#pragma once

#include "cm3.h"

#define HSMCI_CR      (*(volatile unsigned int *)0x40000000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1078433)
#define HSMCI_MR      (*(volatile unsigned int *)0x40000004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1078631)
#define HSMCI_DTOR    (*(volatile unsigned int *)0x40000008)       // [Data Timeout Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1079031)
#define HSMCI_SDCR    (*(volatile unsigned int *)0x4000000C)       // [SD/SDIO Card Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1079279)
#define HSMCI_ARGR    (*(volatile unsigned int *)0x40000010)       // [Argument Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1079539)
#define HSMCI_CMDR    (*(volatile unsigned int *)0x40000014)       // [Command Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1079721)
#define HSMCI_BLKR    (*(volatile unsigned int *)0x40000018)       // [Block Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1080117)
#define HSMCI_CSTOR   (*(volatile unsigned int *)0x4000001C)       // [Completion Signal Timeout Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1080340)
#define HSMCI_RSPR0   (*(const volatile unsigned int *)0x40000024) // [Response Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1080588)
#define HSMCI_RSPR1   (*(const volatile unsigned int *)0x40000024) // [Response Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1080588)
#define HSMCI_RSPR2   (*(const volatile unsigned int *)0x40000024) // [Response Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1080588)
#define HSMCI_RSPR3   (*(const volatile unsigned int *)0x40000024) // [Response Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1080588)
#define HSMCI_RDR     (*(const volatile unsigned int *)0x40000030) // [Receive Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1080770)
#define HSMCI_TDR     (*(volatile unsigned int *)0x40000034)       // [Transmit Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1080952)
#define HSMCI_SR      (*(const volatile unsigned int *)0x40000040) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1081135)
#define HSMCI_IER     (*(volatile unsigned int *)0x40000044)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1081441)
#define HSMCI_IDR     (*(volatile unsigned int *)0x40000048)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1081674)
#define HSMCI_IMR     (*(const volatile unsigned int *)0x4000004C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1081907)
#define HSMCI_DMA     (*(volatile unsigned int *)0x40000050)       // [DMA Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1082142)
#define HSMCI_CFG     (*(volatile unsigned int *)0x40000054)       // [Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1082984)
#define HSMCI_WPMR    (*(volatile unsigned int *)0x400000E4)       // [Write Protection Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083182)
#define HSMCI_WPSR    (*(const volatile unsigned int *)0x400000E8) // [Write Protection Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083394)
#define HSMCI_FIFO0   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO1   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO2   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO3   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO4   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO5   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO6   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO7   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO8   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO9   (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO10  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO11  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO12  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO13  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO14  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO15  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO16  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO17  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO18  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO19  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO20  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO21  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO22  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO23  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO24  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO25  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO26  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO27  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO28  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO29  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO30  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO31  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO32  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO33  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO34  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO35  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO36  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO37  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO38  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO39  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO40  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO41  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO42  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO43  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO44  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO45  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO46  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO47  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO48  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO49  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO50  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO51  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO52  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO53  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO54  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO55  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO56  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO57  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO58  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO59  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO60  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO61  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO62  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO63  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO64  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO65  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO66  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO67  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO68  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO69  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO70  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO71  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO72  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO73  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO74  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO75  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO76  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO77  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO78  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO79  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO80  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO81  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO82  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO83  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO84  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO85  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO86  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO87  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO88  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO89  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO90  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO91  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO92  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO93  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO94  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO95  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO96  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO97  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO98  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO99  (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO100 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO101 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO102 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO103 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO104 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO105 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO106 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO107 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO108 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO109 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO110 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO111 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO112 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO113 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO114 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO115 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO116 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO117 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO118 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO119 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO120 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO121 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO122 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO123 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO124 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO125 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO126 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO127 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO128 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO129 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO130 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO131 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO132 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO133 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO134 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO135 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO136 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO137 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO138 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO139 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO140 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO141 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO142 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO143 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO144 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO145 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO146 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO147 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO148 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO149 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO150 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO151 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO152 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO153 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO154 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO155 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO156 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO157 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO158 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO159 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO160 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO161 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO162 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO163 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO164 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO165 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO166 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO167 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO168 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO169 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO170 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO171 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO172 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO173 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO174 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO175 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO176 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO177 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO178 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO179 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO180 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO181 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO182 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO183 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO184 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO185 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO186 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO187 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO188 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO189 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO190 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO191 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO192 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO193 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO194 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO195 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO196 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO197 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO198 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO199 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO200 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO201 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO202 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO203 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO204 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO205 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO206 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO207 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO208 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO209 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO210 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO211 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO212 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO213 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO214 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO215 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO216 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO217 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO218 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO219 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO220 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO221 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO222 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO223 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO224 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO225 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO226 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO227 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO228 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO229 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO230 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO231 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO232 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO233 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO234 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO235 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO236 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO237 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO238 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO239 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO240 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO241 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO242 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO243 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO244 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO245 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO246 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO247 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO248 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO249 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO250 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO251 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO252 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO253 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO254 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)
#define HSMCI_FIFO255 (*(volatile unsigned int *)0x40000204)       // [FIFO Memory Aperture0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G28.1083610)

#define HSMCI_CR_MCIEN  0x00000001 // Multi-Media Interface Enable
#define HSMCI_CR_MCIDIS 0x00000002 // Multi-Media Interface Disable
#define HSMCI_CR_PWSEN  0x00000004 // Power Save Mode Enable
#define HSMCI_CR_PWSDIS 0x00000008 // Power Save Mode Disable
#define HSMCI_CR_SWRST  0x00000080 // Software Reset

#define HSMCI_MR_CLKDIV(value) (((value) & 0xFF) << 0) // Clock Divider
#define HSMCI_MR_PWSDIV(value) (((value) & 0x7) << 8)  // Power Saving Divider
#define HSMCI_MR_RDPROOF       0x00000800              // Read Proof Enable
#define HSMCI_MR_WRPROOF       0x00001000              // Write Proof Enable
#define HSMCI_MR_FBYTE         0x00002000              // Force Byte Transfer
#define HSMCI_MR_PADV          0x00004000              // Padding Value

#define HSMCI_DTOR_DTOCYC(value)  (((value) & 0xF) << 0) // Data Timeout Cycle Number
#define HSMCI_DTOR_DTOMUL_1       0x00000000             // DTOCYC
#define HSMCI_DTOR_DTOMUL_16      0x00000010             // DTOCYC x 16
#define HSMCI_DTOR_DTOMUL_128     0x00000020             // DTOCYC x 128
#define HSMCI_DTOR_DTOMUL_256     0x00000030             // DTOCYC x 256
#define HSMCI_DTOR_DTOMUL_1024    0x00000040             // DTOCYC x 1024
#define HSMCI_DTOR_DTOMUL_4096    0x00000050             // DTOCYC x 4096
#define HSMCI_DTOR_DTOMUL_65536   0x00000060             // DTOCYC x 65536
#define HSMCI_DTOR_DTOMUL_1048576 0x00000070             // DTOCYC x 1048576

#define HSMCI_SDCR_SDCSEL_SLOTA 0x00000000 // Slot A is selected
#define HSMCI_SDCR_SDCSEL_SLOTB 0x00000001 // SDCARD/SDIO Slot B selected
#define HSMCI_SDCR_SDCSEL_SLOTC 0x00000002 // -
#define HSMCI_SDCR_SDCSEL_SLOTD 0x00000003 // -
#define HSMCI_SDCR_SDCBUS_1     0x00000000 // 1 bit
#define HSMCI_SDCR_SDCBUS_4     0x00000080 // 4 bits
#define HSMCI_SDCR_SDCBUS_8     0x000000C0 // 8 bits

#define HSMCI_ARGR_ARG(value) (((value) & 0xFFFFFFFF) << 0) // Command Argument

#define HSMCI_CMDR_CMDNB(value)     (((value) & 0x3F) << 0) // Command Number
#define HSMCI_CMDR_RSPTYP_NORESP    0x00000000              // No response
#define HSMCI_CMDR_RSPTYP_48_BIT    0x00000040              // 48-bit response
#define HSMCI_CMDR_RSPTYP_136_BIT   0x00000080              // 136-bit response
#define HSMCI_CMDR_RSPTYP_R1B       0x000000C0              // R1b response type
#define HSMCI_CMDR_SPCMD_STD        0x00000000              // Not a special CMD
#define HSMCI_CMDR_SPCMD_INIT       0x00000100              // Initialization CMD: 74 clock cycles for initialization sequence
#define HSMCI_CMDR_SPCMD_SYNC       0x00000200              // Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command
#define HSMCI_CMDR_SPCMD_CE_ATA     0x00000300              // CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line
#define HSMCI_CMDR_SPCMD_IT_CMD     0x00000400              // Interrupt command: Corresponds to the Interrupt Mode (CMD40)
#define HSMCI_CMDR_SPCMD_IT_RESP    0x00000500              // Interrupt response: Corresponds to the Interrupt Mode (CMD40)
#define HSMCI_CMDR_SPCMD_BOR        0x00000600              // Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly
#define HSMCI_CMDR_SPCMD_EBO        0x00000700              // End Boot Operation. This command allows the host processor to terminate the boot operation mode
#define HSMCI_CMDR_OPDCMD_PUSHPULL  0x00000000              // Push pull command
#define HSMCI_CMDR_OPDCMD_OPENDRAIN 0x00000800              // Open drain command
#define HSMCI_CMDR_MAXLAT_5         0x00000000              // 5-cycle max latency
#define HSMCI_CMDR_MAXLAT_64        0x00001000              // 64-cycle max latency
#define HSMCI_CMDR_TRCMD_NO_DATA    0x00000000              // No data transfer
#define HSMCI_CMDR_TRCMD_START_DATA 0x00010000              // Start data transfer
#define HSMCI_CMDR_TRCMD_STOP_DATA  0x00020000              // Stop data transfer
#define HSMCI_CMDR_TRDIR_WRITE      0x00000000              // Write
#define HSMCI_CMDR_TRDIR_READ       0x00040000              // Read
#define HSMCI_CMDR_TRTYP_SINGLE     0x00000000              // MMC/SD Card Single Block
#define HSMCI_CMDR_TRTYP_MULTIPLE   0x00080000              // MMC/SD Card Multiple Block
#define HSMCI_CMDR_TRTYP_STREAM     0x00100000              // MMC Stream
#define HSMCI_CMDR_TRTYP_BYTE       0x00200000              // SDIO Byte
#define HSMCI_CMDR_TRTYP_BLOCK      0x00280000              // SDIO Block
#define HSMCI_CMDR_IOSPCMD_STD      0x00000000              // Not an SDIO Special Command
#define HSMCI_CMDR_IOSPCMD_SUSPEND  0x01000000              // SDIO Suspend Command
#define HSMCI_CMDR_IOSPCMD_RESUME   0x02000000              // SDIO Resume Command
#define HSMCI_CMDR_ATACS_NORMAL     0x00000000              // Normal operation mode
#define HSMCI_CMDR_ATACS_COMPLETION 0x04000000              // This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR)
#define HSMCI_CMDR_BOOT_ACK         0x08000000              // Boot Operation Acknowledge

#define HSMCI_BLKR_BCNT(value)   (((value) & 0xFFFF) << 0)  // MMC/SDIO Block Count - SDIO Byte Count
#define HSMCI_BLKR_BLKLEN(value) (((value) & 0xFFFF) << 16) // Data Block Length

#define HSMCI_CSTOR_CSTOCYC(value)  (((value) & 0xF) << 0) // Completion Signal Timeout Cycle Number
#define HSMCI_CSTOR_CSTOMUL_1       0x00000000             // CSTOCYC x 1
#define HSMCI_CSTOR_CSTOMUL_16      0x00000010             // CSTOCYC x 16
#define HSMCI_CSTOR_CSTOMUL_128     0x00000020             // CSTOCYC x 128
#define HSMCI_CSTOR_CSTOMUL_256     0x00000030             // CSTOCYC x 256
#define HSMCI_CSTOR_CSTOMUL_1024    0x00000040             // CSTOCYC x 1024
#define HSMCI_CSTOR_CSTOMUL_4096    0x00000050             // CSTOCYC x 4096
#define HSMCI_CSTOR_CSTOMUL_65536   0x00000060             // CSTOCYC x 65536
#define HSMCI_CSTOR_CSTOMUL_1048576 0x00000070             // CSTOCYC x 1048576

#define HSMCI_RSPR_RSP(value) (((value) & 0xFFFFFFFF) << 0) // Response

#define HSMCI_RDR_DATA(value) (((value) & 0xFFFFFFFF) << 0) // Data to Read

#define HSMCI_TDR_DATA(value) (((value) & 0xFFFFFFFF) << 0) // Data to Write

#define HSMCI_SR_CMDRDY          0x00000001 // Command Ready
#define HSMCI_SR_RXRDY           0x00000002 // Receiver Ready
#define HSMCI_SR_TXRDY           0x00000004 // Transmit Ready
#define HSMCI_SR_BLKE            0x00000008 // Data Block Ended
#define HSMCI_SR_DTIP            0x00000010 // Data Transfer in Progress
#define HSMCI_SR_NOTBUSY         0x00000020 // HSMCI Not Busy
#define HSMCI_SR_SDIOIRQforSlotA 0x00000100 //
#define HSMCI_SR_SDIOIRQforSlotB 0x00000200 //
#define HSMCI_SR_SDIOWAIT        0x00001000 // SDIO Read Wait Operation Status
#define HSMCI_SR_CSRCV           0x00002000 // CE-ATA Completion Signal Received
#define HSMCI_SR_RINDE           0x00010000 // Response Index Error
#define HSMCI_SR_RDIRE           0x00020000 // Response Direction Error
#define HSMCI_SR_RCRCE           0x00040000 // Response CRC Error
#define HSMCI_SR_RENDE           0x00080000 // Response End Bit Error
#define HSMCI_SR_RTOE            0x00100000 // Response Time-out Error
#define HSMCI_SR_DCRCE           0x00200000 // Data CRC Error
#define HSMCI_SR_DTOE            0x00400000 // Data Time-out Error
#define HSMCI_SR_CSTOE           0x00800000 // Completion Signal Time-out Error
#define HSMCI_SR_BLKOVRE         0x01000000 // DMA Block Overrun Error
#define HSMCI_SR_DMADONE         0x02000000 // DMA Transfer done
#define HSMCI_SR_FIFOEMPTY       0x04000000 // FIFO empty flag
#define HSMCI_SR_XFRDONE         0x08000000 // Transfer Done flag
#define HSMCI_SR_ACKRCV          0x10000000 // Boot Operation Acknowledge Received
#define HSMCI_SR_ACKRCVE         0x20000000 // Boot Operation Acknowledge Error
#define HSMCI_SR_OVRE            0x40000000 // Overrun
#define HSMCI_SR_UNRE            0x80000000 // Underrun

#define HSMCI_IER_CMDRDY          0x00000001 // Command Ready Interrupt Enable
#define HSMCI_IER_RXRDY           0x00000002 // Receiver Ready Interrupt Enable
#define HSMCI_IER_TXRDY           0x00000004 // Transmit Ready Interrupt Enable
#define HSMCI_IER_BLKE            0x00000008 // Data Block Ended Interrupt Enable
#define HSMCI_IER_DTIP            0x00000010 // Data Transfer in Progress Interrupt Enable
#define HSMCI_IER_NOTBUSY         0x00000020 // Data Not Busy Interrupt Enable
#define HSMCI_IER_SDIOIRQforSlotA 0x00000100 //
#define HSMCI_IER_SDIOIRQforSlotB 0x00000200 //
#define HSMCI_IER_SDIOWAIT        0x00001000 // SDIO Read Wait Operation Status Interrupt Enable
#define HSMCI_IER_CSRCV           0x00002000 // Completion Signal Received Interrupt Enable
#define HSMCI_IER_RINDE           0x00010000 // Response Index Error Interrupt Enable
#define HSMCI_IER_RDIRE           0x00020000 // Response Direction Error Interrupt Enable
#define HSMCI_IER_RCRCE           0x00040000 // Response CRC Error Interrupt Enable
#define HSMCI_IER_RENDE           0x00080000 // Response End Bit Error Interrupt Enable
#define HSMCI_IER_RTOE            0x00100000 // Response Time-out Error Interrupt Enable
#define HSMCI_IER_DCRCE           0x00200000 // Data CRC Error Interrupt Enable
#define HSMCI_IER_DTOE            0x00400000 // Data Time-out Error Interrupt Enable
#define HSMCI_IER_CSTOE           0x00800000 // Completion Signal Timeout Error Interrupt Enable
#define HSMCI_IER_BLKOVRE         0x01000000 // DMA Block Overrun Error Interrupt Enable
#define HSMCI_IER_DMADONE         0x02000000 // DMA Transfer completed Interrupt Enable
#define HSMCI_IER_FIFOEMPTY       0x04000000 // FIFO empty Interrupt enable
#define HSMCI_IER_XFRDONE         0x08000000 // Transfer Done Interrupt enable
#define HSMCI_IER_ACKRCV          0x10000000 // Boot Acknowledge Interrupt Enable
#define HSMCI_IER_ACKRCVE         0x20000000 // Boot Acknowledge Error Interrupt Enable
#define HSMCI_IER_OVRE            0x40000000 // Overrun Interrupt Enable
#define HSMCI_IER_UNRE            0x80000000 // Underrun Interrupt Enable

#define HSMCI_IDR_CMDRDY          0x00000001 // Command Ready Interrupt Disable
#define HSMCI_IDR_RXRDY           0x00000002 // Receiver Ready Interrupt Disable
#define HSMCI_IDR_TXRDY           0x00000004 // Transmit Ready Interrupt Disable
#define HSMCI_IDR_BLKE            0x00000008 // Data Block Ended Interrupt Disable
#define HSMCI_IDR_DTIP            0x00000010 // Data Transfer in Progress Interrupt Disable
#define HSMCI_IDR_NOTBUSY         0x00000020 // Data Not Busy Interrupt Disable
#define HSMCI_IDR_SDIOIRQforSlotA 0x00000100 //
#define HSMCI_IDR_SDIOIRQforSlotB 0x00000200 //
#define HSMCI_IDR_SDIOWAIT        0x00001000 // SDIO Read Wait Operation Status Interrupt Disable
#define HSMCI_IDR_CSRCV           0x00002000 // Completion Signal received interrupt Disable
#define HSMCI_IDR_RINDE           0x00010000 // Response Index Error Interrupt Disable
#define HSMCI_IDR_RDIRE           0x00020000 // Response Direction Error Interrupt Disable
#define HSMCI_IDR_RCRCE           0x00040000 // Response CRC Error Interrupt Disable
#define HSMCI_IDR_RENDE           0x00080000 // Response End Bit Error Interrupt Disable
#define HSMCI_IDR_RTOE            0x00100000 // Response Time-out Error Interrupt Disable
#define HSMCI_IDR_DCRCE           0x00200000 // Data CRC Error Interrupt Disable
#define HSMCI_IDR_DTOE            0x00400000 // Data Time-out Error Interrupt Disable
#define HSMCI_IDR_CSTOE           0x00800000 // Completion Signal Time out Error Interrupt Disable
#define HSMCI_IDR_BLKOVRE         0x01000000 // DMA Block Overrun Error Interrupt Disable
#define HSMCI_IDR_DMADONE         0x02000000 // DMA Transfer completed Interrupt Disable
#define HSMCI_IDR_FIFOEMPTY       0x04000000 // FIFO empty Interrupt Disable
#define HSMCI_IDR_XFRDONE         0x08000000 // Transfer Done Interrupt Disable
#define HSMCI_IDR_ACKRCV          0x10000000 // Boot Acknowledge Interrupt Disable
#define HSMCI_IDR_ACKRCVE         0x20000000 // Boot Acknowledge Error Interrupt Disable
#define HSMCI_IDR_OVRE            0x40000000 // Overrun Interrupt Disable
#define HSMCI_IDR_UNRE            0x80000000 // Underrun Interrupt Disable

#define HSMCI_IMR_CMDRDY          0x00000001 // Command Ready Interrupt Mask
#define HSMCI_IMR_RXRDY           0x00000002 // Receiver Ready Interrupt Mask
#define HSMCI_IMR_TXRDY           0x00000004 // Transmit Ready Interrupt Mask
#define HSMCI_IMR_BLKE            0x00000008 // Data Block Ended Interrupt Mask
#define HSMCI_IMR_DTIP            0x00000010 // Data Transfer in Progress Interrupt Mask
#define HSMCI_IMR_NOTBUSY         0x00000020 // Data Not Busy Interrupt Mask
#define HSMCI_IMR_SDIOIRQforSlotA 0x00000100 //
#define HSMCI_IMR_SDIOIRQforSlotB 0x00000200 //
#define HSMCI_IMR_SDIOWAIT        0x00001000 // SDIO Read Wait Operation Status Interrupt Mask
#define HSMCI_IMR_CSRCV           0x00002000 // Completion Signal Received Interrupt Mask
#define HSMCI_IMR_RINDE           0x00010000 // Response Index Error Interrupt Mask
#define HSMCI_IMR_RDIRE           0x00020000 // Response Direction Error Interrupt Mask
#define HSMCI_IMR_RCRCE           0x00040000 // Response CRC Error Interrupt Mask
#define HSMCI_IMR_RENDE           0x00080000 // Response End Bit Error Interrupt Mask
#define HSMCI_IMR_RTOE            0x00100000 // Response Time-out Error Interrupt Mask
#define HSMCI_IMR_DCRCE           0x00200000 // Data CRC Error Interrupt Mask
#define HSMCI_IMR_DTOE            0x00400000 // Data Time-out Error Interrupt Mask
#define HSMCI_IMR_CSTOE           0x00800000 // Completion Signal Time-out Error Interrupt Mask
#define HSMCI_IMR_BLKOVRE         0x01000000 // DMA Block Overrun Error Interrupt Mask
#define HSMCI_IMR_DMADONE         0x02000000 // DMA Transfer Completed Interrupt Mask
#define HSMCI_IMR_FIFOEMPTY       0x04000000 // FIFO Empty Interrupt Mask
#define HSMCI_IMR_XFRDONE         0x08000000 // Transfer Done Interrupt Mask
#define HSMCI_IMR_ACKRCV          0x10000000 // Boot Operation Acknowledge Received Interrupt Mask
#define HSMCI_IMR_ACKRCVE         0x20000000 // Boot Operation Acknowledge Error Interrupt Mask
#define HSMCI_IMR_OVRE            0x40000000 // Overrun Interrupt Mask
#define HSMCI_IMR_UNRE            0x80000000 // Underrun Interrupt Mask

#define HSMCI_DMA_OFFSET(value) (((value) & 0x3) << 0) // DMA Write Buffer Offset
#define HSMCI_DMA_CHKSIZE_1     0x00000000             // 1 data available
#define HSMCI_DMA_CHKSIZE_4     0x00000010             // 4 data available
#define HSMCI_DMA_DMAEN         0x00000100             // DMA Hardware Handshaking Enable
#define HSMCI_DMA_ROPT          0x00001000             // Read Optimization with padding

#define HSMCI_CFG_FIFOMODE 0x00000001 // HSMCI Internal FIFO control mode
#define HSMCI_CFG_FERRCTRL 0x00000010 // Flow Error flag reset control mode
#define HSMCI_CFG_HSMODE   0x00000100 // High Speed Mode
#define HSMCI_CFG_LSYNC    0x00001000 // Synchronize on the last block

#define HSMCI_WPMR_WPEN         0x00000001 // Write Protect Enable
#define HSMCI_WPMR_WPKEY_PASSWD 0x4D434900 // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0

#define HSMCI_WPSR_WPVS          0x00000001                // Write Protection Violation Status
#define HSMCI_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protection Violation Source

#define HSMCI_FIFO_DATA(value) (((value) & 0xFFFFFFFF) << 0) // Data to Read or Data to Write

#define SSC_CR   (*(volatile unsigned int *)0x40004000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1108750)
#define SSC_CMR  (*(volatile unsigned int *)0x40004004)       // [Clock Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1108946)
#define SSC_RCMR (*(volatile unsigned int *)0x40004010)       // [Receive Clock Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1109130)
#define SSC_RFMR (*(volatile unsigned int *)0x40004014)       // [Receive Frame Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1109448)
#define SSC_TCMR (*(volatile unsigned int *)0x40004018)       // [Transmit Clock Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1109709)
#define SSC_TFMR (*(volatile unsigned int *)0x4000401C)       // [Transmit Frame Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1110021)
#define SSC_RHR  (*(const volatile unsigned int *)0x40004020) // [Receive Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1110284)
#define SSC_THR  (*(volatile unsigned int *)0x40004024)       // [Transmit Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1110467)
#define SSC_RSHR (*(const volatile unsigned int *)0x40004030) // [Receive Sync. Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1110650)
#define SSC_TSHR (*(volatile unsigned int *)0x40004034)       // [Transmit Sync. Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1110832)
#define SSC_RC0R (*(volatile unsigned int *)0x40004038)       // [Receive Compare 0 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1111014)
#define SSC_RC1R (*(volatile unsigned int *)0x4000403C)       // [Receive Compare 1 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1111196)
#define SSC_SR   (*(const volatile unsigned int *)0x40004040) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1111378)
#define SSC_IER  (*(volatile unsigned int *)0x40004044)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1111603)
#define SSC_IDR  (*(volatile unsigned int *)0x40004048)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1111822)
#define SSC_IMR  (*(const volatile unsigned int *)0x4000404C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1112041)
#define SSC_WPMR (*(volatile unsigned int *)0x400040E4)       // [Write Protect Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1148244)
#define SSC_WPSR (*(const volatile unsigned int *)0x400040E8) // [Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G21.1148486)

#define SSC_CR_RXEN  0x00000001 // Receive Enable
#define SSC_CR_RXDIS 0x00000002 // Receive Disable
#define SSC_CR_TXEN  0x00000100 // Transmit Enable
#define SSC_CR_TXDIS 0x00000200 // Transmit Disable
#define SSC_CR_SWRST 0x00008000 // Software Reset

#define SSC_CMR_DIV(value) (((value) & 0xFFF) << 0) // Clock Divider

#define SSC_RCMR_CKS_MCK          0x00000000               // Divided Clock
#define SSC_RCMR_CKS_TK           0x00000001               // TK Clock signal
#define SSC_RCMR_CKS_RK           0x00000002               // RK pin
#define SSC_RCMR_CKO_NONE         0x00000000               // None, RK pin is an input
#define SSC_RCMR_CKO_CONTINUOUS   0x00000004               // Continuous Receive Clock, RK pin is an output
#define SSC_RCMR_CKO_TRANSFER     0x00000008               // Receive Clock only during data transfers, RK pin is an output
#define SSC_RCMR_CKI              0x00000020               // Receive Clock Inversion
#define SSC_RCMR_CKG_CONTINUOUS   0x00000000               // None
#define SSC_RCMR_CKG_EN_RF_LOW    0x00000040               // Receive Clock enabled only if RF Low
#define SSC_RCMR_CKG_EN_RF_HIGH   0x00000080               // Receive Clock enabled only if RF High
#define SSC_RCMR_START_CONTINUOUS 0x00000000               // Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data
#define SSC_RCMR_START_TRANSMIT   0x00000100               // Transmit start
#define SSC_RCMR_START_RF_LOW     0x00000200               // Detection of a low level on RF signal
#define SSC_RCMR_START_RF_HIGH    0x00000300               // Detection of a high level on RF signal
#define SSC_RCMR_START_RF_FALLING 0x00000400               // Detection of a falling edge on RF signal
#define SSC_RCMR_START_RF_RISING  0x00000500               // Detection of a rising edge on RF signal
#define SSC_RCMR_START_RF_LEVEL   0x00000600               // Detection of any level change on RF signal
#define SSC_RCMR_START_RF_EDGE    0x00000700               // Detection of any edge on RF signal
#define SSC_RCMR_START_CMP_0      0x00000800               // Compare 0
#define SSC_RCMR_STOP             0x00001000               // Receive Stop Selection
#define SSC_RCMR_STTDLY(value)    (((value) & 0xFF) << 16) // Receive Start Delay
#define SSC_RCMR_PERIOD(value)    (((value) & 0xFF) << 24) // Receive Period Divider Selection

#define SSC_RFMR_DATLEN(value)    (((value) & 0x1F) << 0) // Data Length
#define SSC_RFMR_LOOP             0x00000020              // Loop Mode
#define SSC_RFMR_MSBF             0x00000080              // Most Significant Bit First
#define SSC_RFMR_DATNB(value)     (((value) & 0xF) << 8)  // Data Number per Frame
#define SSC_RFMR_FSLEN(value)     (((value) & 0xF) << 16) // Receive Frame Sync Length
#define SSC_RFMR_FSOS_NONE        0x00000000              // None, RF pin is an input
#define SSC_RFMR_FSOS_NEGATIVE    0x00100000              // Negative Pulse, RF pin is an output
#define SSC_RFMR_FSOS_POSITIVE    0x00200000              // Positive Pulse, RF pin is an output
#define SSC_RFMR_FSOS_LOW         0x00300000              // Driven Low during data transfer, RF pin is an output
#define SSC_RFMR_FSOS_HIGH        0x00400000              // Driven High during data transfer, RF pin is an output
#define SSC_RFMR_FSOS_TOGGLING    0x00500000              // Toggling at each start of data transfer, RF pin is an output
#define SSC_RFMR_FSEDGE_POSITIVE  0x00000000              // Positive Edge Detection
#define SSC_RFMR_FSEDGE_NEGATIVE  0x01000000              // Negative Edge Detection
#define SSC_RFMR_FSLEN_EXT(value) (((value) & 0xF) << 28) // FSLEN Field Extension

#define SSC_TCMR_CKS_MCK          0x00000000               // Divided Clock
#define SSC_TCMR_CKS_RK           0x00000001               // RK Clock signal
#define SSC_TCMR_CKS_TK           0x00000002               // TK pin
#define SSC_TCMR_CKO_NONE         0x00000000               // None, TK pin is an input
#define SSC_TCMR_CKO_CONTINUOUS   0x00000004               // Continuous Transmit Clock, TK pin is an output
#define SSC_TCMR_CKO_TRANSFER     0x00000008               // Transmit Clock only during data transfers, TK pin is an output
#define SSC_TCMR_CKI              0x00000020               // Transmit Clock Inversion
#define SSC_TCMR_CKG_CONTINUOUS   0x00000000               // None
#define SSC_TCMR_CKG_EN_TF_LOW    0x00000040               // Transmit Clock enabled only if TF Low
#define SSC_TCMR_CKG_EN_TF_HIGH   0x00000080               // Transmit Clock enabled only if TF High
#define SSC_TCMR_START_CONTINUOUS 0x00000000               // Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data
#define SSC_TCMR_START_RECEIVE    0x00000100               // Receive start
#define SSC_TCMR_START_TF_LOW     0x00000200               // Detection of a low level on TF signal
#define SSC_TCMR_START_TF_HIGH    0x00000300               // Detection of a high level on TF signal
#define SSC_TCMR_START_TF_FALLING 0x00000400               // Detection of a falling edge on TF signal
#define SSC_TCMR_START_TF_RISING  0x00000500               // Detection of a rising edge on TF signal
#define SSC_TCMR_START_TF_LEVEL   0x00000600               // Detection of any level change on TF signal
#define SSC_TCMR_START_TF_EDGE    0x00000700               // Detection of any edge on TF signal
#define SSC_TCMR_STTDLY(value)    (((value) & 0xFF) << 16) // Transmit Start Delay
#define SSC_TCMR_PERIOD(value)    (((value) & 0xFF) << 24) // Transmit Period Divider Selection

#define SSC_TFMR_DATLEN(value)    (((value) & 0x1F) << 0) // Data Length
#define SSC_TFMR_DATDEF           0x00000020              // Data Default Value
#define SSC_TFMR_MSBF             0x00000080              // Most Significant Bit First
#define SSC_TFMR_DATNB(value)     (((value) & 0xF) << 8)  // Data Number per frame
#define SSC_TFMR_FSLEN(value)     (((value) & 0xF) << 16) // Transmit Frame Sync Length
#define SSC_TFMR_FSOS_NONE        0x00000000              // None, RF pin is an input
#define SSC_TFMR_FSOS_NEGATIVE    0x00100000              // Negative Pulse, RF pin is an output
#define SSC_TFMR_FSOS_POSITIVE    0x00200000              // Positive Pulse, RF pin is an output
#define SSC_TFMR_FSOS_LOW         0x00300000              // Driven Low during data transfer
#define SSC_TFMR_FSOS_HIGH        0x00400000              // Driven High during data transfer
#define SSC_TFMR_FSOS_TOGGLING    0x00500000              // Toggling at each start of data transfer
#define SSC_TFMR_FSDEN            0x00800000              // Frame Sync Data Enable
#define SSC_TFMR_FSEDGE_POSITIVE  0x00000000              // Positive Edge Detection
#define SSC_TFMR_FSEDGE_NEGATIVE  0x01000000              // Negative Edge Detection
#define SSC_TFMR_FSLEN_EXT(value) (((value) & 0xF) << 28) // FSLEN Field Extension

#define SSC_RHR_RDAT(value) (((value) & 0xFFFFFFFF) << 0) // Receive Data

#define SSC_THR_TDAT(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Data

#define SSC_RSHR_RSDAT(value) (((value) & 0xFFFF) << 0) // Receive Synchronization Data

#define SSC_TSHR_TSDAT(value) (((value) & 0xFFFF) << 0) // Transmit Synchronization Data

#define SSC_RC0R_CP0(value) (((value) & 0xFFFF) << 0) // Receive Compare Data 0

#define SSC_RC1R_CP1(value) (((value) & 0xFFFF) << 0) // Receive Compare Data 1

#define SSC_SR_TXRDY   0x00000001 // Transmit Ready
#define SSC_SR_TXEMPTY 0x00000002 // Transmit Empty
#define SSC_SR_RXRDY   0x00000010 // Receive Ready
#define SSC_SR_OVRUN   0x00000020 // Receive Overrun
#define SSC_SR_CP0     0x00000100 // Compare 0
#define SSC_SR_CP1     0x00000200 // Compare 1
#define SSC_SR_TXSYN   0x00000400 // Transmit Sync
#define SSC_SR_RXSYN   0x00000800 // Receive Sync
#define SSC_SR_TXEN    0x00010000 // Transmit Enable
#define SSC_SR_RXEN    0x00020000 // Receive Enable

#define SSC_IER_TXRDY   0x00000001 // Transmit Ready Interrupt Enable
#define SSC_IER_TXEMPTY 0x00000002 // Transmit Empty Interrupt Enable
#define SSC_IER_RXRDY   0x00000010 // Receive Ready Interrupt Enable
#define SSC_IER_OVRUN   0x00000020 // Receive Overrun Interrupt Enable
#define SSC_IER_CP0     0x00000100 // Compare 0 Interrupt Enable
#define SSC_IER_CP1     0x00000200 // Compare 1 Interrupt Enable
#define SSC_IER_TXSYN   0x00000400 // Tx Sync Interrupt Enable
#define SSC_IER_RXSYN   0x00000800 // Rx Sync Interrupt Enable

#define SSC_IDR_TXRDY   0x00000001 // Transmit Ready Interrupt Disable
#define SSC_IDR_TXEMPTY 0x00000002 // Transmit Empty Interrupt Disable
#define SSC_IDR_RXRDY   0x00000010 // Receive Ready Interrupt Disable
#define SSC_IDR_OVRUN   0x00000020 // Receive Overrun Interrupt Disable
#define SSC_IDR_CP0     0x00000100 // Compare 0 Interrupt Disable
#define SSC_IDR_CP1     0x00000200 // Compare 1 Interrupt Disable
#define SSC_IDR_TXSYN   0x00000400 // Tx Sync Interrupt Enable
#define SSC_IDR_RXSYN   0x00000800 // Rx Sync Interrupt Enable

#define SSC_IMR_TXRDY   0x00000001 // Transmit Ready Interrupt Mask
#define SSC_IMR_TXEMPTY 0x00000002 // Transmit Empty Interrupt Mask
#define SSC_IMR_RXRDY   0x00000010 // Receive Ready Interrupt Mask
#define SSC_IMR_OVRUN   0x00000020 // Receive Overrun Interrupt Mask
#define SSC_IMR_CP0     0x00000100 // Compare 0 Interrupt Mask
#define SSC_IMR_CP1     0x00000200 // Compare 1 Interrupt Mask
#define SSC_IMR_TXSYN   0x00000400 // Tx Sync Interrupt Mask
#define SSC_IMR_RXSYN   0x00000800 // Rx Sync Interrupt Mask

#define SSC_WPMR_WPEN         0x00000001 // Write Protect Enable
#define SSC_WPMR_WPKEY_PASSWD 0x53534300 // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0

#define SPI0_CR   (*(volatile unsigned int *)0x40008000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1136010)
#define SPI0_MR   (*(volatile unsigned int *)0x40008004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1136214)
#define SPI0_RDR  (*(const volatile unsigned int *)0x40008008) // [Receive Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1136463)
#define SPI0_TDR  (*(volatile unsigned int *)0x4000800C)       // [Transmit Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1136649)
#define SPI0_SR   (*(const volatile unsigned int *)0x40008010) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1136850)
#define SPI0_IER  (*(volatile unsigned int *)0x40008014)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1137120)
#define SPI0_IDR  (*(volatile unsigned int *)0x40008018)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1137315)
#define SPI0_IMR  (*(const volatile unsigned int *)0x4000801C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1137510)
#define SPI0_CSR0 (*(volatile unsigned int *)0x40008034)       // [Chip Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1137706)
#define SPI0_CSR1 (*(volatile unsigned int *)0x40008034)       // [Chip Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1137706)
#define SPI0_CSR2 (*(volatile unsigned int *)0x40008034)       // [Chip Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1137706)
#define SPI0_CSR3 (*(volatile unsigned int *)0x40008034)       // [Chip Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1137706)
#define SPI0_WPMR (*(volatile unsigned int *)0x400080E4)       // [Write Protection Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1138052)
#define SPI0_WPSR (*(const volatile unsigned int *)0x400080E8) // [Write Protection Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G23.1165614)

#define SPI0_CR_SPIEN    0x00000001 // SPI Enable
#define SPI0_CR_SPIDIS   0x00000002 // SPI Disable
#define SPI0_CR_SWRST    0x00000080 // SPI Software Reset
#define SPI0_CR_LASTXFER 0x01000000 // Last Transfer

#define SPI0_MR_MSTR          0x00000001               // Master/Slave Mode
#define SPI0_MR_PS            0x00000002               // Peripheral Select
#define SPI0_MR_PCSDEC        0x00000004               // Chip Select Decode
#define SPI0_MR_MODFDIS       0x00000010               // Mode Fault Detection
#define SPI0_MR_WDRBT         0x00000020               // Wait Data Read Before Transfer
#define SPI0_MR_LLB           0x00000080               // Local Loopback Enable
#define SPI0_MR_PCS(value)    (((value) & 0xF) << 16)  // Peripheral Chip Select
#define SPI0_MR_DLYBCS(value) (((value) & 0xFF) << 24) // Delay Between Chip Selects

#define SPI0_RDR_RD(value)  (((value) & 0xFFFF) << 0) // Receive Data
#define SPI0_RDR_PCS(value) (((value) & 0xF) << 16)   // Peripheral Chip Select

#define SPI0_TDR_TD(value)  (((value) & 0xFFFF) << 0) // Transmit Data
#define SPI0_TDR_PCS(value) (((value) & 0xF) << 16)   // Peripheral Chip Select
#define SPI0_TDR_LASTXFER   0x01000000                // Last Transfer

#define SPI0_SR_RDRF    0x00000001 // Receive Data Register Full
#define SPI0_SR_TDRE    0x00000002 // Transmit Data Register Empty
#define SPI0_SR_MODF    0x00000004 // Mode Fault Error
#define SPI0_SR_OVRES   0x00000008 // Overrun Error Status
#define SPI0_SR_NSSR    0x00000100 // NSS Rising
#define SPI0_SR_TXEMPTY 0x00000200 // Transmission Registers Empty
#define SPI0_SR_UNDES   0x00000400 // Underrun Error Status (Slave Mode Only)
#define SPI0_SR_SPIENS  0x00010000 // SPI Enable Status

#define SPI0_IER_RDRF    0x00000001 // Receive Data Register Full Interrupt Enable
#define SPI0_IER_TDRE    0x00000002 // SPI Transmit Data Register Empty Interrupt Enable
#define SPI0_IER_MODF    0x00000004 // Mode Fault Error Interrupt Enable
#define SPI0_IER_OVRES   0x00000008 // Overrun Error Interrupt Enable
#define SPI0_IER_NSSR    0x00000100 // NSS Rising Interrupt Enable
#define SPI0_IER_TXEMPTY 0x00000200 // Transmission Registers Empty Enable
#define SPI0_IER_UNDES   0x00000400 // Underrun Error Interrupt Enable

#define SPI0_IDR_RDRF    0x00000001 // Receive Data Register Full Interrupt Disable
#define SPI0_IDR_TDRE    0x00000002 // SPI Transmit Data Register Empty Interrupt Disable
#define SPI0_IDR_MODF    0x00000004 // Mode Fault Error Interrupt Disable
#define SPI0_IDR_OVRES   0x00000008 // Overrun Error Interrupt Disable
#define SPI0_IDR_NSSR    0x00000100 // NSS Rising Interrupt Disable
#define SPI0_IDR_TXEMPTY 0x00000200 // Transmission Registers Empty Disable
#define SPI0_IDR_UNDES   0x00000400 // Underrun Error Interrupt Disable

#define SPI0_IMR_RDRF    0x00000001 // Receive Data Register Full Interrupt Mask
#define SPI0_IMR_TDRE    0x00000002 // SPI Transmit Data Register Empty Interrupt Mask
#define SPI0_IMR_MODF    0x00000004 // Mode Fault Error Interrupt Mask
#define SPI0_IMR_OVRES   0x00000008 // Overrun Error Interrupt Mask
#define SPI0_IMR_NSSR    0x00000100 // NSS Rising Interrupt Mask
#define SPI0_IMR_TXEMPTY 0x00000200 // Transmission Registers Empty Mask
#define SPI0_IMR_UNDES   0x00000400 // Underrun Error Interrupt Mask

#define SPI0_CSR_CPOL          0x00000001               // Clock Polarity
#define SPI0_CSR_NCPHA         0x00000002               // Clock Phase
#define SPI0_CSR_CSNAAT        0x00000004               // Chip Select Not Active After Transfer (Ignored if CSAAT = 1)
#define SPI0_CSR_CSAAT         0x00000008               // Chip Select Active After Transfer
#define SPI0_CSR_BITS_8_BIT    0x00000000               // 8 bits for transfer
#define SPI0_CSR_BITS_9_BIT    0x00000010               // 9 bits for transfer
#define SPI0_CSR_BITS_10_BIT   0x00000020               // 10 bits for transfer
#define SPI0_CSR_BITS_11_BIT   0x00000030               // 11 bits for transfer
#define SPI0_CSR_BITS_12_BIT   0x00000040               // 12 bits for transfer
#define SPI0_CSR_BITS_13_BIT   0x00000050               // 13 bits for transfer
#define SPI0_CSR_BITS_14_BIT   0x00000060               // 14 bits for transfer
#define SPI0_CSR_BITS_15_BIT   0x00000070               // 15 bits for transfer
#define SPI0_CSR_BITS_16_BIT   0x00000080               // 16 bits for transfer
#define SPI0_CSR_SCBR(value)   (((value) & 0xFF) << 8)  // Serial Clock Baud Rate
#define SPI0_CSR_DLYBS(value)  (((value) & 0xFF) << 16) // Delay Before SPCK
#define SPI0_CSR_DLYBCT(value) (((value) & 0xFF) << 24) // Delay Between Consecutive Transfers

#define SPI0_WPMR_WPEN         0x00000001 // Write Protect Enable
#define SPI0_WPMR_WPKEY_PASSWD 0x53504900 // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0

#define SPI0_WPSR_WPVS          0x00000001              // Write Protection Violation Status
#define SPI0_WPSR_WPVSRC(value) (((value) & 0xFF) << 8) // Write Protection Violation Source

#define TC0_CCR0  (*(volatile unsigned int *)0x40080000)       // [Channel Control Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC0_CMR0  (*(volatile unsigned int *)0x40080004)       // [Channel Mode Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC0_SMMR0 (*(volatile unsigned int *)0x40080008)       // [Stepper Motor Mode Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC0_CV0   (*(const volatile unsigned int *)0x40080010) // [Counter Value (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC0_RA0   (*(volatile unsigned int *)0x40080014)       // [Register A (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC0_RB0   (*(volatile unsigned int *)0x40080018)       // [Register B (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC0_RC0   (*(volatile unsigned int *)0x4008001C)       // [Register C (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC0_SR0   (*(const volatile unsigned int *)0x40080020) // [Status Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC0_IER0  (*(volatile unsigned int *)0x40080024)       // [Interrupt Enable Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC0_IDR0  (*(volatile unsigned int *)0x40080028)       // [Interrupt Disable Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC0_IMR0  (*(const volatile unsigned int *)0x4008002C) // [Interrupt Mask Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC0_CCR1  (*(volatile unsigned int *)0x40080040)       // [Channel Control Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC0_CMR1  (*(volatile unsigned int *)0x40080044)       // [Channel Mode Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC0_SMMR1 (*(volatile unsigned int *)0x40080048)       // [Stepper Motor Mode Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC0_CV1   (*(const volatile unsigned int *)0x40080050) // [Counter Value (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC0_RA1   (*(volatile unsigned int *)0x40080054)       // [Register A (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC0_RB1   (*(volatile unsigned int *)0x40080058)       // [Register B (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC0_RC1   (*(volatile unsigned int *)0x4008005C)       // [Register C (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC0_SR1   (*(const volatile unsigned int *)0x40080060) // [Status Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC0_IER1  (*(volatile unsigned int *)0x40080064)       // [Interrupt Enable Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC0_IDR1  (*(volatile unsigned int *)0x40080068)       // [Interrupt Disable Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC0_IMR1  (*(const volatile unsigned int *)0x4008006C) // [Interrupt Mask Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC0_CCR2  (*(volatile unsigned int *)0x40080080)       // [Channel Control Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC0_CMR2  (*(volatile unsigned int *)0x40080084)       // [Channel Mode Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC0_SMMR2 (*(volatile unsigned int *)0x40080088)       // [Stepper Motor Mode Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC0_CV2   (*(const volatile unsigned int *)0x40080090) // [Counter Value (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC0_RA2   (*(volatile unsigned int *)0x40080094)       // [Register A (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC0_RB2   (*(volatile unsigned int *)0x40080098)       // [Register B (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC0_RC2   (*(volatile unsigned int *)0x4008009C)       // [Register C (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC0_SR2   (*(const volatile unsigned int *)0x400800A0) // [Status Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC0_IER2  (*(volatile unsigned int *)0x400800A4)       // [Interrupt Enable Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC0_IDR2  (*(volatile unsigned int *)0x400800A8)       // [Interrupt Disable Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC0_IMR2  (*(const volatile unsigned int *)0x400800AC) // [Interrupt Mask Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC0_BCR   (*(volatile unsigned int *)0x400800C0)       // [Block Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1159522)
#define TC0_BMR   (*(volatile unsigned int *)0x400800C4)       // [Block Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1157922)
#define TC0_QIER  (*(volatile unsigned int *)0x400800C8)       // [QDEC Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158557)
#define TC0_QIDR  (*(volatile unsigned int *)0x400800CC)       // [QDEC Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158748)
#define TC0_QIMR  (*(const volatile unsigned int *)0x400800D0) // [QDEC Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158939)
#define TC0_QISR  (*(const volatile unsigned int *)0x400800D4) // [QDEC Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1159130)
#define TC0_FMR   (*(volatile unsigned int *)0x400800D8)       // [Fault Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1277700)
#define TC0_WPMR  (*(volatile unsigned int *)0x400800E4)       // [Write Protection Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1277892)

#define TC0_CCR0_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC0_CCR0_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC0_CCR0_SWTRG  0x00000004 // Software Trigger Command

#define TC0_CMR0_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC0_CMR0_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC0_CMR0_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC0_CMR0_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC0_CMR0_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC0_CMR0_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC0_CMR0_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC0_CMR0_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC0_CMR0_CLKI                0x00000008 // Clock Invert
#define TC0_CMR0_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC0_CMR0_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC0_CMR0_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC0_CMR0_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC0_CMR0_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC0_CMR0_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC0_CMR0_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC0_CMR0_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC0_CMR0_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC0_CMR0_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC0_CMR0_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC0_CMR0_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC0_CMR0_WAVE                0x00008000 // Waveform Mode
#define TC0_CMR0_LDRA_NONE           0x00000000 // None
#define TC0_CMR0_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC0_CMR0_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC0_CMR0_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC0_CMR0_LDRB_NONE           0x00000000 // None
#define TC0_CMR0_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC0_CMR0_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC0_CMR0_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC0_CMR0_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC0_CMR0_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC0_CMR0_EEVTEDG_NONE     0x00000000 // None
#define TC0_CMR0_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC0_CMR0_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC0_CMR0_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC0_CMR0_EEVT_TIOB        0x00000000 // TIOB
#define TC0_CMR0_EEVT_XC0         0x00000400 // XC0
#define TC0_CMR0_EEVT_XC1         0x00000800 // XC1
#define TC0_CMR0_EEVT_XC2         0x00000C00 // XC2
#define TC0_CMR0_ENETRG           0x00001000 // External Event Trigger Enable
#define TC0_CMR0_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC0_CMR0_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC0_CMR0_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC0_CMR0_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC0_CMR0_ACPA_NONE        0x00000000 // None
#define TC0_CMR0_ACPA_SET         0x00010000 // Set
#define TC0_CMR0_ACPA_CLEAR       0x00020000 // Clear
#define TC0_CMR0_ACPA_TOGGLE      0x00030000 // Toggle
#define TC0_CMR0_ACPC_NONE        0x00000000 // None
#define TC0_CMR0_ACPC_SET         0x00040000 // Set
#define TC0_CMR0_ACPC_CLEAR       0x00080000 // Clear
#define TC0_CMR0_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC0_CMR0_AEEVT_NONE       0x00000000 // None
#define TC0_CMR0_AEEVT_SET        0x00100000 // Set
#define TC0_CMR0_AEEVT_CLEAR      0x00200000 // Clear
#define TC0_CMR0_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC0_CMR0_ASWTRG_NONE      0x00000000 // None
#define TC0_CMR0_ASWTRG_SET       0x00400000 // Set
#define TC0_CMR0_ASWTRG_CLEAR     0x00800000 // Clear
#define TC0_CMR0_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC0_CMR0_BCPB_NONE        0x00000000 // None
#define TC0_CMR0_BCPB_SET         0x01000000 // Set
#define TC0_CMR0_BCPB_CLEAR       0x02000000 // Clear
#define TC0_CMR0_BCPB_TOGGLE      0x03000000 // Toggle
#define TC0_CMR0_BCPC_NONE        0x00000000 // None
#define TC0_CMR0_BCPC_SET         0x04000000 // Set
#define TC0_CMR0_BCPC_CLEAR       0x08000000 // Clear
#define TC0_CMR0_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC0_CMR0_BEEVT_NONE       0x00000000 // None
#define TC0_CMR0_BEEVT_SET        0x10000000 // Set
#define TC0_CMR0_BEEVT_CLEAR      0x20000000 // Clear
#define TC0_CMR0_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC0_CMR0_BSWTRG_NONE      0x00000000 // None
#define TC0_CMR0_BSWTRG_SET       0x40000000 // Set
#define TC0_CMR0_BSWTRG_CLEAR     0x80000000 // Clear
#define TC0_CMR0_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC0_SMMR0_GCEN 0x00000001 // Gray Count Enable
#define TC0_SMMR0_DOWN 0x00000002 // Down Count

#define TC0_CV0_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC0_RA0_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC0_RB0_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC0_RC0_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC0_SR0_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC0_SR0_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC0_SR0_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC0_SR0_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC0_SR0_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC0_SR0_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC0_SR0_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC0_SR0_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC0_SR0_CLKSTA 0x00010000 // Clock Enabling Status
#define TC0_SR0_MTIOA  0x00020000 // TIOA Mirror
#define TC0_SR0_MTIOB  0x00040000 // TIOB Mirror

#define TC0_IER0_COVFS 0x00000001 // Counter Overflow
#define TC0_IER0_LOVRS 0x00000002 // Load Overrun
#define TC0_IER0_CPAS  0x00000004 // RA Compare
#define TC0_IER0_CPBS  0x00000008 // RB Compare
#define TC0_IER0_CPCS  0x00000010 // RC Compare
#define TC0_IER0_LDRAS 0x00000020 // RA Loading
#define TC0_IER0_LDRBS 0x00000040 // RB Loading
#define TC0_IER0_ETRGS 0x00000080 // External Trigger

#define TC0_IDR0_COVFS 0x00000001 // Counter Overflow
#define TC0_IDR0_LOVRS 0x00000002 // Load Overrun
#define TC0_IDR0_CPAS  0x00000004 // RA Compare
#define TC0_IDR0_CPBS  0x00000008 // RB Compare
#define TC0_IDR0_CPCS  0x00000010 // RC Compare
#define TC0_IDR0_LDRAS 0x00000020 // RA Loading
#define TC0_IDR0_LDRBS 0x00000040 // RB Loading
#define TC0_IDR0_ETRGS 0x00000080 // External Trigger

#define TC0_IMR0_COVFS 0x00000001 // Counter Overflow
#define TC0_IMR0_LOVRS 0x00000002 // Load Overrun
#define TC0_IMR0_CPAS  0x00000004 // RA Compare
#define TC0_IMR0_CPBS  0x00000008 // RB Compare
#define TC0_IMR0_CPCS  0x00000010 // RC Compare
#define TC0_IMR0_LDRAS 0x00000020 // RA Loading
#define TC0_IMR0_LDRBS 0x00000040 // RB Loading
#define TC0_IMR0_ETRGS 0x00000080 // External Trigger

#define TC0_CCR1_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC0_CCR1_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC0_CCR1_SWTRG  0x00000004 // Software Trigger Command

#define TC0_CMR1_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC0_CMR1_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC0_CMR1_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC0_CMR1_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC0_CMR1_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC0_CMR1_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC0_CMR1_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC0_CMR1_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC0_CMR1_CLKI                0x00000008 // Clock Invert
#define TC0_CMR1_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC0_CMR1_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC0_CMR1_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC0_CMR1_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC0_CMR1_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC0_CMR1_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC0_CMR1_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC0_CMR1_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC0_CMR1_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC0_CMR1_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC0_CMR1_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC0_CMR1_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC0_CMR1_WAVE                0x00008000 // Waveform Mode
#define TC0_CMR1_LDRA_NONE           0x00000000 // None
#define TC0_CMR1_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC0_CMR1_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC0_CMR1_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC0_CMR1_LDRB_NONE           0x00000000 // None
#define TC0_CMR1_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC0_CMR1_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC0_CMR1_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC0_CMR1_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC0_CMR1_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC0_CMR1_EEVTEDG_NONE     0x00000000 // None
#define TC0_CMR1_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC0_CMR1_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC0_CMR1_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC0_CMR1_EEVT_TIOB        0x00000000 // TIOB
#define TC0_CMR1_EEVT_XC0         0x00000400 // XC0
#define TC0_CMR1_EEVT_XC1         0x00000800 // XC1
#define TC0_CMR1_EEVT_XC2         0x00000C00 // XC2
#define TC0_CMR1_ENETRG           0x00001000 // External Event Trigger Enable
#define TC0_CMR1_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC0_CMR1_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC0_CMR1_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC0_CMR1_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC0_CMR1_ACPA_NONE        0x00000000 // None
#define TC0_CMR1_ACPA_SET         0x00010000 // Set
#define TC0_CMR1_ACPA_CLEAR       0x00020000 // Clear
#define TC0_CMR1_ACPA_TOGGLE      0x00030000 // Toggle
#define TC0_CMR1_ACPC_NONE        0x00000000 // None
#define TC0_CMR1_ACPC_SET         0x00040000 // Set
#define TC0_CMR1_ACPC_CLEAR       0x00080000 // Clear
#define TC0_CMR1_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC0_CMR1_AEEVT_NONE       0x00000000 // None
#define TC0_CMR1_AEEVT_SET        0x00100000 // Set
#define TC0_CMR1_AEEVT_CLEAR      0x00200000 // Clear
#define TC0_CMR1_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC0_CMR1_ASWTRG_NONE      0x00000000 // None
#define TC0_CMR1_ASWTRG_SET       0x00400000 // Set
#define TC0_CMR1_ASWTRG_CLEAR     0x00800000 // Clear
#define TC0_CMR1_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC0_CMR1_BCPB_NONE        0x00000000 // None
#define TC0_CMR1_BCPB_SET         0x01000000 // Set
#define TC0_CMR1_BCPB_CLEAR       0x02000000 // Clear
#define TC0_CMR1_BCPB_TOGGLE      0x03000000 // Toggle
#define TC0_CMR1_BCPC_NONE        0x00000000 // None
#define TC0_CMR1_BCPC_SET         0x04000000 // Set
#define TC0_CMR1_BCPC_CLEAR       0x08000000 // Clear
#define TC0_CMR1_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC0_CMR1_BEEVT_NONE       0x00000000 // None
#define TC0_CMR1_BEEVT_SET        0x10000000 // Set
#define TC0_CMR1_BEEVT_CLEAR      0x20000000 // Clear
#define TC0_CMR1_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC0_CMR1_BSWTRG_NONE      0x00000000 // None
#define TC0_CMR1_BSWTRG_SET       0x40000000 // Set
#define TC0_CMR1_BSWTRG_CLEAR     0x80000000 // Clear
#define TC0_CMR1_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC0_SMMR1_GCEN 0x00000001 // Gray Count Enable
#define TC0_SMMR1_DOWN 0x00000002 // Down Count

#define TC0_CV1_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC0_RA1_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC0_RB1_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC0_RC1_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC0_SR1_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC0_SR1_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC0_SR1_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC0_SR1_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC0_SR1_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC0_SR1_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC0_SR1_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC0_SR1_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC0_SR1_CLKSTA 0x00010000 // Clock Enabling Status
#define TC0_SR1_MTIOA  0x00020000 // TIOA Mirror
#define TC0_SR1_MTIOB  0x00040000 // TIOB Mirror

#define TC0_IER1_COVFS 0x00000001 // Counter Overflow
#define TC0_IER1_LOVRS 0x00000002 // Load Overrun
#define TC0_IER1_CPAS  0x00000004 // RA Compare
#define TC0_IER1_CPBS  0x00000008 // RB Compare
#define TC0_IER1_CPCS  0x00000010 // RC Compare
#define TC0_IER1_LDRAS 0x00000020 // RA Loading
#define TC0_IER1_LDRBS 0x00000040 // RB Loading
#define TC0_IER1_ETRGS 0x00000080 // External Trigger

#define TC0_IDR1_COVFS 0x00000001 // Counter Overflow
#define TC0_IDR1_LOVRS 0x00000002 // Load Overrun
#define TC0_IDR1_CPAS  0x00000004 // RA Compare
#define TC0_IDR1_CPBS  0x00000008 // RB Compare
#define TC0_IDR1_CPCS  0x00000010 // RC Compare
#define TC0_IDR1_LDRAS 0x00000020 // RA Loading
#define TC0_IDR1_LDRBS 0x00000040 // RB Loading
#define TC0_IDR1_ETRGS 0x00000080 // External Trigger

#define TC0_IMR1_COVFS 0x00000001 // Counter Overflow
#define TC0_IMR1_LOVRS 0x00000002 // Load Overrun
#define TC0_IMR1_CPAS  0x00000004 // RA Compare
#define TC0_IMR1_CPBS  0x00000008 // RB Compare
#define TC0_IMR1_CPCS  0x00000010 // RC Compare
#define TC0_IMR1_LDRAS 0x00000020 // RA Loading
#define TC0_IMR1_LDRBS 0x00000040 // RB Loading
#define TC0_IMR1_ETRGS 0x00000080 // External Trigger

#define TC0_CCR2_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC0_CCR2_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC0_CCR2_SWTRG  0x00000004 // Software Trigger Command

#define TC0_CMR2_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC0_CMR2_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC0_CMR2_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC0_CMR2_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC0_CMR2_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC0_CMR2_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC0_CMR2_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC0_CMR2_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC0_CMR2_CLKI                0x00000008 // Clock Invert
#define TC0_CMR2_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC0_CMR2_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC0_CMR2_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC0_CMR2_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC0_CMR2_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC0_CMR2_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC0_CMR2_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC0_CMR2_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC0_CMR2_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC0_CMR2_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC0_CMR2_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC0_CMR2_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC0_CMR2_WAVE                0x00008000 // Waveform Mode
#define TC0_CMR2_LDRA_NONE           0x00000000 // None
#define TC0_CMR2_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC0_CMR2_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC0_CMR2_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC0_CMR2_LDRB_NONE           0x00000000 // None
#define TC0_CMR2_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC0_CMR2_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC0_CMR2_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC0_CMR2_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC0_CMR2_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC0_CMR2_EEVTEDG_NONE     0x00000000 // None
#define TC0_CMR2_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC0_CMR2_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC0_CMR2_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC0_CMR2_EEVT_TIOB        0x00000000 // TIOB
#define TC0_CMR2_EEVT_XC0         0x00000400 // XC0
#define TC0_CMR2_EEVT_XC1         0x00000800 // XC1
#define TC0_CMR2_EEVT_XC2         0x00000C00 // XC2
#define TC0_CMR2_ENETRG           0x00001000 // External Event Trigger Enable
#define TC0_CMR2_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC0_CMR2_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC0_CMR2_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC0_CMR2_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC0_CMR2_ACPA_NONE        0x00000000 // None
#define TC0_CMR2_ACPA_SET         0x00010000 // Set
#define TC0_CMR2_ACPA_CLEAR       0x00020000 // Clear
#define TC0_CMR2_ACPA_TOGGLE      0x00030000 // Toggle
#define TC0_CMR2_ACPC_NONE        0x00000000 // None
#define TC0_CMR2_ACPC_SET         0x00040000 // Set
#define TC0_CMR2_ACPC_CLEAR       0x00080000 // Clear
#define TC0_CMR2_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC0_CMR2_AEEVT_NONE       0x00000000 // None
#define TC0_CMR2_AEEVT_SET        0x00100000 // Set
#define TC0_CMR2_AEEVT_CLEAR      0x00200000 // Clear
#define TC0_CMR2_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC0_CMR2_ASWTRG_NONE      0x00000000 // None
#define TC0_CMR2_ASWTRG_SET       0x00400000 // Set
#define TC0_CMR2_ASWTRG_CLEAR     0x00800000 // Clear
#define TC0_CMR2_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC0_CMR2_BCPB_NONE        0x00000000 // None
#define TC0_CMR2_BCPB_SET         0x01000000 // Set
#define TC0_CMR2_BCPB_CLEAR       0x02000000 // Clear
#define TC0_CMR2_BCPB_TOGGLE      0x03000000 // Toggle
#define TC0_CMR2_BCPC_NONE        0x00000000 // None
#define TC0_CMR2_BCPC_SET         0x04000000 // Set
#define TC0_CMR2_BCPC_CLEAR       0x08000000 // Clear
#define TC0_CMR2_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC0_CMR2_BEEVT_NONE       0x00000000 // None
#define TC0_CMR2_BEEVT_SET        0x10000000 // Set
#define TC0_CMR2_BEEVT_CLEAR      0x20000000 // Clear
#define TC0_CMR2_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC0_CMR2_BSWTRG_NONE      0x00000000 // None
#define TC0_CMR2_BSWTRG_SET       0x40000000 // Set
#define TC0_CMR2_BSWTRG_CLEAR     0x80000000 // Clear
#define TC0_CMR2_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC0_SMMR2_GCEN 0x00000001 // Gray Count Enable
#define TC0_SMMR2_DOWN 0x00000002 // Down Count

#define TC0_CV2_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC0_RA2_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC0_RB2_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC0_RC2_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC0_SR2_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC0_SR2_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC0_SR2_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC0_SR2_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC0_SR2_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC0_SR2_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC0_SR2_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC0_SR2_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC0_SR2_CLKSTA 0x00010000 // Clock Enabling Status
#define TC0_SR2_MTIOA  0x00020000 // TIOA Mirror
#define TC0_SR2_MTIOB  0x00040000 // TIOB Mirror

#define TC0_IER2_COVFS 0x00000001 // Counter Overflow
#define TC0_IER2_LOVRS 0x00000002 // Load Overrun
#define TC0_IER2_CPAS  0x00000004 // RA Compare
#define TC0_IER2_CPBS  0x00000008 // RB Compare
#define TC0_IER2_CPCS  0x00000010 // RC Compare
#define TC0_IER2_LDRAS 0x00000020 // RA Loading
#define TC0_IER2_LDRBS 0x00000040 // RB Loading
#define TC0_IER2_ETRGS 0x00000080 // External Trigger

#define TC0_IDR2_COVFS 0x00000001 // Counter Overflow
#define TC0_IDR2_LOVRS 0x00000002 // Load Overrun
#define TC0_IDR2_CPAS  0x00000004 // RA Compare
#define TC0_IDR2_CPBS  0x00000008 // RB Compare
#define TC0_IDR2_CPCS  0x00000010 // RC Compare
#define TC0_IDR2_LDRAS 0x00000020 // RA Loading
#define TC0_IDR2_LDRBS 0x00000040 // RB Loading
#define TC0_IDR2_ETRGS 0x00000080 // External Trigger

#define TC0_IMR2_COVFS 0x00000001 // Counter Overflow
#define TC0_IMR2_LOVRS 0x00000002 // Load Overrun
#define TC0_IMR2_CPAS  0x00000004 // RA Compare
#define TC0_IMR2_CPBS  0x00000008 // RB Compare
#define TC0_IMR2_CPCS  0x00000010 // RC Compare
#define TC0_IMR2_LDRAS 0x00000020 // RA Loading
#define TC0_IMR2_LDRBS 0x00000040 // RB Loading
#define TC0_IMR2_ETRGS 0x00000080 // External Trigger

#define TC0_BCR_SYNC 0x00000001 // Synchro Command

#define TC0_BMR_TC0XC0S_TCLK0  0x00000000               // Signal connected to XC0: TCLK0
#define TC0_BMR_TC0XC0S_TIOA1  0x00000002               // Signal connected to XC0: TIOA1
#define TC0_BMR_TC0XC0S_TIOA2  0x00000003               // Signal connected to XC0: TIOA2
#define TC0_BMR_TC1XC1S_TCLK1  0x00000000               // Signal connected to XC1: TCLK1
#define TC0_BMR_TC1XC1S_TIOA0  0x00000008               // Signal connected to XC1: TIOA0
#define TC0_BMR_TC1XC1S_TIOA2  0x0000000C               // Signal connected to XC1: TIOA2
#define TC0_BMR_TC2XC2S_TCLK2  0x00000000               // Signal connected to XC2: TCLK2
#define TC0_BMR_TC2XC2S_TIOA0  0x00000020               // Signal connected to XC2: TIOA0
#define TC0_BMR_TC2XC2S_TIOA1  0x00000030               // Signal connected to XC2: TIOA1
#define TC0_BMR_QDEN           0x00000100               // Quadrature Decoder Enabled
#define TC0_BMR_POSEN          0x00000200               // Position Enabled
#define TC0_BMR_SPEEDEN        0x00000400               // Speed Enabled
#define TC0_BMR_QDTRANS        0x00000800               // Quadrature Decoding Transparent
#define TC0_BMR_EDGPHA         0x00001000               // Edge on PHA Count Mode
#define TC0_BMR_INVA           0x00002000               // Inverted PHA
#define TC0_BMR_INVB           0x00004000               // Inverted PHB
#define TC0_BMR_INVIDX         0x00008000               // Inverted Index
#define TC0_BMR_SWAP           0x00010000               // Swap PHA and PHB
#define TC0_BMR_IDXPHB         0x00020000               // Index Pin is PHB Pin
#define TC0_BMR_MAXFILT(value) (((value) & 0x3F) << 20) // Maximum Filter

#define TC0_QIER_IDX    0x00000001 // Index
#define TC0_QIER_DIRCHG 0x00000002 // Direction Change
#define TC0_QIER_QERR   0x00000004 // Quadrature Error

#define TC0_QIDR_IDX    0x00000001 // Index
#define TC0_QIDR_DIRCHG 0x00000002 // Direction Change
#define TC0_QIDR_QERR   0x00000004 // Quadrature Error

#define TC0_QIMR_IDX    0x00000001 // Index
#define TC0_QIMR_DIRCHG 0x00000002 // Direction Change
#define TC0_QIMR_QERR   0x00000004 // Quadrature Error

#define TC0_QISR_IDX    0x00000001 // Index
#define TC0_QISR_DIRCHG 0x00000002 // Direction Change
#define TC0_QISR_QERR   0x00000004 // Quadrature Error
#define TC0_QISR_DIR    0x00000100 // Direction

#define TC0_FMR_ENCF0 0x00000001 // Enable Compare Fault Channel 0
#define TC0_FMR_ENCF1 0x00000002 // Enable Compare Fault Channel 1

#define TC0_WPMR_WPEN         0x00000001 // Write Protection Enable
#define TC0_WPMR_WPKEY_PASSWD 0x54494D00 // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0

#define TC1_CCR0  (*(volatile unsigned int *)0x40084000)       // [Channel Control Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC1_CMR0  (*(volatile unsigned int *)0x40084004)       // [Channel Mode Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC1_SMMR0 (*(volatile unsigned int *)0x40084008)       // [Stepper Motor Mode Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC1_CV0   (*(const volatile unsigned int *)0x40084010) // [Counter Value (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC1_RA0   (*(volatile unsigned int *)0x40084014)       // [Register A (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC1_RB0   (*(volatile unsigned int *)0x40084018)       // [Register B (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC1_RC0   (*(volatile unsigned int *)0x4008401C)       // [Register C (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC1_SR0   (*(const volatile unsigned int *)0x40084020) // [Status Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC1_IER0  (*(volatile unsigned int *)0x40084024)       // [Interrupt Enable Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC1_IDR0  (*(volatile unsigned int *)0x40084028)       // [Interrupt Disable Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC1_IMR0  (*(const volatile unsigned int *)0x4008402C) // [Interrupt Mask Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC1_CCR1  (*(volatile unsigned int *)0x40084040)       // [Channel Control Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC1_CMR1  (*(volatile unsigned int *)0x40084044)       // [Channel Mode Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC1_SMMR1 (*(volatile unsigned int *)0x40084048)       // [Stepper Motor Mode Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC1_CV1   (*(const volatile unsigned int *)0x40084050) // [Counter Value (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC1_RA1   (*(volatile unsigned int *)0x40084054)       // [Register A (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC1_RB1   (*(volatile unsigned int *)0x40084058)       // [Register B (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC1_RC1   (*(volatile unsigned int *)0x4008405C)       // [Register C (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC1_SR1   (*(const volatile unsigned int *)0x40084060) // [Status Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC1_IER1  (*(volatile unsigned int *)0x40084064)       // [Interrupt Enable Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC1_IDR1  (*(volatile unsigned int *)0x40084068)       // [Interrupt Disable Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC1_IMR1  (*(const volatile unsigned int *)0x4008406C) // [Interrupt Mask Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC1_CCR2  (*(volatile unsigned int *)0x40084080)       // [Channel Control Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC1_CMR2  (*(volatile unsigned int *)0x40084084)       // [Channel Mode Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC1_SMMR2 (*(volatile unsigned int *)0x40084088)       // [Stepper Motor Mode Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC1_CV2   (*(const volatile unsigned int *)0x40084090) // [Counter Value (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC1_RA2   (*(volatile unsigned int *)0x40084094)       // [Register A (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC1_RB2   (*(volatile unsigned int *)0x40084098)       // [Register B (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC1_RC2   (*(volatile unsigned int *)0x4008409C)       // [Register C (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC1_SR2   (*(const volatile unsigned int *)0x400840A0) // [Status Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC1_IER2  (*(volatile unsigned int *)0x400840A4)       // [Interrupt Enable Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC1_IDR2  (*(volatile unsigned int *)0x400840A8)       // [Interrupt Disable Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC1_IMR2  (*(const volatile unsigned int *)0x400840AC) // [Interrupt Mask Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC1_BCR   (*(volatile unsigned int *)0x400840C0)       // [Block Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1159522)
#define TC1_BMR   (*(volatile unsigned int *)0x400840C4)       // [Block Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1157922)
#define TC1_QIER  (*(volatile unsigned int *)0x400840C8)       // [QDEC Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158557)
#define TC1_QIDR  (*(volatile unsigned int *)0x400840CC)       // [QDEC Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158748)
#define TC1_QIMR  (*(const volatile unsigned int *)0x400840D0) // [QDEC Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158939)
#define TC1_QISR  (*(const volatile unsigned int *)0x400840D4) // [QDEC Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1159130)
#define TC1_FMR   (*(volatile unsigned int *)0x400840D8)       // [Fault Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1277700)
#define TC1_WPMR  (*(volatile unsigned int *)0x400840E4)       // [Write Protection Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1277892)

#define TC1_CCR0_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC1_CCR0_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC1_CCR0_SWTRG  0x00000004 // Software Trigger Command

#define TC1_CMR0_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC1_CMR0_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC1_CMR0_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC1_CMR0_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC1_CMR0_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC1_CMR0_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC1_CMR0_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC1_CMR0_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC1_CMR0_CLKI                0x00000008 // Clock Invert
#define TC1_CMR0_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC1_CMR0_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC1_CMR0_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC1_CMR0_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC1_CMR0_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC1_CMR0_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC1_CMR0_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC1_CMR0_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC1_CMR0_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC1_CMR0_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC1_CMR0_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC1_CMR0_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC1_CMR0_WAVE                0x00008000 // Waveform Mode
#define TC1_CMR0_LDRA_NONE           0x00000000 // None
#define TC1_CMR0_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC1_CMR0_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC1_CMR0_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC1_CMR0_LDRB_NONE           0x00000000 // None
#define TC1_CMR0_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC1_CMR0_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC1_CMR0_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC1_CMR0_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC1_CMR0_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC1_CMR0_EEVTEDG_NONE     0x00000000 // None
#define TC1_CMR0_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC1_CMR0_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC1_CMR0_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC1_CMR0_EEVT_TIOB        0x00000000 // TIOB
#define TC1_CMR0_EEVT_XC0         0x00000400 // XC0
#define TC1_CMR0_EEVT_XC1         0x00000800 // XC1
#define TC1_CMR0_EEVT_XC2         0x00000C00 // XC2
#define TC1_CMR0_ENETRG           0x00001000 // External Event Trigger Enable
#define TC1_CMR0_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC1_CMR0_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC1_CMR0_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC1_CMR0_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC1_CMR0_ACPA_NONE        0x00000000 // None
#define TC1_CMR0_ACPA_SET         0x00010000 // Set
#define TC1_CMR0_ACPA_CLEAR       0x00020000 // Clear
#define TC1_CMR0_ACPA_TOGGLE      0x00030000 // Toggle
#define TC1_CMR0_ACPC_NONE        0x00000000 // None
#define TC1_CMR0_ACPC_SET         0x00040000 // Set
#define TC1_CMR0_ACPC_CLEAR       0x00080000 // Clear
#define TC1_CMR0_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC1_CMR0_AEEVT_NONE       0x00000000 // None
#define TC1_CMR0_AEEVT_SET        0x00100000 // Set
#define TC1_CMR0_AEEVT_CLEAR      0x00200000 // Clear
#define TC1_CMR0_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC1_CMR0_ASWTRG_NONE      0x00000000 // None
#define TC1_CMR0_ASWTRG_SET       0x00400000 // Set
#define TC1_CMR0_ASWTRG_CLEAR     0x00800000 // Clear
#define TC1_CMR0_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC1_CMR0_BCPB_NONE        0x00000000 // None
#define TC1_CMR0_BCPB_SET         0x01000000 // Set
#define TC1_CMR0_BCPB_CLEAR       0x02000000 // Clear
#define TC1_CMR0_BCPB_TOGGLE      0x03000000 // Toggle
#define TC1_CMR0_BCPC_NONE        0x00000000 // None
#define TC1_CMR0_BCPC_SET         0x04000000 // Set
#define TC1_CMR0_BCPC_CLEAR       0x08000000 // Clear
#define TC1_CMR0_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC1_CMR0_BEEVT_NONE       0x00000000 // None
#define TC1_CMR0_BEEVT_SET        0x10000000 // Set
#define TC1_CMR0_BEEVT_CLEAR      0x20000000 // Clear
#define TC1_CMR0_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC1_CMR0_BSWTRG_NONE      0x00000000 // None
#define TC1_CMR0_BSWTRG_SET       0x40000000 // Set
#define TC1_CMR0_BSWTRG_CLEAR     0x80000000 // Clear
#define TC1_CMR0_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC1_SMMR0_GCEN 0x00000001 // Gray Count Enable
#define TC1_SMMR0_DOWN 0x00000002 // Down Count

#define TC1_CV0_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC1_RA0_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC1_RB0_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC1_RC0_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC1_SR0_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC1_SR0_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC1_SR0_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC1_SR0_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC1_SR0_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC1_SR0_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC1_SR0_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC1_SR0_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC1_SR0_CLKSTA 0x00010000 // Clock Enabling Status
#define TC1_SR0_MTIOA  0x00020000 // TIOA Mirror
#define TC1_SR0_MTIOB  0x00040000 // TIOB Mirror

#define TC1_IER0_COVFS 0x00000001 // Counter Overflow
#define TC1_IER0_LOVRS 0x00000002 // Load Overrun
#define TC1_IER0_CPAS  0x00000004 // RA Compare
#define TC1_IER0_CPBS  0x00000008 // RB Compare
#define TC1_IER0_CPCS  0x00000010 // RC Compare
#define TC1_IER0_LDRAS 0x00000020 // RA Loading
#define TC1_IER0_LDRBS 0x00000040 // RB Loading
#define TC1_IER0_ETRGS 0x00000080 // External Trigger

#define TC1_IDR0_COVFS 0x00000001 // Counter Overflow
#define TC1_IDR0_LOVRS 0x00000002 // Load Overrun
#define TC1_IDR0_CPAS  0x00000004 // RA Compare
#define TC1_IDR0_CPBS  0x00000008 // RB Compare
#define TC1_IDR0_CPCS  0x00000010 // RC Compare
#define TC1_IDR0_LDRAS 0x00000020 // RA Loading
#define TC1_IDR0_LDRBS 0x00000040 // RB Loading
#define TC1_IDR0_ETRGS 0x00000080 // External Trigger

#define TC1_IMR0_COVFS 0x00000001 // Counter Overflow
#define TC1_IMR0_LOVRS 0x00000002 // Load Overrun
#define TC1_IMR0_CPAS  0x00000004 // RA Compare
#define TC1_IMR0_CPBS  0x00000008 // RB Compare
#define TC1_IMR0_CPCS  0x00000010 // RC Compare
#define TC1_IMR0_LDRAS 0x00000020 // RA Loading
#define TC1_IMR0_LDRBS 0x00000040 // RB Loading
#define TC1_IMR0_ETRGS 0x00000080 // External Trigger

#define TC1_CCR1_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC1_CCR1_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC1_CCR1_SWTRG  0x00000004 // Software Trigger Command

#define TC1_CMR1_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC1_CMR1_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC1_CMR1_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC1_CMR1_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC1_CMR1_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC1_CMR1_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC1_CMR1_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC1_CMR1_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC1_CMR1_CLKI                0x00000008 // Clock Invert
#define TC1_CMR1_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC1_CMR1_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC1_CMR1_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC1_CMR1_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC1_CMR1_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC1_CMR1_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC1_CMR1_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC1_CMR1_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC1_CMR1_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC1_CMR1_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC1_CMR1_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC1_CMR1_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC1_CMR1_WAVE                0x00008000 // Waveform Mode
#define TC1_CMR1_LDRA_NONE           0x00000000 // None
#define TC1_CMR1_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC1_CMR1_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC1_CMR1_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC1_CMR1_LDRB_NONE           0x00000000 // None
#define TC1_CMR1_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC1_CMR1_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC1_CMR1_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC1_CMR1_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC1_CMR1_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC1_CMR1_EEVTEDG_NONE     0x00000000 // None
#define TC1_CMR1_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC1_CMR1_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC1_CMR1_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC1_CMR1_EEVT_TIOB        0x00000000 // TIOB
#define TC1_CMR1_EEVT_XC0         0x00000400 // XC0
#define TC1_CMR1_EEVT_XC1         0x00000800 // XC1
#define TC1_CMR1_EEVT_XC2         0x00000C00 // XC2
#define TC1_CMR1_ENETRG           0x00001000 // External Event Trigger Enable
#define TC1_CMR1_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC1_CMR1_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC1_CMR1_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC1_CMR1_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC1_CMR1_ACPA_NONE        0x00000000 // None
#define TC1_CMR1_ACPA_SET         0x00010000 // Set
#define TC1_CMR1_ACPA_CLEAR       0x00020000 // Clear
#define TC1_CMR1_ACPA_TOGGLE      0x00030000 // Toggle
#define TC1_CMR1_ACPC_NONE        0x00000000 // None
#define TC1_CMR1_ACPC_SET         0x00040000 // Set
#define TC1_CMR1_ACPC_CLEAR       0x00080000 // Clear
#define TC1_CMR1_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC1_CMR1_AEEVT_NONE       0x00000000 // None
#define TC1_CMR1_AEEVT_SET        0x00100000 // Set
#define TC1_CMR1_AEEVT_CLEAR      0x00200000 // Clear
#define TC1_CMR1_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC1_CMR1_ASWTRG_NONE      0x00000000 // None
#define TC1_CMR1_ASWTRG_SET       0x00400000 // Set
#define TC1_CMR1_ASWTRG_CLEAR     0x00800000 // Clear
#define TC1_CMR1_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC1_CMR1_BCPB_NONE        0x00000000 // None
#define TC1_CMR1_BCPB_SET         0x01000000 // Set
#define TC1_CMR1_BCPB_CLEAR       0x02000000 // Clear
#define TC1_CMR1_BCPB_TOGGLE      0x03000000 // Toggle
#define TC1_CMR1_BCPC_NONE        0x00000000 // None
#define TC1_CMR1_BCPC_SET         0x04000000 // Set
#define TC1_CMR1_BCPC_CLEAR       0x08000000 // Clear
#define TC1_CMR1_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC1_CMR1_BEEVT_NONE       0x00000000 // None
#define TC1_CMR1_BEEVT_SET        0x10000000 // Set
#define TC1_CMR1_BEEVT_CLEAR      0x20000000 // Clear
#define TC1_CMR1_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC1_CMR1_BSWTRG_NONE      0x00000000 // None
#define TC1_CMR1_BSWTRG_SET       0x40000000 // Set
#define TC1_CMR1_BSWTRG_CLEAR     0x80000000 // Clear
#define TC1_CMR1_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC1_SMMR1_GCEN 0x00000001 // Gray Count Enable
#define TC1_SMMR1_DOWN 0x00000002 // Down Count

#define TC1_CV1_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC1_RA1_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC1_RB1_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC1_RC1_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC1_SR1_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC1_SR1_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC1_SR1_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC1_SR1_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC1_SR1_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC1_SR1_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC1_SR1_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC1_SR1_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC1_SR1_CLKSTA 0x00010000 // Clock Enabling Status
#define TC1_SR1_MTIOA  0x00020000 // TIOA Mirror
#define TC1_SR1_MTIOB  0x00040000 // TIOB Mirror

#define TC1_IER1_COVFS 0x00000001 // Counter Overflow
#define TC1_IER1_LOVRS 0x00000002 // Load Overrun
#define TC1_IER1_CPAS  0x00000004 // RA Compare
#define TC1_IER1_CPBS  0x00000008 // RB Compare
#define TC1_IER1_CPCS  0x00000010 // RC Compare
#define TC1_IER1_LDRAS 0x00000020 // RA Loading
#define TC1_IER1_LDRBS 0x00000040 // RB Loading
#define TC1_IER1_ETRGS 0x00000080 // External Trigger

#define TC1_IDR1_COVFS 0x00000001 // Counter Overflow
#define TC1_IDR1_LOVRS 0x00000002 // Load Overrun
#define TC1_IDR1_CPAS  0x00000004 // RA Compare
#define TC1_IDR1_CPBS  0x00000008 // RB Compare
#define TC1_IDR1_CPCS  0x00000010 // RC Compare
#define TC1_IDR1_LDRAS 0x00000020 // RA Loading
#define TC1_IDR1_LDRBS 0x00000040 // RB Loading
#define TC1_IDR1_ETRGS 0x00000080 // External Trigger

#define TC1_IMR1_COVFS 0x00000001 // Counter Overflow
#define TC1_IMR1_LOVRS 0x00000002 // Load Overrun
#define TC1_IMR1_CPAS  0x00000004 // RA Compare
#define TC1_IMR1_CPBS  0x00000008 // RB Compare
#define TC1_IMR1_CPCS  0x00000010 // RC Compare
#define TC1_IMR1_LDRAS 0x00000020 // RA Loading
#define TC1_IMR1_LDRBS 0x00000040 // RB Loading
#define TC1_IMR1_ETRGS 0x00000080 // External Trigger

#define TC1_CCR2_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC1_CCR2_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC1_CCR2_SWTRG  0x00000004 // Software Trigger Command

#define TC1_CMR2_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC1_CMR2_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC1_CMR2_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC1_CMR2_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC1_CMR2_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC1_CMR2_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC1_CMR2_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC1_CMR2_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC1_CMR2_CLKI                0x00000008 // Clock Invert
#define TC1_CMR2_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC1_CMR2_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC1_CMR2_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC1_CMR2_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC1_CMR2_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC1_CMR2_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC1_CMR2_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC1_CMR2_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC1_CMR2_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC1_CMR2_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC1_CMR2_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC1_CMR2_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC1_CMR2_WAVE                0x00008000 // Waveform Mode
#define TC1_CMR2_LDRA_NONE           0x00000000 // None
#define TC1_CMR2_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC1_CMR2_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC1_CMR2_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC1_CMR2_LDRB_NONE           0x00000000 // None
#define TC1_CMR2_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC1_CMR2_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC1_CMR2_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC1_CMR2_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC1_CMR2_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC1_CMR2_EEVTEDG_NONE     0x00000000 // None
#define TC1_CMR2_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC1_CMR2_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC1_CMR2_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC1_CMR2_EEVT_TIOB        0x00000000 // TIOB
#define TC1_CMR2_EEVT_XC0         0x00000400 // XC0
#define TC1_CMR2_EEVT_XC1         0x00000800 // XC1
#define TC1_CMR2_EEVT_XC2         0x00000C00 // XC2
#define TC1_CMR2_ENETRG           0x00001000 // External Event Trigger Enable
#define TC1_CMR2_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC1_CMR2_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC1_CMR2_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC1_CMR2_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC1_CMR2_ACPA_NONE        0x00000000 // None
#define TC1_CMR2_ACPA_SET         0x00010000 // Set
#define TC1_CMR2_ACPA_CLEAR       0x00020000 // Clear
#define TC1_CMR2_ACPA_TOGGLE      0x00030000 // Toggle
#define TC1_CMR2_ACPC_NONE        0x00000000 // None
#define TC1_CMR2_ACPC_SET         0x00040000 // Set
#define TC1_CMR2_ACPC_CLEAR       0x00080000 // Clear
#define TC1_CMR2_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC1_CMR2_AEEVT_NONE       0x00000000 // None
#define TC1_CMR2_AEEVT_SET        0x00100000 // Set
#define TC1_CMR2_AEEVT_CLEAR      0x00200000 // Clear
#define TC1_CMR2_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC1_CMR2_ASWTRG_NONE      0x00000000 // None
#define TC1_CMR2_ASWTRG_SET       0x00400000 // Set
#define TC1_CMR2_ASWTRG_CLEAR     0x00800000 // Clear
#define TC1_CMR2_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC1_CMR2_BCPB_NONE        0x00000000 // None
#define TC1_CMR2_BCPB_SET         0x01000000 // Set
#define TC1_CMR2_BCPB_CLEAR       0x02000000 // Clear
#define TC1_CMR2_BCPB_TOGGLE      0x03000000 // Toggle
#define TC1_CMR2_BCPC_NONE        0x00000000 // None
#define TC1_CMR2_BCPC_SET         0x04000000 // Set
#define TC1_CMR2_BCPC_CLEAR       0x08000000 // Clear
#define TC1_CMR2_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC1_CMR2_BEEVT_NONE       0x00000000 // None
#define TC1_CMR2_BEEVT_SET        0x10000000 // Set
#define TC1_CMR2_BEEVT_CLEAR      0x20000000 // Clear
#define TC1_CMR2_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC1_CMR2_BSWTRG_NONE      0x00000000 // None
#define TC1_CMR2_BSWTRG_SET       0x40000000 // Set
#define TC1_CMR2_BSWTRG_CLEAR     0x80000000 // Clear
#define TC1_CMR2_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC1_SMMR2_GCEN 0x00000001 // Gray Count Enable
#define TC1_SMMR2_DOWN 0x00000002 // Down Count

#define TC1_CV2_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC1_RA2_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC1_RB2_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC1_RC2_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC1_SR2_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC1_SR2_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC1_SR2_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC1_SR2_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC1_SR2_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC1_SR2_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC1_SR2_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC1_SR2_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC1_SR2_CLKSTA 0x00010000 // Clock Enabling Status
#define TC1_SR2_MTIOA  0x00020000 // TIOA Mirror
#define TC1_SR2_MTIOB  0x00040000 // TIOB Mirror

#define TC1_IER2_COVFS 0x00000001 // Counter Overflow
#define TC1_IER2_LOVRS 0x00000002 // Load Overrun
#define TC1_IER2_CPAS  0x00000004 // RA Compare
#define TC1_IER2_CPBS  0x00000008 // RB Compare
#define TC1_IER2_CPCS  0x00000010 // RC Compare
#define TC1_IER2_LDRAS 0x00000020 // RA Loading
#define TC1_IER2_LDRBS 0x00000040 // RB Loading
#define TC1_IER2_ETRGS 0x00000080 // External Trigger

#define TC1_IDR2_COVFS 0x00000001 // Counter Overflow
#define TC1_IDR2_LOVRS 0x00000002 // Load Overrun
#define TC1_IDR2_CPAS  0x00000004 // RA Compare
#define TC1_IDR2_CPBS  0x00000008 // RB Compare
#define TC1_IDR2_CPCS  0x00000010 // RC Compare
#define TC1_IDR2_LDRAS 0x00000020 // RA Loading
#define TC1_IDR2_LDRBS 0x00000040 // RB Loading
#define TC1_IDR2_ETRGS 0x00000080 // External Trigger

#define TC1_IMR2_COVFS 0x00000001 // Counter Overflow
#define TC1_IMR2_LOVRS 0x00000002 // Load Overrun
#define TC1_IMR2_CPAS  0x00000004 // RA Compare
#define TC1_IMR2_CPBS  0x00000008 // RB Compare
#define TC1_IMR2_CPCS  0x00000010 // RC Compare
#define TC1_IMR2_LDRAS 0x00000020 // RA Loading
#define TC1_IMR2_LDRBS 0x00000040 // RB Loading
#define TC1_IMR2_ETRGS 0x00000080 // External Trigger

#define TC1_BCR_SYNC 0x00000001 // Synchro Command

#define TC1_BMR_TC0XC0S_TCLK0  0x00000000               // Signal connected to XC0: TCLK0
#define TC1_BMR_TC0XC0S_TIOA1  0x00000002               // Signal connected to XC0: TIOA1
#define TC1_BMR_TC0XC0S_TIOA2  0x00000003               // Signal connected to XC0: TIOA2
#define TC1_BMR_TC1XC1S_TCLK1  0x00000000               // Signal connected to XC1: TCLK1
#define TC1_BMR_TC1XC1S_TIOA0  0x00000008               // Signal connected to XC1: TIOA0
#define TC1_BMR_TC1XC1S_TIOA2  0x0000000C               // Signal connected to XC1: TIOA2
#define TC1_BMR_TC2XC2S_TCLK2  0x00000000               // Signal connected to XC2: TCLK2
#define TC1_BMR_TC2XC2S_TIOA0  0x00000020               // Signal connected to XC2: TIOA0
#define TC1_BMR_TC2XC2S_TIOA1  0x00000030               // Signal connected to XC2: TIOA1
#define TC1_BMR_QDEN           0x00000100               // Quadrature Decoder Enabled
#define TC1_BMR_POSEN          0x00000200               // Position Enabled
#define TC1_BMR_SPEEDEN        0x00000400               // Speed Enabled
#define TC1_BMR_QDTRANS        0x00000800               // Quadrature Decoding Transparent
#define TC1_BMR_EDGPHA         0x00001000               // Edge on PHA Count Mode
#define TC1_BMR_INVA           0x00002000               // Inverted PHA
#define TC1_BMR_INVB           0x00004000               // Inverted PHB
#define TC1_BMR_INVIDX         0x00008000               // Inverted Index
#define TC1_BMR_SWAP           0x00010000               // Swap PHA and PHB
#define TC1_BMR_IDXPHB         0x00020000               // Index Pin is PHB Pin
#define TC1_BMR_MAXFILT(value) (((value) & 0x3F) << 20) // Maximum Filter

#define TC1_QIER_IDX    0x00000001 // Index
#define TC1_QIER_DIRCHG 0x00000002 // Direction Change
#define TC1_QIER_QERR   0x00000004 // Quadrature Error

#define TC1_QIDR_IDX    0x00000001 // Index
#define TC1_QIDR_DIRCHG 0x00000002 // Direction Change
#define TC1_QIDR_QERR   0x00000004 // Quadrature Error

#define TC1_QIMR_IDX    0x00000001 // Index
#define TC1_QIMR_DIRCHG 0x00000002 // Direction Change
#define TC1_QIMR_QERR   0x00000004 // Quadrature Error

#define TC1_QISR_IDX    0x00000001 // Index
#define TC1_QISR_DIRCHG 0x00000002 // Direction Change
#define TC1_QISR_QERR   0x00000004 // Quadrature Error
#define TC1_QISR_DIR    0x00000100 // Direction

#define TC1_FMR_ENCF0 0x00000001 // Enable Compare Fault Channel 0
#define TC1_FMR_ENCF1 0x00000002 // Enable Compare Fault Channel 1

#define TC1_WPMR_WPEN         0x00000001 // Write Protection Enable
#define TC1_WPMR_WPKEY_PASSWD 0x54494D00 // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0

#define TC2_CCR0  (*(volatile unsigned int *)0x40088000)       // [Channel Control Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC2_CMR0  (*(volatile unsigned int *)0x40088004)       // [Channel Mode Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC2_SMMR0 (*(volatile unsigned int *)0x40088008)       // [Stepper Motor Mode Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC2_CV0   (*(const volatile unsigned int *)0x40088010) // [Counter Value (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC2_RA0   (*(volatile unsigned int *)0x40088014)       // [Register A (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC2_RB0   (*(volatile unsigned int *)0x40088018)       // [Register B (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC2_RC0   (*(volatile unsigned int *)0x4008801C)       // [Register C (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC2_SR0   (*(const volatile unsigned int *)0x40088020) // [Status Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC2_IER0  (*(volatile unsigned int *)0x40088024)       // [Interrupt Enable Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC2_IDR0  (*(volatile unsigned int *)0x40088028)       // [Interrupt Disable Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC2_IMR0  (*(const volatile unsigned int *)0x4008802C) // [Interrupt Mask Register (channel = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC2_CCR1  (*(volatile unsigned int *)0x40088040)       // [Channel Control Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC2_CMR1  (*(volatile unsigned int *)0x40088044)       // [Channel Mode Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC2_SMMR1 (*(volatile unsigned int *)0x40088048)       // [Stepper Motor Mode Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC2_CV1   (*(const volatile unsigned int *)0x40088050) // [Counter Value (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC2_RA1   (*(volatile unsigned int *)0x40088054)       // [Register A (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC2_RB1   (*(volatile unsigned int *)0x40088058)       // [Register B (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC2_RC1   (*(volatile unsigned int *)0x4008805C)       // [Register C (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC2_SR1   (*(const volatile unsigned int *)0x40088060) // [Status Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC2_IER1  (*(volatile unsigned int *)0x40088064)       // [Interrupt Enable Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC2_IDR1  (*(volatile unsigned int *)0x40088068)       // [Interrupt Disable Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC2_IMR1  (*(const volatile unsigned int *)0x4008806C) // [Interrupt Mask Register (channel = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC2_CCR2  (*(volatile unsigned int *)0x40088080)       // [Channel Control Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1108771)
#define TC2_CMR2  (*(volatile unsigned int *)0x40088084)       // [Channel Mode Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1075116)
#define TC2_SMMR2 (*(volatile unsigned int *)0x40088088)       // [Stepper Motor Mode Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1276990)
#define TC2_CV2   (*(const volatile unsigned int *)0x40088090) // [Counter Value (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1110732)
#define TC2_RA2   (*(volatile unsigned int *)0x40088094)       // [Register A (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076458)
#define TC2_RB2   (*(volatile unsigned int *)0x40088098)       // [Register B (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1237516)
#define TC2_RC2   (*(volatile unsigned int *)0x4008809C)       // [Register C (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1076919)
#define TC2_SR2   (*(const volatile unsigned int *)0x400880A0) // [Status Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077150)
#define TC2_IER2  (*(volatile unsigned int *)0x400880A4)       // [Interrupt Enable Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077428)
#define TC2_IDR2  (*(volatile unsigned int *)0x400880A8)       // [Interrupt Disable Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077705)
#define TC2_IMR2  (*(const volatile unsigned int *)0x400880AC) // [Interrupt Mask Register (channel = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1077982)
#define TC2_BCR   (*(volatile unsigned int *)0x400880C0)       // [Block Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1159522)
#define TC2_BMR   (*(volatile unsigned int *)0x400880C4)       // [Block Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1157922)
#define TC2_QIER  (*(volatile unsigned int *)0x400880C8)       // [QDEC Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158557)
#define TC2_QIDR  (*(volatile unsigned int *)0x400880CC)       // [QDEC Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158748)
#define TC2_QIMR  (*(const volatile unsigned int *)0x400880D0) // [QDEC Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1158939)
#define TC2_QISR  (*(const volatile unsigned int *)0x400880D4) // [QDEC Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1159130)
#define TC2_FMR   (*(volatile unsigned int *)0x400880D8)       // [Fault Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1277700)
#define TC2_WPMR  (*(volatile unsigned int *)0x400880E4)       // [Write Protection Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G27.1277892)

#define TC2_CCR0_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC2_CCR0_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC2_CCR0_SWTRG  0x00000004 // Software Trigger Command

#define TC2_CMR0_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC2_CMR0_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC2_CMR0_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC2_CMR0_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC2_CMR0_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC2_CMR0_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC2_CMR0_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC2_CMR0_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC2_CMR0_CLKI                0x00000008 // Clock Invert
#define TC2_CMR0_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC2_CMR0_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC2_CMR0_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC2_CMR0_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC2_CMR0_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC2_CMR0_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC2_CMR0_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC2_CMR0_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC2_CMR0_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC2_CMR0_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC2_CMR0_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC2_CMR0_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC2_CMR0_WAVE                0x00008000 // Waveform Mode
#define TC2_CMR0_LDRA_NONE           0x00000000 // None
#define TC2_CMR0_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC2_CMR0_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC2_CMR0_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC2_CMR0_LDRB_NONE           0x00000000 // None
#define TC2_CMR0_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC2_CMR0_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC2_CMR0_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC2_CMR0_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC2_CMR0_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC2_CMR0_EEVTEDG_NONE     0x00000000 // None
#define TC2_CMR0_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC2_CMR0_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC2_CMR0_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC2_CMR0_EEVT_TIOB        0x00000000 // TIOB
#define TC2_CMR0_EEVT_XC0         0x00000400 // XC0
#define TC2_CMR0_EEVT_XC1         0x00000800 // XC1
#define TC2_CMR0_EEVT_XC2         0x00000C00 // XC2
#define TC2_CMR0_ENETRG           0x00001000 // External Event Trigger Enable
#define TC2_CMR0_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC2_CMR0_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC2_CMR0_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC2_CMR0_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC2_CMR0_ACPA_NONE        0x00000000 // None
#define TC2_CMR0_ACPA_SET         0x00010000 // Set
#define TC2_CMR0_ACPA_CLEAR       0x00020000 // Clear
#define TC2_CMR0_ACPA_TOGGLE      0x00030000 // Toggle
#define TC2_CMR0_ACPC_NONE        0x00000000 // None
#define TC2_CMR0_ACPC_SET         0x00040000 // Set
#define TC2_CMR0_ACPC_CLEAR       0x00080000 // Clear
#define TC2_CMR0_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC2_CMR0_AEEVT_NONE       0x00000000 // None
#define TC2_CMR0_AEEVT_SET        0x00100000 // Set
#define TC2_CMR0_AEEVT_CLEAR      0x00200000 // Clear
#define TC2_CMR0_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC2_CMR0_ASWTRG_NONE      0x00000000 // None
#define TC2_CMR0_ASWTRG_SET       0x00400000 // Set
#define TC2_CMR0_ASWTRG_CLEAR     0x00800000 // Clear
#define TC2_CMR0_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC2_CMR0_BCPB_NONE        0x00000000 // None
#define TC2_CMR0_BCPB_SET         0x01000000 // Set
#define TC2_CMR0_BCPB_CLEAR       0x02000000 // Clear
#define TC2_CMR0_BCPB_TOGGLE      0x03000000 // Toggle
#define TC2_CMR0_BCPC_NONE        0x00000000 // None
#define TC2_CMR0_BCPC_SET         0x04000000 // Set
#define TC2_CMR0_BCPC_CLEAR       0x08000000 // Clear
#define TC2_CMR0_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC2_CMR0_BEEVT_NONE       0x00000000 // None
#define TC2_CMR0_BEEVT_SET        0x10000000 // Set
#define TC2_CMR0_BEEVT_CLEAR      0x20000000 // Clear
#define TC2_CMR0_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC2_CMR0_BSWTRG_NONE      0x00000000 // None
#define TC2_CMR0_BSWTRG_SET       0x40000000 // Set
#define TC2_CMR0_BSWTRG_CLEAR     0x80000000 // Clear
#define TC2_CMR0_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC2_SMMR0_GCEN 0x00000001 // Gray Count Enable
#define TC2_SMMR0_DOWN 0x00000002 // Down Count

#define TC2_CV0_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC2_RA0_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC2_RB0_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC2_RC0_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC2_SR0_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC2_SR0_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC2_SR0_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC2_SR0_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC2_SR0_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC2_SR0_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC2_SR0_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC2_SR0_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC2_SR0_CLKSTA 0x00010000 // Clock Enabling Status
#define TC2_SR0_MTIOA  0x00020000 // TIOA Mirror
#define TC2_SR0_MTIOB  0x00040000 // TIOB Mirror

#define TC2_IER0_COVFS 0x00000001 // Counter Overflow
#define TC2_IER0_LOVRS 0x00000002 // Load Overrun
#define TC2_IER0_CPAS  0x00000004 // RA Compare
#define TC2_IER0_CPBS  0x00000008 // RB Compare
#define TC2_IER0_CPCS  0x00000010 // RC Compare
#define TC2_IER0_LDRAS 0x00000020 // RA Loading
#define TC2_IER0_LDRBS 0x00000040 // RB Loading
#define TC2_IER0_ETRGS 0x00000080 // External Trigger

#define TC2_IDR0_COVFS 0x00000001 // Counter Overflow
#define TC2_IDR0_LOVRS 0x00000002 // Load Overrun
#define TC2_IDR0_CPAS  0x00000004 // RA Compare
#define TC2_IDR0_CPBS  0x00000008 // RB Compare
#define TC2_IDR0_CPCS  0x00000010 // RC Compare
#define TC2_IDR0_LDRAS 0x00000020 // RA Loading
#define TC2_IDR0_LDRBS 0x00000040 // RB Loading
#define TC2_IDR0_ETRGS 0x00000080 // External Trigger

#define TC2_IMR0_COVFS 0x00000001 // Counter Overflow
#define TC2_IMR0_LOVRS 0x00000002 // Load Overrun
#define TC2_IMR0_CPAS  0x00000004 // RA Compare
#define TC2_IMR0_CPBS  0x00000008 // RB Compare
#define TC2_IMR0_CPCS  0x00000010 // RC Compare
#define TC2_IMR0_LDRAS 0x00000020 // RA Loading
#define TC2_IMR0_LDRBS 0x00000040 // RB Loading
#define TC2_IMR0_ETRGS 0x00000080 // External Trigger

#define TC2_CCR1_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC2_CCR1_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC2_CCR1_SWTRG  0x00000004 // Software Trigger Command

#define TC2_CMR1_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC2_CMR1_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC2_CMR1_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC2_CMR1_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC2_CMR1_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC2_CMR1_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC2_CMR1_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC2_CMR1_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC2_CMR1_CLKI                0x00000008 // Clock Invert
#define TC2_CMR1_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC2_CMR1_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC2_CMR1_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC2_CMR1_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC2_CMR1_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC2_CMR1_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC2_CMR1_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC2_CMR1_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC2_CMR1_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC2_CMR1_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC2_CMR1_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC2_CMR1_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC2_CMR1_WAVE                0x00008000 // Waveform Mode
#define TC2_CMR1_LDRA_NONE           0x00000000 // None
#define TC2_CMR1_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC2_CMR1_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC2_CMR1_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC2_CMR1_LDRB_NONE           0x00000000 // None
#define TC2_CMR1_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC2_CMR1_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC2_CMR1_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC2_CMR1_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC2_CMR1_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC2_CMR1_EEVTEDG_NONE     0x00000000 // None
#define TC2_CMR1_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC2_CMR1_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC2_CMR1_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC2_CMR1_EEVT_TIOB        0x00000000 // TIOB
#define TC2_CMR1_EEVT_XC0         0x00000400 // XC0
#define TC2_CMR1_EEVT_XC1         0x00000800 // XC1
#define TC2_CMR1_EEVT_XC2         0x00000C00 // XC2
#define TC2_CMR1_ENETRG           0x00001000 // External Event Trigger Enable
#define TC2_CMR1_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC2_CMR1_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC2_CMR1_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC2_CMR1_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC2_CMR1_ACPA_NONE        0x00000000 // None
#define TC2_CMR1_ACPA_SET         0x00010000 // Set
#define TC2_CMR1_ACPA_CLEAR       0x00020000 // Clear
#define TC2_CMR1_ACPA_TOGGLE      0x00030000 // Toggle
#define TC2_CMR1_ACPC_NONE        0x00000000 // None
#define TC2_CMR1_ACPC_SET         0x00040000 // Set
#define TC2_CMR1_ACPC_CLEAR       0x00080000 // Clear
#define TC2_CMR1_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC2_CMR1_AEEVT_NONE       0x00000000 // None
#define TC2_CMR1_AEEVT_SET        0x00100000 // Set
#define TC2_CMR1_AEEVT_CLEAR      0x00200000 // Clear
#define TC2_CMR1_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC2_CMR1_ASWTRG_NONE      0x00000000 // None
#define TC2_CMR1_ASWTRG_SET       0x00400000 // Set
#define TC2_CMR1_ASWTRG_CLEAR     0x00800000 // Clear
#define TC2_CMR1_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC2_CMR1_BCPB_NONE        0x00000000 // None
#define TC2_CMR1_BCPB_SET         0x01000000 // Set
#define TC2_CMR1_BCPB_CLEAR       0x02000000 // Clear
#define TC2_CMR1_BCPB_TOGGLE      0x03000000 // Toggle
#define TC2_CMR1_BCPC_NONE        0x00000000 // None
#define TC2_CMR1_BCPC_SET         0x04000000 // Set
#define TC2_CMR1_BCPC_CLEAR       0x08000000 // Clear
#define TC2_CMR1_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC2_CMR1_BEEVT_NONE       0x00000000 // None
#define TC2_CMR1_BEEVT_SET        0x10000000 // Set
#define TC2_CMR1_BEEVT_CLEAR      0x20000000 // Clear
#define TC2_CMR1_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC2_CMR1_BSWTRG_NONE      0x00000000 // None
#define TC2_CMR1_BSWTRG_SET       0x40000000 // Set
#define TC2_CMR1_BSWTRG_CLEAR     0x80000000 // Clear
#define TC2_CMR1_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC2_SMMR1_GCEN 0x00000001 // Gray Count Enable
#define TC2_SMMR1_DOWN 0x00000002 // Down Count

#define TC2_CV1_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC2_RA1_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC2_RB1_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC2_RC1_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC2_SR1_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC2_SR1_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC2_SR1_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC2_SR1_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC2_SR1_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC2_SR1_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC2_SR1_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC2_SR1_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC2_SR1_CLKSTA 0x00010000 // Clock Enabling Status
#define TC2_SR1_MTIOA  0x00020000 // TIOA Mirror
#define TC2_SR1_MTIOB  0x00040000 // TIOB Mirror

#define TC2_IER1_COVFS 0x00000001 // Counter Overflow
#define TC2_IER1_LOVRS 0x00000002 // Load Overrun
#define TC2_IER1_CPAS  0x00000004 // RA Compare
#define TC2_IER1_CPBS  0x00000008 // RB Compare
#define TC2_IER1_CPCS  0x00000010 // RC Compare
#define TC2_IER1_LDRAS 0x00000020 // RA Loading
#define TC2_IER1_LDRBS 0x00000040 // RB Loading
#define TC2_IER1_ETRGS 0x00000080 // External Trigger

#define TC2_IDR1_COVFS 0x00000001 // Counter Overflow
#define TC2_IDR1_LOVRS 0x00000002 // Load Overrun
#define TC2_IDR1_CPAS  0x00000004 // RA Compare
#define TC2_IDR1_CPBS  0x00000008 // RB Compare
#define TC2_IDR1_CPCS  0x00000010 // RC Compare
#define TC2_IDR1_LDRAS 0x00000020 // RA Loading
#define TC2_IDR1_LDRBS 0x00000040 // RB Loading
#define TC2_IDR1_ETRGS 0x00000080 // External Trigger

#define TC2_IMR1_COVFS 0x00000001 // Counter Overflow
#define TC2_IMR1_LOVRS 0x00000002 // Load Overrun
#define TC2_IMR1_CPAS  0x00000004 // RA Compare
#define TC2_IMR1_CPBS  0x00000008 // RB Compare
#define TC2_IMR1_CPCS  0x00000010 // RC Compare
#define TC2_IMR1_LDRAS 0x00000020 // RA Loading
#define TC2_IMR1_LDRBS 0x00000040 // RB Loading
#define TC2_IMR1_ETRGS 0x00000080 // External Trigger

#define TC2_CCR2_CLKEN  0x00000001 // Counter Clock Enable Command
#define TC2_CCR2_CLKDIS 0x00000002 // Counter Clock Disable Command
#define TC2_CCR2_SWTRG  0x00000004 // Software Trigger Command

#define TC2_CMR2_TCCLKS_TIMER_CLOCK1 0x00000000 // Clock selected: internal MCK/2 clock signal (from PMC)
#define TC2_CMR2_TCCLKS_TIMER_CLOCK2 0x00000001 // Clock selected: internal MCK/8 clock signal (from PMC)
#define TC2_CMR2_TCCLKS_TIMER_CLOCK3 0x00000002 // Clock selected: internal MCK/32 clock signal (from PMC)
#define TC2_CMR2_TCCLKS_TIMER_CLOCK4 0x00000003 // Clock selected: internal MCK/128 clock signal (from PMC)
#define TC2_CMR2_TCCLKS_TIMER_CLOCK5 0x00000004 // Clock selected: internal SLCK clock signal (from PMC)
#define TC2_CMR2_TCCLKS_XC0          0x00000005 // Clock selected: XC0
#define TC2_CMR2_TCCLKS_XC1          0x00000006 // Clock selected: XC1
#define TC2_CMR2_TCCLKS_XC2          0x00000007 // Clock selected: XC2
#define TC2_CMR2_CLKI                0x00000008 // Clock Invert
#define TC2_CMR2_BURST_NONE          0x00000000 // The clock is not gated by an external signal
#define TC2_CMR2_BURST_XC0           0x00000010 // XC0 is ANDed with the selected clock
#define TC2_CMR2_BURST_XC1           0x00000020 // XC1 is ANDed with the selected clock
#define TC2_CMR2_BURST_XC2           0x00000030 // XC2 is ANDed with the selected clock
#define TC2_CMR2_LDBSTOP             0x00000040 // Counter Clock Stopped with RB Loading
#define TC2_CMR2_LDBDIS              0x00000080 // Counter Clock Disable with RB Loading
#define TC2_CMR2_ETRGEDG_NONE        0x00000000 // The clock is not gated by an external signal
#define TC2_CMR2_ETRGEDG_RISING      0x00000100 // Rising edge
#define TC2_CMR2_ETRGEDG_FALLING     0x00000200 // Falling edge
#define TC2_CMR2_ETRGEDG_EDGE        0x00000300 // Each edge
#define TC2_CMR2_ABETRG              0x00000400 // TIOA or TIOB External Trigger Selection
#define TC2_CMR2_CPCTRG              0x00004000 // RC Compare Trigger Enable
#define TC2_CMR2_WAVE                0x00008000 // Waveform Mode
#define TC2_CMR2_LDRA_NONE           0x00000000 // None
#define TC2_CMR2_LDRA_RISING         0x00010000 // Rising edge of TIOA
#define TC2_CMR2_LDRA_FALLING        0x00020000 // Falling edge of TIOA
#define TC2_CMR2_LDRA_EDGE           0x00030000 // Each edge of TIOA
#define TC2_CMR2_LDRB_NONE           0x00000000 // None
#define TC2_CMR2_LDRB_RISING         0x00040000 // Rising edge of TIOA
#define TC2_CMR2_LDRB_FALLING        0x00080000 // Falling edge of TIOA
#define TC2_CMR2_LDRB_EDGE           0x000C0000 // Each edge of TIOA

#define TC2_CMR2_CPCSTOP          0x00000040 // Counter Clock Stopped with RC Compare
#define TC2_CMR2_CPCDIS           0x00000080 // Counter Clock Disable with RC Compare
#define TC2_CMR2_EEVTEDG_NONE     0x00000000 // None
#define TC2_CMR2_EEVTEDG_RISING   0x00000100 // Rising edge
#define TC2_CMR2_EEVTEDG_FALLING  0x00000200 // Falling edge
#define TC2_CMR2_EEVTEDG_EDGE     0x00000300 // Each edge
#define TC2_CMR2_EEVT_TIOB        0x00000000 // TIOB
#define TC2_CMR2_EEVT_XC0         0x00000400 // XC0
#define TC2_CMR2_EEVT_XC1         0x00000800 // XC1
#define TC2_CMR2_EEVT_XC2         0x00000C00 // XC2
#define TC2_CMR2_ENETRG           0x00001000 // External Event Trigger Enable
#define TC2_CMR2_WAVSEL_UP        0x00000000 // UP mode without automatic trigger on RC Compare
#define TC2_CMR2_WAVSEL_UPDOWN    0x00002000 // UPDOWN mode without automatic trigger on RC Compare
#define TC2_CMR2_WAVSEL_UP_RC     0x00004000 // UP mode with automatic trigger on RC Compare
#define TC2_CMR2_WAVSEL_UPDOWN_RC 0x00006000 // UPDOWN mode with automatic trigger on RC Compare
#define TC2_CMR2_ACPA_NONE        0x00000000 // None
#define TC2_CMR2_ACPA_SET         0x00010000 // Set
#define TC2_CMR2_ACPA_CLEAR       0x00020000 // Clear
#define TC2_CMR2_ACPA_TOGGLE      0x00030000 // Toggle
#define TC2_CMR2_ACPC_NONE        0x00000000 // None
#define TC2_CMR2_ACPC_SET         0x00040000 // Set
#define TC2_CMR2_ACPC_CLEAR       0x00080000 // Clear
#define TC2_CMR2_ACPC_TOGGLE      0x000C0000 // Toggle
#define TC2_CMR2_AEEVT_NONE       0x00000000 // None
#define TC2_CMR2_AEEVT_SET        0x00100000 // Set
#define TC2_CMR2_AEEVT_CLEAR      0x00200000 // Clear
#define TC2_CMR2_AEEVT_TOGGLE     0x00300000 // Toggle
#define TC2_CMR2_ASWTRG_NONE      0x00000000 // None
#define TC2_CMR2_ASWTRG_SET       0x00400000 // Set
#define TC2_CMR2_ASWTRG_CLEAR     0x00800000 // Clear
#define TC2_CMR2_ASWTRG_TOGGLE    0x00C00000 // Toggle
#define TC2_CMR2_BCPB_NONE        0x00000000 // None
#define TC2_CMR2_BCPB_SET         0x01000000 // Set
#define TC2_CMR2_BCPB_CLEAR       0x02000000 // Clear
#define TC2_CMR2_BCPB_TOGGLE      0x03000000 // Toggle
#define TC2_CMR2_BCPC_NONE        0x00000000 // None
#define TC2_CMR2_BCPC_SET         0x04000000 // Set
#define TC2_CMR2_BCPC_CLEAR       0x08000000 // Clear
#define TC2_CMR2_BCPC_TOGGLE      0x0C000000 // Toggle
#define TC2_CMR2_BEEVT_NONE       0x00000000 // None
#define TC2_CMR2_BEEVT_SET        0x10000000 // Set
#define TC2_CMR2_BEEVT_CLEAR      0x20000000 // Clear
#define TC2_CMR2_BEEVT_TOGGLE     0x30000000 // Toggle
#define TC2_CMR2_BSWTRG_NONE      0x00000000 // None
#define TC2_CMR2_BSWTRG_SET       0x40000000 // Set
#define TC2_CMR2_BSWTRG_CLEAR     0x80000000 // Clear
#define TC2_CMR2_BSWTRG_TOGGLE    0xC0000000 // Toggle

#define TC2_SMMR2_GCEN 0x00000001 // Gray Count Enable
#define TC2_SMMR2_DOWN 0x00000002 // Down Count

#define TC2_CV2_CV(value) (((value) & 0xFFFFFFFF) << 0) // Counter Value

#define TC2_RA2_RA(value) (((value) & 0xFFFFFFFF) << 0) // Register A

#define TC2_RB2_RB(value) (((value) & 0xFFFFFFFF) << 0) // Register B

#define TC2_RC2_RC(value) (((value) & 0xFFFFFFFF) << 0) // Register C

#define TC2_SR2_COVFS  0x00000001 // Counter Overflow Status (cleared on read)
#define TC2_SR2_LOVRS  0x00000002 // Load Overrun Status (cleared on read)
#define TC2_SR2_CPAS   0x00000004 // RA Compare Status (cleared on read)
#define TC2_SR2_CPBS   0x00000008 // RB Compare Status (cleared on read)
#define TC2_SR2_CPCS   0x00000010 // RC Compare Status (cleared on read)
#define TC2_SR2_LDRAS  0x00000020 // RA Loading Status (cleared on read)
#define TC2_SR2_LDRBS  0x00000040 // RB Loading Status (cleared on read)
#define TC2_SR2_ETRGS  0x00000080 // External Trigger Status (cleared on read)
#define TC2_SR2_CLKSTA 0x00010000 // Clock Enabling Status
#define TC2_SR2_MTIOA  0x00020000 // TIOA Mirror
#define TC2_SR2_MTIOB  0x00040000 // TIOB Mirror

#define TC2_IER2_COVFS 0x00000001 // Counter Overflow
#define TC2_IER2_LOVRS 0x00000002 // Load Overrun
#define TC2_IER2_CPAS  0x00000004 // RA Compare
#define TC2_IER2_CPBS  0x00000008 // RB Compare
#define TC2_IER2_CPCS  0x00000010 // RC Compare
#define TC2_IER2_LDRAS 0x00000020 // RA Loading
#define TC2_IER2_LDRBS 0x00000040 // RB Loading
#define TC2_IER2_ETRGS 0x00000080 // External Trigger

#define TC2_IDR2_COVFS 0x00000001 // Counter Overflow
#define TC2_IDR2_LOVRS 0x00000002 // Load Overrun
#define TC2_IDR2_CPAS  0x00000004 // RA Compare
#define TC2_IDR2_CPBS  0x00000008 // RB Compare
#define TC2_IDR2_CPCS  0x00000010 // RC Compare
#define TC2_IDR2_LDRAS 0x00000020 // RA Loading
#define TC2_IDR2_LDRBS 0x00000040 // RB Loading
#define TC2_IDR2_ETRGS 0x00000080 // External Trigger

#define TC2_IMR2_COVFS 0x00000001 // Counter Overflow
#define TC2_IMR2_LOVRS 0x00000002 // Load Overrun
#define TC2_IMR2_CPAS  0x00000004 // RA Compare
#define TC2_IMR2_CPBS  0x00000008 // RB Compare
#define TC2_IMR2_CPCS  0x00000010 // RC Compare
#define TC2_IMR2_LDRAS 0x00000020 // RA Loading
#define TC2_IMR2_LDRBS 0x00000040 // RB Loading
#define TC2_IMR2_ETRGS 0x00000080 // External Trigger

#define TC2_BCR_SYNC 0x00000001 // Synchro Command

#define TC2_BMR_TC0XC0S_TCLK0  0x00000000               // Signal connected to XC0: TCLK0
#define TC2_BMR_TC0XC0S_TIOA1  0x00000002               // Signal connected to XC0: TIOA1
#define TC2_BMR_TC0XC0S_TIOA2  0x00000003               // Signal connected to XC0: TIOA2
#define TC2_BMR_TC1XC1S_TCLK1  0x00000000               // Signal connected to XC1: TCLK1
#define TC2_BMR_TC1XC1S_TIOA0  0x00000008               // Signal connected to XC1: TIOA0
#define TC2_BMR_TC1XC1S_TIOA2  0x0000000C               // Signal connected to XC1: TIOA2
#define TC2_BMR_TC2XC2S_TCLK2  0x00000000               // Signal connected to XC2: TCLK2
#define TC2_BMR_TC2XC2S_TIOA0  0x00000020               // Signal connected to XC2: TIOA0
#define TC2_BMR_TC2XC2S_TIOA1  0x00000030               // Signal connected to XC2: TIOA1
#define TC2_BMR_QDEN           0x00000100               // Quadrature Decoder Enabled
#define TC2_BMR_POSEN          0x00000200               // Position Enabled
#define TC2_BMR_SPEEDEN        0x00000400               // Speed Enabled
#define TC2_BMR_QDTRANS        0x00000800               // Quadrature Decoding Transparent
#define TC2_BMR_EDGPHA         0x00001000               // Edge on PHA Count Mode
#define TC2_BMR_INVA           0x00002000               // Inverted PHA
#define TC2_BMR_INVB           0x00004000               // Inverted PHB
#define TC2_BMR_INVIDX         0x00008000               // Inverted Index
#define TC2_BMR_SWAP           0x00010000               // Swap PHA and PHB
#define TC2_BMR_IDXPHB         0x00020000               // Index Pin is PHB Pin
#define TC2_BMR_MAXFILT(value) (((value) & 0x3F) << 20) // Maximum Filter

#define TC2_QIER_IDX    0x00000001 // Index
#define TC2_QIER_DIRCHG 0x00000002 // Direction Change
#define TC2_QIER_QERR   0x00000004 // Quadrature Error

#define TC2_QIDR_IDX    0x00000001 // Index
#define TC2_QIDR_DIRCHG 0x00000002 // Direction Change
#define TC2_QIDR_QERR   0x00000004 // Quadrature Error

#define TC2_QIMR_IDX    0x00000001 // Index
#define TC2_QIMR_DIRCHG 0x00000002 // Direction Change
#define TC2_QIMR_QERR   0x00000004 // Quadrature Error

#define TC2_QISR_IDX    0x00000001 // Index
#define TC2_QISR_DIRCHG 0x00000002 // Direction Change
#define TC2_QISR_QERR   0x00000004 // Quadrature Error
#define TC2_QISR_DIR    0x00000100 // Direction

#define TC2_FMR_ENCF0 0x00000001 // Enable Compare Fault Channel 0
#define TC2_FMR_ENCF1 0x00000002 // Enable Compare Fault Channel 1

#define TC2_WPMR_WPEN         0x00000001 // Write Protection Enable
#define TC2_WPMR_WPKEY_PASSWD 0x54494D00 // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0

#define TWI0_CR   (*(volatile unsigned int *)0x4008C000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1124672)
#define TWI0_MMR  (*(volatile unsigned int *)0x4008C004)       // [Master Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1206439)
#define TWI0_SMR  (*(volatile unsigned int *)0x4008C008)       // [Slave Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1206533)
#define TWI0_IADR (*(volatile unsigned int *)0x4008C00C)       // [Internal Address Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1206552)
#define TWI0_CWGR (*(volatile unsigned int *)0x4008C010)       // [Clock Waveform Generator Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1127050)
#define TWI0_SR   (*(const volatile unsigned int *)0x4008C020) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1127463)
#define TWI0_IER  (*(volatile unsigned int *)0x4008C024)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1130123)
#define TWI0_IDR  (*(volatile unsigned int *)0x4008C028)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1131064)
#define TWI0_IMR  (*(const volatile unsigned int *)0x4008C02C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1131251)
#define TWI0_RHR  (*(const volatile unsigned int *)0x4008C030) // [Receive Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1131534)
#define TWI0_THR  (*(volatile unsigned int *)0x4008C034)       // [Transmit Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1131912)
#define TWI0_RPR  (*(volatile unsigned int *)0x4008C100)       // [Receive Pointer Register]()
#define TWI0_RCR  (*(volatile unsigned int *)0x4008C104)       // [Receive Counter Register]()
#define TWI0_TPR  (*(volatile unsigned int *)0x4008C108)       // [Transmit Pointer Register]()
#define TWI0_TCR  (*(volatile unsigned int *)0x4008C10C)       // [Transmit Counter Register]()
#define TWI0_RNPR (*(volatile unsigned int *)0x4008C110)       // [Receive Next Pointer Register]()
#define TWI0_RNCR (*(volatile unsigned int *)0x4008C114)       // [Receive Next Counter Register]()
#define TWI0_TNPR (*(volatile unsigned int *)0x4008C118)       // [Transmit Next Pointer Register]()
#define TWI0_TNCR (*(volatile unsigned int *)0x4008C11C)       // [Transmit Next Counter Register]()
#define TWI0_PTCR (*(volatile unsigned int *)0x4008C120)       // [Transfer Control Register]()
#define TWI0_PTSR (*(const volatile unsigned int *)0x4008C124) // [Transfer Status Register]()

#define TWI0_CR_START 0x00000001 // Send a START Condition
#define TWI0_CR_STOP  0x00000002 // Send a STOP Condition
#define TWI0_CR_MSEN  0x00000004 // TWI Master Mode Enabled
#define TWI0_CR_MSDIS 0x00000008 // TWI Master Mode Disabled
#define TWI0_CR_SVEN  0x00000010 // TWI Slave Mode Enabled
#define TWI0_CR_SVDIS 0x00000020 // TWI Slave Mode Disabled
#define TWI0_CR_QUICK 0x00000040 // SMBUS Quick Command
#define TWI0_CR_SWRST 0x00000080 // Software Reset

#define TWI0_MMR_IADRSZ_NONE   0x00000000               // No internal device address
#define TWI0_MMR_IADRSZ_1_BYTE 0x00000100               // One-byte internal device address
#define TWI0_MMR_IADRSZ_2_BYTE 0x00000200               // Two-byte internal device address
#define TWI0_MMR_IADRSZ_3_BYTE 0x00000300               // Three-byte internal device address
#define TWI0_MMR_MREAD         0x00001000               // Master Read Direction
#define TWI0_MMR_DADR(value)   (((value) & 0x7F) << 16) // Device Address

#define TWI0_SMR_SADR(value) (((value) & 0x7F) << 16) // Slave Address

#define TWI0_IADR_IADR(value) (((value) & 0xFFFFFF) << 0) // Internal Address

#define TWI0_CWGR_CLDIV(value) (((value) & 0xFF) << 0) // Clock Low Divider
#define TWI0_CWGR_CHDIV(value) (((value) & 0xFF) << 8) // Clock High Divider
#define TWI0_CWGR_CKDIV(value) (((value) & 0x7) << 16) // Clock Divider

#define TWI0_SR_TXCOMP 0x00000001 // Transmission Completed (automatically set / reset)
#define TWI0_SR_RXRDY  0x00000002 // Receive Holding Register Ready (automatically set / reset)
#define TWI0_SR_TXRDY  0x00000004 // Transmit Holding Register Ready (automatically set / reset)
#define TWI0_SR_SVREAD 0x00000008 // Slave Read (automatically set / reset)
#define TWI0_SR_SVACC  0x00000010 // Slave Access (automatically set / reset)
#define TWI0_SR_GACC   0x00000020 // General Call Access (clear on read)
#define TWI0_SR_OVRE   0x00000040 // Overrun Error (clear on read)
#define TWI0_SR_NACK   0x00000100 // Not Acknowledged (clear on read)
#define TWI0_SR_ARBLST 0x00000200 // Arbitration Lost (clear on read)
#define TWI0_SR_SCLWS  0x00000400 // Clock Wait State (automatically set / reset)
#define TWI0_SR_EOSACC 0x00000800 // End Of Slave Access (clear on read)
#define TWI0_SR_ENDRX  0x00001000 // End of RX buffer
#define TWI0_SR_ENDTX  0x00002000 // End of TX buffer
#define TWI0_SR_RXBUFF 0x00004000 // RX Buffer Full
#define TWI0_SR_TXBUFE 0x00008000 // TX Buffer Empty

#define TWI0_IER_TXCOMP 0x00000001 // Transmission Completed Interrupt Enable
#define TWI0_IER_RXRDY  0x00000002 // Receive Holding Register Ready Interrupt Enable
#define TWI0_IER_TXRDY  0x00000004 // Transmit Holding Register Ready Interrupt Enable
#define TWI0_IER_SVACC  0x00000010 // Slave Access Interrupt Enable
#define TWI0_IER_GACC   0x00000020 // General Call Access Interrupt Enable
#define TWI0_IER_OVRE   0x00000040 // Overrun Error Interrupt Enable
#define TWI0_IER_NACK   0x00000100 // Not Acknowledge Interrupt Enable
#define TWI0_IER_ARBLST 0x00000200 // Arbitration Lost Interrupt Enable
#define TWI0_IER_SCL_WS 0x00000400 // Clock Wait State Interrupt Enable
#define TWI0_IER_EOSACC 0x00000800 // End Of Slave Access Interrupt Enable
#define TWI0_IER_ENDRX  0x00001000 // End of Receive Buffer Interrupt Enable
#define TWI0_IER_ENDTX  0x00002000 // End of Transmit Buffer Interrupt Enable
#define TWI0_IER_RXBUFF 0x00004000 // Receive Buffer Full Interrupt Enable
#define TWI0_IER_TXBUFE 0x00008000 // Transmit Buffer Empty Interrupt Enable

#define TWI0_IDR_TXCOMP 0x00000001 // Transmission Completed Interrupt Disable
#define TWI0_IDR_RXRDY  0x00000002 // Receive Holding Register Ready Interrupt Disable
#define TWI0_IDR_TXRDY  0x00000004 // Transmit Holding Register Ready Interrupt Disable
#define TWI0_IDR_SVACC  0x00000010 // Slave Access Interrupt Disable
#define TWI0_IDR_GACC   0x00000020 // General Call Access Interrupt Disable
#define TWI0_IDR_OVRE   0x00000040 // Overrun Error Interrupt Disable
#define TWI0_IDR_NACK   0x00000100 // Not Acknowledge Interrupt Disable
#define TWI0_IDR_ARBLST 0x00000200 // Arbitration Lost Interrupt Disable
#define TWI0_IDR_SCL_WS 0x00000400 // Clock Wait State Interrupt Disable
#define TWI0_IDR_EOSACC 0x00000800 // End Of Slave Access Interrupt Disable
#define TWI0_IDR_ENDRX  0x00001000 // End of Receive Buffer Interrupt Disable
#define TWI0_IDR_ENDTX  0x00002000 // End of Transmit Buffer Interrupt Disable
#define TWI0_IDR_RXBUFF 0x00004000 // Receive Buffer Full Interrupt Disable
#define TWI0_IDR_TXBUFE 0x00008000 // Transmit Buffer Empty Interrupt Disable

#define TWI0_IMR_TXCOMP 0x00000001 // Transmission Completed Interrupt Mask
#define TWI0_IMR_RXRDY  0x00000002 // Receive Holding Register Ready Interrupt Mask
#define TWI0_IMR_TXRDY  0x00000004 // Transmit Holding Register Ready Interrupt Mask
#define TWI0_IMR_SVACC  0x00000010 // Slave Access Interrupt Mask
#define TWI0_IMR_GACC   0x00000020 // General Call Access Interrupt Mask
#define TWI0_IMR_OVRE   0x00000040 // Overrun Error Interrupt Mask
#define TWI0_IMR_NACK   0x00000100 // Not Acknowledge Interrupt Mask
#define TWI0_IMR_ARBLST 0x00000200 // Arbitration Lost Interrupt Mask
#define TWI0_IMR_SCL_WS 0x00000400 // Clock Wait State Interrupt Mask
#define TWI0_IMR_EOSACC 0x00000800 // End Of Slave Access Interrupt Mask
#define TWI0_IMR_ENDRX  0x00001000 // End of Receive Buffer Interrupt Mask
#define TWI0_IMR_ENDTX  0x00002000 // End of Transmit Buffer Interrupt Mask
#define TWI0_IMR_RXBUFF 0x00004000 // Receive Buffer Full Interrupt Mask
#define TWI0_IMR_TXBUFE 0x00008000 // Transmit Buffer Empty Interrupt Mask

#define TWI0_RHR_RXDATA(value) (((value) & 0xFF) << 0) // Master or Slave Receive Holding Data

#define TWI0_THR_TXDATA(value) (((value) & 0xFF) << 0) // Master or Slave Transmit Holding Data

#define TWI0_RPR_RXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Pointer Register

#define TWI0_RCR_RXCTR(value) (((value) & 0xFFFF) << 0) // Receive Counter Register

#define TWI0_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define TWI0_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define TWI0_RNPR_RXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Next Pointer

#define TWI0_RNCR_RXNCTR(value) (((value) & 0xFFFF) << 0) // Receive Next Counter

#define TWI0_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define TWI0_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define TWI0_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define TWI0_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define TWI0_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define TWI0_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define TWI0_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define TWI0_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define TWI1_CR   (*(volatile unsigned int *)0x40090000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1124672)
#define TWI1_MMR  (*(volatile unsigned int *)0x40090004)       // [Master Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1206439)
#define TWI1_SMR  (*(volatile unsigned int *)0x40090008)       // [Slave Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1206533)
#define TWI1_IADR (*(volatile unsigned int *)0x4009000C)       // [Internal Address Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1206552)
#define TWI1_CWGR (*(volatile unsigned int *)0x40090010)       // [Clock Waveform Generator Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1127050)
#define TWI1_SR   (*(const volatile unsigned int *)0x40090020) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1127463)
#define TWI1_IER  (*(volatile unsigned int *)0x40090024)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1130123)
#define TWI1_IDR  (*(volatile unsigned int *)0x40090028)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1131064)
#define TWI1_IMR  (*(const volatile unsigned int *)0x4009002C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1131251)
#define TWI1_RHR  (*(const volatile unsigned int *)0x40090030) // [Receive Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1131534)
#define TWI1_THR  (*(volatile unsigned int *)0x40090034)       // [Transmit Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G24.1131912)
#define TWI1_RPR  (*(volatile unsigned int *)0x40090100)       // [Receive Pointer Register]()
#define TWI1_RCR  (*(volatile unsigned int *)0x40090104)       // [Receive Counter Register]()
#define TWI1_TPR  (*(volatile unsigned int *)0x40090108)       // [Transmit Pointer Register]()
#define TWI1_TCR  (*(volatile unsigned int *)0x4009010C)       // [Transmit Counter Register]()
#define TWI1_RNPR (*(volatile unsigned int *)0x40090110)       // [Receive Next Pointer Register]()
#define TWI1_RNCR (*(volatile unsigned int *)0x40090114)       // [Receive Next Counter Register]()
#define TWI1_TNPR (*(volatile unsigned int *)0x40090118)       // [Transmit Next Pointer Register]()
#define TWI1_TNCR (*(volatile unsigned int *)0x4009011C)       // [Transmit Next Counter Register]()
#define TWI1_PTCR (*(volatile unsigned int *)0x40090120)       // [Transfer Control Register]()
#define TWI1_PTSR (*(const volatile unsigned int *)0x40090124) // [Transfer Status Register]()

#define TWI1_CR_START 0x00000001 // Send a START Condition
#define TWI1_CR_STOP  0x00000002 // Send a STOP Condition
#define TWI1_CR_MSEN  0x00000004 // TWI Master Mode Enabled
#define TWI1_CR_MSDIS 0x00000008 // TWI Master Mode Disabled
#define TWI1_CR_SVEN  0x00000010 // TWI Slave Mode Enabled
#define TWI1_CR_SVDIS 0x00000020 // TWI Slave Mode Disabled
#define TWI1_CR_QUICK 0x00000040 // SMBUS Quick Command
#define TWI1_CR_SWRST 0x00000080 // Software Reset

#define TWI1_MMR_IADRSZ_NONE   0x00000000               // No internal device address
#define TWI1_MMR_IADRSZ_1_BYTE 0x00000100               // One-byte internal device address
#define TWI1_MMR_IADRSZ_2_BYTE 0x00000200               // Two-byte internal device address
#define TWI1_MMR_IADRSZ_3_BYTE 0x00000300               // Three-byte internal device address
#define TWI1_MMR_MREAD         0x00001000               // Master Read Direction
#define TWI1_MMR_DADR(value)   (((value) & 0x7F) << 16) // Device Address

#define TWI1_SMR_SADR(value) (((value) & 0x7F) << 16) // Slave Address

#define TWI1_IADR_IADR(value) (((value) & 0xFFFFFF) << 0) // Internal Address

#define TWI1_CWGR_CLDIV(value) (((value) & 0xFF) << 0) // Clock Low Divider
#define TWI1_CWGR_CHDIV(value) (((value) & 0xFF) << 8) // Clock High Divider
#define TWI1_CWGR_CKDIV(value) (((value) & 0x7) << 16) // Clock Divider

#define TWI1_SR_TXCOMP 0x00000001 // Transmission Completed (automatically set / reset)
#define TWI1_SR_RXRDY  0x00000002 // Receive Holding Register Ready (automatically set / reset)
#define TWI1_SR_TXRDY  0x00000004 // Transmit Holding Register Ready (automatically set / reset)
#define TWI1_SR_SVREAD 0x00000008 // Slave Read (automatically set / reset)
#define TWI1_SR_SVACC  0x00000010 // Slave Access (automatically set / reset)
#define TWI1_SR_GACC   0x00000020 // General Call Access (clear on read)
#define TWI1_SR_OVRE   0x00000040 // Overrun Error (clear on read)
#define TWI1_SR_NACK   0x00000100 // Not Acknowledged (clear on read)
#define TWI1_SR_ARBLST 0x00000200 // Arbitration Lost (clear on read)
#define TWI1_SR_SCLWS  0x00000400 // Clock Wait State (automatically set / reset)
#define TWI1_SR_EOSACC 0x00000800 // End Of Slave Access (clear on read)
#define TWI1_SR_ENDRX  0x00001000 // End of RX buffer
#define TWI1_SR_ENDTX  0x00002000 // End of TX buffer
#define TWI1_SR_RXBUFF 0x00004000 // RX Buffer Full
#define TWI1_SR_TXBUFE 0x00008000 // TX Buffer Empty

#define TWI1_IER_TXCOMP 0x00000001 // Transmission Completed Interrupt Enable
#define TWI1_IER_RXRDY  0x00000002 // Receive Holding Register Ready Interrupt Enable
#define TWI1_IER_TXRDY  0x00000004 // Transmit Holding Register Ready Interrupt Enable
#define TWI1_IER_SVACC  0x00000010 // Slave Access Interrupt Enable
#define TWI1_IER_GACC   0x00000020 // General Call Access Interrupt Enable
#define TWI1_IER_OVRE   0x00000040 // Overrun Error Interrupt Enable
#define TWI1_IER_NACK   0x00000100 // Not Acknowledge Interrupt Enable
#define TWI1_IER_ARBLST 0x00000200 // Arbitration Lost Interrupt Enable
#define TWI1_IER_SCL_WS 0x00000400 // Clock Wait State Interrupt Enable
#define TWI1_IER_EOSACC 0x00000800 // End Of Slave Access Interrupt Enable
#define TWI1_IER_ENDRX  0x00001000 // End of Receive Buffer Interrupt Enable
#define TWI1_IER_ENDTX  0x00002000 // End of Transmit Buffer Interrupt Enable
#define TWI1_IER_RXBUFF 0x00004000 // Receive Buffer Full Interrupt Enable
#define TWI1_IER_TXBUFE 0x00008000 // Transmit Buffer Empty Interrupt Enable

#define TWI1_IDR_TXCOMP 0x00000001 // Transmission Completed Interrupt Disable
#define TWI1_IDR_RXRDY  0x00000002 // Receive Holding Register Ready Interrupt Disable
#define TWI1_IDR_TXRDY  0x00000004 // Transmit Holding Register Ready Interrupt Disable
#define TWI1_IDR_SVACC  0x00000010 // Slave Access Interrupt Disable
#define TWI1_IDR_GACC   0x00000020 // General Call Access Interrupt Disable
#define TWI1_IDR_OVRE   0x00000040 // Overrun Error Interrupt Disable
#define TWI1_IDR_NACK   0x00000100 // Not Acknowledge Interrupt Disable
#define TWI1_IDR_ARBLST 0x00000200 // Arbitration Lost Interrupt Disable
#define TWI1_IDR_SCL_WS 0x00000400 // Clock Wait State Interrupt Disable
#define TWI1_IDR_EOSACC 0x00000800 // End Of Slave Access Interrupt Disable
#define TWI1_IDR_ENDRX  0x00001000 // End of Receive Buffer Interrupt Disable
#define TWI1_IDR_ENDTX  0x00002000 // End of Transmit Buffer Interrupt Disable
#define TWI1_IDR_RXBUFF 0x00004000 // Receive Buffer Full Interrupt Disable
#define TWI1_IDR_TXBUFE 0x00008000 // Transmit Buffer Empty Interrupt Disable

#define TWI1_IMR_TXCOMP 0x00000001 // Transmission Completed Interrupt Mask
#define TWI1_IMR_RXRDY  0x00000002 // Receive Holding Register Ready Interrupt Mask
#define TWI1_IMR_TXRDY  0x00000004 // Transmit Holding Register Ready Interrupt Mask
#define TWI1_IMR_SVACC  0x00000010 // Slave Access Interrupt Mask
#define TWI1_IMR_GACC   0x00000020 // General Call Access Interrupt Mask
#define TWI1_IMR_OVRE   0x00000040 // Overrun Error Interrupt Mask
#define TWI1_IMR_NACK   0x00000100 // Not Acknowledge Interrupt Mask
#define TWI1_IMR_ARBLST 0x00000200 // Arbitration Lost Interrupt Mask
#define TWI1_IMR_SCL_WS 0x00000400 // Clock Wait State Interrupt Mask
#define TWI1_IMR_EOSACC 0x00000800 // End Of Slave Access Interrupt Mask
#define TWI1_IMR_ENDRX  0x00001000 // End of Receive Buffer Interrupt Mask
#define TWI1_IMR_ENDTX  0x00002000 // End of Transmit Buffer Interrupt Mask
#define TWI1_IMR_RXBUFF 0x00004000 // Receive Buffer Full Interrupt Mask
#define TWI1_IMR_TXBUFE 0x00008000 // Transmit Buffer Empty Interrupt Mask

#define TWI1_RHR_RXDATA(value) (((value) & 0xFF) << 0) // Master or Slave Receive Holding Data

#define TWI1_THR_TXDATA(value) (((value) & 0xFF) << 0) // Master or Slave Transmit Holding Data

#define TWI1_RPR_RXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Pointer Register

#define TWI1_RCR_RXCTR(value) (((value) & 0xFFFF) << 0) // Receive Counter Register

#define TWI1_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define TWI1_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define TWI1_RNPR_RXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Next Pointer

#define TWI1_RNCR_RXNCTR(value) (((value) & 0xFFFF) << 0) // Receive Next Counter

#define TWI1_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define TWI1_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define TWI1_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define TWI1_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define TWI1_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define TWI1_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define TWI1_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define TWI1_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define PWM_CLK      (*(volatile unsigned int *)0x40094000)       // [PWM Clock Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1093674)
#define PWM_ENA      (*(volatile unsigned int *)0x40094004)       // [PWM Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1425406)
#define PWM_DIS      (*(volatile unsigned int *)0x40094008)       // [PWM Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1090946)
#define PWM_SR       (*(const volatile unsigned int *)0x4009400C) // [PWM Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1070432)
#define PWM_IER1     (*(volatile unsigned int *)0x40094010)       // [PWM Interrupt Enable Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1172242)
#define PWM_IDR1     (*(volatile unsigned int *)0x40094014)       // [PWM Interrupt Disable Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1090954)
#define PWM_IMR1     (*(const volatile unsigned int *)0x40094018) // [PWM Interrupt Mask Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1090316)
#define PWM_ISR1     (*(const volatile unsigned int *)0x4009401C) // [PWM Interrupt Status Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1159090)
#define PWM_SCM      (*(volatile unsigned int *)0x40094020)       // [PWM Sync Channels Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1147771)
#define PWM_SCUC     (*(volatile unsigned int *)0x40094028)       // [PWM Sync Channels Update Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1500115)
#define PWM_SCUP     (*(volatile unsigned int *)0x4009402C)       // [PWM Sync Channels Update Period Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1149254)
#define PWM_SCUPUPD  (*(volatile unsigned int *)0x40094030)       // [PWM Sync Channels Update Period Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1480470)
#define PWM_IER2     (*(volatile unsigned int *)0x40094034)       // [PWM Interrupt Enable Register 2](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1170032)
#define PWM_IDR2     (*(volatile unsigned int *)0x40094038)       // [PWM Interrupt Disable Register 2](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1571768)
#define PWM_IMR2     (*(const volatile unsigned int *)0x4009403C) // [PWM Interrupt Mask Register 2](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1571506)
#define PWM_ISR2     (*(const volatile unsigned int *)0x40094040) // [PWM Interrupt Status Register 2](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1571498)
#define PWM_OOV      (*(volatile unsigned int *)0x40094044)       // [PWM Output Override Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1543569)
#define PWM_OS       (*(volatile unsigned int *)0x40094048)       // [PWM Output Selection Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1151455)
#define PWM_OSS      (*(volatile unsigned int *)0x4009404C)       // [PWM Output Selection Set Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1151721)
#define PWM_OSC      (*(volatile unsigned int *)0x40094050)       // [PWM Output Selection Clear Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1151941)
#define PWM_OSSUPD   (*(volatile unsigned int *)0x40094054)       // [PWM Output Selection Set Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1152201)
#define PWM_OSCUPD   (*(volatile unsigned int *)0x40094058)       // [PWM Output Selection Clear Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1152387)
#define PWM_FMR      (*(volatile unsigned int *)0x4009405C)       // [PWM Fault Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1152849)
#define PWM_FSR      (*(const volatile unsigned int *)0x40094060) // [PWM Fault Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1153210)
#define PWM_FCR      (*(volatile unsigned int *)0x40094064)       // [PWM Fault Clear Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1521816)
#define PWM_FPV      (*(volatile unsigned int *)0x40094068)       // [PWM Fault Protection Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1153722)
#define PWM_FPE1     (*(volatile unsigned int *)0x4009406C)       // [PWM Fault Protection Enable Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1154046)
#define PWM_FPE2     (*(volatile unsigned int *)0x40094070)       // [PWM Fault Protection Enable Register 2](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1411006)
#define PWM_ELMR0    (*(volatile unsigned int *)0x40094080)       // [PWM Event Line 0 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1544766)
#define PWM_ELMR1    (*(volatile unsigned int *)0x40094080)       // [PWM Event Line 0 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1544766)
#define PWM_SMMR     (*(volatile unsigned int *)0x400940B0)       // [PWM Stepper Motor Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1838077)
#define PWM_WPCR     (*(volatile unsigned int *)0x400940E4)       // [PWM Write Protect Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1838219)
#define PWM_WPSR     (*(const volatile unsigned int *)0x400940E8) // [PWM Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1279512)
#define PWM_CMPV0    (*(volatile unsigned int *)0x40094130)       // [PWM Comparison 0 Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1560657)
#define PWM_CMPVUPD0 (*(volatile unsigned int *)0x40094134)       // [PWM Comparison 0 Value Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1567469)
#define PWM_CMPM0    (*(volatile unsigned int *)0x40094138)       // [PWM Comparison 0 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677309)
#define PWM_CMPMUPD0 (*(volatile unsigned int *)0x4009413C)       // [PWM Comparison 0 Mode Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677504)
#define PWM_CMPV1    (*(volatile unsigned int *)0x40094140)       // [PWM Comparison 1 Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1560657)
#define PWM_CMPVUPD1 (*(volatile unsigned int *)0x40094144)       // [PWM Comparison 1 Value Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1567469)
#define PWM_CMPM1    (*(volatile unsigned int *)0x40094148)       // [PWM Comparison 1 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677309)
#define PWM_CMPMUPD1 (*(volatile unsigned int *)0x4009414C)       // [PWM Comparison 1 Mode Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677504)
#define PWM_CMPV2    (*(volatile unsigned int *)0x40094150)       // [PWM Comparison 2 Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1560657)
#define PWM_CMPVUPD2 (*(volatile unsigned int *)0x40094154)       // [PWM Comparison 2 Value Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1567469)
#define PWM_CMPM2    (*(volatile unsigned int *)0x40094158)       // [PWM Comparison 2 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677309)
#define PWM_CMPMUPD2 (*(volatile unsigned int *)0x4009415C)       // [PWM Comparison 2 Mode Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677504)
#define PWM_CMPV3    (*(volatile unsigned int *)0x40094160)       // [PWM Comparison 3 Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1560657)
#define PWM_CMPVUPD3 (*(volatile unsigned int *)0x40094164)       // [PWM Comparison 3 Value Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1567469)
#define PWM_CMPM3    (*(volatile unsigned int *)0x40094168)       // [PWM Comparison 3 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677309)
#define PWM_CMPMUPD3 (*(volatile unsigned int *)0x4009416C)       // [PWM Comparison 3 Mode Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677504)
#define PWM_CMPV4    (*(volatile unsigned int *)0x40094170)       // [PWM Comparison 4 Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1560657)
#define PWM_CMPVUPD4 (*(volatile unsigned int *)0x40094174)       // [PWM Comparison 4 Value Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1567469)
#define PWM_CMPM4    (*(volatile unsigned int *)0x40094178)       // [PWM Comparison 4 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677309)
#define PWM_CMPMUPD4 (*(volatile unsigned int *)0x4009417C)       // [PWM Comparison 4 Mode Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677504)
#define PWM_CMPV5    (*(volatile unsigned int *)0x40094180)       // [PWM Comparison 5 Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1560657)
#define PWM_CMPVUPD5 (*(volatile unsigned int *)0x40094184)       // [PWM Comparison 5 Value Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1567469)
#define PWM_CMPM5    (*(volatile unsigned int *)0x40094188)       // [PWM Comparison 5 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677309)
#define PWM_CMPMUPD5 (*(volatile unsigned int *)0x4009418C)       // [PWM Comparison 5 Mode Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677504)
#define PWM_CMPV6    (*(volatile unsigned int *)0x40094190)       // [PWM Comparison 6 Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1560657)
#define PWM_CMPVUPD6 (*(volatile unsigned int *)0x40094194)       // [PWM Comparison 6 Value Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1567469)
#define PWM_CMPM6    (*(volatile unsigned int *)0x40094198)       // [PWM Comparison 6 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677309)
#define PWM_CMPMUPD6 (*(volatile unsigned int *)0x4009419C)       // [PWM Comparison 6 Mode Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677504)
#define PWM_CMPV7    (*(volatile unsigned int *)0x400941A0)       // [PWM Comparison 7 Value Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1560657)
#define PWM_CMPVUPD7 (*(volatile unsigned int *)0x400941A4)       // [PWM Comparison 7 Value Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1567469)
#define PWM_CMPM7    (*(volatile unsigned int *)0x400941A8)       // [PWM Comparison 7 Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677309)
#define PWM_CMPMUPD7 (*(volatile unsigned int *)0x400941AC)       // [PWM Comparison 7 Mode Update Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1677504)
#define PWM_CMR0     (*(volatile unsigned int *)0x40094200)       // [PWM Channel Mode Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1841756)
#define PWM_CDTY0    (*(volatile unsigned int *)0x40094204)       // [PWM Channel Duty Cycle Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155535)
#define PWM_CDTYUPD0 (*(volatile unsigned int *)0x40094208)       // [PWM Channel Duty Cycle Update Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735188)
#define PWM_CPRD0    (*(volatile unsigned int *)0x4009420C)       // [PWM Channel Period Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1675329)
#define PWM_CPRDUPD0 (*(volatile unsigned int *)0x40094210)       // [PWM Channel Period Update Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735709)
#define PWM_CCNT0    (*(const volatile unsigned int *)0x40094214) // [PWM Channel Counter Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1127465)
#define PWM_DT0      (*(volatile unsigned int *)0x40094218)       // [PWM Channel Dead Time Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155164)
#define PWM_DTUPD0   (*(volatile unsigned int *)0x4009421C)       // [PWM Channel Dead Time Update Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1878275)
#define PWM_CMR1     (*(volatile unsigned int *)0x40094220)       // [PWM Channel Mode Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1841756)
#define PWM_CDTY1    (*(volatile unsigned int *)0x40094224)       // [PWM Channel Duty Cycle Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155535)
#define PWM_CDTYUPD1 (*(volatile unsigned int *)0x40094228)       // [PWM Channel Duty Cycle Update Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735188)
#define PWM_CPRD1    (*(volatile unsigned int *)0x4009422C)       // [PWM Channel Period Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1675329)
#define PWM_CPRDUPD1 (*(volatile unsigned int *)0x40094230)       // [PWM Channel Period Update Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735709)
#define PWM_CCNT1    (*(const volatile unsigned int *)0x40094234) // [PWM Channel Counter Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1127465)
#define PWM_DT1      (*(volatile unsigned int *)0x40094238)       // [PWM Channel Dead Time Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155164)
#define PWM_DTUPD1   (*(volatile unsigned int *)0x4009423C)       // [PWM Channel Dead Time Update Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1878275)
#define PWM_CMR2     (*(volatile unsigned int *)0x40094240)       // [PWM Channel Mode Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1841756)
#define PWM_CDTY2    (*(volatile unsigned int *)0x40094244)       // [PWM Channel Duty Cycle Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155535)
#define PWM_CDTYUPD2 (*(volatile unsigned int *)0x40094248)       // [PWM Channel Duty Cycle Update Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735188)
#define PWM_CPRD2    (*(volatile unsigned int *)0x4009424C)       // [PWM Channel Period Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1675329)
#define PWM_CPRDUPD2 (*(volatile unsigned int *)0x40094250)       // [PWM Channel Period Update Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735709)
#define PWM_CCNT2    (*(const volatile unsigned int *)0x40094254) // [PWM Channel Counter Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1127465)
#define PWM_DT2      (*(volatile unsigned int *)0x40094258)       // [PWM Channel Dead Time Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155164)
#define PWM_DTUPD2   (*(volatile unsigned int *)0x4009425C)       // [PWM Channel Dead Time Update Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1878275)
#define PWM_CMR3     (*(volatile unsigned int *)0x40094260)       // [PWM Channel Mode Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1841756)
#define PWM_CDTY3    (*(volatile unsigned int *)0x40094264)       // [PWM Channel Duty Cycle Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155535)
#define PWM_CDTYUPD3 (*(volatile unsigned int *)0x40094268)       // [PWM Channel Duty Cycle Update Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735188)
#define PWM_CPRD3    (*(volatile unsigned int *)0x4009426C)       // [PWM Channel Period Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1675329)
#define PWM_CPRDUPD3 (*(volatile unsigned int *)0x40094270)       // [PWM Channel Period Update Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735709)
#define PWM_CCNT3    (*(const volatile unsigned int *)0x40094274) // [PWM Channel Counter Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1127465)
#define PWM_DT3      (*(volatile unsigned int *)0x40094278)       // [PWM Channel Dead Time Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155164)
#define PWM_DTUPD3   (*(volatile unsigned int *)0x4009427C)       // [PWM Channel Dead Time Update Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1878275)
#define PWM_CMR4     (*(volatile unsigned int *)0x40094280)       // [PWM Channel Mode Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1841756)
#define PWM_CDTY4    (*(volatile unsigned int *)0x40094284)       // [PWM Channel Duty Cycle Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155535)
#define PWM_CDTYUPD4 (*(volatile unsigned int *)0x40094288)       // [PWM Channel Duty Cycle Update Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735188)
#define PWM_CPRD4    (*(volatile unsigned int *)0x4009428C)       // [PWM Channel Period Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1675329)
#define PWM_CPRDUPD4 (*(volatile unsigned int *)0x40094290)       // [PWM Channel Period Update Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735709)
#define PWM_CCNT4    (*(const volatile unsigned int *)0x40094294) // [PWM Channel Counter Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1127465)
#define PWM_DT4      (*(volatile unsigned int *)0x40094298)       // [PWM Channel Dead Time Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155164)
#define PWM_DTUPD4   (*(volatile unsigned int *)0x4009429C)       // [PWM Channel Dead Time Update Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1878275)
#define PWM_CMR5     (*(volatile unsigned int *)0x400942A0)       // [PWM Channel Mode Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1841756)
#define PWM_CDTY5    (*(volatile unsigned int *)0x400942A4)       // [PWM Channel Duty Cycle Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155535)
#define PWM_CDTYUPD5 (*(volatile unsigned int *)0x400942A8)       // [PWM Channel Duty Cycle Update Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735188)
#define PWM_CPRD5    (*(volatile unsigned int *)0x400942AC)       // [PWM Channel Period Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1675329)
#define PWM_CPRDUPD5 (*(volatile unsigned int *)0x400942B0)       // [PWM Channel Period Update Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735709)
#define PWM_CCNT5    (*(const volatile unsigned int *)0x400942B4) // [PWM Channel Counter Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1127465)
#define PWM_DT5      (*(volatile unsigned int *)0x400942B8)       // [PWM Channel Dead Time Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155164)
#define PWM_DTUPD5   (*(volatile unsigned int *)0x400942BC)       // [PWM Channel Dead Time Update Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1878275)
#define PWM_CMR6     (*(volatile unsigned int *)0x400942C0)       // [PWM Channel Mode Register (ch_num = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1841756)
#define PWM_CDTY6    (*(volatile unsigned int *)0x400942C4)       // [PWM Channel Duty Cycle Register (ch_num = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155535)
#define PWM_CDTYUPD6 (*(volatile unsigned int *)0x400942C8)       // [PWM Channel Duty Cycle Update Register (ch_num = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735188)
#define PWM_CPRD6    (*(volatile unsigned int *)0x400942CC)       // [PWM Channel Period Register (ch_num = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1675329)
#define PWM_CPRDUPD6 (*(volatile unsigned int *)0x400942D0)       // [PWM Channel Period Update Register (ch_num = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735709)
#define PWM_CCNT6    (*(const volatile unsigned int *)0x400942D4) // [PWM Channel Counter Register (ch_num = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1127465)
#define PWM_DT6      (*(volatile unsigned int *)0x400942D8)       // [PWM Channel Dead Time Register (ch_num = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155164)
#define PWM_DTUPD6   (*(volatile unsigned int *)0x400942DC)       // [PWM Channel Dead Time Update Register (ch_num = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1878275)
#define PWM_CMR7     (*(volatile unsigned int *)0x400942E0)       // [PWM Channel Mode Register (ch_num = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1841756)
#define PWM_CDTY7    (*(volatile unsigned int *)0x400942E4)       // [PWM Channel Duty Cycle Register (ch_num = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155535)
#define PWM_CDTYUPD7 (*(volatile unsigned int *)0x400942E8)       // [PWM Channel Duty Cycle Update Register (ch_num = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735188)
#define PWM_CPRD7    (*(volatile unsigned int *)0x400942EC)       // [PWM Channel Period Register (ch_num = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1675329)
#define PWM_CPRDUPD7 (*(volatile unsigned int *)0x400942F0)       // [PWM Channel Period Update Register (ch_num = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1735709)
#define PWM_CCNT7    (*(const volatile unsigned int *)0x400942F4) // [PWM Channel Counter Register (ch_num = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1127465)
#define PWM_DT7      (*(volatile unsigned int *)0x400942F8)       // [PWM Channel Dead Time Register (ch_num = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1155164)
#define PWM_DTUPD7   (*(volatile unsigned int *)0x400942FC)       // [PWM Channel Dead Time Update Register (ch_num = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G29.1878275)
#define PWM_TPR      (*(volatile unsigned int *)0x40094108)       // [Transmit Pointer Register]()
#define PWM_TCR      (*(volatile unsigned int *)0x4009410C)       // [Transmit Counter Register]()
#define PWM_TNPR     (*(volatile unsigned int *)0x40094118)       // [Transmit Next Pointer Register]()
#define PWM_TNCR     (*(volatile unsigned int *)0x4009411C)       // [Transmit Next Counter Register]()
#define PWM_PTCR     (*(volatile unsigned int *)0x40094120)       // [Transfer Control Register]()
#define PWM_PTSR     (*(const volatile unsigned int *)0x40094124) // [Transfer Status Register]()

#define PWM_CLK_DIVA(value) (((value) & 0xFF) << 0)  // CLKA, CLKB Divide Factor
#define PWM_CLK_PREA(value) (((value) & 0xF) << 8)   // CLKA, CLKB Source Clock Selection
#define PWM_CLK_DIVB(value) (((value) & 0xFF) << 16) // CLKA, CLKB Divide Factor
#define PWM_CLK_PREB(value) (((value) & 0xF) << 24)  // CLKA, CLKB Source Clock Selection

#define PWM_ENA_CHID0 0x00000001 // Channel ID
#define PWM_ENA_CHID1 0x00000002 // Channel ID
#define PWM_ENA_CHID2 0x00000004 // Channel ID
#define PWM_ENA_CHID3 0x00000008 // Channel ID
#define PWM_ENA_CHID4 0x00000010 // Channel ID
#define PWM_ENA_CHID5 0x00000020 // Channel ID
#define PWM_ENA_CHID6 0x00000040 // Channel ID
#define PWM_ENA_CHID7 0x00000080 // Channel ID

#define PWM_DIS_CHID0 0x00000001 // Channel ID
#define PWM_DIS_CHID1 0x00000002 // Channel ID
#define PWM_DIS_CHID2 0x00000004 // Channel ID
#define PWM_DIS_CHID3 0x00000008 // Channel ID
#define PWM_DIS_CHID4 0x00000010 // Channel ID
#define PWM_DIS_CHID5 0x00000020 // Channel ID
#define PWM_DIS_CHID6 0x00000040 // Channel ID
#define PWM_DIS_CHID7 0x00000080 // Channel ID

#define PWM_SR_CHID0 0x00000001 // Channel ID
#define PWM_SR_CHID1 0x00000002 // Channel ID
#define PWM_SR_CHID2 0x00000004 // Channel ID
#define PWM_SR_CHID3 0x00000008 // Channel ID
#define PWM_SR_CHID4 0x00000010 // Channel ID
#define PWM_SR_CHID5 0x00000020 // Channel ID
#define PWM_SR_CHID6 0x00000040 // Channel ID
#define PWM_SR_CHID7 0x00000080 // Channel ID

#define PWM_IER1_CHID0  0x00000001 // Counter Event on Channel 0 Interrupt Enable
#define PWM_IER1_CHID1  0x00000002 // Counter Event on Channel 1 Interrupt Enable
#define PWM_IER1_CHID2  0x00000004 // Counter Event on Channel 2 Interrupt Enable
#define PWM_IER1_CHID3  0x00000008 // Counter Event on Channel 3 Interrupt Enable
#define PWM_IER1_CHID4  0x00000010 // Counter Event on Channel 4 Interrupt Enable
#define PWM_IER1_CHID5  0x00000020 // Counter Event on Channel 5 Interrupt Enable
#define PWM_IER1_CHID6  0x00000040 // Counter Event on Channel 6 Interrupt Enable
#define PWM_IER1_CHID7  0x00000080 // Counter Event on Channel 7 Interrupt Enable
#define PWM_IER1_FCHID0 0x00010000 // Fault Protection Trigger on Channel 0 Interrupt Enable
#define PWM_IER1_FCHID1 0x00020000 // Fault Protection Trigger on Channel 1 Interrupt Enable
#define PWM_IER1_FCHID2 0x00040000 // Fault Protection Trigger on Channel 2 Interrupt Enable
#define PWM_IER1_FCHID3 0x00080000 // Fault Protection Trigger on Channel 3 Interrupt Enable
#define PWM_IER1_FCHID4 0x00100000 // Fault Protection Trigger on Channel 4 Interrupt Enable
#define PWM_IER1_FCHID5 0x00200000 // Fault Protection Trigger on Channel 5 Interrupt Enable
#define PWM_IER1_FCHID6 0x00400000 // Fault Protection Trigger on Channel 6 Interrupt Enable
#define PWM_IER1_FCHID7 0x00800000 // Fault Protection Trigger on Channel 7 Interrupt Enable

#define PWM_IDR1_CHID0  0x00000001 // Counter Event on Channel 0 Interrupt Disable
#define PWM_IDR1_CHID1  0x00000002 // Counter Event on Channel 1 Interrupt Disable
#define PWM_IDR1_CHID2  0x00000004 // Counter Event on Channel 2 Interrupt Disable
#define PWM_IDR1_CHID3  0x00000008 // Counter Event on Channel 3 Interrupt Disable
#define PWM_IDR1_CHID4  0x00000010 // Counter Event on Channel 4 Interrupt Disable
#define PWM_IDR1_CHID5  0x00000020 // Counter Event on Channel 5 Interrupt Disable
#define PWM_IDR1_CHID6  0x00000040 // Counter Event on Channel 6 Interrupt Disable
#define PWM_IDR1_CHID7  0x00000080 // Counter Event on Channel 7 Interrupt Disable
#define PWM_IDR1_FCHID0 0x00010000 // Fault Protection Trigger on Channel 0 Interrupt Disable
#define PWM_IDR1_FCHID1 0x00020000 // Fault Protection Trigger on Channel 1 Interrupt Disable
#define PWM_IDR1_FCHID2 0x00040000 // Fault Protection Trigger on Channel 2 Interrupt Disable
#define PWM_IDR1_FCHID3 0x00080000 // Fault Protection Trigger on Channel 3 Interrupt Disable
#define PWM_IDR1_FCHID4 0x00100000 // Fault Protection Trigger on Channel 4 Interrupt Disable
#define PWM_IDR1_FCHID5 0x00200000 // Fault Protection Trigger on Channel 5 Interrupt Disable
#define PWM_IDR1_FCHID6 0x00400000 // Fault Protection Trigger on Channel 6 Interrupt Disable
#define PWM_IDR1_FCHID7 0x00800000 // Fault Protection Trigger on Channel 7 Interrupt Disable

#define PWM_IMR1_CHID0  0x00000001 // Counter Event on Channel 0 Interrupt Mask
#define PWM_IMR1_CHID1  0x00000002 // Counter Event on Channel 1 Interrupt Mask
#define PWM_IMR1_CHID2  0x00000004 // Counter Event on Channel 2 Interrupt Mask
#define PWM_IMR1_CHID3  0x00000008 // Counter Event on Channel 3 Interrupt Mask
#define PWM_IMR1_CHID4  0x00000010 // Counter Event on Channel 4 Interrupt Mask
#define PWM_IMR1_CHID5  0x00000020 // Counter Event on Channel 5 Interrupt Mask
#define PWM_IMR1_CHID6  0x00000040 // Counter Event on Channel 6 Interrupt Mask
#define PWM_IMR1_CHID7  0x00000080 // Counter Event on Channel 7 Interrupt Mask
#define PWM_IMR1_FCHID0 0x00010000 // Fault Protection Trigger on Channel 0 Interrupt Mask
#define PWM_IMR1_FCHID1 0x00020000 // Fault Protection Trigger on Channel 1 Interrupt Mask
#define PWM_IMR1_FCHID2 0x00040000 // Fault Protection Trigger on Channel 2 Interrupt Mask
#define PWM_IMR1_FCHID3 0x00080000 // Fault Protection Trigger on Channel 3 Interrupt Mask
#define PWM_IMR1_FCHID4 0x00100000 // Fault Protection Trigger on Channel 4 Interrupt Mask
#define PWM_IMR1_FCHID5 0x00200000 // Fault Protection Trigger on Channel 5 Interrupt Mask
#define PWM_IMR1_FCHID6 0x00400000 // Fault Protection Trigger on Channel 6 Interrupt Mask
#define PWM_IMR1_FCHID7 0x00800000 // Fault Protection Trigger on Channel 7 Interrupt Mask

#define PWM_ISR1_CHID0  0x00000001 // Counter Event on Channel 0
#define PWM_ISR1_CHID1  0x00000002 // Counter Event on Channel 1
#define PWM_ISR1_CHID2  0x00000004 // Counter Event on Channel 2
#define PWM_ISR1_CHID3  0x00000008 // Counter Event on Channel 3
#define PWM_ISR1_CHID4  0x00000010 // Counter Event on Channel 4
#define PWM_ISR1_CHID5  0x00000020 // Counter Event on Channel 5
#define PWM_ISR1_CHID6  0x00000040 // Counter Event on Channel 6
#define PWM_ISR1_CHID7  0x00000080 // Counter Event on Channel 7
#define PWM_ISR1_FCHID0 0x00010000 // Fault Protection Trigger on Channel 0
#define PWM_ISR1_FCHID1 0x00020000 // Fault Protection Trigger on Channel 1
#define PWM_ISR1_FCHID2 0x00040000 // Fault Protection Trigger on Channel 2
#define PWM_ISR1_FCHID3 0x00080000 // Fault Protection Trigger on Channel 3
#define PWM_ISR1_FCHID4 0x00100000 // Fault Protection Trigger on Channel 4
#define PWM_ISR1_FCHID5 0x00200000 // Fault Protection Trigger on Channel 5
#define PWM_ISR1_FCHID6 0x00400000 // Fault Protection Trigger on Channel 6
#define PWM_ISR1_FCHID7 0x00800000 // Fault Protection Trigger on Channel 7

#define PWM_SCM_SYNC0        0x00000001              // Synchronous Channel 0
#define PWM_SCM_SYNC1        0x00000002              // Synchronous Channel 1
#define PWM_SCM_SYNC2        0x00000004              // Synchronous Channel 2
#define PWM_SCM_SYNC3        0x00000008              // Synchronous Channel 3
#define PWM_SCM_SYNC4        0x00000010              // Synchronous Channel 4
#define PWM_SCM_SYNC5        0x00000020              // Synchronous Channel 5
#define PWM_SCM_SYNC6        0x00000040              // Synchronous Channel 6
#define PWM_SCM_SYNC7        0x00000080              // Synchronous Channel 7
#define PWM_SCM_UPDM_MODE0   0x00000000              // Manual write of double buffer registers and manual update of synchronous channels
#define PWM_SCM_UPDM_MODE1   0x00010000              // Manual write of double buffer registers and automatic update of synchronous channels
#define PWM_SCM_UPDM_MODE2   0x00020000              // Automatic write of duty-cycle update registers by the PDC and automatic update of synchronous channels
#define PWM_SCM_PTRM         0x00100000              // PDC Transfer Request Mode
#define PWM_SCM_PTRCS(value) (((value) & 0x7) << 21) // PDC Transfer Request Comparison Selection

#define PWM_SCUC_UPDULOCK 0x00000001 // Synchronous Channels Update Unlock

#define PWM_SCUP_UPR(value)    (((value) & 0xF) << 0) // Update Period
#define PWM_SCUP_UPRCNT(value) (((value) & 0xF) << 4) // Update Period Counter

#define PWM_SCUPUPD_UPRUPD(value) (((value) & 0xF) << 0) // Update Period Update

#define PWM_IER2_WRDY   0x00000001 // Write Ready for Synchronous Channels Update Interrupt Enable
#define PWM_IER2_ENDTX  0x00000002 // PDC End of TX Buffer Interrupt Enable
#define PWM_IER2_TXBUFE 0x00000004 // PDC TX Buffer Empty Interrupt Enable
#define PWM_IER2_UNRE   0x00000008 // Synchronous Channels Update Underrun Error Interrupt Enable
#define PWM_IER2_CMPM0  0x00000100 // Comparison 0 Match Interrupt Enable
#define PWM_IER2_CMPM1  0x00000200 // Comparison 1 Match Interrupt Enable
#define PWM_IER2_CMPM2  0x00000400 // Comparison 2 Match Interrupt Enable
#define PWM_IER2_CMPM3  0x00000800 // Comparison 3 Match Interrupt Enable
#define PWM_IER2_CMPM4  0x00001000 // Comparison 4 Match Interrupt Enable
#define PWM_IER2_CMPM5  0x00002000 // Comparison 5 Match Interrupt Enable
#define PWM_IER2_CMPM6  0x00004000 // Comparison 6 Match Interrupt Enable
#define PWM_IER2_CMPM7  0x00008000 // Comparison 7 Match Interrupt Enable
#define PWM_IER2_CMPU0  0x00010000 // Comparison 0 Update Interrupt Enable
#define PWM_IER2_CMPU1  0x00020000 // Comparison 1 Update Interrupt Enable
#define PWM_IER2_CMPU2  0x00040000 // Comparison 2 Update Interrupt Enable
#define PWM_IER2_CMPU3  0x00080000 // Comparison 3 Update Interrupt Enable
#define PWM_IER2_CMPU4  0x00100000 // Comparison 4 Update Interrupt Enable
#define PWM_IER2_CMPU5  0x00200000 // Comparison 5 Update Interrupt Enable
#define PWM_IER2_CMPU6  0x00400000 // Comparison 6 Update Interrupt Enable
#define PWM_IER2_CMPU7  0x00800000 // Comparison 7 Update Interrupt Enable

#define PWM_IDR2_WRDY   0x00000001 // Write Ready for Synchronous Channels Update Interrupt Disable
#define PWM_IDR2_ENDTX  0x00000002 // PDC End of TX Buffer Interrupt Disable
#define PWM_IDR2_TXBUFE 0x00000004 // PDC TX Buffer Empty Interrupt Disable
#define PWM_IDR2_UNRE   0x00000008 // Synchronous Channels Update Underrun Error Interrupt Disable
#define PWM_IDR2_CMPM0  0x00000100 // Comparison 0 Match Interrupt Disable
#define PWM_IDR2_CMPM1  0x00000200 // Comparison 1 Match Interrupt Disable
#define PWM_IDR2_CMPM2  0x00000400 // Comparison 2 Match Interrupt Disable
#define PWM_IDR2_CMPM3  0x00000800 // Comparison 3 Match Interrupt Disable
#define PWM_IDR2_CMPM4  0x00001000 // Comparison 4 Match Interrupt Disable
#define PWM_IDR2_CMPM5  0x00002000 // Comparison 5 Match Interrupt Disable
#define PWM_IDR2_CMPM6  0x00004000 // Comparison 6 Match Interrupt Disable
#define PWM_IDR2_CMPM7  0x00008000 // Comparison 7 Match Interrupt Disable
#define PWM_IDR2_CMPU0  0x00010000 // Comparison 0 Update Interrupt Disable
#define PWM_IDR2_CMPU1  0x00020000 // Comparison 1 Update Interrupt Disable
#define PWM_IDR2_CMPU2  0x00040000 // Comparison 2 Update Interrupt Disable
#define PWM_IDR2_CMPU3  0x00080000 // Comparison 3 Update Interrupt Disable
#define PWM_IDR2_CMPU4  0x00100000 // Comparison 4 Update Interrupt Disable
#define PWM_IDR2_CMPU5  0x00200000 // Comparison 5 Update Interrupt Disable
#define PWM_IDR2_CMPU6  0x00400000 // Comparison 6 Update Interrupt Disable
#define PWM_IDR2_CMPU7  0x00800000 // Comparison 7 Update Interrupt Disable

#define PWM_IMR2_WRDY   0x00000001 // Write Ready for Synchronous Channels Update Interrupt Mask
#define PWM_IMR2_ENDTX  0x00000002 // PDC End of TX Buffer Interrupt Mask
#define PWM_IMR2_TXBUFE 0x00000004 // PDC TX Buffer Empty Interrupt Mask
#define PWM_IMR2_UNRE   0x00000008 // Synchronous Channels Update Underrun Error Interrupt Mask
#define PWM_IMR2_CMPM0  0x00000100 // Comparison 0 Match Interrupt Mask
#define PWM_IMR2_CMPM1  0x00000200 // Comparison 1 Match Interrupt Mask
#define PWM_IMR2_CMPM2  0x00000400 // Comparison 2 Match Interrupt Mask
#define PWM_IMR2_CMPM3  0x00000800 // Comparison 3 Match Interrupt Mask
#define PWM_IMR2_CMPM4  0x00001000 // Comparison 4 Match Interrupt Mask
#define PWM_IMR2_CMPM5  0x00002000 // Comparison 5 Match Interrupt Mask
#define PWM_IMR2_CMPM6  0x00004000 // Comparison 6 Match Interrupt Mask
#define PWM_IMR2_CMPM7  0x00008000 // Comparison 7 Match Interrupt Mask
#define PWM_IMR2_CMPU0  0x00010000 // Comparison 0 Update Interrupt Mask
#define PWM_IMR2_CMPU1  0x00020000 // Comparison 1 Update Interrupt Mask
#define PWM_IMR2_CMPU2  0x00040000 // Comparison 2 Update Interrupt Mask
#define PWM_IMR2_CMPU3  0x00080000 // Comparison 3 Update Interrupt Mask
#define PWM_IMR2_CMPU4  0x00100000 // Comparison 4 Update Interrupt Mask
#define PWM_IMR2_CMPU5  0x00200000 // Comparison 5 Update Interrupt Mask
#define PWM_IMR2_CMPU6  0x00400000 // Comparison 6 Update Interrupt Mask
#define PWM_IMR2_CMPU7  0x00800000 // Comparison 7 Update Interrupt Mask

#define PWM_ISR2_WRDY   0x00000001 // Write Ready for Synchronous Channels Update
#define PWM_ISR2_ENDTX  0x00000002 // PDC End of TX Buffer
#define PWM_ISR2_TXBUFE 0x00000004 // PDC TX Buffer Empty
#define PWM_ISR2_UNRE   0x00000008 // Synchronous Channels Update Underrun Error
#define PWM_ISR2_CMPM0  0x00000100 // Comparison 0 Match
#define PWM_ISR2_CMPM1  0x00000200 // Comparison 1 Match
#define PWM_ISR2_CMPM2  0x00000400 // Comparison 2 Match
#define PWM_ISR2_CMPM3  0x00000800 // Comparison 3 Match
#define PWM_ISR2_CMPM4  0x00001000 // Comparison 4 Match
#define PWM_ISR2_CMPM5  0x00002000 // Comparison 5 Match
#define PWM_ISR2_CMPM6  0x00004000 // Comparison 6 Match
#define PWM_ISR2_CMPM7  0x00008000 // Comparison 7 Match
#define PWM_ISR2_CMPU0  0x00010000 // Comparison 0 Update
#define PWM_ISR2_CMPU1  0x00020000 // Comparison 1 Update
#define PWM_ISR2_CMPU2  0x00040000 // Comparison 2 Update
#define PWM_ISR2_CMPU3  0x00080000 // Comparison 3 Update
#define PWM_ISR2_CMPU4  0x00100000 // Comparison 4 Update
#define PWM_ISR2_CMPU5  0x00200000 // Comparison 5 Update
#define PWM_ISR2_CMPU6  0x00400000 // Comparison 6 Update
#define PWM_ISR2_CMPU7  0x00800000 // Comparison 7 Update

#define PWM_OOV_OOVH0 0x00000001 // Output Override Value for PWMH output of the channel 0
#define PWM_OOV_OOVH1 0x00000002 // Output Override Value for PWMH output of the channel 1
#define PWM_OOV_OOVH2 0x00000004 // Output Override Value for PWMH output of the channel 2
#define PWM_OOV_OOVH3 0x00000008 // Output Override Value for PWMH output of the channel 3
#define PWM_OOV_OOVH4 0x00000010 // Output Override Value for PWMH output of the channel 4
#define PWM_OOV_OOVH5 0x00000020 // Output Override Value for PWMH output of the channel 5
#define PWM_OOV_OOVH6 0x00000040 // Output Override Value for PWMH output of the channel 6
#define PWM_OOV_OOVH7 0x00000080 // Output Override Value for PWMH output of the channel 7
#define PWM_OOV_OOVL0 0x00010000 // Output Override Value for PWML output of the channel 0
#define PWM_OOV_OOVL1 0x00020000 // Output Override Value for PWML output of the channel 1
#define PWM_OOV_OOVL2 0x00040000 // Output Override Value for PWML output of the channel 2
#define PWM_OOV_OOVL3 0x00080000 // Output Override Value for PWML output of the channel 3
#define PWM_OOV_OOVL4 0x00100000 // Output Override Value for PWML output of the channel 4
#define PWM_OOV_OOVL5 0x00200000 // Output Override Value for PWML output of the channel 5
#define PWM_OOV_OOVL6 0x00400000 // Output Override Value for PWML output of the channel 6
#define PWM_OOV_OOVL7 0x00800000 // Output Override Value for PWML output of the channel 7

#define PWM_OS_OSH0 0x00000001 // Output Selection for PWMH output of the channel 0
#define PWM_OS_OSH1 0x00000002 // Output Selection for PWMH output of the channel 1
#define PWM_OS_OSH2 0x00000004 // Output Selection for PWMH output of the channel 2
#define PWM_OS_OSH3 0x00000008 // Output Selection for PWMH output of the channel 3
#define PWM_OS_OSH4 0x00000010 // Output Selection for PWMH output of the channel 4
#define PWM_OS_OSH5 0x00000020 // Output Selection for PWMH output of the channel 5
#define PWM_OS_OSH6 0x00000040 // Output Selection for PWMH output of the channel 6
#define PWM_OS_OSH7 0x00000080 // Output Selection for PWMH output of the channel 7
#define PWM_OS_OSL0 0x00010000 // Output Selection for PWML output of the channel 0
#define PWM_OS_OSL1 0x00020000 // Output Selection for PWML output of the channel 1
#define PWM_OS_OSL2 0x00040000 // Output Selection for PWML output of the channel 2
#define PWM_OS_OSL3 0x00080000 // Output Selection for PWML output of the channel 3
#define PWM_OS_OSL4 0x00100000 // Output Selection for PWML output of the channel 4
#define PWM_OS_OSL5 0x00200000 // Output Selection for PWML output of the channel 5
#define PWM_OS_OSL6 0x00400000 // Output Selection for PWML output of the channel 6
#define PWM_OS_OSL7 0x00800000 // Output Selection for PWML output of the channel 7

#define PWM_OSS_OSSH0 0x00000001 // Output Selection Set for PWMH output of the channel 0
#define PWM_OSS_OSSH1 0x00000002 // Output Selection Set for PWMH output of the channel 1
#define PWM_OSS_OSSH2 0x00000004 // Output Selection Set for PWMH output of the channel 2
#define PWM_OSS_OSSH3 0x00000008 // Output Selection Set for PWMH output of the channel 3
#define PWM_OSS_OSSH4 0x00000010 // Output Selection Set for PWMH output of the channel 4
#define PWM_OSS_OSSH5 0x00000020 // Output Selection Set for PWMH output of the channel 5
#define PWM_OSS_OSSH6 0x00000040 // Output Selection Set for PWMH output of the channel 6
#define PWM_OSS_OSSH7 0x00000080 // Output Selection Set for PWMH output of the channel 7
#define PWM_OSS_OSSL0 0x00010000 // Output Selection Set for PWML output of the channel 0
#define PWM_OSS_OSSL1 0x00020000 // Output Selection Set for PWML output of the channel 1
#define PWM_OSS_OSSL2 0x00040000 // Output Selection Set for PWML output of the channel 2
#define PWM_OSS_OSSL3 0x00080000 // Output Selection Set for PWML output of the channel 3
#define PWM_OSS_OSSL4 0x00100000 // Output Selection Set for PWML output of the channel 4
#define PWM_OSS_OSSL5 0x00200000 // Output Selection Set for PWML output of the channel 5
#define PWM_OSS_OSSL6 0x00400000 // Output Selection Set for PWML output of the channel 6
#define PWM_OSS_OSSL7 0x00800000 // Output Selection Set for PWML output of the channel 7

#define PWM_OSC_OSCH0 0x00000001 // Output Selection Clear for PWMH output of the channel 0
#define PWM_OSC_OSCH1 0x00000002 // Output Selection Clear for PWMH output of the channel 1
#define PWM_OSC_OSCH2 0x00000004 // Output Selection Clear for PWMH output of the channel 2
#define PWM_OSC_OSCH3 0x00000008 // Output Selection Clear for PWMH output of the channel 3
#define PWM_OSC_OSCH4 0x00000010 // Output Selection Clear for PWMH output of the channel 4
#define PWM_OSC_OSCH5 0x00000020 // Output Selection Clear for PWMH output of the channel 5
#define PWM_OSC_OSCH6 0x00000040 // Output Selection Clear for PWMH output of the channel 6
#define PWM_OSC_OSCH7 0x00000080 // Output Selection Clear for PWMH output of the channel 7
#define PWM_OSC_OSCL0 0x00010000 // Output Selection Clear for PWML output of the channel 0
#define PWM_OSC_OSCL1 0x00020000 // Output Selection Clear for PWML output of the channel 1
#define PWM_OSC_OSCL2 0x00040000 // Output Selection Clear for PWML output of the channel 2
#define PWM_OSC_OSCL3 0x00080000 // Output Selection Clear for PWML output of the channel 3
#define PWM_OSC_OSCL4 0x00100000 // Output Selection Clear for PWML output of the channel 4
#define PWM_OSC_OSCL5 0x00200000 // Output Selection Clear for PWML output of the channel 5
#define PWM_OSC_OSCL6 0x00400000 // Output Selection Clear for PWML output of the channel 6
#define PWM_OSC_OSCL7 0x00800000 // Output Selection Clear for PWML output of the channel 7

#define PWM_OSSUPD_OSSUPH0 0x00000001 // Output Selection Set for PWMH output of the channel 0
#define PWM_OSSUPD_OSSUPH1 0x00000002 // Output Selection Set for PWMH output of the channel 1
#define PWM_OSSUPD_OSSUPH2 0x00000004 // Output Selection Set for PWMH output of the channel 2
#define PWM_OSSUPD_OSSUPH3 0x00000008 // Output Selection Set for PWMH output of the channel 3
#define PWM_OSSUPD_OSSUPH4 0x00000010 // Output Selection Set for PWMH output of the channel 4
#define PWM_OSSUPD_OSSUPH5 0x00000020 // Output Selection Set for PWMH output of the channel 5
#define PWM_OSSUPD_OSSUPH6 0x00000040 // Output Selection Set for PWMH output of the channel 6
#define PWM_OSSUPD_OSSUPH7 0x00000080 // Output Selection Set for PWMH output of the channel 7
#define PWM_OSSUPD_OSSUPL0 0x00010000 // Output Selection Set for PWML output of the channel 0
#define PWM_OSSUPD_OSSUPL1 0x00020000 // Output Selection Set for PWML output of the channel 1
#define PWM_OSSUPD_OSSUPL2 0x00040000 // Output Selection Set for PWML output of the channel 2
#define PWM_OSSUPD_OSSUPL3 0x00080000 // Output Selection Set for PWML output of the channel 3
#define PWM_OSSUPD_OSSUPL4 0x00100000 // Output Selection Set for PWML output of the channel 4
#define PWM_OSSUPD_OSSUPL5 0x00200000 // Output Selection Set for PWML output of the channel 5
#define PWM_OSSUPD_OSSUPL6 0x00400000 // Output Selection Set for PWML output of the channel 6
#define PWM_OSSUPD_OSSUPL7 0x00800000 // Output Selection Set for PWML output of the channel 7

#define PWM_OSCUPD_OSCUPH0 0x00000001 // Output Selection Clear for PWMH output of the channel 0
#define PWM_OSCUPD_OSCUPH1 0x00000002 // Output Selection Clear for PWMH output of the channel 1
#define PWM_OSCUPD_OSCUPH2 0x00000004 // Output Selection Clear for PWMH output of the channel 2
#define PWM_OSCUPD_OSCUPH3 0x00000008 // Output Selection Clear for PWMH output of the channel 3
#define PWM_OSCUPD_OSCUPH4 0x00000010 // Output Selection Clear for PWMH output of the channel 4
#define PWM_OSCUPD_OSCUPH5 0x00000020 // Output Selection Clear for PWMH output of the channel 5
#define PWM_OSCUPD_OSCUPH6 0x00000040 // Output Selection Clear for PWMH output of the channel 6
#define PWM_OSCUPD_OSCUPH7 0x00000080 // Output Selection Clear for PWMH output of the channel 7
#define PWM_OSCUPD_OSCUPL0 0x00010000 // Output Selection Clear for PWML output of the channel 0
#define PWM_OSCUPD_OSCUPL1 0x00020000 // Output Selection Clear for PWML output of the channel 1
#define PWM_OSCUPD_OSCUPL2 0x00040000 // Output Selection Clear for PWML output of the channel 2
#define PWM_OSCUPD_OSCUPL3 0x00080000 // Output Selection Clear for PWML output of the channel 3
#define PWM_OSCUPD_OSCUPL4 0x00100000 // Output Selection Clear for PWML output of the channel 4
#define PWM_OSCUPD_OSCUPL5 0x00200000 // Output Selection Clear for PWML output of the channel 5
#define PWM_OSCUPD_OSCUPL6 0x00400000 // Output Selection Clear for PWML output of the channel 6
#define PWM_OSCUPD_OSCUPL7 0x00800000 // Output Selection Clear for PWML output of the channel 7

#define PWM_FMR_FPOL(value) (((value) & 0xFF) << 0)  // Fault Polarity (fault input bit varies from 0 to 5)
#define PWM_FMR_FMOD(value) (((value) & 0xFF) << 8)  // Fault Activation Mode (fault input bit varies from 0 to 5)
#define PWM_FMR_FFIL(value) (((value) & 0xFF) << 16) // Fault Filtering (fault input bit varies from 0 to 5)

#define PWM_FSR_FIV(value) (((value) & 0xFF) << 0) // Fault Input Value (fault input bit varies from 0 to 5)
#define PWM_FSR_FS(value)  (((value) & 0xFF) << 8) // Fault Status (fault input bit varies from 0 to 5)

#define PWM_FCR_FCLR(value) (((value) & 0xFF) << 0) // Fault Clear (fault input bit varies from 0 to 5)

#define PWM_FPV_FPVH0 0x00000001 // Fault Protection Value for PWMH output on channel 0
#define PWM_FPV_FPVH1 0x00000002 // Fault Protection Value for PWMH output on channel 1
#define PWM_FPV_FPVH2 0x00000004 // Fault Protection Value for PWMH output on channel 2
#define PWM_FPV_FPVH3 0x00000008 // Fault Protection Value for PWMH output on channel 3
#define PWM_FPV_FPVH4 0x00000010 // Fault Protection Value for PWMH output on channel 4
#define PWM_FPV_FPVH5 0x00000020 // Fault Protection Value for PWMH output on channel 5
#define PWM_FPV_FPVH6 0x00000040 // Fault Protection Value for PWMH output on channel 6
#define PWM_FPV_FPVH7 0x00000080 // Fault Protection Value for PWMH output on channel 7
#define PWM_FPV_FPVL0 0x00010000 // Fault Protection Value for PWML output on channel 0
#define PWM_FPV_FPVL1 0x00020000 // Fault Protection Value for PWML output on channel 1
#define PWM_FPV_FPVL2 0x00040000 // Fault Protection Value for PWML output on channel 2
#define PWM_FPV_FPVL3 0x00080000 // Fault Protection Value for PWML output on channel 3
#define PWM_FPV_FPVL4 0x00100000 // Fault Protection Value for PWML output on channel 4
#define PWM_FPV_FPVL5 0x00200000 // Fault Protection Value for PWML output on channel 5
#define PWM_FPV_FPVL6 0x00400000 // Fault Protection Value for PWML output on channel 6
#define PWM_FPV_FPVL7 0x00800000 // Fault Protection Value for PWML output on channel 7

#define PWM_FPE1_FPE0(value) (((value) & 0xFF) << 0)  // Fault Protection Enable for channel 0 (fault input bit varies from 0 to 5)
#define PWM_FPE1_FPE1(value) (((value) & 0xFF) << 8)  // Fault Protection Enable for channel 1 (fault input bit varies from 0 to 5)
#define PWM_FPE1_FPE2(value) (((value) & 0xFF) << 16) // Fault Protection Enable for channel 2 (fault input bit varies from 0 to 5)
#define PWM_FPE1_FPE3(value) (((value) & 0xFF) << 24) // Fault Protection Enable for channel 3 (fault input bit varies from 0 to 5)

#define PWM_FPE2_FPE4(value) (((value) & 0xFF) << 0)  // Fault Protection Enable for channel 4 (fault input bit varies from 0 to 5)
#define PWM_FPE2_FPE5(value) (((value) & 0xFF) << 8)  // Fault Protection Enable for channel 5 (fault input bit varies from 0 to 5)
#define PWM_FPE2_FPE6(value) (((value) & 0xFF) << 16) // Fault Protection Enable for channel 6 (fault input bit varies from 0 to 5)
#define PWM_FPE2_FPE7(value) (((value) & 0xFF) << 24) // Fault Protection Enable for channel 7 (fault input bit varies from 0 to 5)

#define PWM_ELMR_CSEL0 0x00000001 // Comparison 0 Selection
#define PWM_ELMR_CSEL1 0x00000002 // Comparison 1 Selection
#define PWM_ELMR_CSEL2 0x00000004 // Comparison 2 Selection
#define PWM_ELMR_CSEL3 0x00000008 // Comparison 3 Selection
#define PWM_ELMR_CSEL4 0x00000010 // Comparison 4 Selection
#define PWM_ELMR_CSEL5 0x00000020 // Comparison 5 Selection
#define PWM_ELMR_CSEL6 0x00000040 // Comparison 6 Selection
#define PWM_ELMR_CSEL7 0x00000080 // Comparison 7 Selection

#define PWM_SMMR_GCEN0 0x00000001 // Gray Count ENable
#define PWM_SMMR_GCEN1 0x00000002 // Gray Count ENable
#define PWM_SMMR_GCEN2 0x00000004 // Gray Count ENable
#define PWM_SMMR_GCEN3 0x00000008 // Gray Count ENable
#define PWM_SMMR_DOWN0 0x00010000 // DOWN Count
#define PWM_SMMR_DOWN1 0x00020000 // DOWN Count
#define PWM_SMMR_DOWN2 0x00040000 // DOWN Count
#define PWM_SMMR_DOWN3 0x00080000 // DOWN Count

#define PWM_WPCR_WPCMD(value) (((value) & 0x3) << 0)      // Write Protect Command
#define PWM_WPCR_WPRG0        0x00000004                  // Write Protect Register Group 0
#define PWM_WPCR_WPRG1        0x00000008                  // Write Protect Register Group 1
#define PWM_WPCR_WPRG2        0x00000010                  // Write Protect Register Group 2
#define PWM_WPCR_WPRG3        0x00000020                  // Write Protect Register Group 3
#define PWM_WPCR_WPRG4        0x00000040                  // Write Protect Register Group 4
#define PWM_WPCR_WPRG5        0x00000080                  // Write Protect Register Group 5
#define PWM_WPCR_WPKEY(value) (((value) & 0xFFFFFF) << 8) // Write Protect Key

#define PWM_WPSR_WPSWS0        0x00000001                 // Write Protect SW Status
#define PWM_WPSR_WPSWS1        0x00000002                 // Write Protect SW Status
#define PWM_WPSR_WPSWS2        0x00000004                 // Write Protect SW Status
#define PWM_WPSR_WPSWS3        0x00000008                 // Write Protect SW Status
#define PWM_WPSR_WPSWS4        0x00000010                 // Write Protect SW Status
#define PWM_WPSR_WPSWS5        0x00000020                 // Write Protect SW Status
#define PWM_WPSR_WPVS          0x00000080                 // Write Protect Violation Status
#define PWM_WPSR_WPHWS0        0x00000100                 // Write Protect HW Status
#define PWM_WPSR_WPHWS1        0x00000200                 // Write Protect HW Status
#define PWM_WPSR_WPHWS2        0x00000400                 // Write Protect HW Status
#define PWM_WPSR_WPHWS3        0x00000800                 // Write Protect HW Status
#define PWM_WPSR_WPHWS4        0x00001000                 // Write Protect HW Status
#define PWM_WPSR_WPHWS5        0x00002000                 // Write Protect HW Status
#define PWM_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 16) // Write Protect Violation Source

#define PWM_CMPV0_CV(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value
#define PWM_CMPV0_CVM       0x01000000                  // Comparison x Value Mode

#define PWM_CMPVUPD0_CVUPD(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value Update
#define PWM_CMPVUPD0_CVMUPD       0x01000000                  // Comparison x Value Mode Update

#define PWM_CMPM0_CEN            0x00000001              // Comparison x Enable
#define PWM_CMPM0_CTR(value)     (((value) & 0xF) << 4)  // Comparison x Trigger
#define PWM_CMPM0_CPR(value)     (((value) & 0xF) << 8)  // Comparison x Period
#define PWM_CMPM0_CPRCNT(value)  (((value) & 0xF) << 12) // Comparison x Period Counter
#define PWM_CMPM0_CUPR(value)    (((value) & 0xF) << 16) // Comparison x Update Period
#define PWM_CMPM0_CUPRCNT(value) (((value) & 0xF) << 20) // Comparison x Update Period Counter

#define PWM_CMPMUPD0_CENUPD         0x00000001              // Comparison x Enable Update
#define PWM_CMPMUPD0_CTRUPD(value)  (((value) & 0xF) << 4)  // Comparison x Trigger Update
#define PWM_CMPMUPD0_CPRUPD(value)  (((value) & 0xF) << 8)  // Comparison x Period Update
#define PWM_CMPMUPD0_CUPRUPD(value) (((value) & 0xF) << 16) // Comparison x Update Period Update

#define PWM_CMPV1_CV(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value
#define PWM_CMPV1_CVM       0x01000000                  // Comparison x Value Mode

#define PWM_CMPVUPD1_CVUPD(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value Update
#define PWM_CMPVUPD1_CVMUPD       0x01000000                  // Comparison x Value Mode Update

#define PWM_CMPM1_CEN            0x00000001              // Comparison x Enable
#define PWM_CMPM1_CTR(value)     (((value) & 0xF) << 4)  // Comparison x Trigger
#define PWM_CMPM1_CPR(value)     (((value) & 0xF) << 8)  // Comparison x Period
#define PWM_CMPM1_CPRCNT(value)  (((value) & 0xF) << 12) // Comparison x Period Counter
#define PWM_CMPM1_CUPR(value)    (((value) & 0xF) << 16) // Comparison x Update Period
#define PWM_CMPM1_CUPRCNT(value) (((value) & 0xF) << 20) // Comparison x Update Period Counter

#define PWM_CMPMUPD1_CENUPD         0x00000001              // Comparison x Enable Update
#define PWM_CMPMUPD1_CTRUPD(value)  (((value) & 0xF) << 4)  // Comparison x Trigger Update
#define PWM_CMPMUPD1_CPRUPD(value)  (((value) & 0xF) << 8)  // Comparison x Period Update
#define PWM_CMPMUPD1_CUPRUPD(value) (((value) & 0xF) << 16) // Comparison x Update Period Update

#define PWM_CMPV2_CV(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value
#define PWM_CMPV2_CVM       0x01000000                  // Comparison x Value Mode

#define PWM_CMPVUPD2_CVUPD(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value Update
#define PWM_CMPVUPD2_CVMUPD       0x01000000                  // Comparison x Value Mode Update

#define PWM_CMPM2_CEN            0x00000001              // Comparison x Enable
#define PWM_CMPM2_CTR(value)     (((value) & 0xF) << 4)  // Comparison x Trigger
#define PWM_CMPM2_CPR(value)     (((value) & 0xF) << 8)  // Comparison x Period
#define PWM_CMPM2_CPRCNT(value)  (((value) & 0xF) << 12) // Comparison x Period Counter
#define PWM_CMPM2_CUPR(value)    (((value) & 0xF) << 16) // Comparison x Update Period
#define PWM_CMPM2_CUPRCNT(value) (((value) & 0xF) << 20) // Comparison x Update Period Counter

#define PWM_CMPMUPD2_CENUPD         0x00000001              // Comparison x Enable Update
#define PWM_CMPMUPD2_CTRUPD(value)  (((value) & 0xF) << 4)  // Comparison x Trigger Update
#define PWM_CMPMUPD2_CPRUPD(value)  (((value) & 0xF) << 8)  // Comparison x Period Update
#define PWM_CMPMUPD2_CUPRUPD(value) (((value) & 0xF) << 16) // Comparison x Update Period Update

#define PWM_CMPV3_CV(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value
#define PWM_CMPV3_CVM       0x01000000                  // Comparison x Value Mode

#define PWM_CMPVUPD3_CVUPD(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value Update
#define PWM_CMPVUPD3_CVMUPD       0x01000000                  // Comparison x Value Mode Update

#define PWM_CMPM3_CEN            0x00000001              // Comparison x Enable
#define PWM_CMPM3_CTR(value)     (((value) & 0xF) << 4)  // Comparison x Trigger
#define PWM_CMPM3_CPR(value)     (((value) & 0xF) << 8)  // Comparison x Period
#define PWM_CMPM3_CPRCNT(value)  (((value) & 0xF) << 12) // Comparison x Period Counter
#define PWM_CMPM3_CUPR(value)    (((value) & 0xF) << 16) // Comparison x Update Period
#define PWM_CMPM3_CUPRCNT(value) (((value) & 0xF) << 20) // Comparison x Update Period Counter

#define PWM_CMPMUPD3_CENUPD         0x00000001              // Comparison x Enable Update
#define PWM_CMPMUPD3_CTRUPD(value)  (((value) & 0xF) << 4)  // Comparison x Trigger Update
#define PWM_CMPMUPD3_CPRUPD(value)  (((value) & 0xF) << 8)  // Comparison x Period Update
#define PWM_CMPMUPD3_CUPRUPD(value) (((value) & 0xF) << 16) // Comparison x Update Period Update

#define PWM_CMPV4_CV(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value
#define PWM_CMPV4_CVM       0x01000000                  // Comparison x Value Mode

#define PWM_CMPVUPD4_CVUPD(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value Update
#define PWM_CMPVUPD4_CVMUPD       0x01000000                  // Comparison x Value Mode Update

#define PWM_CMPM4_CEN            0x00000001              // Comparison x Enable
#define PWM_CMPM4_CTR(value)     (((value) & 0xF) << 4)  // Comparison x Trigger
#define PWM_CMPM4_CPR(value)     (((value) & 0xF) << 8)  // Comparison x Period
#define PWM_CMPM4_CPRCNT(value)  (((value) & 0xF) << 12) // Comparison x Period Counter
#define PWM_CMPM4_CUPR(value)    (((value) & 0xF) << 16) // Comparison x Update Period
#define PWM_CMPM4_CUPRCNT(value) (((value) & 0xF) << 20) // Comparison x Update Period Counter

#define PWM_CMPMUPD4_CENUPD         0x00000001              // Comparison x Enable Update
#define PWM_CMPMUPD4_CTRUPD(value)  (((value) & 0xF) << 4)  // Comparison x Trigger Update
#define PWM_CMPMUPD4_CPRUPD(value)  (((value) & 0xF) << 8)  // Comparison x Period Update
#define PWM_CMPMUPD4_CUPRUPD(value) (((value) & 0xF) << 16) // Comparison x Update Period Update

#define PWM_CMPV5_CV(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value
#define PWM_CMPV5_CVM       0x01000000                  // Comparison x Value Mode

#define PWM_CMPVUPD5_CVUPD(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value Update
#define PWM_CMPVUPD5_CVMUPD       0x01000000                  // Comparison x Value Mode Update

#define PWM_CMPM5_CEN            0x00000001              // Comparison x Enable
#define PWM_CMPM5_CTR(value)     (((value) & 0xF) << 4)  // Comparison x Trigger
#define PWM_CMPM5_CPR(value)     (((value) & 0xF) << 8)  // Comparison x Period
#define PWM_CMPM5_CPRCNT(value)  (((value) & 0xF) << 12) // Comparison x Period Counter
#define PWM_CMPM5_CUPR(value)    (((value) & 0xF) << 16) // Comparison x Update Period
#define PWM_CMPM5_CUPRCNT(value) (((value) & 0xF) << 20) // Comparison x Update Period Counter

#define PWM_CMPMUPD5_CENUPD         0x00000001              // Comparison x Enable Update
#define PWM_CMPMUPD5_CTRUPD(value)  (((value) & 0xF) << 4)  // Comparison x Trigger Update
#define PWM_CMPMUPD5_CPRUPD(value)  (((value) & 0xF) << 8)  // Comparison x Period Update
#define PWM_CMPMUPD5_CUPRUPD(value) (((value) & 0xF) << 16) // Comparison x Update Period Update

#define PWM_CMPV6_CV(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value
#define PWM_CMPV6_CVM       0x01000000                  // Comparison x Value Mode

#define PWM_CMPVUPD6_CVUPD(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value Update
#define PWM_CMPVUPD6_CVMUPD       0x01000000                  // Comparison x Value Mode Update

#define PWM_CMPM6_CEN            0x00000001              // Comparison x Enable
#define PWM_CMPM6_CTR(value)     (((value) & 0xF) << 4)  // Comparison x Trigger
#define PWM_CMPM6_CPR(value)     (((value) & 0xF) << 8)  // Comparison x Period
#define PWM_CMPM6_CPRCNT(value)  (((value) & 0xF) << 12) // Comparison x Period Counter
#define PWM_CMPM6_CUPR(value)    (((value) & 0xF) << 16) // Comparison x Update Period
#define PWM_CMPM6_CUPRCNT(value) (((value) & 0xF) << 20) // Comparison x Update Period Counter

#define PWM_CMPMUPD6_CENUPD         0x00000001              // Comparison x Enable Update
#define PWM_CMPMUPD6_CTRUPD(value)  (((value) & 0xF) << 4)  // Comparison x Trigger Update
#define PWM_CMPMUPD6_CPRUPD(value)  (((value) & 0xF) << 8)  // Comparison x Period Update
#define PWM_CMPMUPD6_CUPRUPD(value) (((value) & 0xF) << 16) // Comparison x Update Period Update

#define PWM_CMPV7_CV(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value
#define PWM_CMPV7_CVM       0x01000000                  // Comparison x Value Mode

#define PWM_CMPVUPD7_CVUPD(value) (((value) & 0xFFFFFF) << 0) // Comparison x Value Update
#define PWM_CMPVUPD7_CVMUPD       0x01000000                  // Comparison x Value Mode Update

#define PWM_CMPM7_CEN            0x00000001              // Comparison x Enable
#define PWM_CMPM7_CTR(value)     (((value) & 0xF) << 4)  // Comparison x Trigger
#define PWM_CMPM7_CPR(value)     (((value) & 0xF) << 8)  // Comparison x Period
#define PWM_CMPM7_CPRCNT(value)  (((value) & 0xF) << 12) // Comparison x Period Counter
#define PWM_CMPM7_CUPR(value)    (((value) & 0xF) << 16) // Comparison x Update Period
#define PWM_CMPM7_CUPRCNT(value) (((value) & 0xF) << 20) // Comparison x Update Period Counter

#define PWM_CMPMUPD7_CENUPD         0x00000001              // Comparison x Enable Update
#define PWM_CMPMUPD7_CTRUPD(value)  (((value) & 0xF) << 4)  // Comparison x Trigger Update
#define PWM_CMPMUPD7_CPRUPD(value)  (((value) & 0xF) << 8)  // Comparison x Period Update
#define PWM_CMPMUPD7_CUPRUPD(value) (((value) & 0xF) << 16) // Comparison x Update Period Update

#define PWM_CMR0_CPRE_MCK          0x00000000 // Master clock
#define PWM_CMR0_CPRE_MCK_DIV_2    0x00000001 // Master clock/2
#define PWM_CMR0_CPRE_MCK_DIV_4    0x00000002 // Master clock/4
#define PWM_CMR0_CPRE_MCK_DIV_8    0x00000003 // Master clock/8
#define PWM_CMR0_CPRE_MCK_DIV_16   0x00000004 // Master clock/16
#define PWM_CMR0_CPRE_MCK_DIV_32   0x00000005 // Master clock/32
#define PWM_CMR0_CPRE_MCK_DIV_64   0x00000006 // Master clock/64
#define PWM_CMR0_CPRE_MCK_DIV_128  0x00000007 // Master clock/128
#define PWM_CMR0_CPRE_MCK_DIV_256  0x00000008 // Master clock/256
#define PWM_CMR0_CPRE_MCK_DIV_512  0x00000009 // Master clock/512
#define PWM_CMR0_CPRE_MCK_DIV_1024 0x0000000A // Master clock/1024
#define PWM_CMR0_CPRE_CLKA         0x0000000B // Clock A
#define PWM_CMR0_CPRE_CLKB         0x0000000C // Clock B
#define PWM_CMR0_CALG              0x00000100 // Channel Alignment
#define PWM_CMR0_CPOL              0x00000200 // Channel Polarity
#define PWM_CMR0_CES               0x00000400 // Counter Event Selection
#define PWM_CMR0_DTE               0x00010000 // Dead-Time Generator Enable
#define PWM_CMR0_DTHI              0x00020000 // Dead-Time PWMHx Output Inverted
#define PWM_CMR0_DTLI              0x00040000 // Dead-Time PWMLx Output Inverted

#define PWM_CDTY0_CDTY(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle

#define PWM_CDTYUPD0_CDTYUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle Update

#define PWM_CPRD0_CPRD(value) (((value) & 0xFFFFFF) << 0) // Channel Period

#define PWM_CPRDUPD0_CPRDUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Period Update

#define PWM_CCNT0_CNT(value) (((value) & 0xFFFFFF) << 0) // Channel Counter Register

#define PWM_DT0_DTH(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value for PWMHx Output
#define PWM_DT0_DTL(value) (((value) & 0xFFFF) << 16) // Dead-Time Value for PWMLx Output

#define PWM_DTUPD0_DTHUPD(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value Update for PWMHx Output
#define PWM_DTUPD0_DTLUPD(value) (((value) & 0xFFFF) << 16) // Dead-Time Value Update for PWMLx Output

#define PWM_CMR1_CPRE_MCK          0x00000000 // Master clock
#define PWM_CMR1_CPRE_MCK_DIV_2    0x00000001 // Master clock/2
#define PWM_CMR1_CPRE_MCK_DIV_4    0x00000002 // Master clock/4
#define PWM_CMR1_CPRE_MCK_DIV_8    0x00000003 // Master clock/8
#define PWM_CMR1_CPRE_MCK_DIV_16   0x00000004 // Master clock/16
#define PWM_CMR1_CPRE_MCK_DIV_32   0x00000005 // Master clock/32
#define PWM_CMR1_CPRE_MCK_DIV_64   0x00000006 // Master clock/64
#define PWM_CMR1_CPRE_MCK_DIV_128  0x00000007 // Master clock/128
#define PWM_CMR1_CPRE_MCK_DIV_256  0x00000008 // Master clock/256
#define PWM_CMR1_CPRE_MCK_DIV_512  0x00000009 // Master clock/512
#define PWM_CMR1_CPRE_MCK_DIV_1024 0x0000000A // Master clock/1024
#define PWM_CMR1_CPRE_CLKA         0x0000000B // Clock A
#define PWM_CMR1_CPRE_CLKB         0x0000000C // Clock B
#define PWM_CMR1_CALG              0x00000100 // Channel Alignment
#define PWM_CMR1_CPOL              0x00000200 // Channel Polarity
#define PWM_CMR1_CES               0x00000400 // Counter Event Selection
#define PWM_CMR1_DTE               0x00010000 // Dead-Time Generator Enable
#define PWM_CMR1_DTHI              0x00020000 // Dead-Time PWMHx Output Inverted
#define PWM_CMR1_DTLI              0x00040000 // Dead-Time PWMLx Output Inverted

#define PWM_CDTY1_CDTY(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle

#define PWM_CDTYUPD1_CDTYUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle Update

#define PWM_CPRD1_CPRD(value) (((value) & 0xFFFFFF) << 0) // Channel Period

#define PWM_CPRDUPD1_CPRDUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Period Update

#define PWM_CCNT1_CNT(value) (((value) & 0xFFFFFF) << 0) // Channel Counter Register

#define PWM_DT1_DTH(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value for PWMHx Output
#define PWM_DT1_DTL(value) (((value) & 0xFFFF) << 16) // Dead-Time Value for PWMLx Output

#define PWM_DTUPD1_DTHUPD(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value Update for PWMHx Output
#define PWM_DTUPD1_DTLUPD(value) (((value) & 0xFFFF) << 16) // Dead-Time Value Update for PWMLx Output

#define PWM_CMR2_CPRE_MCK          0x00000000 // Master clock
#define PWM_CMR2_CPRE_MCK_DIV_2    0x00000001 // Master clock/2
#define PWM_CMR2_CPRE_MCK_DIV_4    0x00000002 // Master clock/4
#define PWM_CMR2_CPRE_MCK_DIV_8    0x00000003 // Master clock/8
#define PWM_CMR2_CPRE_MCK_DIV_16   0x00000004 // Master clock/16
#define PWM_CMR2_CPRE_MCK_DIV_32   0x00000005 // Master clock/32
#define PWM_CMR2_CPRE_MCK_DIV_64   0x00000006 // Master clock/64
#define PWM_CMR2_CPRE_MCK_DIV_128  0x00000007 // Master clock/128
#define PWM_CMR2_CPRE_MCK_DIV_256  0x00000008 // Master clock/256
#define PWM_CMR2_CPRE_MCK_DIV_512  0x00000009 // Master clock/512
#define PWM_CMR2_CPRE_MCK_DIV_1024 0x0000000A // Master clock/1024
#define PWM_CMR2_CPRE_CLKA         0x0000000B // Clock A
#define PWM_CMR2_CPRE_CLKB         0x0000000C // Clock B
#define PWM_CMR2_CALG              0x00000100 // Channel Alignment
#define PWM_CMR2_CPOL              0x00000200 // Channel Polarity
#define PWM_CMR2_CES               0x00000400 // Counter Event Selection
#define PWM_CMR2_DTE               0x00010000 // Dead-Time Generator Enable
#define PWM_CMR2_DTHI              0x00020000 // Dead-Time PWMHx Output Inverted
#define PWM_CMR2_DTLI              0x00040000 // Dead-Time PWMLx Output Inverted

#define PWM_CDTY2_CDTY(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle

#define PWM_CDTYUPD2_CDTYUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle Update

#define PWM_CPRD2_CPRD(value) (((value) & 0xFFFFFF) << 0) // Channel Period

#define PWM_CPRDUPD2_CPRDUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Period Update

#define PWM_CCNT2_CNT(value) (((value) & 0xFFFFFF) << 0) // Channel Counter Register

#define PWM_DT2_DTH(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value for PWMHx Output
#define PWM_DT2_DTL(value) (((value) & 0xFFFF) << 16) // Dead-Time Value for PWMLx Output

#define PWM_DTUPD2_DTHUPD(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value Update for PWMHx Output
#define PWM_DTUPD2_DTLUPD(value) (((value) & 0xFFFF) << 16) // Dead-Time Value Update for PWMLx Output

#define PWM_CMR3_CPRE_MCK          0x00000000 // Master clock
#define PWM_CMR3_CPRE_MCK_DIV_2    0x00000001 // Master clock/2
#define PWM_CMR3_CPRE_MCK_DIV_4    0x00000002 // Master clock/4
#define PWM_CMR3_CPRE_MCK_DIV_8    0x00000003 // Master clock/8
#define PWM_CMR3_CPRE_MCK_DIV_16   0x00000004 // Master clock/16
#define PWM_CMR3_CPRE_MCK_DIV_32   0x00000005 // Master clock/32
#define PWM_CMR3_CPRE_MCK_DIV_64   0x00000006 // Master clock/64
#define PWM_CMR3_CPRE_MCK_DIV_128  0x00000007 // Master clock/128
#define PWM_CMR3_CPRE_MCK_DIV_256  0x00000008 // Master clock/256
#define PWM_CMR3_CPRE_MCK_DIV_512  0x00000009 // Master clock/512
#define PWM_CMR3_CPRE_MCK_DIV_1024 0x0000000A // Master clock/1024
#define PWM_CMR3_CPRE_CLKA         0x0000000B // Clock A
#define PWM_CMR3_CPRE_CLKB         0x0000000C // Clock B
#define PWM_CMR3_CALG              0x00000100 // Channel Alignment
#define PWM_CMR3_CPOL              0x00000200 // Channel Polarity
#define PWM_CMR3_CES               0x00000400 // Counter Event Selection
#define PWM_CMR3_DTE               0x00010000 // Dead-Time Generator Enable
#define PWM_CMR3_DTHI              0x00020000 // Dead-Time PWMHx Output Inverted
#define PWM_CMR3_DTLI              0x00040000 // Dead-Time PWMLx Output Inverted

#define PWM_CDTY3_CDTY(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle

#define PWM_CDTYUPD3_CDTYUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle Update

#define PWM_CPRD3_CPRD(value) (((value) & 0xFFFFFF) << 0) // Channel Period

#define PWM_CPRDUPD3_CPRDUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Period Update

#define PWM_CCNT3_CNT(value) (((value) & 0xFFFFFF) << 0) // Channel Counter Register

#define PWM_DT3_DTH(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value for PWMHx Output
#define PWM_DT3_DTL(value) (((value) & 0xFFFF) << 16) // Dead-Time Value for PWMLx Output

#define PWM_DTUPD3_DTHUPD(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value Update for PWMHx Output
#define PWM_DTUPD3_DTLUPD(value) (((value) & 0xFFFF) << 16) // Dead-Time Value Update for PWMLx Output

#define PWM_CMR4_CPRE_MCK          0x00000000 // Master clock
#define PWM_CMR4_CPRE_MCK_DIV_2    0x00000001 // Master clock/2
#define PWM_CMR4_CPRE_MCK_DIV_4    0x00000002 // Master clock/4
#define PWM_CMR4_CPRE_MCK_DIV_8    0x00000003 // Master clock/8
#define PWM_CMR4_CPRE_MCK_DIV_16   0x00000004 // Master clock/16
#define PWM_CMR4_CPRE_MCK_DIV_32   0x00000005 // Master clock/32
#define PWM_CMR4_CPRE_MCK_DIV_64   0x00000006 // Master clock/64
#define PWM_CMR4_CPRE_MCK_DIV_128  0x00000007 // Master clock/128
#define PWM_CMR4_CPRE_MCK_DIV_256  0x00000008 // Master clock/256
#define PWM_CMR4_CPRE_MCK_DIV_512  0x00000009 // Master clock/512
#define PWM_CMR4_CPRE_MCK_DIV_1024 0x0000000A // Master clock/1024
#define PWM_CMR4_CPRE_CLKA         0x0000000B // Clock A
#define PWM_CMR4_CPRE_CLKB         0x0000000C // Clock B
#define PWM_CMR4_CALG              0x00000100 // Channel Alignment
#define PWM_CMR4_CPOL              0x00000200 // Channel Polarity
#define PWM_CMR4_CES               0x00000400 // Counter Event Selection
#define PWM_CMR4_DTE               0x00010000 // Dead-Time Generator Enable
#define PWM_CMR4_DTHI              0x00020000 // Dead-Time PWMHx Output Inverted
#define PWM_CMR4_DTLI              0x00040000 // Dead-Time PWMLx Output Inverted

#define PWM_CDTY4_CDTY(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle

#define PWM_CDTYUPD4_CDTYUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle Update

#define PWM_CPRD4_CPRD(value) (((value) & 0xFFFFFF) << 0) // Channel Period

#define PWM_CPRDUPD4_CPRDUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Period Update

#define PWM_CCNT4_CNT(value) (((value) & 0xFFFFFF) << 0) // Channel Counter Register

#define PWM_DT4_DTH(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value for PWMHx Output
#define PWM_DT4_DTL(value) (((value) & 0xFFFF) << 16) // Dead-Time Value for PWMLx Output

#define PWM_DTUPD4_DTHUPD(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value Update for PWMHx Output
#define PWM_DTUPD4_DTLUPD(value) (((value) & 0xFFFF) << 16) // Dead-Time Value Update for PWMLx Output

#define PWM_CMR5_CPRE_MCK          0x00000000 // Master clock
#define PWM_CMR5_CPRE_MCK_DIV_2    0x00000001 // Master clock/2
#define PWM_CMR5_CPRE_MCK_DIV_4    0x00000002 // Master clock/4
#define PWM_CMR5_CPRE_MCK_DIV_8    0x00000003 // Master clock/8
#define PWM_CMR5_CPRE_MCK_DIV_16   0x00000004 // Master clock/16
#define PWM_CMR5_CPRE_MCK_DIV_32   0x00000005 // Master clock/32
#define PWM_CMR5_CPRE_MCK_DIV_64   0x00000006 // Master clock/64
#define PWM_CMR5_CPRE_MCK_DIV_128  0x00000007 // Master clock/128
#define PWM_CMR5_CPRE_MCK_DIV_256  0x00000008 // Master clock/256
#define PWM_CMR5_CPRE_MCK_DIV_512  0x00000009 // Master clock/512
#define PWM_CMR5_CPRE_MCK_DIV_1024 0x0000000A // Master clock/1024
#define PWM_CMR5_CPRE_CLKA         0x0000000B // Clock A
#define PWM_CMR5_CPRE_CLKB         0x0000000C // Clock B
#define PWM_CMR5_CALG              0x00000100 // Channel Alignment
#define PWM_CMR5_CPOL              0x00000200 // Channel Polarity
#define PWM_CMR5_CES               0x00000400 // Counter Event Selection
#define PWM_CMR5_DTE               0x00010000 // Dead-Time Generator Enable
#define PWM_CMR5_DTHI              0x00020000 // Dead-Time PWMHx Output Inverted
#define PWM_CMR5_DTLI              0x00040000 // Dead-Time PWMLx Output Inverted

#define PWM_CDTY5_CDTY(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle

#define PWM_CDTYUPD5_CDTYUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle Update

#define PWM_CPRD5_CPRD(value) (((value) & 0xFFFFFF) << 0) // Channel Period

#define PWM_CPRDUPD5_CPRDUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Period Update

#define PWM_CCNT5_CNT(value) (((value) & 0xFFFFFF) << 0) // Channel Counter Register

#define PWM_DT5_DTH(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value for PWMHx Output
#define PWM_DT5_DTL(value) (((value) & 0xFFFF) << 16) // Dead-Time Value for PWMLx Output

#define PWM_DTUPD5_DTHUPD(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value Update for PWMHx Output
#define PWM_DTUPD5_DTLUPD(value) (((value) & 0xFFFF) << 16) // Dead-Time Value Update for PWMLx Output

#define PWM_CMR6_CPRE_MCK          0x00000000 // Master clock
#define PWM_CMR6_CPRE_MCK_DIV_2    0x00000001 // Master clock/2
#define PWM_CMR6_CPRE_MCK_DIV_4    0x00000002 // Master clock/4
#define PWM_CMR6_CPRE_MCK_DIV_8    0x00000003 // Master clock/8
#define PWM_CMR6_CPRE_MCK_DIV_16   0x00000004 // Master clock/16
#define PWM_CMR6_CPRE_MCK_DIV_32   0x00000005 // Master clock/32
#define PWM_CMR6_CPRE_MCK_DIV_64   0x00000006 // Master clock/64
#define PWM_CMR6_CPRE_MCK_DIV_128  0x00000007 // Master clock/128
#define PWM_CMR6_CPRE_MCK_DIV_256  0x00000008 // Master clock/256
#define PWM_CMR6_CPRE_MCK_DIV_512  0x00000009 // Master clock/512
#define PWM_CMR6_CPRE_MCK_DIV_1024 0x0000000A // Master clock/1024
#define PWM_CMR6_CPRE_CLKA         0x0000000B // Clock A
#define PWM_CMR6_CPRE_CLKB         0x0000000C // Clock B
#define PWM_CMR6_CALG              0x00000100 // Channel Alignment
#define PWM_CMR6_CPOL              0x00000200 // Channel Polarity
#define PWM_CMR6_CES               0x00000400 // Counter Event Selection
#define PWM_CMR6_DTE               0x00010000 // Dead-Time Generator Enable
#define PWM_CMR6_DTHI              0x00020000 // Dead-Time PWMHx Output Inverted
#define PWM_CMR6_DTLI              0x00040000 // Dead-Time PWMLx Output Inverted

#define PWM_CDTY6_CDTY(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle

#define PWM_CDTYUPD6_CDTYUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle Update

#define PWM_CPRD6_CPRD(value) (((value) & 0xFFFFFF) << 0) // Channel Period

#define PWM_CPRDUPD6_CPRDUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Period Update

#define PWM_CCNT6_CNT(value) (((value) & 0xFFFFFF) << 0) // Channel Counter Register

#define PWM_DT6_DTH(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value for PWMHx Output
#define PWM_DT6_DTL(value) (((value) & 0xFFFF) << 16) // Dead-Time Value for PWMLx Output

#define PWM_DTUPD6_DTHUPD(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value Update for PWMHx Output
#define PWM_DTUPD6_DTLUPD(value) (((value) & 0xFFFF) << 16) // Dead-Time Value Update for PWMLx Output

#define PWM_CMR7_CPRE_MCK          0x00000000 // Master clock
#define PWM_CMR7_CPRE_MCK_DIV_2    0x00000001 // Master clock/2
#define PWM_CMR7_CPRE_MCK_DIV_4    0x00000002 // Master clock/4
#define PWM_CMR7_CPRE_MCK_DIV_8    0x00000003 // Master clock/8
#define PWM_CMR7_CPRE_MCK_DIV_16   0x00000004 // Master clock/16
#define PWM_CMR7_CPRE_MCK_DIV_32   0x00000005 // Master clock/32
#define PWM_CMR7_CPRE_MCK_DIV_64   0x00000006 // Master clock/64
#define PWM_CMR7_CPRE_MCK_DIV_128  0x00000007 // Master clock/128
#define PWM_CMR7_CPRE_MCK_DIV_256  0x00000008 // Master clock/256
#define PWM_CMR7_CPRE_MCK_DIV_512  0x00000009 // Master clock/512
#define PWM_CMR7_CPRE_MCK_DIV_1024 0x0000000A // Master clock/1024
#define PWM_CMR7_CPRE_CLKA         0x0000000B // Clock A
#define PWM_CMR7_CPRE_CLKB         0x0000000C // Clock B
#define PWM_CMR7_CALG              0x00000100 // Channel Alignment
#define PWM_CMR7_CPOL              0x00000200 // Channel Polarity
#define PWM_CMR7_CES               0x00000400 // Counter Event Selection
#define PWM_CMR7_DTE               0x00010000 // Dead-Time Generator Enable
#define PWM_CMR7_DTHI              0x00020000 // Dead-Time PWMHx Output Inverted
#define PWM_CMR7_DTLI              0x00040000 // Dead-Time PWMLx Output Inverted

#define PWM_CDTY7_CDTY(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle

#define PWM_CDTYUPD7_CDTYUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Duty-Cycle Update

#define PWM_CPRD7_CPRD(value) (((value) & 0xFFFFFF) << 0) // Channel Period

#define PWM_CPRDUPD7_CPRDUPD(value) (((value) & 0xFFFFFF) << 0) // Channel Period Update

#define PWM_CCNT7_CNT(value) (((value) & 0xFFFFFF) << 0) // Channel Counter Register

#define PWM_DT7_DTH(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value for PWMHx Output
#define PWM_DT7_DTL(value) (((value) & 0xFFFF) << 16) // Dead-Time Value for PWMLx Output

#define PWM_DTUPD7_DTHUPD(value) (((value) & 0xFFFF) << 0)  // Dead-Time Value Update for PWMHx Output
#define PWM_DTUPD7_DTLUPD(value) (((value) & 0xFFFF) << 16) // Dead-Time Value Update for PWMLx Output

#define PWM_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define PWM_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define PWM_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define PWM_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define PWM_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define PWM_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define PWM_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define PWM_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define PWM_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define PWM_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define USART0_CR           (*(volatile unsigned int *)0x40098000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166548)
#define USART0_CR_SPI_MODE  (*(volatile unsigned int *)0x40098000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166548)
#define USART0_MR           (*(volatile unsigned int *)0x40098004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166791)
#define USART0_MR_SPI_MODE  (*(volatile unsigned int *)0x40098004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166791)
#define USART0_IER          (*(volatile unsigned int *)0x40098008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART0_IER_SPI_MODE (*(volatile unsigned int *)0x40098008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART0_IER_LIN_MODE (*(volatile unsigned int *)0x40098008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART0_IDR          (*(volatile unsigned int *)0x4009800C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART0_IDR_SPI_MODE (*(volatile unsigned int *)0x4009800C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART0_IDR_LIN_MODE (*(volatile unsigned int *)0x4009800C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART0_IMR          (*(const volatile unsigned int *)0x40098010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART0_IMR_SPI_MODE (*(const volatile unsigned int *)0x40098010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART0_IMR_LIN_MODE (*(const volatile unsigned int *)0x40098010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART0_CSR          (*(const volatile unsigned int *)0x40098014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART0_CSR_SPI_MODE (*(const volatile unsigned int *)0x40098014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART0_CSR_LIN_MODE (*(const volatile unsigned int *)0x40098014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART0_RHR          (*(const volatile unsigned int *)0x40098018) // [Receive Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168260)
#define USART0_THR          (*(volatile unsigned int *)0x4009801C)       // [Transmit Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168446)
#define USART0_BRGR         (*(volatile unsigned int *)0x40098020)       // [Baud Rate Generator Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168632)
#define USART0_RTOR         (*(volatile unsigned int *)0x40098024)       // [Receiver Time-out Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168875)
#define USART0_TTGR         (*(volatile unsigned int *)0x40098028)       // [Transmitter Timeguard Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169060)
#define USART0_FIDI         (*(volatile unsigned int *)0x40098040)       // [FI DI Ratio Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169244)
#define USART0_NER          (*(const volatile unsigned int *)0x40098044) // [Number of Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169428)
#define USART0_IF           (*(volatile unsigned int *)0x4009804C)       // [IrDA Filter Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169611)
#define USART0_MAN          (*(volatile unsigned int *)0x40098050)       // [Manchester Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1180048)
#define USART0_LINMR        (*(volatile unsigned int *)0x40098054)       // [LIN Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1313805)
#define USART0_LINIR        (*(volatile unsigned int *)0x40098058)       // [LIN Identifier Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1314055)
#define USART0_LINBRR       (*(const volatile unsigned int *)0x4009805C) // [LIN Baud Rate Register]()
#define USART0_WPMR         (*(volatile unsigned int *)0x400980E4)       // [Write Protection Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1214665)
#define USART0_WPSR         (*(const volatile unsigned int *)0x400980E8) // [Write Protection Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1214895)
#define USART0_RPR          (*(volatile unsigned int *)0x40098100)       // [Receive Pointer Register]()
#define USART0_RCR          (*(volatile unsigned int *)0x40098104)       // [Receive Counter Register]()
#define USART0_TPR          (*(volatile unsigned int *)0x40098108)       // [Transmit Pointer Register]()
#define USART0_TCR          (*(volatile unsigned int *)0x4009810C)       // [Transmit Counter Register]()
#define USART0_RNPR         (*(volatile unsigned int *)0x40098110)       // [Receive Next Pointer Register]()
#define USART0_RNCR         (*(volatile unsigned int *)0x40098114)       // [Receive Next Counter Register]()
#define USART0_TNPR         (*(volatile unsigned int *)0x40098118)       // [Transmit Next Pointer Register]()
#define USART0_TNCR         (*(volatile unsigned int *)0x4009811C)       // [Transmit Next Counter Register]()
#define USART0_PTCR         (*(volatile unsigned int *)0x40098120)       // [Transfer Control Register]()
#define USART0_PTSR         (*(const volatile unsigned int *)0x40098124) // [Transfer Status Register]()

#define USART0_CR_RSTRX   0x00000004 // Reset Receiver
#define USART0_CR_RSTTX   0x00000008 // Reset Transmitter
#define USART0_CR_RXEN    0x00000010 // Receiver Enable
#define USART0_CR_RXDIS   0x00000020 // Receiver Disable
#define USART0_CR_TXEN    0x00000040 // Transmitter Enable
#define USART0_CR_TXDIS   0x00000080 // Transmitter Disable
#define USART0_CR_RSTSTA  0x00000100 // Reset Status Bits
#define USART0_CR_STTBRK  0x00000200 // Start Break
#define USART0_CR_STPBRK  0x00000400 // Stop Break
#define USART0_CR_STTTO   0x00000800 // Start Time-out
#define USART0_CR_SENDA   0x00001000 // Send Address
#define USART0_CR_RSTIT   0x00002000 // Reset Iterations
#define USART0_CR_RSTNACK 0x00004000 // Reset Non Acknowledge
#define USART0_CR_RETTO   0x00008000 // Rearm Time-out
#define USART0_CR_RTSEN   0x00040000 // Request to Send Enable
#define USART0_CR_RTSDIS  0x00080000 // Request to Send Disable
#define USART0_CR_LINABT  0x00100000 // Abort LIN Transmission
#define USART0_CR_LINWKUP 0x00200000 // Send LIN Wakeup Signal

#define USART0_CR_SPI_MODE_RSTRX  0x00000004 // Reset Receiver
#define USART0_CR_SPI_MODE_RSTTX  0x00000008 // Reset Transmitter
#define USART0_CR_SPI_MODE_RXEN   0x00000010 // Receiver Enable
#define USART0_CR_SPI_MODE_RXDIS  0x00000020 // Receiver Disable
#define USART0_CR_SPI_MODE_TXEN   0x00000040 // Transmitter Enable
#define USART0_CR_SPI_MODE_TXDIS  0x00000080 // Transmitter Disable
#define USART0_CR_SPI_MODE_RSTSTA 0x00000100 // Reset Status Bits
#define USART0_CR_SPI_MODE_FCS    0x00040000 // Force SPI Chip Select
#define USART0_CR_SPI_MODE_RCS    0x00080000 // Release SPI Chip Select

#define USART0_MR_USART_MODE_NORMAL         0x00000000              // Normal mode
#define USART0_MR_USART_MODE_RS485          0x00000001              // RS485
#define USART0_MR_USART_MODE_HW_HANDSHAKING 0x00000002              // Hardware Handshaking
#define USART0_MR_USART_MODE_IS07816_T_0    0x00000004              // IS07816 Protocol: T = 0
#define USART0_MR_USART_MODE_IS07816_T_1    0x00000006              // IS07816 Protocol: T = 1
#define USART0_MR_USART_MODE_IRDA           0x00000008              // IrDA
#define USART0_MR_USART_MODE_LIN_MASTER     0x0000000A              // LIN master
#define USART0_MR_USART_MODE_LIN_SLAVE      0x0000000B              // LIN Slave
#define USART0_MR_USART_MODE_SPI_MASTER     0x0000000E              // SPI master
#define USART0_MR_USART_MODE_SPI_SLAVE      0x0000000F              // SPI Slave
#define USART0_MR_USCLKS_MCK                0x00000000              // master Clock MCK is selected
#define USART0_MR_USCLKS_DIV                0x00000010              // Internal Clock Divided MCK/DIV (DIV=8) is selected
#define USART0_MR_USCLKS_SCK                0x00000030              // Serial Clock SLK is selected
#define USART0_MR_CHRL_5_BIT                0x00000000              // Character length is 5 bits
#define USART0_MR_CHRL_6_BIT                0x00000040              // Character length is 6 bits
#define USART0_MR_CHRL_7_BIT                0x00000080              // Character length is 7 bits
#define USART0_MR_CHRL_8_BIT                0x000000C0              // Character length is 8 bits
#define USART0_MR_SYNC                      0x00000100              // Synchronous Mode Select
#define USART0_MR_PAR_EVEN                  0x00000000              // Even parity
#define USART0_MR_PAR_ODD                   0x00000200              // Odd parity
#define USART0_MR_PAR_SPACE                 0x00000400              // Parity forced to 0 (Space)
#define USART0_MR_PAR_MARK                  0x00000600              // Parity forced to 1 (Mark)
#define USART0_MR_PAR_NO                    0x00000800              // No parity
#define USART0_MR_PAR_MULTIDROP             0x00000C00              // Multidrop mode
#define USART0_MR_NBSTOP_1_BIT              0x00000000              // 1 stop bit
#define USART0_MR_NBSTOP_1_5_BIT            0x00001000              // 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
#define USART0_MR_NBSTOP_2_BIT              0x00002000              // 2 stop bits
#define USART0_MR_CHMODE_NORMAL             0x00000000              // Normal mode
#define USART0_MR_CHMODE_AUTOMATIC          0x00004000              // Automatic Echo. Receiver input is connected to the TXD pin
#define USART0_MR_CHMODE_LOCAL_LOOPBACK     0x00008000              // Local Loopback. Transmitter output is connected to the Receiver Input
#define USART0_MR_CHMODE_REMOTE_LOOPBACK    0x0000C000              // Remote Loopback. RXD pin is internally connected to the TXD pin
#define USART0_MR_MSBF                      0x00010000              // Bit Order
#define USART0_MR_MODE9                     0x00020000              // 9-bit Character Length
#define USART0_MR_CLKO                      0x00040000              // Clock Output Select
#define USART0_MR_OVER                      0x00080000              // Oversampling Mode
#define USART0_MR_INACK                     0x00100000              // Inhibit Non Acknowledge
#define USART0_MR_DSNACK                    0x00200000              // Disable Successive NACK
#define USART0_MR_VAR_SYNC                  0x00400000              // Variable Synchronization of Command/Data Sync Start Frame Delimiter
#define USART0_MR_INVDATA                   0x00800000              // Inverted Data
#define USART0_MR_MAX_ITERATION(value)      (((value) & 0x7) << 24) // Maximum Number of Automatic Iteration
#define USART0_MR_FILTER                    0x10000000              // Infrared Receive Line Filter
#define USART0_MR_MAN                       0x20000000              // Manchester Encoder/Decoder Enable
#define USART0_MR_MODSYNC                   0x40000000              // Manchester Synchronization Mode
#define USART0_MR_ONEBIT                    0x80000000              // Start Frame Delimiter Selector

#define USART0_MR_SPI_MODE_USART_MODE_SPI_MASTER 0x0000000E // SPI master
#define USART0_MR_SPI_MODE_USART_MODE_SPI_SLAVE  0x0000000F // SPI Slave
#define USART0_MR_SPI_MODE_USCLKS_MCK            0x00000000 // master Clock MCK is selected
#define USART0_MR_SPI_MODE_USCLKS_DIV            0x00000010 // Internal Clock Divided MCK/DIV (DIV=8) is selected
#define USART0_MR_SPI_MODE_USCLKS_SCK            0x00000030 // Serial Clock SLK is selected
#define USART0_MR_SPI_MODE_CHRL_8_BIT            0x000000C0 // Character length is 8 bits
#define USART0_MR_SPI_MODE_CPHA                  0x00000100 // SPI Clock Phase
#define USART0_MR_SPI_MODE_CPOL                  0x00010000 // SPI Clock Polarity
#define USART0_MR_SPI_MODE_WRDBT                 0x00100000 // Wait Read Data Before Transfer

#define USART0_IER_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART0_IER_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART0_IER_RXBRK   0x00000004 // Receiver Break Interrupt Enable
#define USART0_IER_ENDRX   0x00000008 // End of Receive Transfer Interrupt Enable (available in all USART modes of operation)
#define USART0_IER_ENDTX   0x00000010 // End of Transmit Interrupt Enable (available in all USART modes of operation)
#define USART0_IER_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART0_IER_FRAME   0x00000040 // Framing Error Interrupt Enable
#define USART0_IER_PARE    0x00000080 // Parity Error Interrupt Enable
#define USART0_IER_TIMEOUT 0x00000100 // Time-out Interrupt Enable
#define USART0_IER_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART0_IER_ITER    0x00000400 // Max number of Repetitions Reached Interrupt Enable
#define USART0_IER_TXBUFE  0x00000800 // Buffer Empty Interrupt Enable (available in all USART modes of operation)
#define USART0_IER_RXBUFF  0x00001000 // Buffer Full Interrupt Enable (available in all USART modes of operation)
#define USART0_IER_NACK    0x00002000 // Non Acknowledge Interrupt Enable
#define USART0_IER_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Enable
#define USART0_IER_MANE    0x01000000 // Manchester Error Interrupt Enable

#define USART0_IER_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART0_IER_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART0_IER_SPI_MODE_ENDRX   0x00000008 //
#define USART0_IER_SPI_MODE_ENDTX   0x00000010 //
#define USART0_IER_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART0_IER_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART0_IER_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Enable
#define USART0_IER_SPI_MODE_TXBUFE  0x00000800 //
#define USART0_IER_SPI_MODE_RXBUFF  0x00001000 //

#define USART0_IER_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART0_IER_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART0_IER_LIN_MODE_ENDRX   0x00000008 //
#define USART0_IER_LIN_MODE_ENDTX   0x00000010 //
#define USART0_IER_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART0_IER_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Enable
#define USART0_IER_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Enable
#define USART0_IER_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Enable
#define USART0_IER_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART0_IER_LIN_MODE_TXBUFE  0x00000800 //
#define USART0_IER_LIN_MODE_RXBUFF  0x00001000 //
#define USART0_IER_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Enable
#define USART0_IER_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Enable
#define USART0_IER_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Enable
#define USART0_IER_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Enable
#define USART0_IER_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Enable
#define USART0_IER_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Enable
#define USART0_IER_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Enable
#define USART0_IER_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Enable

#define USART0_IDR_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART0_IDR_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART0_IDR_RXBRK   0x00000004 // Receiver Break Interrupt Disable
#define USART0_IDR_ENDRX   0x00000008 // End of Receive Transfer Interrupt Disable (available in all USART modes of operation)
#define USART0_IDR_ENDTX   0x00000010 // End of Transmit Interrupt Disable (available in all USART modes of operation)
#define USART0_IDR_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART0_IDR_FRAME   0x00000040 // Framing Error Interrupt Disable
#define USART0_IDR_PARE    0x00000080 // Parity Error Interrupt Disable
#define USART0_IDR_TIMEOUT 0x00000100 // Time-out Interrupt Disable
#define USART0_IDR_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART0_IDR_ITER    0x00000400 // Max Number of Repetitions Reached Interrupt Disable
#define USART0_IDR_TXBUFE  0x00000800 // Buffer Empty Interrupt Disable (available in all USART modes of operation)
#define USART0_IDR_RXBUFF  0x00001000 // Buffer Full Interrupt Disable (available in all USART modes of operation)
#define USART0_IDR_NACK    0x00002000 // Non Acknowledge Interrupt Disable
#define USART0_IDR_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Disable
#define USART0_IDR_MANE    0x01000000 // Manchester Error Interrupt Disable

#define USART0_IDR_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART0_IDR_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART0_IDR_SPI_MODE_ENDRX   0x00000008 //
#define USART0_IDR_SPI_MODE_ENDTX   0x00000010 //
#define USART0_IDR_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Disable
#define USART0_IDR_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART0_IDR_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Disable
#define USART0_IDR_SPI_MODE_TXBUFE  0x00000800 //
#define USART0_IDR_SPI_MODE_RXBUFF  0x00001000 //

#define USART0_IDR_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART0_IDR_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART0_IDR_LIN_MODE_ENDRX   0x00000008 //
#define USART0_IDR_LIN_MODE_ENDTX   0x00000010 //
#define USART0_IDR_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Disable
#define USART0_IDR_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Disable
#define USART0_IDR_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Disable
#define USART0_IDR_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Disable
#define USART0_IDR_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART0_IDR_LIN_MODE_TXBUFE  0x00000800 //
#define USART0_IDR_LIN_MODE_RXBUFF  0x00001000 //
#define USART0_IDR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Disable
#define USART0_IDR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Disable
#define USART0_IDR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Disable
#define USART0_IDR_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Disable
#define USART0_IDR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Disable
#define USART0_IDR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Disable
#define USART0_IDR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Disable
#define USART0_IDR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Disable

#define USART0_IMR_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART0_IMR_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART0_IMR_RXBRK   0x00000004 // Receiver Break Interrupt Mask
#define USART0_IMR_ENDRX   0x00000008 // End of Receive Transfer Interrupt Mask (available in all USART modes of operation)
#define USART0_IMR_ENDTX   0x00000010 // End of Transmit Interrupt Mask (available in all USART modes of operation)
#define USART0_IMR_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART0_IMR_FRAME   0x00000040 // Framing Error Interrupt Mask
#define USART0_IMR_PARE    0x00000080 // Parity Error Interrupt Mask
#define USART0_IMR_TIMEOUT 0x00000100 // Time-out Interrupt Mask
#define USART0_IMR_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART0_IMR_ITER    0x00000400 // Max Number of Repetitions Reached Interrupt Mask
#define USART0_IMR_TXBUFE  0x00000800 // Buffer Empty Interrupt Mask (available in all USART modes of operation)
#define USART0_IMR_RXBUFF  0x00001000 // Buffer Full Interrupt Mask (available in all USART modes of operation)
#define USART0_IMR_NACK    0x00002000 // Non Acknowledge Interrupt Mask
#define USART0_IMR_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Mask
#define USART0_IMR_MANE    0x01000000 // Manchester Error Interrupt Mask

#define USART0_IMR_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART0_IMR_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART0_IMR_SPI_MODE_ENDRX   0x00000008 //
#define USART0_IMR_SPI_MODE_ENDTX   0x00000010 //
#define USART0_IMR_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART0_IMR_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART0_IMR_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Mask
#define USART0_IMR_SPI_MODE_TXBUFE  0x00000800 //
#define USART0_IMR_SPI_MODE_RXBUFF  0x00001000 //

#define USART0_IMR_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART0_IMR_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART0_IMR_LIN_MODE_ENDRX   0x00000008 //
#define USART0_IMR_LIN_MODE_ENDTX   0x00000010 //
#define USART0_IMR_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART0_IMR_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Mask
#define USART0_IMR_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Mask
#define USART0_IMR_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Mask
#define USART0_IMR_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART0_IMR_LIN_MODE_TXBUFE  0x00000800 //
#define USART0_IMR_LIN_MODE_RXBUFF  0x00001000 //
#define USART0_IMR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Mask
#define USART0_IMR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Mask
#define USART0_IMR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Mask
#define USART0_IMR_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Mask
#define USART0_IMR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Mask
#define USART0_IMR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Mask
#define USART0_IMR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Mask
#define USART0_IMR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Mask

#define USART0_CSR_RXRDY   0x00000001 // Receiver Ready
#define USART0_CSR_TXRDY   0x00000002 // Transmitter Ready
#define USART0_CSR_RXBRK   0x00000004 // Break Received/End of Break
#define USART0_CSR_ENDRX   0x00000008 // End of Receiver Transfer
#define USART0_CSR_ENDTX   0x00000010 // End of Transmitter Transfer
#define USART0_CSR_OVRE    0x00000020 // Overrun Error
#define USART0_CSR_FRAME   0x00000040 // Framing Error
#define USART0_CSR_PARE    0x00000080 // Parity Error
#define USART0_CSR_TIMEOUT 0x00000100 // Receiver Time-out
#define USART0_CSR_TXEMPTY 0x00000200 // Transmitter Empty
#define USART0_CSR_ITER    0x00000400 // Max Number of Repetitions Reached
#define USART0_CSR_TXBUFE  0x00000800 // Transmission Buffer Empty
#define USART0_CSR_RXBUFF  0x00001000 // Reception Buffer Full
#define USART0_CSR_NACK    0x00002000 // Non Acknowledge Interrupt
#define USART0_CSR_CTSIC   0x00080000 // Clear to Send Input Change Flag
#define USART0_CSR_CTS     0x00800000 // Image of CTS Input
#define USART0_CSR_MANERR  0x01000000 // Manchester Error

#define USART0_CSR_SPI_MODE_RXRDY   0x00000001 // Receiver Ready
#define USART0_CSR_SPI_MODE_TXRDY   0x00000002 // Transmitter Ready
#define USART0_CSR_SPI_MODE_ENDRX   0x00000008 //
#define USART0_CSR_SPI_MODE_ENDTX   0x00000010 //
#define USART0_CSR_SPI_MODE_OVRE    0x00000020 // Overrun Error
#define USART0_CSR_SPI_MODE_TXEMPTY 0x00000200 // Transmitter Empty
#define USART0_CSR_SPI_MODE_UNRE    0x00000400 // Underrun Error
#define USART0_CSR_SPI_MODE_TXBUFE  0x00000800 //
#define USART0_CSR_SPI_MODE_RXBUFF  0x00001000 //

#define USART0_CSR_LIN_MODE_RXRDY   0x00000001 // Receiver Ready
#define USART0_CSR_LIN_MODE_TXRDY   0x00000002 // Transmitter Ready
#define USART0_CSR_LIN_MODE_ENDRX   0x00000008 //
#define USART0_CSR_LIN_MODE_ENDTX   0x00000010 //
#define USART0_CSR_LIN_MODE_OVRE    0x00000020 // Overrun Error
#define USART0_CSR_LIN_MODE_FRAME   0x00000040 // Framing Error
#define USART0_CSR_LIN_MODE_PARE    0x00000080 // Parity Error
#define USART0_CSR_LIN_MODE_TIMEOUT 0x00000100 // Receiver Time-out
#define USART0_CSR_LIN_MODE_TXEMPTY 0x00000200 // Transmitter Empty
#define USART0_CSR_LIN_MODE_TXBUFE  0x00000800 //
#define USART0_CSR_LIN_MODE_RXBUFF  0x00001000 //
#define USART0_CSR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received
#define USART0_CSR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received
#define USART0_CSR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed
#define USART0_CSR_LIN_MODE_LINBLS  0x00800000 // LIN Bus Line Status
#define USART0_CSR_LIN_MODE_LINBE   0x02000000 // LIN Bit Error
#define USART0_CSR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error
#define USART0_CSR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Error
#define USART0_CSR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error
#define USART0_CSR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error

#define USART0_RHR_RXCHR(value) (((value) & 0x1FF) << 0) // Received Character
#define USART0_RHR_RXSYNH       0x00008000               // Received Sync

#define USART0_THR_TXCHR(value) (((value) & 0x1FF) << 0) // Character to be Transmitted
#define USART0_THR_TXSYNH       0x00008000               // Sync Field to be Transmitted

#define USART0_BRGR_CD(value) (((value) & 0xFFFF) << 0) // Clock Divider
#define USART0_BRGR_FP(value) (((value) & 0x7) << 16)   // Fractional Part

#define USART0_RTOR_TO(value) (((value) & 0x1FFFF) << 0) // Time-out Value

#define USART0_TTGR_TG(value) (((value) & 0xFF) << 0) // Timeguard Value

#define USART0_FIDI_FI_DI_RATIO(value) (((value) & 0x7FF) << 0) // FI Over DI Ratio Value

#define USART0_NER_NB_ERRORS(value) (((value) & 0xFF) << 0) // Number of Errors

#define USART0_IF_IRDA_FILTER(value) (((value) & 0xFF) << 0) // IrDA Filter

#define USART0_MAN_TX_PL(value)   (((value) & 0xF) << 0)  // Transmitter Preamble Length
#define USART0_MAN_TX_PP_ALL_ONE  0x00000000              // The preamble is composed of '1's
#define USART0_MAN_TX_PP_ALL_ZERO 0x00000100              // The preamble is composed of '0's
#define USART0_MAN_TX_PP_ZERO_ONE 0x00000200              // The preamble is composed of '01's
#define USART0_MAN_TX_PP_ONE_ZERO 0x00000300              // The preamble is composed of '10's
#define USART0_MAN_TX_MPOL        0x00001000              // Transmitter Manchester Polarity
#define USART0_MAN_RX_PL(value)   (((value) & 0xF) << 16) // Receiver Preamble Length
#define USART0_MAN_RX_PP_ALL_ONE  0x00000000              // The preamble is composed of '1's
#define USART0_MAN_RX_PP_ALL_ZERO 0x01000000              // The preamble is composed of '0's
#define USART0_MAN_RX_PP_ZERO_ONE 0x02000000              // The preamble is composed of '01's
#define USART0_MAN_RX_PP_ONE_ZERO 0x03000000              // The preamble is composed of '10's
#define USART0_MAN_RX_MPOL        0x10000000              // Receiver Manchester Polarity
#define USART0_MAN_ONE            0x20000000              // Must Be Set to 1
#define USART0_MAN_DRIFT          0x40000000              // Drift Compensation

#define USART0_LINMR_NACT_PUBLISH   0x00000000              // The USART transmits the response
#define USART0_LINMR_NACT_SUBSCRIBE 0x00000001              // The USART receives the response
#define USART0_LINMR_NACT_IGNORE    0x00000002              // The USART does not transmit and does not receive the response
#define USART0_LINMR_PARDIS         0x00000004              // Parity Disable
#define USART0_LINMR_CHKDIS         0x00000008              // Checksum Disable
#define USART0_LINMR_CHKTYP         0x00000010              // Checksum Type
#define USART0_LINMR_DLM            0x00000020              // Data Length Mode
#define USART0_LINMR_FSDIS          0x00000040              // Frame Slot Mode Disable
#define USART0_LINMR_WKUPTYP        0x00000080              // Wakeup Signal Type
#define USART0_LINMR_DLC(value)     (((value) & 0xFF) << 8) // Data Length Control
#define USART0_LINMR_PDCM           0x00010000              // PDC Mode

#define USART0_LINIR_IDCHR(value) (((value) & 0xFF) << 0) // Identifier Character

#define USART0_LINBRR_LINCD(value) (((value) & 0xFFFF) << 0) // Clock Divider after Synchronization
#define USART0_LINBRR_LINFP(value) (((value) & 0x7) << 16)   // Fractional Part after Synchronization

#define USART0_WPMR_WPEN         0x00000001 // Write Protection Enable
#define USART0_WPMR_WPKEY_PASSWD 0x55534100 // Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0

#define USART0_WPSR_WPVS          0x00000001                // Write Protection Violation Status
#define USART0_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protection Violation Source

#define USART0_RPR_RXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Pointer Register

#define USART0_RCR_RXCTR(value) (((value) & 0xFFFF) << 0) // Receive Counter Register

#define USART0_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define USART0_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define USART0_RNPR_RXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Next Pointer

#define USART0_RNCR_RXNCTR(value) (((value) & 0xFFFF) << 0) // Receive Next Counter

#define USART0_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define USART0_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define USART0_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define USART0_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define USART0_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define USART0_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define USART0_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define USART0_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define USART1_CR           (*(volatile unsigned int *)0x4009C000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166548)
#define USART1_CR_SPI_MODE  (*(volatile unsigned int *)0x4009C000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166548)
#define USART1_MR           (*(volatile unsigned int *)0x4009C004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166791)
#define USART1_MR_SPI_MODE  (*(volatile unsigned int *)0x4009C004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166791)
#define USART1_IER          (*(volatile unsigned int *)0x4009C008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART1_IER_SPI_MODE (*(volatile unsigned int *)0x4009C008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART1_IER_LIN_MODE (*(volatile unsigned int *)0x4009C008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART1_IDR          (*(volatile unsigned int *)0x4009C00C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART1_IDR_SPI_MODE (*(volatile unsigned int *)0x4009C00C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART1_IDR_LIN_MODE (*(volatile unsigned int *)0x4009C00C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART1_IMR          (*(const volatile unsigned int *)0x4009C010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART1_IMR_SPI_MODE (*(const volatile unsigned int *)0x4009C010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART1_IMR_LIN_MODE (*(const volatile unsigned int *)0x4009C010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART1_CSR          (*(const volatile unsigned int *)0x4009C014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART1_CSR_SPI_MODE (*(const volatile unsigned int *)0x4009C014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART1_CSR_LIN_MODE (*(const volatile unsigned int *)0x4009C014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART1_RHR          (*(const volatile unsigned int *)0x4009C018) // [Receive Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168260)
#define USART1_THR          (*(volatile unsigned int *)0x4009C01C)       // [Transmit Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168446)
#define USART1_BRGR         (*(volatile unsigned int *)0x4009C020)       // [Baud Rate Generator Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168632)
#define USART1_RTOR         (*(volatile unsigned int *)0x4009C024)       // [Receiver Time-out Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168875)
#define USART1_TTGR         (*(volatile unsigned int *)0x4009C028)       // [Transmitter Timeguard Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169060)
#define USART1_FIDI         (*(volatile unsigned int *)0x4009C040)       // [FI DI Ratio Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169244)
#define USART1_NER          (*(const volatile unsigned int *)0x4009C044) // [Number of Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169428)
#define USART1_IF           (*(volatile unsigned int *)0x4009C04C)       // [IrDA Filter Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169611)
#define USART1_MAN          (*(volatile unsigned int *)0x4009C050)       // [Manchester Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1180048)
#define USART1_LINMR        (*(volatile unsigned int *)0x4009C054)       // [LIN Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1313805)
#define USART1_LINIR        (*(volatile unsigned int *)0x4009C058)       // [LIN Identifier Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1314055)
#define USART1_LINBRR       (*(const volatile unsigned int *)0x4009C05C) // [LIN Baud Rate Register]()
#define USART1_WPMR         (*(volatile unsigned int *)0x4009C0E4)       // [Write Protection Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1214665)
#define USART1_WPSR         (*(const volatile unsigned int *)0x4009C0E8) // [Write Protection Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1214895)
#define USART1_RPR          (*(volatile unsigned int *)0x4009C100)       // [Receive Pointer Register]()
#define USART1_RCR          (*(volatile unsigned int *)0x4009C104)       // [Receive Counter Register]()
#define USART1_TPR          (*(volatile unsigned int *)0x4009C108)       // [Transmit Pointer Register]()
#define USART1_TCR          (*(volatile unsigned int *)0x4009C10C)       // [Transmit Counter Register]()
#define USART1_RNPR         (*(volatile unsigned int *)0x4009C110)       // [Receive Next Pointer Register]()
#define USART1_RNCR         (*(volatile unsigned int *)0x4009C114)       // [Receive Next Counter Register]()
#define USART1_TNPR         (*(volatile unsigned int *)0x4009C118)       // [Transmit Next Pointer Register]()
#define USART1_TNCR         (*(volatile unsigned int *)0x4009C11C)       // [Transmit Next Counter Register]()
#define USART1_PTCR         (*(volatile unsigned int *)0x4009C120)       // [Transfer Control Register]()
#define USART1_PTSR         (*(const volatile unsigned int *)0x4009C124) // [Transfer Status Register]()

#define USART1_CR_RSTRX   0x00000004 // Reset Receiver
#define USART1_CR_RSTTX   0x00000008 // Reset Transmitter
#define USART1_CR_RXEN    0x00000010 // Receiver Enable
#define USART1_CR_RXDIS   0x00000020 // Receiver Disable
#define USART1_CR_TXEN    0x00000040 // Transmitter Enable
#define USART1_CR_TXDIS   0x00000080 // Transmitter Disable
#define USART1_CR_RSTSTA  0x00000100 // Reset Status Bits
#define USART1_CR_STTBRK  0x00000200 // Start Break
#define USART1_CR_STPBRK  0x00000400 // Stop Break
#define USART1_CR_STTTO   0x00000800 // Start Time-out
#define USART1_CR_SENDA   0x00001000 // Send Address
#define USART1_CR_RSTIT   0x00002000 // Reset Iterations
#define USART1_CR_RSTNACK 0x00004000 // Reset Non Acknowledge
#define USART1_CR_RETTO   0x00008000 // Rearm Time-out
#define USART1_CR_RTSEN   0x00040000 // Request to Send Enable
#define USART1_CR_RTSDIS  0x00080000 // Request to Send Disable
#define USART1_CR_LINABT  0x00100000 // Abort LIN Transmission
#define USART1_CR_LINWKUP 0x00200000 // Send LIN Wakeup Signal

#define USART1_CR_SPI_MODE_RSTRX  0x00000004 // Reset Receiver
#define USART1_CR_SPI_MODE_RSTTX  0x00000008 // Reset Transmitter
#define USART1_CR_SPI_MODE_RXEN   0x00000010 // Receiver Enable
#define USART1_CR_SPI_MODE_RXDIS  0x00000020 // Receiver Disable
#define USART1_CR_SPI_MODE_TXEN   0x00000040 // Transmitter Enable
#define USART1_CR_SPI_MODE_TXDIS  0x00000080 // Transmitter Disable
#define USART1_CR_SPI_MODE_RSTSTA 0x00000100 // Reset Status Bits
#define USART1_CR_SPI_MODE_FCS    0x00040000 // Force SPI Chip Select
#define USART1_CR_SPI_MODE_RCS    0x00080000 // Release SPI Chip Select

#define USART1_MR_USART_MODE_NORMAL         0x00000000              // Normal mode
#define USART1_MR_USART_MODE_RS485          0x00000001              // RS485
#define USART1_MR_USART_MODE_HW_HANDSHAKING 0x00000002              // Hardware Handshaking
#define USART1_MR_USART_MODE_IS07816_T_0    0x00000004              // IS07816 Protocol: T = 0
#define USART1_MR_USART_MODE_IS07816_T_1    0x00000006              // IS07816 Protocol: T = 1
#define USART1_MR_USART_MODE_IRDA           0x00000008              // IrDA
#define USART1_MR_USART_MODE_LIN_MASTER     0x0000000A              // LIN master
#define USART1_MR_USART_MODE_LIN_SLAVE      0x0000000B              // LIN Slave
#define USART1_MR_USART_MODE_SPI_MASTER     0x0000000E              // SPI master
#define USART1_MR_USART_MODE_SPI_SLAVE      0x0000000F              // SPI Slave
#define USART1_MR_USCLKS_MCK                0x00000000              // master Clock MCK is selected
#define USART1_MR_USCLKS_DIV                0x00000010              // Internal Clock Divided MCK/DIV (DIV=8) is selected
#define USART1_MR_USCLKS_SCK                0x00000030              // Serial Clock SLK is selected
#define USART1_MR_CHRL_5_BIT                0x00000000              // Character length is 5 bits
#define USART1_MR_CHRL_6_BIT                0x00000040              // Character length is 6 bits
#define USART1_MR_CHRL_7_BIT                0x00000080              // Character length is 7 bits
#define USART1_MR_CHRL_8_BIT                0x000000C0              // Character length is 8 bits
#define USART1_MR_SYNC                      0x00000100              // Synchronous Mode Select
#define USART1_MR_PAR_EVEN                  0x00000000              // Even parity
#define USART1_MR_PAR_ODD                   0x00000200              // Odd parity
#define USART1_MR_PAR_SPACE                 0x00000400              // Parity forced to 0 (Space)
#define USART1_MR_PAR_MARK                  0x00000600              // Parity forced to 1 (Mark)
#define USART1_MR_PAR_NO                    0x00000800              // No parity
#define USART1_MR_PAR_MULTIDROP             0x00000C00              // Multidrop mode
#define USART1_MR_NBSTOP_1_BIT              0x00000000              // 1 stop bit
#define USART1_MR_NBSTOP_1_5_BIT            0x00001000              // 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
#define USART1_MR_NBSTOP_2_BIT              0x00002000              // 2 stop bits
#define USART1_MR_CHMODE_NORMAL             0x00000000              // Normal mode
#define USART1_MR_CHMODE_AUTOMATIC          0x00004000              // Automatic Echo. Receiver input is connected to the TXD pin
#define USART1_MR_CHMODE_LOCAL_LOOPBACK     0x00008000              // Local Loopback. Transmitter output is connected to the Receiver Input
#define USART1_MR_CHMODE_REMOTE_LOOPBACK    0x0000C000              // Remote Loopback. RXD pin is internally connected to the TXD pin
#define USART1_MR_MSBF                      0x00010000              // Bit Order
#define USART1_MR_MODE9                     0x00020000              // 9-bit Character Length
#define USART1_MR_CLKO                      0x00040000              // Clock Output Select
#define USART1_MR_OVER                      0x00080000              // Oversampling Mode
#define USART1_MR_INACK                     0x00100000              // Inhibit Non Acknowledge
#define USART1_MR_DSNACK                    0x00200000              // Disable Successive NACK
#define USART1_MR_VAR_SYNC                  0x00400000              // Variable Synchronization of Command/Data Sync Start Frame Delimiter
#define USART1_MR_INVDATA                   0x00800000              // Inverted Data
#define USART1_MR_MAX_ITERATION(value)      (((value) & 0x7) << 24) // Maximum Number of Automatic Iteration
#define USART1_MR_FILTER                    0x10000000              // Infrared Receive Line Filter
#define USART1_MR_MAN                       0x20000000              // Manchester Encoder/Decoder Enable
#define USART1_MR_MODSYNC                   0x40000000              // Manchester Synchronization Mode
#define USART1_MR_ONEBIT                    0x80000000              // Start Frame Delimiter Selector

#define USART1_MR_SPI_MODE_USART_MODE_SPI_MASTER 0x0000000E // SPI master
#define USART1_MR_SPI_MODE_USART_MODE_SPI_SLAVE  0x0000000F // SPI Slave
#define USART1_MR_SPI_MODE_USCLKS_MCK            0x00000000 // master Clock MCK is selected
#define USART1_MR_SPI_MODE_USCLKS_DIV            0x00000010 // Internal Clock Divided MCK/DIV (DIV=8) is selected
#define USART1_MR_SPI_MODE_USCLKS_SCK            0x00000030 // Serial Clock SLK is selected
#define USART1_MR_SPI_MODE_CHRL_8_BIT            0x000000C0 // Character length is 8 bits
#define USART1_MR_SPI_MODE_CPHA                  0x00000100 // SPI Clock Phase
#define USART1_MR_SPI_MODE_CPOL                  0x00010000 // SPI Clock Polarity
#define USART1_MR_SPI_MODE_WRDBT                 0x00100000 // Wait Read Data Before Transfer

#define USART1_IER_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART1_IER_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART1_IER_RXBRK   0x00000004 // Receiver Break Interrupt Enable
#define USART1_IER_ENDRX   0x00000008 // End of Receive Transfer Interrupt Enable (available in all USART modes of operation)
#define USART1_IER_ENDTX   0x00000010 // End of Transmit Interrupt Enable (available in all USART modes of operation)
#define USART1_IER_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART1_IER_FRAME   0x00000040 // Framing Error Interrupt Enable
#define USART1_IER_PARE    0x00000080 // Parity Error Interrupt Enable
#define USART1_IER_TIMEOUT 0x00000100 // Time-out Interrupt Enable
#define USART1_IER_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART1_IER_ITER    0x00000400 // Max number of Repetitions Reached Interrupt Enable
#define USART1_IER_TXBUFE  0x00000800 // Buffer Empty Interrupt Enable (available in all USART modes of operation)
#define USART1_IER_RXBUFF  0x00001000 // Buffer Full Interrupt Enable (available in all USART modes of operation)
#define USART1_IER_NACK    0x00002000 // Non Acknowledge Interrupt Enable
#define USART1_IER_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Enable
#define USART1_IER_MANE    0x01000000 // Manchester Error Interrupt Enable

#define USART1_IER_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART1_IER_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART1_IER_SPI_MODE_ENDRX   0x00000008 //
#define USART1_IER_SPI_MODE_ENDTX   0x00000010 //
#define USART1_IER_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART1_IER_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART1_IER_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Enable
#define USART1_IER_SPI_MODE_TXBUFE  0x00000800 //
#define USART1_IER_SPI_MODE_RXBUFF  0x00001000 //

#define USART1_IER_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART1_IER_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART1_IER_LIN_MODE_ENDRX   0x00000008 //
#define USART1_IER_LIN_MODE_ENDTX   0x00000010 //
#define USART1_IER_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART1_IER_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Enable
#define USART1_IER_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Enable
#define USART1_IER_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Enable
#define USART1_IER_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART1_IER_LIN_MODE_TXBUFE  0x00000800 //
#define USART1_IER_LIN_MODE_RXBUFF  0x00001000 //
#define USART1_IER_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Enable
#define USART1_IER_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Enable
#define USART1_IER_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Enable
#define USART1_IER_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Enable
#define USART1_IER_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Enable
#define USART1_IER_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Enable
#define USART1_IER_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Enable
#define USART1_IER_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Enable

#define USART1_IDR_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART1_IDR_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART1_IDR_RXBRK   0x00000004 // Receiver Break Interrupt Disable
#define USART1_IDR_ENDRX   0x00000008 // End of Receive Transfer Interrupt Disable (available in all USART modes of operation)
#define USART1_IDR_ENDTX   0x00000010 // End of Transmit Interrupt Disable (available in all USART modes of operation)
#define USART1_IDR_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART1_IDR_FRAME   0x00000040 // Framing Error Interrupt Disable
#define USART1_IDR_PARE    0x00000080 // Parity Error Interrupt Disable
#define USART1_IDR_TIMEOUT 0x00000100 // Time-out Interrupt Disable
#define USART1_IDR_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART1_IDR_ITER    0x00000400 // Max Number of Repetitions Reached Interrupt Disable
#define USART1_IDR_TXBUFE  0x00000800 // Buffer Empty Interrupt Disable (available in all USART modes of operation)
#define USART1_IDR_RXBUFF  0x00001000 // Buffer Full Interrupt Disable (available in all USART modes of operation)
#define USART1_IDR_NACK    0x00002000 // Non Acknowledge Interrupt Disable
#define USART1_IDR_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Disable
#define USART1_IDR_MANE    0x01000000 // Manchester Error Interrupt Disable

#define USART1_IDR_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART1_IDR_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART1_IDR_SPI_MODE_ENDRX   0x00000008 //
#define USART1_IDR_SPI_MODE_ENDTX   0x00000010 //
#define USART1_IDR_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Disable
#define USART1_IDR_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART1_IDR_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Disable
#define USART1_IDR_SPI_MODE_TXBUFE  0x00000800 //
#define USART1_IDR_SPI_MODE_RXBUFF  0x00001000 //

#define USART1_IDR_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART1_IDR_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART1_IDR_LIN_MODE_ENDRX   0x00000008 //
#define USART1_IDR_LIN_MODE_ENDTX   0x00000010 //
#define USART1_IDR_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Disable
#define USART1_IDR_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Disable
#define USART1_IDR_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Disable
#define USART1_IDR_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Disable
#define USART1_IDR_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART1_IDR_LIN_MODE_TXBUFE  0x00000800 //
#define USART1_IDR_LIN_MODE_RXBUFF  0x00001000 //
#define USART1_IDR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Disable
#define USART1_IDR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Disable
#define USART1_IDR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Disable
#define USART1_IDR_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Disable
#define USART1_IDR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Disable
#define USART1_IDR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Disable
#define USART1_IDR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Disable
#define USART1_IDR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Disable

#define USART1_IMR_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART1_IMR_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART1_IMR_RXBRK   0x00000004 // Receiver Break Interrupt Mask
#define USART1_IMR_ENDRX   0x00000008 // End of Receive Transfer Interrupt Mask (available in all USART modes of operation)
#define USART1_IMR_ENDTX   0x00000010 // End of Transmit Interrupt Mask (available in all USART modes of operation)
#define USART1_IMR_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART1_IMR_FRAME   0x00000040 // Framing Error Interrupt Mask
#define USART1_IMR_PARE    0x00000080 // Parity Error Interrupt Mask
#define USART1_IMR_TIMEOUT 0x00000100 // Time-out Interrupt Mask
#define USART1_IMR_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART1_IMR_ITER    0x00000400 // Max Number of Repetitions Reached Interrupt Mask
#define USART1_IMR_TXBUFE  0x00000800 // Buffer Empty Interrupt Mask (available in all USART modes of operation)
#define USART1_IMR_RXBUFF  0x00001000 // Buffer Full Interrupt Mask (available in all USART modes of operation)
#define USART1_IMR_NACK    0x00002000 // Non Acknowledge Interrupt Mask
#define USART1_IMR_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Mask
#define USART1_IMR_MANE    0x01000000 // Manchester Error Interrupt Mask

#define USART1_IMR_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART1_IMR_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART1_IMR_SPI_MODE_ENDRX   0x00000008 //
#define USART1_IMR_SPI_MODE_ENDTX   0x00000010 //
#define USART1_IMR_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART1_IMR_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART1_IMR_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Mask
#define USART1_IMR_SPI_MODE_TXBUFE  0x00000800 //
#define USART1_IMR_SPI_MODE_RXBUFF  0x00001000 //

#define USART1_IMR_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART1_IMR_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART1_IMR_LIN_MODE_ENDRX   0x00000008 //
#define USART1_IMR_LIN_MODE_ENDTX   0x00000010 //
#define USART1_IMR_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART1_IMR_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Mask
#define USART1_IMR_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Mask
#define USART1_IMR_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Mask
#define USART1_IMR_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART1_IMR_LIN_MODE_TXBUFE  0x00000800 //
#define USART1_IMR_LIN_MODE_RXBUFF  0x00001000 //
#define USART1_IMR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Mask
#define USART1_IMR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Mask
#define USART1_IMR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Mask
#define USART1_IMR_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Mask
#define USART1_IMR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Mask
#define USART1_IMR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Mask
#define USART1_IMR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Mask
#define USART1_IMR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Mask

#define USART1_CSR_RXRDY   0x00000001 // Receiver Ready
#define USART1_CSR_TXRDY   0x00000002 // Transmitter Ready
#define USART1_CSR_RXBRK   0x00000004 // Break Received/End of Break
#define USART1_CSR_ENDRX   0x00000008 // End of Receiver Transfer
#define USART1_CSR_ENDTX   0x00000010 // End of Transmitter Transfer
#define USART1_CSR_OVRE    0x00000020 // Overrun Error
#define USART1_CSR_FRAME   0x00000040 // Framing Error
#define USART1_CSR_PARE    0x00000080 // Parity Error
#define USART1_CSR_TIMEOUT 0x00000100 // Receiver Time-out
#define USART1_CSR_TXEMPTY 0x00000200 // Transmitter Empty
#define USART1_CSR_ITER    0x00000400 // Max Number of Repetitions Reached
#define USART1_CSR_TXBUFE  0x00000800 // Transmission Buffer Empty
#define USART1_CSR_RXBUFF  0x00001000 // Reception Buffer Full
#define USART1_CSR_NACK    0x00002000 // Non Acknowledge Interrupt
#define USART1_CSR_CTSIC   0x00080000 // Clear to Send Input Change Flag
#define USART1_CSR_CTS     0x00800000 // Image of CTS Input
#define USART1_CSR_MANERR  0x01000000 // Manchester Error

#define USART1_CSR_SPI_MODE_RXRDY   0x00000001 // Receiver Ready
#define USART1_CSR_SPI_MODE_TXRDY   0x00000002 // Transmitter Ready
#define USART1_CSR_SPI_MODE_ENDRX   0x00000008 //
#define USART1_CSR_SPI_MODE_ENDTX   0x00000010 //
#define USART1_CSR_SPI_MODE_OVRE    0x00000020 // Overrun Error
#define USART1_CSR_SPI_MODE_TXEMPTY 0x00000200 // Transmitter Empty
#define USART1_CSR_SPI_MODE_UNRE    0x00000400 // Underrun Error
#define USART1_CSR_SPI_MODE_TXBUFE  0x00000800 //
#define USART1_CSR_SPI_MODE_RXBUFF  0x00001000 //

#define USART1_CSR_LIN_MODE_RXRDY   0x00000001 // Receiver Ready
#define USART1_CSR_LIN_MODE_TXRDY   0x00000002 // Transmitter Ready
#define USART1_CSR_LIN_MODE_ENDRX   0x00000008 //
#define USART1_CSR_LIN_MODE_ENDTX   0x00000010 //
#define USART1_CSR_LIN_MODE_OVRE    0x00000020 // Overrun Error
#define USART1_CSR_LIN_MODE_FRAME   0x00000040 // Framing Error
#define USART1_CSR_LIN_MODE_PARE    0x00000080 // Parity Error
#define USART1_CSR_LIN_MODE_TIMEOUT 0x00000100 // Receiver Time-out
#define USART1_CSR_LIN_MODE_TXEMPTY 0x00000200 // Transmitter Empty
#define USART1_CSR_LIN_MODE_TXBUFE  0x00000800 //
#define USART1_CSR_LIN_MODE_RXBUFF  0x00001000 //
#define USART1_CSR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received
#define USART1_CSR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received
#define USART1_CSR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed
#define USART1_CSR_LIN_MODE_LINBLS  0x00800000 // LIN Bus Line Status
#define USART1_CSR_LIN_MODE_LINBE   0x02000000 // LIN Bit Error
#define USART1_CSR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error
#define USART1_CSR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Error
#define USART1_CSR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error
#define USART1_CSR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error

#define USART1_RHR_RXCHR(value) (((value) & 0x1FF) << 0) // Received Character
#define USART1_RHR_RXSYNH       0x00008000               // Received Sync

#define USART1_THR_TXCHR(value) (((value) & 0x1FF) << 0) // Character to be Transmitted
#define USART1_THR_TXSYNH       0x00008000               // Sync Field to be Transmitted

#define USART1_BRGR_CD(value) (((value) & 0xFFFF) << 0) // Clock Divider
#define USART1_BRGR_FP(value) (((value) & 0x7) << 16)   // Fractional Part

#define USART1_RTOR_TO(value) (((value) & 0x1FFFF) << 0) // Time-out Value

#define USART1_TTGR_TG(value) (((value) & 0xFF) << 0) // Timeguard Value

#define USART1_FIDI_FI_DI_RATIO(value) (((value) & 0x7FF) << 0) // FI Over DI Ratio Value

#define USART1_NER_NB_ERRORS(value) (((value) & 0xFF) << 0) // Number of Errors

#define USART1_IF_IRDA_FILTER(value) (((value) & 0xFF) << 0) // IrDA Filter

#define USART1_MAN_TX_PL(value)   (((value) & 0xF) << 0)  // Transmitter Preamble Length
#define USART1_MAN_TX_PP_ALL_ONE  0x00000000              // The preamble is composed of '1's
#define USART1_MAN_TX_PP_ALL_ZERO 0x00000100              // The preamble is composed of '0's
#define USART1_MAN_TX_PP_ZERO_ONE 0x00000200              // The preamble is composed of '01's
#define USART1_MAN_TX_PP_ONE_ZERO 0x00000300              // The preamble is composed of '10's
#define USART1_MAN_TX_MPOL        0x00001000              // Transmitter Manchester Polarity
#define USART1_MAN_RX_PL(value)   (((value) & 0xF) << 16) // Receiver Preamble Length
#define USART1_MAN_RX_PP_ALL_ONE  0x00000000              // The preamble is composed of '1's
#define USART1_MAN_RX_PP_ALL_ZERO 0x01000000              // The preamble is composed of '0's
#define USART1_MAN_RX_PP_ZERO_ONE 0x02000000              // The preamble is composed of '01's
#define USART1_MAN_RX_PP_ONE_ZERO 0x03000000              // The preamble is composed of '10's
#define USART1_MAN_RX_MPOL        0x10000000              // Receiver Manchester Polarity
#define USART1_MAN_ONE            0x20000000              // Must Be Set to 1
#define USART1_MAN_DRIFT          0x40000000              // Drift Compensation

#define USART1_LINMR_NACT_PUBLISH   0x00000000              // The USART transmits the response
#define USART1_LINMR_NACT_SUBSCRIBE 0x00000001              // The USART receives the response
#define USART1_LINMR_NACT_IGNORE    0x00000002              // The USART does not transmit and does not receive the response
#define USART1_LINMR_PARDIS         0x00000004              // Parity Disable
#define USART1_LINMR_CHKDIS         0x00000008              // Checksum Disable
#define USART1_LINMR_CHKTYP         0x00000010              // Checksum Type
#define USART1_LINMR_DLM            0x00000020              // Data Length Mode
#define USART1_LINMR_FSDIS          0x00000040              // Frame Slot Mode Disable
#define USART1_LINMR_WKUPTYP        0x00000080              // Wakeup Signal Type
#define USART1_LINMR_DLC(value)     (((value) & 0xFF) << 8) // Data Length Control
#define USART1_LINMR_PDCM           0x00010000              // PDC Mode

#define USART1_LINIR_IDCHR(value) (((value) & 0xFF) << 0) // Identifier Character

#define USART1_LINBRR_LINCD(value) (((value) & 0xFFFF) << 0) // Clock Divider after Synchronization
#define USART1_LINBRR_LINFP(value) (((value) & 0x7) << 16)   // Fractional Part after Synchronization

#define USART1_WPMR_WPEN         0x00000001 // Write Protection Enable
#define USART1_WPMR_WPKEY_PASSWD 0x55534100 // Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0

#define USART1_WPSR_WPVS          0x00000001                // Write Protection Violation Status
#define USART1_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protection Violation Source

#define USART1_RPR_RXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Pointer Register

#define USART1_RCR_RXCTR(value) (((value) & 0xFFFF) << 0) // Receive Counter Register

#define USART1_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define USART1_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define USART1_RNPR_RXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Next Pointer

#define USART1_RNCR_RXNCTR(value) (((value) & 0xFFFF) << 0) // Receive Next Counter

#define USART1_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define USART1_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define USART1_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define USART1_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define USART1_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define USART1_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define USART1_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define USART1_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define USART2_CR           (*(volatile unsigned int *)0x400A0000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166548)
#define USART2_CR_SPI_MODE  (*(volatile unsigned int *)0x400A0000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166548)
#define USART2_MR           (*(volatile unsigned int *)0x400A0004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166791)
#define USART2_MR_SPI_MODE  (*(volatile unsigned int *)0x400A0004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166791)
#define USART2_IER          (*(volatile unsigned int *)0x400A0008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART2_IER_SPI_MODE (*(volatile unsigned int *)0x400A0008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART2_IER_LIN_MODE (*(volatile unsigned int *)0x400A0008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART2_IDR          (*(volatile unsigned int *)0x400A000C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART2_IDR_SPI_MODE (*(volatile unsigned int *)0x400A000C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART2_IDR_LIN_MODE (*(volatile unsigned int *)0x400A000C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART2_IMR          (*(const volatile unsigned int *)0x400A0010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART2_IMR_SPI_MODE (*(const volatile unsigned int *)0x400A0010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART2_IMR_LIN_MODE (*(const volatile unsigned int *)0x400A0010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART2_CSR          (*(const volatile unsigned int *)0x400A0014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART2_CSR_SPI_MODE (*(const volatile unsigned int *)0x400A0014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART2_CSR_LIN_MODE (*(const volatile unsigned int *)0x400A0014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART2_RHR          (*(const volatile unsigned int *)0x400A0018) // [Receive Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168260)
#define USART2_THR          (*(volatile unsigned int *)0x400A001C)       // [Transmit Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168446)
#define USART2_BRGR         (*(volatile unsigned int *)0x400A0020)       // [Baud Rate Generator Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168632)
#define USART2_RTOR         (*(volatile unsigned int *)0x400A0024)       // [Receiver Time-out Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168875)
#define USART2_TTGR         (*(volatile unsigned int *)0x400A0028)       // [Transmitter Timeguard Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169060)
#define USART2_FIDI         (*(volatile unsigned int *)0x400A0040)       // [FI DI Ratio Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169244)
#define USART2_NER          (*(const volatile unsigned int *)0x400A0044) // [Number of Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169428)
#define USART2_IF           (*(volatile unsigned int *)0x400A004C)       // [IrDA Filter Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169611)
#define USART2_MAN          (*(volatile unsigned int *)0x400A0050)       // [Manchester Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1180048)
#define USART2_LINMR        (*(volatile unsigned int *)0x400A0054)       // [LIN Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1313805)
#define USART2_LINIR        (*(volatile unsigned int *)0x400A0058)       // [LIN Identifier Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1314055)
#define USART2_LINBRR       (*(const volatile unsigned int *)0x400A005C) // [LIN Baud Rate Register]()
#define USART2_WPMR         (*(volatile unsigned int *)0x400A00E4)       // [Write Protection Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1214665)
#define USART2_WPSR         (*(const volatile unsigned int *)0x400A00E8) // [Write Protection Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1214895)
#define USART2_RPR          (*(volatile unsigned int *)0x400A0100)       // [Receive Pointer Register]()
#define USART2_RCR          (*(volatile unsigned int *)0x400A0104)       // [Receive Counter Register]()
#define USART2_TPR          (*(volatile unsigned int *)0x400A0108)       // [Transmit Pointer Register]()
#define USART2_TCR          (*(volatile unsigned int *)0x400A010C)       // [Transmit Counter Register]()
#define USART2_RNPR         (*(volatile unsigned int *)0x400A0110)       // [Receive Next Pointer Register]()
#define USART2_RNCR         (*(volatile unsigned int *)0x400A0114)       // [Receive Next Counter Register]()
#define USART2_TNPR         (*(volatile unsigned int *)0x400A0118)       // [Transmit Next Pointer Register]()
#define USART2_TNCR         (*(volatile unsigned int *)0x400A011C)       // [Transmit Next Counter Register]()
#define USART2_PTCR         (*(volatile unsigned int *)0x400A0120)       // [Transfer Control Register]()
#define USART2_PTSR         (*(const volatile unsigned int *)0x400A0124) // [Transfer Status Register]()

#define USART2_CR_RSTRX   0x00000004 // Reset Receiver
#define USART2_CR_RSTTX   0x00000008 // Reset Transmitter
#define USART2_CR_RXEN    0x00000010 // Receiver Enable
#define USART2_CR_RXDIS   0x00000020 // Receiver Disable
#define USART2_CR_TXEN    0x00000040 // Transmitter Enable
#define USART2_CR_TXDIS   0x00000080 // Transmitter Disable
#define USART2_CR_RSTSTA  0x00000100 // Reset Status Bits
#define USART2_CR_STTBRK  0x00000200 // Start Break
#define USART2_CR_STPBRK  0x00000400 // Stop Break
#define USART2_CR_STTTO   0x00000800 // Start Time-out
#define USART2_CR_SENDA   0x00001000 // Send Address
#define USART2_CR_RSTIT   0x00002000 // Reset Iterations
#define USART2_CR_RSTNACK 0x00004000 // Reset Non Acknowledge
#define USART2_CR_RETTO   0x00008000 // Rearm Time-out
#define USART2_CR_RTSEN   0x00040000 // Request to Send Enable
#define USART2_CR_RTSDIS  0x00080000 // Request to Send Disable
#define USART2_CR_LINABT  0x00100000 // Abort LIN Transmission
#define USART2_CR_LINWKUP 0x00200000 // Send LIN Wakeup Signal

#define USART2_CR_SPI_MODE_RSTRX  0x00000004 // Reset Receiver
#define USART2_CR_SPI_MODE_RSTTX  0x00000008 // Reset Transmitter
#define USART2_CR_SPI_MODE_RXEN   0x00000010 // Receiver Enable
#define USART2_CR_SPI_MODE_RXDIS  0x00000020 // Receiver Disable
#define USART2_CR_SPI_MODE_TXEN   0x00000040 // Transmitter Enable
#define USART2_CR_SPI_MODE_TXDIS  0x00000080 // Transmitter Disable
#define USART2_CR_SPI_MODE_RSTSTA 0x00000100 // Reset Status Bits
#define USART2_CR_SPI_MODE_FCS    0x00040000 // Force SPI Chip Select
#define USART2_CR_SPI_MODE_RCS    0x00080000 // Release SPI Chip Select

#define USART2_MR_USART_MODE_NORMAL         0x00000000              // Normal mode
#define USART2_MR_USART_MODE_RS485          0x00000001              // RS485
#define USART2_MR_USART_MODE_HW_HANDSHAKING 0x00000002              // Hardware Handshaking
#define USART2_MR_USART_MODE_IS07816_T_0    0x00000004              // IS07816 Protocol: T = 0
#define USART2_MR_USART_MODE_IS07816_T_1    0x00000006              // IS07816 Protocol: T = 1
#define USART2_MR_USART_MODE_IRDA           0x00000008              // IrDA
#define USART2_MR_USART_MODE_LIN_MASTER     0x0000000A              // LIN master
#define USART2_MR_USART_MODE_LIN_SLAVE      0x0000000B              // LIN Slave
#define USART2_MR_USART_MODE_SPI_MASTER     0x0000000E              // SPI master
#define USART2_MR_USART_MODE_SPI_SLAVE      0x0000000F              // SPI Slave
#define USART2_MR_USCLKS_MCK                0x00000000              // master Clock MCK is selected
#define USART2_MR_USCLKS_DIV                0x00000010              // Internal Clock Divided MCK/DIV (DIV=8) is selected
#define USART2_MR_USCLKS_SCK                0x00000030              // Serial Clock SLK is selected
#define USART2_MR_CHRL_5_BIT                0x00000000              // Character length is 5 bits
#define USART2_MR_CHRL_6_BIT                0x00000040              // Character length is 6 bits
#define USART2_MR_CHRL_7_BIT                0x00000080              // Character length is 7 bits
#define USART2_MR_CHRL_8_BIT                0x000000C0              // Character length is 8 bits
#define USART2_MR_SYNC                      0x00000100              // Synchronous Mode Select
#define USART2_MR_PAR_EVEN                  0x00000000              // Even parity
#define USART2_MR_PAR_ODD                   0x00000200              // Odd parity
#define USART2_MR_PAR_SPACE                 0x00000400              // Parity forced to 0 (Space)
#define USART2_MR_PAR_MARK                  0x00000600              // Parity forced to 1 (Mark)
#define USART2_MR_PAR_NO                    0x00000800              // No parity
#define USART2_MR_PAR_MULTIDROP             0x00000C00              // Multidrop mode
#define USART2_MR_NBSTOP_1_BIT              0x00000000              // 1 stop bit
#define USART2_MR_NBSTOP_1_5_BIT            0x00001000              // 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
#define USART2_MR_NBSTOP_2_BIT              0x00002000              // 2 stop bits
#define USART2_MR_CHMODE_NORMAL             0x00000000              // Normal mode
#define USART2_MR_CHMODE_AUTOMATIC          0x00004000              // Automatic Echo. Receiver input is connected to the TXD pin
#define USART2_MR_CHMODE_LOCAL_LOOPBACK     0x00008000              // Local Loopback. Transmitter output is connected to the Receiver Input
#define USART2_MR_CHMODE_REMOTE_LOOPBACK    0x0000C000              // Remote Loopback. RXD pin is internally connected to the TXD pin
#define USART2_MR_MSBF                      0x00010000              // Bit Order
#define USART2_MR_MODE9                     0x00020000              // 9-bit Character Length
#define USART2_MR_CLKO                      0x00040000              // Clock Output Select
#define USART2_MR_OVER                      0x00080000              // Oversampling Mode
#define USART2_MR_INACK                     0x00100000              // Inhibit Non Acknowledge
#define USART2_MR_DSNACK                    0x00200000              // Disable Successive NACK
#define USART2_MR_VAR_SYNC                  0x00400000              // Variable Synchronization of Command/Data Sync Start Frame Delimiter
#define USART2_MR_INVDATA                   0x00800000              // Inverted Data
#define USART2_MR_MAX_ITERATION(value)      (((value) & 0x7) << 24) // Maximum Number of Automatic Iteration
#define USART2_MR_FILTER                    0x10000000              // Infrared Receive Line Filter
#define USART2_MR_MAN                       0x20000000              // Manchester Encoder/Decoder Enable
#define USART2_MR_MODSYNC                   0x40000000              // Manchester Synchronization Mode
#define USART2_MR_ONEBIT                    0x80000000              // Start Frame Delimiter Selector

#define USART2_MR_SPI_MODE_USART_MODE_SPI_MASTER 0x0000000E // SPI master
#define USART2_MR_SPI_MODE_USART_MODE_SPI_SLAVE  0x0000000F // SPI Slave
#define USART2_MR_SPI_MODE_USCLKS_MCK            0x00000000 // master Clock MCK is selected
#define USART2_MR_SPI_MODE_USCLKS_DIV            0x00000010 // Internal Clock Divided MCK/DIV (DIV=8) is selected
#define USART2_MR_SPI_MODE_USCLKS_SCK            0x00000030 // Serial Clock SLK is selected
#define USART2_MR_SPI_MODE_CHRL_8_BIT            0x000000C0 // Character length is 8 bits
#define USART2_MR_SPI_MODE_CPHA                  0x00000100 // SPI Clock Phase
#define USART2_MR_SPI_MODE_CPOL                  0x00010000 // SPI Clock Polarity
#define USART2_MR_SPI_MODE_WRDBT                 0x00100000 // Wait Read Data Before Transfer

#define USART2_IER_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART2_IER_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART2_IER_RXBRK   0x00000004 // Receiver Break Interrupt Enable
#define USART2_IER_ENDRX   0x00000008 // End of Receive Transfer Interrupt Enable (available in all USART modes of operation)
#define USART2_IER_ENDTX   0x00000010 // End of Transmit Interrupt Enable (available in all USART modes of operation)
#define USART2_IER_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART2_IER_FRAME   0x00000040 // Framing Error Interrupt Enable
#define USART2_IER_PARE    0x00000080 // Parity Error Interrupt Enable
#define USART2_IER_TIMEOUT 0x00000100 // Time-out Interrupt Enable
#define USART2_IER_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART2_IER_ITER    0x00000400 // Max number of Repetitions Reached Interrupt Enable
#define USART2_IER_TXBUFE  0x00000800 // Buffer Empty Interrupt Enable (available in all USART modes of operation)
#define USART2_IER_RXBUFF  0x00001000 // Buffer Full Interrupt Enable (available in all USART modes of operation)
#define USART2_IER_NACK    0x00002000 // Non Acknowledge Interrupt Enable
#define USART2_IER_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Enable
#define USART2_IER_MANE    0x01000000 // Manchester Error Interrupt Enable

#define USART2_IER_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART2_IER_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART2_IER_SPI_MODE_ENDRX   0x00000008 //
#define USART2_IER_SPI_MODE_ENDTX   0x00000010 //
#define USART2_IER_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART2_IER_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART2_IER_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Enable
#define USART2_IER_SPI_MODE_TXBUFE  0x00000800 //
#define USART2_IER_SPI_MODE_RXBUFF  0x00001000 //

#define USART2_IER_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART2_IER_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART2_IER_LIN_MODE_ENDRX   0x00000008 //
#define USART2_IER_LIN_MODE_ENDTX   0x00000010 //
#define USART2_IER_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART2_IER_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Enable
#define USART2_IER_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Enable
#define USART2_IER_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Enable
#define USART2_IER_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART2_IER_LIN_MODE_TXBUFE  0x00000800 //
#define USART2_IER_LIN_MODE_RXBUFF  0x00001000 //
#define USART2_IER_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Enable
#define USART2_IER_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Enable
#define USART2_IER_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Enable
#define USART2_IER_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Enable
#define USART2_IER_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Enable
#define USART2_IER_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Enable
#define USART2_IER_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Enable
#define USART2_IER_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Enable

#define USART2_IDR_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART2_IDR_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART2_IDR_RXBRK   0x00000004 // Receiver Break Interrupt Disable
#define USART2_IDR_ENDRX   0x00000008 // End of Receive Transfer Interrupt Disable (available in all USART modes of operation)
#define USART2_IDR_ENDTX   0x00000010 // End of Transmit Interrupt Disable (available in all USART modes of operation)
#define USART2_IDR_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART2_IDR_FRAME   0x00000040 // Framing Error Interrupt Disable
#define USART2_IDR_PARE    0x00000080 // Parity Error Interrupt Disable
#define USART2_IDR_TIMEOUT 0x00000100 // Time-out Interrupt Disable
#define USART2_IDR_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART2_IDR_ITER    0x00000400 // Max Number of Repetitions Reached Interrupt Disable
#define USART2_IDR_TXBUFE  0x00000800 // Buffer Empty Interrupt Disable (available in all USART modes of operation)
#define USART2_IDR_RXBUFF  0x00001000 // Buffer Full Interrupt Disable (available in all USART modes of operation)
#define USART2_IDR_NACK    0x00002000 // Non Acknowledge Interrupt Disable
#define USART2_IDR_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Disable
#define USART2_IDR_MANE    0x01000000 // Manchester Error Interrupt Disable

#define USART2_IDR_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART2_IDR_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART2_IDR_SPI_MODE_ENDRX   0x00000008 //
#define USART2_IDR_SPI_MODE_ENDTX   0x00000010 //
#define USART2_IDR_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Disable
#define USART2_IDR_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART2_IDR_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Disable
#define USART2_IDR_SPI_MODE_TXBUFE  0x00000800 //
#define USART2_IDR_SPI_MODE_RXBUFF  0x00001000 //

#define USART2_IDR_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART2_IDR_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART2_IDR_LIN_MODE_ENDRX   0x00000008 //
#define USART2_IDR_LIN_MODE_ENDTX   0x00000010 //
#define USART2_IDR_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Disable
#define USART2_IDR_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Disable
#define USART2_IDR_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Disable
#define USART2_IDR_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Disable
#define USART2_IDR_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART2_IDR_LIN_MODE_TXBUFE  0x00000800 //
#define USART2_IDR_LIN_MODE_RXBUFF  0x00001000 //
#define USART2_IDR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Disable
#define USART2_IDR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Disable
#define USART2_IDR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Disable
#define USART2_IDR_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Disable
#define USART2_IDR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Disable
#define USART2_IDR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Disable
#define USART2_IDR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Disable
#define USART2_IDR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Disable

#define USART2_IMR_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART2_IMR_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART2_IMR_RXBRK   0x00000004 // Receiver Break Interrupt Mask
#define USART2_IMR_ENDRX   0x00000008 // End of Receive Transfer Interrupt Mask (available in all USART modes of operation)
#define USART2_IMR_ENDTX   0x00000010 // End of Transmit Interrupt Mask (available in all USART modes of operation)
#define USART2_IMR_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART2_IMR_FRAME   0x00000040 // Framing Error Interrupt Mask
#define USART2_IMR_PARE    0x00000080 // Parity Error Interrupt Mask
#define USART2_IMR_TIMEOUT 0x00000100 // Time-out Interrupt Mask
#define USART2_IMR_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART2_IMR_ITER    0x00000400 // Max Number of Repetitions Reached Interrupt Mask
#define USART2_IMR_TXBUFE  0x00000800 // Buffer Empty Interrupt Mask (available in all USART modes of operation)
#define USART2_IMR_RXBUFF  0x00001000 // Buffer Full Interrupt Mask (available in all USART modes of operation)
#define USART2_IMR_NACK    0x00002000 // Non Acknowledge Interrupt Mask
#define USART2_IMR_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Mask
#define USART2_IMR_MANE    0x01000000 // Manchester Error Interrupt Mask

#define USART2_IMR_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART2_IMR_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART2_IMR_SPI_MODE_ENDRX   0x00000008 //
#define USART2_IMR_SPI_MODE_ENDTX   0x00000010 //
#define USART2_IMR_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART2_IMR_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART2_IMR_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Mask
#define USART2_IMR_SPI_MODE_TXBUFE  0x00000800 //
#define USART2_IMR_SPI_MODE_RXBUFF  0x00001000 //

#define USART2_IMR_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART2_IMR_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART2_IMR_LIN_MODE_ENDRX   0x00000008 //
#define USART2_IMR_LIN_MODE_ENDTX   0x00000010 //
#define USART2_IMR_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART2_IMR_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Mask
#define USART2_IMR_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Mask
#define USART2_IMR_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Mask
#define USART2_IMR_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART2_IMR_LIN_MODE_TXBUFE  0x00000800 //
#define USART2_IMR_LIN_MODE_RXBUFF  0x00001000 //
#define USART2_IMR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Mask
#define USART2_IMR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Mask
#define USART2_IMR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Mask
#define USART2_IMR_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Mask
#define USART2_IMR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Mask
#define USART2_IMR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Mask
#define USART2_IMR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Mask
#define USART2_IMR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Mask

#define USART2_CSR_RXRDY   0x00000001 // Receiver Ready
#define USART2_CSR_TXRDY   0x00000002 // Transmitter Ready
#define USART2_CSR_RXBRK   0x00000004 // Break Received/End of Break
#define USART2_CSR_ENDRX   0x00000008 // End of Receiver Transfer
#define USART2_CSR_ENDTX   0x00000010 // End of Transmitter Transfer
#define USART2_CSR_OVRE    0x00000020 // Overrun Error
#define USART2_CSR_FRAME   0x00000040 // Framing Error
#define USART2_CSR_PARE    0x00000080 // Parity Error
#define USART2_CSR_TIMEOUT 0x00000100 // Receiver Time-out
#define USART2_CSR_TXEMPTY 0x00000200 // Transmitter Empty
#define USART2_CSR_ITER    0x00000400 // Max Number of Repetitions Reached
#define USART2_CSR_TXBUFE  0x00000800 // Transmission Buffer Empty
#define USART2_CSR_RXBUFF  0x00001000 // Reception Buffer Full
#define USART2_CSR_NACK    0x00002000 // Non Acknowledge Interrupt
#define USART2_CSR_CTSIC   0x00080000 // Clear to Send Input Change Flag
#define USART2_CSR_CTS     0x00800000 // Image of CTS Input
#define USART2_CSR_MANERR  0x01000000 // Manchester Error

#define USART2_CSR_SPI_MODE_RXRDY   0x00000001 // Receiver Ready
#define USART2_CSR_SPI_MODE_TXRDY   0x00000002 // Transmitter Ready
#define USART2_CSR_SPI_MODE_ENDRX   0x00000008 //
#define USART2_CSR_SPI_MODE_ENDTX   0x00000010 //
#define USART2_CSR_SPI_MODE_OVRE    0x00000020 // Overrun Error
#define USART2_CSR_SPI_MODE_TXEMPTY 0x00000200 // Transmitter Empty
#define USART2_CSR_SPI_MODE_UNRE    0x00000400 // Underrun Error
#define USART2_CSR_SPI_MODE_TXBUFE  0x00000800 //
#define USART2_CSR_SPI_MODE_RXBUFF  0x00001000 //

#define USART2_CSR_LIN_MODE_RXRDY   0x00000001 // Receiver Ready
#define USART2_CSR_LIN_MODE_TXRDY   0x00000002 // Transmitter Ready
#define USART2_CSR_LIN_MODE_ENDRX   0x00000008 //
#define USART2_CSR_LIN_MODE_ENDTX   0x00000010 //
#define USART2_CSR_LIN_MODE_OVRE    0x00000020 // Overrun Error
#define USART2_CSR_LIN_MODE_FRAME   0x00000040 // Framing Error
#define USART2_CSR_LIN_MODE_PARE    0x00000080 // Parity Error
#define USART2_CSR_LIN_MODE_TIMEOUT 0x00000100 // Receiver Time-out
#define USART2_CSR_LIN_MODE_TXEMPTY 0x00000200 // Transmitter Empty
#define USART2_CSR_LIN_MODE_TXBUFE  0x00000800 //
#define USART2_CSR_LIN_MODE_RXBUFF  0x00001000 //
#define USART2_CSR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received
#define USART2_CSR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received
#define USART2_CSR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed
#define USART2_CSR_LIN_MODE_LINBLS  0x00800000 // LIN Bus Line Status
#define USART2_CSR_LIN_MODE_LINBE   0x02000000 // LIN Bit Error
#define USART2_CSR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error
#define USART2_CSR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Error
#define USART2_CSR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error
#define USART2_CSR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error

#define USART2_RHR_RXCHR(value) (((value) & 0x1FF) << 0) // Received Character
#define USART2_RHR_RXSYNH       0x00008000               // Received Sync

#define USART2_THR_TXCHR(value) (((value) & 0x1FF) << 0) // Character to be Transmitted
#define USART2_THR_TXSYNH       0x00008000               // Sync Field to be Transmitted

#define USART2_BRGR_CD(value) (((value) & 0xFFFF) << 0) // Clock Divider
#define USART2_BRGR_FP(value) (((value) & 0x7) << 16)   // Fractional Part

#define USART2_RTOR_TO(value) (((value) & 0x1FFFF) << 0) // Time-out Value

#define USART2_TTGR_TG(value) (((value) & 0xFF) << 0) // Timeguard Value

#define USART2_FIDI_FI_DI_RATIO(value) (((value) & 0x7FF) << 0) // FI Over DI Ratio Value

#define USART2_NER_NB_ERRORS(value) (((value) & 0xFF) << 0) // Number of Errors

#define USART2_IF_IRDA_FILTER(value) (((value) & 0xFF) << 0) // IrDA Filter

#define USART2_MAN_TX_PL(value)   (((value) & 0xF) << 0)  // Transmitter Preamble Length
#define USART2_MAN_TX_PP_ALL_ONE  0x00000000              // The preamble is composed of '1's
#define USART2_MAN_TX_PP_ALL_ZERO 0x00000100              // The preamble is composed of '0's
#define USART2_MAN_TX_PP_ZERO_ONE 0x00000200              // The preamble is composed of '01's
#define USART2_MAN_TX_PP_ONE_ZERO 0x00000300              // The preamble is composed of '10's
#define USART2_MAN_TX_MPOL        0x00001000              // Transmitter Manchester Polarity
#define USART2_MAN_RX_PL(value)   (((value) & 0xF) << 16) // Receiver Preamble Length
#define USART2_MAN_RX_PP_ALL_ONE  0x00000000              // The preamble is composed of '1's
#define USART2_MAN_RX_PP_ALL_ZERO 0x01000000              // The preamble is composed of '0's
#define USART2_MAN_RX_PP_ZERO_ONE 0x02000000              // The preamble is composed of '01's
#define USART2_MAN_RX_PP_ONE_ZERO 0x03000000              // The preamble is composed of '10's
#define USART2_MAN_RX_MPOL        0x10000000              // Receiver Manchester Polarity
#define USART2_MAN_ONE            0x20000000              // Must Be Set to 1
#define USART2_MAN_DRIFT          0x40000000              // Drift Compensation

#define USART2_LINMR_NACT_PUBLISH   0x00000000              // The USART transmits the response
#define USART2_LINMR_NACT_SUBSCRIBE 0x00000001              // The USART receives the response
#define USART2_LINMR_NACT_IGNORE    0x00000002              // The USART does not transmit and does not receive the response
#define USART2_LINMR_PARDIS         0x00000004              // Parity Disable
#define USART2_LINMR_CHKDIS         0x00000008              // Checksum Disable
#define USART2_LINMR_CHKTYP         0x00000010              // Checksum Type
#define USART2_LINMR_DLM            0x00000020              // Data Length Mode
#define USART2_LINMR_FSDIS          0x00000040              // Frame Slot Mode Disable
#define USART2_LINMR_WKUPTYP        0x00000080              // Wakeup Signal Type
#define USART2_LINMR_DLC(value)     (((value) & 0xFF) << 8) // Data Length Control
#define USART2_LINMR_PDCM           0x00010000              // PDC Mode

#define USART2_LINIR_IDCHR(value) (((value) & 0xFF) << 0) // Identifier Character

#define USART2_LINBRR_LINCD(value) (((value) & 0xFFFF) << 0) // Clock Divider after Synchronization
#define USART2_LINBRR_LINFP(value) (((value) & 0x7) << 16)   // Fractional Part after Synchronization

#define USART2_WPMR_WPEN         0x00000001 // Write Protection Enable
#define USART2_WPMR_WPKEY_PASSWD 0x55534100 // Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0

#define USART2_WPSR_WPVS          0x00000001                // Write Protection Violation Status
#define USART2_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protection Violation Source

#define USART2_RPR_RXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Pointer Register

#define USART2_RCR_RXCTR(value) (((value) & 0xFFFF) << 0) // Receive Counter Register

#define USART2_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define USART2_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define USART2_RNPR_RXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Next Pointer

#define USART2_RNCR_RXNCTR(value) (((value) & 0xFFFF) << 0) // Receive Next Counter

#define USART2_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define USART2_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define USART2_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define USART2_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define USART2_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define USART2_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define USART2_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define USART2_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define USART3_CR           (*(volatile unsigned int *)0x400A4000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166548)
#define USART3_CR_SPI_MODE  (*(volatile unsigned int *)0x400A4000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166548)
#define USART3_MR           (*(volatile unsigned int *)0x400A4004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166791)
#define USART3_MR_SPI_MODE  (*(volatile unsigned int *)0x400A4004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1166791)
#define USART3_IER          (*(volatile unsigned int *)0x400A4008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART3_IER_SPI_MODE (*(volatile unsigned int *)0x400A4008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART3_IER_LIN_MODE (*(volatile unsigned int *)0x400A4008)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167357)
#define USART3_IDR          (*(volatile unsigned int *)0x400A400C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART3_IDR_SPI_MODE (*(volatile unsigned int *)0x400A400C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART3_IDR_LIN_MODE (*(volatile unsigned int *)0x400A400C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167566)
#define USART3_IMR          (*(const volatile unsigned int *)0x400A4010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART3_IMR_SPI_MODE (*(const volatile unsigned int *)0x400A4010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART3_IMR_LIN_MODE (*(const volatile unsigned int *)0x400A4010) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167774)
#define USART3_CSR          (*(const volatile unsigned int *)0x400A4014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART3_CSR_SPI_MODE (*(const volatile unsigned int *)0x400A4014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART3_CSR_LIN_MODE (*(const volatile unsigned int *)0x400A4014) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1167983)
#define USART3_RHR          (*(const volatile unsigned int *)0x400A4018) // [Receive Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168260)
#define USART3_THR          (*(volatile unsigned int *)0x400A401C)       // [Transmit Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168446)
#define USART3_BRGR         (*(volatile unsigned int *)0x400A4020)       // [Baud Rate Generator Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168632)
#define USART3_RTOR         (*(volatile unsigned int *)0x400A4024)       // [Receiver Time-out Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1168875)
#define USART3_TTGR         (*(volatile unsigned int *)0x400A4028)       // [Transmitter Timeguard Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169060)
#define USART3_FIDI         (*(volatile unsigned int *)0x400A4040)       // [FI DI Ratio Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169244)
#define USART3_NER          (*(const volatile unsigned int *)0x400A4044) // [Number of Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169428)
#define USART3_IF           (*(volatile unsigned int *)0x400A404C)       // [IrDA Filter Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1169611)
#define USART3_MAN          (*(volatile unsigned int *)0x400A4050)       // [Manchester Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1180048)
#define USART3_LINMR        (*(volatile unsigned int *)0x400A4054)       // [LIN Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1313805)
#define USART3_LINIR        (*(volatile unsigned int *)0x400A4058)       // [LIN Identifier Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1314055)
#define USART3_LINBRR       (*(const volatile unsigned int *)0x400A405C) // [LIN Baud Rate Register]()
#define USART3_WPMR         (*(volatile unsigned int *)0x400A40E4)       // [Write Protection Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1214665)
#define USART3_WPSR         (*(const volatile unsigned int *)0x400A40E8) // [Write Protection Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G26.1214895)
#define USART3_RPR          (*(volatile unsigned int *)0x400A4100)       // [Receive Pointer Register]()
#define USART3_RCR          (*(volatile unsigned int *)0x400A4104)       // [Receive Counter Register]()
#define USART3_TPR          (*(volatile unsigned int *)0x400A4108)       // [Transmit Pointer Register]()
#define USART3_TCR          (*(volatile unsigned int *)0x400A410C)       // [Transmit Counter Register]()
#define USART3_RNPR         (*(volatile unsigned int *)0x400A4110)       // [Receive Next Pointer Register]()
#define USART3_RNCR         (*(volatile unsigned int *)0x400A4114)       // [Receive Next Counter Register]()
#define USART3_TNPR         (*(volatile unsigned int *)0x400A4118)       // [Transmit Next Pointer Register]()
#define USART3_TNCR         (*(volatile unsigned int *)0x400A411C)       // [Transmit Next Counter Register]()
#define USART3_PTCR         (*(volatile unsigned int *)0x400A4120)       // [Transfer Control Register]()
#define USART3_PTSR         (*(const volatile unsigned int *)0x400A4124) // [Transfer Status Register]()

#define USART3_CR_RSTRX   0x00000004 // Reset Receiver
#define USART3_CR_RSTTX   0x00000008 // Reset Transmitter
#define USART3_CR_RXEN    0x00000010 // Receiver Enable
#define USART3_CR_RXDIS   0x00000020 // Receiver Disable
#define USART3_CR_TXEN    0x00000040 // Transmitter Enable
#define USART3_CR_TXDIS   0x00000080 // Transmitter Disable
#define USART3_CR_RSTSTA  0x00000100 // Reset Status Bits
#define USART3_CR_STTBRK  0x00000200 // Start Break
#define USART3_CR_STPBRK  0x00000400 // Stop Break
#define USART3_CR_STTTO   0x00000800 // Start Time-out
#define USART3_CR_SENDA   0x00001000 // Send Address
#define USART3_CR_RSTIT   0x00002000 // Reset Iterations
#define USART3_CR_RSTNACK 0x00004000 // Reset Non Acknowledge
#define USART3_CR_RETTO   0x00008000 // Rearm Time-out
#define USART3_CR_RTSEN   0x00040000 // Request to Send Enable
#define USART3_CR_RTSDIS  0x00080000 // Request to Send Disable
#define USART3_CR_LINABT  0x00100000 // Abort LIN Transmission
#define USART3_CR_LINWKUP 0x00200000 // Send LIN Wakeup Signal

#define USART3_CR_SPI_MODE_RSTRX  0x00000004 // Reset Receiver
#define USART3_CR_SPI_MODE_RSTTX  0x00000008 // Reset Transmitter
#define USART3_CR_SPI_MODE_RXEN   0x00000010 // Receiver Enable
#define USART3_CR_SPI_MODE_RXDIS  0x00000020 // Receiver Disable
#define USART3_CR_SPI_MODE_TXEN   0x00000040 // Transmitter Enable
#define USART3_CR_SPI_MODE_TXDIS  0x00000080 // Transmitter Disable
#define USART3_CR_SPI_MODE_RSTSTA 0x00000100 // Reset Status Bits
#define USART3_CR_SPI_MODE_FCS    0x00040000 // Force SPI Chip Select
#define USART3_CR_SPI_MODE_RCS    0x00080000 // Release SPI Chip Select

#define USART3_MR_USART_MODE_NORMAL         0x00000000              // Normal mode
#define USART3_MR_USART_MODE_RS485          0x00000001              // RS485
#define USART3_MR_USART_MODE_HW_HANDSHAKING 0x00000002              // Hardware Handshaking
#define USART3_MR_USART_MODE_IS07816_T_0    0x00000004              // IS07816 Protocol: T = 0
#define USART3_MR_USART_MODE_IS07816_T_1    0x00000006              // IS07816 Protocol: T = 1
#define USART3_MR_USART_MODE_IRDA           0x00000008              // IrDA
#define USART3_MR_USART_MODE_LIN_MASTER     0x0000000A              // LIN master
#define USART3_MR_USART_MODE_LIN_SLAVE      0x0000000B              // LIN Slave
#define USART3_MR_USART_MODE_SPI_MASTER     0x0000000E              // SPI master
#define USART3_MR_USART_MODE_SPI_SLAVE      0x0000000F              // SPI Slave
#define USART3_MR_USCLKS_MCK                0x00000000              // master Clock MCK is selected
#define USART3_MR_USCLKS_DIV                0x00000010              // Internal Clock Divided MCK/DIV (DIV=8) is selected
#define USART3_MR_USCLKS_SCK                0x00000030              // Serial Clock SLK is selected
#define USART3_MR_CHRL_5_BIT                0x00000000              // Character length is 5 bits
#define USART3_MR_CHRL_6_BIT                0x00000040              // Character length is 6 bits
#define USART3_MR_CHRL_7_BIT                0x00000080              // Character length is 7 bits
#define USART3_MR_CHRL_8_BIT                0x000000C0              // Character length is 8 bits
#define USART3_MR_SYNC                      0x00000100              // Synchronous Mode Select
#define USART3_MR_PAR_EVEN                  0x00000000              // Even parity
#define USART3_MR_PAR_ODD                   0x00000200              // Odd parity
#define USART3_MR_PAR_SPACE                 0x00000400              // Parity forced to 0 (Space)
#define USART3_MR_PAR_MARK                  0x00000600              // Parity forced to 1 (Mark)
#define USART3_MR_PAR_NO                    0x00000800              // No parity
#define USART3_MR_PAR_MULTIDROP             0x00000C00              // Multidrop mode
#define USART3_MR_NBSTOP_1_BIT              0x00000000              // 1 stop bit
#define USART3_MR_NBSTOP_1_5_BIT            0x00001000              // 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
#define USART3_MR_NBSTOP_2_BIT              0x00002000              // 2 stop bits
#define USART3_MR_CHMODE_NORMAL             0x00000000              // Normal mode
#define USART3_MR_CHMODE_AUTOMATIC          0x00004000              // Automatic Echo. Receiver input is connected to the TXD pin
#define USART3_MR_CHMODE_LOCAL_LOOPBACK     0x00008000              // Local Loopback. Transmitter output is connected to the Receiver Input
#define USART3_MR_CHMODE_REMOTE_LOOPBACK    0x0000C000              // Remote Loopback. RXD pin is internally connected to the TXD pin
#define USART3_MR_MSBF                      0x00010000              // Bit Order
#define USART3_MR_MODE9                     0x00020000              // 9-bit Character Length
#define USART3_MR_CLKO                      0x00040000              // Clock Output Select
#define USART3_MR_OVER                      0x00080000              // Oversampling Mode
#define USART3_MR_INACK                     0x00100000              // Inhibit Non Acknowledge
#define USART3_MR_DSNACK                    0x00200000              // Disable Successive NACK
#define USART3_MR_VAR_SYNC                  0x00400000              // Variable Synchronization of Command/Data Sync Start Frame Delimiter
#define USART3_MR_INVDATA                   0x00800000              // Inverted Data
#define USART3_MR_MAX_ITERATION(value)      (((value) & 0x7) << 24) // Maximum Number of Automatic Iteration
#define USART3_MR_FILTER                    0x10000000              // Infrared Receive Line Filter
#define USART3_MR_MAN                       0x20000000              // Manchester Encoder/Decoder Enable
#define USART3_MR_MODSYNC                   0x40000000              // Manchester Synchronization Mode
#define USART3_MR_ONEBIT                    0x80000000              // Start Frame Delimiter Selector

#define USART3_MR_SPI_MODE_USART_MODE_SPI_MASTER 0x0000000E // SPI master
#define USART3_MR_SPI_MODE_USART_MODE_SPI_SLAVE  0x0000000F // SPI Slave
#define USART3_MR_SPI_MODE_USCLKS_MCK            0x00000000 // master Clock MCK is selected
#define USART3_MR_SPI_MODE_USCLKS_DIV            0x00000010 // Internal Clock Divided MCK/DIV (DIV=8) is selected
#define USART3_MR_SPI_MODE_USCLKS_SCK            0x00000030 // Serial Clock SLK is selected
#define USART3_MR_SPI_MODE_CHRL_8_BIT            0x000000C0 // Character length is 8 bits
#define USART3_MR_SPI_MODE_CPHA                  0x00000100 // SPI Clock Phase
#define USART3_MR_SPI_MODE_CPOL                  0x00010000 // SPI Clock Polarity
#define USART3_MR_SPI_MODE_WRDBT                 0x00100000 // Wait Read Data Before Transfer

#define USART3_IER_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART3_IER_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART3_IER_RXBRK   0x00000004 // Receiver Break Interrupt Enable
#define USART3_IER_ENDRX   0x00000008 // End of Receive Transfer Interrupt Enable (available in all USART modes of operation)
#define USART3_IER_ENDTX   0x00000010 // End of Transmit Interrupt Enable (available in all USART modes of operation)
#define USART3_IER_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART3_IER_FRAME   0x00000040 // Framing Error Interrupt Enable
#define USART3_IER_PARE    0x00000080 // Parity Error Interrupt Enable
#define USART3_IER_TIMEOUT 0x00000100 // Time-out Interrupt Enable
#define USART3_IER_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART3_IER_ITER    0x00000400 // Max number of Repetitions Reached Interrupt Enable
#define USART3_IER_TXBUFE  0x00000800 // Buffer Empty Interrupt Enable (available in all USART modes of operation)
#define USART3_IER_RXBUFF  0x00001000 // Buffer Full Interrupt Enable (available in all USART modes of operation)
#define USART3_IER_NACK    0x00002000 // Non Acknowledge Interrupt Enable
#define USART3_IER_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Enable
#define USART3_IER_MANE    0x01000000 // Manchester Error Interrupt Enable

#define USART3_IER_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART3_IER_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART3_IER_SPI_MODE_ENDRX   0x00000008 //
#define USART3_IER_SPI_MODE_ENDTX   0x00000010 //
#define USART3_IER_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART3_IER_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART3_IER_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Enable
#define USART3_IER_SPI_MODE_TXBUFE  0x00000800 //
#define USART3_IER_SPI_MODE_RXBUFF  0x00001000 //

#define USART3_IER_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Enable
#define USART3_IER_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Enable
#define USART3_IER_LIN_MODE_ENDRX   0x00000008 //
#define USART3_IER_LIN_MODE_ENDTX   0x00000010 //
#define USART3_IER_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART3_IER_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Enable
#define USART3_IER_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Enable
#define USART3_IER_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Enable
#define USART3_IER_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Enable
#define USART3_IER_LIN_MODE_TXBUFE  0x00000800 //
#define USART3_IER_LIN_MODE_RXBUFF  0x00001000 //
#define USART3_IER_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Enable
#define USART3_IER_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Enable
#define USART3_IER_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Enable
#define USART3_IER_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Enable
#define USART3_IER_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Enable
#define USART3_IER_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Enable
#define USART3_IER_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Enable
#define USART3_IER_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Enable

#define USART3_IDR_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART3_IDR_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART3_IDR_RXBRK   0x00000004 // Receiver Break Interrupt Disable
#define USART3_IDR_ENDRX   0x00000008 // End of Receive Transfer Interrupt Disable (available in all USART modes of operation)
#define USART3_IDR_ENDTX   0x00000010 // End of Transmit Interrupt Disable (available in all USART modes of operation)
#define USART3_IDR_OVRE    0x00000020 // Overrun Error Interrupt Enable
#define USART3_IDR_FRAME   0x00000040 // Framing Error Interrupt Disable
#define USART3_IDR_PARE    0x00000080 // Parity Error Interrupt Disable
#define USART3_IDR_TIMEOUT 0x00000100 // Time-out Interrupt Disable
#define USART3_IDR_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART3_IDR_ITER    0x00000400 // Max Number of Repetitions Reached Interrupt Disable
#define USART3_IDR_TXBUFE  0x00000800 // Buffer Empty Interrupt Disable (available in all USART modes of operation)
#define USART3_IDR_RXBUFF  0x00001000 // Buffer Full Interrupt Disable (available in all USART modes of operation)
#define USART3_IDR_NACK    0x00002000 // Non Acknowledge Interrupt Disable
#define USART3_IDR_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Disable
#define USART3_IDR_MANE    0x01000000 // Manchester Error Interrupt Disable

#define USART3_IDR_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART3_IDR_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART3_IDR_SPI_MODE_ENDRX   0x00000008 //
#define USART3_IDR_SPI_MODE_ENDTX   0x00000010 //
#define USART3_IDR_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Disable
#define USART3_IDR_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART3_IDR_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Disable
#define USART3_IDR_SPI_MODE_TXBUFE  0x00000800 //
#define USART3_IDR_SPI_MODE_RXBUFF  0x00001000 //

#define USART3_IDR_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Disable
#define USART3_IDR_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Disable
#define USART3_IDR_LIN_MODE_ENDRX   0x00000008 //
#define USART3_IDR_LIN_MODE_ENDTX   0x00000010 //
#define USART3_IDR_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Disable
#define USART3_IDR_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Disable
#define USART3_IDR_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Disable
#define USART3_IDR_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Disable
#define USART3_IDR_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Disable
#define USART3_IDR_LIN_MODE_TXBUFE  0x00000800 //
#define USART3_IDR_LIN_MODE_RXBUFF  0x00001000 //
#define USART3_IDR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Disable
#define USART3_IDR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Disable
#define USART3_IDR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Disable
#define USART3_IDR_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Disable
#define USART3_IDR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Disable
#define USART3_IDR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Disable
#define USART3_IDR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Disable
#define USART3_IDR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Disable

#define USART3_IMR_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART3_IMR_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART3_IMR_RXBRK   0x00000004 // Receiver Break Interrupt Mask
#define USART3_IMR_ENDRX   0x00000008 // End of Receive Transfer Interrupt Mask (available in all USART modes of operation)
#define USART3_IMR_ENDTX   0x00000010 // End of Transmit Interrupt Mask (available in all USART modes of operation)
#define USART3_IMR_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART3_IMR_FRAME   0x00000040 // Framing Error Interrupt Mask
#define USART3_IMR_PARE    0x00000080 // Parity Error Interrupt Mask
#define USART3_IMR_TIMEOUT 0x00000100 // Time-out Interrupt Mask
#define USART3_IMR_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART3_IMR_ITER    0x00000400 // Max Number of Repetitions Reached Interrupt Mask
#define USART3_IMR_TXBUFE  0x00000800 // Buffer Empty Interrupt Mask (available in all USART modes of operation)
#define USART3_IMR_RXBUFF  0x00001000 // Buffer Full Interrupt Mask (available in all USART modes of operation)
#define USART3_IMR_NACK    0x00002000 // Non Acknowledge Interrupt Mask
#define USART3_IMR_CTSIC   0x00080000 // Clear to Send Input Change Interrupt Mask
#define USART3_IMR_MANE    0x01000000 // Manchester Error Interrupt Mask

#define USART3_IMR_SPI_MODE_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART3_IMR_SPI_MODE_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART3_IMR_SPI_MODE_ENDRX   0x00000008 //
#define USART3_IMR_SPI_MODE_ENDTX   0x00000010 //
#define USART3_IMR_SPI_MODE_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART3_IMR_SPI_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART3_IMR_SPI_MODE_UNRE    0x00000400 // SPI Underrun Error Interrupt Mask
#define USART3_IMR_SPI_MODE_TXBUFE  0x00000800 //
#define USART3_IMR_SPI_MODE_RXBUFF  0x00001000 //

#define USART3_IMR_LIN_MODE_RXRDY   0x00000001 // RXRDY Interrupt Mask
#define USART3_IMR_LIN_MODE_TXRDY   0x00000002 // TXRDY Interrupt Mask
#define USART3_IMR_LIN_MODE_ENDRX   0x00000008 //
#define USART3_IMR_LIN_MODE_ENDTX   0x00000010 //
#define USART3_IMR_LIN_MODE_OVRE    0x00000020 // Overrun Error Interrupt Mask
#define USART3_IMR_LIN_MODE_FRAME   0x00000040 // Framing Error Interrupt Mask
#define USART3_IMR_LIN_MODE_PARE    0x00000080 // Parity Error Interrupt Mask
#define USART3_IMR_LIN_MODE_TIMEOUT 0x00000100 // Time-out Interrupt Mask
#define USART3_IMR_LIN_MODE_TXEMPTY 0x00000200 // TXEMPTY Interrupt Mask
#define USART3_IMR_LIN_MODE_TXBUFE  0x00000800 //
#define USART3_IMR_LIN_MODE_RXBUFF  0x00001000 //
#define USART3_IMR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received Interrupt Mask
#define USART3_IMR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received Interrupt Mask
#define USART3_IMR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed Interrupt Mask
#define USART3_IMR_LIN_MODE_LINBE   0x02000000 // LIN Bus Error Interrupt Mask
#define USART3_IMR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error Interrupt Mask
#define USART3_IMR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Interrupt Mask
#define USART3_IMR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error Interrupt Mask
#define USART3_IMR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error Interrupt Mask

#define USART3_CSR_RXRDY   0x00000001 // Receiver Ready
#define USART3_CSR_TXRDY   0x00000002 // Transmitter Ready
#define USART3_CSR_RXBRK   0x00000004 // Break Received/End of Break
#define USART3_CSR_ENDRX   0x00000008 // End of Receiver Transfer
#define USART3_CSR_ENDTX   0x00000010 // End of Transmitter Transfer
#define USART3_CSR_OVRE    0x00000020 // Overrun Error
#define USART3_CSR_FRAME   0x00000040 // Framing Error
#define USART3_CSR_PARE    0x00000080 // Parity Error
#define USART3_CSR_TIMEOUT 0x00000100 // Receiver Time-out
#define USART3_CSR_TXEMPTY 0x00000200 // Transmitter Empty
#define USART3_CSR_ITER    0x00000400 // Max Number of Repetitions Reached
#define USART3_CSR_TXBUFE  0x00000800 // Transmission Buffer Empty
#define USART3_CSR_RXBUFF  0x00001000 // Reception Buffer Full
#define USART3_CSR_NACK    0x00002000 // Non Acknowledge Interrupt
#define USART3_CSR_CTSIC   0x00080000 // Clear to Send Input Change Flag
#define USART3_CSR_CTS     0x00800000 // Image of CTS Input
#define USART3_CSR_MANERR  0x01000000 // Manchester Error

#define USART3_CSR_SPI_MODE_RXRDY   0x00000001 // Receiver Ready
#define USART3_CSR_SPI_MODE_TXRDY   0x00000002 // Transmitter Ready
#define USART3_CSR_SPI_MODE_ENDRX   0x00000008 //
#define USART3_CSR_SPI_MODE_ENDTX   0x00000010 //
#define USART3_CSR_SPI_MODE_OVRE    0x00000020 // Overrun Error
#define USART3_CSR_SPI_MODE_TXEMPTY 0x00000200 // Transmitter Empty
#define USART3_CSR_SPI_MODE_UNRE    0x00000400 // Underrun Error
#define USART3_CSR_SPI_MODE_TXBUFE  0x00000800 //
#define USART3_CSR_SPI_MODE_RXBUFF  0x00001000 //

#define USART3_CSR_LIN_MODE_RXRDY   0x00000001 // Receiver Ready
#define USART3_CSR_LIN_MODE_TXRDY   0x00000002 // Transmitter Ready
#define USART3_CSR_LIN_MODE_ENDRX   0x00000008 //
#define USART3_CSR_LIN_MODE_ENDTX   0x00000010 //
#define USART3_CSR_LIN_MODE_OVRE    0x00000020 // Overrun Error
#define USART3_CSR_LIN_MODE_FRAME   0x00000040 // Framing Error
#define USART3_CSR_LIN_MODE_PARE    0x00000080 // Parity Error
#define USART3_CSR_LIN_MODE_TIMEOUT 0x00000100 // Receiver Time-out
#define USART3_CSR_LIN_MODE_TXEMPTY 0x00000200 // Transmitter Empty
#define USART3_CSR_LIN_MODE_TXBUFE  0x00000800 //
#define USART3_CSR_LIN_MODE_RXBUFF  0x00001000 //
#define USART3_CSR_LIN_MODE_LINBK   0x00002000 // LIN Break Sent or LIN Break Received
#define USART3_CSR_LIN_MODE_LINID   0x00004000 // LIN Identifier Sent or LIN Identifier Received
#define USART3_CSR_LIN_MODE_LINTC   0x00008000 // LIN Transfer Completed
#define USART3_CSR_LIN_MODE_LINBLS  0x00800000 // LIN Bus Line Status
#define USART3_CSR_LIN_MODE_LINBE   0x02000000 // LIN Bit Error
#define USART3_CSR_LIN_MODE_LINISFE 0x04000000 // LIN Inconsistent Synch Field Error
#define USART3_CSR_LIN_MODE_LINIPE  0x08000000 // LIN Identifier Parity Error
#define USART3_CSR_LIN_MODE_LINCE   0x10000000 // LIN Checksum Error
#define USART3_CSR_LIN_MODE_LINSNRE 0x20000000 // LIN Slave Not Responding Error

#define USART3_RHR_RXCHR(value) (((value) & 0x1FF) << 0) // Received Character
#define USART3_RHR_RXSYNH       0x00008000               // Received Sync

#define USART3_THR_TXCHR(value) (((value) & 0x1FF) << 0) // Character to be Transmitted
#define USART3_THR_TXSYNH       0x00008000               // Sync Field to be Transmitted

#define USART3_BRGR_CD(value) (((value) & 0xFFFF) << 0) // Clock Divider
#define USART3_BRGR_FP(value) (((value) & 0x7) << 16)   // Fractional Part

#define USART3_RTOR_TO(value) (((value) & 0x1FFFF) << 0) // Time-out Value

#define USART3_TTGR_TG(value) (((value) & 0xFF) << 0) // Timeguard Value

#define USART3_FIDI_FI_DI_RATIO(value) (((value) & 0x7FF) << 0) // FI Over DI Ratio Value

#define USART3_NER_NB_ERRORS(value) (((value) & 0xFF) << 0) // Number of Errors

#define USART3_IF_IRDA_FILTER(value) (((value) & 0xFF) << 0) // IrDA Filter

#define USART3_MAN_TX_PL(value)   (((value) & 0xF) << 0)  // Transmitter Preamble Length
#define USART3_MAN_TX_PP_ALL_ONE  0x00000000              // The preamble is composed of '1's
#define USART3_MAN_TX_PP_ALL_ZERO 0x00000100              // The preamble is composed of '0's
#define USART3_MAN_TX_PP_ZERO_ONE 0x00000200              // The preamble is composed of '01's
#define USART3_MAN_TX_PP_ONE_ZERO 0x00000300              // The preamble is composed of '10's
#define USART3_MAN_TX_MPOL        0x00001000              // Transmitter Manchester Polarity
#define USART3_MAN_RX_PL(value)   (((value) & 0xF) << 16) // Receiver Preamble Length
#define USART3_MAN_RX_PP_ALL_ONE  0x00000000              // The preamble is composed of '1's
#define USART3_MAN_RX_PP_ALL_ZERO 0x01000000              // The preamble is composed of '0's
#define USART3_MAN_RX_PP_ZERO_ONE 0x02000000              // The preamble is composed of '01's
#define USART3_MAN_RX_PP_ONE_ZERO 0x03000000              // The preamble is composed of '10's
#define USART3_MAN_RX_MPOL        0x10000000              // Receiver Manchester Polarity
#define USART3_MAN_ONE            0x20000000              // Must Be Set to 1
#define USART3_MAN_DRIFT          0x40000000              // Drift Compensation

#define USART3_LINMR_NACT_PUBLISH   0x00000000              // The USART transmits the response
#define USART3_LINMR_NACT_SUBSCRIBE 0x00000001              // The USART receives the response
#define USART3_LINMR_NACT_IGNORE    0x00000002              // The USART does not transmit and does not receive the response
#define USART3_LINMR_PARDIS         0x00000004              // Parity Disable
#define USART3_LINMR_CHKDIS         0x00000008              // Checksum Disable
#define USART3_LINMR_CHKTYP         0x00000010              // Checksum Type
#define USART3_LINMR_DLM            0x00000020              // Data Length Mode
#define USART3_LINMR_FSDIS          0x00000040              // Frame Slot Mode Disable
#define USART3_LINMR_WKUPTYP        0x00000080              // Wakeup Signal Type
#define USART3_LINMR_DLC(value)     (((value) & 0xFF) << 8) // Data Length Control
#define USART3_LINMR_PDCM           0x00010000              // PDC Mode

#define USART3_LINIR_IDCHR(value) (((value) & 0xFF) << 0) // Identifier Character

#define USART3_LINBRR_LINCD(value) (((value) & 0xFFFF) << 0) // Clock Divider after Synchronization
#define USART3_LINBRR_LINFP(value) (((value) & 0x7) << 16)   // Fractional Part after Synchronization

#define USART3_WPMR_WPEN         0x00000001 // Write Protection Enable
#define USART3_WPMR_WPKEY_PASSWD 0x55534100 // Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0

#define USART3_WPSR_WPVS          0x00000001                // Write Protection Violation Status
#define USART3_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protection Violation Source

#define USART3_RPR_RXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Pointer Register

#define USART3_RCR_RXCTR(value) (((value) & 0xFFFF) << 0) // Receive Counter Register

#define USART3_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define USART3_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define USART3_RNPR_RXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Next Pointer

#define USART3_RNCR_RXNCTR(value) (((value) & 0xFFFF) << 0) // Receive Next Counter

#define USART3_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define USART3_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define USART3_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define USART3_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define USART3_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define USART3_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define USART3_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define USART3_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define UOTGHS_DEVCTRL             (*(volatile unsigned int *)0x400AC000)       // [Device General Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1086178)
#define UOTGHS_DEVISR              (*(const volatile unsigned int *)0x400AC004) // [Device Global Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136017)
#define UOTGHS_DEVICR              (*(volatile unsigned int *)0x400AC008)       // [Device Global Interrupt Clear Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1086619)
#define UOTGHS_DEVIFR              (*(volatile unsigned int *)0x400AC00C)       // [Device Global Interrupt Set Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1102817)
#define UOTGHS_DEVIMR              (*(const volatile unsigned int *)0x400AC010) // [Device Global Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1086957)
#define UOTGHS_DEVIDR              (*(volatile unsigned int *)0x400AC014)       // [Device Global Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087127)
#define UOTGHS_DEVIER              (*(volatile unsigned int *)0x400AC018)       // [Device Global Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087296)
#define UOTGHS_DEVEPT              (*(volatile unsigned int *)0x400AC01C)       // [Device Endpoint Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087465)
#define UOTGHS_DEVFNUM             (*(const volatile unsigned int *)0x400AC020) // [Device Frame Number Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087640)
#define UOTGHS_DEVEPTCFG0          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG1          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG2          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG3          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG4          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG5          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG6          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG7          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG8          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTCFG9          (*(volatile unsigned int *)0x400AC104)       // [Device Endpoint Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1087833)
#define UOTGHS_DEVEPTISR0          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR1          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR2          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR3          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR4          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR5          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR6          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR7          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR8          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR9          (*(const volatile unsigned int *)0x400AC134) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTISR0_ISOENPT  (*(const volatile unsigned int *)0x400AC130) // [Device Endpoint Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1103025)
#define UOTGHS_DEVEPTICR0          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR1          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR2          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR3          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR4          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR5          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR6          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR7          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR8          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR9          (*(volatile unsigned int *)0x400AC164)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTICR0_ISOENPT  (*(volatile unsigned int *)0x400AC160)       // [Device Endpoint Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088572)
#define UOTGHS_DEVEPTIFR0          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR1          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR2          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR3          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR4          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR5          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR6          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR7          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR8          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR9          (*(volatile unsigned int *)0x400AC194)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIFR0_ISOENPT  (*(volatile unsigned int *)0x400AC190)       // [Device Endpoint Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088744)
#define UOTGHS_DEVEPTIMR0          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR1          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR2          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR3          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR4          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR5          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR6          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR7          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR8          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR9          (*(const volatile unsigned int *)0x400AC1C4) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIMR0_ISOENPT  (*(const volatile unsigned int *)0x400AC1C0) // [Device Endpoint Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1088916)
#define UOTGHS_DEVEPTIER0          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER1          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER2          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER3          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER4          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER5          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER6          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER7          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER8          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER9          (*(volatile unsigned int *)0x400AC1F4)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIER0_ISOENPT  (*(volatile unsigned int *)0x400AC1F0)       // [Device Endpoint Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089339)
#define UOTGHS_DEVEPTIDR0          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR1          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR2          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR3          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR4          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR5          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR6          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR7          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR8          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR9          (*(volatile unsigned int *)0x400AC224)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVEPTIDR0_ISOENPT  (*(volatile unsigned int *)0x400AC220)       // [Device Endpoint Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089167)
#define UOTGHS_DEVDMANXTDSC1       (*(volatile unsigned int *)0x400AC310)       // [Device DMA Channel Next Descriptor Address Register (n = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089512)
#define UOTGHS_DEVDMAADDRESS1      (*(volatile unsigned int *)0x400AC314)       // [Device DMA Channel Address Register (n = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089685)
#define UOTGHS_DEVDMACONTROL1      (*(volatile unsigned int *)0x400AC318)       // [Device DMA Channel Control Register (n = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089865)
#define UOTGHS_DEVDMASTATUS1       (*(volatile unsigned int *)0x400AC31C)       // [Device DMA Channel Status Register (n = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090103)
#define UOTGHS_DEVDMANXTDSC2       (*(volatile unsigned int *)0x400AC320)       // [Device DMA Channel Next Descriptor Address Register (n = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089512)
#define UOTGHS_DEVDMAADDRESS2      (*(volatile unsigned int *)0x400AC324)       // [Device DMA Channel Address Register (n = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089685)
#define UOTGHS_DEVDMACONTROL2      (*(volatile unsigned int *)0x400AC328)       // [Device DMA Channel Control Register (n = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089865)
#define UOTGHS_DEVDMASTATUS2       (*(volatile unsigned int *)0x400AC32C)       // [Device DMA Channel Status Register (n = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090103)
#define UOTGHS_DEVDMANXTDSC3       (*(volatile unsigned int *)0x400AC330)       // [Device DMA Channel Next Descriptor Address Register (n = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089512)
#define UOTGHS_DEVDMAADDRESS3      (*(volatile unsigned int *)0x400AC334)       // [Device DMA Channel Address Register (n = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089685)
#define UOTGHS_DEVDMACONTROL3      (*(volatile unsigned int *)0x400AC338)       // [Device DMA Channel Control Register (n = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089865)
#define UOTGHS_DEVDMASTATUS3       (*(volatile unsigned int *)0x400AC33C)       // [Device DMA Channel Status Register (n = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090103)
#define UOTGHS_DEVDMANXTDSC4       (*(volatile unsigned int *)0x400AC340)       // [Device DMA Channel Next Descriptor Address Register (n = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089512)
#define UOTGHS_DEVDMAADDRESS4      (*(volatile unsigned int *)0x400AC344)       // [Device DMA Channel Address Register (n = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089685)
#define UOTGHS_DEVDMACONTROL4      (*(volatile unsigned int *)0x400AC348)       // [Device DMA Channel Control Register (n = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089865)
#define UOTGHS_DEVDMASTATUS4       (*(volatile unsigned int *)0x400AC34C)       // [Device DMA Channel Status Register (n = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090103)
#define UOTGHS_DEVDMANXTDSC5       (*(volatile unsigned int *)0x400AC350)       // [Device DMA Channel Next Descriptor Address Register (n = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089512)
#define UOTGHS_DEVDMAADDRESS5      (*(volatile unsigned int *)0x400AC354)       // [Device DMA Channel Address Register (n = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089685)
#define UOTGHS_DEVDMACONTROL5      (*(volatile unsigned int *)0x400AC358)       // [Device DMA Channel Control Register (n = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089865)
#define UOTGHS_DEVDMASTATUS5       (*(volatile unsigned int *)0x400AC35C)       // [Device DMA Channel Status Register (n = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090103)
#define UOTGHS_DEVDMANXTDSC6       (*(volatile unsigned int *)0x400AC360)       // [Device DMA Channel Next Descriptor Address Register (n = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089512)
#define UOTGHS_DEVDMAADDRESS6      (*(volatile unsigned int *)0x400AC364)       // [Device DMA Channel Address Register (n = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089685)
#define UOTGHS_DEVDMACONTROL6      (*(volatile unsigned int *)0x400AC368)       // [Device DMA Channel Control Register (n = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1089865)
#define UOTGHS_DEVDMASTATUS6       (*(volatile unsigned int *)0x400AC36C)       // [Device DMA Channel Status Register (n = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090103)
#define UOTGHS_HSTCTRL             (*(volatile unsigned int *)0x400AC400)       // [Host General Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090296)
#define UOTGHS_HSTISR              (*(const volatile unsigned int *)0x400AC404) // [Host Global Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090524)
#define UOTGHS_HSTICR              (*(volatile unsigned int *)0x400AC408)       // [Host Global Interrupt Clear Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090719)
#define UOTGHS_HSTIFR              (*(volatile unsigned int *)0x400AC40C)       // [Host Global Interrupt Set Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1090888)
#define UOTGHS_HSTIMR              (*(const volatile unsigned int *)0x400AC410) // [Host Global Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1091057)
#define UOTGHS_HSTIDR              (*(volatile unsigned int *)0x400AC414)       // [Host Global Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1091250)
#define UOTGHS_HSTIER              (*(volatile unsigned int *)0x400AC418)       // [Host Global Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1091419)
#define UOTGHS_HSTPIP              (*(volatile unsigned int *)0x400AC41C)       // [Host Pipe Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092322)
#define UOTGHS_HSTFNUM             (*(volatile unsigned int *)0x400AC420)       // [Host Frame Number Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1091588)
#define UOTGHS_HSTADDR1            (*(volatile unsigned int *)0x400AC424)       // [Host Address 1 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1100830)
#define UOTGHS_HSTADDR2            (*(volatile unsigned int *)0x400AC428)       // [Host Address 2 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1091959)
#define UOTGHS_HSTADDR3            (*(volatile unsigned int *)0x400AC42C)       // [Host Address 3 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092153)
#define UOTGHS_HSTPIPCFG0          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG1          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG2          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG3          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG4          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG5          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG6          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG7          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG8          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG9          (*(volatile unsigned int *)0x400AC504)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPCFG0_HSBOHSCP (*(volatile unsigned int *)0x400AC500)       // [Host Pipe Configuration Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092498)
#define UOTGHS_HSTPIPISR0          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR1          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR2          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR3          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR4          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR5          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR6          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR7          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR8          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR9          (*(const volatile unsigned int *)0x400AC534) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR0_INTPIPES (*(const volatile unsigned int *)0x400AC530) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPISR0_ISOPIPES (*(const volatile unsigned int *)0x400AC530) // [Host Pipe Status Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1092863)
#define UOTGHS_HSTPIPICR0          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR1          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR2          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR3          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR4          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR5          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR6          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR7          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR8          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR9          (*(volatile unsigned int *)0x400AC564)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR0_INTPIPES (*(volatile unsigned int *)0x400AC560)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPICR0_ISOPIPES (*(volatile unsigned int *)0x400AC560)       // [Host Pipe Clear Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093182)
#define UOTGHS_HSTPIPIFR0          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR1          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR2          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR3          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR4          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR5          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR6          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR7          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR8          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR9          (*(volatile unsigned int *)0x400AC594)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR0_INTPIPES (*(volatile unsigned int *)0x400AC590)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIFR0_ISOPIPES (*(volatile unsigned int *)0x400AC590)       // [Host Pipe Set Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1136811)
#define UOTGHS_HSTPIPIMR0          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR1          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR2          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR3          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR4          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR5          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR6          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR7          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR8          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR9          (*(const volatile unsigned int *)0x400AC5C4) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR0_INTPIPES (*(const volatile unsigned int *)0x400AC5C0) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIMR0_ISOPIPES (*(const volatile unsigned int *)0x400AC5C0) // [Host Pipe Mask Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093526)
#define UOTGHS_HSTPIPIER0          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER1          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER2          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER3          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER4          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER5          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER6          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER7          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER8          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER9          (*(volatile unsigned int *)0x400AC5F4)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER0_INTPIPES (*(volatile unsigned int *)0x400AC5F0)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIER0_ISOPIPES (*(volatile unsigned int *)0x400AC5F0)       // [Host Pipe Enable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093916)
#define UOTGHS_HSTPIPIDR0          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR1          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR2          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR3          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR4          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR5          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR6          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR7          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR8          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR9          (*(volatile unsigned int *)0x400AC624)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR0_INTPIPES (*(volatile unsigned int *)0x400AC620)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPIDR0_ISOPIPES (*(volatile unsigned int *)0x400AC620)       // [Host Pipe Disable Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1093743)
#define UOTGHS_HSTPIPINRQ0         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ1         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ2         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ3         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ4         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ5         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ6         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ7         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ8         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPINRQ9         (*(volatile unsigned int *)0x400AC654)       // [Host Pipe IN Request Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094089)
#define UOTGHS_HSTPIPERR0          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR1          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR2          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR3          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR4          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR5          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR6          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR7          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR8          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTPIPERR9          (*(volatile unsigned int *)0x400AC684)       // [Host Pipe Error Register (n = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094264)
#define UOTGHS_HSTDMANXTDSC1       (*(volatile unsigned int *)0x400AC710)       // [Host DMA Channel Next Descriptor Address Register (n = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1104242)
#define UOTGHS_HSTDMAADDRESS1      (*(volatile unsigned int *)0x400AC714)       // [Host DMA Channel Address Register (n = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094631)
#define UOTGHS_HSTDMACONTROL1      (*(volatile unsigned int *)0x400AC718)       // [Host DMA Channel Control Register (n = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094804)
#define UOTGHS_HSTDMASTATUS1       (*(volatile unsigned int *)0x400AC71C)       // [Host DMA Channel Status Register (n = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094978)
#define UOTGHS_HSTDMANXTDSC2       (*(volatile unsigned int *)0x400AC720)       // [Host DMA Channel Next Descriptor Address Register (n = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1104242)
#define UOTGHS_HSTDMAADDRESS2      (*(volatile unsigned int *)0x400AC724)       // [Host DMA Channel Address Register (n = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094631)
#define UOTGHS_HSTDMACONTROL2      (*(volatile unsigned int *)0x400AC728)       // [Host DMA Channel Control Register (n = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094804)
#define UOTGHS_HSTDMASTATUS2       (*(volatile unsigned int *)0x400AC72C)       // [Host DMA Channel Status Register (n = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094978)
#define UOTGHS_HSTDMANXTDSC3       (*(volatile unsigned int *)0x400AC730)       // [Host DMA Channel Next Descriptor Address Register (n = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1104242)
#define UOTGHS_HSTDMAADDRESS3      (*(volatile unsigned int *)0x400AC734)       // [Host DMA Channel Address Register (n = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094631)
#define UOTGHS_HSTDMACONTROL3      (*(volatile unsigned int *)0x400AC738)       // [Host DMA Channel Control Register (n = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094804)
#define UOTGHS_HSTDMASTATUS3       (*(volatile unsigned int *)0x400AC73C)       // [Host DMA Channel Status Register (n = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094978)
#define UOTGHS_HSTDMANXTDSC4       (*(volatile unsigned int *)0x400AC740)       // [Host DMA Channel Next Descriptor Address Register (n = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1104242)
#define UOTGHS_HSTDMAADDRESS4      (*(volatile unsigned int *)0x400AC744)       // [Host DMA Channel Address Register (n = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094631)
#define UOTGHS_HSTDMACONTROL4      (*(volatile unsigned int *)0x400AC748)       // [Host DMA Channel Control Register (n = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094804)
#define UOTGHS_HSTDMASTATUS4       (*(volatile unsigned int *)0x400AC74C)       // [Host DMA Channel Status Register (n = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094978)
#define UOTGHS_HSTDMANXTDSC5       (*(volatile unsigned int *)0x400AC750)       // [Host DMA Channel Next Descriptor Address Register (n = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1104242)
#define UOTGHS_HSTDMAADDRESS5      (*(volatile unsigned int *)0x400AC754)       // [Host DMA Channel Address Register (n = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094631)
#define UOTGHS_HSTDMACONTROL5      (*(volatile unsigned int *)0x400AC758)       // [Host DMA Channel Control Register (n = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094804)
#define UOTGHS_HSTDMASTATUS5       (*(volatile unsigned int *)0x400AC75C)       // [Host DMA Channel Status Register (n = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094978)
#define UOTGHS_HSTDMANXTDSC6       (*(volatile unsigned int *)0x400AC760)       // [Host DMA Channel Next Descriptor Address Register (n = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1104242)
#define UOTGHS_HSTDMAADDRESS6      (*(volatile unsigned int *)0x400AC764)       // [Host DMA Channel Address Register (n = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094631)
#define UOTGHS_HSTDMACONTROL6      (*(volatile unsigned int *)0x400AC768)       // [Host DMA Channel Control Register (n = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094804)
#define UOTGHS_HSTDMASTATUS6       (*(volatile unsigned int *)0x400AC76C)       // [Host DMA Channel Status Register (n = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1094978)
#define UOTGHS_CTRL                (*(volatile unsigned int *)0x400AC800)       // [General Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1102364)
#define UOTGHS_SR                  (*(const volatile unsigned int *)0x400AC804) // [General Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1084250)
#define UOTGHS_SCR                 (*(volatile unsigned int *)0x400AC808)       // [General Status Clear Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1084497)
#define UOTGHS_SFR                 (*(volatile unsigned int *)0x400AC80C)       // [General Status Set Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1084666)
#define UOTGHS_FSM                 (*(const volatile unsigned int *)0x400AC82C) // [General Finite State Machine Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G30.1085939)

#define UOTGHS_DEVCTRL_UADD(value)        (((value) & 0x7F) << 0) // USB Address
#define UOTGHS_DEVCTRL_ADDEN              0x00000080              // Address Enable
#define UOTGHS_DEVCTRL_DETACH             0x00000100              // Detach
#define UOTGHS_DEVCTRL_RMWKUP             0x00000200              // Remote Wake-Up
#define UOTGHS_DEVCTRL_SPDCONF_NORMAL     0x00000000              // The peripheral starts in full-speed mode and performs a high-speed reset to switch to the high-speed mode if the host is high-speed capable
#define UOTGHS_DEVCTRL_SPDCONF_LOW_POWER  0x00000400              // For a better consumption, if high-speed is not needed
#define UOTGHS_DEVCTRL_SPDCONF_HIGH_SPEED 0x00000800              // Forced high speed
#define UOTGHS_DEVCTRL_SPDCONF_FORCED_FS  0x00000C00              // The peripheral remains in full-speed mode whatever the host speed capability
#define UOTGHS_DEVCTRL_LS                 0x00001000              // Low-Speed Mode Force
#define UOTGHS_DEVCTRL_TSTJ               0x00002000              // Test mode J
#define UOTGHS_DEVCTRL_TSTK               0x00004000              // Test mode K
#define UOTGHS_DEVCTRL_TSTPCKT            0x00008000              // Test packet mode
#define UOTGHS_DEVCTRL_OPMODE2            0x00010000              // Specific Operational mode

#define UOTGHS_DEVISR_SUSP   0x00000001 // Suspend Interrupt
#define UOTGHS_DEVISR_MSOF   0x00000002 // Micro Start of Frame Interrupt
#define UOTGHS_DEVISR_SOF    0x00000004 // Start of Frame Interrupt
#define UOTGHS_DEVISR_EORST  0x00000008 // End of Reset Interrupt
#define UOTGHS_DEVISR_WAKEUP 0x00000010 // Wake-Up Interrupt
#define UOTGHS_DEVISR_EORSM  0x00000020 // End of Resume Interrupt
#define UOTGHS_DEVISR_UPRSM  0x00000040 // Upstream Resume Interrupt
#define UOTGHS_DEVISR_PEP_0  0x00001000 // Endpoint 0 Interrupt
#define UOTGHS_DEVISR_PEP_1  0x00002000 // Endpoint 1 Interrupt
#define UOTGHS_DEVISR_PEP_2  0x00004000 // Endpoint 2 Interrupt
#define UOTGHS_DEVISR_PEP_3  0x00008000 // Endpoint 3 Interrupt
#define UOTGHS_DEVISR_PEP_4  0x00010000 // Endpoint 4 Interrupt
#define UOTGHS_DEVISR_PEP_5  0x00020000 // Endpoint 5 Interrupt
#define UOTGHS_DEVISR_PEP_6  0x00040000 // Endpoint 6 Interrupt
#define UOTGHS_DEVISR_PEP_7  0x00080000 // Endpoint 7 Interrupt
#define UOTGHS_DEVISR_PEP_8  0x00100000 // Endpoint 8 Interrupt
#define UOTGHS_DEVISR_PEP_9  0x00200000 // Endpoint 9 Interrupt
#define UOTGHS_DEVISR_DMA_1  0x02000000 // DMA Channel 1 Interrupt
#define UOTGHS_DEVISR_DMA_2  0x04000000 // DMA Channel 2 Interrupt
#define UOTGHS_DEVISR_DMA_3  0x08000000 // DMA Channel 3 Interrupt
#define UOTGHS_DEVISR_DMA_4  0x10000000 // DMA Channel 4 Interrupt
#define UOTGHS_DEVISR_DMA_5  0x20000000 // DMA Channel 5 Interrupt
#define UOTGHS_DEVISR_DMA_6  0x40000000 // DMA Channel 6 Interrupt

#define UOTGHS_DEVICR_SUSPC   0x00000001 // Suspend Interrupt Clear
#define UOTGHS_DEVICR_MSOFC   0x00000002 // Micro Start of Frame Interrupt Clear
#define UOTGHS_DEVICR_SOFC    0x00000004 // Start of Frame Interrupt Clear
#define UOTGHS_DEVICR_EORSTC  0x00000008 // End of Reset Interrupt Clear
#define UOTGHS_DEVICR_WAKEUPC 0x00000010 // Wake-Up Interrupt Clear
#define UOTGHS_DEVICR_EORSMC  0x00000020 // End of Resume Interrupt Clear
#define UOTGHS_DEVICR_UPRSMC  0x00000040 // Upstream Resume Interrupt Clear

#define UOTGHS_DEVIFR_SUSPS   0x00000001 // Suspend Interrupt Set
#define UOTGHS_DEVIFR_MSOFS   0x00000002 // Micro Start of Frame Interrupt Set
#define UOTGHS_DEVIFR_SOFS    0x00000004 // Start of Frame Interrupt Set
#define UOTGHS_DEVIFR_EORSTS  0x00000008 // End of Reset Interrupt Set
#define UOTGHS_DEVIFR_WAKEUPS 0x00000010 // Wake-Up Interrupt Set
#define UOTGHS_DEVIFR_EORSMS  0x00000020 // End of Resume Interrupt Set
#define UOTGHS_DEVIFR_UPRSMS  0x00000040 // Upstream Resume Interrupt Set
#define UOTGHS_DEVIFR_DMA_1   0x02000000 // DMA Channel 1 Interrupt Set
#define UOTGHS_DEVIFR_DMA_2   0x04000000 // DMA Channel 2 Interrupt Set
#define UOTGHS_DEVIFR_DMA_3   0x08000000 // DMA Channel 3 Interrupt Set
#define UOTGHS_DEVIFR_DMA_4   0x10000000 // DMA Channel 4 Interrupt Set
#define UOTGHS_DEVIFR_DMA_5   0x20000000 // DMA Channel 5 Interrupt Set
#define UOTGHS_DEVIFR_DMA_6   0x40000000 // DMA Channel 6 Interrupt Set

#define UOTGHS_DEVIMR_SUSPE   0x00000001 // Suspend Interrupt Mask
#define UOTGHS_DEVIMR_MSOFE   0x00000002 // Micro Start of Frame Interrupt Mask
#define UOTGHS_DEVIMR_SOFE    0x00000004 // Start of Frame Interrupt Mask
#define UOTGHS_DEVIMR_EORSTE  0x00000008 // End of Reset Interrupt Mask
#define UOTGHS_DEVIMR_WAKEUPE 0x00000010 // Wake-Up Interrupt Mask
#define UOTGHS_DEVIMR_EORSME  0x00000020 // End of Resume Interrupt Mask
#define UOTGHS_DEVIMR_UPRSME  0x00000040 // Upstream Resume Interrupt Mask
#define UOTGHS_DEVIMR_PEP_0   0x00001000 // Endpoint 0 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_1   0x00002000 // Endpoint 1 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_2   0x00004000 // Endpoint 2 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_3   0x00008000 // Endpoint 3 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_4   0x00010000 // Endpoint 4 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_5   0x00020000 // Endpoint 5 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_6   0x00040000 // Endpoint 6 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_7   0x00080000 // Endpoint 7 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_8   0x00100000 // Endpoint 8 Interrupt Mask
#define UOTGHS_DEVIMR_PEP_9   0x00200000 // Endpoint 9 Interrupt Mask
#define UOTGHS_DEVIMR_DMA_1   0x02000000 // DMA Channel 1 Interrupt Mask
#define UOTGHS_DEVIMR_DMA_2   0x04000000 // DMA Channel 2 Interrupt Mask
#define UOTGHS_DEVIMR_DMA_3   0x08000000 // DMA Channel 3 Interrupt Mask
#define UOTGHS_DEVIMR_DMA_4   0x10000000 // DMA Channel 4 Interrupt Mask
#define UOTGHS_DEVIMR_DMA_5   0x20000000 // DMA Channel 5 Interrupt Mask
#define UOTGHS_DEVIMR_DMA_6   0x40000000 // DMA Channel 6 Interrupt Mask

#define UOTGHS_DEVIDR_SUSPEC   0x00000001 // Suspend Interrupt Disable
#define UOTGHS_DEVIDR_MSOFEC   0x00000002 // Micro Start of Frame Interrupt Disable
#define UOTGHS_DEVIDR_SOFEC    0x00000004 // Start of Frame Interrupt Disable
#define UOTGHS_DEVIDR_EORSTEC  0x00000008 // End of Reset Interrupt Disable
#define UOTGHS_DEVIDR_WAKEUPEC 0x00000010 // Wake-Up Interrupt Disable
#define UOTGHS_DEVIDR_EORSMEC  0x00000020 // End of Resume Interrupt Disable
#define UOTGHS_DEVIDR_UPRSMEC  0x00000040 // Upstream Resume Interrupt Disable
#define UOTGHS_DEVIDR_PEP_0    0x00001000 // Endpoint 0 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_1    0x00002000 // Endpoint 1 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_2    0x00004000 // Endpoint 2 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_3    0x00008000 // Endpoint 3 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_4    0x00010000 // Endpoint 4 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_5    0x00020000 // Endpoint 5 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_6    0x00040000 // Endpoint 6 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_7    0x00080000 // Endpoint 7 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_8    0x00100000 // Endpoint 8 Interrupt Disable
#define UOTGHS_DEVIDR_PEP_9    0x00200000 // Endpoint 9 Interrupt Disable
#define UOTGHS_DEVIDR_DMA_1    0x02000000 // DMA Channel 1 Interrupt Disable
#define UOTGHS_DEVIDR_DMA_2    0x04000000 // DMA Channel 2 Interrupt Disable
#define UOTGHS_DEVIDR_DMA_3    0x08000000 // DMA Channel 3 Interrupt Disable
#define UOTGHS_DEVIDR_DMA_4    0x10000000 // DMA Channel 4 Interrupt Disable
#define UOTGHS_DEVIDR_DMA_5    0x20000000 // DMA Channel 5 Interrupt Disable
#define UOTGHS_DEVIDR_DMA_6    0x40000000 // DMA Channel 6 Interrupt Disable

#define UOTGHS_DEVIER_SUSPES   0x00000001 // Suspend Interrupt Enable
#define UOTGHS_DEVIER_MSOFES   0x00000002 // Micro Start of Frame Interrupt Enable
#define UOTGHS_DEVIER_SOFES    0x00000004 // Start of Frame Interrupt Enable
#define UOTGHS_DEVIER_EORSTES  0x00000008 // End of Reset Interrupt Enable
#define UOTGHS_DEVIER_WAKEUPES 0x00000010 // Wake-Up Interrupt Enable
#define UOTGHS_DEVIER_EORSMES  0x00000020 // End of Resume Interrupt Enable
#define UOTGHS_DEVIER_UPRSMES  0x00000040 // Upstream Resume Interrupt Enable
#define UOTGHS_DEVIER_PEP_0    0x00001000 // Endpoint 0 Interrupt Enable
#define UOTGHS_DEVIER_PEP_1    0x00002000 // Endpoint 1 Interrupt Enable
#define UOTGHS_DEVIER_PEP_2    0x00004000 // Endpoint 2 Interrupt Enable
#define UOTGHS_DEVIER_PEP_3    0x00008000 // Endpoint 3 Interrupt Enable
#define UOTGHS_DEVIER_PEP_4    0x00010000 // Endpoint 4 Interrupt Enable
#define UOTGHS_DEVIER_PEP_5    0x00020000 // Endpoint 5 Interrupt Enable
#define UOTGHS_DEVIER_PEP_6    0x00040000 // Endpoint 6 Interrupt Enable
#define UOTGHS_DEVIER_PEP_7    0x00080000 // Endpoint 7 Interrupt Enable
#define UOTGHS_DEVIER_PEP_8    0x00100000 // Endpoint 8 Interrupt Enable
#define UOTGHS_DEVIER_PEP_9    0x00200000 // Endpoint 9 Interrupt Enable
#define UOTGHS_DEVIER_DMA_1    0x02000000 // DMA Channel 1 Interrupt Enable
#define UOTGHS_DEVIER_DMA_2    0x04000000 // DMA Channel 2 Interrupt Enable
#define UOTGHS_DEVIER_DMA_3    0x08000000 // DMA Channel 3 Interrupt Enable
#define UOTGHS_DEVIER_DMA_4    0x10000000 // DMA Channel 4 Interrupt Enable
#define UOTGHS_DEVIER_DMA_5    0x20000000 // DMA Channel 5 Interrupt Enable
#define UOTGHS_DEVIER_DMA_6    0x40000000 // DMA Channel 6 Interrupt Enable

#define UOTGHS_DEVEPT_EPEN0  0x00000001 // Endpoint 0 Enable
#define UOTGHS_DEVEPT_EPEN1  0x00000002 // Endpoint 1 Enable
#define UOTGHS_DEVEPT_EPEN2  0x00000004 // Endpoint 2 Enable
#define UOTGHS_DEVEPT_EPEN3  0x00000008 // Endpoint 3 Enable
#define UOTGHS_DEVEPT_EPEN4  0x00000010 // Endpoint 4 Enable
#define UOTGHS_DEVEPT_EPEN5  0x00000020 // Endpoint 5 Enable
#define UOTGHS_DEVEPT_EPEN6  0x00000040 // Endpoint 6 Enable
#define UOTGHS_DEVEPT_EPEN7  0x00000080 // Endpoint 7 Enable
#define UOTGHS_DEVEPT_EPEN8  0x00000100 // Endpoint 8 Enable
#define UOTGHS_DEVEPT_EPRST0 0x00010000 // Endpoint 0 Reset
#define UOTGHS_DEVEPT_EPRST1 0x00020000 // Endpoint 1 Reset
#define UOTGHS_DEVEPT_EPRST2 0x00040000 // Endpoint 2 Reset
#define UOTGHS_DEVEPT_EPRST3 0x00080000 // Endpoint 3 Reset
#define UOTGHS_DEVEPT_EPRST4 0x00100000 // Endpoint 4 Reset
#define UOTGHS_DEVEPT_EPRST5 0x00200000 // Endpoint 5 Reset
#define UOTGHS_DEVEPT_EPRST6 0x00400000 // Endpoint 6 Reset
#define UOTGHS_DEVEPT_EPRST7 0x00800000 // Endpoint 7 Reset
#define UOTGHS_DEVEPT_EPRST8 0x01000000 // Endpoint 8 Reset

#define UOTGHS_DEVFNUM_MFNUM(value) (((value) & 0x7) << 0)   // Micro Frame Number
#define UOTGHS_DEVFNUM_FNUM(value)  (((value) & 0x7FF) << 3) // Frame Number
#define UOTGHS_DEVFNUM_FNCERR       0x00008000               // Frame Number CRC Error

#define UOTGHS_DEVEPTCFG_ALLOC            0x00000002 // Endpoint Memory Allocate
#define UOTGHS_DEVEPTCFG_EPBK_1_BANK      0x00000000 // Single-bank endpoint
#define UOTGHS_DEVEPTCFG_EPBK_2_BANK      0x00000004 // Double-bank endpoint
#define UOTGHS_DEVEPTCFG_EPBK_3_BANK      0x00000008 // Triple-bank endpoint
#define UOTGHS_DEVEPTCFG_EPSIZE_8_BYTE    0x00000000 // 8 bytes
#define UOTGHS_DEVEPTCFG_EPSIZE_16_BYTE   0x00000010 // 16 bytes
#define UOTGHS_DEVEPTCFG_EPSIZE_32_BYTE   0x00000020 // 32 bytes
#define UOTGHS_DEVEPTCFG_EPSIZE_64_BYTE   0x00000030 // 64 bytes
#define UOTGHS_DEVEPTCFG_EPSIZE_128_BYTE  0x00000040 // 128 bytes
#define UOTGHS_DEVEPTCFG_EPSIZE_256_BYTE  0x00000050 // 256 bytes
#define UOTGHS_DEVEPTCFG_EPSIZE_512_BYTE  0x00000060 // 512 bytes
#define UOTGHS_DEVEPTCFG_EPSIZE_1024_BYTE 0x00000070 // 1024 bytes
#define UOTGHS_DEVEPTCFG_EPDIR_OUT        0x00000000 // The endpoint direction is OUT
#define UOTGHS_DEVEPTCFG_EPDIR_IN         0x00000100 // The endpoint direction is IN (nor for control endpoints)
#define UOTGHS_DEVEPTCFG_AUTOSW           0x00000200 // Automatic Switch
#define UOTGHS_DEVEPTCFG_EPTYPE_CTRL      0x00000000 // Control
#define UOTGHS_DEVEPTCFG_EPTYPE_ISO       0x00000800 // Isochronous
#define UOTGHS_DEVEPTCFG_EPTYPE_BLK       0x00001000 // Bulk
#define UOTGHS_DEVEPTCFG_EPTYPE_INTRPT    0x00001800 // Interrupt
#define UOTGHS_DEVEPTCFG_NBTRANS_0_TRANS  0x00000000 // reserved to endpoint that does not have the high-bandwidth isochronous capability
#define UOTGHS_DEVEPTCFG_NBTRANS_1_TRANS  0x00002000 // default value: one transaction per micro-frame
#define UOTGHS_DEVEPTCFG_NBTRANS_2_TRANS  0x00004000 // 2 transactions per micro-frame. This endpoint should be configured as double-bank
#define UOTGHS_DEVEPTCFG_NBTRANS_3_TRANS  0x00006000 // 3 transactions per micro-frame. This endpoint should be configured as triple-bank

#define UOTGHS_DEVEPTISR_TXINI          0x00000001                // Transmitted IN Data Interrupt
#define UOTGHS_DEVEPTISR_RXOUTI         0x00000002                // Received OUT Data Interrupt
#define UOTGHS_DEVEPTISR_RXSTPI         0x00000004                // Received SETUP Interrupt
#define UOTGHS_DEVEPTISR_NAKOUTI        0x00000008                // NAKed OUT Interrupt
#define UOTGHS_DEVEPTISR_NAKINI         0x00000010                // NAKed IN Interrupt
#define UOTGHS_DEVEPTISR_OVERFI         0x00000020                // Overflow Interrupt
#define UOTGHS_DEVEPTISR_STALLEDI       0x00000040                // STALLed Interrupt
#define UOTGHS_DEVEPTISR_SHORTPACKET    0x00000080                // Short Packet Interrupt
#define UOTGHS_DEVEPTISR_DTSEQ_DATA0    0x00000000                // Data0 toggle sequence
#define UOTGHS_DEVEPTISR_DTSEQ_DATA1    0x00000100                // Data1 toggle sequence
#define UOTGHS_DEVEPTISR_DTSEQ_DATA2    0x00000200                // Reserved for high-bandwidth isochronous endpoint
#define UOTGHS_DEVEPTISR_DTSEQ_MDATA    0x00000300                // Reserved for high-bandwidth isochronous endpoint
#define UOTGHS_DEVEPTISR_NBUSYBK_0_BUSY 0x00000000                // 0 busy bank (all banks free)
#define UOTGHS_DEVEPTISR_NBUSYBK_1_BUSY 0x00001000                // 1 busy bank
#define UOTGHS_DEVEPTISR_NBUSYBK_2_BUSY 0x00002000                // 2 busy banks
#define UOTGHS_DEVEPTISR_NBUSYBK_3_BUSY 0x00003000                // 3 busy banks
#define UOTGHS_DEVEPTISR_CURRBK_BANK0   0x00000000                // Current bank is bank0
#define UOTGHS_DEVEPTISR_CURRBK_BANK1   0x00004000                // Current bank is bank1
#define UOTGHS_DEVEPTISR_CURRBK_BANK2   0x00008000                // Current bank is bank2
#define UOTGHS_DEVEPTISR_RWALL          0x00010000                // Read-write Allowed
#define UOTGHS_DEVEPTISR_CTRLDIR        0x00020000                // Control Direction
#define UOTGHS_DEVEPTISR_CFGOK          0x00040000                // Configuration OK Status
#define UOTGHS_DEVEPTISR_BYCT(value)    (((value) & 0x7FF) << 20) // Byte Count

#define UOTGHS_DEVEPTISR0_ISOENPT_TXINI          0x00000001                // Transmitted IN Data Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_RXOUTI         0x00000002                // Received OUT Data Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_UNDERFI        0x00000004                // Underflow Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_HBISOINERRI    0x00000008                // High Bandwidth Isochronous IN Underflow Error Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_HBISOFLUSHI    0x00000010                // High Bandwidth Isochronous IN Flush Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_OVERFI         0x00000020                // Overflow Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_CRCERRI        0x00000040                // CRC Error Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_SHORTPACKET    0x00000080                // Short Packet Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_DATA0    0x00000000                // Data0 toggle sequence
#define UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_DATA1    0x00000100                // Data1 toggle sequence
#define UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_DATA2    0x00000200                // Data2 toggle sequence (for high-bandwidth isochronous endpoint)
#define UOTGHS_DEVEPTISR0_ISOENPT_DTSEQ_MDATA    0x00000300                // MData toggle sequence (for high-bandwidth isochronous endpoint)
#define UOTGHS_DEVEPTISR0_ISOENPT_ERRORTRANS     0x00000400                // High-bandwidth Isochronous OUT Endpoint Transaction Error Interrupt
#define UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_0_BUSY 0x00000000                // 0 busy bank (all banks free)
#define UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_1_BUSY 0x00001000                // 1 busy bank
#define UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_2_BUSY 0x00002000                // 2 busy banks
#define UOTGHS_DEVEPTISR0_ISOENPT_NBUSYBK_3_BUSY 0x00003000                // 3 busy banks
#define UOTGHS_DEVEPTISR0_ISOENPT_CURRBK_BANK0   0x00000000                // Current bank is bank0
#define UOTGHS_DEVEPTISR0_ISOENPT_CURRBK_BANK1   0x00004000                // Current bank is bank1
#define UOTGHS_DEVEPTISR0_ISOENPT_CURRBK_BANK2   0x00008000                // Current bank is bank2
#define UOTGHS_DEVEPTISR0_ISOENPT_RWALL          0x00010000                // Read-write Allowed
#define UOTGHS_DEVEPTISR0_ISOENPT_CFGOK          0x00040000                // Configuration OK Status
#define UOTGHS_DEVEPTISR0_ISOENPT_BYCT(value)    (((value) & 0x7FF) << 20) // Byte Count

#define UOTGHS_DEVEPTICR_TXINIC       0x00000001 // Transmitted IN Data Interrupt Clear
#define UOTGHS_DEVEPTICR_RXOUTIC      0x00000002 // Received OUT Data Interrupt Clear
#define UOTGHS_DEVEPTICR_RXSTPIC      0x00000004 // Received SETUP Interrupt Clear
#define UOTGHS_DEVEPTICR_NAKOUTIC     0x00000008 // NAKed OUT Interrupt Clear
#define UOTGHS_DEVEPTICR_NAKINIC      0x00000010 // NAKed IN Interrupt Clear
#define UOTGHS_DEVEPTICR_OVERFIC      0x00000020 // Overflow Interrupt Clear
#define UOTGHS_DEVEPTICR_STALLEDIC    0x00000040 // STALLed Interrupt Clear
#define UOTGHS_DEVEPTICR_SHORTPACKETC 0x00000080 // Short Packet Interrupt Clear

#define UOTGHS_DEVEPTICR0_ISOENPT_TXINIC       0x00000001 // Transmitted IN Data Interrupt Clear
#define UOTGHS_DEVEPTICR0_ISOENPT_RXOUTIC      0x00000002 // Received OUT Data Interrupt Clear
#define UOTGHS_DEVEPTICR0_ISOENPT_UNDERFIC     0x00000004 // Underflow Interrupt Clear
#define UOTGHS_DEVEPTICR0_ISOENPT_HBISOINERRIC 0x00000008 // High bandwidth isochronous IN Underflow Error Interrupt Clear
#define UOTGHS_DEVEPTICR0_ISOENPT_HBISOFLUSHIC 0x00000010 // High Bandwidth Isochronous IN Flush Interrupt Clear
#define UOTGHS_DEVEPTICR0_ISOENPT_OVERFIC      0x00000020 // Overflow Interrupt Clear
#define UOTGHS_DEVEPTICR0_ISOENPT_CRCERRIC     0x00000040 // CRC Error Interrupt Clear
#define UOTGHS_DEVEPTICR0_ISOENPT_SHORTPACKETC 0x00000080 // Short Packet Interrupt Clear

#define UOTGHS_DEVEPTIFR_TXINIS       0x00000001 // Transmitted IN Data Interrupt Set
#define UOTGHS_DEVEPTIFR_RXOUTIS      0x00000002 // Received OUT Data Interrupt Set
#define UOTGHS_DEVEPTIFR_RXSTPIS      0x00000004 // Received SETUP Interrupt Set
#define UOTGHS_DEVEPTIFR_NAKOUTIS     0x00000008 // NAKed OUT Interrupt Set
#define UOTGHS_DEVEPTIFR_NAKINIS      0x00000010 // NAKed IN Interrupt Set
#define UOTGHS_DEVEPTIFR_OVERFIS      0x00000020 // Overflow Interrupt Set
#define UOTGHS_DEVEPTIFR_STALLEDIS    0x00000040 // STALLed Interrupt Set
#define UOTGHS_DEVEPTIFR_SHORTPACKETS 0x00000080 // Short Packet Interrupt Set
#define UOTGHS_DEVEPTIFR_NBUSYBKS     0x00001000 // Number of Busy Banks Interrupt Set

#define UOTGHS_DEVEPTIFR0_ISOENPT_TXINIS       0x00000001 // Transmitted IN Data Interrupt Set
#define UOTGHS_DEVEPTIFR0_ISOENPT_RXOUTIS      0x00000002 // Received OUT Data Interrupt Set
#define UOTGHS_DEVEPTIFR0_ISOENPT_UNDERFIS     0x00000004 // Underflow Interrupt Set
#define UOTGHS_DEVEPTIFR0_ISOENPT_HBISOINERRIS 0x00000008 // High bandwidth isochronous IN Underflow Error Interrupt Set
#define UOTGHS_DEVEPTIFR0_ISOENPT_HBISOFLUSHIS 0x00000010 // High Bandwidth Isochronous IN Flush Interrupt Set
#define UOTGHS_DEVEPTIFR0_ISOENPT_OVERFIS      0x00000020 // Overflow Interrupt Set
#define UOTGHS_DEVEPTIFR0_ISOENPT_CRCERRIS     0x00000040 // CRC Error Interrupt Set
#define UOTGHS_DEVEPTIFR0_ISOENPT_SHORTPACKETS 0x00000080 // Short Packet Interrupt Set
#define UOTGHS_DEVEPTIFR0_ISOENPT_NBUSYBKS     0x00001000 // Number of Busy Banks Interrupt Set

#define UOTGHS_DEVEPTIMR_TXINE        0x00000001 // Transmitted IN Data Interrupt
#define UOTGHS_DEVEPTIMR_RXOUTE       0x00000002 // Received OUT Data Interrupt
#define UOTGHS_DEVEPTIMR_RXSTPE       0x00000004 // Received SETUP Interrupt
#define UOTGHS_DEVEPTIMR_NAKOUTE      0x00000008 // NAKed OUT Interrupt
#define UOTGHS_DEVEPTIMR_NAKINE       0x00000010 // NAKed IN Interrupt
#define UOTGHS_DEVEPTIMR_OVERFE       0x00000020 // Overflow Interrupt
#define UOTGHS_DEVEPTIMR_STALLEDE     0x00000040 // STALLed Interrupt
#define UOTGHS_DEVEPTIMR_SHORTPACKETE 0x00000080 // Short Packet Interrupt
#define UOTGHS_DEVEPTIMR_NBUSYBKE     0x00001000 // Number of Busy Banks Interrupt
#define UOTGHS_DEVEPTIMR_KILLBK       0x00002000 // Kill IN Bank
#define UOTGHS_DEVEPTIMR_FIFOCON      0x00004000 // FIFO Control
#define UOTGHS_DEVEPTIMR_EPDISHDMA    0x00010000 // Endpoint Interrupts Disable HDMA Request
#define UOTGHS_DEVEPTIMR_NYETDIS      0x00020000 // NYET Token Disable
#define UOTGHS_DEVEPTIMR_RSTDT        0x00040000 // Reset Data Toggle
#define UOTGHS_DEVEPTIMR_STALLRQ      0x00080000 // STALL Request

#define UOTGHS_DEVEPTIMR0_ISOENPT_TXINE        0x00000001 // Transmitted IN Data Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_RXOUTE       0x00000002 // Received OUT Data Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_UNDERFE      0x00000004 // Underflow Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_HBISOINERRE  0x00000008 // High Bandwidth Isochronous IN Error Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_HBISOFLUSHE  0x00000010 // High Bandwidth Isochronous IN Flush Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_OVERFE       0x00000020 // Overflow Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_CRCERRE      0x00000040 // CRC Error Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_SHORTPACKETE 0x00000080 // Short Packet Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_MDATAE       0x00000100 // MData Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_DATAXE       0x00000200 // DataX Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_ERRORTRANSE  0x00000400 // Transaction Error Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_NBUSYBKE     0x00001000 // Number of Busy Banks Interrupt
#define UOTGHS_DEVEPTIMR0_ISOENPT_KILLBK       0x00002000 // Kill IN Bank
#define UOTGHS_DEVEPTIMR0_ISOENPT_FIFOCON      0x00004000 // FIFO Control
#define UOTGHS_DEVEPTIMR0_ISOENPT_EPDISHDMA    0x00010000 // Endpoint Interrupts Disable HDMA Request
#define UOTGHS_DEVEPTIMR0_ISOENPT_RSTDT        0x00040000 // Reset Data Toggle

#define UOTGHS_DEVEPTIER_TXINES        0x00000001 // Transmitted IN Data Interrupt Enable
#define UOTGHS_DEVEPTIER_RXOUTES       0x00000002 // Received OUT Data Interrupt Enable
#define UOTGHS_DEVEPTIER_RXSTPES       0x00000004 // Received SETUP Interrupt Enable
#define UOTGHS_DEVEPTIER_NAKOUTES      0x00000008 // NAKed OUT Interrupt Enable
#define UOTGHS_DEVEPTIER_NAKINES       0x00000010 // NAKed IN Interrupt Enable
#define UOTGHS_DEVEPTIER_OVERFES       0x00000020 // Overflow Interrupt Enable
#define UOTGHS_DEVEPTIER_STALLEDES     0x00000040 // STALLed Interrupt Enable
#define UOTGHS_DEVEPTIER_SHORTPACKETES 0x00000080 // Short Packet Interrupt Enable
#define UOTGHS_DEVEPTIER_NBUSYBKES     0x00001000 // Number of Busy Banks Interrupt Enable
#define UOTGHS_DEVEPTIER_KILLBKS       0x00002000 // Kill IN Bank
#define UOTGHS_DEVEPTIER_FIFOCONS      0x00004000 // FIFO Control
#define UOTGHS_DEVEPTIER_EPDISHDMAS    0x00010000 // Endpoint Interrupts Disable HDMA Request Enable
#define UOTGHS_DEVEPTIER_NYETDISS      0x00020000 // NYET Token Disable Enable
#define UOTGHS_DEVEPTIER_RSTDTS        0x00040000 // Reset Data Toggle Enable
#define UOTGHS_DEVEPTIER_STALLRQS      0x00080000 // STALL Request Enable

#define UOTGHS_DEVEPTIER0_ISOENPT_TXINES        0x00000001 // Transmitted IN Data Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_RXOUTES       0x00000002 // Received OUT Data Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_UNDERFES      0x00000004 // Underflow Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_HBISOINERRES  0x00000008 // High Bandwidth Isochronous IN Error Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_HBISOFLUSHES  0x00000010 // High Bandwidth Isochronous IN Flush Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_OVERFES       0x00000020 // Overflow Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_CRCERRES      0x00000040 // CRC Error Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_SHORTPACKETES 0x00000080 // Short Packet Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_MDATAES       0x00000100 // MData Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_DATAXES       0x00000200 // DataX Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_ERRORTRANSES  0x00000400 // Transaction Error Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_NBUSYBKES     0x00001000 // Number of Busy Banks Interrupt Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_KILLBKS       0x00002000 // Kill IN Bank
#define UOTGHS_DEVEPTIER0_ISOENPT_FIFOCONS      0x00004000 // FIFO Control
#define UOTGHS_DEVEPTIER0_ISOENPT_EPDISHDMAS    0x00010000 // Endpoint Interrupts Disable HDMA Request Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_RSTDTS        0x00040000 // Reset Data Toggle Enable
#define UOTGHS_DEVEPTIER0_ISOENPT_STALLRQS      0x00080000 // STALL Request Enable

#define UOTGHS_DEVEPTIDR_TXINEC        0x00000001 // Transmitted IN Interrupt Clear
#define UOTGHS_DEVEPTIDR_RXOUTEC       0x00000002 // Received OUT Data Interrupt Clear
#define UOTGHS_DEVEPTIDR_RXSTPEC       0x00000004 // Received SETUP Interrupt Clear
#define UOTGHS_DEVEPTIDR_NAKOUTEC      0x00000008 // NAKed OUT Interrupt Clear
#define UOTGHS_DEVEPTIDR_NAKINEC       0x00000010 // NAKed IN Interrupt Clear
#define UOTGHS_DEVEPTIDR_OVERFEC       0x00000020 // Overflow Interrupt Clear
#define UOTGHS_DEVEPTIDR_STALLEDEC     0x00000040 // STALLed Interrupt Clear
#define UOTGHS_DEVEPTIDR_SHORTPACKETEC 0x00000080 // Shortpacket Interrupt Clear
#define UOTGHS_DEVEPTIDR_NBUSYBKEC     0x00001000 // Number of Busy Banks Interrupt Clear
#define UOTGHS_DEVEPTIDR_FIFOCONC      0x00004000 // FIFO Control Clear
#define UOTGHS_DEVEPTIDR_EPDISHDMAC    0x00010000 // Endpoint Interrupts Disable HDMA Request Clear
#define UOTGHS_DEVEPTIDR_NYETDISC      0x00020000 // NYET Token Disable Clear
#define UOTGHS_DEVEPTIDR_STALLRQC      0x00080000 // STALL Request Clear

#define UOTGHS_DEVEPTIDR0_ISOENPT_TXINEC        0x00000001 // Transmitted IN Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_RXOUTEC       0x00000002 // Received OUT Data Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_UNDERFEC      0x00000004 // Underflow Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_HBISOINERREC  0x00000008 // High Bandwidth Isochronous IN Error Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_HBISOFLUSHEC  0x00000010 // High Bandwidth Isochronous IN Flush Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_OVERFEC       0x00000020 // Overflow Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_CRCERREC      0x00000040 // CRC Error Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_SHORTPACKETEC 0x00000080 // Shortpacket Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_MDATEC        0x00000100 // MData Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_DATAXEC       0x00000200 // DataX Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_ERRORTRANSEC  0x00000400 // Transaction Error Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_NBUSYBKEC     0x00001000 // Number of Busy Banks Interrupt Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_FIFOCONC      0x00004000 // FIFO Control Clear
#define UOTGHS_DEVEPTIDR0_ISOENPT_EPDISHDMAC    0x00010000 // Endpoint Interrupts Disable HDMA Request Clear

#define UOTGHS_DEVDMANXTDSC1_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_DEVDMAADDRESS1_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_DEVDMACONTROL1_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_DEVDMACONTROL1_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_DEVDMACONTROL1_END_TR_EN          0x00000004                 // End of Transfer Enable Control
#define UOTGHS_DEVDMACONTROL1_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_DEVDMACONTROL1_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_DEVDMACONTROL1_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_DEVDMACONTROL1_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_DEVDMACONTROL1_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_DEVDMACONTROL1_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_DEVDMASTATUS1_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_DEVDMASTATUS1_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_DEVDMASTATUS1_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_DEVDMASTATUS1_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_DEVDMASTATUS1_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_DEVDMASTATUS1_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_DEVDMANXTDSC2_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_DEVDMAADDRESS2_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_DEVDMACONTROL2_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_DEVDMACONTROL2_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_DEVDMACONTROL2_END_TR_EN          0x00000004                 // End of Transfer Enable Control
#define UOTGHS_DEVDMACONTROL2_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_DEVDMACONTROL2_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_DEVDMACONTROL2_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_DEVDMACONTROL2_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_DEVDMACONTROL2_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_DEVDMACONTROL2_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_DEVDMASTATUS2_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_DEVDMASTATUS2_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_DEVDMASTATUS2_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_DEVDMASTATUS2_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_DEVDMASTATUS2_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_DEVDMASTATUS2_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_DEVDMANXTDSC3_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_DEVDMAADDRESS3_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_DEVDMACONTROL3_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_DEVDMACONTROL3_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_DEVDMACONTROL3_END_TR_EN          0x00000004                 // End of Transfer Enable Control
#define UOTGHS_DEVDMACONTROL3_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_DEVDMACONTROL3_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_DEVDMACONTROL3_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_DEVDMACONTROL3_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_DEVDMACONTROL3_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_DEVDMACONTROL3_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_DEVDMASTATUS3_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_DEVDMASTATUS3_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_DEVDMASTATUS3_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_DEVDMASTATUS3_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_DEVDMASTATUS3_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_DEVDMASTATUS3_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_DEVDMANXTDSC4_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_DEVDMAADDRESS4_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_DEVDMACONTROL4_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_DEVDMACONTROL4_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_DEVDMACONTROL4_END_TR_EN          0x00000004                 // End of Transfer Enable Control
#define UOTGHS_DEVDMACONTROL4_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_DEVDMACONTROL4_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_DEVDMACONTROL4_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_DEVDMACONTROL4_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_DEVDMACONTROL4_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_DEVDMACONTROL4_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_DEVDMASTATUS4_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_DEVDMASTATUS4_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_DEVDMASTATUS4_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_DEVDMASTATUS4_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_DEVDMASTATUS4_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_DEVDMASTATUS4_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_DEVDMANXTDSC5_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_DEVDMAADDRESS5_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_DEVDMACONTROL5_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_DEVDMACONTROL5_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_DEVDMACONTROL5_END_TR_EN          0x00000004                 // End of Transfer Enable Control
#define UOTGHS_DEVDMACONTROL5_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_DEVDMACONTROL5_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_DEVDMACONTROL5_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_DEVDMACONTROL5_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_DEVDMACONTROL5_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_DEVDMACONTROL5_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_DEVDMASTATUS5_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_DEVDMASTATUS5_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_DEVDMASTATUS5_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_DEVDMASTATUS5_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_DEVDMASTATUS5_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_DEVDMASTATUS5_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_DEVDMANXTDSC6_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_DEVDMAADDRESS6_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_DEVDMACONTROL6_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_DEVDMACONTROL6_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_DEVDMACONTROL6_END_TR_EN          0x00000004                 // End of Transfer Enable Control
#define UOTGHS_DEVDMACONTROL6_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_DEVDMACONTROL6_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_DEVDMACONTROL6_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_DEVDMACONTROL6_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_DEVDMACONTROL6_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_DEVDMACONTROL6_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_DEVDMASTATUS6_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_DEVDMASTATUS6_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_DEVDMASTATUS6_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_DEVDMASTATUS6_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_DEVDMASTATUS6_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_DEVDMASTATUS6_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_HSTCTRL_SOFE               0x00000100 // Start of Frame Generation Enable
#define UOTGHS_HSTCTRL_RESET              0x00000200 // Send USB Reset
#define UOTGHS_HSTCTRL_RESUME             0x00000400 // Send USB Resume
#define UOTGHS_HSTCTRL_SPDCONF_NORMAL     0x00000000 // The host starts in full-speed mode and performs a high-speed reset to switch to the high-speed mode if the downstream peripheral is high-speed capable
#define UOTGHS_HSTCTRL_SPDCONF_LOW_POWER  0x00001000 // For a better consumption, if high-speed is not needed
#define UOTGHS_HSTCTRL_SPDCONF_HIGH_SPEED 0x00002000 // Forced high speed
#define UOTGHS_HSTCTRL_SPDCONF_FORCED_FS  0x00003000 // The host remains to full-speed mode whatever the peripheral speed capability

#define UOTGHS_HSTISR_DCONNI 0x00000001 // Device Connection Interrupt
#define UOTGHS_HSTISR_DDISCI 0x00000002 // Device Disconnection Interrupt
#define UOTGHS_HSTISR_RSTI   0x00000004 // USB Reset Sent Interrupt
#define UOTGHS_HSTISR_RSMEDI 0x00000008 // Downstream Resume Sent Interrupt
#define UOTGHS_HSTISR_RXRSMI 0x00000010 // Upstream Resume Received Interrupt
#define UOTGHS_HSTISR_HSOFI  0x00000020 // Host Start of Frame Interrupt
#define UOTGHS_HSTISR_HWUPI  0x00000040 // Host Wake-Up Interrupt
#define UOTGHS_HSTISR_PEP_0  0x00000100 // Pipe 0 Interrupt
#define UOTGHS_HSTISR_PEP_1  0x00000200 // Pipe 1 Interrupt
#define UOTGHS_HSTISR_PEP_2  0x00000400 // Pipe 2 Interrupt
#define UOTGHS_HSTISR_PEP_3  0x00000800 // Pipe 3 Interrupt
#define UOTGHS_HSTISR_PEP_4  0x00001000 // Pipe 4 Interrupt
#define UOTGHS_HSTISR_PEP_5  0x00002000 // Pipe 5 Interrupt
#define UOTGHS_HSTISR_PEP_6  0x00004000 // Pipe 6 Interrupt
#define UOTGHS_HSTISR_PEP_7  0x00008000 // Pipe 7 Interrupt
#define UOTGHS_HSTISR_PEP_8  0x00010000 // Pipe 8 Interrupt
#define UOTGHS_HSTISR_PEP_9  0x00020000 // Pipe 9 Interrupt
#define UOTGHS_HSTISR_DMA_1  0x02000000 // DMA Channel 1 Interrupt
#define UOTGHS_HSTISR_DMA_2  0x04000000 // DMA Channel 2 Interrupt
#define UOTGHS_HSTISR_DMA_3  0x08000000 // DMA Channel 3 Interrupt
#define UOTGHS_HSTISR_DMA_4  0x10000000 // DMA Channel 4 Interrupt
#define UOTGHS_HSTISR_DMA_5  0x20000000 // DMA Channel 5 Interrupt
#define UOTGHS_HSTISR_DMA_6  0x40000000 // DMA Channel 6 Interrupt

#define UOTGHS_HSTICR_DCONNIC 0x00000001 // Device Connection Interrupt Clear
#define UOTGHS_HSTICR_DDISCIC 0x00000002 // Device Disconnection Interrupt Clear
#define UOTGHS_HSTICR_RSTIC   0x00000004 // USB Reset Sent Interrupt Clear
#define UOTGHS_HSTICR_RSMEDIC 0x00000008 // Downstream Resume Sent Interrupt Clear
#define UOTGHS_HSTICR_RXRSMIC 0x00000010 // Upstream Resume Received Interrupt Clear
#define UOTGHS_HSTICR_HSOFIC  0x00000020 // Host Start of Frame Interrupt Clear
#define UOTGHS_HSTICR_HWUPIC  0x00000040 // Host Wake-Up Interrupt Clear

#define UOTGHS_HSTIFR_DCONNIS 0x00000001 // Device Connection Interrupt Set
#define UOTGHS_HSTIFR_DDISCIS 0x00000002 // Device Disconnection Interrupt Set
#define UOTGHS_HSTIFR_RSTIS   0x00000004 // USB Reset Sent Interrupt Set
#define UOTGHS_HSTIFR_RSMEDIS 0x00000008 // Downstream Resume Sent Interrupt Set
#define UOTGHS_HSTIFR_RXRSMIS 0x00000010 // Upstream Resume Received Interrupt Set
#define UOTGHS_HSTIFR_HSOFIS  0x00000020 // Host Start of Frame Interrupt Set
#define UOTGHS_HSTIFR_HWUPIS  0x00000040 // Host Wake-Up Interrupt Set
#define UOTGHS_HSTIFR_DMA_1   0x02000000 // DMA Channel 1 Interrupt Set
#define UOTGHS_HSTIFR_DMA_2   0x04000000 // DMA Channel 2 Interrupt Set
#define UOTGHS_HSTIFR_DMA_3   0x08000000 // DMA Channel 3 Interrupt Set
#define UOTGHS_HSTIFR_DMA_4   0x10000000 // DMA Channel 4 Interrupt Set
#define UOTGHS_HSTIFR_DMA_5   0x20000000 // DMA Channel 5 Interrupt Set
#define UOTGHS_HSTIFR_DMA_6   0x40000000 // DMA Channel 6 Interrupt Set

#define UOTGHS_HSTIMR_DCONNIE 0x00000001 // Device Connection Interrupt Enable
#define UOTGHS_HSTIMR_DDISCIE 0x00000002 // Device Disconnection Interrupt Enable
#define UOTGHS_HSTIMR_RSTIE   0x00000004 // USB Reset Sent Interrupt Enable
#define UOTGHS_HSTIMR_RSMEDIE 0x00000008 // Downstream Resume Sent Interrupt Enable
#define UOTGHS_HSTIMR_RXRSMIE 0x00000010 // Upstream Resume Received Interrupt Enable
#define UOTGHS_HSTIMR_HSOFIE  0x00000020 // Host Start of Frame Interrupt Enable
#define UOTGHS_HSTIMR_HWUPIE  0x00000040 // Host Wake-Up Interrupt Enable
#define UOTGHS_HSTIMR_PEP_0   0x00000100 // Pipe 0 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_1   0x00000200 // Pipe 1 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_2   0x00000400 // Pipe 2 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_3   0x00000800 // Pipe 3 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_4   0x00001000 // Pipe 4 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_5   0x00002000 // Pipe 5 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_6   0x00004000 // Pipe 6 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_7   0x00008000 // Pipe 7 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_8   0x00010000 // Pipe 8 Interrupt Enable
#define UOTGHS_HSTIMR_PEP_9   0x00020000 // Pipe 9 Interrupt Enable
#define UOTGHS_HSTIMR_DMA_1   0x02000000 // DMA Channel 1 Interrupt Enable
#define UOTGHS_HSTIMR_DMA_2   0x04000000 // DMA Channel 2 Interrupt Enable
#define UOTGHS_HSTIMR_DMA_3   0x08000000 // DMA Channel 3 Interrupt Enable
#define UOTGHS_HSTIMR_DMA_4   0x10000000 // DMA Channel 4 Interrupt Enable
#define UOTGHS_HSTIMR_DMA_5   0x20000000 // DMA Channel 5 Interrupt Enable
#define UOTGHS_HSTIMR_DMA_6   0x40000000 // DMA Channel 6 Interrupt Enable

#define UOTGHS_HSTIDR_DCONNIEC 0x00000001 // Device Connection Interrupt Disable
#define UOTGHS_HSTIDR_DDISCIEC 0x00000002 // Device Disconnection Interrupt Disable
#define UOTGHS_HSTIDR_RSTIEC   0x00000004 // USB Reset Sent Interrupt Disable
#define UOTGHS_HSTIDR_RSMEDIEC 0x00000008 // Downstream Resume Sent Interrupt Disable
#define UOTGHS_HSTIDR_RXRSMIEC 0x00000010 // Upstream Resume Received Interrupt Disable
#define UOTGHS_HSTIDR_HSOFIEC  0x00000020 // Host Start of Frame Interrupt Disable
#define UOTGHS_HSTIDR_HWUPIEC  0x00000040 // Host Wake-Up Interrupt Disable
#define UOTGHS_HSTIDR_PEP_0    0x00000100 // Pipe 0 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_1    0x00000200 // Pipe 1 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_2    0x00000400 // Pipe 2 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_3    0x00000800 // Pipe 3 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_4    0x00001000 // Pipe 4 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_5    0x00002000 // Pipe 5 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_6    0x00004000 // Pipe 6 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_7    0x00008000 // Pipe 7 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_8    0x00010000 // Pipe 8 Interrupt Disable
#define UOTGHS_HSTIDR_PEP_9    0x00020000 // Pipe 9 Interrupt Disable
#define UOTGHS_HSTIDR_DMA_1    0x02000000 // DMA Channel 1 Interrupt Disable
#define UOTGHS_HSTIDR_DMA_2    0x04000000 // DMA Channel 2 Interrupt Disable
#define UOTGHS_HSTIDR_DMA_3    0x08000000 // DMA Channel 3 Interrupt Disable
#define UOTGHS_HSTIDR_DMA_4    0x10000000 // DMA Channel 4 Interrupt Disable
#define UOTGHS_HSTIDR_DMA_5    0x20000000 // DMA Channel 5 Interrupt Disable
#define UOTGHS_HSTIDR_DMA_6    0x40000000 // DMA Channel 6 Interrupt Disable

#define UOTGHS_HSTIER_DCONNIES 0x00000001 // Device Connection Interrupt Enable
#define UOTGHS_HSTIER_DDISCIES 0x00000002 // Device Disconnection Interrupt Enable
#define UOTGHS_HSTIER_RSTIES   0x00000004 // USB Reset Sent Interrupt Enable
#define UOTGHS_HSTIER_RSMEDIES 0x00000008 // Downstream Resume Sent Interrupt Enable
#define UOTGHS_HSTIER_RXRSMIES 0x00000010 // Upstream Resume Received Interrupt Enable
#define UOTGHS_HSTIER_HSOFIES  0x00000020 // Host Start of Frame Interrupt Enable
#define UOTGHS_HSTIER_HWUPIES  0x00000040 // Host Wake-Up Interrupt Enable
#define UOTGHS_HSTIER_PEP_0    0x00000100 // Pipe 0 Interrupt Enable
#define UOTGHS_HSTIER_PEP_1    0x00000200 // Pipe 1 Interrupt Enable
#define UOTGHS_HSTIER_PEP_2    0x00000400 // Pipe 2 Interrupt Enable
#define UOTGHS_HSTIER_PEP_3    0x00000800 // Pipe 3 Interrupt Enable
#define UOTGHS_HSTIER_PEP_4    0x00001000 // Pipe 4 Interrupt Enable
#define UOTGHS_HSTIER_PEP_5    0x00002000 // Pipe 5 Interrupt Enable
#define UOTGHS_HSTIER_PEP_6    0x00004000 // Pipe 6 Interrupt Enable
#define UOTGHS_HSTIER_PEP_7    0x00008000 // Pipe 7 Interrupt Enable
#define UOTGHS_HSTIER_PEP_8    0x00010000 // Pipe 8 Interrupt Enable
#define UOTGHS_HSTIER_PEP_9    0x00020000 // Pipe 9 Interrupt Enable
#define UOTGHS_HSTIER_DMA_1    0x02000000 // DMA Channel 1 Interrupt Enable
#define UOTGHS_HSTIER_DMA_2    0x04000000 // DMA Channel 2 Interrupt Enable
#define UOTGHS_HSTIER_DMA_3    0x08000000 // DMA Channel 3 Interrupt Enable
#define UOTGHS_HSTIER_DMA_4    0x10000000 // DMA Channel 4 Interrupt Enable
#define UOTGHS_HSTIER_DMA_5    0x20000000 // DMA Channel 5 Interrupt Enable
#define UOTGHS_HSTIER_DMA_6    0x40000000 // DMA Channel 6 Interrupt Enable

#define UOTGHS_HSTPIP_PEN0  0x00000001 // Pipe 0 Enable
#define UOTGHS_HSTPIP_PEN1  0x00000002 // Pipe 1 Enable
#define UOTGHS_HSTPIP_PEN2  0x00000004 // Pipe 2 Enable
#define UOTGHS_HSTPIP_PEN3  0x00000008 // Pipe 3 Enable
#define UOTGHS_HSTPIP_PEN4  0x00000010 // Pipe 4 Enable
#define UOTGHS_HSTPIP_PEN5  0x00000020 // Pipe 5 Enable
#define UOTGHS_HSTPIP_PEN6  0x00000040 // Pipe 6 Enable
#define UOTGHS_HSTPIP_PEN7  0x00000080 // Pipe 7 Enable
#define UOTGHS_HSTPIP_PEN8  0x00000100 // Pipe 8 Enable
#define UOTGHS_HSTPIP_PRST0 0x00010000 // Pipe 0 Reset
#define UOTGHS_HSTPIP_PRST1 0x00020000 // Pipe 1 Reset
#define UOTGHS_HSTPIP_PRST2 0x00040000 // Pipe 2 Reset
#define UOTGHS_HSTPIP_PRST3 0x00080000 // Pipe 3 Reset
#define UOTGHS_HSTPIP_PRST4 0x00100000 // Pipe 4 Reset
#define UOTGHS_HSTPIP_PRST5 0x00200000 // Pipe 5 Reset
#define UOTGHS_HSTPIP_PRST6 0x00400000 // Pipe 6 Reset
#define UOTGHS_HSTPIP_PRST7 0x00800000 // Pipe 7 Reset
#define UOTGHS_HSTPIP_PRST8 0x01000000 // Pipe 8 Reset

#define UOTGHS_HSTFNUM_MFNUM(value)    (((value) & 0x7) << 0)   // Micro Frame Number
#define UOTGHS_HSTFNUM_FNUM(value)     (((value) & 0x7FF) << 3) // Frame Number
#define UOTGHS_HSTFNUM_FLENHIGH(value) (((value) & 0xFF) << 16) // Frame Length

#define UOTGHS_HSTADDR1_HSTADDRP0(value) (((value) & 0x7F) << 0)  // USB Host Address
#define UOTGHS_HSTADDR1_HSTADDRP1(value) (((value) & 0x7F) << 8)  // USB Host Address
#define UOTGHS_HSTADDR1_HSTADDRP2(value) (((value) & 0x7F) << 16) // USB Host Address
#define UOTGHS_HSTADDR1_HSTADDRP3(value) (((value) & 0x7F) << 24) // USB Host Address

#define UOTGHS_HSTADDR2_HSTADDRP4(value) (((value) & 0x7F) << 0)  // USB Host Address
#define UOTGHS_HSTADDR2_HSTADDRP5(value) (((value) & 0x7F) << 8)  // USB Host Address
#define UOTGHS_HSTADDR2_HSTADDRP6(value) (((value) & 0x7F) << 16) // USB Host Address
#define UOTGHS_HSTADDR2_HSTADDRP7(value) (((value) & 0x7F) << 24) // USB Host Address

#define UOTGHS_HSTADDR3_HSTADDRP8(value) (((value) & 0x7F) << 0) // USB Host Address
#define UOTGHS_HSTADDR3_HSTADDRP9(value) (((value) & 0x7F) << 8) // USB Host Address

#define UOTGHS_HSTPIPCFG_ALLOC           0x00000002               // Pipe Memory Allocate
#define UOTGHS_HSTPIPCFG_PBK_1_BANK      0x00000000               // Single-bank pipe
#define UOTGHS_HSTPIPCFG_PBK_2_BANK      0x00000004               // Double-bank pipe
#define UOTGHS_HSTPIPCFG_PBK_3_BANK      0x00000008               // Triple-bank pipe
#define UOTGHS_HSTPIPCFG_PSIZE_8_BYTE    0x00000000               // 8 bytes
#define UOTGHS_HSTPIPCFG_PSIZE_16_BYTE   0x00000010               // 16 bytes
#define UOTGHS_HSTPIPCFG_PSIZE_32_BYTE   0x00000020               // 32 bytes
#define UOTGHS_HSTPIPCFG_PSIZE_64_BYTE   0x00000030               // 64 bytes
#define UOTGHS_HSTPIPCFG_PSIZE_128_BYTE  0x00000040               // 128 bytes
#define UOTGHS_HSTPIPCFG_PSIZE_256_BYTE  0x00000050               // 256 bytes
#define UOTGHS_HSTPIPCFG_PSIZE_512_BYTE  0x00000060               // 512 bytes
#define UOTGHS_HSTPIPCFG_PSIZE_1024_BYTE 0x00000070               // 1024 bytes
#define UOTGHS_HSTPIPCFG_PTOKEN_SETUP    0x00000000               // SETUP
#define UOTGHS_HSTPIPCFG_PTOKEN_IN       0x00000100               // IN
#define UOTGHS_HSTPIPCFG_PTOKEN_OUT      0x00000200               // OUT
#define UOTGHS_HSTPIPCFG_AUTOSW          0x00000400               // Automatic Switch
#define UOTGHS_HSTPIPCFG_PTYPE_CTRL      0x00000000               // Control
#define UOTGHS_HSTPIPCFG_PTYPE_ISO       0x00001000               // Isochronous
#define UOTGHS_HSTPIPCFG_PTYPE_BLK       0x00002000               // Bulk
#define UOTGHS_HSTPIPCFG_PTYPE_INTRPT    0x00003000               // Interrupt
#define UOTGHS_HSTPIPCFG_PEPNUM(value)   (((value) & 0xF) << 16)  // Pipe Endpoint Number
#define UOTGHS_HSTPIPCFG_INTFRQ(value)   (((value) & 0xFF) << 24) // Pipe Interrupt Request Frequency

#define UOTGHS_HSTPIPCFG0_HSBOHSCP_ALLOC            0x00000002               // Pipe Memory Allocate
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PBK_1_BANK       0x00000000               // Single-bank pipe
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PBK_2_BANK       0x00000004               // Double-bank pipe
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PBK_3_BANK       0x00000008               // Triple-bank pipe
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_8_BYTE     0x00000000               // 8 bytes
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_16_BYTE    0x00000010               // 16 bytes
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_32_BYTE    0x00000020               // 32 bytes
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_64_BYTE    0x00000030               // 64 bytes
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_128_BYTE   0x00000040               // 128 bytes
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_256_BYTE   0x00000050               // 256 bytes
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_512_BYTE   0x00000060               // 512 bytes
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PSIZE_1024_BYTE  0x00000070               // 1024 bytes
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PTOKEN_SETUP     0x00000000               // SETUP
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PTOKEN_IN        0x00000100               // IN
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PTOKEN_OUT       0x00000200               // OUT
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_AUTOSW           0x00000400               // Automatic Switch
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PTYPE_CTRL       0x00000000               // Control
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PTYPE_BLK        0x00002000               // Bulk
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PEPNUM(value)    (((value) & 0xF) << 16)  // Pipe Endpoint Number
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_PINGEN           0x00100000               // Ping Enable
#define UOTGHS_HSTPIPCFG0_HSBOHSCP_BINTERVAL(value) (((value) & 0xFF) << 24) // Binterval Parameter for the Bulk-Out/Ping Transaction

#define UOTGHS_HSTPIPISR_RXINI          0x00000001                // Received IN Data Interrupt
#define UOTGHS_HSTPIPISR_TXOUTI         0x00000002                // Transmitted OUT Data Interrupt
#define UOTGHS_HSTPIPISR_TXSTPI         0x00000004                // Transmitted SETUP Interrupt
#define UOTGHS_HSTPIPISR_PERRI          0x00000008                // Pipe Error Interrupt
#define UOTGHS_HSTPIPISR_NAKEDI         0x00000010                // NAKed Interrupt
#define UOTGHS_HSTPIPISR_OVERFI         0x00000020                // Overflow Interrupt
#define UOTGHS_HSTPIPISR_RXSTALLDI      0x00000040                // Received STALLed Interrupt
#define UOTGHS_HSTPIPISR_SHORTPACKETI   0x00000080                // Short Packet Interrupt
#define UOTGHS_HSTPIPISR_DTSEQ_DATA0    0x00000000                // Data0 toggle sequence
#define UOTGHS_HSTPIPISR_DTSEQ_DATA1    0x00000100                // Data1 toggle sequence
#define UOTGHS_HSTPIPISR_NBUSYBK_0_BUSY 0x00000000                // 0 busy bank (all banks free)
#define UOTGHS_HSTPIPISR_NBUSYBK_1_BUSY 0x00001000                // 1 busy bank
#define UOTGHS_HSTPIPISR_NBUSYBK_2_BUSY 0x00002000                // 2 busy banks
#define UOTGHS_HSTPIPISR_NBUSYBK_3_BUSY 0x00003000                // 3 busy banks
#define UOTGHS_HSTPIPISR_CURRBK_BANK0   0x00000000                // Current bank is bank0
#define UOTGHS_HSTPIPISR_CURRBK_BANK1   0x00004000                // Current bank is bank1
#define UOTGHS_HSTPIPISR_CURRBK_BANK2   0x00008000                // Current bank is bank2
#define UOTGHS_HSTPIPISR_RWALL          0x00010000                // Read-write Allowed
#define UOTGHS_HSTPIPISR_CFGOK          0x00040000                // Configuration OK Status
#define UOTGHS_HSTPIPISR_PBYCT(value)   (((value) & 0x7FF) << 20) // Pipe Byte Count

#define UOTGHS_HSTPIPISR0_INTPIPES_RXINI          0x00000001                // Received IN Data Interrupt
#define UOTGHS_HSTPIPISR0_INTPIPES_TXOUTI         0x00000002                // Transmitted OUT Data Interrupt
#define UOTGHS_HSTPIPISR0_INTPIPES_UNDERFI        0x00000004                // Underflow Interrupt
#define UOTGHS_HSTPIPISR0_INTPIPES_PERRI          0x00000008                // Pipe Error Interrupt
#define UOTGHS_HSTPIPISR0_INTPIPES_NAKEDI         0x00000010                // NAKed Interrupt
#define UOTGHS_HSTPIPISR0_INTPIPES_OVERFI         0x00000020                // Overflow Interrupt
#define UOTGHS_HSTPIPISR0_INTPIPES_RXSTALLDI      0x00000040                // Received STALLed Interrupt
#define UOTGHS_HSTPIPISR0_INTPIPES_SHORTPACKETI   0x00000080                // Short Packet Interrupt
#define UOTGHS_HSTPIPISR0_INTPIPES_DTSEQ_DATA0    0x00000000                // Data0 toggle sequence
#define UOTGHS_HSTPIPISR0_INTPIPES_DTSEQ_DATA1    0x00000100                // Data1 toggle sequence
#define UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_0_BUSY 0x00000000                // 0 busy bank (all banks free)
#define UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_1_BUSY 0x00001000                // 1 busy bank
#define UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_2_BUSY 0x00002000                // 2 busy banks
#define UOTGHS_HSTPIPISR0_INTPIPES_NBUSYBK_3_BUSY 0x00003000                // 3 busy banks
#define UOTGHS_HSTPIPISR0_INTPIPES_CURRBK_BANK0   0x00000000                // Current bank is bank0
#define UOTGHS_HSTPIPISR0_INTPIPES_CURRBK_BANK1   0x00004000                // Current bank is bank1
#define UOTGHS_HSTPIPISR0_INTPIPES_CURRBK_BANK2   0x00008000                // Current bank is bank2
#define UOTGHS_HSTPIPISR0_INTPIPES_RWALL          0x00010000                // Read-write Allowed
#define UOTGHS_HSTPIPISR0_INTPIPES_CFGOK          0x00040000                // Configuration OK Status
#define UOTGHS_HSTPIPISR0_INTPIPES_PBYCT(value)   (((value) & 0x7FF) << 20) // Pipe Byte Count

#define UOTGHS_HSTPIPISR0_ISOPIPES_RXINI          0x00000001                // Received IN Data Interrupt
#define UOTGHS_HSTPIPISR0_ISOPIPES_TXOUTI         0x00000002                // Transmitted OUT Data Interrupt
#define UOTGHS_HSTPIPISR0_ISOPIPES_UNDERFI        0x00000004                // Underflow Interrupt
#define UOTGHS_HSTPIPISR0_ISOPIPES_PERRI          0x00000008                // Pipe Error Interrupt
#define UOTGHS_HSTPIPISR0_ISOPIPES_NAKEDI         0x00000010                // NAKed Interrupt
#define UOTGHS_HSTPIPISR0_ISOPIPES_OVERFI         0x00000020                // Overflow Interrupt
#define UOTGHS_HSTPIPISR0_ISOPIPES_CRCERRI        0x00000040                // CRC Error Interrupt
#define UOTGHS_HSTPIPISR0_ISOPIPES_SHORTPACKETI   0x00000080                // Short Packet Interrupt
#define UOTGHS_HSTPIPISR0_ISOPIPES_DTSEQ_DATA0    0x00000000                // Data0 toggle sequence
#define UOTGHS_HSTPIPISR0_ISOPIPES_DTSEQ_DATA1    0x00000100                // Data1 toggle sequence
#define UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_0_BUSY 0x00000000                // 0 busy bank (all banks free)
#define UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_1_BUSY 0x00001000                // 1 busy bank
#define UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_2_BUSY 0x00002000                // 2 busy banks
#define UOTGHS_HSTPIPISR0_ISOPIPES_NBUSYBK_3_BUSY 0x00003000                // 3 busy banks
#define UOTGHS_HSTPIPISR0_ISOPIPES_CURRBK_BANK0   0x00000000                // Current bank is bank0
#define UOTGHS_HSTPIPISR0_ISOPIPES_CURRBK_BANK1   0x00004000                // Current bank is bank1
#define UOTGHS_HSTPIPISR0_ISOPIPES_CURRBK_BANK2   0x00008000                // Current bank is bank2
#define UOTGHS_HSTPIPISR0_ISOPIPES_RWALL          0x00010000                // Read-write Allowed
#define UOTGHS_HSTPIPISR0_ISOPIPES_CFGOK          0x00040000                // Configuration OK Status
#define UOTGHS_HSTPIPISR0_ISOPIPES_PBYCT(value)   (((value) & 0x7FF) << 20) // Pipe Byte Count

#define UOTGHS_HSTPIPICR_RXINIC        0x00000001 // Received IN Data Interrupt Clear
#define UOTGHS_HSTPIPICR_TXOUTIC       0x00000002 // Transmitted OUT Data Interrupt Clear
#define UOTGHS_HSTPIPICR_TXSTPIC       0x00000004 // Transmitted SETUP Interrupt Clear
#define UOTGHS_HSTPIPICR_NAKEDIC       0x00000010 // NAKed Interrupt Clear
#define UOTGHS_HSTPIPICR_OVERFIC       0x00000020 // Overflow Interrupt Clear
#define UOTGHS_HSTPIPICR_RXSTALLDIC    0x00000040 // Received STALLed Interrupt Clear
#define UOTGHS_HSTPIPICR_SHORTPACKETIC 0x00000080 // Short Packet Interrupt Clear

#define UOTGHS_HSTPIPICR0_INTPIPES_RXINIC        0x00000001 // Received IN Data Interrupt Clear
#define UOTGHS_HSTPIPICR0_INTPIPES_TXOUTIC       0x00000002 // Transmitted OUT Data Interrupt Clear
#define UOTGHS_HSTPIPICR0_INTPIPES_UNDERFIC      0x00000004 // Underflow Interrupt Clear
#define UOTGHS_HSTPIPICR0_INTPIPES_NAKEDIC       0x00000010 // NAKed Interrupt Clear
#define UOTGHS_HSTPIPICR0_INTPIPES_OVERFIC       0x00000020 // Overflow Interrupt Clear
#define UOTGHS_HSTPIPICR0_INTPIPES_RXSTALLDIC    0x00000040 // Received STALLed Interrupt Clear
#define UOTGHS_HSTPIPICR0_INTPIPES_SHORTPACKETIC 0x00000080 // Short Packet Interrupt Clear

#define UOTGHS_HSTPIPICR0_ISOPIPES_RXINIC        0x00000001 // Received IN Data Interrupt Clear
#define UOTGHS_HSTPIPICR0_ISOPIPES_TXOUTIC       0x00000002 // Transmitted OUT Data Interrupt Clear
#define UOTGHS_HSTPIPICR0_ISOPIPES_UNDERFIC      0x00000004 // Underflow Interrupt Clear
#define UOTGHS_HSTPIPICR0_ISOPIPES_NAKEDIC       0x00000010 // NAKed Interrupt Clear
#define UOTGHS_HSTPIPICR0_ISOPIPES_OVERFIC       0x00000020 // Overflow Interrupt Clear
#define UOTGHS_HSTPIPICR0_ISOPIPES_CRCERRIC      0x00000040 // CRC Error Interrupt Clear
#define UOTGHS_HSTPIPICR0_ISOPIPES_SHORTPACKETIC 0x00000080 // Short Packet Interrupt Clear

#define UOTGHS_HSTPIPIFR_RXINIS        0x00000001 // Received IN Data Interrupt Set
#define UOTGHS_HSTPIPIFR_TXOUTIS       0x00000002 // Transmitted OUT Data Interrupt Set
#define UOTGHS_HSTPIPIFR_TXSTPIS       0x00000004 // Transmitted SETUP Interrupt Set
#define UOTGHS_HSTPIPIFR_PERRIS        0x00000008 // Pipe Error Interrupt Set
#define UOTGHS_HSTPIPIFR_NAKEDIS       0x00000010 // NAKed Interrupt Set
#define UOTGHS_HSTPIPIFR_OVERFIS       0x00000020 // Overflow Interrupt Set
#define UOTGHS_HSTPIPIFR_RXSTALLDIS    0x00000040 // Received STALLed Interrupt Set
#define UOTGHS_HSTPIPIFR_SHORTPACKETIS 0x00000080 // Short Packet Interrupt Set
#define UOTGHS_HSTPIPIFR_NBUSYBKS      0x00001000 // Number of Busy Banks Set

#define UOTGHS_HSTPIPIFR0_INTPIPES_RXINIS        0x00000001 // Received IN Data Interrupt Set
#define UOTGHS_HSTPIPIFR0_INTPIPES_TXOUTIS       0x00000002 // Transmitted OUT Data Interrupt Set
#define UOTGHS_HSTPIPIFR0_INTPIPES_UNDERFIS      0x00000004 // Underflow Interrupt Set
#define UOTGHS_HSTPIPIFR0_INTPIPES_PERRIS        0x00000008 // Pipe Error Interrupt Set
#define UOTGHS_HSTPIPIFR0_INTPIPES_NAKEDIS       0x00000010 // NAKed Interrupt Set
#define UOTGHS_HSTPIPIFR0_INTPIPES_OVERFIS       0x00000020 // Overflow Interrupt Set
#define UOTGHS_HSTPIPIFR0_INTPIPES_RXSTALLDIS    0x00000040 // Received STALLed Interrupt Set
#define UOTGHS_HSTPIPIFR0_INTPIPES_SHORTPACKETIS 0x00000080 // Short Packet Interrupt Set
#define UOTGHS_HSTPIPIFR0_INTPIPES_NBUSYBKS      0x00001000 // Number of Busy Banks Set

#define UOTGHS_HSTPIPIFR0_ISOPIPES_RXINIS        0x00000001 // Received IN Data Interrupt Set
#define UOTGHS_HSTPIPIFR0_ISOPIPES_TXOUTIS       0x00000002 // Transmitted OUT Data Interrupt Set
#define UOTGHS_HSTPIPIFR0_ISOPIPES_UNDERFIS      0x00000004 // Underflow Interrupt Set
#define UOTGHS_HSTPIPIFR0_ISOPIPES_PERRIS        0x00000008 // Pipe Error Interrupt Set
#define UOTGHS_HSTPIPIFR0_ISOPIPES_NAKEDIS       0x00000010 // NAKed Interrupt Set
#define UOTGHS_HSTPIPIFR0_ISOPIPES_OVERFIS       0x00000020 // Overflow Interrupt Set
#define UOTGHS_HSTPIPIFR0_ISOPIPES_CRCERRIS      0x00000040 // CRC Error Interrupt Set
#define UOTGHS_HSTPIPIFR0_ISOPIPES_SHORTPACKETIS 0x00000080 // Short Packet Interrupt Set
#define UOTGHS_HSTPIPIFR0_ISOPIPES_NBUSYBKS      0x00001000 // Number of Busy Banks Set

#define UOTGHS_HSTPIPIMR_RXINE         0x00000001 // Received IN Data Interrupt Enable
#define UOTGHS_HSTPIPIMR_TXOUTE        0x00000002 // Transmitted OUT Data Interrupt Enable
#define UOTGHS_HSTPIPIMR_TXSTPE        0x00000004 // Transmitted SETUP Interrupt Enable
#define UOTGHS_HSTPIPIMR_PERRE         0x00000008 // Pipe Error Interrupt Enable
#define UOTGHS_HSTPIPIMR_NAKEDE        0x00000010 // NAKed Interrupt Enable
#define UOTGHS_HSTPIPIMR_OVERFIE       0x00000020 // Overflow Interrupt Enable
#define UOTGHS_HSTPIPIMR_RXSTALLDE     0x00000040 // Received STALLed Interrupt Enable
#define UOTGHS_HSTPIPIMR_SHORTPACKETIE 0x00000080 // Short Packet Interrupt Enable
#define UOTGHS_HSTPIPIMR_NBUSYBKE      0x00001000 // Number of Busy Banks Interrupt Enable
#define UOTGHS_HSTPIPIMR_FIFOCON       0x00004000 // FIFO Control
#define UOTGHS_HSTPIPIMR_PDISHDMA      0x00010000 // Pipe Interrupts Disable HDMA Request Enable
#define UOTGHS_HSTPIPIMR_PFREEZE       0x00020000 // Pipe Freeze
#define UOTGHS_HSTPIPIMR_RSTDT         0x00040000 // Reset Data Toggle

#define UOTGHS_HSTPIPIMR0_INTPIPES_RXINE         0x00000001 // Received IN Data Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_TXOUTE        0x00000002 // Transmitted OUT Data Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_UNDERFIE      0x00000004 // Underflow Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_PERRE         0x00000008 // Pipe Error Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_NAKEDE        0x00000010 // NAKed Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_OVERFIE       0x00000020 // Overflow Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_RXSTALLDE     0x00000040 // Received STALLed Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_SHORTPACKETIE 0x00000080 // Short Packet Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_NBUSYBKE      0x00001000 // Number of Busy Banks Interrupt Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_FIFOCON       0x00004000 // FIFO Control
#define UOTGHS_HSTPIPIMR0_INTPIPES_PDISHDMA      0x00010000 // Pipe Interrupts Disable HDMA Request Enable
#define UOTGHS_HSTPIPIMR0_INTPIPES_PFREEZE       0x00020000 // Pipe Freeze
#define UOTGHS_HSTPIPIMR0_INTPIPES_RSTDT         0x00040000 // Reset Data Toggle

#define UOTGHS_HSTPIPIMR0_ISOPIPES_RXINE         0x00000001 // Received IN Data Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_TXOUTE        0x00000002 // Transmitted OUT Data Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_UNDERFIE      0x00000004 // Underflow Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_PERRE         0x00000008 // Pipe Error Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_NAKEDE        0x00000010 // NAKed Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_OVERFIE       0x00000020 // Overflow Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_CRCERRE       0x00000040 // CRC Error Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_SHORTPACKETIE 0x00000080 // Short Packet Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_NBUSYBKE      0x00001000 // Number of Busy Banks Interrupt Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_FIFOCON       0x00004000 // FIFO Control
#define UOTGHS_HSTPIPIMR0_ISOPIPES_PDISHDMA      0x00010000 // Pipe Interrupts Disable HDMA Request Enable
#define UOTGHS_HSTPIPIMR0_ISOPIPES_PFREEZE       0x00020000 // Pipe Freeze
#define UOTGHS_HSTPIPIMR0_ISOPIPES_RSTDT         0x00040000 // Reset Data Toggle

#define UOTGHS_HSTPIPIER_RXINES         0x00000001 // Received IN Data Interrupt Enable
#define UOTGHS_HSTPIPIER_TXOUTES        0x00000002 // Transmitted OUT Data Interrupt Enable
#define UOTGHS_HSTPIPIER_TXSTPES        0x00000004 // Transmitted SETUP Interrupt Enable
#define UOTGHS_HSTPIPIER_PERRES         0x00000008 // Pipe Error Interrupt Enable
#define UOTGHS_HSTPIPIER_NAKEDES        0x00000010 // NAKed Interrupt Enable
#define UOTGHS_HSTPIPIER_OVERFIES       0x00000020 // Overflow Interrupt Enable
#define UOTGHS_HSTPIPIER_RXSTALLDES     0x00000040 // Received STALLed Interrupt Enable
#define UOTGHS_HSTPIPIER_SHORTPACKETIES 0x00000080 // Short Packet Interrupt Enable
#define UOTGHS_HSTPIPIER_NBUSYBKES      0x00001000 // Number of Busy Banks Enable
#define UOTGHS_HSTPIPIER_PDISHDMAS      0x00010000 // Pipe Interrupts Disable HDMA Request Enable
#define UOTGHS_HSTPIPIER_PFREEZES       0x00020000 // Pipe Freeze Enable
#define UOTGHS_HSTPIPIER_RSTDTS         0x00040000 // Reset Data Toggle Enable

#define UOTGHS_HSTPIPIER0_INTPIPES_RXINES         0x00000001 // Received IN Data Interrupt Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_TXOUTES        0x00000002 // Transmitted OUT Data Interrupt Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_UNDERFIES      0x00000004 // Underflow Interrupt Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_PERRES         0x00000008 // Pipe Error Interrupt Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_NAKEDES        0x00000010 // NAKed Interrupt Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_OVERFIES       0x00000020 // Overflow Interrupt Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_RXSTALLDES     0x00000040 // Received STALLed Interrupt Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_SHORTPACKETIES 0x00000080 // Short Packet Interrupt Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_NBUSYBKES      0x00001000 // Number of Busy Banks Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_PDISHDMAS      0x00010000 // Pipe Interrupts Disable HDMA Request Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_PFREEZES       0x00020000 // Pipe Freeze Enable
#define UOTGHS_HSTPIPIER0_INTPIPES_RSTDTS         0x00040000 // Reset Data Toggle Enable

#define UOTGHS_HSTPIPIER0_ISOPIPES_RXINES         0x00000001 // Received IN Data Interrupt Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_TXOUTES        0x00000002 // Transmitted OUT Data Interrupt Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_UNDERFIES      0x00000004 // Underflow Interrupt Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_PERRES         0x00000008 // Pipe Error Interrupt Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_NAKEDES        0x00000010 // NAKed Interrupt Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_OVERFIES       0x00000020 // Overflow Interrupt Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_CRCERRES       0x00000040 // CRC Error Interrupt Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_SHORTPACKETIES 0x00000080 // Short Packet Interrupt Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_NBUSYBKES      0x00001000 // Number of Busy Banks Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_PDISHDMAS      0x00010000 // Pipe Interrupts Disable HDMA Request Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_PFREEZES       0x00020000 // Pipe Freeze Enable
#define UOTGHS_HSTPIPIER0_ISOPIPES_RSTDTS         0x00040000 // Reset Data Toggle Enable

#define UOTGHS_HSTPIPIDR_RXINEC         0x00000001 // Received IN Data Interrupt Disable
#define UOTGHS_HSTPIPIDR_TXOUTEC        0x00000002 // Transmitted OUT Data Interrupt Disable
#define UOTGHS_HSTPIPIDR_TXSTPEC        0x00000004 // Transmitted SETUP Interrupt Disable
#define UOTGHS_HSTPIPIDR_PERREC         0x00000008 // Pipe Error Interrupt Disable
#define UOTGHS_HSTPIPIDR_NAKEDEC        0x00000010 // NAKed Interrupt Disable
#define UOTGHS_HSTPIPIDR_OVERFIEC       0x00000020 // Overflow Interrupt Disable
#define UOTGHS_HSTPIPIDR_RXSTALLDEC     0x00000040 // Received STALLed Interrupt Disable
#define UOTGHS_HSTPIPIDR_SHORTPACKETIEC 0x00000080 // Short Packet Interrupt Disable
#define UOTGHS_HSTPIPIDR_NBUSYBKEC      0x00001000 // Number of Busy Banks Disable
#define UOTGHS_HSTPIPIDR_FIFOCONC       0x00004000 // FIFO Control Disable
#define UOTGHS_HSTPIPIDR_PDISHDMAC      0x00010000 // Pipe Interrupts Disable HDMA Request Disable
#define UOTGHS_HSTPIPIDR_PFREEZEC       0x00020000 // Pipe Freeze Disable

#define UOTGHS_HSTPIPIDR0_INTPIPES_RXINEC         0x00000001 // Received IN Data Interrupt Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_TXOUTEC        0x00000002 // Transmitted OUT Data Interrupt Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_UNDERFIEC      0x00000004 // Underflow Interrupt Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_PERREC         0x00000008 // Pipe Error Interrupt Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_NAKEDEC        0x00000010 // NAKed Interrupt Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_OVERFIEC       0x00000020 // Overflow Interrupt Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_RXSTALLDEC     0x00000040 // Received STALLed Interrupt Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_SHORTPACKETIEC 0x00000080 // Short Packet Interrupt Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_NBUSYBKEC      0x00001000 // Number of Busy Banks Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_FIFOCONC       0x00004000 // FIFO Control Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_PDISHDMAC      0x00010000 // Pipe Interrupts Disable HDMA Request Disable
#define UOTGHS_HSTPIPIDR0_INTPIPES_PFREEZEC       0x00020000 // Pipe Freeze Disable

#define UOTGHS_HSTPIPIDR0_ISOPIPES_RXINEC         0x00000001 // Received IN Data Interrupt Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_TXOUTEC        0x00000002 // Transmitted OUT Data Interrupt Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_UNDERFIEC      0x00000004 // Underflow Interrupt Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_PERREC         0x00000008 // Pipe Error Interrupt Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_NAKEDEC        0x00000010 // NAKed Interrupt Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_OVERFIEC       0x00000020 // Overflow Interrupt Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_CRCERREC       0x00000040 // CRC Error Interrupt Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_SHORTPACKETIEC 0x00000080 // Short Packet Interrupt Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_NBUSYBKEC      0x00001000 // Number of Busy Banks Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_FIFOCONC       0x00004000 // FIFO Control Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_PDISHDMAC      0x00010000 // Pipe Interrupts Disable HDMA Request Disable
#define UOTGHS_HSTPIPIDR0_ISOPIPES_PFREEZEC       0x00020000 // Pipe Freeze Disable

#define UOTGHS_HSTPIPINRQ_INRQ(value) (((value) & 0xFF) << 0) // IN Request Number before Freeze
#define UOTGHS_HSTPIPINRQ_INMODE      0x00000100              // IN Request Mode

#define UOTGHS_HSTPIPERR_DATATGL        0x00000001             // Data Toggle Error
#define UOTGHS_HSTPIPERR_DATAPID        0x00000002             // Data PID Error
#define UOTGHS_HSTPIPERR_PID            0x00000004             // PID Error
#define UOTGHS_HSTPIPERR_TIMEOUT        0x00000008             // Time-Out Error
#define UOTGHS_HSTPIPERR_CRC16          0x00000010             // CRC16 Error
#define UOTGHS_HSTPIPERR_COUNTER(value) (((value) & 0x3) << 5) // Error Counter

#define UOTGHS_HSTDMANXTDSC1_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_HSTDMAADDRESS1_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_HSTDMACONTROL1_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_HSTDMACONTROL1_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_HSTDMACONTROL1_END_TR_EN          0x00000004                 // End of Transfer Enable (Control)
#define UOTGHS_HSTDMACONTROL1_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_HSTDMACONTROL1_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_HSTDMACONTROL1_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_HSTDMACONTROL1_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_HSTDMACONTROL1_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_HSTDMACONTROL1_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_HSTDMASTATUS1_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_HSTDMASTATUS1_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_HSTDMASTATUS1_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_HSTDMASTATUS1_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_HSTDMASTATUS1_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_HSTDMASTATUS1_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_HSTDMANXTDSC2_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_HSTDMAADDRESS2_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_HSTDMACONTROL2_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_HSTDMACONTROL2_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_HSTDMACONTROL2_END_TR_EN          0x00000004                 // End of Transfer Enable (Control)
#define UOTGHS_HSTDMACONTROL2_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_HSTDMACONTROL2_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_HSTDMACONTROL2_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_HSTDMACONTROL2_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_HSTDMACONTROL2_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_HSTDMACONTROL2_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_HSTDMASTATUS2_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_HSTDMASTATUS2_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_HSTDMASTATUS2_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_HSTDMASTATUS2_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_HSTDMASTATUS2_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_HSTDMASTATUS2_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_HSTDMANXTDSC3_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_HSTDMAADDRESS3_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_HSTDMACONTROL3_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_HSTDMACONTROL3_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_HSTDMACONTROL3_END_TR_EN          0x00000004                 // End of Transfer Enable (Control)
#define UOTGHS_HSTDMACONTROL3_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_HSTDMACONTROL3_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_HSTDMACONTROL3_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_HSTDMACONTROL3_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_HSTDMACONTROL3_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_HSTDMACONTROL3_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_HSTDMASTATUS3_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_HSTDMASTATUS3_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_HSTDMASTATUS3_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_HSTDMASTATUS3_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_HSTDMASTATUS3_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_HSTDMASTATUS3_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_HSTDMANXTDSC4_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_HSTDMAADDRESS4_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_HSTDMACONTROL4_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_HSTDMACONTROL4_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_HSTDMACONTROL4_END_TR_EN          0x00000004                 // End of Transfer Enable (Control)
#define UOTGHS_HSTDMACONTROL4_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_HSTDMACONTROL4_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_HSTDMACONTROL4_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_HSTDMACONTROL4_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_HSTDMACONTROL4_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_HSTDMACONTROL4_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_HSTDMASTATUS4_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_HSTDMASTATUS4_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_HSTDMASTATUS4_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_HSTDMASTATUS4_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_HSTDMASTATUS4_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_HSTDMASTATUS4_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_HSTDMANXTDSC5_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_HSTDMAADDRESS5_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_HSTDMACONTROL5_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_HSTDMACONTROL5_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_HSTDMACONTROL5_END_TR_EN          0x00000004                 // End of Transfer Enable (Control)
#define UOTGHS_HSTDMACONTROL5_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_HSTDMACONTROL5_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_HSTDMACONTROL5_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_HSTDMACONTROL5_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_HSTDMACONTROL5_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_HSTDMACONTROL5_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_HSTDMASTATUS5_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_HSTDMASTATUS5_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_HSTDMASTATUS5_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_HSTDMASTATUS5_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_HSTDMASTATUS5_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_HSTDMASTATUS5_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_HSTDMANXTDSC6_NXT_DSC_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Next Descriptor Address

#define UOTGHS_HSTDMAADDRESS6_BUFF_ADD(value) (((value) & 0xFFFFFFFF) << 0) // Buffer Address

#define UOTGHS_HSTDMACONTROL6_CHANN_ENB          0x00000001                 // Channel Enable Command
#define UOTGHS_HSTDMACONTROL6_LDNXT_DSC          0x00000002                 // Load Next Channel Transfer Descriptor Enable Command
#define UOTGHS_HSTDMACONTROL6_END_TR_EN          0x00000004                 // End of Transfer Enable (Control)
#define UOTGHS_HSTDMACONTROL6_END_B_EN           0x00000008                 // End of Buffer Enable Control
#define UOTGHS_HSTDMACONTROL6_END_TR_IT          0x00000010                 // End of Transfer Interrupt Enable
#define UOTGHS_HSTDMACONTROL6_END_BUFFIT         0x00000020                 // End of Buffer Interrupt Enable
#define UOTGHS_HSTDMACONTROL6_DESC_LD_IT         0x00000040                 // Descriptor Loaded Interrupt Enable
#define UOTGHS_HSTDMACONTROL6_BURST_LCK          0x00000080                 // Burst Lock Enable
#define UOTGHS_HSTDMACONTROL6_BUFF_LENGTH(value) (((value) & 0xFFFF) << 16) // Buffer Byte Length (Write-only)

#define UOTGHS_HSTDMASTATUS6_CHANN_ENB         0x00000001                 // Channel Enable Status
#define UOTGHS_HSTDMASTATUS6_CHANN_ACT         0x00000002                 // Channel Active Status
#define UOTGHS_HSTDMASTATUS6_END_TR_ST         0x00000010                 // End of Channel Transfer Status
#define UOTGHS_HSTDMASTATUS6_END_BF_ST         0x00000020                 // End of Channel Buffer Status
#define UOTGHS_HSTDMASTATUS6_DESC_LDST         0x00000040                 // Descriptor Loaded Status
#define UOTGHS_HSTDMASTATUS6_BUFF_COUNT(value) (((value) & 0xFFFF) << 16) // Buffer Byte Count

#define UOTGHS_CTRL_IDTE            0x00000001              // ID Transition Interrupt Enable
#define UOTGHS_CTRL_VBUSTE          0x00000002              // VBus Transition Interrupt Enable
#define UOTGHS_CTRL_SRPE            0x00000004              // SRP Interrupt Enable
#define UOTGHS_CTRL_VBERRE          0x00000008              // VBus Error Interrupt Enable
#define UOTGHS_CTRL_BCERRE          0x00000010              // B-Connection Error Interrupt Enable
#define UOTGHS_CTRL_ROLEEXE         0x00000020              // Role Exchange Interrupt Enable
#define UOTGHS_CTRL_HNPERRE         0x00000040              // HNP Error Interrupt Enable
#define UOTGHS_CTRL_STOE            0x00000080              // Suspend Time-Out Interrupt Enable
#define UOTGHS_CTRL_VBUSHWC         0x00000100              // VBus Hardware Control
#define UOTGHS_CTRL_SRPSEL          0x00000200              // SRP Selection
#define UOTGHS_CTRL_SRPREQ          0x00000400              // SRP Request
#define UOTGHS_CTRL_HNPREQ          0x00000800              // HNP Request
#define UOTGHS_CTRL_OTGPADE         0x00001000              // OTG Pad Enable
#define UOTGHS_CTRL_VBUSPO          0x00002000              // VBus Polarity Off
#define UOTGHS_CTRL_FRZCLK          0x00004000              // Freeze USB Clock
#define UOTGHS_CTRL_USBE            0x00008000              // UOTGHS Enable
#define UOTGHS_CTRL_TIMVALUE(value) (((value) & 0x3) << 16) // Timer Value
#define UOTGHS_CTRL_TIMPAGE(value)  (((value) & 0x3) << 20) // Timer Page
#define UOTGHS_CTRL_UNLOCK          0x00400000              // Timer Access Unlock
#define UOTGHS_CTRL_UIDE_UIMOD      0x00000000              // The USB mode (device/host) is selected from the UIMOD bit
#define UOTGHS_CTRL_UIDE_UOTGID     0x01000000              // The USB mode (device/host) is selected from the UOTGID input pin
#define UOTGHS_CTRL_UIMOD_HOST      0x00000000              // The module is in USB host mode
#define UOTGHS_CTRL_UIMOD_DEVICE    0x02000000              // The module is in USB device mode

#define UOTGHS_SR_IDTI             0x00000001 // ID Transition Interrupt
#define UOTGHS_SR_VBUSTI           0x00000002 // VBus Transition Interrupt
#define UOTGHS_SR_SRPI             0x00000004 // SRP Interrupt
#define UOTGHS_SR_VBERRI           0x00000008 // VBus Error Interrupt
#define UOTGHS_SR_BCERRI           0x00000010 // B-Connection Error Interrupt
#define UOTGHS_SR_ROLEEXI          0x00000020 // Role Exchange Interrupt
#define UOTGHS_SR_HNPERRI          0x00000040 // HNP Error Interrupt
#define UOTGHS_SR_STOI             0x00000080 // Suspend Time-Out Interrupt
#define UOTGHS_SR_VBUSRQ           0x00000200 // VBus Request
#define UOTGHS_SR_ID               0x00000400 // UOTGID Pin State
#define UOTGHS_SR_VBUS             0x00000800 // VBus Level
#define UOTGHS_SR_SPEED_FULL_SPEED 0x00000000 // Full-Speed mode
#define UOTGHS_SR_SPEED_HIGH_SPEED 0x00001000 // High-Speed mode
#define UOTGHS_SR_SPEED_LOW_SPEED  0x00002000 // Low-Speed mode
#define UOTGHS_SR_CLKUSABLE        0x00004000 // UTMI Clock Usable

#define UOTGHS_SCR_IDTIC    0x00000001 // ID Transition Interrupt Clear
#define UOTGHS_SCR_VBUSTIC  0x00000002 // VBus Transition Interrupt Clear
#define UOTGHS_SCR_SRPIC    0x00000004 // SRP Interrupt Clear
#define UOTGHS_SCR_VBERRIC  0x00000008 // VBus Error Interrupt Clear
#define UOTGHS_SCR_BCERRIC  0x00000010 // B-Connection Error Interrupt Clear
#define UOTGHS_SCR_ROLEEXIC 0x00000020 // Role Exchange Interrupt Clear
#define UOTGHS_SCR_HNPERRIC 0x00000040 // HNP Error Interrupt Clear
#define UOTGHS_SCR_STOIC    0x00000080 // Suspend Time-Out Interrupt Clear
#define UOTGHS_SCR_VBUSRQC  0x00000200 // VBus Request Clear

#define UOTGHS_SFR_IDTIS    0x00000001 // ID Transition Interrupt Set
#define UOTGHS_SFR_VBUSTIS  0x00000002 // VBus Transition Interrupt Set
#define UOTGHS_SFR_SRPIS    0x00000004 // SRP Interrupt Set
#define UOTGHS_SFR_VBERRIS  0x00000008 // VBus Error Interrupt Set
#define UOTGHS_SFR_BCERRIS  0x00000010 // B-Connection Error Interrupt Set
#define UOTGHS_SFR_ROLEEXIS 0x00000020 // Role Exchange Interrupt Set
#define UOTGHS_SFR_HNPERRIS 0x00000040 // HNP Error Interrupt Set
#define UOTGHS_SFR_STOIS    0x00000080 // Suspend Time-Out Interrupt Set
#define UOTGHS_SFR_VBUSRQS  0x00000200 // VBus Request Set

#define UOTGHS_FSM_DRDSTATE_A_IDLESTATE      0x00000000 // This is the start state for A-devices (when the ID pin is 0)
#define UOTGHS_FSM_DRDSTATE_A_WAIT_VRISE     0x00000001 // In this state, the A-device waits for the voltage on VBus to rise above the A-device VBus Valid threshold (4.4 V)
#define UOTGHS_FSM_DRDSTATE_A_WAIT_BCON      0x00000002 // In this state, the A-device waits for the B-device to signal a connection
#define UOTGHS_FSM_DRDSTATE_A_HOST           0x00000003 // In this state, the A-device that operates in Host mode is operational
#define UOTGHS_FSM_DRDSTATE_A_SUSPEND        0x00000004 // The A-device operating as a host is in the suspend mode
#define UOTGHS_FSM_DRDSTATE_A_PERIPHERAL     0x00000005 // The A-device operates as a peripheral
#define UOTGHS_FSM_DRDSTATE_A_WAIT_VFALL     0x00000006 // In this state, the A-device waits for the voltage on VBus to drop below the A-device Session Valid threshold (1.4 V)
#define UOTGHS_FSM_DRDSTATE_A_VBUS_ERR       0x00000007 // In this state, the A-device waits for recovery of the over-current condition that caused it to enter this state
#define UOTGHS_FSM_DRDSTATE_A_WAIT_DISCHARGE 0x00000008 // In this state, the A-device waits for the data USB line to discharge (100 us)
#define UOTGHS_FSM_DRDSTATE_B_IDLE           0x00000009 // This is the start state for B-device (when the ID pin is 1)
#define UOTGHS_FSM_DRDSTATE_B_PERIPHERAL     0x0000000A // In this state, the B-device acts as the peripheral
#define UOTGHS_FSM_DRDSTATE_B_WAIT_BEGIN_HNP 0x0000000B // In this state, the B-device is in suspend mode and waits until 3 ms before initiating the HNP protocol if requested
#define UOTGHS_FSM_DRDSTATE_B_WAIT_DISCHARGE 0x0000000C // In this state, the B-device waits for the data USB line to discharge (100 us) before becoming Host
#define UOTGHS_FSM_DRDSTATE_B_WAIT_ACON      0x0000000D // In this state, the B-device waits for the A-device to signal a connect before becoming B-Host
#define UOTGHS_FSM_DRDSTATE_B_HOST           0x0000000E // In this state, the B-device acts as the Host
#define UOTGHS_FSM_DRDSTATE_B_SRP_INIT       0x0000000F // In this state, the B-device attempts to start a session using the SRP protocol

#define EMAC_NCR   (*(volatile unsigned int *)0x400B0000)       // [Network Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1072980)
#define EMAC_NCFGR (*(volatile unsigned int *)0x400B0004)       // [Network Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1149047)
#define EMAC_NSR   (*(const volatile unsigned int *)0x400B0008) // [Network Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1150025)
#define EMAC_TSR   (*(volatile unsigned int *)0x400B0014)       // [Transmit Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1150335)
#define EMAC_RBQP  (*(volatile unsigned int *)0x400B0018)       // [Receive Buffer Queue Pointer Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1151442)
#define EMAC_TBQP  (*(volatile unsigned int *)0x400B001C)       // [Transmit Buffer Queue Pointer Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1172867)
#define EMAC_RSR   (*(volatile unsigned int *)0x400B0020)       // [Receive Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1172862)
#define EMAC_ISR   (*(volatile unsigned int *)0x400B0024)       // [Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1152176)
#define EMAC_IER   (*(volatile unsigned int *)0x400B0028)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1269410)
#define EMAC_IDR   (*(volatile unsigned int *)0x400B002C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1223058)
#define EMAC_IMR   (*(const volatile unsigned int *)0x400B0030) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1223069)
#define EMAC_MAN   (*(volatile unsigned int *)0x400B0034)       // [Phy Maintenance Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1242252)
#define EMAC_PTR   (*(volatile unsigned int *)0x400B0038)       // [Pause Time Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1154119)
#define EMAC_PFR   (*(volatile unsigned int *)0x400B003C)       // [Pause Frames Received Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1175917)
#define EMAC_FTO   (*(volatile unsigned int *)0x400B0040)       // [Frames Transmitted Ok Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1158097)
#define EMAC_SCF   (*(volatile unsigned int *)0x400B0044)       // [Single Collision Frames Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1158151)
#define EMAC_MCF   (*(volatile unsigned int *)0x400B0048)       // [Multiple Collision Frames Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1158376)
#define EMAC_FRO   (*(volatile unsigned int *)0x400B004C)       // [Frames Received Ok Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1158599)
#define EMAC_FCSE  (*(volatile unsigned int *)0x400B0050)       // [Frame Check Sequence Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1158830)
#define EMAC_ALE   (*(volatile unsigned int *)0x400B0054)       // [Alignment Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1159073)
#define EMAC_DTF   (*(volatile unsigned int *)0x400B0058)       // [Deferred Transmission Frames Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1159314)
#define EMAC_LCOL  (*(volatile unsigned int *)0x400B005C)       // [Late Collisions Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1159547)
#define EMAC_ECOL  (*(volatile unsigned int *)0x400B0060)       // [Excessive Collisions Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1159780)
#define EMAC_TUND  (*(volatile unsigned int *)0x400B0064)       // [Transmit Underrun Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1160180)
#define EMAC_CSE   (*(volatile unsigned int *)0x400B0068)       // [Carrier Sense Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1160590)
#define EMAC_RRE   (*(volatile unsigned int *)0x400B006C)       // [Receive Resource Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1160830)
#define EMAC_ROV   (*(volatile unsigned int *)0x400B0070)       // [Receive Overrun Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1161061)
#define EMAC_RSE   (*(volatile unsigned int *)0x400B0074)       // [Receive Symbol Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1223311)
#define EMAC_ELE   (*(volatile unsigned int *)0x400B0078)       // [Excessive Length Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1161525)
#define EMAC_RJA   (*(volatile unsigned int *)0x400B007C)       // [Receive Jabbers Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1161763)
#define EMAC_USF   (*(volatile unsigned int *)0x400B0080)       // [Undersize Frames Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1271614)
#define EMAC_STE   (*(volatile unsigned int *)0x400B0084)       // [SQE Test Errors Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1162226)
#define EMAC_RLE   (*(volatile unsigned int *)0x400B0088)       // [Received Length Field Mismatch Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1162456)
#define EMAC_HRB   (*(volatile unsigned int *)0x400B0090)       // [Hash Register Bottom [31:0] Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1262976)
#define EMAC_HRT   (*(volatile unsigned int *)0x400B0094)       // [Hash Register Top [63:32] Register]()
#define EMAC_SA1B  (*(volatile unsigned int *)0x400B0098)       // [Specific Address 1 Bottom Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1223117)
#define EMAC_SA1T  (*(volatile unsigned int *)0x400B009C)       // [Specific Address 1 Top Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1173265)
#define EMAC_SA2B  (*(volatile unsigned int *)0x400B00A0)       // [Specific Address 2 Bottom Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1223136)
#define EMAC_SA2T  (*(volatile unsigned int *)0x400B00A4)       // [Specific Address 2 Top Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1173679)
#define EMAC_SA3B  (*(volatile unsigned int *)0x400B00A8)       // [Specific Address 3 Bottom Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1223155)
#define EMAC_SA3T  (*(volatile unsigned int *)0x400B00AC)       // [Specific Address 3 Top Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1174093)
#define EMAC_SA4B  (*(volatile unsigned int *)0x400B00B0)       // [Specific Address 4 Bottom Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1223174)
#define EMAC_SA4T  (*(volatile unsigned int *)0x400B00B4)       // [Specific Address 4 Top Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1174507)
#define EMAC_TID   (*(volatile unsigned int *)0x400B00B8)       // [Type ID Checking Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1174751)
#define EMAC_USRIO (*(volatile unsigned int *)0x400B00C0)       // [User Input/Output Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G32.1175990)

#define EMAC_NCR_LB      0x00000001 // LoopBack
#define EMAC_NCR_LLB     0x00000002 // Loopback local
#define EMAC_NCR_RE      0x00000004 // Receive enable
#define EMAC_NCR_TE      0x00000008 // Transmit enable
#define EMAC_NCR_MPE     0x00000010 // Management port enable
#define EMAC_NCR_CLRSTAT 0x00000020 // Clear statistics registers
#define EMAC_NCR_INCSTAT 0x00000040 // Increment statistics registers
#define EMAC_NCR_WESTAT  0x00000080 // Write enable for statistics registers
#define EMAC_NCR_BP      0x00000100 // Back pressure
#define EMAC_NCR_TSTART  0x00000200 // Start transmission
#define EMAC_NCR_THALT   0x00000400 // Transmit halt

#define EMAC_NCFGR_SPD           0x00000001 // Speed
#define EMAC_NCFGR_FD            0x00000002 // Full Duplex
#define EMAC_NCFGR_JFRAME        0x00000008 // Jumbo Frames
#define EMAC_NCFGR_CAF           0x00000010 // Copy All Frames
#define EMAC_NCFGR_NBC           0x00000020 // No Broadcast
#define EMAC_NCFGR_MTI           0x00000040 // Multicast Hash Enable
#define EMAC_NCFGR_UNI           0x00000080 // Unicast Hash Enable
#define EMAC_NCFGR_BIG           0x00000100 // Receive 1536 bytes frames
#define EMAC_NCFGR_CLK_MCK_8     0x00000000 // MCK divided by 8 (MCK up to 20 MHz)
#define EMAC_NCFGR_CLK_MCK_16    0x00000400 // MCK divided by 16 (MCK up to 40 MHz)
#define EMAC_NCFGR_CLK_MCK_32    0x00000800 // MCK divided by 32 (MCK up to 80 MHz)
#define EMAC_NCFGR_CLK_MCK_64    0x00000C00 // MCK divided by 64 (MCK up to 160 MHz)
#define EMAC_NCFGR_RTY           0x00001000 // Retry test
#define EMAC_NCFGR_PAE           0x00002000 // Pause Enable
#define EMAC_NCFGR_RBOF_OFFSET_0 0x00000000 // No offset from start of receive buffer
#define EMAC_NCFGR_RBOF_OFFSET_1 0x00004000 // One-byte offset from start of receive buffer
#define EMAC_NCFGR_RBOF_OFFSET_2 0x00008000 // Two-byte offset from start of receive buffer
#define EMAC_NCFGR_RBOF_OFFSET_3 0x0000C000 // Three-byte offset from start of receive buffer
#define EMAC_NCFGR_RLCE          0x00010000 // Receive Length field Checking Enable
#define EMAC_NCFGR_DRFCS         0x00020000 // Discard Receive FCS
#define EMAC_NCFGR_EFRHD         0x00040000 //
#define EMAC_NCFGR_IRXFCS        0x00080000 // Ignore RX FCS

#define EMAC_NSR_MDIO 0x00000002 //
#define EMAC_NSR_IDLE 0x00000004 //

#define EMAC_TSR_UBR  0x00000001 // Used Bit Read
#define EMAC_TSR_COL  0x00000002 // Collision Occurred
#define EMAC_TSR_RLES 0x00000004 // Retry Limit exceeded
#define EMAC_TSR_TGO  0x00000008 // Transmit Go
#define EMAC_TSR_BEX  0x00000010 // Buffers exhausted mid frame
#define EMAC_TSR_COMP 0x00000020 // Transmit Complete
#define EMAC_TSR_UND  0x00000040 // Transmit Underrun

#define EMAC_RBQP_ADDR(value) (((value) & 0x3FFFFFFF) << 2) // Receive buffer queue pointer address

#define EMAC_TBQP_ADDR(value) (((value) & 0x3FFFFFFF) << 2) // Transmit buffer queue pointer address

#define EMAC_RSR_BNA 0x00000001 // Buffer Not Available
#define EMAC_RSR_REC 0x00000002 // Frame Received
#define EMAC_RSR_OVR 0x00000004 // Receive Overrun

#define EMAC_ISR_MFD   0x00000001 // Management Frame Done
#define EMAC_ISR_RCOMP 0x00000002 // Receive Complete
#define EMAC_ISR_RXUBR 0x00000004 // Receive Used Bit Read
#define EMAC_ISR_TXUBR 0x00000008 // Transmit Used Bit Read
#define EMAC_ISR_TUND  0x00000010 // Ethernet Transmit Buffer Underrun
#define EMAC_ISR_RLEX  0x00000020 // Retry Limit Exceeded
#define EMAC_ISR_TXERR 0x00000040 // Transmit Error
#define EMAC_ISR_TCOMP 0x00000080 // Transmit Complete
#define EMAC_ISR_ROVR  0x00000400 // Receive Overrun
#define EMAC_ISR_HRESP 0x00000800 // Hresp not OK
#define EMAC_ISR_PFRE  0x00001000 // Pause Frame Received
#define EMAC_ISR_PTZ   0x00002000 // Pause Time Zero

#define EMAC_IER_MFD   0x00000001 // Management Frame sent
#define EMAC_IER_RCOMP 0x00000002 // Receive Complete
#define EMAC_IER_RXUBR 0x00000004 // Receive Used Bit Read
#define EMAC_IER_TXUBR 0x00000008 // Transmit Used Bit Read
#define EMAC_IER_TUND  0x00000010 // Ethernet Transmit Buffer Underrun
#define EMAC_IER_RLE   0x00000020 // Retry Limit Exceeded
#define EMAC_IER_TXERR 0x00000040 //
#define EMAC_IER_TCOMP 0x00000080 // Transmit Complete
#define EMAC_IER_ROVR  0x00000400 // Receive Overrun
#define EMAC_IER_HRESP 0x00000800 // Hresp not OK
#define EMAC_IER_PFR   0x00001000 // Pause Frame Received
#define EMAC_IER_PTZ   0x00002000 // Pause Time Zero

#define EMAC_IDR_MFD   0x00000001 // Management Frame sent
#define EMAC_IDR_RCOMP 0x00000002 // Receive Complete
#define EMAC_IDR_RXUBR 0x00000004 // Receive Used Bit Read
#define EMAC_IDR_TXUBR 0x00000008 // Transmit Used Bit Read
#define EMAC_IDR_TUND  0x00000010 // Ethernet Transmit Buffer Underrun
#define EMAC_IDR_RLE   0x00000020 // Retry Limit Exceeded
#define EMAC_IDR_TXERR 0x00000040 //
#define EMAC_IDR_TCOMP 0x00000080 // Transmit Complete
#define EMAC_IDR_ROVR  0x00000400 // Receive Overrun
#define EMAC_IDR_HRESP 0x00000800 // Hresp not OK
#define EMAC_IDR_PFR   0x00001000 // Pause Frame Received
#define EMAC_IDR_PTZ   0x00002000 // Pause Time Zero

#define EMAC_IMR_MFD   0x00000001 // Management Frame sent
#define EMAC_IMR_RCOMP 0x00000002 // Receive Complete
#define EMAC_IMR_RXUBR 0x00000004 // Receive Used Bit Read
#define EMAC_IMR_TXUBR 0x00000008 // Transmit Used Bit Read
#define EMAC_IMR_TUND  0x00000010 // Ethernet Transmit Buffer Underrun
#define EMAC_IMR_RLE   0x00000020 // Retry Limit Exceeded
#define EMAC_IMR_TXERR 0x00000040 //
#define EMAC_IMR_TCOMP 0x00000080 // Transmit Complete
#define EMAC_IMR_ROVR  0x00000400 // Receive Overrun
#define EMAC_IMR_HRESP 0x00000800 // Hresp not OK
#define EMAC_IMR_PFR   0x00001000 // Pause Frame Received
#define EMAC_IMR_PTZ   0x00002000 // Pause Time Zero

#define EMAC_MAN_DATA(value) (((value) & 0xFFFF) << 0) //
#define EMAC_MAN_CODE(value) (((value) & 0x3) << 16)   //
#define EMAC_MAN_REGA(value) (((value) & 0x1F) << 18)  // Register Address
#define EMAC_MAN_PHYA(value) (((value) & 0x1F) << 23)  // PHY Address
#define EMAC_MAN_RW(value)   (((value) & 0x3) << 28)   // Read-write
#define EMAC_MAN_SOF(value)  (((value) & 0x3) << 30)   // Start of frame

#define EMAC_PTR_PTIME(value) (((value) & 0xFFFF) << 0) // Pause Time

#define EMAC_PFR_FROK(value) (((value) & 0xFFFF) << 0) // Pause Frames received OK

#define EMAC_FTO_FTOK(value) (((value) & 0xFFFFFF) << 0) // Frames Transmitted OK

#define EMAC_SCF_SCF(value) (((value) & 0xFFFF) << 0) // Single Collision Frames

#define EMAC_MCF_MCF(value) (((value) & 0xFFFF) << 0) // Multicollision Frames

#define EMAC_FRO_FROK(value) (((value) & 0xFFFFFF) << 0) // Frames Received OK

#define EMAC_FCSE_FCSE(value) (((value) & 0xFF) << 0) // Frame Check Sequence Errors

#define EMAC_ALE_ALE(value) (((value) & 0xFF) << 0) // Alignment Errors

#define EMAC_DTF_DTF(value) (((value) & 0xFFFF) << 0) // Deferred Transmission Frames

#define EMAC_LCOL_LCOL(value) (((value) & 0xFF) << 0) // Late Collisions

#define EMAC_ECOL_EXCOL(value) (((value) & 0xFF) << 0) // Excessive Collisions

#define EMAC_TUND_TUND(value) (((value) & 0xFF) << 0) // Transmit Underruns

#define EMAC_CSE_CSE(value) (((value) & 0xFF) << 0) // Carrier Sense Errors

#define EMAC_RRE_RRE(value) (((value) & 0xFFFF) << 0) // Receive Resource Errors

#define EMAC_ROV_ROVR(value) (((value) & 0xFF) << 0) // Receive Overrun

#define EMAC_RSE_RSE(value) (((value) & 0xFF) << 0) // Receive Symbol Errors

#define EMAC_ELE_EXL(value) (((value) & 0xFF) << 0) // Excessive Length Errors

#define EMAC_RJA_RJB(value) (((value) & 0xFF) << 0) // Receive Jabbers

#define EMAC_USF_USF(value) (((value) & 0xFF) << 0) // Undersize frames

#define EMAC_STE_SQER(value) (((value) & 0xFF) << 0) // SQE test errors

#define EMAC_RLE_RLFM(value) (((value) & 0xFF) << 0) // Receive Length Field Mismatch

#define EMAC_HRB_ADDR(value) (((value) & 0xFFFFFFFF) << 0) //

#define EMAC_HRT_ADDR(value) (((value) & 0xFFFFFFFF) << 0) //

#define EMAC_SA1B_ADDR(value) (((value) & 0xFFFFFFFF) << 0) //

#define EMAC_SA1T_ADDR(value) (((value) & 0xFFFF) << 0) //

#define EMAC_SA2B_ADDR(value) (((value) & 0xFFFFFFFF) << 0) //

#define EMAC_SA2T_ADDR(value) (((value) & 0xFFFF) << 0) //

#define EMAC_SA3B_ADDR(value) (((value) & 0xFFFFFFFF) << 0) //

#define EMAC_SA3T_ADDR(value) (((value) & 0xFFFF) << 0) //

#define EMAC_SA4B_ADDR(value) (((value) & 0xFFFFFFFF) << 0) //

#define EMAC_SA4T_ADDR(value) (((value) & 0xFFFF) << 0) //

#define EMAC_TID_TID(value) (((value) & 0xFFFF) << 0) // Type ID checking

#define EMAC_USRIO_RMII  0x00000001 // Reduce MII
#define EMAC_USRIO_CLKEN 0x00000002 // Clock Enable

#define CAN0_MR      (*(volatile unsigned int *)0x400B4000)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1203895)
#define CAN0_IER     (*(volatile unsigned int *)0x400B4004)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1204127)
#define CAN0_IDR     (*(volatile unsigned int *)0x400B4008)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1204398)
#define CAN0_IMR     (*(const volatile unsigned int *)0x400B400C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1204669)
#define CAN0_SR      (*(const volatile unsigned int *)0x400B4010) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1204941)
#define CAN0_BR      (*(volatile unsigned int *)0x400B4014)       // [Baudrate Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1205284)
#define CAN0_TIM     (*(const volatile unsigned int *)0x400B4018) // [Timer Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1205507)
#define CAN0_TIMESTP (*(const volatile unsigned int *)0x400B401C) // [Timestamp Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1205742)
#define CAN0_ECR     (*(const volatile unsigned int *)0x400B4020) // [Error Counter Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1205978)
#define CAN0_TCR     (*(volatile unsigned int *)0x400B4024)       // [Transfer Command Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206172)
#define CAN0_ACR     (*(volatile unsigned int *)0x400B4028)       // [Abort Command Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206432)
#define CAN0_WPMR    (*(volatile unsigned int *)0x400B40E4)       // [Write Protect Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1257255)
#define CAN0_WPSR    (*(const volatile unsigned int *)0x400B40E8) // [Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1257228)
#define CAN0_MMR0    (*(volatile unsigned int *)0x400B4200)       // [Mailbox Mode Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN0_MAM0    (*(volatile unsigned int *)0x400B4204)       // [Mailbox Acceptance Mask Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN0_MID0    (*(volatile unsigned int *)0x400B4208)       // [Mailbox ID Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN0_MFID0   (*(const volatile unsigned int *)0x400B420C) // [Mailbox Family ID Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN0_MSR0    (*(const volatile unsigned int *)0x400B4210) // [Mailbox Status Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN0_MDL0    (*(volatile unsigned int *)0x400B4214)       // [Mailbox Data Low Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN0_MDH0    (*(volatile unsigned int *)0x400B4218)       // [Mailbox Data High Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN0_MCR0    (*(volatile unsigned int *)0x400B421C)       // [Mailbox Control Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN0_MMR1    (*(volatile unsigned int *)0x400B4220)       // [Mailbox Mode Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN0_MAM1    (*(volatile unsigned int *)0x400B4224)       // [Mailbox Acceptance Mask Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN0_MID1    (*(volatile unsigned int *)0x400B4228)       // [Mailbox ID Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN0_MFID1   (*(const volatile unsigned int *)0x400B422C) // [Mailbox Family ID Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN0_MSR1    (*(const volatile unsigned int *)0x400B4230) // [Mailbox Status Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN0_MDL1    (*(volatile unsigned int *)0x400B4234)       // [Mailbox Data Low Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN0_MDH1    (*(volatile unsigned int *)0x400B4238)       // [Mailbox Data High Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN0_MCR1    (*(volatile unsigned int *)0x400B423C)       // [Mailbox Control Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN0_MMR2    (*(volatile unsigned int *)0x400B4240)       // [Mailbox Mode Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN0_MAM2    (*(volatile unsigned int *)0x400B4244)       // [Mailbox Acceptance Mask Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN0_MID2    (*(volatile unsigned int *)0x400B4248)       // [Mailbox ID Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN0_MFID2   (*(const volatile unsigned int *)0x400B424C) // [Mailbox Family ID Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN0_MSR2    (*(const volatile unsigned int *)0x400B4250) // [Mailbox Status Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN0_MDL2    (*(volatile unsigned int *)0x400B4254)       // [Mailbox Data Low Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN0_MDH2    (*(volatile unsigned int *)0x400B4258)       // [Mailbox Data High Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN0_MCR2    (*(volatile unsigned int *)0x400B425C)       // [Mailbox Control Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN0_MMR3    (*(volatile unsigned int *)0x400B4260)       // [Mailbox Mode Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN0_MAM3    (*(volatile unsigned int *)0x400B4264)       // [Mailbox Acceptance Mask Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN0_MID3    (*(volatile unsigned int *)0x400B4268)       // [Mailbox ID Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN0_MFID3   (*(const volatile unsigned int *)0x400B426C) // [Mailbox Family ID Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN0_MSR3    (*(const volatile unsigned int *)0x400B4270) // [Mailbox Status Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN0_MDL3    (*(volatile unsigned int *)0x400B4274)       // [Mailbox Data Low Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN0_MDH3    (*(volatile unsigned int *)0x400B4278)       // [Mailbox Data High Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN0_MCR3    (*(volatile unsigned int *)0x400B427C)       // [Mailbox Control Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN0_MMR4    (*(volatile unsigned int *)0x400B4280)       // [Mailbox Mode Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN0_MAM4    (*(volatile unsigned int *)0x400B4284)       // [Mailbox Acceptance Mask Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN0_MID4    (*(volatile unsigned int *)0x400B4288)       // [Mailbox ID Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN0_MFID4   (*(const volatile unsigned int *)0x400B428C) // [Mailbox Family ID Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN0_MSR4    (*(const volatile unsigned int *)0x400B4290) // [Mailbox Status Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN0_MDL4    (*(volatile unsigned int *)0x400B4294)       // [Mailbox Data Low Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN0_MDH4    (*(volatile unsigned int *)0x400B4298)       // [Mailbox Data High Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN0_MCR4    (*(volatile unsigned int *)0x400B429C)       // [Mailbox Control Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN0_MMR5    (*(volatile unsigned int *)0x400B42A0)       // [Mailbox Mode Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN0_MAM5    (*(volatile unsigned int *)0x400B42A4)       // [Mailbox Acceptance Mask Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN0_MID5    (*(volatile unsigned int *)0x400B42A8)       // [Mailbox ID Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN0_MFID5   (*(const volatile unsigned int *)0x400B42AC) // [Mailbox Family ID Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN0_MSR5    (*(const volatile unsigned int *)0x400B42B0) // [Mailbox Status Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN0_MDL5    (*(volatile unsigned int *)0x400B42B4)       // [Mailbox Data Low Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN0_MDH5    (*(volatile unsigned int *)0x400B42B8)       // [Mailbox Data High Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN0_MCR5    (*(volatile unsigned int *)0x400B42BC)       // [Mailbox Control Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN0_MMR6    (*(volatile unsigned int *)0x400B42C0)       // [Mailbox Mode Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN0_MAM6    (*(volatile unsigned int *)0x400B42C4)       // [Mailbox Acceptance Mask Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN0_MID6    (*(volatile unsigned int *)0x400B42C8)       // [Mailbox ID Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN0_MFID6   (*(const volatile unsigned int *)0x400B42CC) // [Mailbox Family ID Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN0_MSR6    (*(const volatile unsigned int *)0x400B42D0) // [Mailbox Status Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN0_MDL6    (*(volatile unsigned int *)0x400B42D4)       // [Mailbox Data Low Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN0_MDH6    (*(volatile unsigned int *)0x400B42D8)       // [Mailbox Data High Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN0_MCR6    (*(volatile unsigned int *)0x400B42DC)       // [Mailbox Control Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN0_MMR7    (*(volatile unsigned int *)0x400B42E0)       // [Mailbox Mode Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN0_MAM7    (*(volatile unsigned int *)0x400B42E4)       // [Mailbox Acceptance Mask Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN0_MID7    (*(volatile unsigned int *)0x400B42E8)       // [Mailbox ID Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN0_MFID7   (*(const volatile unsigned int *)0x400B42EC) // [Mailbox Family ID Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN0_MSR7    (*(const volatile unsigned int *)0x400B42F0) // [Mailbox Status Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN0_MDL7    (*(volatile unsigned int *)0x400B42F4)       // [Mailbox Data Low Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN0_MDH7    (*(volatile unsigned int *)0x400B42F8)       // [Mailbox Data High Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN0_MCR7    (*(volatile unsigned int *)0x400B42FC)       // [Mailbox Control Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)

#define CAN0_MR_CANEN            0x00000001 // CAN Controller Enable
#define CAN0_MR_LPM              0x00000002 // Disable/Enable Low Power Mode
#define CAN0_MR_ABM              0x00000004 // Disable/Enable Autobaud/Listen mode
#define CAN0_MR_OVL              0x00000008 // Disable/Enable Overload Frame
#define CAN0_MR_TEOF             0x00000010 // Timestamp messages at each end of Frame
#define CAN0_MR_TTM              0x00000020 // Disable/Enable Time Triggered Mode
#define CAN0_MR_TIMFRZ           0x00000040 // Enable Timer Freeze
#define CAN0_MR_DRPT             0x00000080 // Disable Repeat
#define CAN0_MR_RXSYNC_DOUBLE_PP 0x00000000 // Rx Signal with Double Synchro Stages (2 Positive Edges)
#define CAN0_MR_RXSYNC_DOUBLE_PN 0x01000000 // Rx Signal with Double Synchro Stages (One Positive Edge and One Negative Edge)
#define CAN0_MR_RXSYNC_SINGLE_P  0x02000000 // Rx Signal with Single Synchro Stage (Positive Edge)
#define CAN0_MR_RXSYNC_NONE      0x03000000 // Rx Signal with No Synchro Stage

#define CAN0_IER_MB0    0x00000001 // Mailbox 0 Interrupt Enable
#define CAN0_IER_MB1    0x00000002 // Mailbox 1 Interrupt Enable
#define CAN0_IER_MB2    0x00000004 // Mailbox 2 Interrupt Enable
#define CAN0_IER_MB3    0x00000008 // Mailbox 3 Interrupt Enable
#define CAN0_IER_MB4    0x00000010 // Mailbox 4 Interrupt Enable
#define CAN0_IER_MB5    0x00000020 // Mailbox 5 Interrupt Enable
#define CAN0_IER_MB6    0x00000040 // Mailbox 6 Interrupt Enable
#define CAN0_IER_MB7    0x00000080 // Mailbox 7 Interrupt Enable
#define CAN0_IER_ERRA   0x00010000 // Error Active Mode Interrupt Enable
#define CAN0_IER_WARN   0x00020000 // Warning Limit Interrupt Enable
#define CAN0_IER_ERRP   0x00040000 // Error Passive Mode Interrupt Enable
#define CAN0_IER_BOFF   0x00080000 // Bus Off Mode Interrupt Enable
#define CAN0_IER_SLEEP  0x00100000 // Sleep Interrupt Enable
#define CAN0_IER_WAKEUP 0x00200000 // Wakeup Interrupt Enable
#define CAN0_IER_TOVF   0x00400000 // Timer Overflow Interrupt Enable
#define CAN0_IER_TSTP   0x00800000 // TimeStamp Interrupt Enable
#define CAN0_IER_CERR   0x01000000 // CRC Error Interrupt Enable
#define CAN0_IER_SERR   0x02000000 // Stuffing Error Interrupt Enable
#define CAN0_IER_AERR   0x04000000 // Acknowledgment Error Interrupt Enable
#define CAN0_IER_FERR   0x08000000 // Form Error Interrupt Enable
#define CAN0_IER_BERR   0x10000000 // Bit Error Interrupt Enable

#define CAN0_IDR_MB0    0x00000001 // Mailbox 0 Interrupt Disable
#define CAN0_IDR_MB1    0x00000002 // Mailbox 1 Interrupt Disable
#define CAN0_IDR_MB2    0x00000004 // Mailbox 2 Interrupt Disable
#define CAN0_IDR_MB3    0x00000008 // Mailbox 3 Interrupt Disable
#define CAN0_IDR_MB4    0x00000010 // Mailbox 4 Interrupt Disable
#define CAN0_IDR_MB5    0x00000020 // Mailbox 5 Interrupt Disable
#define CAN0_IDR_MB6    0x00000040 // Mailbox 6 Interrupt Disable
#define CAN0_IDR_MB7    0x00000080 // Mailbox 7 Interrupt Disable
#define CAN0_IDR_ERRA   0x00010000 // Error Active Mode Interrupt Disable
#define CAN0_IDR_WARN   0x00020000 // Warning Limit Interrupt Disable
#define CAN0_IDR_ERRP   0x00040000 // Error Passive Mode Interrupt Disable
#define CAN0_IDR_BOFF   0x00080000 // Bus Off Mode Interrupt Disable
#define CAN0_IDR_SLEEP  0x00100000 // Sleep Interrupt Disable
#define CAN0_IDR_WAKEUP 0x00200000 // Wakeup Interrupt Disable
#define CAN0_IDR_TOVF   0x00400000 // Timer Overflow Interrupt
#define CAN0_IDR_TSTP   0x00800000 // TimeStamp Interrupt Disable
#define CAN0_IDR_CERR   0x01000000 // CRC Error Interrupt Disable
#define CAN0_IDR_SERR   0x02000000 // Stuffing Error Interrupt Disable
#define CAN0_IDR_AERR   0x04000000 // Acknowledgment Error Interrupt Disable
#define CAN0_IDR_FERR   0x08000000 // Form Error Interrupt Disable
#define CAN0_IDR_BERR   0x10000000 // Bit Error Interrupt Disable

#define CAN0_IMR_MB0    0x00000001 // Mailbox 0 Interrupt Mask
#define CAN0_IMR_MB1    0x00000002 // Mailbox 1 Interrupt Mask
#define CAN0_IMR_MB2    0x00000004 // Mailbox 2 Interrupt Mask
#define CAN0_IMR_MB3    0x00000008 // Mailbox 3 Interrupt Mask
#define CAN0_IMR_MB4    0x00000010 // Mailbox 4 Interrupt Mask
#define CAN0_IMR_MB5    0x00000020 // Mailbox 5 Interrupt Mask
#define CAN0_IMR_MB6    0x00000040 // Mailbox 6 Interrupt Mask
#define CAN0_IMR_MB7    0x00000080 // Mailbox 7 Interrupt Mask
#define CAN0_IMR_ERRA   0x00010000 // Error Active Mode Interrupt Mask
#define CAN0_IMR_WARN   0x00020000 // Warning Limit Interrupt Mask
#define CAN0_IMR_ERRP   0x00040000 // Error Passive Mode Interrupt Mask
#define CAN0_IMR_BOFF   0x00080000 // Bus Off Mode Interrupt Mask
#define CAN0_IMR_SLEEP  0x00100000 // Sleep Interrupt Mask
#define CAN0_IMR_WAKEUP 0x00200000 // Wakeup Interrupt Mask
#define CAN0_IMR_TOVF   0x00400000 // Timer Overflow Interrupt Mask
#define CAN0_IMR_TSTP   0x00800000 // Timestamp Interrupt Mask
#define CAN0_IMR_CERR   0x01000000 // CRC Error Interrupt Mask
#define CAN0_IMR_SERR   0x02000000 // Stuffing Error Interrupt Mask
#define CAN0_IMR_AERR   0x04000000 // Acknowledgment Error Interrupt Mask
#define CAN0_IMR_FERR   0x08000000 // Form Error Interrupt Mask
#define CAN0_IMR_BERR   0x10000000 // Bit Error Interrupt Mask

#define CAN0_SR_MB0    0x00000001 // Mailbox 0 Event
#define CAN0_SR_MB1    0x00000002 // Mailbox 1 Event
#define CAN0_SR_MB2    0x00000004 // Mailbox 2 Event
#define CAN0_SR_MB3    0x00000008 // Mailbox 3 Event
#define CAN0_SR_MB4    0x00000010 // Mailbox 4 Event
#define CAN0_SR_MB5    0x00000020 // Mailbox 5 Event
#define CAN0_SR_MB6    0x00000040 // Mailbox 6 Event
#define CAN0_SR_MB7    0x00000080 // Mailbox 7 Event
#define CAN0_SR_ERRA   0x00010000 // Error Active Mode
#define CAN0_SR_WARN   0x00020000 // Warning Limit
#define CAN0_SR_ERRP   0x00040000 // Error Passive Mode
#define CAN0_SR_BOFF   0x00080000 // Bus Off Mode
#define CAN0_SR_SLEEP  0x00100000 // CAN controller in Low power Mode
#define CAN0_SR_WAKEUP 0x00200000 // CAN controller is not in Low power Mode
#define CAN0_SR_TOVF   0x00400000 // Timer Overflow
#define CAN0_SR_TSTP   0x00800000 //
#define CAN0_SR_CERR   0x01000000 // Mailbox CRC Error
#define CAN0_SR_SERR   0x02000000 // Mailbox Stuffing Error
#define CAN0_SR_AERR   0x04000000 // Acknowledgment Error
#define CAN0_SR_FERR   0x08000000 // Form Error
#define CAN0_SR_BERR   0x10000000 // Bit Error
#define CAN0_SR_RBSY   0x20000000 // Receiver busy
#define CAN0_SR_TBSY   0x40000000 // Transmitter busy
#define CAN0_SR_OVLSY  0x80000000 // Overload busy

#define CAN0_BR_PHASE2(value) (((value) & 0x7) << 0)   // Phase 2 segment
#define CAN0_BR_PHASE1(value) (((value) & 0x7) << 4)   // Phase 1 segment
#define CAN0_BR_PROPAG(value) (((value) & 0x7) << 8)   // Programming time segment
#define CAN0_BR_SJW(value)    (((value) & 0x3) << 12)  // Re-synchronization jump width
#define CAN0_BR_BRP(value)    (((value) & 0x7F) << 16) // Baudrate Prescaler
#define CAN0_BR_SMP_ONCE      0x00000000               // The incoming bit stream is sampled once at sample point
#define CAN0_BR_SMP_THREE     0x01000000               // The incoming bit stream is sampled three times with a period of a MCK clock period, centered on sample point

#define CAN0_TIM_TIMER(value) (((value) & 0xFFFF) << 0) // Timer

#define CAN0_TIMESTP_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timestamp

#define CAN0_ECR_REC(value) (((value) & 0xFF) << 0)  // Receive Error Counter
#define CAN0_ECR_TEC(value) (((value) & 0xFF) << 16) // Transmit Error Counter

#define CAN0_TCR_MB0    0x00000001 // Transfer Request for Mailbox 0
#define CAN0_TCR_MB1    0x00000002 // Transfer Request for Mailbox 1
#define CAN0_TCR_MB2    0x00000004 // Transfer Request for Mailbox 2
#define CAN0_TCR_MB3    0x00000008 // Transfer Request for Mailbox 3
#define CAN0_TCR_MB4    0x00000010 // Transfer Request for Mailbox 4
#define CAN0_TCR_MB5    0x00000020 // Transfer Request for Mailbox 5
#define CAN0_TCR_MB6    0x00000040 // Transfer Request for Mailbox 6
#define CAN0_TCR_MB7    0x00000080 // Transfer Request for Mailbox 7
#define CAN0_TCR_TIMRST 0x80000000 // Timer Reset

#define CAN0_ACR_MB0 0x00000001 // Abort Request for Mailbox 0
#define CAN0_ACR_MB1 0x00000002 // Abort Request for Mailbox 1
#define CAN0_ACR_MB2 0x00000004 // Abort Request for Mailbox 2
#define CAN0_ACR_MB3 0x00000008 // Abort Request for Mailbox 3
#define CAN0_ACR_MB4 0x00000010 // Abort Request for Mailbox 4
#define CAN0_ACR_MB5 0x00000020 // Abort Request for Mailbox 5
#define CAN0_ACR_MB6 0x00000040 // Abort Request for Mailbox 6
#define CAN0_ACR_MB7 0x00000080 // Abort Request for Mailbox 7

#define CAN0_WPMR_WPEN         0x00000001                  // Write Protection Enable
#define CAN0_WPMR_WPKEY(value) (((value) & 0xFFFFFF) << 8) // SPI Write Protection Key Password

#define CAN0_WPSR_WPVS          0x00000001              // Write Protection Violation Status
#define CAN0_WPSR_WPVSRC(value) (((value) & 0xFF) << 8) // Write Protection Violation Source

#define CAN0_MMR0_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN0_MMR0_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN0_MMR0_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN0_MMR0_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN0_MMR0_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN0_MMR0_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN0_MMR0_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN0_MMR0_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN0_MAM0_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MAM0_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MAM0_MIDE         0x20000000                 // Identifier Version

#define CAN0_MID0_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MID0_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MID0_MIDE         0x20000000                 // Identifier Version

#define CAN0_MFID0_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN0_MSR0_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN0_MSR0_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN0_MSR0_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN0_MSR0_MABT              0x00400000                // Mailbox Message Abort
#define CAN0_MSR0_MRDY              0x00800000                // Mailbox Ready
#define CAN0_MSR0_MMI               0x01000000                // Mailbox Message Ignored

#define CAN0_MDL0_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN0_MDH0_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN0_MCR0_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN0_MCR0_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN0_MCR0_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN0_MCR0_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN0_MMR1_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN0_MMR1_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN0_MMR1_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN0_MMR1_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN0_MMR1_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN0_MMR1_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN0_MMR1_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN0_MMR1_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN0_MAM1_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MAM1_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MAM1_MIDE         0x20000000                 // Identifier Version

#define CAN0_MID1_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MID1_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MID1_MIDE         0x20000000                 // Identifier Version

#define CAN0_MFID1_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN0_MSR1_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN0_MSR1_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN0_MSR1_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN0_MSR1_MABT              0x00400000                // Mailbox Message Abort
#define CAN0_MSR1_MRDY              0x00800000                // Mailbox Ready
#define CAN0_MSR1_MMI               0x01000000                // Mailbox Message Ignored

#define CAN0_MDL1_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN0_MDH1_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN0_MCR1_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN0_MCR1_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN0_MCR1_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN0_MCR1_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN0_MMR2_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN0_MMR2_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN0_MMR2_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN0_MMR2_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN0_MMR2_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN0_MMR2_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN0_MMR2_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN0_MMR2_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN0_MAM2_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MAM2_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MAM2_MIDE         0x20000000                 // Identifier Version

#define CAN0_MID2_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MID2_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MID2_MIDE         0x20000000                 // Identifier Version

#define CAN0_MFID2_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN0_MSR2_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN0_MSR2_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN0_MSR2_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN0_MSR2_MABT              0x00400000                // Mailbox Message Abort
#define CAN0_MSR2_MRDY              0x00800000                // Mailbox Ready
#define CAN0_MSR2_MMI               0x01000000                // Mailbox Message Ignored

#define CAN0_MDL2_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN0_MDH2_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN0_MCR2_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN0_MCR2_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN0_MCR2_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN0_MCR2_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN0_MMR3_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN0_MMR3_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN0_MMR3_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN0_MMR3_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN0_MMR3_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN0_MMR3_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN0_MMR3_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN0_MMR3_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN0_MAM3_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MAM3_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MAM3_MIDE         0x20000000                 // Identifier Version

#define CAN0_MID3_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MID3_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MID3_MIDE         0x20000000                 // Identifier Version

#define CAN0_MFID3_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN0_MSR3_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN0_MSR3_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN0_MSR3_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN0_MSR3_MABT              0x00400000                // Mailbox Message Abort
#define CAN0_MSR3_MRDY              0x00800000                // Mailbox Ready
#define CAN0_MSR3_MMI               0x01000000                // Mailbox Message Ignored

#define CAN0_MDL3_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN0_MDH3_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN0_MCR3_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN0_MCR3_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN0_MCR3_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN0_MCR3_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN0_MMR4_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN0_MMR4_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN0_MMR4_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN0_MMR4_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN0_MMR4_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN0_MMR4_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN0_MMR4_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN0_MMR4_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN0_MAM4_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MAM4_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MAM4_MIDE         0x20000000                 // Identifier Version

#define CAN0_MID4_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MID4_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MID4_MIDE         0x20000000                 // Identifier Version

#define CAN0_MFID4_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN0_MSR4_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN0_MSR4_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN0_MSR4_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN0_MSR4_MABT              0x00400000                // Mailbox Message Abort
#define CAN0_MSR4_MRDY              0x00800000                // Mailbox Ready
#define CAN0_MSR4_MMI               0x01000000                // Mailbox Message Ignored

#define CAN0_MDL4_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN0_MDH4_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN0_MCR4_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN0_MCR4_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN0_MCR4_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN0_MCR4_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN0_MMR5_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN0_MMR5_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN0_MMR5_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN0_MMR5_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN0_MMR5_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN0_MMR5_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN0_MMR5_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN0_MMR5_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN0_MAM5_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MAM5_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MAM5_MIDE         0x20000000                 // Identifier Version

#define CAN0_MID5_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MID5_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MID5_MIDE         0x20000000                 // Identifier Version

#define CAN0_MFID5_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN0_MSR5_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN0_MSR5_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN0_MSR5_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN0_MSR5_MABT              0x00400000                // Mailbox Message Abort
#define CAN0_MSR5_MRDY              0x00800000                // Mailbox Ready
#define CAN0_MSR5_MMI               0x01000000                // Mailbox Message Ignored

#define CAN0_MDL5_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN0_MDH5_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN0_MCR5_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN0_MCR5_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN0_MCR5_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN0_MCR5_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN0_MMR6_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN0_MMR6_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN0_MMR6_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN0_MMR6_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN0_MMR6_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN0_MMR6_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN0_MMR6_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN0_MMR6_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN0_MAM6_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MAM6_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MAM6_MIDE         0x20000000                 // Identifier Version

#define CAN0_MID6_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MID6_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MID6_MIDE         0x20000000                 // Identifier Version

#define CAN0_MFID6_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN0_MSR6_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN0_MSR6_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN0_MSR6_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN0_MSR6_MABT              0x00400000                // Mailbox Message Abort
#define CAN0_MSR6_MRDY              0x00800000                // Mailbox Ready
#define CAN0_MSR6_MMI               0x01000000                // Mailbox Message Ignored

#define CAN0_MDL6_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN0_MDH6_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN0_MCR6_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN0_MCR6_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN0_MCR6_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN0_MCR6_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN0_MMR7_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN0_MMR7_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN0_MMR7_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN0_MMR7_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN0_MMR7_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN0_MMR7_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN0_MMR7_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN0_MMR7_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN0_MAM7_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MAM7_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MAM7_MIDE         0x20000000                 // Identifier Version

#define CAN0_MID7_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN0_MID7_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN0_MID7_MIDE         0x20000000                 // Identifier Version

#define CAN0_MFID7_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN0_MSR7_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN0_MSR7_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN0_MSR7_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN0_MSR7_MABT              0x00400000                // Mailbox Message Abort
#define CAN0_MSR7_MRDY              0x00800000                // Mailbox Ready
#define CAN0_MSR7_MMI               0x01000000                // Mailbox Message Ignored

#define CAN0_MDL7_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN0_MDH7_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN0_MCR7_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN0_MCR7_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN0_MCR7_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN0_MCR7_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN1_MR      (*(volatile unsigned int *)0x400B8000)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1203895)
#define CAN1_IER     (*(volatile unsigned int *)0x400B8004)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1204127)
#define CAN1_IDR     (*(volatile unsigned int *)0x400B8008)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1204398)
#define CAN1_IMR     (*(const volatile unsigned int *)0x400B800C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1204669)
#define CAN1_SR      (*(const volatile unsigned int *)0x400B8010) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1204941)
#define CAN1_BR      (*(volatile unsigned int *)0x400B8014)       // [Baudrate Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1205284)
#define CAN1_TIM     (*(const volatile unsigned int *)0x400B8018) // [Timer Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1205507)
#define CAN1_TIMESTP (*(const volatile unsigned int *)0x400B801C) // [Timestamp Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1205742)
#define CAN1_ECR     (*(const volatile unsigned int *)0x400B8020) // [Error Counter Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1205978)
#define CAN1_TCR     (*(volatile unsigned int *)0x400B8024)       // [Transfer Command Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206172)
#define CAN1_ACR     (*(volatile unsigned int *)0x400B8028)       // [Abort Command Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206432)
#define CAN1_WPMR    (*(volatile unsigned int *)0x400B80E4)       // [Write Protect Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1257255)
#define CAN1_WPSR    (*(const volatile unsigned int *)0x400B80E8) // [Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1257228)
#define CAN1_MMR0    (*(volatile unsigned int *)0x400B8200)       // [Mailbox Mode Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN1_MAM0    (*(volatile unsigned int *)0x400B8204)       // [Mailbox Acceptance Mask Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN1_MID0    (*(volatile unsigned int *)0x400B8208)       // [Mailbox ID Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN1_MFID0   (*(const volatile unsigned int *)0x400B820C) // [Mailbox Family ID Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN1_MSR0    (*(const volatile unsigned int *)0x400B8210) // [Mailbox Status Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN1_MDL0    (*(volatile unsigned int *)0x400B8214)       // [Mailbox Data Low Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN1_MDH0    (*(volatile unsigned int *)0x400B8218)       // [Mailbox Data High Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN1_MCR0    (*(volatile unsigned int *)0x400B821C)       // [Mailbox Control Register (MB = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN1_MMR1    (*(volatile unsigned int *)0x400B8220)       // [Mailbox Mode Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN1_MAM1    (*(volatile unsigned int *)0x400B8224)       // [Mailbox Acceptance Mask Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN1_MID1    (*(volatile unsigned int *)0x400B8228)       // [Mailbox ID Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN1_MFID1   (*(const volatile unsigned int *)0x400B822C) // [Mailbox Family ID Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN1_MSR1    (*(const volatile unsigned int *)0x400B8230) // [Mailbox Status Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN1_MDL1    (*(volatile unsigned int *)0x400B8234)       // [Mailbox Data Low Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN1_MDH1    (*(volatile unsigned int *)0x400B8238)       // [Mailbox Data High Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN1_MCR1    (*(volatile unsigned int *)0x400B823C)       // [Mailbox Control Register (MB = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN1_MMR2    (*(volatile unsigned int *)0x400B8240)       // [Mailbox Mode Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN1_MAM2    (*(volatile unsigned int *)0x400B8244)       // [Mailbox Acceptance Mask Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN1_MID2    (*(volatile unsigned int *)0x400B8248)       // [Mailbox ID Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN1_MFID2   (*(const volatile unsigned int *)0x400B824C) // [Mailbox Family ID Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN1_MSR2    (*(const volatile unsigned int *)0x400B8250) // [Mailbox Status Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN1_MDL2    (*(volatile unsigned int *)0x400B8254)       // [Mailbox Data Low Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN1_MDH2    (*(volatile unsigned int *)0x400B8258)       // [Mailbox Data High Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN1_MCR2    (*(volatile unsigned int *)0x400B825C)       // [Mailbox Control Register (MB = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN1_MMR3    (*(volatile unsigned int *)0x400B8260)       // [Mailbox Mode Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN1_MAM3    (*(volatile unsigned int *)0x400B8264)       // [Mailbox Acceptance Mask Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN1_MID3    (*(volatile unsigned int *)0x400B8268)       // [Mailbox ID Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN1_MFID3   (*(const volatile unsigned int *)0x400B826C) // [Mailbox Family ID Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN1_MSR3    (*(const volatile unsigned int *)0x400B8270) // [Mailbox Status Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN1_MDL3    (*(volatile unsigned int *)0x400B8274)       // [Mailbox Data Low Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN1_MDH3    (*(volatile unsigned int *)0x400B8278)       // [Mailbox Data High Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN1_MCR3    (*(volatile unsigned int *)0x400B827C)       // [Mailbox Control Register (MB = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN1_MMR4    (*(volatile unsigned int *)0x400B8280)       // [Mailbox Mode Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN1_MAM4    (*(volatile unsigned int *)0x400B8284)       // [Mailbox Acceptance Mask Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN1_MID4    (*(volatile unsigned int *)0x400B8288)       // [Mailbox ID Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN1_MFID4   (*(const volatile unsigned int *)0x400B828C) // [Mailbox Family ID Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN1_MSR4    (*(const volatile unsigned int *)0x400B8290) // [Mailbox Status Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN1_MDL4    (*(volatile unsigned int *)0x400B8294)       // [Mailbox Data Low Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN1_MDH4    (*(volatile unsigned int *)0x400B8298)       // [Mailbox Data High Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN1_MCR4    (*(volatile unsigned int *)0x400B829C)       // [Mailbox Control Register (MB = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN1_MMR5    (*(volatile unsigned int *)0x400B82A0)       // [Mailbox Mode Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN1_MAM5    (*(volatile unsigned int *)0x400B82A4)       // [Mailbox Acceptance Mask Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN1_MID5    (*(volatile unsigned int *)0x400B82A8)       // [Mailbox ID Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN1_MFID5   (*(const volatile unsigned int *)0x400B82AC) // [Mailbox Family ID Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN1_MSR5    (*(const volatile unsigned int *)0x400B82B0) // [Mailbox Status Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN1_MDL5    (*(volatile unsigned int *)0x400B82B4)       // [Mailbox Data Low Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN1_MDH5    (*(volatile unsigned int *)0x400B82B8)       // [Mailbox Data High Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN1_MCR5    (*(volatile unsigned int *)0x400B82BC)       // [Mailbox Control Register (MB = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN1_MMR6    (*(volatile unsigned int *)0x400B82C0)       // [Mailbox Mode Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN1_MAM6    (*(volatile unsigned int *)0x400B82C4)       // [Mailbox Acceptance Mask Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN1_MID6    (*(volatile unsigned int *)0x400B82C8)       // [Mailbox ID Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN1_MFID6   (*(const volatile unsigned int *)0x400B82CC) // [Mailbox Family ID Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN1_MSR6    (*(const volatile unsigned int *)0x400B82D0) // [Mailbox Status Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN1_MDL6    (*(volatile unsigned int *)0x400B82D4)       // [Mailbox Data Low Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN1_MDH6    (*(volatile unsigned int *)0x400B82D8)       // [Mailbox Data High Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN1_MCR6    (*(volatile unsigned int *)0x400B82DC)       // [Mailbox Control Register (MB = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)
#define CAN1_MMR7    (*(volatile unsigned int *)0x400B82E0)       // [Mailbox Mode Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1206875)
#define CAN1_MAM7    (*(volatile unsigned int *)0x400B82E4)       // [Mailbox Acceptance Mask Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207182)
#define CAN1_MID7    (*(volatile unsigned int *)0x400B82E8)       // [Mailbox ID Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207374)
#define CAN1_MFID7   (*(const volatile unsigned int *)0x400B82EC) // [Mailbox Family ID Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207564)
#define CAN1_MSR7    (*(const volatile unsigned int *)0x400B82F0) // [Mailbox Status Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1207755)
#define CAN1_MDL7    (*(volatile unsigned int *)0x400B82F4)       // [Mailbox Data Low Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208143)
#define CAN1_MDH7    (*(volatile unsigned int *)0x400B82F8)       // [Mailbox Data High Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208340)
#define CAN1_MCR7    (*(volatile unsigned int *)0x400B82FC)       // [Mailbox Control Register (MB = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G31.1208537)

#define CAN1_MR_CANEN            0x00000001 // CAN Controller Enable
#define CAN1_MR_LPM              0x00000002 // Disable/Enable Low Power Mode
#define CAN1_MR_ABM              0x00000004 // Disable/Enable Autobaud/Listen mode
#define CAN1_MR_OVL              0x00000008 // Disable/Enable Overload Frame
#define CAN1_MR_TEOF             0x00000010 // Timestamp messages at each end of Frame
#define CAN1_MR_TTM              0x00000020 // Disable/Enable Time Triggered Mode
#define CAN1_MR_TIMFRZ           0x00000040 // Enable Timer Freeze
#define CAN1_MR_DRPT             0x00000080 // Disable Repeat
#define CAN1_MR_RXSYNC_DOUBLE_PP 0x00000000 // Rx Signal with Double Synchro Stages (2 Positive Edges)
#define CAN1_MR_RXSYNC_DOUBLE_PN 0x01000000 // Rx Signal with Double Synchro Stages (One Positive Edge and One Negative Edge)
#define CAN1_MR_RXSYNC_SINGLE_P  0x02000000 // Rx Signal with Single Synchro Stage (Positive Edge)
#define CAN1_MR_RXSYNC_NONE      0x03000000 // Rx Signal with No Synchro Stage

#define CAN1_IER_MB0    0x00000001 // Mailbox 0 Interrupt Enable
#define CAN1_IER_MB1    0x00000002 // Mailbox 1 Interrupt Enable
#define CAN1_IER_MB2    0x00000004 // Mailbox 2 Interrupt Enable
#define CAN1_IER_MB3    0x00000008 // Mailbox 3 Interrupt Enable
#define CAN1_IER_MB4    0x00000010 // Mailbox 4 Interrupt Enable
#define CAN1_IER_MB5    0x00000020 // Mailbox 5 Interrupt Enable
#define CAN1_IER_MB6    0x00000040 // Mailbox 6 Interrupt Enable
#define CAN1_IER_MB7    0x00000080 // Mailbox 7 Interrupt Enable
#define CAN1_IER_ERRA   0x00010000 // Error Active Mode Interrupt Enable
#define CAN1_IER_WARN   0x00020000 // Warning Limit Interrupt Enable
#define CAN1_IER_ERRP   0x00040000 // Error Passive Mode Interrupt Enable
#define CAN1_IER_BOFF   0x00080000 // Bus Off Mode Interrupt Enable
#define CAN1_IER_SLEEP  0x00100000 // Sleep Interrupt Enable
#define CAN1_IER_WAKEUP 0x00200000 // Wakeup Interrupt Enable
#define CAN1_IER_TOVF   0x00400000 // Timer Overflow Interrupt Enable
#define CAN1_IER_TSTP   0x00800000 // TimeStamp Interrupt Enable
#define CAN1_IER_CERR   0x01000000 // CRC Error Interrupt Enable
#define CAN1_IER_SERR   0x02000000 // Stuffing Error Interrupt Enable
#define CAN1_IER_AERR   0x04000000 // Acknowledgment Error Interrupt Enable
#define CAN1_IER_FERR   0x08000000 // Form Error Interrupt Enable
#define CAN1_IER_BERR   0x10000000 // Bit Error Interrupt Enable

#define CAN1_IDR_MB0    0x00000001 // Mailbox 0 Interrupt Disable
#define CAN1_IDR_MB1    0x00000002 // Mailbox 1 Interrupt Disable
#define CAN1_IDR_MB2    0x00000004 // Mailbox 2 Interrupt Disable
#define CAN1_IDR_MB3    0x00000008 // Mailbox 3 Interrupt Disable
#define CAN1_IDR_MB4    0x00000010 // Mailbox 4 Interrupt Disable
#define CAN1_IDR_MB5    0x00000020 // Mailbox 5 Interrupt Disable
#define CAN1_IDR_MB6    0x00000040 // Mailbox 6 Interrupt Disable
#define CAN1_IDR_MB7    0x00000080 // Mailbox 7 Interrupt Disable
#define CAN1_IDR_ERRA   0x00010000 // Error Active Mode Interrupt Disable
#define CAN1_IDR_WARN   0x00020000 // Warning Limit Interrupt Disable
#define CAN1_IDR_ERRP   0x00040000 // Error Passive Mode Interrupt Disable
#define CAN1_IDR_BOFF   0x00080000 // Bus Off Mode Interrupt Disable
#define CAN1_IDR_SLEEP  0x00100000 // Sleep Interrupt Disable
#define CAN1_IDR_WAKEUP 0x00200000 // Wakeup Interrupt Disable
#define CAN1_IDR_TOVF   0x00400000 // Timer Overflow Interrupt
#define CAN1_IDR_TSTP   0x00800000 // TimeStamp Interrupt Disable
#define CAN1_IDR_CERR   0x01000000 // CRC Error Interrupt Disable
#define CAN1_IDR_SERR   0x02000000 // Stuffing Error Interrupt Disable
#define CAN1_IDR_AERR   0x04000000 // Acknowledgment Error Interrupt Disable
#define CAN1_IDR_FERR   0x08000000 // Form Error Interrupt Disable
#define CAN1_IDR_BERR   0x10000000 // Bit Error Interrupt Disable

#define CAN1_IMR_MB0    0x00000001 // Mailbox 0 Interrupt Mask
#define CAN1_IMR_MB1    0x00000002 // Mailbox 1 Interrupt Mask
#define CAN1_IMR_MB2    0x00000004 // Mailbox 2 Interrupt Mask
#define CAN1_IMR_MB3    0x00000008 // Mailbox 3 Interrupt Mask
#define CAN1_IMR_MB4    0x00000010 // Mailbox 4 Interrupt Mask
#define CAN1_IMR_MB5    0x00000020 // Mailbox 5 Interrupt Mask
#define CAN1_IMR_MB6    0x00000040 // Mailbox 6 Interrupt Mask
#define CAN1_IMR_MB7    0x00000080 // Mailbox 7 Interrupt Mask
#define CAN1_IMR_ERRA   0x00010000 // Error Active Mode Interrupt Mask
#define CAN1_IMR_WARN   0x00020000 // Warning Limit Interrupt Mask
#define CAN1_IMR_ERRP   0x00040000 // Error Passive Mode Interrupt Mask
#define CAN1_IMR_BOFF   0x00080000 // Bus Off Mode Interrupt Mask
#define CAN1_IMR_SLEEP  0x00100000 // Sleep Interrupt Mask
#define CAN1_IMR_WAKEUP 0x00200000 // Wakeup Interrupt Mask
#define CAN1_IMR_TOVF   0x00400000 // Timer Overflow Interrupt Mask
#define CAN1_IMR_TSTP   0x00800000 // Timestamp Interrupt Mask
#define CAN1_IMR_CERR   0x01000000 // CRC Error Interrupt Mask
#define CAN1_IMR_SERR   0x02000000 // Stuffing Error Interrupt Mask
#define CAN1_IMR_AERR   0x04000000 // Acknowledgment Error Interrupt Mask
#define CAN1_IMR_FERR   0x08000000 // Form Error Interrupt Mask
#define CAN1_IMR_BERR   0x10000000 // Bit Error Interrupt Mask

#define CAN1_SR_MB0    0x00000001 // Mailbox 0 Event
#define CAN1_SR_MB1    0x00000002 // Mailbox 1 Event
#define CAN1_SR_MB2    0x00000004 // Mailbox 2 Event
#define CAN1_SR_MB3    0x00000008 // Mailbox 3 Event
#define CAN1_SR_MB4    0x00000010 // Mailbox 4 Event
#define CAN1_SR_MB5    0x00000020 // Mailbox 5 Event
#define CAN1_SR_MB6    0x00000040 // Mailbox 6 Event
#define CAN1_SR_MB7    0x00000080 // Mailbox 7 Event
#define CAN1_SR_ERRA   0x00010000 // Error Active Mode
#define CAN1_SR_WARN   0x00020000 // Warning Limit
#define CAN1_SR_ERRP   0x00040000 // Error Passive Mode
#define CAN1_SR_BOFF   0x00080000 // Bus Off Mode
#define CAN1_SR_SLEEP  0x00100000 // CAN controller in Low power Mode
#define CAN1_SR_WAKEUP 0x00200000 // CAN controller is not in Low power Mode
#define CAN1_SR_TOVF   0x00400000 // Timer Overflow
#define CAN1_SR_TSTP   0x00800000 //
#define CAN1_SR_CERR   0x01000000 // Mailbox CRC Error
#define CAN1_SR_SERR   0x02000000 // Mailbox Stuffing Error
#define CAN1_SR_AERR   0x04000000 // Acknowledgment Error
#define CAN1_SR_FERR   0x08000000 // Form Error
#define CAN1_SR_BERR   0x10000000 // Bit Error
#define CAN1_SR_RBSY   0x20000000 // Receiver busy
#define CAN1_SR_TBSY   0x40000000 // Transmitter busy
#define CAN1_SR_OVLSY  0x80000000 // Overload busy

#define CAN1_BR_PHASE2(value) (((value) & 0x7) << 0)   // Phase 2 segment
#define CAN1_BR_PHASE1(value) (((value) & 0x7) << 4)   // Phase 1 segment
#define CAN1_BR_PROPAG(value) (((value) & 0x7) << 8)   // Programming time segment
#define CAN1_BR_SJW(value)    (((value) & 0x3) << 12)  // Re-synchronization jump width
#define CAN1_BR_BRP(value)    (((value) & 0x7F) << 16) // Baudrate Prescaler
#define CAN1_BR_SMP_ONCE      0x00000000               // The incoming bit stream is sampled once at sample point
#define CAN1_BR_SMP_THREE     0x01000000               // The incoming bit stream is sampled three times with a period of a MCK clock period, centered on sample point

#define CAN1_TIM_TIMER(value) (((value) & 0xFFFF) << 0) // Timer

#define CAN1_TIMESTP_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timestamp

#define CAN1_ECR_REC(value) (((value) & 0xFF) << 0)  // Receive Error Counter
#define CAN1_ECR_TEC(value) (((value) & 0xFF) << 16) // Transmit Error Counter

#define CAN1_TCR_MB0    0x00000001 // Transfer Request for Mailbox 0
#define CAN1_TCR_MB1    0x00000002 // Transfer Request for Mailbox 1
#define CAN1_TCR_MB2    0x00000004 // Transfer Request for Mailbox 2
#define CAN1_TCR_MB3    0x00000008 // Transfer Request for Mailbox 3
#define CAN1_TCR_MB4    0x00000010 // Transfer Request for Mailbox 4
#define CAN1_TCR_MB5    0x00000020 // Transfer Request for Mailbox 5
#define CAN1_TCR_MB6    0x00000040 // Transfer Request for Mailbox 6
#define CAN1_TCR_MB7    0x00000080 // Transfer Request for Mailbox 7
#define CAN1_TCR_TIMRST 0x80000000 // Timer Reset

#define CAN1_ACR_MB0 0x00000001 // Abort Request for Mailbox 0
#define CAN1_ACR_MB1 0x00000002 // Abort Request for Mailbox 1
#define CAN1_ACR_MB2 0x00000004 // Abort Request for Mailbox 2
#define CAN1_ACR_MB3 0x00000008 // Abort Request for Mailbox 3
#define CAN1_ACR_MB4 0x00000010 // Abort Request for Mailbox 4
#define CAN1_ACR_MB5 0x00000020 // Abort Request for Mailbox 5
#define CAN1_ACR_MB6 0x00000040 // Abort Request for Mailbox 6
#define CAN1_ACR_MB7 0x00000080 // Abort Request for Mailbox 7

#define CAN1_WPMR_WPEN         0x00000001                  // Write Protection Enable
#define CAN1_WPMR_WPKEY(value) (((value) & 0xFFFFFF) << 8) // SPI Write Protection Key Password

#define CAN1_WPSR_WPVS          0x00000001              // Write Protection Violation Status
#define CAN1_WPSR_WPVSRC(value) (((value) & 0xFF) << 8) // Write Protection Violation Source

#define CAN1_MMR0_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN1_MMR0_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN1_MMR0_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN1_MMR0_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN1_MMR0_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN1_MMR0_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN1_MMR0_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN1_MMR0_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN1_MAM0_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MAM0_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MAM0_MIDE         0x20000000                 // Identifier Version

#define CAN1_MID0_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MID0_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MID0_MIDE         0x20000000                 // Identifier Version

#define CAN1_MFID0_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN1_MSR0_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN1_MSR0_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN1_MSR0_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN1_MSR0_MABT              0x00400000                // Mailbox Message Abort
#define CAN1_MSR0_MRDY              0x00800000                // Mailbox Ready
#define CAN1_MSR0_MMI               0x01000000                // Mailbox Message Ignored

#define CAN1_MDL0_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN1_MDH0_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN1_MCR0_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN1_MCR0_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN1_MCR0_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN1_MCR0_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN1_MMR1_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN1_MMR1_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN1_MMR1_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN1_MMR1_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN1_MMR1_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN1_MMR1_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN1_MMR1_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN1_MMR1_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN1_MAM1_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MAM1_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MAM1_MIDE         0x20000000                 // Identifier Version

#define CAN1_MID1_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MID1_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MID1_MIDE         0x20000000                 // Identifier Version

#define CAN1_MFID1_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN1_MSR1_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN1_MSR1_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN1_MSR1_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN1_MSR1_MABT              0x00400000                // Mailbox Message Abort
#define CAN1_MSR1_MRDY              0x00800000                // Mailbox Ready
#define CAN1_MSR1_MMI               0x01000000                // Mailbox Message Ignored

#define CAN1_MDL1_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN1_MDH1_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN1_MCR1_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN1_MCR1_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN1_MCR1_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN1_MCR1_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN1_MMR2_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN1_MMR2_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN1_MMR2_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN1_MMR2_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN1_MMR2_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN1_MMR2_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN1_MMR2_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN1_MMR2_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN1_MAM2_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MAM2_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MAM2_MIDE         0x20000000                 // Identifier Version

#define CAN1_MID2_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MID2_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MID2_MIDE         0x20000000                 // Identifier Version

#define CAN1_MFID2_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN1_MSR2_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN1_MSR2_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN1_MSR2_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN1_MSR2_MABT              0x00400000                // Mailbox Message Abort
#define CAN1_MSR2_MRDY              0x00800000                // Mailbox Ready
#define CAN1_MSR2_MMI               0x01000000                // Mailbox Message Ignored

#define CAN1_MDL2_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN1_MDH2_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN1_MCR2_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN1_MCR2_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN1_MCR2_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN1_MCR2_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN1_MMR3_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN1_MMR3_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN1_MMR3_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN1_MMR3_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN1_MMR3_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN1_MMR3_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN1_MMR3_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN1_MMR3_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN1_MAM3_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MAM3_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MAM3_MIDE         0x20000000                 // Identifier Version

#define CAN1_MID3_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MID3_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MID3_MIDE         0x20000000                 // Identifier Version

#define CAN1_MFID3_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN1_MSR3_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN1_MSR3_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN1_MSR3_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN1_MSR3_MABT              0x00400000                // Mailbox Message Abort
#define CAN1_MSR3_MRDY              0x00800000                // Mailbox Ready
#define CAN1_MSR3_MMI               0x01000000                // Mailbox Message Ignored

#define CAN1_MDL3_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN1_MDH3_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN1_MCR3_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN1_MCR3_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN1_MCR3_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN1_MCR3_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN1_MMR4_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN1_MMR4_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN1_MMR4_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN1_MMR4_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN1_MMR4_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN1_MMR4_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN1_MMR4_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN1_MMR4_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN1_MAM4_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MAM4_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MAM4_MIDE         0x20000000                 // Identifier Version

#define CAN1_MID4_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MID4_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MID4_MIDE         0x20000000                 // Identifier Version

#define CAN1_MFID4_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN1_MSR4_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN1_MSR4_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN1_MSR4_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN1_MSR4_MABT              0x00400000                // Mailbox Message Abort
#define CAN1_MSR4_MRDY              0x00800000                // Mailbox Ready
#define CAN1_MSR4_MMI               0x01000000                // Mailbox Message Ignored

#define CAN1_MDL4_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN1_MDH4_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN1_MCR4_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN1_MCR4_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN1_MCR4_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN1_MCR4_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN1_MMR5_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN1_MMR5_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN1_MMR5_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN1_MMR5_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN1_MMR5_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN1_MMR5_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN1_MMR5_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN1_MMR5_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN1_MAM5_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MAM5_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MAM5_MIDE         0x20000000                 // Identifier Version

#define CAN1_MID5_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MID5_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MID5_MIDE         0x20000000                 // Identifier Version

#define CAN1_MFID5_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN1_MSR5_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN1_MSR5_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN1_MSR5_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN1_MSR5_MABT              0x00400000                // Mailbox Message Abort
#define CAN1_MSR5_MRDY              0x00800000                // Mailbox Ready
#define CAN1_MSR5_MMI               0x01000000                // Mailbox Message Ignored

#define CAN1_MDL5_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN1_MDH5_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN1_MCR5_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN1_MCR5_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN1_MCR5_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN1_MCR5_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN1_MMR6_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN1_MMR6_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN1_MMR6_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN1_MMR6_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN1_MMR6_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN1_MMR6_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN1_MMR6_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN1_MMR6_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN1_MAM6_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MAM6_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MAM6_MIDE         0x20000000                 // Identifier Version

#define CAN1_MID6_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MID6_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MID6_MIDE         0x20000000                 // Identifier Version

#define CAN1_MFID6_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN1_MSR6_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN1_MSR6_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN1_MSR6_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN1_MSR6_MABT              0x00400000                // Mailbox Message Abort
#define CAN1_MSR6_MRDY              0x00800000                // Mailbox Ready
#define CAN1_MSR6_MMI               0x01000000                // Mailbox Message Ignored

#define CAN1_MDL6_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN1_MDH6_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN1_MCR6_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN1_MCR6_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN1_MCR6_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN1_MCR6_MTCR        0x00800000              // Mailbox Transfer Command

#define CAN1_MMR7_MTIMEMARK(value)    (((value) & 0xFFFF) << 0) // Mailbox Timemark
#define CAN1_MMR7_PRIOR(value)        (((value) & 0xF) << 16)   // Mailbox Priority
#define CAN1_MMR7_MOT_MB_DISABLED     0x00000000                // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox
#define CAN1_MMR7_MOT_MB_RX           0x01000000                // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded
#define CAN1_MMR7_MOT_MB_RX_OVERWRITE 0x02000000                // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message
#define CAN1_MMR7_MOT_MB_TX           0x03000000                // Transmit mailbox. Mailbox is configured for transmission
#define CAN1_MMR7_MOT_MB_CONSUMER     0x04000000                // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer
#define CAN1_MMR7_MOT_MB_PRODUCER     0x05000000                // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents

#define CAN1_MAM7_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MAM7_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MAM7_MIDE         0x20000000                 // Identifier Version

#define CAN1_MID7_MIDvB(value) (((value) & 0x3FFFF) << 0) // Complementary bits for identifier in extended frame mode
#define CAN1_MID7_MIDvA(value) (((value) & 0x7FF) << 18)  // Identifier for standard frame mode
#define CAN1_MID7_MIDE         0x20000000                 // Identifier Version

#define CAN1_MFID7_MFID(value) (((value) & 0x1FFFFFFF) << 0) // Family ID

#define CAN1_MSR7_MTIMESTAMP(value) (((value) & 0xFFFF) << 0) // Timer value
#define CAN1_MSR7_MDLC(value)       (((value) & 0xF) << 16)   // Mailbox Data Length Code
#define CAN1_MSR7_MRTR              0x00100000                // Mailbox Remote Transmission Request
#define CAN1_MSR7_MABT              0x00400000                // Mailbox Message Abort
#define CAN1_MSR7_MRDY              0x00800000                // Mailbox Ready
#define CAN1_MSR7_MMI               0x01000000                // Mailbox Message Ignored

#define CAN1_MDL7_MDL(value) (((value) & 0xFFFFFFFF) << 0) // Message Data Low Value

#define CAN1_MDH7_MDH(value) (((value) & 0xFFFFFFFF) << 0) // Message Data High Value

#define CAN1_MCR7_MDLC(value) (((value) & 0xF) << 16) // Mailbox Data Length Code
#define CAN1_MCR7_MRTR        0x00100000              // Mailbox Remote Transmission Request
#define CAN1_MCR7_MACR        0x00400000              // Abort Request for Mailbox x
#define CAN1_MCR7_MTCR        0x00800000              // Mailbox Transfer Command

#define TRNG_CR    (*(volatile unsigned int *)0x400BC000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G33.1047342)
#define TRNG_IER   (*(volatile unsigned int *)0x400BC010)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G33.1105585)
#define TRNG_IDR   (*(volatile unsigned int *)0x400BC014)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G33.1047656)
#define TRNG_IMR   (*(const volatile unsigned int *)0x400BC018) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G33.1112665)
#define TRNG_ISR   (*(const volatile unsigned int *)0x400BC01C) // [Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G33.1080283)
#define TRNG_ODATA (*(const volatile unsigned int *)0x400BC050) // [Output Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G33.1113277)

#define TRNG_CR_ENABLE     0x00000001                  // Enables the TRNG to provide random values
#define TRNG_CR_KEY(value) (((value) & 0xFFFFFF) << 8) // Security Key

#define TRNG_IER_DATRDY 0x00000001 // Data Ready Interrupt Enable

#define TRNG_IDR_DATRDY 0x00000001 // Data Ready Interrupt Disable

#define TRNG_IMR_DATRDY 0x00000001 // Data Ready Interrupt Mask

#define TRNG_ISR_DATRDY 0x00000001 // Data Ready

#define TRNG_ODATA_ODATA(value) (((value) & 0xFFFFFFFF) << 0) // Output Data

#define ADC_CR    (*(volatile unsigned int *)0x400C0000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1185433)
#define ADC_MR    (*(volatile unsigned int *)0x400C0004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1185627)
#define ADC_SEQR1 (*(volatile unsigned int *)0x400C0008)       // [Channel Sequence Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1302797)
#define ADC_SEQR2 (*(volatile unsigned int *)0x400C000C)       // [Channel Sequence Register 2](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1302999)
#define ADC_CHER  (*(volatile unsigned int *)0x400C0010)       // [Channel Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1186906)
#define ADC_CHDR  (*(volatile unsigned int *)0x400C0014)       // [Channel Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1187144)
#define ADC_CHSR  (*(const volatile unsigned int *)0x400C0018) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1187382)
#define ADC_LCDR  (*(const volatile unsigned int *)0x400C0020) // [Last Converted Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1187614)
#define ADC_IER   (*(volatile unsigned int *)0x400C0024)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1187801)
#define ADC_IDR   (*(volatile unsigned int *)0x400C0028)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1188044)
#define ADC_IMR   (*(const volatile unsigned int *)0x400C002C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1188288)
#define ADC_ISR   (*(const volatile unsigned int *)0x400C0030) // [Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1188532)
#define ADC_OVER  (*(const volatile unsigned int *)0x400C003C) // [Overrun Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1188799)
#define ADC_EMR   (*(volatile unsigned int *)0x400C0040)       // [Extended Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1189032)
#define ADC_CWR   (*(volatile unsigned int *)0x400C0044)       // [Compare Window Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1189294)
#define ADC_CGR   (*(volatile unsigned int *)0x400C0048)       // [Channel Gain Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1280112)
#define ADC_COR   (*(volatile unsigned int *)0x400C004C)       // [Channel Offset Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1280390)
#define ADC_CDR0  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR1  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR2  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR3  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR4  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR5  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR6  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR7  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR8  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR9  (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR10 (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR11 (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR12 (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR13 (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR14 (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_CDR15 (*(const volatile unsigned int *)0x400C0054) // [Channel Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1190051)
#define ADC_ACR   (*(volatile unsigned int *)0x400C0094)       // [Analog Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1300656)
#define ADC_WPMR  (*(volatile unsigned int *)0x400C00E4)       // [Write Protect Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1191558)
#define ADC_WPSR  (*(const volatile unsigned int *)0x400C00E8) // [Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G34.1191823)
#define ADC_RPR   (*(volatile unsigned int *)0x400C0100)       // [Receive Pointer Register]()
#define ADC_RCR   (*(volatile unsigned int *)0x400C0104)       // [Receive Counter Register]()
#define ADC_RNPR  (*(volatile unsigned int *)0x400C0110)       // [Receive Next Pointer Register]()
#define ADC_RNCR  (*(volatile unsigned int *)0x400C0114)       // [Receive Next Counter Register]()
#define ADC_PTCR  (*(volatile unsigned int *)0x400C0120)       // [Transfer Control Register]()
#define ADC_PTSR  (*(const volatile unsigned int *)0x400C0124) // [Transfer Status Register]()

#define ADC_CR_SWRST 0x00000001 // Software Reset
#define ADC_CR_START 0x00000002 // Start Conversion

#define ADC_MR_TRGEN_DIS        0x00000000              // Hardware triggers are disabled. Starting a conversion is only possible by software
#define ADC_MR_TRGEN_EN         0x00000001              // Hardware trigger selected by TRGSEL field is enabled
#define ADC_MR_TRGSEL_ADC_TRIG0 0x00000000              // External : ADCTRG
#define ADC_MR_TRGSEL_ADC_TRIG1 0x00000002              // TIOA Output of the Timer Counter Channel 0
#define ADC_MR_TRGSEL_ADC_TRIG2 0x00000004              // TIOA Output of the Timer Counter Channel 1
#define ADC_MR_TRGSEL_ADC_TRIG3 0x00000006              // TIOA Output of the Timer Counter Channel 2
#define ADC_MR_TRGSEL_ADC_TRIG4 0x00000008              // PWM Event Line 0
#define ADC_MR_TRGSEL_ADC_TRIG5 0x0000000A              // PWM Event Line 0
#define ADC_MR_SLEEP_NORMAL     0x00000000              // Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
#define ADC_MR_SLEEP_SLEEP      0x00000020              // Sleep Mode: The wake-up time can be modified by programming FWUP bit
#define ADC_MR_FWUP_OFF         0x00000000              // If SLEEP is 1 then both ADC Core and reference voltage circuitry are OFF between conversions
#define ADC_MR_FWUP_ON          0x00000040              // If SLEEP is 1 then Fast Wake-up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
#define ADC_MR_FREERUN_OFF      0x00000000              // Normal Mode
#define ADC_MR_FREERUN_ON       0x00000080              // Free Run Mode: Never wait for any trigger
#define ADC_MR_PRESCAL(value)   (((value) & 0xFF) << 8) // Prescaler Rate Selection
#define ADC_MR_STARTUP_SUT0     0x00000000              // 0 periods of ADCClock
#define ADC_MR_STARTUP_SUT8     0x00010000              // 8 periods of ADCClock
#define ADC_MR_STARTUP_SUT16    0x00020000              // 16 periods of ADCClock
#define ADC_MR_STARTUP_SUT24    0x00030000              // 24 periods of ADCClock
#define ADC_MR_STARTUP_SUT64    0x00040000              // 64 periods of ADCClock
#define ADC_MR_STARTUP_SUT80    0x00050000              // 80 periods of ADCClock
#define ADC_MR_STARTUP_SUT96    0x00060000              // 96 periods of ADCClock
#define ADC_MR_STARTUP_SUT112   0x00070000              // 112 periods of ADCClock
#define ADC_MR_STARTUP_SUT512   0x00080000              // 512 periods of ADCClock
#define ADC_MR_STARTUP_SUT576   0x00090000              // 576 periods of ADCClock
#define ADC_MR_STARTUP_SUT640   0x000A0000              // 640 periods of ADCClock
#define ADC_MR_STARTUP_SUT704   0x000B0000              // 704 periods of ADCClock
#define ADC_MR_STARTUP_SUT768   0x000C0000              // 768 periods of ADCClock
#define ADC_MR_STARTUP_SUT832   0x000D0000              // 832 periods of ADCClock
#define ADC_MR_STARTUP_SUT896   0x000E0000              // 896 periods of ADCClock
#define ADC_MR_STARTUP_SUT960   0x000F0000              // 960 periods of ADCClock
#define ADC_MR_SETTLING_AST3    0x00000000              // 3 periods of ADCClock
#define ADC_MR_SETTLING_AST5    0x00100000              // 5 periods of ADCClock
#define ADC_MR_SETTLING_AST9    0x00200000              // 9 periods of ADCClock
#define ADC_MR_SETTLING_AST17   0x00300000              // 17 periods of ADCClock
#define ADC_MR_ANACH_NONE       0x00000000              // No analog change on channel switching: DIFF0, GAIN0 and OFF0 are used for all channels
#define ADC_MR_ANACH_ALLOWED    0x00800000              // Allows different analog settings for each channel. See ADC_CGR and ADC_COR Registers
#define ADC_MR_TRACKTIM(value)  (((value) & 0xF) << 24) // Tracking Time
#define ADC_MR_TRANSFER(value)  (((value) & 0x3) << 28) // Transfer Period
#define ADC_MR_USEQ_NUM_ORDER   0x00000000              // Normal Mode: The controller converts channels in a simple numeric order depending only on the channel index
#define ADC_MR_USEQ_REG_ORDER   0x80000000              // User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers and can be used to convert several times the same channel

#define ADC_SEQR1_USCH1(value) (((value) & 0xF) << 0)  // User Sequence Number 1
#define ADC_SEQR1_USCH2(value) (((value) & 0xF) << 4)  // User Sequence Number 2
#define ADC_SEQR1_USCH3(value) (((value) & 0xF) << 8)  // User Sequence Number 3
#define ADC_SEQR1_USCH4(value) (((value) & 0xF) << 12) // User Sequence Number 4
#define ADC_SEQR1_USCH5(value) (((value) & 0xF) << 16) // User Sequence Number 5
#define ADC_SEQR1_USCH6(value) (((value) & 0xF) << 20) // User Sequence Number 6
#define ADC_SEQR1_USCH7(value) (((value) & 0xF) << 24) // User Sequence Number 7
#define ADC_SEQR1_USCH8(value) (((value) & 0xF) << 28) // User Sequence Number 8

#define ADC_SEQR2_USCH9(value)  (((value) & 0xF) << 0)  // User Sequence Number 9
#define ADC_SEQR2_USCH10(value) (((value) & 0xF) << 4)  // User Sequence Number 10
#define ADC_SEQR2_USCH11(value) (((value) & 0xF) << 8)  // User Sequence Number 11
#define ADC_SEQR2_USCH12(value) (((value) & 0xF) << 12) // User Sequence Number 12
#define ADC_SEQR2_USCH13(value) (((value) & 0xF) << 16) // User Sequence Number 13
#define ADC_SEQR2_USCH14(value) (((value) & 0xF) << 20) // User Sequence Number 14
#define ADC_SEQR2_USCH15(value) (((value) & 0xF) << 24) // User Sequence Number 15

#define ADC_CHER_CH0  0x00000001 // Channel 0 Enable
#define ADC_CHER_CH1  0x00000002 // Channel 1 Enable
#define ADC_CHER_CH2  0x00000004 // Channel 2 Enable
#define ADC_CHER_CH3  0x00000008 // Channel 3 Enable
#define ADC_CHER_CH4  0x00000010 // Channel 4 Enable
#define ADC_CHER_CH5  0x00000020 // Channel 5 Enable
#define ADC_CHER_CH6  0x00000040 // Channel 6 Enable
#define ADC_CHER_CH7  0x00000080 // Channel 7 Enable
#define ADC_CHER_CH8  0x00000100 // Channel 8 Enable
#define ADC_CHER_CH9  0x00000200 // Channel 9 Enable
#define ADC_CHER_CH10 0x00000400 // Channel 10 Enable
#define ADC_CHER_CH11 0x00000800 // Channel 11 Enable
#define ADC_CHER_CH12 0x00001000 // Channel 12 Enable
#define ADC_CHER_CH13 0x00002000 // Channel 13 Enable
#define ADC_CHER_CH14 0x00004000 // Channel 14 Enable
#define ADC_CHER_CH15 0x00008000 // Channel 15 Enable

#define ADC_CHDR_CH0  0x00000001 // Channel 0 Disable
#define ADC_CHDR_CH1  0x00000002 // Channel 1 Disable
#define ADC_CHDR_CH2  0x00000004 // Channel 2 Disable
#define ADC_CHDR_CH3  0x00000008 // Channel 3 Disable
#define ADC_CHDR_CH4  0x00000010 // Channel 4 Disable
#define ADC_CHDR_CH5  0x00000020 // Channel 5 Disable
#define ADC_CHDR_CH6  0x00000040 // Channel 6 Disable
#define ADC_CHDR_CH7  0x00000080 // Channel 7 Disable
#define ADC_CHDR_CH8  0x00000100 // Channel 8 Disable
#define ADC_CHDR_CH9  0x00000200 // Channel 9 Disable
#define ADC_CHDR_CH10 0x00000400 // Channel 10 Disable
#define ADC_CHDR_CH11 0x00000800 // Channel 11 Disable
#define ADC_CHDR_CH12 0x00001000 // Channel 12 Disable
#define ADC_CHDR_CH13 0x00002000 // Channel 13 Disable
#define ADC_CHDR_CH14 0x00004000 // Channel 14 Disable
#define ADC_CHDR_CH15 0x00008000 // Channel 15 Disable

#define ADC_CHSR_CH0  0x00000001 // Channel 0 Status
#define ADC_CHSR_CH1  0x00000002 // Channel 1 Status
#define ADC_CHSR_CH2  0x00000004 // Channel 2 Status
#define ADC_CHSR_CH3  0x00000008 // Channel 3 Status
#define ADC_CHSR_CH4  0x00000010 // Channel 4 Status
#define ADC_CHSR_CH5  0x00000020 // Channel 5 Status
#define ADC_CHSR_CH6  0x00000040 // Channel 6 Status
#define ADC_CHSR_CH7  0x00000080 // Channel 7 Status
#define ADC_CHSR_CH8  0x00000100 // Channel 8 Status
#define ADC_CHSR_CH9  0x00000200 // Channel 9 Status
#define ADC_CHSR_CH10 0x00000400 // Channel 10 Status
#define ADC_CHSR_CH11 0x00000800 // Channel 11 Status
#define ADC_CHSR_CH12 0x00001000 // Channel 12 Status
#define ADC_CHSR_CH13 0x00002000 // Channel 13 Status
#define ADC_CHSR_CH14 0x00004000 // Channel 14 Status
#define ADC_CHSR_CH15 0x00008000 // Channel 15 Status

#define ADC_LCDR_LDATA(value) (((value) & 0xFFF) << 0) // Last Data Converted
#define ADC_LCDR_CHNB(value)  (((value) & 0xF) << 12)  // Channel Number

#define ADC_IER_EOC0   0x00000001 // End of Conversion Interrupt Enable 0
#define ADC_IER_EOC1   0x00000002 // End of Conversion Interrupt Enable 1
#define ADC_IER_EOC2   0x00000004 // End of Conversion Interrupt Enable 2
#define ADC_IER_EOC3   0x00000008 // End of Conversion Interrupt Enable 3
#define ADC_IER_EOC4   0x00000010 // End of Conversion Interrupt Enable 4
#define ADC_IER_EOC5   0x00000020 // End of Conversion Interrupt Enable 5
#define ADC_IER_EOC6   0x00000040 // End of Conversion Interrupt Enable 6
#define ADC_IER_EOC7   0x00000080 // End of Conversion Interrupt Enable 7
#define ADC_IER_EOC8   0x00000100 // End of Conversion Interrupt Enable 8
#define ADC_IER_EOC9   0x00000200 // End of Conversion Interrupt Enable 9
#define ADC_IER_EOC10  0x00000400 // End of Conversion Interrupt Enable 10
#define ADC_IER_EOC11  0x00000800 // End of Conversion Interrupt Enable 11
#define ADC_IER_EOC12  0x00001000 // End of Conversion Interrupt Enable 12
#define ADC_IER_EOC13  0x00002000 // End of Conversion Interrupt Enable 13
#define ADC_IER_EOC14  0x00004000 // End of Conversion Interrupt Enable 14
#define ADC_IER_EOC15  0x00008000 // End of Conversion Interrupt Enable 15
#define ADC_IER_DRDY   0x01000000 // Data Ready Interrupt Enable
#define ADC_IER_GOVRE  0x02000000 // General Overrun Error Interrupt Enable
#define ADC_IER_COMPE  0x04000000 // Comparison Event Interrupt Enable
#define ADC_IER_ENDRX  0x08000000 // End of Receive Buffer Interrupt Enable
#define ADC_IER_RXBUFF 0x10000000 // Receive Buffer Full Interrupt Enable

#define ADC_IDR_EOC0   0x00000001 // End of Conversion Interrupt Disable 0
#define ADC_IDR_EOC1   0x00000002 // End of Conversion Interrupt Disable 1
#define ADC_IDR_EOC2   0x00000004 // End of Conversion Interrupt Disable 2
#define ADC_IDR_EOC3   0x00000008 // End of Conversion Interrupt Disable 3
#define ADC_IDR_EOC4   0x00000010 // End of Conversion Interrupt Disable 4
#define ADC_IDR_EOC5   0x00000020 // End of Conversion Interrupt Disable 5
#define ADC_IDR_EOC6   0x00000040 // End of Conversion Interrupt Disable 6
#define ADC_IDR_EOC7   0x00000080 // End of Conversion Interrupt Disable 7
#define ADC_IDR_EOC8   0x00000100 // End of Conversion Interrupt Disable 8
#define ADC_IDR_EOC9   0x00000200 // End of Conversion Interrupt Disable 9
#define ADC_IDR_EOC10  0x00000400 // End of Conversion Interrupt Disable 10
#define ADC_IDR_EOC11  0x00000800 // End of Conversion Interrupt Disable 11
#define ADC_IDR_EOC12  0x00001000 // End of Conversion Interrupt Disable 12
#define ADC_IDR_EOC13  0x00002000 // End of Conversion Interrupt Disable 13
#define ADC_IDR_EOC14  0x00004000 // End of Conversion Interrupt Disable 14
#define ADC_IDR_EOC15  0x00008000 // End of Conversion Interrupt Disable 15
#define ADC_IDR_DRDY   0x01000000 // Data Ready Interrupt Disable
#define ADC_IDR_GOVRE  0x02000000 // General Overrun Error Interrupt Disable
#define ADC_IDR_COMPE  0x04000000 // Comparison Event Interrupt Disable
#define ADC_IDR_ENDRX  0x08000000 // End of Receive Buffer Interrupt Disable
#define ADC_IDR_RXBUFF 0x10000000 // Receive Buffer Full Interrupt Disable

#define ADC_IMR_EOC0   0x00000001 // End of Conversion Interrupt Mask 0
#define ADC_IMR_EOC1   0x00000002 // End of Conversion Interrupt Mask 1
#define ADC_IMR_EOC2   0x00000004 // End of Conversion Interrupt Mask 2
#define ADC_IMR_EOC3   0x00000008 // End of Conversion Interrupt Mask 3
#define ADC_IMR_EOC4   0x00000010 // End of Conversion Interrupt Mask 4
#define ADC_IMR_EOC5   0x00000020 // End of Conversion Interrupt Mask 5
#define ADC_IMR_EOC6   0x00000040 // End of Conversion Interrupt Mask 6
#define ADC_IMR_EOC7   0x00000080 // End of Conversion Interrupt Mask 7
#define ADC_IMR_EOC8   0x00000100 // End of Conversion Interrupt Mask 8
#define ADC_IMR_EOC9   0x00000200 // End of Conversion Interrupt Mask 9
#define ADC_IMR_EOC10  0x00000400 // End of Conversion Interrupt Mask 10
#define ADC_IMR_EOC11  0x00000800 // End of Conversion Interrupt Mask 11
#define ADC_IMR_EOC12  0x00001000 // End of Conversion Interrupt Mask 12
#define ADC_IMR_EOC13  0x00002000 // End of Conversion Interrupt Mask 13
#define ADC_IMR_EOC14  0x00004000 // End of Conversion Interrupt Mask 14
#define ADC_IMR_EOC15  0x00008000 // End of Conversion Interrupt Mask 15
#define ADC_IMR_DRDY   0x01000000 // Data Ready Interrupt Mask
#define ADC_IMR_GOVRE  0x02000000 // General Overrun Error Interrupt Mask
#define ADC_IMR_COMPE  0x04000000 // Comparison Event Interrupt Mask
#define ADC_IMR_ENDRX  0x08000000 // End of Receive Buffer Interrupt Mask
#define ADC_IMR_RXBUFF 0x10000000 // Receive Buffer Full Interrupt Mask

#define ADC_ISR_EOC0   0x00000001 // End of Conversion 0
#define ADC_ISR_EOC1   0x00000002 // End of Conversion 1
#define ADC_ISR_EOC2   0x00000004 // End of Conversion 2
#define ADC_ISR_EOC3   0x00000008 // End of Conversion 3
#define ADC_ISR_EOC4   0x00000010 // End of Conversion 4
#define ADC_ISR_EOC5   0x00000020 // End of Conversion 5
#define ADC_ISR_EOC6   0x00000040 // End of Conversion 6
#define ADC_ISR_EOC7   0x00000080 // End of Conversion 7
#define ADC_ISR_EOC8   0x00000100 // End of Conversion 8
#define ADC_ISR_EOC9   0x00000200 // End of Conversion 9
#define ADC_ISR_EOC10  0x00000400 // End of Conversion 10
#define ADC_ISR_EOC11  0x00000800 // End of Conversion 11
#define ADC_ISR_EOC12  0x00001000 // End of Conversion 12
#define ADC_ISR_EOC13  0x00002000 // End of Conversion 13
#define ADC_ISR_EOC14  0x00004000 // End of Conversion 14
#define ADC_ISR_EOC15  0x00008000 // End of Conversion 15
#define ADC_ISR_DRDY   0x01000000 // Data Ready
#define ADC_ISR_GOVRE  0x02000000 // General Overrun Error
#define ADC_ISR_COMPE  0x04000000 // Comparison Error
#define ADC_ISR_ENDRX  0x08000000 // End of RX Buffer
#define ADC_ISR_RXBUFF 0x10000000 // RX Buffer Full

#define ADC_OVER_OVRE0  0x00000001 // Overrun Error 0
#define ADC_OVER_OVRE1  0x00000002 // Overrun Error 1
#define ADC_OVER_OVRE2  0x00000004 // Overrun Error 2
#define ADC_OVER_OVRE3  0x00000008 // Overrun Error 3
#define ADC_OVER_OVRE4  0x00000010 // Overrun Error 4
#define ADC_OVER_OVRE5  0x00000020 // Overrun Error 5
#define ADC_OVER_OVRE6  0x00000040 // Overrun Error 6
#define ADC_OVER_OVRE7  0x00000080 // Overrun Error 7
#define ADC_OVER_OVRE8  0x00000100 // Overrun Error 8
#define ADC_OVER_OVRE9  0x00000200 // Overrun Error 9
#define ADC_OVER_OVRE10 0x00000400 // Overrun Error 10
#define ADC_OVER_OVRE11 0x00000800 // Overrun Error 11
#define ADC_OVER_OVRE12 0x00001000 // Overrun Error 12
#define ADC_OVER_OVRE13 0x00002000 // Overrun Error 13
#define ADC_OVER_OVRE14 0x00004000 // Overrun Error 14
#define ADC_OVER_OVRE15 0x00008000 // Overrun Error 15

#define ADC_EMR_CMPMODE_LOW      0x00000000              // Generates an event when the converted data is lower than the low threshold of the window
#define ADC_EMR_CMPMODE_HIGH     0x00000001              // Generates an event when the converted data is higher than the high threshold of the window
#define ADC_EMR_CMPMODE_IN       0x00000002              // Generates an event when the converted data is in the comparison window
#define ADC_EMR_CMPMODE_OUT      0x00000003              // Generates an event when the converted data is out of the comparison window
#define ADC_EMR_CMPSEL(value)    (((value) & 0xF) << 4)  // Comparison Selected Channel
#define ADC_EMR_CMPALL           0x00000200              // Compare All Channels
#define ADC_EMR_CMPFILTER(value) (((value) & 0x3) << 12) // Compare Event Filtering
#define ADC_EMR_TAG              0x01000000              // TAG of the ADC_LDCR register

#define ADC_CWR_LOWTHRES(value)  (((value) & 0xFFF) << 0)  // Low Threshold
#define ADC_CWR_HIGHTHRES(value) (((value) & 0xFFF) << 16) // High Threshold

#define ADC_CGR_GAIN0(value)  (((value) & 0x3) << 0)  // Gain for Channel 0
#define ADC_CGR_GAIN1(value)  (((value) & 0x3) << 2)  // Gain for Channel 1
#define ADC_CGR_GAIN2(value)  (((value) & 0x3) << 4)  // Gain for Channel 2
#define ADC_CGR_GAIN3(value)  (((value) & 0x3) << 6)  // Gain for Channel 3
#define ADC_CGR_GAIN4(value)  (((value) & 0x3) << 8)  // Gain for Channel 4
#define ADC_CGR_GAIN5(value)  (((value) & 0x3) << 10) // Gain for Channel 5
#define ADC_CGR_GAIN6(value)  (((value) & 0x3) << 12) // Gain for Channel 6
#define ADC_CGR_GAIN7(value)  (((value) & 0x3) << 14) // Gain for Channel 7
#define ADC_CGR_GAIN8(value)  (((value) & 0x3) << 16) // Gain for Channel 8
#define ADC_CGR_GAIN9(value)  (((value) & 0x3) << 18) // Gain for Channel 9
#define ADC_CGR_GAIN10(value) (((value) & 0x3) << 20) // Gain for Channel 10
#define ADC_CGR_GAIN11(value) (((value) & 0x3) << 22) // Gain for Channel 11
#define ADC_CGR_GAIN12(value) (((value) & 0x3) << 24) // Gain for Channel 12
#define ADC_CGR_GAIN13(value) (((value) & 0x3) << 26) // Gain for Channel 13
#define ADC_CGR_GAIN14(value) (((value) & 0x3) << 28) // Gain for Channel 14
#define ADC_CGR_GAIN15(value) (((value) & 0x3) << 30) // Gain for Channel 15

#define ADC_COR_OFF0   0x00000001 // Offset for channel 0
#define ADC_COR_OFF1   0x00000002 // Offset for channel 1
#define ADC_COR_OFF2   0x00000004 // Offset for channel 2
#define ADC_COR_OFF3   0x00000008 // Offset for channel 3
#define ADC_COR_OFF4   0x00000010 // Offset for channel 4
#define ADC_COR_OFF5   0x00000020 // Offset for channel 5
#define ADC_COR_OFF6   0x00000040 // Offset for channel 6
#define ADC_COR_OFF7   0x00000080 // Offset for channel 7
#define ADC_COR_OFF8   0x00000100 // Offset for channel 8
#define ADC_COR_OFF9   0x00000200 // Offset for channel 9
#define ADC_COR_OFF10  0x00000400 // Offset for channel 10
#define ADC_COR_OFF11  0x00000800 // Offset for channel 11
#define ADC_COR_OFF12  0x00001000 // Offset for channel 12
#define ADC_COR_OFF13  0x00002000 // Offset for channel 13
#define ADC_COR_OFF14  0x00004000 // Offset for channel 14
#define ADC_COR_OFF15  0x00008000 // Offset for channel 15
#define ADC_COR_DIFF0  0x00010000 // Differential inputs for channel 0
#define ADC_COR_DIFF1  0x00020000 // Differential inputs for channel 1
#define ADC_COR_DIFF2  0x00040000 // Differential inputs for channel 2
#define ADC_COR_DIFF3  0x00080000 // Differential inputs for channel 3
#define ADC_COR_DIFF4  0x00100000 // Differential inputs for channel 4
#define ADC_COR_DIFF5  0x00200000 // Differential inputs for channel 5
#define ADC_COR_DIFF6  0x00400000 // Differential inputs for channel 6
#define ADC_COR_DIFF7  0x00800000 // Differential inputs for channel 7
#define ADC_COR_DIFF8  0x01000000 // Differential inputs for channel 8
#define ADC_COR_DIFF9  0x02000000 // Differential inputs for channel 9
#define ADC_COR_DIFF10 0x04000000 // Differential inputs for channel 10
#define ADC_COR_DIFF11 0x08000000 // Differential inputs for channel 11
#define ADC_COR_DIFF12 0x10000000 // Differential inputs for channel 12
#define ADC_COR_DIFF13 0x20000000 // Differential inputs for channel 13
#define ADC_COR_DIFF14 0x40000000 // Differential inputs for channel 14
#define ADC_COR_DIFF15 0x80000000 // Differential inputs for channel 15

#define ADC_CDR_DATA(value) (((value) & 0xFFF) << 0) // Converted Data

#define ADC_ACR_TSON         0x00000010             // Temperature Sensor On
#define ADC_ACR_IBCTL(value) (((value) & 0x3) << 8) // ADC Bias Current Control

#define ADC_WPMR_WPEN         0x00000001 // Write Protect Enable
#define ADC_WPMR_WPKEY_PASSWD 0x41444300 // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0

#define ADC_WPSR_WPVS          0x00000001                // Write Protect Violation Status
#define ADC_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protect Violation Source

#define ADC_RPR_RXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Pointer Register

#define ADC_RCR_RXCTR(value) (((value) & 0xFFFF) << 0) // Receive Counter Register

#define ADC_RNPR_RXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Next Pointer

#define ADC_RNCR_RXNCTR(value) (((value) & 0xFFFF) << 0) // Receive Next Counter

#define ADC_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define ADC_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define ADC_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define ADC_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define ADC_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define ADC_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define DMAC_GCFG   (*(volatile unsigned int *)0x400C4000)       // [DMAC Global Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1392368)
#define DMAC_EN     (*(volatile unsigned int *)0x400C4004)       // [DMAC Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1392658)
#define DMAC_SREQ   (*(volatile unsigned int *)0x400C4008)       // [DMAC Software Single Request Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1413723)
#define DMAC_CREQ   (*(volatile unsigned int *)0x400C400C)       // [DMAC Software Chunk Transfer Request Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1393218)
#define DMAC_LAST   (*(volatile unsigned int *)0x400C4010)       // [DMAC Software Last Transfer Flag Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1393501)
#define DMAC_EBCIER (*(volatile unsigned int *)0x400C4018)       // [DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1394066)
#define DMAC_EBCIDR (*(volatile unsigned int *)0x400C401C)       // [DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1394359)
#define DMAC_EBCIMR (*(const volatile unsigned int *)0x400C4020) // [DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1394652)
#define DMAC_EBCISR (*(const volatile unsigned int *)0x400C4024) // [DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1394948)
#define DMAC_CHER   (*(volatile unsigned int *)0x400C4028)       // [DMAC Channel Handler Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1395241)
#define DMAC_CHDR   (*(volatile unsigned int *)0x400C402C)       // [DMAC Channel Handler Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1395534)
#define DMAC_CHSR   (*(const volatile unsigned int *)0x400C4030) // [DMAC Channel Handler Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1395825)
#define DMAC_SADDR0 (*(volatile unsigned int *)0x400C403C)       // [DMAC Channel Source Address Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396127)
#define DMAC_DADDR0 (*(volatile unsigned int *)0x400C4040)       // [DMAC Channel Destination Address Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396317)
#define DMAC_DSCR0  (*(volatile unsigned int *)0x400C4044)       // [DMAC Channel Descriptor Address Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396507)
#define DMAC_CTRLA0 (*(volatile unsigned int *)0x400C4048)       // [DMAC Channel Control A Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396705)
#define DMAC_CTRLB0 (*(volatile unsigned int *)0x400C404C)       // [DMAC Channel Control B Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397240)
#define DMAC_CFG0   (*(volatile unsigned int *)0x400C4050)       // [DMAC Channel Configuration Register (ch_num = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397829)
#define DMAC_SADDR1 (*(volatile unsigned int *)0x400C4064)       // [DMAC Channel Source Address Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396127)
#define DMAC_DADDR1 (*(volatile unsigned int *)0x400C4068)       // [DMAC Channel Destination Address Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396317)
#define DMAC_DSCR1  (*(volatile unsigned int *)0x400C406C)       // [DMAC Channel Descriptor Address Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396507)
#define DMAC_CTRLA1 (*(volatile unsigned int *)0x400C4070)       // [DMAC Channel Control A Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396705)
#define DMAC_CTRLB1 (*(volatile unsigned int *)0x400C4074)       // [DMAC Channel Control B Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397240)
#define DMAC_CFG1   (*(volatile unsigned int *)0x400C4078)       // [DMAC Channel Configuration Register (ch_num = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397829)
#define DMAC_SADDR2 (*(volatile unsigned int *)0x400C408C)       // [DMAC Channel Source Address Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396127)
#define DMAC_DADDR2 (*(volatile unsigned int *)0x400C4090)       // [DMAC Channel Destination Address Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396317)
#define DMAC_DSCR2  (*(volatile unsigned int *)0x400C4094)       // [DMAC Channel Descriptor Address Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396507)
#define DMAC_CTRLA2 (*(volatile unsigned int *)0x400C4098)       // [DMAC Channel Control A Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396705)
#define DMAC_CTRLB2 (*(volatile unsigned int *)0x400C409C)       // [DMAC Channel Control B Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397240)
#define DMAC_CFG2   (*(volatile unsigned int *)0x400C40A0)       // [DMAC Channel Configuration Register (ch_num = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397829)
#define DMAC_SADDR3 (*(volatile unsigned int *)0x400C40B4)       // [DMAC Channel Source Address Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396127)
#define DMAC_DADDR3 (*(volatile unsigned int *)0x400C40B8)       // [DMAC Channel Destination Address Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396317)
#define DMAC_DSCR3  (*(volatile unsigned int *)0x400C40BC)       // [DMAC Channel Descriptor Address Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396507)
#define DMAC_CTRLA3 (*(volatile unsigned int *)0x400C40C0)       // [DMAC Channel Control A Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396705)
#define DMAC_CTRLB3 (*(volatile unsigned int *)0x400C40C4)       // [DMAC Channel Control B Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397240)
#define DMAC_CFG3   (*(volatile unsigned int *)0x400C40C8)       // [DMAC Channel Configuration Register (ch_num = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397829)
#define DMAC_SADDR4 (*(volatile unsigned int *)0x400C40DC)       // [DMAC Channel Source Address Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396127)
#define DMAC_DADDR4 (*(volatile unsigned int *)0x400C40E0)       // [DMAC Channel Destination Address Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396317)
#define DMAC_DSCR4  (*(volatile unsigned int *)0x400C40E4)       // [DMAC Channel Descriptor Address Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396507)
#define DMAC_CTRLA4 (*(volatile unsigned int *)0x400C40E8)       // [DMAC Channel Control A Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396705)
#define DMAC_CTRLB4 (*(volatile unsigned int *)0x400C40EC)       // [DMAC Channel Control B Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397240)
#define DMAC_CFG4   (*(volatile unsigned int *)0x400C40F0)       // [DMAC Channel Configuration Register (ch_num = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397829)
#define DMAC_SADDR5 (*(volatile unsigned int *)0x400C4104)       // [DMAC Channel Source Address Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396127)
#define DMAC_DADDR5 (*(volatile unsigned int *)0x400C4108)       // [DMAC Channel Destination Address Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396317)
#define DMAC_DSCR5  (*(volatile unsigned int *)0x400C410C)       // [DMAC Channel Descriptor Address Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396507)
#define DMAC_CTRLA5 (*(volatile unsigned int *)0x400C4110)       // [DMAC Channel Control A Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1396705)
#define DMAC_CTRLB5 (*(volatile unsigned int *)0x400C4114)       // [DMAC Channel Control B Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397240)
#define DMAC_CFG5   (*(volatile unsigned int *)0x400C4118)       // [DMAC Channel Configuration Register (ch_num = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1397829)
#define DMAC_WPMR   (*(volatile unsigned int *)0x400C41E4)       // [DMAC Write Protect Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1457422)
#define DMAC_WPSR   (*(const volatile unsigned int *)0x400C41E8) // [DMAC Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G14.1457710)

#define DMAC_GCFG_ARB_CFG_FIXED       0x00000000 // Fixed priority arbiter (see "Basic Definitions" )
#define DMAC_GCFG_ARB_CFG_ROUND_ROBIN 0x00000010 // Modified round robin arbiter

#define DMAC_EN_ENABLE 0x00000001 // General Enable of DMA

#define DMAC_SREQ_SSREQ0 0x00000001 // Source Request
#define DMAC_SREQ_DSREQ0 0x00000002 // Destination Request
#define DMAC_SREQ_SSREQ1 0x00000004 // Source Request
#define DMAC_SREQ_DSREQ1 0x00000008 // Destination Request
#define DMAC_SREQ_SSREQ2 0x00000010 // Source Request
#define DMAC_SREQ_DSREQ2 0x00000020 // Destination Request
#define DMAC_SREQ_SSREQ3 0x00000040 // Source Request
#define DMAC_SREQ_DSREQ3 0x00000080 // Destination Request
#define DMAC_SREQ_SSREQ4 0x00000100 // Source Request
#define DMAC_SREQ_DSREQ4 0x00000200 // Destination Request
#define DMAC_SREQ_SSREQ5 0x00000400 // Source Request
#define DMAC_SREQ_DSREQ5 0x00000800 // Destination Request

#define DMAC_CREQ_SCREQ0 0x00000001 // Source Chunk Request
#define DMAC_CREQ_DCREQ0 0x00000002 // Destination Chunk Request
#define DMAC_CREQ_SCREQ1 0x00000004 // Source Chunk Request
#define DMAC_CREQ_DCREQ1 0x00000008 // Destination Chunk Request
#define DMAC_CREQ_SCREQ2 0x00000010 // Source Chunk Request
#define DMAC_CREQ_DCREQ2 0x00000020 // Destination Chunk Request
#define DMAC_CREQ_SCREQ3 0x00000040 // Source Chunk Request
#define DMAC_CREQ_DCREQ3 0x00000080 // Destination Chunk Request
#define DMAC_CREQ_SCREQ4 0x00000100 // Source Chunk Request
#define DMAC_CREQ_DCREQ4 0x00000200 // Destination Chunk Request
#define DMAC_CREQ_SCREQ5 0x00000400 // Source Chunk Request
#define DMAC_CREQ_DCREQ5 0x00000800 // Destination Chunk Request

#define DMAC_LAST_SLAST0 0x00000001 // Source Last
#define DMAC_LAST_DLAST0 0x00000002 // Destination Last
#define DMAC_LAST_SLAST1 0x00000004 // Source Last
#define DMAC_LAST_DLAST1 0x00000008 // Destination Last
#define DMAC_LAST_SLAST2 0x00000010 // Source Last
#define DMAC_LAST_DLAST2 0x00000020 // Destination Last
#define DMAC_LAST_SLAST3 0x00000040 // Source Last
#define DMAC_LAST_DLAST3 0x00000080 // Destination Last
#define DMAC_LAST_SLAST4 0x00000100 // Source Last
#define DMAC_LAST_DLAST4 0x00000200 // Destination Last
#define DMAC_LAST_SLAST5 0x00000400 // Source Last
#define DMAC_LAST_DLAST5 0x00000800 // Destination Last

#define DMAC_EBCIER_BTC0  0x00000001 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_BTC1  0x00000002 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_BTC2  0x00000004 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_BTC3  0x00000008 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_BTC4  0x00000010 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_BTC5  0x00000020 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_CBTC0 0x00000100 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_CBTC1 0x00000200 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_CBTC2 0x00000400 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_CBTC3 0x00000800 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_CBTC4 0x00001000 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_CBTC5 0x00002000 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIER_ERR0  0x00010000 // Access Error [5:0]
#define DMAC_EBCIER_ERR1  0x00020000 // Access Error [5:0]
#define DMAC_EBCIER_ERR2  0x00040000 // Access Error [5:0]
#define DMAC_EBCIER_ERR3  0x00080000 // Access Error [5:0]
#define DMAC_EBCIER_ERR4  0x00100000 // Access Error [5:0]
#define DMAC_EBCIER_ERR5  0x00200000 // Access Error [5:0]

#define DMAC_EBCIDR_BTC0  0x00000001 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_BTC1  0x00000002 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_BTC2  0x00000004 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_BTC3  0x00000008 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_BTC4  0x00000010 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_BTC5  0x00000020 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_CBTC0 0x00000100 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_CBTC1 0x00000200 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_CBTC2 0x00000400 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_CBTC3 0x00000800 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_CBTC4 0x00001000 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_CBTC5 0x00002000 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIDR_ERR0  0x00010000 // Access Error [5:0]
#define DMAC_EBCIDR_ERR1  0x00020000 // Access Error [5:0]
#define DMAC_EBCIDR_ERR2  0x00040000 // Access Error [5:0]
#define DMAC_EBCIDR_ERR3  0x00080000 // Access Error [5:0]
#define DMAC_EBCIDR_ERR4  0x00100000 // Access Error [5:0]
#define DMAC_EBCIDR_ERR5  0x00200000 // Access Error [5:0]

#define DMAC_EBCIMR_BTC0  0x00000001 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_BTC1  0x00000002 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_BTC2  0x00000004 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_BTC3  0x00000008 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_BTC4  0x00000010 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_BTC5  0x00000020 // Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_CBTC0 0x00000100 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_CBTC1 0x00000200 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_CBTC2 0x00000400 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_CBTC3 0x00000800 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_CBTC4 0x00001000 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_CBTC5 0x00002000 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCIMR_ERR0  0x00010000 // Access Error [5:0]
#define DMAC_EBCIMR_ERR1  0x00020000 // Access Error [5:0]
#define DMAC_EBCIMR_ERR2  0x00040000 // Access Error [5:0]
#define DMAC_EBCIMR_ERR3  0x00080000 // Access Error [5:0]
#define DMAC_EBCIMR_ERR4  0x00100000 // Access Error [5:0]
#define DMAC_EBCIMR_ERR5  0x00200000 // Access Error [5:0]

#define DMAC_EBCISR_BTC0  0x00000001 // Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_BTC1  0x00000002 // Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_BTC2  0x00000004 // Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_BTC3  0x00000008 // Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_BTC4  0x00000010 // Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_BTC5  0x00000020 // Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_CBTC0 0x00000100 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_CBTC1 0x00000200 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_CBTC2 0x00000400 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_CBTC3 0x00000800 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_CBTC4 0x00001000 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_CBTC5 0x00002000 // Chained Buffer Transfer Completed [5:0]
#define DMAC_EBCISR_ERR0  0x00010000 // Access Error [5:0]
#define DMAC_EBCISR_ERR1  0x00020000 // Access Error [5:0]
#define DMAC_EBCISR_ERR2  0x00040000 // Access Error [5:0]
#define DMAC_EBCISR_ERR3  0x00080000 // Access Error [5:0]
#define DMAC_EBCISR_ERR4  0x00100000 // Access Error [5:0]
#define DMAC_EBCISR_ERR5  0x00200000 // Access Error [5:0]

#define DMAC_CHER_ENA0  0x00000001 // Enable [5:0]
#define DMAC_CHER_ENA1  0x00000002 // Enable [5:0]
#define DMAC_CHER_ENA2  0x00000004 // Enable [5:0]
#define DMAC_CHER_ENA3  0x00000008 // Enable [5:0]
#define DMAC_CHER_ENA4  0x00000010 // Enable [5:0]
#define DMAC_CHER_ENA5  0x00000020 // Enable [5:0]
#define DMAC_CHER_SUSP0 0x00000100 // Suspend [5:0]
#define DMAC_CHER_SUSP1 0x00000200 // Suspend [5:0]
#define DMAC_CHER_SUSP2 0x00000400 // Suspend [5:0]
#define DMAC_CHER_SUSP3 0x00000800 // Suspend [5:0]
#define DMAC_CHER_SUSP4 0x00001000 // Suspend [5:0]
#define DMAC_CHER_SUSP5 0x00002000 // Suspend [5:0]
#define DMAC_CHER_KEEP0 0x01000000 // Keep on [5:0]
#define DMAC_CHER_KEEP1 0x02000000 // Keep on [5:0]
#define DMAC_CHER_KEEP2 0x04000000 // Keep on [5:0]
#define DMAC_CHER_KEEP3 0x08000000 // Keep on [5:0]
#define DMAC_CHER_KEEP4 0x10000000 // Keep on [5:0]
#define DMAC_CHER_KEEP5 0x20000000 // Keep on [5:0]

#define DMAC_CHDR_DIS0 0x00000001 // Disable [5:0]
#define DMAC_CHDR_DIS1 0x00000002 // Disable [5:0]
#define DMAC_CHDR_DIS2 0x00000004 // Disable [5:0]
#define DMAC_CHDR_DIS3 0x00000008 // Disable [5:0]
#define DMAC_CHDR_DIS4 0x00000010 // Disable [5:0]
#define DMAC_CHDR_DIS5 0x00000020 // Disable [5:0]
#define DMAC_CHDR_RES0 0x00000100 // Resume [5:0]
#define DMAC_CHDR_RES1 0x00000200 // Resume [5:0]
#define DMAC_CHDR_RES2 0x00000400 // Resume [5:0]
#define DMAC_CHDR_RES3 0x00000800 // Resume [5:0]
#define DMAC_CHDR_RES4 0x00001000 // Resume [5:0]
#define DMAC_CHDR_RES5 0x00002000 // Resume [5:0]

#define DMAC_CHSR_ENA0  0x00000001 // Enable [5:0]
#define DMAC_CHSR_ENA1  0x00000002 // Enable [5:0]
#define DMAC_CHSR_ENA2  0x00000004 // Enable [5:0]
#define DMAC_CHSR_ENA3  0x00000008 // Enable [5:0]
#define DMAC_CHSR_ENA4  0x00000010 // Enable [5:0]
#define DMAC_CHSR_ENA5  0x00000020 // Enable [5:0]
#define DMAC_CHSR_SUSP0 0x00000100 // Suspend [5:0]
#define DMAC_CHSR_SUSP1 0x00000200 // Suspend [5:0]
#define DMAC_CHSR_SUSP2 0x00000400 // Suspend [5:0]
#define DMAC_CHSR_SUSP3 0x00000800 // Suspend [5:0]
#define DMAC_CHSR_SUSP4 0x00001000 // Suspend [5:0]
#define DMAC_CHSR_SUSP5 0x00002000 // Suspend [5:0]
#define DMAC_CHSR_EMPT0 0x00010000 // Empty [5:0]
#define DMAC_CHSR_EMPT1 0x00020000 // Empty [5:0]
#define DMAC_CHSR_EMPT2 0x00040000 // Empty [5:0]
#define DMAC_CHSR_EMPT3 0x00080000 // Empty [5:0]
#define DMAC_CHSR_EMPT4 0x00100000 // Empty [5:0]
#define DMAC_CHSR_EMPT5 0x00200000 // Empty [5:0]
#define DMAC_CHSR_STAL0 0x01000000 // Stalled [5:0]
#define DMAC_CHSR_STAL1 0x02000000 // Stalled [5:0]
#define DMAC_CHSR_STAL2 0x04000000 // Stalled [5:0]
#define DMAC_CHSR_STAL3 0x08000000 // Stalled [5:0]
#define DMAC_CHSR_STAL4 0x10000000 // Stalled [5:0]
#define DMAC_CHSR_STAL5 0x20000000 // Stalled [5:0]

#define DMAC_SADDR0_SADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Source Address

#define DMAC_DADDR0_DADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Destination Address

#define DMAC_DSCR0_DSCR(value) (((value) & 0x3FFFFFFF) << 2) // Buffer Transfer Descriptor Address

#define DMAC_CTRLA0_BTSIZE(value)       (((value) & 0xFFFF) << 0) // Buffer Transfer Size
#define DMAC_CTRLA0_SCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA0_SCSIZE_CHK_4        0x00010000                // 4 data transferred
#define DMAC_CTRLA0_SCSIZE_CHK_8        0x00020000                // 8 data transferred
#define DMAC_CTRLA0_SCSIZE_CHK_16       0x00030000                // 16 data transferred
#define DMAC_CTRLA0_DCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA0_DCSIZE_CHK_4        0x00100000                // 4 data transferred
#define DMAC_CTRLA0_DCSIZE_CHK_8        0x00200000                // 8 data transferred
#define DMAC_CTRLA0_DCSIZE_CHK_16       0x00300000                // 16 data transferred
#define DMAC_CTRLA0_SRC_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA0_SRC_WIDTH_HALF_WORD 0x01000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA0_SRC_WIDTH_WORD      0x02000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA0_DST_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA0_DST_WIDTH_HALF_WORD 0x10000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA0_DST_WIDTH_WORD      0x20000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA0_DONE                0x80000000                // Current Descriptor Stop Command and Transfer Completed Memory Indicator

#define DMAC_CTRLB0_SRC_DSCR_FETCH_FROM_MEM 0x00000000 // Source address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB0_SRC_DSCR_FETCH_DISABLE  0x00010000 // Buffer Descriptor Fetch operation is disabled for the source
#define DMAC_CTRLB0_DST_DSCR_FETCH_FROM_MEM 0x00000000 // Destination address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB0_DST_DSCR_FETCH_DISABLE  0x00100000 // Buffer Descriptor Fetch operation is disabled for the destination
#define DMAC_CTRLB0_FC_MEM2MEM_DMA_FC       0x00000000 // Memory-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB0_FC_MEM2PER_DMA_FC       0x00200000 // Memory-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB0_FC_PER2MEM_DMA_FC       0x00400000 // Peripheral-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB0_FC_PER2PER_DMA_FC       0x00600000 // Peripheral-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB0_SRC_INCR_INCREMENTING   0x00000000 // The source address is incremented
#define DMAC_CTRLB0_SRC_INCR_DECREMENTING   0x01000000 // The source address is decremented
#define DMAC_CTRLB0_SRC_INCR_FIXED          0x02000000 // The source address remains unchanged
#define DMAC_CTRLB0_DST_INCR_INCREMENTING   0x00000000 // The destination address is incremented
#define DMAC_CTRLB0_DST_INCR_DECREMENTING   0x10000000 // The destination address is decremented
#define DMAC_CTRLB0_DST_INCR_FIXED          0x20000000 // The destination address remains unchanged
#define DMAC_CTRLB0_IEN                     0x40000000 // Interrupt Enable Not

#define DMAC_CFG0_SRC_PER(value)   (((value) & 0xF) << 0)  // Source with Peripheral identifier
#define DMAC_CFG0_DST_PER(value)   (((value) & 0xF) << 4)  // Destination with Peripheral identifier
#define DMAC_CFG0_SRC_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG0_SRC_H2SEL_HW     0x00000200              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG0_DST_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG0_DST_H2SEL_HW     0x00002000              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG0_SOD_DISABLE      0x00000000              // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register
#define DMAC_CFG0_SOD_ENABLE       0x00010000              // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1
#define DMAC_CFG0_LOCK_IF_DISABLE  0x00000000              // Interface Lock capability is disabled
#define DMAC_CFG0_LOCK_IF_ENABLE   0x00100000              // Interface Lock capability is enabled
#define DMAC_CFG0_LOCK_B_DISABLE   0x00000000              // AHB Bus Locking capability is disabled
#define DMAC_CFG0_LOCK_IF_L_CHUNK  0x00000000              // The Master Interface Arbiter is locked by the channel x for a chunk transfer
#define DMAC_CFG0_LOCK_IF_L_BUFFER 0x00400000              // The Master Interface Arbiter is locked by the channel x for a buffer transfer
#define DMAC_CFG0_AHB_PROT(value)  (((value) & 0x7) << 24) // AHB Protection
#define DMAC_CFG0_FIFOCFG_ALAP_CFG 0x00000000              // The largest defined length AHB burst is performed on the destination AHB interface
#define DMAC_CFG0_FIFOCFG_HALF_CFG 0x10000000              // When half FIFO size is available/filled, a source/destination request is serviced
#define DMAC_CFG0_FIFOCFG_ASAP_CFG 0x20000000              // When there is enough space/data available to perform a single AHB access, then the request is serviced

#define DMAC_SADDR1_SADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Source Address

#define DMAC_DADDR1_DADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Destination Address

#define DMAC_DSCR1_DSCR(value) (((value) & 0x3FFFFFFF) << 2) // Buffer Transfer Descriptor Address

#define DMAC_CTRLA1_BTSIZE(value)       (((value) & 0xFFFF) << 0) // Buffer Transfer Size
#define DMAC_CTRLA1_SCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA1_SCSIZE_CHK_4        0x00010000                // 4 data transferred
#define DMAC_CTRLA1_SCSIZE_CHK_8        0x00020000                // 8 data transferred
#define DMAC_CTRLA1_SCSIZE_CHK_16       0x00030000                // 16 data transferred
#define DMAC_CTRLA1_DCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA1_DCSIZE_CHK_4        0x00100000                // 4 data transferred
#define DMAC_CTRLA1_DCSIZE_CHK_8        0x00200000                // 8 data transferred
#define DMAC_CTRLA1_DCSIZE_CHK_16       0x00300000                // 16 data transferred
#define DMAC_CTRLA1_SRC_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA1_SRC_WIDTH_HALF_WORD 0x01000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA1_SRC_WIDTH_WORD      0x02000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA1_DST_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA1_DST_WIDTH_HALF_WORD 0x10000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA1_DST_WIDTH_WORD      0x20000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA1_DONE                0x80000000                // Current Descriptor Stop Command and Transfer Completed Memory Indicator

#define DMAC_CTRLB1_SRC_DSCR_FETCH_FROM_MEM 0x00000000 // Source address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB1_SRC_DSCR_FETCH_DISABLE  0x00010000 // Buffer Descriptor Fetch operation is disabled for the source
#define DMAC_CTRLB1_DST_DSCR_FETCH_FROM_MEM 0x00000000 // Destination address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB1_DST_DSCR_FETCH_DISABLE  0x00100000 // Buffer Descriptor Fetch operation is disabled for the destination
#define DMAC_CTRLB1_FC_MEM2MEM_DMA_FC       0x00000000 // Memory-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB1_FC_MEM2PER_DMA_FC       0x00200000 // Memory-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB1_FC_PER2MEM_DMA_FC       0x00400000 // Peripheral-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB1_FC_PER2PER_DMA_FC       0x00600000 // Peripheral-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB1_SRC_INCR_INCREMENTING   0x00000000 // The source address is incremented
#define DMAC_CTRLB1_SRC_INCR_DECREMENTING   0x01000000 // The source address is decremented
#define DMAC_CTRLB1_SRC_INCR_FIXED          0x02000000 // The source address remains unchanged
#define DMAC_CTRLB1_DST_INCR_INCREMENTING   0x00000000 // The destination address is incremented
#define DMAC_CTRLB1_DST_INCR_DECREMENTING   0x10000000 // The destination address is decremented
#define DMAC_CTRLB1_DST_INCR_FIXED          0x20000000 // The destination address remains unchanged
#define DMAC_CTRLB1_IEN                     0x40000000 // Interrupt Enable Not

#define DMAC_CFG1_SRC_PER(value)   (((value) & 0xF) << 0)  // Source with Peripheral identifier
#define DMAC_CFG1_DST_PER(value)   (((value) & 0xF) << 4)  // Destination with Peripheral identifier
#define DMAC_CFG1_SRC_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG1_SRC_H2SEL_HW     0x00000200              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG1_DST_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG1_DST_H2SEL_HW     0x00002000              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG1_SOD_DISABLE      0x00000000              // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register
#define DMAC_CFG1_SOD_ENABLE       0x00010000              // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1
#define DMAC_CFG1_LOCK_IF_DISABLE  0x00000000              // Interface Lock capability is disabled
#define DMAC_CFG1_LOCK_IF_ENABLE   0x00100000              // Interface Lock capability is enabled
#define DMAC_CFG1_LOCK_B_DISABLE   0x00000000              // AHB Bus Locking capability is disabled
#define DMAC_CFG1_LOCK_IF_L_CHUNK  0x00000000              // The Master Interface Arbiter is locked by the channel x for a chunk transfer
#define DMAC_CFG1_LOCK_IF_L_BUFFER 0x00400000              // The Master Interface Arbiter is locked by the channel x for a buffer transfer
#define DMAC_CFG1_AHB_PROT(value)  (((value) & 0x7) << 24) // AHB Protection
#define DMAC_CFG1_FIFOCFG_ALAP_CFG 0x00000000              // The largest defined length AHB burst is performed on the destination AHB interface
#define DMAC_CFG1_FIFOCFG_HALF_CFG 0x10000000              // When half FIFO size is available/filled, a source/destination request is serviced
#define DMAC_CFG1_FIFOCFG_ASAP_CFG 0x20000000              // When there is enough space/data available to perform a single AHB access, then the request is serviced

#define DMAC_SADDR2_SADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Source Address

#define DMAC_DADDR2_DADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Destination Address

#define DMAC_DSCR2_DSCR(value) (((value) & 0x3FFFFFFF) << 2) // Buffer Transfer Descriptor Address

#define DMAC_CTRLA2_BTSIZE(value)       (((value) & 0xFFFF) << 0) // Buffer Transfer Size
#define DMAC_CTRLA2_SCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA2_SCSIZE_CHK_4        0x00010000                // 4 data transferred
#define DMAC_CTRLA2_SCSIZE_CHK_8        0x00020000                // 8 data transferred
#define DMAC_CTRLA2_SCSIZE_CHK_16       0x00030000                // 16 data transferred
#define DMAC_CTRLA2_DCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA2_DCSIZE_CHK_4        0x00100000                // 4 data transferred
#define DMAC_CTRLA2_DCSIZE_CHK_8        0x00200000                // 8 data transferred
#define DMAC_CTRLA2_DCSIZE_CHK_16       0x00300000                // 16 data transferred
#define DMAC_CTRLA2_SRC_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA2_SRC_WIDTH_HALF_WORD 0x01000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA2_SRC_WIDTH_WORD      0x02000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA2_DST_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA2_DST_WIDTH_HALF_WORD 0x10000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA2_DST_WIDTH_WORD      0x20000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA2_DONE                0x80000000                // Current Descriptor Stop Command and Transfer Completed Memory Indicator

#define DMAC_CTRLB2_SRC_DSCR_FETCH_FROM_MEM 0x00000000 // Source address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB2_SRC_DSCR_FETCH_DISABLE  0x00010000 // Buffer Descriptor Fetch operation is disabled for the source
#define DMAC_CTRLB2_DST_DSCR_FETCH_FROM_MEM 0x00000000 // Destination address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB2_DST_DSCR_FETCH_DISABLE  0x00100000 // Buffer Descriptor Fetch operation is disabled for the destination
#define DMAC_CTRLB2_FC_MEM2MEM_DMA_FC       0x00000000 // Memory-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB2_FC_MEM2PER_DMA_FC       0x00200000 // Memory-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB2_FC_PER2MEM_DMA_FC       0x00400000 // Peripheral-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB2_FC_PER2PER_DMA_FC       0x00600000 // Peripheral-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB2_SRC_INCR_INCREMENTING   0x00000000 // The source address is incremented
#define DMAC_CTRLB2_SRC_INCR_DECREMENTING   0x01000000 // The source address is decremented
#define DMAC_CTRLB2_SRC_INCR_FIXED          0x02000000 // The source address remains unchanged
#define DMAC_CTRLB2_DST_INCR_INCREMENTING   0x00000000 // The destination address is incremented
#define DMAC_CTRLB2_DST_INCR_DECREMENTING   0x10000000 // The destination address is decremented
#define DMAC_CTRLB2_DST_INCR_FIXED          0x20000000 // The destination address remains unchanged
#define DMAC_CTRLB2_IEN                     0x40000000 // Interrupt Enable Not

#define DMAC_CFG2_SRC_PER(value)   (((value) & 0xF) << 0)  // Source with Peripheral identifier
#define DMAC_CFG2_DST_PER(value)   (((value) & 0xF) << 4)  // Destination with Peripheral identifier
#define DMAC_CFG2_SRC_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG2_SRC_H2SEL_HW     0x00000200              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG2_DST_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG2_DST_H2SEL_HW     0x00002000              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG2_SOD_DISABLE      0x00000000              // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register
#define DMAC_CFG2_SOD_ENABLE       0x00010000              // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1
#define DMAC_CFG2_LOCK_IF_DISABLE  0x00000000              // Interface Lock capability is disabled
#define DMAC_CFG2_LOCK_IF_ENABLE   0x00100000              // Interface Lock capability is enabled
#define DMAC_CFG2_LOCK_B_DISABLE   0x00000000              // AHB Bus Locking capability is disabled
#define DMAC_CFG2_LOCK_IF_L_CHUNK  0x00000000              // The Master Interface Arbiter is locked by the channel x for a chunk transfer
#define DMAC_CFG2_LOCK_IF_L_BUFFER 0x00400000              // The Master Interface Arbiter is locked by the channel x for a buffer transfer
#define DMAC_CFG2_AHB_PROT(value)  (((value) & 0x7) << 24) // AHB Protection
#define DMAC_CFG2_FIFOCFG_ALAP_CFG 0x00000000              // The largest defined length AHB burst is performed on the destination AHB interface
#define DMAC_CFG2_FIFOCFG_HALF_CFG 0x10000000              // When half FIFO size is available/filled, a source/destination request is serviced
#define DMAC_CFG2_FIFOCFG_ASAP_CFG 0x20000000              // When there is enough space/data available to perform a single AHB access, then the request is serviced

#define DMAC_SADDR3_SADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Source Address

#define DMAC_DADDR3_DADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Destination Address

#define DMAC_DSCR3_DSCR(value) (((value) & 0x3FFFFFFF) << 2) // Buffer Transfer Descriptor Address

#define DMAC_CTRLA3_BTSIZE(value)       (((value) & 0xFFFF) << 0) // Buffer Transfer Size
#define DMAC_CTRLA3_SCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA3_SCSIZE_CHK_4        0x00010000                // 4 data transferred
#define DMAC_CTRLA3_SCSIZE_CHK_8        0x00020000                // 8 data transferred
#define DMAC_CTRLA3_SCSIZE_CHK_16       0x00030000                // 16 data transferred
#define DMAC_CTRLA3_DCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA3_DCSIZE_CHK_4        0x00100000                // 4 data transferred
#define DMAC_CTRLA3_DCSIZE_CHK_8        0x00200000                // 8 data transferred
#define DMAC_CTRLA3_DCSIZE_CHK_16       0x00300000                // 16 data transferred
#define DMAC_CTRLA3_SRC_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA3_SRC_WIDTH_HALF_WORD 0x01000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA3_SRC_WIDTH_WORD      0x02000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA3_DST_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA3_DST_WIDTH_HALF_WORD 0x10000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA3_DST_WIDTH_WORD      0x20000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA3_DONE                0x80000000                // Current Descriptor Stop Command and Transfer Completed Memory Indicator

#define DMAC_CTRLB3_SRC_DSCR_FETCH_FROM_MEM 0x00000000 // Source address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB3_SRC_DSCR_FETCH_DISABLE  0x00010000 // Buffer Descriptor Fetch operation is disabled for the source
#define DMAC_CTRLB3_DST_DSCR_FETCH_FROM_MEM 0x00000000 // Destination address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB3_DST_DSCR_FETCH_DISABLE  0x00100000 // Buffer Descriptor Fetch operation is disabled for the destination
#define DMAC_CTRLB3_FC_MEM2MEM_DMA_FC       0x00000000 // Memory-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB3_FC_MEM2PER_DMA_FC       0x00200000 // Memory-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB3_FC_PER2MEM_DMA_FC       0x00400000 // Peripheral-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB3_FC_PER2PER_DMA_FC       0x00600000 // Peripheral-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB3_SRC_INCR_INCREMENTING   0x00000000 // The source address is incremented
#define DMAC_CTRLB3_SRC_INCR_DECREMENTING   0x01000000 // The source address is decremented
#define DMAC_CTRLB3_SRC_INCR_FIXED          0x02000000 // The source address remains unchanged
#define DMAC_CTRLB3_DST_INCR_INCREMENTING   0x00000000 // The destination address is incremented
#define DMAC_CTRLB3_DST_INCR_DECREMENTING   0x10000000 // The destination address is decremented
#define DMAC_CTRLB3_DST_INCR_FIXED          0x20000000 // The destination address remains unchanged
#define DMAC_CTRLB3_IEN                     0x40000000 // Interrupt Enable Not

#define DMAC_CFG3_SRC_PER(value)   (((value) & 0xF) << 0)  // Source with Peripheral identifier
#define DMAC_CFG3_DST_PER(value)   (((value) & 0xF) << 4)  // Destination with Peripheral identifier
#define DMAC_CFG3_SRC_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG3_SRC_H2SEL_HW     0x00000200              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG3_DST_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG3_DST_H2SEL_HW     0x00002000              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG3_SOD_DISABLE      0x00000000              // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register
#define DMAC_CFG3_SOD_ENABLE       0x00010000              // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1
#define DMAC_CFG3_LOCK_IF_DISABLE  0x00000000              // Interface Lock capability is disabled
#define DMAC_CFG3_LOCK_IF_ENABLE   0x00100000              // Interface Lock capability is enabled
#define DMAC_CFG3_LOCK_B_DISABLE   0x00000000              // AHB Bus Locking capability is disabled
#define DMAC_CFG3_LOCK_IF_L_CHUNK  0x00000000              // The Master Interface Arbiter is locked by the channel x for a chunk transfer
#define DMAC_CFG3_LOCK_IF_L_BUFFER 0x00400000              // The Master Interface Arbiter is locked by the channel x for a buffer transfer
#define DMAC_CFG3_AHB_PROT(value)  (((value) & 0x7) << 24) // AHB Protection
#define DMAC_CFG3_FIFOCFG_ALAP_CFG 0x00000000              // The largest defined length AHB burst is performed on the destination AHB interface
#define DMAC_CFG3_FIFOCFG_HALF_CFG 0x10000000              // When half FIFO size is available/filled, a source/destination request is serviced
#define DMAC_CFG3_FIFOCFG_ASAP_CFG 0x20000000              // When there is enough space/data available to perform a single AHB access, then the request is serviced

#define DMAC_SADDR4_SADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Source Address

#define DMAC_DADDR4_DADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Destination Address

#define DMAC_DSCR4_DSCR(value) (((value) & 0x3FFFFFFF) << 2) // Buffer Transfer Descriptor Address

#define DMAC_CTRLA4_BTSIZE(value)       (((value) & 0xFFFF) << 0) // Buffer Transfer Size
#define DMAC_CTRLA4_SCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA4_SCSIZE_CHK_4        0x00010000                // 4 data transferred
#define DMAC_CTRLA4_SCSIZE_CHK_8        0x00020000                // 8 data transferred
#define DMAC_CTRLA4_SCSIZE_CHK_16       0x00030000                // 16 data transferred
#define DMAC_CTRLA4_DCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA4_DCSIZE_CHK_4        0x00100000                // 4 data transferred
#define DMAC_CTRLA4_DCSIZE_CHK_8        0x00200000                // 8 data transferred
#define DMAC_CTRLA4_DCSIZE_CHK_16       0x00300000                // 16 data transferred
#define DMAC_CTRLA4_SRC_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA4_SRC_WIDTH_HALF_WORD 0x01000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA4_SRC_WIDTH_WORD      0x02000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA4_DST_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA4_DST_WIDTH_HALF_WORD 0x10000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA4_DST_WIDTH_WORD      0x20000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA4_DONE                0x80000000                // Current Descriptor Stop Command and Transfer Completed Memory Indicator

#define DMAC_CTRLB4_SRC_DSCR_FETCH_FROM_MEM 0x00000000 // Source address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB4_SRC_DSCR_FETCH_DISABLE  0x00010000 // Buffer Descriptor Fetch operation is disabled for the source
#define DMAC_CTRLB4_DST_DSCR_FETCH_FROM_MEM 0x00000000 // Destination address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB4_DST_DSCR_FETCH_DISABLE  0x00100000 // Buffer Descriptor Fetch operation is disabled for the destination
#define DMAC_CTRLB4_FC_MEM2MEM_DMA_FC       0x00000000 // Memory-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB4_FC_MEM2PER_DMA_FC       0x00200000 // Memory-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB4_FC_PER2MEM_DMA_FC       0x00400000 // Peripheral-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB4_FC_PER2PER_DMA_FC       0x00600000 // Peripheral-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB4_SRC_INCR_INCREMENTING   0x00000000 // The source address is incremented
#define DMAC_CTRLB4_SRC_INCR_DECREMENTING   0x01000000 // The source address is decremented
#define DMAC_CTRLB4_SRC_INCR_FIXED          0x02000000 // The source address remains unchanged
#define DMAC_CTRLB4_DST_INCR_INCREMENTING   0x00000000 // The destination address is incremented
#define DMAC_CTRLB4_DST_INCR_DECREMENTING   0x10000000 // The destination address is decremented
#define DMAC_CTRLB4_DST_INCR_FIXED          0x20000000 // The destination address remains unchanged
#define DMAC_CTRLB4_IEN                     0x40000000 // Interrupt Enable Not

#define DMAC_CFG4_SRC_PER(value)   (((value) & 0xF) << 0)  // Source with Peripheral identifier
#define DMAC_CFG4_DST_PER(value)   (((value) & 0xF) << 4)  // Destination with Peripheral identifier
#define DMAC_CFG4_SRC_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG4_SRC_H2SEL_HW     0x00000200              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG4_DST_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG4_DST_H2SEL_HW     0x00002000              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG4_SOD_DISABLE      0x00000000              // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register
#define DMAC_CFG4_SOD_ENABLE       0x00010000              // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1
#define DMAC_CFG4_LOCK_IF_DISABLE  0x00000000              // Interface Lock capability is disabled
#define DMAC_CFG4_LOCK_IF_ENABLE   0x00100000              // Interface Lock capability is enabled
#define DMAC_CFG4_LOCK_B_DISABLE   0x00000000              // AHB Bus Locking capability is disabled
#define DMAC_CFG4_LOCK_IF_L_CHUNK  0x00000000              // The Master Interface Arbiter is locked by the channel x for a chunk transfer
#define DMAC_CFG4_LOCK_IF_L_BUFFER 0x00400000              // The Master Interface Arbiter is locked by the channel x for a buffer transfer
#define DMAC_CFG4_AHB_PROT(value)  (((value) & 0x7) << 24) // AHB Protection
#define DMAC_CFG4_FIFOCFG_ALAP_CFG 0x00000000              // The largest defined length AHB burst is performed on the destination AHB interface
#define DMAC_CFG4_FIFOCFG_HALF_CFG 0x10000000              // When half FIFO size is available/filled, a source/destination request is serviced
#define DMAC_CFG4_FIFOCFG_ASAP_CFG 0x20000000              // When there is enough space/data available to perform a single AHB access, then the request is serviced

#define DMAC_SADDR5_SADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Source Address

#define DMAC_DADDR5_DADDR(value) (((value) & 0xFFFFFFFF) << 0) // Channel x Destination Address

#define DMAC_DSCR5_DSCR(value) (((value) & 0x3FFFFFFF) << 2) // Buffer Transfer Descriptor Address

#define DMAC_CTRLA5_BTSIZE(value)       (((value) & 0xFFFF) << 0) // Buffer Transfer Size
#define DMAC_CTRLA5_SCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA5_SCSIZE_CHK_4        0x00010000                // 4 data transferred
#define DMAC_CTRLA5_SCSIZE_CHK_8        0x00020000                // 8 data transferred
#define DMAC_CTRLA5_SCSIZE_CHK_16       0x00030000                // 16 data transferred
#define DMAC_CTRLA5_DCSIZE_CHK_1        0x00000000                // 1 data transferred
#define DMAC_CTRLA5_DCSIZE_CHK_4        0x00100000                // 4 data transferred
#define DMAC_CTRLA5_DCSIZE_CHK_8        0x00200000                // 8 data transferred
#define DMAC_CTRLA5_DCSIZE_CHK_16       0x00300000                // 16 data transferred
#define DMAC_CTRLA5_SRC_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA5_SRC_WIDTH_HALF_WORD 0x01000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA5_SRC_WIDTH_WORD      0x02000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA5_DST_WIDTH_BYTE      0x00000000                // the transfer size is set to 8-bit width
#define DMAC_CTRLA5_DST_WIDTH_HALF_WORD 0x10000000                // the transfer size is set to 16-bit width
#define DMAC_CTRLA5_DST_WIDTH_WORD      0x20000000                // the transfer size is set to 32-bit width
#define DMAC_CTRLA5_DONE                0x80000000                // Current Descriptor Stop Command and Transfer Completed Memory Indicator

#define DMAC_CTRLB5_SRC_DSCR_FETCH_FROM_MEM 0x00000000 // Source address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB5_SRC_DSCR_FETCH_DISABLE  0x00010000 // Buffer Descriptor Fetch operation is disabled for the source
#define DMAC_CTRLB5_DST_DSCR_FETCH_FROM_MEM 0x00000000 // Destination address is updated when the descriptor is fetched from the memory
#define DMAC_CTRLB5_DST_DSCR_FETCH_DISABLE  0x00100000 // Buffer Descriptor Fetch operation is disabled for the destination
#define DMAC_CTRLB5_FC_MEM2MEM_DMA_FC       0x00000000 // Memory-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB5_FC_MEM2PER_DMA_FC       0x00200000 // Memory-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB5_FC_PER2MEM_DMA_FC       0x00400000 // Peripheral-to-Memory Transfer DMAC is flow controller
#define DMAC_CTRLB5_FC_PER2PER_DMA_FC       0x00600000 // Peripheral-to-Peripheral Transfer DMAC is flow controller
#define DMAC_CTRLB5_SRC_INCR_INCREMENTING   0x00000000 // The source address is incremented
#define DMAC_CTRLB5_SRC_INCR_DECREMENTING   0x01000000 // The source address is decremented
#define DMAC_CTRLB5_SRC_INCR_FIXED          0x02000000 // The source address remains unchanged
#define DMAC_CTRLB5_DST_INCR_INCREMENTING   0x00000000 // The destination address is incremented
#define DMAC_CTRLB5_DST_INCR_DECREMENTING   0x10000000 // The destination address is decremented
#define DMAC_CTRLB5_DST_INCR_FIXED          0x20000000 // The destination address remains unchanged
#define DMAC_CTRLB5_IEN                     0x40000000 // Interrupt Enable Not

#define DMAC_CFG5_SRC_PER(value)   (((value) & 0xF) << 0)  // Source with Peripheral identifier
#define DMAC_CFG5_DST_PER(value)   (((value) & 0xF) << 4)  // Destination with Peripheral identifier
#define DMAC_CFG5_SRC_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG5_SRC_H2SEL_HW     0x00000200              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG5_DST_H2SEL_SW     0x00000000              // Software handshaking interface is used to trigger a transfer request
#define DMAC_CFG5_DST_H2SEL_HW     0x00002000              // Hardware handshaking interface is used to trigger a transfer request
#define DMAC_CFG5_SOD_DISABLE      0x00000000              // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register
#define DMAC_CFG5_SOD_ENABLE       0x00010000              // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1
#define DMAC_CFG5_LOCK_IF_DISABLE  0x00000000              // Interface Lock capability is disabled
#define DMAC_CFG5_LOCK_IF_ENABLE   0x00100000              // Interface Lock capability is enabled
#define DMAC_CFG5_LOCK_B_DISABLE   0x00000000              // AHB Bus Locking capability is disabled
#define DMAC_CFG5_LOCK_IF_L_CHUNK  0x00000000              // The Master Interface Arbiter is locked by the channel x for a chunk transfer
#define DMAC_CFG5_LOCK_IF_L_BUFFER 0x00400000              // The Master Interface Arbiter is locked by the channel x for a buffer transfer
#define DMAC_CFG5_AHB_PROT(value)  (((value) & 0x7) << 24) // AHB Protection
#define DMAC_CFG5_FIFOCFG_ALAP_CFG 0x00000000              // The largest defined length AHB burst is performed on the destination AHB interface
#define DMAC_CFG5_FIFOCFG_HALF_CFG 0x10000000              // When half FIFO size is available/filled, a source/destination request is serviced
#define DMAC_CFG5_FIFOCFG_ASAP_CFG 0x20000000              // When there is enough space/data available to perform a single AHB access, then the request is serviced

#define DMAC_WPMR_WPEN         0x00000001 // Write Protect Enable
#define DMAC_WPMR_WPKEY_PASSWD 0x444D4100 // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0

#define DMAC_WPSR_WPVS          0x00000001                // Write Protect Violation Status
#define DMAC_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protect Violation Source

#define DACC_CR   (*(volatile unsigned int *)0x400C8000)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1065603)
#define DACC_MR   (*(volatile unsigned int *)0x400C8004)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1065790)
#define DACC_CHER (*(volatile unsigned int *)0x400C8010)       // [Channel Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1066140)
#define DACC_CHDR (*(volatile unsigned int *)0x400C8014)       // [Channel Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1094775)
#define DACC_CHSR (*(const volatile unsigned int *)0x400C8018) // [Channel Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1066509)
#define DACC_CDR  (*(volatile unsigned int *)0x400C8020)       // [Conversion Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1123870)
#define DACC_IER  (*(volatile unsigned int *)0x400C8024)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1066883)
#define DACC_IDR  (*(volatile unsigned int *)0x400C8028)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1067071)
#define DACC_IMR  (*(const volatile unsigned int *)0x400C802C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1125408)
#define DACC_ISR  (*(const volatile unsigned int *)0x400C8030) // [Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1122025)
#define DACC_ACR  (*(volatile unsigned int *)0x400C8094)       // [Analog Current Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1125650)
#define DACC_WPMR (*(volatile unsigned int *)0x400C80E4)       // [Write Protect Mode register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1123029)
#define DACC_WPSR (*(const volatile unsigned int *)0x400C80E8) // [Write Protect Status register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G35.1123605)
#define DACC_TPR  (*(volatile unsigned int *)0x400C8108)       // [Transmit Pointer Register]()
#define DACC_TCR  (*(volatile unsigned int *)0x400C810C)       // [Transmit Counter Register]()
#define DACC_TNPR (*(volatile unsigned int *)0x400C8118)       // [Transmit Next Pointer Register]()
#define DACC_TNCR (*(volatile unsigned int *)0x400C811C)       // [Transmit Next Counter Register]()
#define DACC_PTCR (*(volatile unsigned int *)0x400C8120)       // [Transfer Control Register]()
#define DACC_PTSR (*(const volatile unsigned int *)0x400C8124) // [Transfer Status Register]()

#define DACC_CR_SWRST 0x00000001 // Software Reset

#define DACC_MR_TRGEN_DIS         0x00000000              // External trigger mode disabled. DACC in free running mode
#define DACC_MR_TRGEN_EN          0x00000001              // External trigger mode enabled
#define DACC_MR_TRGSEL(value)     (((value) & 0x7) << 1)  // Trigger Selection
#define DACC_MR_WORD_HALF         0x00000000              // Half-Word transfer
#define DACC_MR_WORD_WORD         0x00000010              // Word Transfer
#define DACC_MR_SLEEP             0x00000020              // Sleep Mode
#define DACC_MR_FASTWKUP          0x00000040              // Fast Wake up Mode
#define DACC_MR_REFRESH(value)    (((value) & 0xFF) << 8) // Refresh Period
#define DACC_MR_USER_SEL_CHANNEL0 0x00000000              // Channel 0
#define DACC_MR_USER_SEL_CHANNEL1 0x00010000              // Channel 1
#define DACC_MR_TAG_DIS           0x00000000              // Tag selection mode disabled. Using USER_SEL to select the channel for the conversion
#define DACC_MR_TAG_EN            0x00100000              // Tag selection mode enabled
#define DACC_MR_MAXS_NORMAL       0x00000000              // Normal Mode
#define DACC_MR_MAXS_MAXIMUM      0x00200000              // Max Speed Mode enabled
#define DACC_MR_STARTUP_0         0x00000000              // 0 periods of DACClock
#define DACC_MR_STARTUP_8         0x01000000              // 8 periods of DACClock
#define DACC_MR_STARTUP_16        0x02000000              // 16 periods of DACClock
#define DACC_MR_STARTUP_24        0x03000000              // 24 periods of DACClock
#define DACC_MR_STARTUP_64        0x04000000              // 64 periods of DACClock
#define DACC_MR_STARTUP_80        0x05000000              // 80 periods of DACClock
#define DACC_MR_STARTUP_96        0x06000000              // 96 periods of DACClock
#define DACC_MR_STARTUP_112       0x07000000              // 112 periods of DACClock
#define DACC_MR_STARTUP_512       0x08000000              // 512 periods of DACClock
#define DACC_MR_STARTUP_576       0x09000000              // 576 periods of DACClock
#define DACC_MR_STARTUP_640       0x0A000000              // 640 periods of DACClock
#define DACC_MR_STARTUP_704       0x0B000000              // 704 periods of DACClock
#define DACC_MR_STARTUP_768       0x0C000000              // 768 periods of DACClock
#define DACC_MR_STARTUP_832       0x0D000000              // 832 periods of DACClock
#define DACC_MR_STARTUP_896       0x0E000000              // 896 periods of DACClock
#define DACC_MR_STARTUP_960       0x0F000000              // 960 periods of DACClock
#define DACC_MR_STARTUP_1024      0x10000000              // 1024 periods of DACClock
#define DACC_MR_STARTUP_1088      0x11000000              // 1088 periods of DACClock
#define DACC_MR_STARTUP_1152      0x12000000              // 1152 periods of DACClock
#define DACC_MR_STARTUP_1216      0x13000000              // 1216 periods of DACClock
#define DACC_MR_STARTUP_1280      0x14000000              // 1280 periods of DACClock
#define DACC_MR_STARTUP_1344      0x15000000              // 1344 periods of DACClock
#define DACC_MR_STARTUP_1408      0x16000000              // 1408 periods of DACClock
#define DACC_MR_STARTUP_1472      0x17000000              // 1472 periods of DACClock
#define DACC_MR_STARTUP_1536      0x18000000              // 1536 periods of DACClock
#define DACC_MR_STARTUP_1600      0x19000000              // 1600 periods of DACClock
#define DACC_MR_STARTUP_1664      0x1A000000              // 1664 periods of DACClock
#define DACC_MR_STARTUP_1728      0x1B000000              // 1728 periods of DACClock
#define DACC_MR_STARTUP_1792      0x1C000000              // 1792 periods of DACClock
#define DACC_MR_STARTUP_1856      0x1D000000              // 1856 periods of DACClock
#define DACC_MR_STARTUP_1920      0x1E000000              // 1920 periods of DACClock
#define DACC_MR_STARTUP_1984      0x1F000000              // 1984 periods of DACClock

#define DACC_CHER_CH0 0x00000001 // Channel 0 Enable
#define DACC_CHER_CH1 0x00000002 // Channel 1 Enable

#define DACC_CHDR_CH0 0x00000001 // Channel 0 Disable
#define DACC_CHDR_CH1 0x00000002 // Channel 1 Disable

#define DACC_CHSR_CH0 0x00000001 // Channel 0 Status
#define DACC_CHSR_CH1 0x00000002 // Channel 1 Status

#define DACC_CDR_DATA(value) (((value) & 0xFFFFFFFF) << 0) // Data to Convert

#define DACC_IER_TXRDY  0x00000001 // Transmit Ready Interrupt Enable
#define DACC_IER_EOC    0x00000002 // End of Conversion Interrupt Enable
#define DACC_IER_ENDTX  0x00000004 // End of Transmit Buffer Interrupt Enable
#define DACC_IER_TXBUFE 0x00000008 // Transmit Buffer Empty Interrupt Enable

#define DACC_IDR_TXRDY  0x00000001 // Transmit Ready Interrupt Disable
#define DACC_IDR_EOC    0x00000002 // End of Conversion Interrupt Disable
#define DACC_IDR_ENDTX  0x00000004 // End of Transmit Buffer Interrupt Disable
#define DACC_IDR_TXBUFE 0x00000008 // Transmit Buffer Empty Interrupt Disable

#define DACC_IMR_TXRDY  0x00000001 // Transmit Ready Interrupt Mask
#define DACC_IMR_EOC    0x00000002 // End of Conversion Interrupt Mask
#define DACC_IMR_ENDTX  0x00000004 // End of Transmit Buffer Interrupt Mask
#define DACC_IMR_TXBUFE 0x00000008 // Transmit Buffer Empty Interrupt Mask

#define DACC_ISR_TXRDY  0x00000001 // Transmit Ready Interrupt Flag
#define DACC_ISR_EOC    0x00000002 // End of Conversion Interrupt Flag
#define DACC_ISR_ENDTX  0x00000004 // End of DMA Interrupt Flag
#define DACC_ISR_TXBUFE 0x00000008 // Transmit Buffer Empty

#define DACC_ACR_IBCTLCH0(value)     (((value) & 0x3) << 0) // Analog Output Current Control
#define DACC_ACR_IBCTLCH1(value)     (((value) & 0x3) << 2) // Analog Output Current Control
#define DACC_ACR_IBCTLDACCORE(value) (((value) & 0x3) << 8) // Bias Current Control for DAC Core

#define DACC_WPMR_WPEN         0x00000001                  // Write Protect Enable
#define DACC_WPMR_WPKEY(value) (((value) & 0xFFFFFF) << 8) // Write Protect KEY

#define DACC_WPSR_WPROTERR         0x00000001              // Write protection error
#define DACC_WPSR_WPROTADDR(value) (((value) & 0xFF) << 8) // Write protection error address

#define DACC_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define DACC_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define DACC_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define DACC_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define DACC_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define DACC_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define DACC_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define DACC_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define DACC_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define DACC_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define SMC_CFG      (*(volatile unsigned int *)0x400E0000)       // [SMC NFC Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1590817)
#define SMC_CTRL     (*(volatile unsigned int *)0x400E0004)       // [SMC NFC Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1126974)
#define SMC_SR       (*(const volatile unsigned int *)0x400E0008) // [SMC NFC Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1363092)
#define SMC_IER      (*(volatile unsigned int *)0x400E000C)       // [SMC NFC Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1363374)
#define SMC_IDR      (*(volatile unsigned int *)0x400E0010)       // [SMC NFC Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1378270)
#define SMC_IMR      (*(const volatile unsigned int *)0x400E0014) // [SMC NFC Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1377744)
#define SMC_ADDR     (*(volatile unsigned int *)0x400E0018)       // [SMC NFC Address Cycle Zero Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1378292)
#define SMC_BANK     (*(volatile unsigned int *)0x400E001C)       // [SMC Bank Address Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1397170)
#define SMC_ECC_CTRL (*(volatile unsigned int *)0x400E0020)       // [SMC ECC Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1402725)
#define SMC_ECC_MD   (*(volatile unsigned int *)0x400E0024)       // [SMC ECC Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1402994)
#define SMC_ECC_SR1  (*(const volatile unsigned int *)0x400E0028) // [SMC ECC Status 1 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1419185)
#define SMC_ECC_PR0  (*(const volatile unsigned int *)0x400E002C) // [SMC ECC Parity 0 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1379585)
#define SMC_ECC_PR1  (*(const volatile unsigned int *)0x400E0030) // [SMC ECC parity 1 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1664224)
#define SMC_ECC_SR2  (*(const volatile unsigned int *)0x400E0034) // [SMC ECC status 2 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1379346)
#define SMC_ECC_PR2  (*(const volatile unsigned int *)0x400E0038) // [SMC ECC parity 2 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1380990)
#define SMC_ECC_PR3  (*(const volatile unsigned int *)0x400E003C) // [SMC ECC parity 3 Register]()
#define SMC_ECC_PR4  (*(const volatile unsigned int *)0x400E0040) // [SMC ECC parity 4 Register]()
#define SMC_ECC_PR5  (*(const volatile unsigned int *)0x400E0044) // [SMC ECC parity 5 Register]()
#define SMC_ECC_PR6  (*(const volatile unsigned int *)0x400E0048) // [SMC ECC parity 6 Register]()
#define SMC_ECC_PR7  (*(const volatile unsigned int *)0x400E004C) // [SMC ECC parity 7 Register]()
#define SMC_ECC_PR8  (*(const volatile unsigned int *)0x400E0050) // [SMC ECC parity 8 Register]()
#define SMC_ECC_PR9  (*(const volatile unsigned int *)0x400E0054) // [SMC ECC parity 9 Register]()
#define SMC_ECC_PR10 (*(const volatile unsigned int *)0x400E0058) // [SMC ECC parity 10 Register]()
#define SMC_ECC_PR11 (*(const volatile unsigned int *)0x400E005C) // [SMC ECC parity 11 Register]()
#define SMC_ECC_PR12 (*(const volatile unsigned int *)0x400E0060) // [SMC ECC parity 12 Register]()
#define SMC_ECC_PR13 (*(const volatile unsigned int *)0x400E0064) // [SMC ECC parity 13 Register]()
#define SMC_ECC_PR14 (*(const volatile unsigned int *)0x400E0068) // [SMC ECC parity 14 Register]()
#define SMC_ECC_PR15 (*(const volatile unsigned int *)0x400E006C) // [SMC ECC parity 15 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1380990)
#define SMC_SETUP0   (*(volatile unsigned int *)0x400E0070)       // [SMC Setup Register (CS_number = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364169)
#define SMC_PULSE0   (*(volatile unsigned int *)0x400E0074)       // [SMC Pulse Register (CS_number = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364664)
#define SMC_CYCLE0   (*(volatile unsigned int *)0x400E0078)       // [SMC Cycle Register (CS_number = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364908)
#define SMC_TIMINGS0 (*(volatile unsigned int *)0x400E007C)       // [SMC Timings Register (CS_number = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1387154)
#define SMC_MODE0    (*(volatile unsigned int *)0x400E0080)       // [SMC Mode Register (CS_number = 0)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1376124)
#define SMC_SETUP1   (*(volatile unsigned int *)0x400E0084)       // [SMC Setup Register (CS_number = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364169)
#define SMC_PULSE1   (*(volatile unsigned int *)0x400E0088)       // [SMC Pulse Register (CS_number = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364664)
#define SMC_CYCLE1   (*(volatile unsigned int *)0x400E008C)       // [SMC Cycle Register (CS_number = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364908)
#define SMC_TIMINGS1 (*(volatile unsigned int *)0x400E0090)       // [SMC Timings Register (CS_number = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1387154)
#define SMC_MODE1    (*(volatile unsigned int *)0x400E0094)       // [SMC Mode Register (CS_number = 1)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1376124)
#define SMC_SETUP2   (*(volatile unsigned int *)0x400E0098)       // [SMC Setup Register (CS_number = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364169)
#define SMC_PULSE2   (*(volatile unsigned int *)0x400E009C)       // [SMC Pulse Register (CS_number = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364664)
#define SMC_CYCLE2   (*(volatile unsigned int *)0x400E00A0)       // [SMC Cycle Register (CS_number = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364908)
#define SMC_TIMINGS2 (*(volatile unsigned int *)0x400E00A4)       // [SMC Timings Register (CS_number = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1387154)
#define SMC_MODE2    (*(volatile unsigned int *)0x400E00A8)       // [SMC Mode Register (CS_number = 2)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1376124)
#define SMC_SETUP3   (*(volatile unsigned int *)0x400E00AC)       // [SMC Setup Register (CS_number = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364169)
#define SMC_PULSE3   (*(volatile unsigned int *)0x400E00B0)       // [SMC Pulse Register (CS_number = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364664)
#define SMC_CYCLE3   (*(volatile unsigned int *)0x400E00B4)       // [SMC Cycle Register (CS_number = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364908)
#define SMC_TIMINGS3 (*(volatile unsigned int *)0x400E00B8)       // [SMC Timings Register (CS_number = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1387154)
#define SMC_MODE3    (*(volatile unsigned int *)0x400E00BC)       // [SMC Mode Register (CS_number = 3)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1376124)
#define SMC_SETUP4   (*(volatile unsigned int *)0x400E00C0)       // [SMC Setup Register (CS_number = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364169)
#define SMC_PULSE4   (*(volatile unsigned int *)0x400E00C4)       // [SMC Pulse Register (CS_number = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364664)
#define SMC_CYCLE4   (*(volatile unsigned int *)0x400E00C8)       // [SMC Cycle Register (CS_number = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364908)
#define SMC_TIMINGS4 (*(volatile unsigned int *)0x400E00CC)       // [SMC Timings Register (CS_number = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1387154)
#define SMC_MODE4    (*(volatile unsigned int *)0x400E00D0)       // [SMC Mode Register (CS_number = 4)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1376124)
#define SMC_SETUP5   (*(volatile unsigned int *)0x400E00D4)       // [SMC Setup Register (CS_number = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364169)
#define SMC_PULSE5   (*(volatile unsigned int *)0x400E00D8)       // [SMC Pulse Register (CS_number = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364664)
#define SMC_CYCLE5   (*(volatile unsigned int *)0x400E00DC)       // [SMC Cycle Register (CS_number = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364908)
#define SMC_TIMINGS5 (*(volatile unsigned int *)0x400E00E0)       // [SMC Timings Register (CS_number = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1387154)
#define SMC_MODE5    (*(volatile unsigned int *)0x400E00E4)       // [SMC Mode Register (CS_number = 5)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1376124)
#define SMC_SETUP6   (*(volatile unsigned int *)0x400E00E8)       // [SMC Setup Register (CS_number = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364169)
#define SMC_PULSE6   (*(volatile unsigned int *)0x400E00EC)       // [SMC Pulse Register (CS_number = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364664)
#define SMC_CYCLE6   (*(volatile unsigned int *)0x400E00F0)       // [SMC Cycle Register (CS_number = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364908)
#define SMC_TIMINGS6 (*(volatile unsigned int *)0x400E00F4)       // [SMC Timings Register (CS_number = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1387154)
#define SMC_MODE6    (*(volatile unsigned int *)0x400E00F8)       // [SMC Mode Register (CS_number = 6)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1376124)
#define SMC_SETUP7   (*(volatile unsigned int *)0x400E00FC)       // [SMC Setup Register (CS_number = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364169)
#define SMC_PULSE7   (*(volatile unsigned int *)0x400E0100)       // [SMC Pulse Register (CS_number = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364664)
#define SMC_CYCLE7   (*(volatile unsigned int *)0x400E0104)       // [SMC Cycle Register (CS_number = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1364908)
#define SMC_TIMINGS7 (*(volatile unsigned int *)0x400E0108)       // [SMC Timings Register (CS_number = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1387154)
#define SMC_MODE7    (*(volatile unsigned int *)0x400E010C)       // [SMC Mode Register (CS_number = 7)](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1376124)
#define SMC_OCMS     (*(volatile unsigned int *)0x400E0110)       // [SMC OCMS Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1404487)
#define SMC_KEY1     (*(volatile unsigned int *)0x400E0114)       // [SMC OCMS KEY1 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1405419)
#define SMC_KEY2     (*(volatile unsigned int *)0x400E0118)       // [SMC OCMS KEY2 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1405468)
#define SMC_WPCR     (*(volatile unsigned int *)0x400E01E4)       // [Write Protection Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1369478)
#define SMC_WPSR     (*(const volatile unsigned int *)0x400E01E8) // [Write Protection Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G17.1369666)

#define SMC_CFG_PAGESIZE_PS512  0x00000000              // Main area 512 Bytes
#define SMC_CFG_PAGESIZE_PS1024 0x00000001              // Main area 1024 Bytes
#define SMC_CFG_PAGESIZE_PS2048 0x00000002              // Main area 2048 Bytes
#define SMC_CFG_PAGESIZE_PS4096 0x00000003              // Main area 4096 Bytes
#define SMC_CFG_WSPARE          0x00000100              // Write Spare Area
#define SMC_CFG_RSPARE          0x00000200              // Read Spare Area
#define SMC_CFG_EDGECTRL        0x00001000              // Rising/Falling Edge Detection Control
#define SMC_CFG_RBEDGE          0x00002000              // Ready/Busy Signal Edge Detection
#define SMC_CFG_DTOCYC(value)   (((value) & 0xF) << 16) // Data Timeout Cycle Number
#define SMC_CFG_DTOMUL_X1       0x00000000              // DTOCYC
#define SMC_CFG_DTOMUL_X16      0x00100000              // DTOCYC x 16
#define SMC_CFG_DTOMUL_X128     0x00200000              // DTOCYC x 128
#define SMC_CFG_DTOMUL_X256     0x00300000              // DTOCYC x 256
#define SMC_CFG_DTOMUL_X1024    0x00400000              // DTOCYC x 1024
#define SMC_CFG_DTOMUL_X4096    0x00500000              // DTOCYC x 4096
#define SMC_CFG_DTOMUL_X65536   0x00600000              // DTOCYC x 65536
#define SMC_CFG_DTOMUL_X1048576 0x00700000              // DTOCYC x 1048576

#define SMC_CTRL_NFCEN  0x00000001 // NAND Flash Controller Enable
#define SMC_CTRL_NFCDIS 0x00000002 // NAND Flash Controller Disable

#define SMC_SR_SMCSTS        0x00000001              // NAND Flash Controller status (this field cannot be reset)
#define SMC_SR_RB_RISE       0x00000010              // Selected Ready Busy Rising Edge Detected
#define SMC_SR_RB_FALL       0x00000020              // Selected Ready Busy Falling Edge Detected
#define SMC_SR_NFCBUSY       0x00000100              // NFC Busy (this field cannot be reset)
#define SMC_SR_NFCWR         0x00000800              // NFC Write/Read Operation (this field cannot be reset)
#define SMC_SR_NFCSID(value) (((value) & 0x7) << 12) // NFC Chip Select ID (this field cannot be reset)
#define SMC_SR_XFRDONE       0x00010000              // NFC Data Transfer Terminated
#define SMC_SR_CMDDONE       0x00020000              // Command Done
#define SMC_SR_DTOE          0x00100000              // Data Timeout Error
#define SMC_SR_UNDEF         0x00200000              // Undefined Area Error
#define SMC_SR_AWB           0x00400000              // Accessing While Busy
#define SMC_SR_NFCASE        0x00800000              // NFC Access Size Error
#define SMC_SR_RB_EDGE0      0x01000000              // Ready/Busy Line 0 Edge Detected

#define SMC_IER_RB_RISE  0x00000010 // Ready Busy Rising Edge Detection Interrupt Enable
#define SMC_IER_RB_FALL  0x00000020 // Ready Busy Falling Edge Detection Interrupt Enable
#define SMC_IER_XFRDONE  0x00010000 // Transfer Done Interrupt Enable
#define SMC_IER_CMDDONE  0x00020000 // Command Done Interrupt Enable
#define SMC_IER_DTOE     0x00100000 // Data Timeout Error Interrupt Enable
#define SMC_IER_UNDEF    0x00200000 // Undefined Area Access Interrupt Enable
#define SMC_IER_AWB      0x00400000 // Accessing While Busy Interrupt Enable
#define SMC_IER_NFCASE   0x00800000 // NFC Access Size Error Interrupt Enable
#define SMC_IER_RB_EDGE0 0x01000000 // Ready/Busy Line 0 Interrupt Enable

#define SMC_IDR_RB_RISE  0x00000010 // Ready Busy Rising Edge Detection Interrupt Disable
#define SMC_IDR_RB_FALL  0x00000020 // Ready Busy Falling Edge Detection Interrupt Disable
#define SMC_IDR_XFRDONE  0x00010000 // Transfer Done Interrupt Disable
#define SMC_IDR_CMDDONE  0x00020000 // Command Done Interrupt Disable
#define SMC_IDR_DTOE     0x00100000 // Data Timeout Error Interrupt Disable
#define SMC_IDR_UNDEF    0x00200000 // Undefined Area Access Interrupt Disable
#define SMC_IDR_AWB      0x00400000 // Accessing While Busy Interrupt Disable
#define SMC_IDR_NFCASE   0x00800000 // NFC Access Size Error Interrupt Disable
#define SMC_IDR_RB_EDGE0 0x01000000 // Ready/Busy Line 0 Interrupt Disable

#define SMC_IMR_RB_RISE  0x00000010 // Ready Busy Rising Edge Detection Interrupt Mask
#define SMC_IMR_RB_FALL  0x00000020 // Ready Busy Falling Edge Detection Interrupt Mask
#define SMC_IMR_XFRDONE  0x00010000 // Transfer Done Interrupt Mask
#define SMC_IMR_CMDDONE  0x00020000 // Command Done Interrupt Mask
#define SMC_IMR_DTOE     0x00100000 // Data Timeout Error Interrupt Mask
#define SMC_IMR_UNDEF    0x00200000 // Undefined Area Access Interrupt Mask5
#define SMC_IMR_AWB      0x00400000 // Accessing While Busy Interrupt Mask
#define SMC_IMR_NFCASE   0x00800000 // NFC Access Size Error Interrupt Mask
#define SMC_IMR_RB_EDGE0 0x01000000 // Ready/Busy Line 0 Interrupt Mask

#define SMC_ADDR_ADDR_CYCLE0(value) (((value) & 0xFF) << 0) // NAND Flash Array Address cycle 0

#define SMC_BANK_BANK(value) (((value) & 0x7) << 0) // Bank Identifier

#define SMC_ECC_CTRL_RST   0x00000001 // Reset ECC
#define SMC_ECC_CTRL_SWRST 0x00000002 // Software Reset

#define SMC_ECC_MD_ECC_PAGESIZE_PS512  0x00000000 // Main area 512 Words
#define SMC_ECC_MD_ECC_PAGESIZE_PS1024 0x00000001 // Main area 1024 Words
#define SMC_ECC_MD_ECC_PAGESIZE_PS2048 0x00000002 // Main area 2048 Words
#define SMC_ECC_MD_ECC_PAGESIZE_PS4096 0x00000003 // Main area 4096 Words
#define SMC_ECC_MD_TYPCORREC_CPAGE     0x00000000 // 1 bit correction for a page of 512/1024/2048/4096 Bytes  (for 8 or 16-bit NAND Flash)
#define SMC_ECC_MD_TYPCORREC_C256B     0x00000010 // 1 bit correction for 256 Bytes of data for a page of 512/2048/4096 bytes (for 8-bit NAND Flash only)
#define SMC_ECC_MD_TYPCORREC_C512B     0x00000020 // 1 bit correction for 512 Bytes of data for a page of 512/2048/4096 bytes (for 8-bit NAND Flash only)

#define SMC_ECC_SR1_RECERR0 0x00000001 // Recoverable Error
#define SMC_ECC_SR1_ECCERR0 0x00000002 // ECC Error
#define SMC_ECC_SR1_MULERR0 0x00000004 // Multiple Error
#define SMC_ECC_SR1_RECERR1 0x00000010 // Recoverable Error in the page between the 256th and the 511th bytes or the 512nd and the 1023rd bytes
#define SMC_ECC_SR1_ECCERR1 0x00000020 // ECC Error in the page between the 256th and the 511th bytes or between the 512nd and the 1023rd bytes
#define SMC_ECC_SR1_MULERR1 0x00000040 // Multiple Error in the page between the 256th and the 511th bytes or between the 512nd and the 1023rd bytes
#define SMC_ECC_SR1_RECERR2 0x00000100 // Recoverable Error in the page between the 512nd and the 767th bytes or between the 1024th and the 1535th bytes
#define SMC_ECC_SR1_ECCERR2 0x00000200 // ECC Error in the page between the 512nd and the 767th bytes or between the 1024th and the 1535th bytes
#define SMC_ECC_SR1_MULERR2 0x00000400 // Multiple Error in the page between the 512nd and the 767th bytes or between the 1024th and the 1535th bytes
#define SMC_ECC_SR1_RECERR3 0x00001000 // Recoverable Error in the page between the 768th and the 1023rd bytes or between the 1536th and the 2047th bytes
#define SMC_ECC_SR1_ECCERR3 0x00002000 // ECC Error in the page between the 768th and the 1023rd bytes or between the 1536th and the 2047th bytes
#define SMC_ECC_SR1_MULERR3 0x00004000 // Multiple Error in the page between the 768th and the 1023rd bytes or between the 1536th and the 2047th bytes
#define SMC_ECC_SR1_RECERR4 0x00010000 // Recoverable Error in the page between the 1024th and the 1279th bytes or between the 2048th and the 2559th bytes
#define SMC_ECC_SR1_ECCERR4 0x00020000 // ECC Error in the page between the 1024th and the 1279th bytes or between the 2048th and the 2559th bytes
#define SMC_ECC_SR1_MULERR4 0x00040000 // Multiple Error in the page between the 1024th and the 1279th bytes or between the 2048th and the 2559th bytes
#define SMC_ECC_SR1_RECERR5 0x00100000 // Recoverable Error in the page between the 1280th and the 1535th bytes or between the 2560th and the 3071st bytes
#define SMC_ECC_SR1_ECCERR5 0x00200000 // ECC Error in the page between the 1280th and the 1535th bytes or between the 2560th and the 3071st bytes
#define SMC_ECC_SR1_MULERR5 0x00400000 // Multiple Error in the page between the 1280th and the 1535th bytes or between the 2560th and the 3071st bytes
#define SMC_ECC_SR1_RECERR6 0x01000000 // Recoverable Error in the page between the 1536th and the 1791st bytes or between the 3072nd and the 3583rd bytes
#define SMC_ECC_SR1_ECCERR6 0x02000000 // ECC Error in the page between the 1536th and the 1791st bytes or between the 3072nd and the 3583rd bytes
#define SMC_ECC_SR1_MULERR6 0x04000000 // Multiple Error in the page between the 1536th and the 1791st bytes or between the 3072nd and the 3583rd bytes
#define SMC_ECC_SR1_RECERR7 0x10000000 // Recoverable Error in the page between the 1792nd and the 2047th bytes or between the 3584th and the 4095th bytes
#define SMC_ECC_SR1_ECCERR7 0x20000000 // ECC Error in the page between the 1792nd and the 2047th bytes or between the 3584th and the 4095th bytes
#define SMC_ECC_SR1_MULERR7 0x40000000 // Multiple Error in the page between the 1792nd and the 2047th bytes or between the 3584th and the 4095th bytes

#define SMC_ECC_PR0_BITADDR(value)  (((value) & 0xF) << 0)   // Bit Address
#define SMC_ECC_PR0_WORDADDR(value) (((value) & 0xFFF) << 4) // Word Address

#define SMC_ECC_PR1_NPARITY(value) (((value) & 0xFFFF) << 0) // Parity N

#define SMC_ECC_SR2_RECERR8  0x00000001 // Recoverable Error in the page between the 2048th and the 2303rd bytes
#define SMC_ECC_SR2_ECCERR8  0x00000002 // ECC Error in the page between the 2048th and the 2303rd bytes
#define SMC_ECC_SR2_MULERR8  0x00000004 // Multiple Error in the page between the 2048th and the 2303rd bytes
#define SMC_ECC_SR2_RECERR9  0x00000010 // Recoverable Error in the page between the 2304th and the 2559th bytes
#define SMC_ECC_SR2_ECCERR9  0x00000020 // ECC Error in the page between the 2304th and the 2559th bytes
#define SMC_ECC_SR2_MULERR9  0x00000040 // Multiple Error in the page between the 2304th and the 2559th bytes
#define SMC_ECC_SR2_RECERR10 0x00000100 // Recoverable Error in the page between the 2560th and the 2815th bytes
#define SMC_ECC_SR2_ECCERR10 0x00000200 // ECC Error in the page between the 2560th and the 2815th bytes
#define SMC_ECC_SR2_MULERR10 0x00000400 // Multiple Error in the page between the 2560th and the 2815th bytes
#define SMC_ECC_SR2_RECERR11 0x00001000 // Recoverable Error in the page between the 2816th and the 3071st bytes
#define SMC_ECC_SR2_ECCERR11 0x00002000 // ECC Error in the page between the 2816th and the 3071st bytes
#define SMC_ECC_SR2_MULERR11 0x00004000 // Multiple Error in the page between the 2816th and the 3071st bytes
#define SMC_ECC_SR2_RECERR12 0x00010000 // Recoverable Error in the page between the 3072nd and the 3327th bytes
#define SMC_ECC_SR2_ECCERR12 0x00020000 // ECC Error in the page between the 3072nd and the 3327th bytes
#define SMC_ECC_SR2_MULERR12 0x00040000 // Multiple Error in the page between the 3072nd and the 3327th bytes
#define SMC_ECC_SR2_RECERR13 0x00100000 // Recoverable Error in the page between the 3328th and the 3583rd bytes
#define SMC_ECC_SR2_ECCERR13 0x00200000 // ECC Error in the page between the 3328th and the 3583rd bytes
#define SMC_ECC_SR2_MULERR13 0x00400000 // Multiple Error in the page between the 3328th and the 3583rd bytes
#define SMC_ECC_SR2_RECERR14 0x01000000 // Recoverable Error in the page between the 3584th and the 3839th bytes
#define SMC_ECC_SR2_ECCERR14 0x02000000 // ECC Error in the page between the 3584th and the 3839th bytes
#define SMC_ECC_SR2_MULERR14 0x04000000 // Multiple Error in the page between the 3584th and the 3839th bytes
#define SMC_ECC_SR2_RECERR15 0x10000000 // Recoverable Error in the page between the 3840th and the 4095th bytes
#define SMC_ECC_SR2_ECCERR15 0x20000000 // ECC Error in the page between the 3840th and the 4095th bytes
#define SMC_ECC_SR2_MULERR15 0x40000000 // Multiple Error in the page between the 3840th and the 4095th bytes

#define SMC_ECC_PR2_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR2_WORDADDR(value) (((value) & 0x1FF) << 3)  // Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR2_NPARITY(value)  (((value) & 0xFFF) << 12) // Parity N

#define SMC_ECC_PR3_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR3_WORDADDR(value) (((value) & 0x1FF) << 3)  // Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR3_NPARITY(value)  (((value) & 0xFFF) << 12) // Parity N

#define SMC_ECC_PR4_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR4_WORDADDR(value) (((value) & 0x1FF) << 3)  // Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR4_NPARITY(value)  (((value) & 0xFFF) << 12) // Parity N

#define SMC_ECC_PR5_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR5_WORDADDR(value) (((value) & 0x1FF) << 3)  // Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR5_NPARITY(value)  (((value) & 0xFFF) << 12) // Parity N

#define SMC_ECC_PR6_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR6_WORDADDR(value) (((value) & 0x1FF) << 3)  // Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR6_NPARITY(value)  (((value) & 0xFFF) << 12) // Parity N

#define SMC_ECC_PR7_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR7_WORDADDR(value) (((value) & 0x1FF) << 3)  // Corrupted Word Address in the Page between (i x 512) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR7_NPARITY(value)  (((value) & 0xFFF) << 12) // Parity N

#define SMC_ECC_PR8_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR8_WORDADDR(value) (((value) & 0xFF) << 3)   // Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR8_NPARITY(value)  (((value) & 0x7FF) << 12) // Parity N

#define SMC_ECC_PR9_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR9_WORDADDR(value) (((value) & 0xFF) << 3)   // Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR9_NPARITY(value)  (((value) & 0x7FF) << 12) // Parity N

#define SMC_ECC_PR10_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR10_WORDADDR(value) (((value) & 0xFF) << 3)   // Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR10_NPARITY(value)  (((value) & 0x7FF) << 12) // Parity N

#define SMC_ECC_PR11_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR11_WORDADDR(value) (((value) & 0xFF) << 3)   // Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR11_NPARITY(value)  (((value) & 0x7FF) << 12) // Parity N

#define SMC_ECC_PR12_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR12_WORDADDR(value) (((value) & 0xFF) << 3)   // Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR12_NPARITY(value)  (((value) & 0x7FF) << 12) // Parity N

#define SMC_ECC_PR13_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR13_WORDADDR(value) (((value) & 0xFF) << 3)   // Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR13_NPARITY(value)  (((value) & 0x7FF) << 12) // Parity N

#define SMC_ECC_PR14_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR14_WORDADDR(value) (((value) & 0xFF) << 3)   // Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR14_NPARITY(value)  (((value) & 0x7FF) << 12) // Parity N

#define SMC_ECC_PR15_BITADDR(value)  (((value) & 0x7) << 0)    // Corrupted Bit Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR15_WORDADDR(value) (((value) & 0xFF) << 3)   // Corrupted Word Address in the Page between (i x 256) and ((i + 1) x 512) - 1) Bytes
#define SMC_ECC_PR15_NPARITY(value)  (((value) & 0x7FF) << 12) // Parity N

#define SMC_SETUP0_NWE_SETUP(value)    (((value) & 0x3F) << 0)  // NWE Setup Length
#define SMC_SETUP0_NCS_WR_SETUP(value) (((value) & 0x3F) << 8)  // NCS Setup Length in Write Access
#define SMC_SETUP0_NRD_SETUP(value)    (((value) & 0x3F) << 16) // NRD Setup Length
#define SMC_SETUP0_NCS_RD_SETUP(value) (((value) & 0x3F) << 24) // NCS Setup Length in Read Access

#define SMC_PULSE0_NWE_PULSE(value)    (((value) & 0x7F) << 0)  // NWE Pulse Length
#define SMC_PULSE0_NCS_WR_PULSE(value) (((value) & 0x7F) << 8)  // NCS Pulse Length in WRITE Access
#define SMC_PULSE0_NRD_PULSE(value)    (((value) & 0x7F) << 16) // NRD Pulse Length
#define SMC_PULSE0_NCS_RD_PULSE(value) (((value) & 0x7F) << 24) // NCS Pulse Length in READ Access

#define SMC_CYCLE0_NWE_CYCLE(value) (((value) & 0x1FF) << 0)  // Total Write Cycle Length
#define SMC_CYCLE0_NRD_CYCLE(value) (((value) & 0x1FF) << 16) // Total Read Cycle Length

#define SMC_TIMINGS0_TCLR(value)   (((value) & 0xF) << 0)  // CLE to REN Low Delay
#define SMC_TIMINGS0_TADL(value)   (((value) & 0xF) << 4)  // ALE to Data Start
#define SMC_TIMINGS0_TAR(value)    (((value) & 0xF) << 8)  // ALE to REN Low Delay
#define SMC_TIMINGS0_OCMS          0x00001000              // Off Chip Memory Scrambling Enable
#define SMC_TIMINGS0_TRR(value)    (((value) & 0xF) << 16) // Ready to REN Low Delay
#define SMC_TIMINGS0_TWB(value)    (((value) & 0xF) << 24) // WEN High to REN to Busy
#define SMC_TIMINGS0_RBNSEL(value) (((value) & 0x7) << 28) // Ready/Busy Line Selection
#define SMC_TIMINGS0_NFSEL         0x80000000              // NAND Flash Selection

#define SMC_MODE0_READ_MODE_NCS_CTRL  0x00000000              // The Read operation is controlled by the NCS signal
#define SMC_MODE0_READ_MODE_NRD_CTRL  0x00000001              // The Read operation is controlled by the NRD signal
#define SMC_MODE0_WRITE_MODE_NCS_CTRL 0x00000000              // The Write operation is controller by the NCS signal
#define SMC_MODE0_WRITE_MODE_NWE_CTRL 0x00000002              // The Write operation is controlled by the NWE signal
#define SMC_MODE0_EXNW_MODE_DISABLED  0x00000000              // Disabled
#define SMC_MODE0_EXNW_MODE_FROZEN    0x00000020              // Frozen Mode
#define SMC_MODE0_EXNW_MODE_READY     0x00000030              // Ready Mode
#define SMC_MODE0_BAT                 0x00000100              // Byte Access Type
#define SMC_MODE0_DBW_BIT_8           0x00000000              // 8-bit bus
#define SMC_MODE0_DBW_BIT_16          0x00001000              // 16-bit bus
#define SMC_MODE0_TDF_CYCLES(value)   (((value) & 0xF) << 16) // Data Float Time
#define SMC_MODE0_TDF_MODE            0x00100000              // TDF Optimization

#define SMC_SETUP1_NWE_SETUP(value)    (((value) & 0x3F) << 0)  // NWE Setup Length
#define SMC_SETUP1_NCS_WR_SETUP(value) (((value) & 0x3F) << 8)  // NCS Setup Length in Write Access
#define SMC_SETUP1_NRD_SETUP(value)    (((value) & 0x3F) << 16) // NRD Setup Length
#define SMC_SETUP1_NCS_RD_SETUP(value) (((value) & 0x3F) << 24) // NCS Setup Length in Read Access

#define SMC_PULSE1_NWE_PULSE(value)    (((value) & 0x7F) << 0)  // NWE Pulse Length
#define SMC_PULSE1_NCS_WR_PULSE(value) (((value) & 0x7F) << 8)  // NCS Pulse Length in WRITE Access
#define SMC_PULSE1_NRD_PULSE(value)    (((value) & 0x7F) << 16) // NRD Pulse Length
#define SMC_PULSE1_NCS_RD_PULSE(value) (((value) & 0x7F) << 24) // NCS Pulse Length in READ Access

#define SMC_CYCLE1_NWE_CYCLE(value) (((value) & 0x1FF) << 0)  // Total Write Cycle Length
#define SMC_CYCLE1_NRD_CYCLE(value) (((value) & 0x1FF) << 16) // Total Read Cycle Length

#define SMC_TIMINGS1_TCLR(value)   (((value) & 0xF) << 0)  // CLE to REN Low Delay
#define SMC_TIMINGS1_TADL(value)   (((value) & 0xF) << 4)  // ALE to Data Start
#define SMC_TIMINGS1_TAR(value)    (((value) & 0xF) << 8)  // ALE to REN Low Delay
#define SMC_TIMINGS1_OCMS          0x00001000              // Off Chip Memory Scrambling Enable
#define SMC_TIMINGS1_TRR(value)    (((value) & 0xF) << 16) // Ready to REN Low Delay
#define SMC_TIMINGS1_TWB(value)    (((value) & 0xF) << 24) // WEN High to REN to Busy
#define SMC_TIMINGS1_RBNSEL(value) (((value) & 0x7) << 28) // Ready/Busy Line Selection
#define SMC_TIMINGS1_NFSEL         0x80000000              // NAND Flash Selection

#define SMC_MODE1_READ_MODE_NCS_CTRL  0x00000000              // The Read operation is controlled by the NCS signal
#define SMC_MODE1_READ_MODE_NRD_CTRL  0x00000001              // The Read operation is controlled by the NRD signal
#define SMC_MODE1_WRITE_MODE_NCS_CTRL 0x00000000              // The Write operation is controller by the NCS signal
#define SMC_MODE1_WRITE_MODE_NWE_CTRL 0x00000002              // The Write operation is controlled by the NWE signal
#define SMC_MODE1_EXNW_MODE_DISABLED  0x00000000              // Disabled
#define SMC_MODE1_EXNW_MODE_FROZEN    0x00000020              // Frozen Mode
#define SMC_MODE1_EXNW_MODE_READY     0x00000030              // Ready Mode
#define SMC_MODE1_BAT                 0x00000100              // Byte Access Type
#define SMC_MODE1_DBW_BIT_8           0x00000000              // 8-bit bus
#define SMC_MODE1_DBW_BIT_16          0x00001000              // 16-bit bus
#define SMC_MODE1_TDF_CYCLES(value)   (((value) & 0xF) << 16) // Data Float Time
#define SMC_MODE1_TDF_MODE            0x00100000              // TDF Optimization

#define SMC_SETUP2_NWE_SETUP(value)    (((value) & 0x3F) << 0)  // NWE Setup Length
#define SMC_SETUP2_NCS_WR_SETUP(value) (((value) & 0x3F) << 8)  // NCS Setup Length in Write Access
#define SMC_SETUP2_NRD_SETUP(value)    (((value) & 0x3F) << 16) // NRD Setup Length
#define SMC_SETUP2_NCS_RD_SETUP(value) (((value) & 0x3F) << 24) // NCS Setup Length in Read Access

#define SMC_PULSE2_NWE_PULSE(value)    (((value) & 0x7F) << 0)  // NWE Pulse Length
#define SMC_PULSE2_NCS_WR_PULSE(value) (((value) & 0x7F) << 8)  // NCS Pulse Length in WRITE Access
#define SMC_PULSE2_NRD_PULSE(value)    (((value) & 0x7F) << 16) // NRD Pulse Length
#define SMC_PULSE2_NCS_RD_PULSE(value) (((value) & 0x7F) << 24) // NCS Pulse Length in READ Access

#define SMC_CYCLE2_NWE_CYCLE(value) (((value) & 0x1FF) << 0)  // Total Write Cycle Length
#define SMC_CYCLE2_NRD_CYCLE(value) (((value) & 0x1FF) << 16) // Total Read Cycle Length

#define SMC_TIMINGS2_TCLR(value)   (((value) & 0xF) << 0)  // CLE to REN Low Delay
#define SMC_TIMINGS2_TADL(value)   (((value) & 0xF) << 4)  // ALE to Data Start
#define SMC_TIMINGS2_TAR(value)    (((value) & 0xF) << 8)  // ALE to REN Low Delay
#define SMC_TIMINGS2_OCMS          0x00001000              // Off Chip Memory Scrambling Enable
#define SMC_TIMINGS2_TRR(value)    (((value) & 0xF) << 16) // Ready to REN Low Delay
#define SMC_TIMINGS2_TWB(value)    (((value) & 0xF) << 24) // WEN High to REN to Busy
#define SMC_TIMINGS2_RBNSEL(value) (((value) & 0x7) << 28) // Ready/Busy Line Selection
#define SMC_TIMINGS2_NFSEL         0x80000000              // NAND Flash Selection

#define SMC_MODE2_READ_MODE_NCS_CTRL  0x00000000              // The Read operation is controlled by the NCS signal
#define SMC_MODE2_READ_MODE_NRD_CTRL  0x00000001              // The Read operation is controlled by the NRD signal
#define SMC_MODE2_WRITE_MODE_NCS_CTRL 0x00000000              // The Write operation is controller by the NCS signal
#define SMC_MODE2_WRITE_MODE_NWE_CTRL 0x00000002              // The Write operation is controlled by the NWE signal
#define SMC_MODE2_EXNW_MODE_DISABLED  0x00000000              // Disabled
#define SMC_MODE2_EXNW_MODE_FROZEN    0x00000020              // Frozen Mode
#define SMC_MODE2_EXNW_MODE_READY     0x00000030              // Ready Mode
#define SMC_MODE2_BAT                 0x00000100              // Byte Access Type
#define SMC_MODE2_DBW_BIT_8           0x00000000              // 8-bit bus
#define SMC_MODE2_DBW_BIT_16          0x00001000              // 16-bit bus
#define SMC_MODE2_TDF_CYCLES(value)   (((value) & 0xF) << 16) // Data Float Time
#define SMC_MODE2_TDF_MODE            0x00100000              // TDF Optimization

#define SMC_SETUP3_NWE_SETUP(value)    (((value) & 0x3F) << 0)  // NWE Setup Length
#define SMC_SETUP3_NCS_WR_SETUP(value) (((value) & 0x3F) << 8)  // NCS Setup Length in Write Access
#define SMC_SETUP3_NRD_SETUP(value)    (((value) & 0x3F) << 16) // NRD Setup Length
#define SMC_SETUP3_NCS_RD_SETUP(value) (((value) & 0x3F) << 24) // NCS Setup Length in Read Access

#define SMC_PULSE3_NWE_PULSE(value)    (((value) & 0x7F) << 0)  // NWE Pulse Length
#define SMC_PULSE3_NCS_WR_PULSE(value) (((value) & 0x7F) << 8)  // NCS Pulse Length in WRITE Access
#define SMC_PULSE3_NRD_PULSE(value)    (((value) & 0x7F) << 16) // NRD Pulse Length
#define SMC_PULSE3_NCS_RD_PULSE(value) (((value) & 0x7F) << 24) // NCS Pulse Length in READ Access

#define SMC_CYCLE3_NWE_CYCLE(value) (((value) & 0x1FF) << 0)  // Total Write Cycle Length
#define SMC_CYCLE3_NRD_CYCLE(value) (((value) & 0x1FF) << 16) // Total Read Cycle Length

#define SMC_TIMINGS3_TCLR(value)   (((value) & 0xF) << 0)  // CLE to REN Low Delay
#define SMC_TIMINGS3_TADL(value)   (((value) & 0xF) << 4)  // ALE to Data Start
#define SMC_TIMINGS3_TAR(value)    (((value) & 0xF) << 8)  // ALE to REN Low Delay
#define SMC_TIMINGS3_OCMS          0x00001000              // Off Chip Memory Scrambling Enable
#define SMC_TIMINGS3_TRR(value)    (((value) & 0xF) << 16) // Ready to REN Low Delay
#define SMC_TIMINGS3_TWB(value)    (((value) & 0xF) << 24) // WEN High to REN to Busy
#define SMC_TIMINGS3_RBNSEL(value) (((value) & 0x7) << 28) // Ready/Busy Line Selection
#define SMC_TIMINGS3_NFSEL         0x80000000              // NAND Flash Selection

#define SMC_MODE3_READ_MODE_NCS_CTRL  0x00000000              // The Read operation is controlled by the NCS signal
#define SMC_MODE3_READ_MODE_NRD_CTRL  0x00000001              // The Read operation is controlled by the NRD signal
#define SMC_MODE3_WRITE_MODE_NCS_CTRL 0x00000000              // The Write operation is controller by the NCS signal
#define SMC_MODE3_WRITE_MODE_NWE_CTRL 0x00000002              // The Write operation is controlled by the NWE signal
#define SMC_MODE3_EXNW_MODE_DISABLED  0x00000000              // Disabled
#define SMC_MODE3_EXNW_MODE_FROZEN    0x00000020              // Frozen Mode
#define SMC_MODE3_EXNW_MODE_READY     0x00000030              // Ready Mode
#define SMC_MODE3_BAT                 0x00000100              // Byte Access Type
#define SMC_MODE3_DBW_BIT_8           0x00000000              // 8-bit bus
#define SMC_MODE3_DBW_BIT_16          0x00001000              // 16-bit bus
#define SMC_MODE3_TDF_CYCLES(value)   (((value) & 0xF) << 16) // Data Float Time
#define SMC_MODE3_TDF_MODE            0x00100000              // TDF Optimization

#define SMC_SETUP4_NWE_SETUP(value)    (((value) & 0x3F) << 0)  // NWE Setup Length
#define SMC_SETUP4_NCS_WR_SETUP(value) (((value) & 0x3F) << 8)  // NCS Setup Length in Write Access
#define SMC_SETUP4_NRD_SETUP(value)    (((value) & 0x3F) << 16) // NRD Setup Length
#define SMC_SETUP4_NCS_RD_SETUP(value) (((value) & 0x3F) << 24) // NCS Setup Length in Read Access

#define SMC_PULSE4_NWE_PULSE(value)    (((value) & 0x7F) << 0)  // NWE Pulse Length
#define SMC_PULSE4_NCS_WR_PULSE(value) (((value) & 0x7F) << 8)  // NCS Pulse Length in WRITE Access
#define SMC_PULSE4_NRD_PULSE(value)    (((value) & 0x7F) << 16) // NRD Pulse Length
#define SMC_PULSE4_NCS_RD_PULSE(value) (((value) & 0x7F) << 24) // NCS Pulse Length in READ Access

#define SMC_CYCLE4_NWE_CYCLE(value) (((value) & 0x1FF) << 0)  // Total Write Cycle Length
#define SMC_CYCLE4_NRD_CYCLE(value) (((value) & 0x1FF) << 16) // Total Read Cycle Length

#define SMC_TIMINGS4_TCLR(value)   (((value) & 0xF) << 0)  // CLE to REN Low Delay
#define SMC_TIMINGS4_TADL(value)   (((value) & 0xF) << 4)  // ALE to Data Start
#define SMC_TIMINGS4_TAR(value)    (((value) & 0xF) << 8)  // ALE to REN Low Delay
#define SMC_TIMINGS4_OCMS          0x00001000              // Off Chip Memory Scrambling Enable
#define SMC_TIMINGS4_TRR(value)    (((value) & 0xF) << 16) // Ready to REN Low Delay
#define SMC_TIMINGS4_TWB(value)    (((value) & 0xF) << 24) // WEN High to REN to Busy
#define SMC_TIMINGS4_RBNSEL(value) (((value) & 0x7) << 28) // Ready/Busy Line Selection
#define SMC_TIMINGS4_NFSEL         0x80000000              // NAND Flash Selection

#define SMC_MODE4_READ_MODE_NCS_CTRL  0x00000000              // The Read operation is controlled by the NCS signal
#define SMC_MODE4_READ_MODE_NRD_CTRL  0x00000001              // The Read operation is controlled by the NRD signal
#define SMC_MODE4_WRITE_MODE_NCS_CTRL 0x00000000              // The Write operation is controller by the NCS signal
#define SMC_MODE4_WRITE_MODE_NWE_CTRL 0x00000002              // The Write operation is controlled by the NWE signal
#define SMC_MODE4_EXNW_MODE_DISABLED  0x00000000              // Disabled
#define SMC_MODE4_EXNW_MODE_FROZEN    0x00000020              // Frozen Mode
#define SMC_MODE4_EXNW_MODE_READY     0x00000030              // Ready Mode
#define SMC_MODE4_BAT                 0x00000100              // Byte Access Type
#define SMC_MODE4_DBW_BIT_8           0x00000000              // 8-bit bus
#define SMC_MODE4_DBW_BIT_16          0x00001000              // 16-bit bus
#define SMC_MODE4_TDF_CYCLES(value)   (((value) & 0xF) << 16) // Data Float Time
#define SMC_MODE4_TDF_MODE            0x00100000              // TDF Optimization

#define SMC_SETUP5_NWE_SETUP(value)    (((value) & 0x3F) << 0)  // NWE Setup Length
#define SMC_SETUP5_NCS_WR_SETUP(value) (((value) & 0x3F) << 8)  // NCS Setup Length in Write Access
#define SMC_SETUP5_NRD_SETUP(value)    (((value) & 0x3F) << 16) // NRD Setup Length
#define SMC_SETUP5_NCS_RD_SETUP(value) (((value) & 0x3F) << 24) // NCS Setup Length in Read Access

#define SMC_PULSE5_NWE_PULSE(value)    (((value) & 0x7F) << 0)  // NWE Pulse Length
#define SMC_PULSE5_NCS_WR_PULSE(value) (((value) & 0x7F) << 8)  // NCS Pulse Length in WRITE Access
#define SMC_PULSE5_NRD_PULSE(value)    (((value) & 0x7F) << 16) // NRD Pulse Length
#define SMC_PULSE5_NCS_RD_PULSE(value) (((value) & 0x7F) << 24) // NCS Pulse Length in READ Access

#define SMC_CYCLE5_NWE_CYCLE(value) (((value) & 0x1FF) << 0)  // Total Write Cycle Length
#define SMC_CYCLE5_NRD_CYCLE(value) (((value) & 0x1FF) << 16) // Total Read Cycle Length

#define SMC_TIMINGS5_TCLR(value)   (((value) & 0xF) << 0)  // CLE to REN Low Delay
#define SMC_TIMINGS5_TADL(value)   (((value) & 0xF) << 4)  // ALE to Data Start
#define SMC_TIMINGS5_TAR(value)    (((value) & 0xF) << 8)  // ALE to REN Low Delay
#define SMC_TIMINGS5_OCMS          0x00001000              // Off Chip Memory Scrambling Enable
#define SMC_TIMINGS5_TRR(value)    (((value) & 0xF) << 16) // Ready to REN Low Delay
#define SMC_TIMINGS5_TWB(value)    (((value) & 0xF) << 24) // WEN High to REN to Busy
#define SMC_TIMINGS5_RBNSEL(value) (((value) & 0x7) << 28) // Ready/Busy Line Selection
#define SMC_TIMINGS5_NFSEL         0x80000000              // NAND Flash Selection

#define SMC_MODE5_READ_MODE_NCS_CTRL  0x00000000              // The Read operation is controlled by the NCS signal
#define SMC_MODE5_READ_MODE_NRD_CTRL  0x00000001              // The Read operation is controlled by the NRD signal
#define SMC_MODE5_WRITE_MODE_NCS_CTRL 0x00000000              // The Write operation is controller by the NCS signal
#define SMC_MODE5_WRITE_MODE_NWE_CTRL 0x00000002              // The Write operation is controlled by the NWE signal
#define SMC_MODE5_EXNW_MODE_DISABLED  0x00000000              // Disabled
#define SMC_MODE5_EXNW_MODE_FROZEN    0x00000020              // Frozen Mode
#define SMC_MODE5_EXNW_MODE_READY     0x00000030              // Ready Mode
#define SMC_MODE5_BAT                 0x00000100              // Byte Access Type
#define SMC_MODE5_DBW_BIT_8           0x00000000              // 8-bit bus
#define SMC_MODE5_DBW_BIT_16          0x00001000              // 16-bit bus
#define SMC_MODE5_TDF_CYCLES(value)   (((value) & 0xF) << 16) // Data Float Time
#define SMC_MODE5_TDF_MODE            0x00100000              // TDF Optimization

#define SMC_SETUP6_NWE_SETUP(value)    (((value) & 0x3F) << 0)  // NWE Setup Length
#define SMC_SETUP6_NCS_WR_SETUP(value) (((value) & 0x3F) << 8)  // NCS Setup Length in Write Access
#define SMC_SETUP6_NRD_SETUP(value)    (((value) & 0x3F) << 16) // NRD Setup Length
#define SMC_SETUP6_NCS_RD_SETUP(value) (((value) & 0x3F) << 24) // NCS Setup Length in Read Access

#define SMC_PULSE6_NWE_PULSE(value)    (((value) & 0x7F) << 0)  // NWE Pulse Length
#define SMC_PULSE6_NCS_WR_PULSE(value) (((value) & 0x7F) << 8)  // NCS Pulse Length in WRITE Access
#define SMC_PULSE6_NRD_PULSE(value)    (((value) & 0x7F) << 16) // NRD Pulse Length
#define SMC_PULSE6_NCS_RD_PULSE(value) (((value) & 0x7F) << 24) // NCS Pulse Length in READ Access

#define SMC_CYCLE6_NWE_CYCLE(value) (((value) & 0x1FF) << 0)  // Total Write Cycle Length
#define SMC_CYCLE6_NRD_CYCLE(value) (((value) & 0x1FF) << 16) // Total Read Cycle Length

#define SMC_TIMINGS6_TCLR(value)   (((value) & 0xF) << 0)  // CLE to REN Low Delay
#define SMC_TIMINGS6_TADL(value)   (((value) & 0xF) << 4)  // ALE to Data Start
#define SMC_TIMINGS6_TAR(value)    (((value) & 0xF) << 8)  // ALE to REN Low Delay
#define SMC_TIMINGS6_OCMS          0x00001000              // Off Chip Memory Scrambling Enable
#define SMC_TIMINGS6_TRR(value)    (((value) & 0xF) << 16) // Ready to REN Low Delay
#define SMC_TIMINGS6_TWB(value)    (((value) & 0xF) << 24) // WEN High to REN to Busy
#define SMC_TIMINGS6_RBNSEL(value) (((value) & 0x7) << 28) // Ready/Busy Line Selection
#define SMC_TIMINGS6_NFSEL         0x80000000              // NAND Flash Selection

#define SMC_MODE6_READ_MODE_NCS_CTRL  0x00000000              // The Read operation is controlled by the NCS signal
#define SMC_MODE6_READ_MODE_NRD_CTRL  0x00000001              // The Read operation is controlled by the NRD signal
#define SMC_MODE6_WRITE_MODE_NCS_CTRL 0x00000000              // The Write operation is controller by the NCS signal
#define SMC_MODE6_WRITE_MODE_NWE_CTRL 0x00000002              // The Write operation is controlled by the NWE signal
#define SMC_MODE6_EXNW_MODE_DISABLED  0x00000000              // Disabled
#define SMC_MODE6_EXNW_MODE_FROZEN    0x00000020              // Frozen Mode
#define SMC_MODE6_EXNW_MODE_READY     0x00000030              // Ready Mode
#define SMC_MODE6_BAT                 0x00000100              // Byte Access Type
#define SMC_MODE6_DBW_BIT_8           0x00000000              // 8-bit bus
#define SMC_MODE6_DBW_BIT_16          0x00001000              // 16-bit bus
#define SMC_MODE6_TDF_CYCLES(value)   (((value) & 0xF) << 16) // Data Float Time
#define SMC_MODE6_TDF_MODE            0x00100000              // TDF Optimization

#define SMC_SETUP7_NWE_SETUP(value)    (((value) & 0x3F) << 0)  // NWE Setup Length
#define SMC_SETUP7_NCS_WR_SETUP(value) (((value) & 0x3F) << 8)  // NCS Setup Length in Write Access
#define SMC_SETUP7_NRD_SETUP(value)    (((value) & 0x3F) << 16) // NRD Setup Length
#define SMC_SETUP7_NCS_RD_SETUP(value) (((value) & 0x3F) << 24) // NCS Setup Length in Read Access

#define SMC_PULSE7_NWE_PULSE(value)    (((value) & 0x7F) << 0)  // NWE Pulse Length
#define SMC_PULSE7_NCS_WR_PULSE(value) (((value) & 0x7F) << 8)  // NCS Pulse Length in WRITE Access
#define SMC_PULSE7_NRD_PULSE(value)    (((value) & 0x7F) << 16) // NRD Pulse Length
#define SMC_PULSE7_NCS_RD_PULSE(value) (((value) & 0x7F) << 24) // NCS Pulse Length in READ Access

#define SMC_CYCLE7_NWE_CYCLE(value) (((value) & 0x1FF) << 0)  // Total Write Cycle Length
#define SMC_CYCLE7_NRD_CYCLE(value) (((value) & 0x1FF) << 16) // Total Read Cycle Length

#define SMC_TIMINGS7_TCLR(value)   (((value) & 0xF) << 0)  // CLE to REN Low Delay
#define SMC_TIMINGS7_TADL(value)   (((value) & 0xF) << 4)  // ALE to Data Start
#define SMC_TIMINGS7_TAR(value)    (((value) & 0xF) << 8)  // ALE to REN Low Delay
#define SMC_TIMINGS7_OCMS          0x00001000              // Off Chip Memory Scrambling Enable
#define SMC_TIMINGS7_TRR(value)    (((value) & 0xF) << 16) // Ready to REN Low Delay
#define SMC_TIMINGS7_TWB(value)    (((value) & 0xF) << 24) // WEN High to REN to Busy
#define SMC_TIMINGS7_RBNSEL(value) (((value) & 0x7) << 28) // Ready/Busy Line Selection
#define SMC_TIMINGS7_NFSEL         0x80000000              // NAND Flash Selection

#define SMC_MODE7_READ_MODE_NCS_CTRL  0x00000000              // The Read operation is controlled by the NCS signal
#define SMC_MODE7_READ_MODE_NRD_CTRL  0x00000001              // The Read operation is controlled by the NRD signal
#define SMC_MODE7_WRITE_MODE_NCS_CTRL 0x00000000              // The Write operation is controller by the NCS signal
#define SMC_MODE7_WRITE_MODE_NWE_CTRL 0x00000002              // The Write operation is controlled by the NWE signal
#define SMC_MODE7_EXNW_MODE_DISABLED  0x00000000              // Disabled
#define SMC_MODE7_EXNW_MODE_FROZEN    0x00000020              // Frozen Mode
#define SMC_MODE7_EXNW_MODE_READY     0x00000030              // Ready Mode
#define SMC_MODE7_BAT                 0x00000100              // Byte Access Type
#define SMC_MODE7_DBW_BIT_8           0x00000000              // 8-bit bus
#define SMC_MODE7_DBW_BIT_16          0x00001000              // 16-bit bus
#define SMC_MODE7_TDF_CYCLES(value)   (((value) & 0xF) << 16) // Data Float Time
#define SMC_MODE7_TDF_MODE            0x00100000              // TDF Optimization

#define SMC_OCMS_SMSE 0x00000001 // Static Memory Controller Scrambling Enable
#define SMC_OCMS_SRSE 0x00000002 // SRAM Scrambling Enable

#define SMC_KEY1_KEY1(value) (((value) & 0xFFFFFFFF) << 0) // Off Chip Memory Scrambling (OCMS) Key Part 1

#define SMC_KEY2_KEY2(value) (((value) & 0xFFFFFFFF) << 0) // Off Chip Memory Scrambling (OCMS) Key Part 2

#define SMC_WPCR_WP_EN         0x00000001 // Write Protection Enable
#define SMC_WPCR_WP_KEY_PASSWD 0x534D4300 // Writing any other value in this field aborts the write operation of the WP_EN bit. Always reads as 0

#define SMC_WPSR_WP_VS(value)   (((value) & 0xF) << 0)    // Write Protection Violation Status
#define SMC_WPSR_WP_VSRC(value) (((value) & 0xFFFF) << 8) // Write Protection Violation Source

#define MATRIX_MCFG0 (*(volatile unsigned int *)0x400E0404)       // [Master Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064216)
#define MATRIX_MCFG1 (*(volatile unsigned int *)0x400E0404)       // [Master Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064216)
#define MATRIX_MCFG2 (*(volatile unsigned int *)0x400E0404)       // [Master Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064216)
#define MATRIX_MCFG3 (*(volatile unsigned int *)0x400E0404)       // [Master Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064216)
#define MATRIX_MCFG4 (*(volatile unsigned int *)0x400E0404)       // [Master Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064216)
#define MATRIX_MCFG5 (*(volatile unsigned int *)0x400E0404)       // [Master Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064216)
#define MATRIX_SCFG0 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_SCFG1 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_SCFG2 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_SCFG3 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_SCFG4 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_SCFG5 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_SCFG6 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_SCFG7 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_SCFG8 (*(volatile unsigned int *)0x400E0444)       // [Slave Configuration Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1064475)
#define MATRIX_PRAS0 (*(volatile unsigned int *)0x400E0480)       // [Priority Register A for Slave 0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_PRAS1 (*(volatile unsigned int *)0x400E0488)       // [Priority Register A for Slave 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_PRAS2 (*(volatile unsigned int *)0x400E0490)       // [Priority Register A for Slave 2](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_PRAS3 (*(volatile unsigned int *)0x400E0498)       // [Priority Register A for Slave 3](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_PRAS4 (*(volatile unsigned int *)0x400E04A0)       // [Priority Register A for Slave 4](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_PRAS5 (*(volatile unsigned int *)0x400E04A8)       // [Priority Register A for Slave 5](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_PRAS6 (*(volatile unsigned int *)0x400E04B0)       // [Priority Register A for Slave 6](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_PRAS7 (*(volatile unsigned int *)0x400E04B8)       // [Priority Register A for Slave 7](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_PRAS8 (*(volatile unsigned int *)0x400E04C0)       // [Priority Register A for Slave 8](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1140174)
#define MATRIX_MRCR  (*(volatile unsigned int *)0x400E0500)       // [Master Remap Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1066908)
#define CCFG_SYSIO   (*(volatile unsigned int *)0x400E0514)       // [System I/O Configuration register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1106277)
#define MATRIX_WPMR  (*(volatile unsigned int *)0x400E05E4)       // [Write Protect Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1103323)
#define MATRIX_WPSR  (*(const volatile unsigned int *)0x400E05E8) // [Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G13.1103537)

#define MATRIX_MCFG_ULBT(value) (((value) & 0x7) << 0) // Undefined Length Burst Type

#define MATRIX_SCFG_SLOT_CYCLE(value)    (((value) & 0xFF) << 0) // Maximum Number of Allowed Cycles for a Burst
#define MATRIX_SCFG_DEFMSTR_TYPE(value)  (((value) & 0x3) << 16) // Default Master Type
#define MATRIX_SCFG_FIXED_DEFMSTR(value) (((value) & 0x7) << 18) // Fixed Default Master
#define MATRIX_SCFG_ARBT(value)          (((value) & 0x3) << 24) // Arbitration Type

#define MATRIX_PRAS0_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS0_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS0_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS0_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS0_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS0_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_PRAS1_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS1_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS1_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS1_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS1_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS1_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_PRAS2_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS2_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS2_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS2_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS2_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS2_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_PRAS3_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS3_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS3_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS3_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS3_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS3_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_PRAS4_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS4_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS4_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS4_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS4_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS4_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_PRAS5_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS5_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS5_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS5_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS5_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS5_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_PRAS6_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS6_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS6_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS6_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS6_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS6_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_PRAS7_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS7_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS7_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS7_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS7_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS7_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_PRAS8_M0PR(value) (((value) & 0x3) << 0)  // Master 0 Priority
#define MATRIX_PRAS8_M1PR(value) (((value) & 0x3) << 4)  // Master 1 Priority
#define MATRIX_PRAS8_M2PR(value) (((value) & 0x3) << 8)  // Master 2 Priority
#define MATRIX_PRAS8_M3PR(value) (((value) & 0x3) << 12) // Master 3 Priority
#define MATRIX_PRAS8_M4PR(value) (((value) & 0x3) << 16) // Master 4 Priority
#define MATRIX_PRAS8_M5PR(value) (((value) & 0x3) << 20) // Master 5 Priority

#define MATRIX_MRCR_RCB0        0x00000001             // Remap Command Bit for AHB Master 0
#define MATRIX_MRCR_RCB1        0x00000002             // Remap Command Bit for AHB Master 1
#define MATRIX_MRCR_RCB2        0x00000004             // Remap Command Bit for AHB Master 2
#define MATRIX_MRCR_RCB3        0x00000008             // Remap Command Bit for AHB Master 3
#define MATRIX_MRCR_RCB4(value) (((value) & 0x3) << 4) // Remap Command Bit for AHB Master 4
#define MATRIX_MRCR_RCB5        0x00000040             // Remap Command Bit for AHB Master 5

#define CCFG_SYSIO_SYSIO12 0x00001000 // PC0 or ERASE Assignment

#define MATRIX_WPMR_WPEN         0x00000001                  // Write Protect ENable
#define MATRIX_WPMR_WPKEY(value) (((value) & 0xFFFFFF) << 8) // Write Protect KEY (Write-only)

#define MATRIX_WPSR_WPVS          0x00000001                // Write Protect Violation Status
#define MATRIX_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protect Violation Source

#define PMC_SCER   (*(volatile unsigned int *)0x400E0600)       // [System Clock Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1085992)
#define PMC_SCDR   (*(volatile unsigned int *)0x400E0604)       // [System Clock Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1086183)
#define PMC_SCSR   (*(const volatile unsigned int *)0x400E0608) // [System Clock Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1086375)
#define PMC_PCER0  (*(volatile unsigned int *)0x400E0610)       // [Peripheral Clock Enable Register 0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1174090)
#define PMC_PCDR0  (*(volatile unsigned int *)0x400E0614)       // [Peripheral Clock Disable Register 0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1086754)
#define PMC_PCSR0  (*(const volatile unsigned int *)0x400E0618) // [Peripheral Clock Status Register 0](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1086945)
#define CKGR_UCKR  (*(volatile unsigned int *)0x400E061C)       // [UTMI Clock Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1132112)
#define CKGR_MOR   (*(volatile unsigned int *)0x400E0620)       // [Main Oscillator Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1087133)
#define CKGR_MCFR  (*(const volatile unsigned int *)0x400E0624) // [Main Clock Frequency Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1087374)
#define CKGR_PLLAR (*(volatile unsigned int *)0x400E0628)       // [PLLA Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1087565)
#define PMC_MCKR   (*(volatile unsigned int *)0x400E0630)       // [Master Clock Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1087989)
#define PMC_USB    (*(volatile unsigned int *)0x400E0638)       // [USB Clock Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1139277)
#define PMC_PCK0   (*(volatile unsigned int *)0x400E0644)       // [Programmable Clock 0 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1100636)
#define PMC_PCK1   (*(volatile unsigned int *)0x400E0644)       // [Programmable Clock 0 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1100636)
#define PMC_PCK2   (*(volatile unsigned int *)0x400E0644)       // [Programmable Clock 0 Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1100636)
#define PMC_IER    (*(volatile unsigned int *)0x400E0660)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1088766)
#define PMC_IDR    (*(volatile unsigned int *)0x400E0664)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1088982)
#define PMC_SR     (*(const volatile unsigned int *)0x400E0668) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1089196)
#define PMC_IMR    (*(const volatile unsigned int *)0x400E066C) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1089434)
#define PMC_FSMR   (*(volatile unsigned int *)0x400E0670)       // [Fast Start-up Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1089648)
#define PMC_FSPR   (*(volatile unsigned int *)0x400E0674)       // [Fast Start-up Polarity Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1089849)
#define PMC_FOCR   (*(volatile unsigned int *)0x400E0678)       // [Fault Output Clear Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1090036)
#define PMC_WPMR   (*(volatile unsigned int *)0x400E06E4)       // [Write Protect Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1176768)
#define PMC_WPSR   (*(const volatile unsigned int *)0x400E06E8) // [Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1090494)
#define PMC_PCER1  (*(volatile unsigned int *)0x400E0700)       // [Peripheral Clock Enable Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1090731)
#define PMC_PCDR1  (*(volatile unsigned int *)0x400E0704)       // [Peripheral Clock Disable Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1090921)
#define PMC_PCSR1  (*(const volatile unsigned int *)0x400E0708) // [Peripheral Clock Status Register 1](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1091109)
#define PMC_PCR    (*(volatile unsigned int *)0x400E070C)       // [Peripheral Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G19.1097984)

#define PMC_SCER_UOTGCLK 0x00000020 // Enable USB OTG Clock (48 MHz, USB_48M) for UTMI
#define PMC_SCER_PCK0    0x00000100 // Programmable Clock 0 Output Enable
#define PMC_SCER_PCK1    0x00000200 // Programmable Clock 1 Output Enable
#define PMC_SCER_PCK2    0x00000400 // Programmable Clock 2 Output Enable

#define PMC_SCDR_UOTGCLK 0x00000020 // Disable USB OTG Clock (48 MHz, USB_48M) for UTMI
#define PMC_SCDR_PCK0    0x00000100 // Programmable Clock 0 Output Disable
#define PMC_SCDR_PCK1    0x00000200 // Programmable Clock 1 Output Disable
#define PMC_SCDR_PCK2    0x00000400 // Programmable Clock 2 Output Disable

#define PMC_SCSR_UOTGCLK 0x00000020 // USB OTG Clock (48 MHz, USB_48M) Clock Status
#define PMC_SCSR_PCK0    0x00000100 // Programmable Clock 0 Output Status
#define PMC_SCSR_PCK1    0x00000200 // Programmable Clock 1 Output Status
#define PMC_SCSR_PCK2    0x00000400 // Programmable Clock 2 Output Status

#define PMC_PCER0_PID8  0x00000100 // Peripheral Clock 8 Enable
#define PMC_PCER0_PID9  0x00000200 // Peripheral Clock 9 Enable
#define PMC_PCER0_PID10 0x00000400 // Peripheral Clock 10 Enable
#define PMC_PCER0_PID11 0x00000800 // Peripheral Clock 11 Enable
#define PMC_PCER0_PID12 0x00001000 // Peripheral Clock 12 Enable
#define PMC_PCER0_PID13 0x00002000 // Peripheral Clock 13 Enable
#define PMC_PCER0_PID14 0x00004000 // Peripheral Clock 14 Enable
#define PMC_PCER0_PID15 0x00008000 // Peripheral Clock 15 Enable
#define PMC_PCER0_PID16 0x00010000 // Peripheral Clock 16 Enable
#define PMC_PCER0_PID17 0x00020000 // Peripheral Clock 17 Enable
#define PMC_PCER0_PID18 0x00040000 // Peripheral Clock 18 Enable
#define PMC_PCER0_PID19 0x00080000 // Peripheral Clock 19 Enable
#define PMC_PCER0_PID20 0x00100000 // Peripheral Clock 20 Enable
#define PMC_PCER0_PID21 0x00200000 // Peripheral Clock 21 Enable
#define PMC_PCER0_PID22 0x00400000 // Peripheral Clock 22 Enable
#define PMC_PCER0_PID23 0x00800000 // Peripheral Clock 23 Enable
#define PMC_PCER0_PID24 0x01000000 // Peripheral Clock 24 Enable
#define PMC_PCER0_PID25 0x02000000 // Peripheral Clock 25 Enable
#define PMC_PCER0_PID26 0x04000000 // Peripheral Clock 26 Enable
#define PMC_PCER0_PID27 0x08000000 // Peripheral Clock 27 Enable
#define PMC_PCER0_PID28 0x10000000 // Peripheral Clock 28 Enable
#define PMC_PCER0_PID29 0x20000000 // Peripheral Clock 29 Enable
#define PMC_PCER0_PID30 0x40000000 // Peripheral Clock 30 Enable
#define PMC_PCER0_PID31 0x80000000 // Peripheral Clock 31 Enable

#define PMC_PCDR0_PID8  0x00000100 // Peripheral Clock 8 Disable
#define PMC_PCDR0_PID9  0x00000200 // Peripheral Clock 9 Disable
#define PMC_PCDR0_PID10 0x00000400 // Peripheral Clock 10 Disable
#define PMC_PCDR0_PID11 0x00000800 // Peripheral Clock 11 Disable
#define PMC_PCDR0_PID12 0x00001000 // Peripheral Clock 12 Disable
#define PMC_PCDR0_PID13 0x00002000 // Peripheral Clock 13 Disable
#define PMC_PCDR0_PID14 0x00004000 // Peripheral Clock 14 Disable
#define PMC_PCDR0_PID15 0x00008000 // Peripheral Clock 15 Disable
#define PMC_PCDR0_PID16 0x00010000 // Peripheral Clock 16 Disable
#define PMC_PCDR0_PID17 0x00020000 // Peripheral Clock 17 Disable
#define PMC_PCDR0_PID18 0x00040000 // Peripheral Clock 18 Disable
#define PMC_PCDR0_PID19 0x00080000 // Peripheral Clock 19 Disable
#define PMC_PCDR0_PID20 0x00100000 // Peripheral Clock 20 Disable
#define PMC_PCDR0_PID21 0x00200000 // Peripheral Clock 21 Disable
#define PMC_PCDR0_PID22 0x00400000 // Peripheral Clock 22 Disable
#define PMC_PCDR0_PID23 0x00800000 // Peripheral Clock 23 Disable
#define PMC_PCDR0_PID24 0x01000000 // Peripheral Clock 24 Disable
#define PMC_PCDR0_PID25 0x02000000 // Peripheral Clock 25 Disable
#define PMC_PCDR0_PID26 0x04000000 // Peripheral Clock 26 Disable
#define PMC_PCDR0_PID27 0x08000000 // Peripheral Clock 27 Disable
#define PMC_PCDR0_PID28 0x10000000 // Peripheral Clock 28 Disable
#define PMC_PCDR0_PID29 0x20000000 // Peripheral Clock 29 Disable
#define PMC_PCDR0_PID30 0x40000000 // Peripheral Clock 30 Disable
#define PMC_PCDR0_PID31 0x80000000 // Peripheral Clock 31 Disable

#define PMC_PCSR0_PID8  0x00000100 // Peripheral Clock 8 Status
#define PMC_PCSR0_PID9  0x00000200 // Peripheral Clock 9 Status
#define PMC_PCSR0_PID10 0x00000400 // Peripheral Clock 10 Status
#define PMC_PCSR0_PID11 0x00000800 // Peripheral Clock 11 Status
#define PMC_PCSR0_PID12 0x00001000 // Peripheral Clock 12 Status
#define PMC_PCSR0_PID13 0x00002000 // Peripheral Clock 13 Status
#define PMC_PCSR0_PID14 0x00004000 // Peripheral Clock 14 Status
#define PMC_PCSR0_PID15 0x00008000 // Peripheral Clock 15 Status
#define PMC_PCSR0_PID16 0x00010000 // Peripheral Clock 16 Status
#define PMC_PCSR0_PID17 0x00020000 // Peripheral Clock 17 Status
#define PMC_PCSR0_PID18 0x00040000 // Peripheral Clock 18 Status
#define PMC_PCSR0_PID19 0x00080000 // Peripheral Clock 19 Status
#define PMC_PCSR0_PID20 0x00100000 // Peripheral Clock 20 Status
#define PMC_PCSR0_PID21 0x00200000 // Peripheral Clock 21 Status
#define PMC_PCSR0_PID22 0x00400000 // Peripheral Clock 22 Status
#define PMC_PCSR0_PID23 0x00800000 // Peripheral Clock 23 Status
#define PMC_PCSR0_PID24 0x01000000 // Peripheral Clock 24 Status
#define PMC_PCSR0_PID25 0x02000000 // Peripheral Clock 25 Status
#define PMC_PCSR0_PID26 0x04000000 // Peripheral Clock 26 Status
#define PMC_PCSR0_PID27 0x08000000 // Peripheral Clock 27 Status
#define PMC_PCSR0_PID28 0x10000000 // Peripheral Clock 28 Status
#define PMC_PCSR0_PID29 0x20000000 // Peripheral Clock 29 Status
#define PMC_PCSR0_PID30 0x40000000 // Peripheral Clock 30 Status
#define PMC_PCSR0_PID31 0x80000000 // Peripheral Clock 31 Status

#define CKGR_UCKR_UPLLEN           0x00010000              // UTMI PLL Enable
#define CKGR_UCKR_UPLLCOUNT(value) (((value) & 0xF) << 20) // UTMI PLL Start-up Time

#define CKGR_MOR_MOSCXTEN        0x00000001              // Main Crystal Oscillator Enable
#define CKGR_MOR_MOSCXTBY        0x00000002              // Main Crystal Oscillator Bypass
#define CKGR_MOR_MOSCRCEN        0x00000008              // Main On-Chip RC Oscillator Enable
#define CKGR_MOR_MOSCRCF_4_MHz   0x00000000              // The Fast RC Oscillator Frequency is at 4 MHz (default)
#define CKGR_MOR_MOSCRCF_8_MHz   0x00000010              // The Fast RC Oscillator Frequency is at 8 MHz
#define CKGR_MOR_MOSCRCF_12_MHz  0x00000020              // The Fast RC Oscillator Frequency is at 12 MHz
#define CKGR_MOR_MOSCXTST(value) (((value) & 0xFF) << 8) // Main Crystal Oscillator Start-up Time
#define CKGR_MOR_KEY_PASSWD      0x00370000              // Writing any other value in this field aborts the write operation.Always reads as 0
#define CKGR_MOR_MOSCSEL         0x01000000              // Main Oscillator Selection
#define CKGR_MOR_CFDEN           0x02000000              // Clock Failure Detector Enable

#define CKGR_MCFR_MAINF(value) (((value) & 0xFFFF) << 0) // Main Clock Frequency
#define CKGR_MCFR_MAINFRDY     0x00010000                // Main Clock Ready

#define CKGR_PLLAR_DIVA(value)      (((value) & 0xFF) << 0)   // Divider
#define CKGR_PLLAR_PLLACOUNT(value) (((value) & 0x3F) << 8)   // PLLA Counter
#define CKGR_PLLAR_MULA(value)      (((value) & 0x7FF) << 16) // PLLA Multiplier
#define CKGR_PLLAR_ONE              0x20000000                // Must Be Set to 1

#define PMC_MCKR_CSS_SLOW_CLK 0x00000000 // Slow Clock is selected
#define PMC_MCKR_CSS_MAIN_CLK 0x00000001 // Main Clock is selected
#define PMC_MCKR_CSS_PLLA_CLK 0x00000002 // PLLA Clock is selected
#define PMC_MCKR_CSS_UPLL_CLK 0x00000003 // UPLL Clock is selected
#define PMC_MCKR_PRES_CLK_1   0x00000000 // Selected clock
#define PMC_MCKR_PRES_CLK_2   0x00000010 // Selected clock divided by 2
#define PMC_MCKR_PRES_CLK_4   0x00000020 // Selected clock divided by 4
#define PMC_MCKR_PRES_CLK_8   0x00000030 // Selected clock divided by 8
#define PMC_MCKR_PRES_CLK_16  0x00000040 // Selected clock divided by 16
#define PMC_MCKR_PRES_CLK_32  0x00000050 // Selected clock divided by 32
#define PMC_MCKR_PRES_CLK_64  0x00000060 // Selected clock divided by 64
#define PMC_MCKR_PRES_CLK_3   0x00000070 // Selected clock divided by 3
#define PMC_MCKR_PLLADIV2     0x00001000 // PLLA Divisor by 2
#define PMC_MCKR_UPLLDIV2     0x00002000 //

#define PMC_USB_USBS          0x00000001             // USB Input Clock Selection
#define PMC_USB_USBDIV(value) (((value) & 0xF) << 8) // Divider for USB Clock

#define PMC_PCK_CSS_SLOW_CLK 0x00000000 // Slow Clock is selected
#define PMC_PCK_CSS_MAIN_CLK 0x00000001 // Main Clock is selected
#define PMC_PCK_CSS_PLLA_CLK 0x00000002 // PLLA Clock is selected
#define PMC_PCK_CSS_UPLL_CLK 0x00000003 // UPLL Clock is selected
#define PMC_PCK_CSS_MCK      0x00000004 // Master Clock is selected
#define PMC_PCK_PRES_CLK_1   0x00000000 // Selected clock
#define PMC_PCK_PRES_CLK_2   0x00000010 // Selected clock divided by 2
#define PMC_PCK_PRES_CLK_4   0x00000020 // Selected clock divided by 4
#define PMC_PCK_PRES_CLK_8   0x00000030 // Selected clock divided by 8
#define PMC_PCK_PRES_CLK_16  0x00000040 // Selected clock divided by 16
#define PMC_PCK_PRES_CLK_32  0x00000050 // Selected clock divided by 32
#define PMC_PCK_PRES_CLK_64  0x00000060 // Selected clock divided by 64

#define PMC_IER_MOSCXTS  0x00000001 // Main Crystal Oscillator Status Interrupt Enable
#define PMC_IER_LOCKA    0x00000002 // PLLA Lock Interrupt Enable
#define PMC_IER_MCKRDY   0x00000008 // Master Clock Ready Interrupt Enable
#define PMC_IER_LOCKU    0x00000040 // UTMI PLL Lock Interrupt Enable
#define PMC_IER_PCKRDY0  0x00000100 // Programmable Clock Ready 0 Interrupt Enable
#define PMC_IER_PCKRDY1  0x00000200 // Programmable Clock Ready 1 Interrupt Enable
#define PMC_IER_PCKRDY2  0x00000400 // Programmable Clock Ready 2 Interrupt Enable
#define PMC_IER_MOSCSELS 0x00010000 // Main Oscillator Selection Status Interrupt Enable
#define PMC_IER_MOSCRCS  0x00020000 // Main On-Chip RC Status Interrupt Enable
#define PMC_IER_CFDEV    0x00040000 // Clock Failure Detector Event Interrupt Enable

#define PMC_IDR_MOSCXTS  0x00000001 // Main Crystal Oscillator Status Interrupt Disable
#define PMC_IDR_LOCKA    0x00000002 // PLLA Lock Interrupt Disable
#define PMC_IDR_MCKRDY   0x00000008 // Master Clock Ready Interrupt Disable
#define PMC_IDR_LOCKU    0x00000040 // UTMI PLL Lock Interrupt Disable
#define PMC_IDR_PCKRDY0  0x00000100 // Programmable Clock Ready 0 Interrupt Disable
#define PMC_IDR_PCKRDY1  0x00000200 // Programmable Clock Ready 1 Interrupt Disable
#define PMC_IDR_PCKRDY2  0x00000400 // Programmable Clock Ready 2 Interrupt Disable
#define PMC_IDR_MOSCSELS 0x00010000 // Main Oscillator Selection Status Interrupt Disable
#define PMC_IDR_MOSCRCS  0x00020000 // Main On-Chip RC Status Interrupt Disable
#define PMC_IDR_CFDEV    0x00040000 // Clock Failure Detector Event Interrupt Disable

#define PMC_SR_MOSCXTS  0x00000001 // Main XTAL Oscillator Status
#define PMC_SR_LOCKA    0x00000002 // PLLA Lock Status
#define PMC_SR_MCKRDY   0x00000008 // Master Clock Status
#define PMC_SR_LOCKU    0x00000040 // UTMI PLL Lock Status
#define PMC_SR_OSCSELS  0x00000080 // Slow Clock Oscillator Selection
#define PMC_SR_PCKRDY0  0x00000100 // Programmable Clock Ready Status
#define PMC_SR_PCKRDY1  0x00000200 // Programmable Clock Ready Status
#define PMC_SR_PCKRDY2  0x00000400 // Programmable Clock Ready Status
#define PMC_SR_MOSCSELS 0x00010000 // Main Oscillator Selection Status
#define PMC_SR_MOSCRCS  0x00020000 // Main On-Chip RC Oscillator Status
#define PMC_SR_CFDEV    0x00040000 // Clock Failure Detector Event
#define PMC_SR_CFDS     0x00080000 // Clock Failure Detector Status
#define PMC_SR_FOS      0x00100000 // Clock Failure Detector Fault Output Status

#define PMC_IMR_MOSCXTS  0x00000001 // Main Crystal Oscillator Status Interrupt Mask
#define PMC_IMR_LOCKA    0x00000002 // PLLA Lock Interrupt Mask
#define PMC_IMR_MCKRDY   0x00000008 // Master Clock Ready Interrupt Mask
#define PMC_IMR_LOCKU    0x00000040 // UTMI PLL Lock Interrupt Mask
#define PMC_IMR_PCKRDY0  0x00000100 // Programmable Clock Ready 0 Interrupt Mask
#define PMC_IMR_PCKRDY1  0x00000200 // Programmable Clock Ready 1 Interrupt Mask
#define PMC_IMR_PCKRDY2  0x00000400 // Programmable Clock Ready 2 Interrupt Mask
#define PMC_IMR_MOSCSELS 0x00010000 // Main Oscillator Selection Status Interrupt Mask
#define PMC_IMR_MOSCRCS  0x00020000 // Main On-Chip RC Status Interrupt Mask
#define PMC_IMR_CFDEV    0x00040000 // Clock Failure Detector Event Interrupt Mask

#define PMC_FSMR_FSTT0  0x00000001 // Fast Start-up Input Enable 0
#define PMC_FSMR_FSTT1  0x00000002 // Fast Start-up Input Enable 1
#define PMC_FSMR_FSTT2  0x00000004 // Fast Start-up Input Enable 2
#define PMC_FSMR_FSTT3  0x00000008 // Fast Start-up Input Enable 3
#define PMC_FSMR_FSTT4  0x00000010 // Fast Start-up Input Enable 4
#define PMC_FSMR_FSTT5  0x00000020 // Fast Start-up Input Enable 5
#define PMC_FSMR_FSTT6  0x00000040 // Fast Start-up Input Enable 6
#define PMC_FSMR_FSTT7  0x00000080 // Fast Start-up Input Enable 7
#define PMC_FSMR_FSTT8  0x00000100 // Fast Start-up Input Enable 8
#define PMC_FSMR_FSTT9  0x00000200 // Fast Start-up Input Enable 9
#define PMC_FSMR_FSTT10 0x00000400 // Fast Start-up Input Enable 10
#define PMC_FSMR_FSTT11 0x00000800 // Fast Start-up Input Enable 11
#define PMC_FSMR_FSTT12 0x00001000 // Fast Start-up Input Enable 12
#define PMC_FSMR_FSTT13 0x00002000 // Fast Start-up Input Enable 13
#define PMC_FSMR_FSTT14 0x00004000 // Fast Start-up Input Enable 14
#define PMC_FSMR_FSTT15 0x00008000 // Fast Start-up Input Enable 15
#define PMC_FSMR_RTTAL  0x00010000 // RTT Alarm Enable
#define PMC_FSMR_RTCAL  0x00020000 // RTC Alarm Enable
#define PMC_FSMR_USBAL  0x00040000 // USB Alarm Enable
#define PMC_FSMR_LPM    0x00100000 // Low Power Mode

#define PMC_FSPR_FSTP0  0x00000001 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP1  0x00000002 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP2  0x00000004 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP3  0x00000008 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP4  0x00000010 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP5  0x00000020 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP6  0x00000040 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP7  0x00000080 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP8  0x00000100 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP9  0x00000200 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP10 0x00000400 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP11 0x00000800 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP12 0x00001000 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP13 0x00002000 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP14 0x00004000 // Fast Start-up Input Polarityx
#define PMC_FSPR_FSTP15 0x00008000 // Fast Start-up Input Polarityx

#define PMC_FOCR_FOCLR 0x00000001 // Fault Output Clear

#define PMC_WPMR_WPEN         0x00000001 // Write Protect Enable
#define PMC_WPMR_WPKEY_PASSWD 0x504D4300 // Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0

#define PMC_WPSR_WPVS          0x00000001                // Write Protect Violation Status
#define PMC_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protect Violation Source

#define PMC_PCER1_PID32 0x00000001 // Peripheral Clock 32 Enable
#define PMC_PCER1_PID33 0x00000002 // Peripheral Clock 33 Enable
#define PMC_PCER1_PID34 0x00000004 // Peripheral Clock 34 Enable
#define PMC_PCER1_PID35 0x00000008 // Peripheral Clock 35 Enable
#define PMC_PCER1_PID36 0x00000010 // Peripheral Clock 36 Enable
#define PMC_PCER1_PID37 0x00000020 // Peripheral Clock 37 Enable
#define PMC_PCER1_PID38 0x00000040 // Peripheral Clock 38 Enable
#define PMC_PCER1_PID39 0x00000080 // Peripheral Clock 39 Enable
#define PMC_PCER1_PID40 0x00000100 // Peripheral Clock 40 Enable
#define PMC_PCER1_PID41 0x00000200 // Peripheral Clock 41 Enable
#define PMC_PCER1_PID42 0x00000400 // Peripheral Clock 42 Enable
#define PMC_PCER1_PID43 0x00000800 // Peripheral Clock 43 Enable
#define PMC_PCER1_PID44 0x00001000 // Peripheral Clock 44 Enable

#define PMC_PCDR1_PID32 0x00000001 // Peripheral Clock 32 Disable
#define PMC_PCDR1_PID33 0x00000002 // Peripheral Clock 33 Disable
#define PMC_PCDR1_PID34 0x00000004 // Peripheral Clock 34 Disable
#define PMC_PCDR1_PID35 0x00000008 // Peripheral Clock 35 Disable
#define PMC_PCDR1_PID36 0x00000010 // Peripheral Clock 36 Disable
#define PMC_PCDR1_PID37 0x00000020 // Peripheral Clock 37 Disable
#define PMC_PCDR1_PID38 0x00000040 // Peripheral Clock 38 Disable
#define PMC_PCDR1_PID39 0x00000080 // Peripheral Clock 39 Disable
#define PMC_PCDR1_PID40 0x00000100 // Peripheral Clock 40 Disable
#define PMC_PCDR1_PID41 0x00000200 // Peripheral Clock 41 Disable
#define PMC_PCDR1_PID42 0x00000400 // Peripheral Clock 42 Disable
#define PMC_PCDR1_PID43 0x00000800 // Peripheral Clock 43 Disable
#define PMC_PCDR1_PID44 0x00001000 // Peripheral Clock 44 Disable

#define PMC_PCSR1_PID32 0x00000001 // Peripheral Clock 32 Status
#define PMC_PCSR1_PID33 0x00000002 // Peripheral Clock 33 Status
#define PMC_PCSR1_PID34 0x00000004 // Peripheral Clock 34 Status
#define PMC_PCSR1_PID35 0x00000008 // Peripheral Clock 35 Status
#define PMC_PCSR1_PID36 0x00000010 // Peripheral Clock 36 Status
#define PMC_PCSR1_PID37 0x00000020 // Peripheral Clock 37 Status
#define PMC_PCSR1_PID38 0x00000040 // Peripheral Clock 38 Status
#define PMC_PCSR1_PID39 0x00000080 // Peripheral Clock 39 Status
#define PMC_PCSR1_PID40 0x00000100 // Peripheral Clock 40 Status
#define PMC_PCSR1_PID41 0x00000200 // Peripheral Clock 41 Status
#define PMC_PCSR1_PID42 0x00000400 // Peripheral Clock 42 Status
#define PMC_PCSR1_PID43 0x00000800 // Peripheral Clock 43 Status
#define PMC_PCSR1_PID44 0x00001000 // Peripheral Clock 44 Status

#define PMC_PCR_PID(value)          (((value) & 0x3F) << 0) // Peripheral ID
#define PMC_PCR_CMD                 0x00001000              // Command
#define PMC_PCR_DIV_PERIPH_DIV_MCK  0x00000000              // Peripheral clock is MCK
#define PMC_PCR_DIV_PERIPH_DIV2_MCK 0x00010000              // Peripheral clock is MCK/2
#define PMC_PCR_DIV_PERIPH_DIV4_MCK 0x00020000              // Peripheral clock is MCK/4
#define PMC_PCR_EN                  0x10000000              // Enable

#define UART_CR   (*(volatile unsigned int *)0x400E0800)       // [Control Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1075798)
#define UART_MR   (*(volatile unsigned int *)0x400E0804)       // [Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1076000)
#define UART_IER  (*(volatile unsigned int *)0x400E0808)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1076263)
#define UART_IDR  (*(volatile unsigned int *)0x400E080C)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1076456)
#define UART_IMR  (*(const volatile unsigned int *)0x400E0810) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1076649)
#define UART_SR   (*(const volatile unsigned int *)0x400E0814) // [Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1076842)
#define UART_RHR  (*(const volatile unsigned int *)0x400E0818) // [Receive Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1077053)
#define UART_THR  (*(volatile unsigned int *)0x400E081C)       // [Transmit Holding Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1077237)
#define UART_BRGR (*(volatile unsigned int *)0x400E0820)       // [Baud Rate Generator Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G25.1077420)
#define UART_RPR  (*(volatile unsigned int *)0x400E0900)       // [Receive Pointer Register]()
#define UART_RCR  (*(volatile unsigned int *)0x400E0904)       // [Receive Counter Register]()
#define UART_TPR  (*(volatile unsigned int *)0x400E0908)       // [Transmit Pointer Register]()
#define UART_TCR  (*(volatile unsigned int *)0x400E090C)       // [Transmit Counter Register]()
#define UART_RNPR (*(volatile unsigned int *)0x400E0910)       // [Receive Next Pointer Register]()
#define UART_RNCR (*(volatile unsigned int *)0x400E0914)       // [Receive Next Counter Register]()
#define UART_TNPR (*(volatile unsigned int *)0x400E0918)       // [Transmit Next Pointer Register]()
#define UART_TNCR (*(volatile unsigned int *)0x400E091C)       // [Transmit Next Counter Register]()
#define UART_PTCR (*(volatile unsigned int *)0x400E0920)       // [Transfer Control Register]()
#define UART_PTSR (*(const volatile unsigned int *)0x400E0924) // [Transfer Status Register]()

#define UART_CR_RSTRX  0x00000004 // Reset Receiver
#define UART_CR_RSTTX  0x00000008 // Reset Transmitter
#define UART_CR_RXEN   0x00000010 // Receiver Enable
#define UART_CR_RXDIS  0x00000020 // Receiver Disable
#define UART_CR_TXEN   0x00000040 // Transmitter Enable
#define UART_CR_TXDIS  0x00000080 // Transmitter Disable
#define UART_CR_RSTSTA 0x00000100 // Reset Status Bits

#define UART_MR_PAR_EVEN               0x00000000 // Even Parity
#define UART_MR_PAR_ODD                0x00000200 // Odd Parity
#define UART_MR_PAR_SPACE              0x00000400 // Space: parity forced to 0
#define UART_MR_PAR_MARK               0x00000600 // Mark: parity forced to 1
#define UART_MR_PAR_NO                 0x00000800 // No Parity
#define UART_MR_CHMODE_NORMAL          0x00000000 // Normal Mode
#define UART_MR_CHMODE_AUTOMATIC       0x00004000 // Automatic Echo
#define UART_MR_CHMODE_LOCAL_LOOPBACK  0x00008000 // Local Loopback
#define UART_MR_CHMODE_REMOTE_LOOPBACK 0x0000C000 // Remote Loopback

#define UART_IER_RXRDY   0x00000001 // Enable RXRDY Interrupt
#define UART_IER_TXRDY   0x00000002 // Enable TXRDY Interrupt
#define UART_IER_ENDRX   0x00000008 // Enable End of Receive Transfer Interrupt
#define UART_IER_ENDTX   0x00000010 // Enable End of Transmit Interrupt
#define UART_IER_OVRE    0x00000020 // Enable Overrun Error Interrupt
#define UART_IER_FRAME   0x00000040 // Enable Framing Error Interrupt
#define UART_IER_PARE    0x00000080 // Enable Parity Error Interrupt
#define UART_IER_TXEMPTY 0x00000200 // Enable TXEMPTY Interrupt
#define UART_IER_TXBUFE  0x00000800 // Enable Buffer Empty Interrupt
#define UART_IER_RXBUFF  0x00001000 // Enable Buffer Full Interrupt

#define UART_IDR_RXRDY   0x00000001 // Disable RXRDY Interrupt
#define UART_IDR_TXRDY   0x00000002 // Disable TXRDY Interrupt
#define UART_IDR_ENDRX   0x00000008 // Disable End of Receive Transfer Interrupt
#define UART_IDR_ENDTX   0x00000010 // Disable End of Transmit Interrupt
#define UART_IDR_OVRE    0x00000020 // Disable Overrun Error Interrupt
#define UART_IDR_FRAME   0x00000040 // Disable Framing Error Interrupt
#define UART_IDR_PARE    0x00000080 // Disable Parity Error Interrupt
#define UART_IDR_TXEMPTY 0x00000200 // Disable TXEMPTY Interrupt
#define UART_IDR_TXBUFE  0x00000800 // Disable Buffer Empty Interrupt
#define UART_IDR_RXBUFF  0x00001000 // Disable Buffer Full Interrupt

#define UART_IMR_RXRDY   0x00000001 // Mask RXRDY Interrupt
#define UART_IMR_TXRDY   0x00000002 // Disable TXRDY Interrupt
#define UART_IMR_ENDRX   0x00000008 // Mask End of Receive Transfer Interrupt
#define UART_IMR_ENDTX   0x00000010 // Mask End of Transmit Interrupt
#define UART_IMR_OVRE    0x00000020 // Mask Overrun Error Interrupt
#define UART_IMR_FRAME   0x00000040 // Mask Framing Error Interrupt
#define UART_IMR_PARE    0x00000080 // Mask Parity Error Interrupt
#define UART_IMR_TXEMPTY 0x00000200 // Mask TXEMPTY Interrupt
#define UART_IMR_TXBUFE  0x00000800 // Mask TXBUFE Interrupt
#define UART_IMR_RXBUFF  0x00001000 // Mask RXBUFF Interrupt

#define UART_SR_RXRDY   0x00000001 // Receiver Ready
#define UART_SR_TXRDY   0x00000002 // Transmitter Ready
#define UART_SR_ENDRX   0x00000008 // End of Receiver Transfer
#define UART_SR_ENDTX   0x00000010 // End of Transmitter Transfer
#define UART_SR_OVRE    0x00000020 // Overrun Error
#define UART_SR_FRAME   0x00000040 // Framing Error
#define UART_SR_PARE    0x00000080 // Parity Error
#define UART_SR_TXEMPTY 0x00000200 // Transmitter Empty
#define UART_SR_TXBUFE  0x00000800 // Transmission Buffer Empty
#define UART_SR_RXBUFF  0x00001000 // Receive Buffer Full

#define UART_RHR_RXCHR(value) (((value) & 0xFF) << 0) // Received Character

#define UART_THR_TXCHR(value) (((value) & 0xFF) << 0) // Character to be Transmitted

#define UART_BRGR_CD(value) (((value) & 0xFFFF) << 0) // Clock Divisor

#define UART_RPR_RXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Pointer Register

#define UART_RCR_RXCTR(value) (((value) & 0xFFFF) << 0) // Receive Counter Register

#define UART_TPR_TXPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Counter Register

#define UART_TCR_TXCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Register

#define UART_RNPR_RXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Receive Next Pointer

#define UART_RNCR_RXNCTR(value) (((value) & 0xFFFF) << 0) // Receive Next Counter

#define UART_TNPR_TXNPTR(value) (((value) & 0xFFFFFFFF) << 0) // Transmit Next Pointer

#define UART_TNCR_TXNCTR(value) (((value) & 0xFFFF) << 0) // Transmit Counter Next

#define UART_PTCR_RXTEN  0x00000001 // Receiver Transfer Enable
#define UART_PTCR_RXTDIS 0x00000002 // Receiver Transfer Disable
#define UART_PTCR_TXTEN  0x00000100 // Transmitter Transfer Enable
#define UART_PTCR_TXTDIS 0x00000200 // Transmitter Transfer Disable

#define UART_PTSR_RXTEN 0x00000001 // Receiver Transfer Enable
#define UART_PTSR_TXTEN 0x00000100 // Transmitter Transfer Enable

#define CHIPID_CIDR (*(const volatile unsigned int *)0x400E0940) // [Chip ID Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G20.1070013)
#define CHIPID_EXID (*(const volatile unsigned int *)0x400E0944) // [Chip ID Extension Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G20.1070659)

#define CHIPID_CIDR_VERSION(value)   (((value) & 0x1F) << 0) // Version of the Device
#define CHIPID_CIDR_EPROC_ARM946ES   0x00000020              // ARM946ES
#define CHIPID_CIDR_EPROC_ARM7TDMI   0x00000040              // ARM7TDMI
#define CHIPID_CIDR_EPROC_CM3        0x00000060              // Cortex-M3
#define CHIPID_CIDR_EPROC_ARM920T    0x00000080              // ARM920T
#define CHIPID_CIDR_EPROC_ARM926EJS  0x000000A0              // ARM926EJS
#define CHIPID_CIDR_EPROC_CA5        0x000000C0              // Cortex-A5
#define CHIPID_CIDR_EPROC_CM4        0x000000E0              // Cortex-M4
#define CHIPID_CIDR_NVPSIZ_NONE      0x00000000              // None
#define CHIPID_CIDR_NVPSIZ_8K        0x00000100              // 8 Kbytes
#define CHIPID_CIDR_NVPSIZ_16K       0x00000200              // 16 Kbytes
#define CHIPID_CIDR_NVPSIZ_32K       0x00000300              // 32 Kbytes
#define CHIPID_CIDR_NVPSIZ_64K       0x00000500              // 64 Kbytes
#define CHIPID_CIDR_NVPSIZ_128K      0x00000700              // 128 Kbytes
#define CHIPID_CIDR_NVPSIZ_256K      0x00000900              // 256 Kbytes
#define CHIPID_CIDR_NVPSIZ_512K      0x00000A00              // 512 Kbytes
#define CHIPID_CIDR_NVPSIZ_1024K     0x00000C00              // 1024 Kbytes
#define CHIPID_CIDR_NVPSIZ_2048K     0x00000E00              // 2048 Kbytes
#define CHIPID_CIDR_NVPSIZ2_NONE     0x00000000              // None
#define CHIPID_CIDR_NVPSIZ2_8K       0x00001000              // 8 Kbytes
#define CHIPID_CIDR_NVPSIZ2_16K      0x00002000              // 16 Kbytes
#define CHIPID_CIDR_NVPSIZ2_32K      0x00003000              // 32 Kbytes
#define CHIPID_CIDR_NVPSIZ2_64K      0x00005000              // 64 Kbytes
#define CHIPID_CIDR_NVPSIZ2_128K     0x00007000              // 128 Kbytes
#define CHIPID_CIDR_NVPSIZ2_256K     0x00009000              // 256 Kbytes
#define CHIPID_CIDR_NVPSIZ2_512K     0x0000A000              // 512 Kbytes
#define CHIPID_CIDR_NVPSIZ2_1024K    0x0000C000              // 1024 Kbytes
#define CHIPID_CIDR_NVPSIZ2_2048K    0x0000E000              // 2048 Kbytes
#define CHIPID_CIDR_SRAMSIZ_48K      0x00000000              // 48 Kbytes
#define CHIPID_CIDR_SRAMSIZ_192K     0x00010000              // 192 Kbytes
#define CHIPID_CIDR_SRAMSIZ_2K       0x00020000              // 2 Kbytes
#define CHIPID_CIDR_SRAMSIZ_6K       0x00030000              // 6 Kbytes
#define CHIPID_CIDR_SRAMSIZ_24K      0x00040000              // 24 Kbytes
#define CHIPID_CIDR_SRAMSIZ_4K       0x00050000              // 4 Kbytes
#define CHIPID_CIDR_SRAMSIZ_80K      0x00060000              // 80 Kbytes
#define CHIPID_CIDR_SRAMSIZ_160K     0x00070000              // 160 Kbytes
#define CHIPID_CIDR_SRAMSIZ_8K       0x00080000              // 8 Kbytes
#define CHIPID_CIDR_SRAMSIZ_16K      0x00090000              // 16 Kbytes
#define CHIPID_CIDR_SRAMSIZ_32K      0x000A0000              // 32 Kbytes
#define CHIPID_CIDR_SRAMSIZ_64K      0x000B0000              // 64 Kbytes
#define CHIPID_CIDR_SRAMSIZ_128K     0x000C0000              // 128 Kbytes
#define CHIPID_CIDR_SRAMSIZ_256K     0x000D0000              // 256 Kbytes
#define CHIPID_CIDR_SRAMSIZ_96K      0x000E0000              // 96 Kbytes
#define CHIPID_CIDR_SRAMSIZ_512K     0x000F0000              // 512 Kbytes
#define CHIPID_CIDR_ARCH_SAM3AxC     0x08300000              // SAM3AxC (100-pin version)
#define CHIPID_CIDR_ARCH_SAM3XxC     0x08400000              // SAM3XxC (100-pin version)
#define CHIPID_CIDR_ARCH_SAM3XxE     0x08500000              // SAM3XxE (144-pin version)
#define CHIPID_CIDR_ARCH_SAM3XxG     0x08600000              // SAM3XxG (208/217-pin version)
#define CHIPID_CIDR_NVPTYP_ROM       0x00000000              // ROM
#define CHIPID_CIDR_NVPTYP_ROMLESS   0x10000000              // ROMless or on-chip Flash
#define CHIPID_CIDR_NVPTYP_FLASH     0x20000000              // Embedded Flash Memory
#define CHIPID_CIDR_NVPTYP_ROM_FLASH 0x30000000              // ROM and Embedded Flash Memory- NVPSIZ is ROM size- NVPSIZ2 is Flash size
#define CHIPID_CIDR_NVPTYP_SRAM      0x40000000              // SRAM emulating ROM
#define CHIPID_CIDR_EXT              0x80000000              // Extension Flag

#define CHIPID_EXID_EXID(value) (((value) & 0xFFFFFFFF) << 0) // Chip ID Extension

#define EFC0_FMR (*(volatile unsigned int *)0x400E0A00)       // [EEFC Flash Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G10.1081257)
#define EFC0_FCR (*(volatile unsigned int *)0x400E0A04)       // [EEFC Flash Command Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G10.1117728)
#define EFC0_FSR (*(const volatile unsigned int *)0x400E0A08) // [EEFC Flash Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G10.1083017)
#define EFC0_FRR (*(const volatile unsigned int *)0x400E0A0C) // [EEFC Flash Result Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G10.1089158)

#define EFC0_FMR_FRDY       0x00000001             // Ready Interrupt Enable
#define EFC0_FMR_FWS(value) (((value) & 0xF) << 8) // Flash Wait State
#define EFC0_FMR_SCOD       0x00010000             // Sequential Code Optimization Disable
#define EFC0_FMR_FAM        0x01000000             // Flash Access Mode

#define EFC0_FCR_FCMD_GETD   0x00000000                // Get Flash Descriptor
#define EFC0_FCR_FCMD_WP     0x00000001                // Write page
#define EFC0_FCR_FCMD_WPL    0x00000002                // Write page and lock
#define EFC0_FCR_FCMD_EWP    0x00000003                // Erase page and write page
#define EFC0_FCR_FCMD_EWPL   0x00000004                // Erase page and write page then lock
#define EFC0_FCR_FCMD_EA     0x00000005                // Erase all
#define EFC0_FCR_FCMD_SLB    0x00000008                // Set Lock Bit
#define EFC0_FCR_FCMD_CLB    0x00000009                // Clear Lock Bit
#define EFC0_FCR_FCMD_GLB    0x0000000A                // Get Lock Bit
#define EFC0_FCR_FCMD_SGPB   0x0000000B                // Set GPNVM Bit
#define EFC0_FCR_FCMD_CGPB   0x0000000C                // Clear GPNVM Bit
#define EFC0_FCR_FCMD_GGPB   0x0000000D                // Get GPNVM Bit
#define EFC0_FCR_FCMD_STUI   0x0000000E                // Start Read Unique Identifier
#define EFC0_FCR_FCMD_SPUI   0x0000000F                // Stop Read Unique Identifier
#define EFC0_FCR_FCMD_GCALB  0x00000010                // Get CALIB Bit
#define EFC0_FCR_FARG(value) (((value) & 0xFFFF) << 8) // Flash Command Argument
#define EFC0_FCR_FKEY_PASSWD 0x5A000000                // The 0x5A value enables the command defined by the bits of the register. If the field is written with a different value, the write is not performed and no action is started

#define EFC0_FSR_FRDY   0x00000001 // Flash Ready Status
#define EFC0_FSR_FCMDE  0x00000002 // Flash Command Error Status
#define EFC0_FSR_FLOCKE 0x00000004 // Flash Lock Error Status

#define EFC0_FRR_FVALUE(value) (((value) & 0xFFFFFFFF) << 0) // Flash Result Value

#define EFC1_FMR (*(volatile unsigned int *)0x400E0C00)       // [EEFC Flash Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G10.1081257)
#define EFC1_FCR (*(volatile unsigned int *)0x400E0C04)       // [EEFC Flash Command Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G10.1117728)
#define EFC1_FSR (*(const volatile unsigned int *)0x400E0C08) // [EEFC Flash Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G10.1083017)
#define EFC1_FRR (*(const volatile unsigned int *)0x400E0C0C) // [EEFC Flash Result Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G10.1089158)

#define EFC1_FMR_FRDY       0x00000001             // Ready Interrupt Enable
#define EFC1_FMR_FWS(value) (((value) & 0xF) << 8) // Flash Wait State
#define EFC1_FMR_SCOD       0x00010000             // Sequential Code Optimization Disable
#define EFC1_FMR_FAM        0x01000000             // Flash Access Mode

#define EFC1_FCR_FCMD_GETD   0x00000000                // Get Flash Descriptor
#define EFC1_FCR_FCMD_WP     0x00000001                // Write page
#define EFC1_FCR_FCMD_WPL    0x00000002                // Write page and lock
#define EFC1_FCR_FCMD_EWP    0x00000003                // Erase page and write page
#define EFC1_FCR_FCMD_EWPL   0x00000004                // Erase page and write page then lock
#define EFC1_FCR_FCMD_EA     0x00000005                // Erase all
#define EFC1_FCR_FCMD_SLB    0x00000008                // Set Lock Bit
#define EFC1_FCR_FCMD_CLB    0x00000009                // Clear Lock Bit
#define EFC1_FCR_FCMD_GLB    0x0000000A                // Get Lock Bit
#define EFC1_FCR_FCMD_SGPB   0x0000000B                // Set GPNVM Bit
#define EFC1_FCR_FCMD_CGPB   0x0000000C                // Clear GPNVM Bit
#define EFC1_FCR_FCMD_GGPB   0x0000000D                // Get GPNVM Bit
#define EFC1_FCR_FCMD_STUI   0x0000000E                // Start Read Unique Identifier
#define EFC1_FCR_FCMD_SPUI   0x0000000F                // Stop Read Unique Identifier
#define EFC1_FCR_FCMD_GCALB  0x00000010                // Get CALIB Bit
#define EFC1_FCR_FARG(value) (((value) & 0xFFFF) << 8) // Flash Command Argument
#define EFC1_FCR_FKEY_PASSWD 0x5A000000                // The 0x5A value enables the command defined by the bits of the register. If the field is written with a different value, the write is not performed and no action is started

#define EFC1_FSR_FRDY   0x00000001 // Flash Ready Status
#define EFC1_FSR_FCMDE  0x00000002 // Flash Command Error Status
#define EFC1_FSR_FLOCKE 0x00000004 // Flash Lock Error Status

#define EFC1_FRR_FVALUE(value) (((value) & 0xFFFFFFFF) << 0) // Flash Result Value

#define PIOA_PER    (*(volatile unsigned int *)0x400E0E00)       // [PIO Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1076654)
#define PIOA_PDR    (*(volatile unsigned int *)0x400E0E04)       // [PIO Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1076837)
#define PIOA_PSR    (*(const volatile unsigned int *)0x400E0E08) // [PIO Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077021)
#define PIOA_OER    (*(volatile unsigned int *)0x400E0E10)       // [Output Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077204)
#define PIOA_ODR    (*(volatile unsigned int *)0x400E0E14)       // [Output Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077388)
#define PIOA_OSR    (*(const volatile unsigned int *)0x400E0E18) // [Output Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077571)
#define PIOA_IFER   (*(volatile unsigned int *)0x400E0E20)       // [Glitch Input Filter Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077755)
#define PIOA_IFDR   (*(volatile unsigned int *)0x400E0E24)       // [Glitch Input Filter Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077938)
#define PIOA_IFSR   (*(const volatile unsigned int *)0x400E0E28) // [Glitch Input Filter Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1078122)
#define PIOA_SODR   (*(volatile unsigned int *)0x400E0E30)       // [Set Output Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1078305)
#define PIOA_CODR   (*(volatile unsigned int *)0x400E0E34)       // [Clear Output Data Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1078489)
#define PIOA_ODSR   (*(volatile unsigned int *)0x400E0E38)       // [Output Data Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1078672)
#define PIOA_PDSR   (*(const volatile unsigned int *)0x400E0E3C) // [Pin Data Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1078856)
#define PIOA_IER    (*(volatile unsigned int *)0x400E0E40)       // [Interrupt Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1079039)
#define PIOA_IDR    (*(volatile unsigned int *)0x400E0E44)       // [Interrupt Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1079223)
#define PIOA_IMR    (*(const volatile unsigned int *)0x400E0E48) // [Interrupt Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1079406)
#define PIOA_ISR    (*(const volatile unsigned int *)0x400E0E4C) // [Interrupt Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1079590)
#define PIOA_MDER   (*(volatile unsigned int *)0x400E0E50)       // [Multi-driver Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1079773)
#define PIOA_MDDR   (*(volatile unsigned int *)0x400E0E54)       // [Multi-driver Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1079957)
#define PIOA_MDSR   (*(const volatile unsigned int *)0x400E0E58) // [Multi-driver Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1080140)
#define PIOA_PUDR   (*(volatile unsigned int *)0x400E0E60)       // [Pull-up Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1080324)
#define PIOA_PUER   (*(volatile unsigned int *)0x400E0E64)       // [Pull-up Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1080507)
#define PIOA_PUSR   (*(const volatile unsigned int *)0x400E0E68) // [Pad Pull-up Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1080691)
#define PIOA_ABSR   (*(volatile unsigned int *)0x400E0E70)       // [Peripheral AB Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1145822)
#define PIOA_SCIFSR (*(volatile unsigned int *)0x400E0E80)       // [System Clock Glitch Input Filter Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1081058)
#define PIOA_DIFSR  (*(volatile unsigned int *)0x400E0E84)       // [Debouncing Input Filter Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1081241)
#define PIOA_IFDGSR (*(const volatile unsigned int *)0x400E0E88) // [Glitch or Debouncing Input Filter Clock Selection Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1081425)
#define PIOA_SCDR   (*(volatile unsigned int *)0x400E0E8C)       // [Slow Clock Divider Debouncing Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1081608)
#define PIOA_OWER   (*(volatile unsigned int *)0x400E0EA0)       // [Output Write Enable](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1081791)
#define PIOA_OWDR   (*(volatile unsigned int *)0x400E0EA4)       // [Output Write Disable](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1081974)
#define PIOA_OWSR   (*(const volatile unsigned int *)0x400E0EA8) // [Output Write Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1082158)
#define PIOA_AIMER  (*(volatile unsigned int *)0x400E0EB0)       // [Additional Interrupt Modes Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1082341)
#define PIOA_AIMDR  (*(volatile unsigned int *)0x400E0EB4)       // [Additional Interrupt Modes Disables Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1082525)
#define PIOA_AIMMR  (*(const volatile unsigned int *)0x400E0EB8) // [Additional Interrupt Modes Mask Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1082708)
#define PIOA_ESR    (*(volatile unsigned int *)0x400E0EC0)       // [Edge Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1082892)
#define PIOA_LSR    (*(volatile unsigned int *)0x400E0EC4)       // [Level Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1083075)
#define PIOA_ELSR   (*(const volatile unsigned int *)0x400E0EC8) // [Edge/Level Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1083259)
#define PIOA_FELLSR (*(volatile unsigned int *)0x400E0ED0)       // [Falling Edge/Low Level Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1083442)
#define PIOA_REHLSR (*(volatile unsigned int *)0x400E0ED4)       // [Rising Edge/ High Level Select Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1083626)
#define PIOA_FRLHSR (*(const volatile unsigned int *)0x400E0ED8) // [Fall/Rise - Low/High Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1083809)
#define PIOA_LOCKSR (*(const volatile unsigned int *)0x400E0EE0) // [Lock Status](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1083993)
#define PIOA_WPMR   (*(volatile unsigned int *)0x400E0EE4)       // [Write Protect Mode Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1100105)
#define PIOA_WPSR   (*(const volatile unsigned int *)0x400E0EE8) // [Write Protect Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1100323)

#define PIOA_PER_P0  0x00000001 // PIO Enable
#define PIOA_PER_P1  0x00000002 // PIO Enable
#define PIOA_PER_P2  0x00000004 // PIO Enable
#define PIOA_PER_P3  0x00000008 // PIO Enable
#define PIOA_PER_P4  0x00000010 // PIO Enable
#define PIOA_PER_P5  0x00000020 // PIO Enable
#define PIOA_PER_P6  0x00000040 // PIO Enable
#define PIOA_PER_P7  0x00000080 // PIO Enable
#define PIOA_PER_P8  0x00000100 // PIO Enable
#define PIOA_PER_P9  0x00000200 // PIO Enable
#define PIOA_PER_P10 0x00000400 // PIO Enable
#define PIOA_PER_P11 0x00000800 // PIO Enable
#define PIOA_PER_P12 0x00001000 // PIO Enable
#define PIOA_PER_P13 0x00002000 // PIO Enable
#define PIOA_PER_P14 0x00004000 // PIO Enable
#define PIOA_PER_P15 0x00008000 // PIO Enable
#define PIOA_PER_P16 0x00010000 // PIO Enable
#define PIOA_PER_P17 0x00020000 // PIO Enable
#define PIOA_PER_P18 0x00040000 // PIO Enable
#define PIOA_PER_P19 0x00080000 // PIO Enable
#define PIOA_PER_P20 0x00100000 // PIO Enable
#define PIOA_PER_P21 0x00200000 // PIO Enable
#define PIOA_PER_P22 0x00400000 // PIO Enable
#define PIOA_PER_P23 0x00800000 // PIO Enable
#define PIOA_PER_P24 0x01000000 // PIO Enable
#define PIOA_PER_P25 0x02000000 // PIO Enable
#define PIOA_PER_P26 0x04000000 // PIO Enable
#define PIOA_PER_P27 0x08000000 // PIO Enable
#define PIOA_PER_P28 0x10000000 // PIO Enable
#define PIOA_PER_P29 0x20000000 // PIO Enable
#define PIOA_PER_P30 0x40000000 // PIO Enable
#define PIOA_PER_P31 0x80000000 // PIO Enable

#define PIOA_PDR_P0  0x00000001 // PIO Disable
#define PIOA_PDR_P1  0x00000002 // PIO Disable
#define PIOA_PDR_P2  0x00000004 // PIO Disable
#define PIOA_PDR_P3  0x00000008 // PIO Disable
#define PIOA_PDR_P4  0x00000010 // PIO Disable
#define PIOA_PDR_P5  0x00000020 // PIO Disable
#define PIOA_PDR_P6  0x00000040 // PIO Disable
#define PIOA_PDR_P7  0x00000080 // PIO Disable
#define PIOA_PDR_P8  0x00000100 // PIO Disable
#define PIOA_PDR_P9  0x00000200 // PIO Disable
#define PIOA_PDR_P10 0x00000400 // PIO Disable
#define PIOA_PDR_P11 0x00000800 // PIO Disable
#define PIOA_PDR_P12 0x00001000 // PIO Disable
#define PIOA_PDR_P13 0x00002000 // PIO Disable
#define PIOA_PDR_P14 0x00004000 // PIO Disable
#define PIOA_PDR_P15 0x00008000 // PIO Disable
#define PIOA_PDR_P16 0x00010000 // PIO Disable
#define PIOA_PDR_P17 0x00020000 // PIO Disable
#define PIOA_PDR_P18 0x00040000 // PIO Disable
#define PIOA_PDR_P19 0x00080000 // PIO Disable
#define PIOA_PDR_P20 0x00100000 // PIO Disable
#define PIOA_PDR_P21 0x00200000 // PIO Disable
#define PIOA_PDR_P22 0x00400000 // PIO Disable
#define PIOA_PDR_P23 0x00800000 // PIO Disable
#define PIOA_PDR_P24 0x01000000 // PIO Disable
#define PIOA_PDR_P25 0x02000000 // PIO Disable
#define PIOA_PDR_P26 0x04000000 // PIO Disable
#define PIOA_PDR_P27 0x08000000 // PIO Disable
#define PIOA_PDR_P28 0x10000000 // PIO Disable
#define PIOA_PDR_P29 0x20000000 // PIO Disable
#define PIOA_PDR_P30 0x40000000 // PIO Disable
#define PIOA_PDR_P31 0x80000000 // PIO Disable

#define PIOA_PSR_P0  0x00000001 // PIO Status
#define PIOA_PSR_P1  0x00000002 // PIO Status
#define PIOA_PSR_P2  0x00000004 // PIO Status
#define PIOA_PSR_P3  0x00000008 // PIO Status
#define PIOA_PSR_P4  0x00000010 // PIO Status
#define PIOA_PSR_P5  0x00000020 // PIO Status
#define PIOA_PSR_P6  0x00000040 // PIO Status
#define PIOA_PSR_P7  0x00000080 // PIO Status
#define PIOA_PSR_P8  0x00000100 // PIO Status
#define PIOA_PSR_P9  0x00000200 // PIO Status
#define PIOA_PSR_P10 0x00000400 // PIO Status
#define PIOA_PSR_P11 0x00000800 // PIO Status
#define PIOA_PSR_P12 0x00001000 // PIO Status
#define PIOA_PSR_P13 0x00002000 // PIO Status
#define PIOA_PSR_P14 0x00004000 // PIO Status
#define PIOA_PSR_P15 0x00008000 // PIO Status
#define PIOA_PSR_P16 0x00010000 // PIO Status
#define PIOA_PSR_P17 0x00020000 // PIO Status
#define PIOA_PSR_P18 0x00040000 // PIO Status
#define PIOA_PSR_P19 0x00080000 // PIO Status
#define PIOA_PSR_P20 0x00100000 // PIO Status
#define PIOA_PSR_P21 0x00200000 // PIO Status
#define PIOA_PSR_P22 0x00400000 // PIO Status
#define PIOA_PSR_P23 0x00800000 // PIO Status
#define PIOA_PSR_P24 0x01000000 // PIO Status
#define PIOA_PSR_P25 0x02000000 // PIO Status
#define PIOA_PSR_P26 0x04000000 // PIO Status
#define PIOA_PSR_P27 0x08000000 // PIO Status
#define PIOA_PSR_P28 0x10000000 // PIO Status
#define PIOA_PSR_P29 0x20000000 // PIO Status
#define PIOA_PSR_P30 0x40000000 // PIO Status
#define PIOA_PSR_P31 0x80000000 // PIO Status

#define PIOA_OER_P0  0x00000001 // Output Enable
#define PIOA_OER_P1  0x00000002 // Output Enable
#define PIOA_OER_P2  0x00000004 // Output Enable
#define PIOA_OER_P3  0x00000008 // Output Enable
#define PIOA_OER_P4  0x00000010 // Output Enable
#define PIOA_OER_P5  0x00000020 // Output Enable
#define PIOA_OER_P6  0x00000040 // Output Enable
#define PIOA_OER_P7  0x00000080 // Output Enable
#define PIOA_OER_P8  0x00000100 // Output Enable
#define PIOA_OER_P9  0x00000200 // Output Enable
#define PIOA_OER_P10 0x00000400 // Output Enable
#define PIOA_OER_P11 0x00000800 // Output Enable
#define PIOA_OER_P12 0x00001000 // Output Enable
#define PIOA_OER_P13 0x00002000 // Output Enable
#define PIOA_OER_P14 0x00004000 // Output Enable
#define PIOA_OER_P15 0x00008000 // Output Enable
#define PIOA_OER_P16 0x00010000 // Output Enable
#define PIOA_OER_P17 0x00020000 // Output Enable
#define PIOA_OER_P18 0x00040000 // Output Enable
#define PIOA_OER_P19 0x00080000 // Output Enable
#define PIOA_OER_P20 0x00100000 // Output Enable
#define PIOA_OER_P21 0x00200000 // Output Enable
#define PIOA_OER_P22 0x00400000 // Output Enable
#define PIOA_OER_P23 0x00800000 // Output Enable
#define PIOA_OER_P24 0x01000000 // Output Enable
#define PIOA_OER_P25 0x02000000 // Output Enable
#define PIOA_OER_P26 0x04000000 // Output Enable
#define PIOA_OER_P27 0x08000000 // Output Enable
#define PIOA_OER_P28 0x10000000 // Output Enable
#define PIOA_OER_P29 0x20000000 // Output Enable
#define PIOA_OER_P30 0x40000000 // Output Enable
#define PIOA_OER_P31 0x80000000 // Output Enable

#define PIOA_ODR_P0  0x00000001 // Output Disable
#define PIOA_ODR_P1  0x00000002 // Output Disable
#define PIOA_ODR_P2  0x00000004 // Output Disable
#define PIOA_ODR_P3  0x00000008 // Output Disable
#define PIOA_ODR_P4  0x00000010 // Output Disable
#define PIOA_ODR_P5  0x00000020 // Output Disable
#define PIOA_ODR_P6  0x00000040 // Output Disable
#define PIOA_ODR_P7  0x00000080 // Output Disable
#define PIOA_ODR_P8  0x00000100 // Output Disable
#define PIOA_ODR_P9  0x00000200 // Output Disable
#define PIOA_ODR_P10 0x00000400 // Output Disable
#define PIOA_ODR_P11 0x00000800 // Output Disable
#define PIOA_ODR_P12 0x00001000 // Output Disable
#define PIOA_ODR_P13 0x00002000 // Output Disable
#define PIOA_ODR_P14 0x00004000 // Output Disable
#define PIOA_ODR_P15 0x00008000 // Output Disable
#define PIOA_ODR_P16 0x00010000 // Output Disable
#define PIOA_ODR_P17 0x00020000 // Output Disable
#define PIOA_ODR_P18 0x00040000 // Output Disable
#define PIOA_ODR_P19 0x00080000 // Output Disable
#define PIOA_ODR_P20 0x00100000 // Output Disable
#define PIOA_ODR_P21 0x00200000 // Output Disable
#define PIOA_ODR_P22 0x00400000 // Output Disable
#define PIOA_ODR_P23 0x00800000 // Output Disable
#define PIOA_ODR_P24 0x01000000 // Output Disable
#define PIOA_ODR_P25 0x02000000 // Output Disable
#define PIOA_ODR_P26 0x04000000 // Output Disable
#define PIOA_ODR_P27 0x08000000 // Output Disable
#define PIOA_ODR_P28 0x10000000 // Output Disable
#define PIOA_ODR_P29 0x20000000 // Output Disable
#define PIOA_ODR_P30 0x40000000 // Output Disable
#define PIOA_ODR_P31 0x80000000 // Output Disable

#define PIOA_OSR_P0  0x00000001 // Output Status
#define PIOA_OSR_P1  0x00000002 // Output Status
#define PIOA_OSR_P2  0x00000004 // Output Status
#define PIOA_OSR_P3  0x00000008 // Output Status
#define PIOA_OSR_P4  0x00000010 // Output Status
#define PIOA_OSR_P5  0x00000020 // Output Status
#define PIOA_OSR_P6  0x00000040 // Output Status
#define PIOA_OSR_P7  0x00000080 // Output Status
#define PIOA_OSR_P8  0x00000100 // Output Status
#define PIOA_OSR_P9  0x00000200 // Output Status
#define PIOA_OSR_P10 0x00000400 // Output Status
#define PIOA_OSR_P11 0x00000800 // Output Status
#define PIOA_OSR_P12 0x00001000 // Output Status
#define PIOA_OSR_P13 0x00002000 // Output Status
#define PIOA_OSR_P14 0x00004000 // Output Status
#define PIOA_OSR_P15 0x00008000 // Output Status
#define PIOA_OSR_P16 0x00010000 // Output Status
#define PIOA_OSR_P17 0x00020000 // Output Status
#define PIOA_OSR_P18 0x00040000 // Output Status
#define PIOA_OSR_P19 0x00080000 // Output Status
#define PIOA_OSR_P20 0x00100000 // Output Status
#define PIOA_OSR_P21 0x00200000 // Output Status
#define PIOA_OSR_P22 0x00400000 // Output Status
#define PIOA_OSR_P23 0x00800000 // Output Status
#define PIOA_OSR_P24 0x01000000 // Output Status
#define PIOA_OSR_P25 0x02000000 // Output Status
#define PIOA_OSR_P26 0x04000000 // Output Status
#define PIOA_OSR_P27 0x08000000 // Output Status
#define PIOA_OSR_P28 0x10000000 // Output Status
#define PIOA_OSR_P29 0x20000000 // Output Status
#define PIOA_OSR_P30 0x40000000 // Output Status
#define PIOA_OSR_P31 0x80000000 // Output Status

#define PIOA_IFER_P0  0x00000001 // Input Filter Enable
#define PIOA_IFER_P1  0x00000002 // Input Filter Enable
#define PIOA_IFER_P2  0x00000004 // Input Filter Enable
#define PIOA_IFER_P3  0x00000008 // Input Filter Enable
#define PIOA_IFER_P4  0x00000010 // Input Filter Enable
#define PIOA_IFER_P5  0x00000020 // Input Filter Enable
#define PIOA_IFER_P6  0x00000040 // Input Filter Enable
#define PIOA_IFER_P7  0x00000080 // Input Filter Enable
#define PIOA_IFER_P8  0x00000100 // Input Filter Enable
#define PIOA_IFER_P9  0x00000200 // Input Filter Enable
#define PIOA_IFER_P10 0x00000400 // Input Filter Enable
#define PIOA_IFER_P11 0x00000800 // Input Filter Enable
#define PIOA_IFER_P12 0x00001000 // Input Filter Enable
#define PIOA_IFER_P13 0x00002000 // Input Filter Enable
#define PIOA_IFER_P14 0x00004000 // Input Filter Enable
#define PIOA_IFER_P15 0x00008000 // Input Filter Enable
#define PIOA_IFER_P16 0x00010000 // Input Filter Enable
#define PIOA_IFER_P17 0x00020000 // Input Filter Enable
#define PIOA_IFER_P18 0x00040000 // Input Filter Enable
#define PIOA_IFER_P19 0x00080000 // Input Filter Enable
#define PIOA_IFER_P20 0x00100000 // Input Filter Enable
#define PIOA_IFER_P21 0x00200000 // Input Filter Enable
#define PIOA_IFER_P22 0x00400000 // Input Filter Enable
#define PIOA_IFER_P23 0x00800000 // Input Filter Enable
#define PIOA_IFER_P24 0x01000000 // Input Filter Enable
#define PIOA_IFER_P25 0x02000000 // Input Filter Enable
#define PIOA_IFER_P26 0x04000000 // Input Filter Enable
#define PIOA_IFER_P27 0x08000000 // Input Filter Enable
#define PIOA_IFER_P28 0x10000000 // Input Filter Enable
#define PIOA_IFER_P29 0x20000000 // Input Filter Enable
#define PIOA_IFER_P30 0x40000000 // Input Filter Enable
#define PIOA_IFER_P31 0x80000000 // Input Filter Enable

#define PIOA_IFDR_P0  0x00000001 // Input Filter Disable
#define PIOA_IFDR_P1  0x00000002 // Input Filter Disable
#define PIOA_IFDR_P2  0x00000004 // Input Filter Disable
#define PIOA_IFDR_P3  0x00000008 // Input Filter Disable
#define PIOA_IFDR_P4  0x00000010 // Input Filter Disable
#define PIOA_IFDR_P5  0x00000020 // Input Filter Disable
#define PIOA_IFDR_P6  0x00000040 // Input Filter Disable
#define PIOA_IFDR_P7  0x00000080 // Input Filter Disable
#define PIOA_IFDR_P8  0x00000100 // Input Filter Disable
#define PIOA_IFDR_P9  0x00000200 // Input Filter Disable
#define PIOA_IFDR_P10 0x00000400 // Input Filter Disable
#define PIOA_IFDR_P11 0x00000800 // Input Filter Disable
#define PIOA_IFDR_P12 0x00001000 // Input Filter Disable
#define PIOA_IFDR_P13 0x00002000 // Input Filter Disable
#define PIOA_IFDR_P14 0x00004000 // Input Filter Disable
#define PIOA_IFDR_P15 0x00008000 // Input Filter Disable
#define PIOA_IFDR_P16 0x00010000 // Input Filter Disable
#define PIOA_IFDR_P17 0x00020000 // Input Filter Disable
#define PIOA_IFDR_P18 0x00040000 // Input Filter Disable
#define PIOA_IFDR_P19 0x00080000 // Input Filter Disable
#define PIOA_IFDR_P20 0x00100000 // Input Filter Disable
#define PIOA_IFDR_P21 0x00200000 // Input Filter Disable
#define PIOA_IFDR_P22 0x00400000 // Input Filter Disable
#define PIOA_IFDR_P23 0x00800000 // Input Filter Disable
#define PIOA_IFDR_P24 0x01000000 // Input Filter Disable
#define PIOA_IFDR_P25 0x02000000 // Input Filter Disable
#define PIOA_IFDR_P26 0x04000000 // Input Filter Disable
#define PIOA_IFDR_P27 0x08000000 // Input Filter Disable
#define PIOA_IFDR_P28 0x10000000 // Input Filter Disable
#define PIOA_IFDR_P29 0x20000000 // Input Filter Disable
#define PIOA_IFDR_P30 0x40000000 // Input Filter Disable
#define PIOA_IFDR_P31 0x80000000 // Input Filter Disable

#define PIOA_IFSR_P0  0x00000001 // Input Filer Status
#define PIOA_IFSR_P1  0x00000002 // Input Filer Status
#define PIOA_IFSR_P2  0x00000004 // Input Filer Status
#define PIOA_IFSR_P3  0x00000008 // Input Filer Status
#define PIOA_IFSR_P4  0x00000010 // Input Filer Status
#define PIOA_IFSR_P5  0x00000020 // Input Filer Status
#define PIOA_IFSR_P6  0x00000040 // Input Filer Status
#define PIOA_IFSR_P7  0x00000080 // Input Filer Status
#define PIOA_IFSR_P8  0x00000100 // Input Filer Status
#define PIOA_IFSR_P9  0x00000200 // Input Filer Status
#define PIOA_IFSR_P10 0x00000400 // Input Filer Status
#define PIOA_IFSR_P11 0x00000800 // Input Filer Status
#define PIOA_IFSR_P12 0x00001000 // Input Filer Status
#define PIOA_IFSR_P13 0x00002000 // Input Filer Status
#define PIOA_IFSR_P14 0x00004000 // Input Filer Status
#define PIOA_IFSR_P15 0x00008000 // Input Filer Status
#define PIOA_IFSR_P16 0x00010000 // Input Filer Status
#define PIOA_IFSR_P17 0x00020000 // Input Filer Status
#define PIOA_IFSR_P18 0x00040000 // Input Filer Status
#define PIOA_IFSR_P19 0x00080000 // Input Filer Status
#define PIOA_IFSR_P20 0x00100000 // Input Filer Status
#define PIOA_IFSR_P21 0x00200000 // Input Filer Status
#define PIOA_IFSR_P22 0x00400000 // Input Filer Status
#define PIOA_IFSR_P23 0x00800000 // Input Filer Status
#define PIOA_IFSR_P24 0x01000000 // Input Filer Status
#define PIOA_IFSR_P25 0x02000000 // Input Filer Status
#define PIOA_IFSR_P26 0x04000000 // Input Filer Status
#define PIOA_IFSR_P27 0x08000000 // Input Filer Status
#define PIOA_IFSR_P28 0x10000000 // Input Filer Status
#define PIOA_IFSR_P29 0x20000000 // Input Filer Status
#define PIOA_IFSR_P30 0x40000000 // Input Filer Status
#define PIOA_IFSR_P31 0x80000000 // Input Filer Status

#define PIOA_SODR_P0  0x00000001 // Set Output Data
#define PIOA_SODR_P1  0x00000002 // Set Output Data
#define PIOA_SODR_P2  0x00000004 // Set Output Data
#define PIOA_SODR_P3  0x00000008 // Set Output Data
#define PIOA_SODR_P4  0x00000010 // Set Output Data
#define PIOA_SODR_P5  0x00000020 // Set Output Data
#define PIOA_SODR_P6  0x00000040 // Set Output Data
#define PIOA_SODR_P7  0x00000080 // Set Output Data
#define PIOA_SODR_P8  0x00000100 // Set Output Data
#define PIOA_SODR_P9  0x00000200 // Set Output Data
#define PIOA_SODR_P10 0x00000400 // Set Output Data
#define PIOA_SODR_P11 0x00000800 // Set Output Data
#define PIOA_SODR_P12 0x00001000 // Set Output Data
#define PIOA_SODR_P13 0x00002000 // Set Output Data
#define PIOA_SODR_P14 0x00004000 // Set Output Data
#define PIOA_SODR_P15 0x00008000 // Set Output Data
#define PIOA_SODR_P16 0x00010000 // Set Output Data
#define PIOA_SODR_P17 0x00020000 // Set Output Data
#define PIOA_SODR_P18 0x00040000 // Set Output Data
#define PIOA_SODR_P19 0x00080000 // Set Output Data
#define PIOA_SODR_P20 0x00100000 // Set Output Data
#define PIOA_SODR_P21 0x00200000 // Set Output Data
#define PIOA_SODR_P22 0x00400000 // Set Output Data
#define PIOA_SODR_P23 0x00800000 // Set Output Data
#define PIOA_SODR_P24 0x01000000 // Set Output Data
#define PIOA_SODR_P25 0x02000000 // Set Output Data
#define PIOA_SODR_P26 0x04000000 // Set Output Data
#define PIOA_SODR_P27 0x08000000 // Set Output Data
#define PIOA_SODR_P28 0x10000000 // Set Output Data
#define PIOA_SODR_P29 0x20000000 // Set Output Data
#define PIOA_SODR_P30 0x40000000 // Set Output Data
#define PIOA_SODR_P31 0x80000000 // Set Output Data

#define PIOA_CODR_P0  0x00000001 // Clear Output Data
#define PIOA_CODR_P1  0x00000002 // Clear Output Data
#define PIOA_CODR_P2  0x00000004 // Clear Output Data
#define PIOA_CODR_P3  0x00000008 // Clear Output Data
#define PIOA_CODR_P4  0x00000010 // Clear Output Data
#define PIOA_CODR_P5  0x00000020 // Clear Output Data
#define PIOA_CODR_P6  0x00000040 // Clear Output Data
#define PIOA_CODR_P7  0x00000080 // Clear Output Data
#define PIOA_CODR_P8  0x00000100 // Clear Output Data
#define PIOA_CODR_P9  0x00000200 // Clear Output Data
#define PIOA_CODR_P10 0x00000400 // Clear Output Data
#define PIOA_CODR_P11 0x00000800 // Clear Output Data
#define PIOA_CODR_P12 0x00001000 // Clear Output Data
#define PIOA_CODR_P13 0x00002000 // Clear Output Data
#define PIOA_CODR_P14 0x00004000 // Clear Output Data
#define PIOA_CODR_P15 0x00008000 // Clear Output Data
#define PIOA_CODR_P16 0x00010000 // Clear Output Data
#define PIOA_CODR_P17 0x00020000 // Clear Output Data
#define PIOA_CODR_P18 0x00040000 // Clear Output Data
#define PIOA_CODR_P19 0x00080000 // Clear Output Data
#define PIOA_CODR_P20 0x00100000 // Clear Output Data
#define PIOA_CODR_P21 0x00200000 // Clear Output Data
#define PIOA_CODR_P22 0x00400000 // Clear Output Data
#define PIOA_CODR_P23 0x00800000 // Clear Output Data
#define PIOA_CODR_P24 0x01000000 // Clear Output Data
#define PIOA_CODR_P25 0x02000000 // Clear Output Data
#define PIOA_CODR_P26 0x04000000 // Clear Output Data
#define PIOA_CODR_P27 0x08000000 // Clear Output Data
#define PIOA_CODR_P28 0x10000000 // Clear Output Data
#define PIOA_CODR_P29 0x20000000 // Clear Output Data
#define PIOA_CODR_P30 0x40000000 // Clear Output Data
#define PIOA_CODR_P31 0x80000000 // Clear Output Data

#define PIOA_ODSR_P0  0x00000001 // Output Data Status
#define PIOA_ODSR_P1  0x00000002 // Output Data Status
#define PIOA_ODSR_P2  0x00000004 // Output Data Status
#define PIOA_ODSR_P3  0x00000008 // Output Data Status
#define PIOA_ODSR_P4  0x00000010 // Output Data Status
#define PIOA_ODSR_P5  0x00000020 // Output Data Status
#define PIOA_ODSR_P6  0x00000040 // Output Data Status
#define PIOA_ODSR_P7  0x00000080 // Output Data Status
#define PIOA_ODSR_P8  0x00000100 // Output Data Status
#define PIOA_ODSR_P9  0x00000200 // Output Data Status
#define PIOA_ODSR_P10 0x00000400 // Output Data Status
#define PIOA_ODSR_P11 0x00000800 // Output Data Status
#define PIOA_ODSR_P12 0x00001000 // Output Data Status
#define PIOA_ODSR_P13 0x00002000 // Output Data Status
#define PIOA_ODSR_P14 0x00004000 // Output Data Status
#define PIOA_ODSR_P15 0x00008000 // Output Data Status
#define PIOA_ODSR_P16 0x00010000 // Output Data Status
#define PIOA_ODSR_P17 0x00020000 // Output Data Status
#define PIOA_ODSR_P18 0x00040000 // Output Data Status
#define PIOA_ODSR_P19 0x00080000 // Output Data Status
#define PIOA_ODSR_P20 0x00100000 // Output Data Status
#define PIOA_ODSR_P21 0x00200000 // Output Data Status
#define PIOA_ODSR_P22 0x00400000 // Output Data Status
#define PIOA_ODSR_P23 0x00800000 // Output Data Status
#define PIOA_ODSR_P24 0x01000000 // Output Data Status
#define PIOA_ODSR_P25 0x02000000 // Output Data Status
#define PIOA_ODSR_P26 0x04000000 // Output Data Status
#define PIOA_ODSR_P27 0x08000000 // Output Data Status
#define PIOA_ODSR_P28 0x10000000 // Output Data Status
#define PIOA_ODSR_P29 0x20000000 // Output Data Status
#define PIOA_ODSR_P30 0x40000000 // Output Data Status
#define PIOA_ODSR_P31 0x80000000 // Output Data Status

#define PIOA_PDSR_P0  0x00000001 // Output Data Status
#define PIOA_PDSR_P1  0x00000002 // Output Data Status
#define PIOA_PDSR_P2  0x00000004 // Output Data Status
#define PIOA_PDSR_P3  0x00000008 // Output Data Status
#define PIOA_PDSR_P4  0x00000010 // Output Data Status
#define PIOA_PDSR_P5  0x00000020 // Output Data Status
#define PIOA_PDSR_P6  0x00000040 // Output Data Status
#define PIOA_PDSR_P7  0x00000080 // Output Data Status
#define PIOA_PDSR_P8  0x00000100 // Output Data Status
#define PIOA_PDSR_P9  0x00000200 // Output Data Status
#define PIOA_PDSR_P10 0x00000400 // Output Data Status
#define PIOA_PDSR_P11 0x00000800 // Output Data Status
#define PIOA_PDSR_P12 0x00001000 // Output Data Status
#define PIOA_PDSR_P13 0x00002000 // Output Data Status
#define PIOA_PDSR_P14 0x00004000 // Output Data Status
#define PIOA_PDSR_P15 0x00008000 // Output Data Status
#define PIOA_PDSR_P16 0x00010000 // Output Data Status
#define PIOA_PDSR_P17 0x00020000 // Output Data Status
#define PIOA_PDSR_P18 0x00040000 // Output Data Status
#define PIOA_PDSR_P19 0x00080000 // Output Data Status
#define PIOA_PDSR_P20 0x00100000 // Output Data Status
#define PIOA_PDSR_P21 0x00200000 // Output Data Status
#define PIOA_PDSR_P22 0x00400000 // Output Data Status
#define PIOA_PDSR_P23 0x00800000 // Output Data Status
#define PIOA_PDSR_P24 0x01000000 // Output Data Status
#define PIOA_PDSR_P25 0x02000000 // Output Data Status
#define PIOA_PDSR_P26 0x04000000 // Output Data Status
#define PIOA_PDSR_P27 0x08000000 // Output Data Status
#define PIOA_PDSR_P28 0x10000000 // Output Data Status
#define PIOA_PDSR_P29 0x20000000 // Output Data Status
#define PIOA_PDSR_P30 0x40000000 // Output Data Status
#define PIOA_PDSR_P31 0x80000000 // Output Data Status

#define PIOA_IER_P0  0x00000001 // Input Change Interrupt Enable
#define PIOA_IER_P1  0x00000002 // Input Change Interrupt Enable
#define PIOA_IER_P2  0x00000004 // Input Change Interrupt Enable
#define PIOA_IER_P3  0x00000008 // Input Change Interrupt Enable
#define PIOA_IER_P4  0x00000010 // Input Change Interrupt Enable
#define PIOA_IER_P5  0x00000020 // Input Change Interrupt Enable
#define PIOA_IER_P6  0x00000040 // Input Change Interrupt Enable
#define PIOA_IER_P7  0x00000080 // Input Change Interrupt Enable
#define PIOA_IER_P8  0x00000100 // Input Change Interrupt Enable
#define PIOA_IER_P9  0x00000200 // Input Change Interrupt Enable
#define PIOA_IER_P10 0x00000400 // Input Change Interrupt Enable
#define PIOA_IER_P11 0x00000800 // Input Change Interrupt Enable
#define PIOA_IER_P12 0x00001000 // Input Change Interrupt Enable
#define PIOA_IER_P13 0x00002000 // Input Change Interrupt Enable
#define PIOA_IER_P14 0x00004000 // Input Change Interrupt Enable
#define PIOA_IER_P15 0x00008000 // Input Change Interrupt Enable
#define PIOA_IER_P16 0x00010000 // Input Change Interrupt Enable
#define PIOA_IER_P17 0x00020000 // Input Change Interrupt Enable
#define PIOA_IER_P18 0x00040000 // Input Change Interrupt Enable
#define PIOA_IER_P19 0x00080000 // Input Change Interrupt Enable
#define PIOA_IER_P20 0x00100000 // Input Change Interrupt Enable
#define PIOA_IER_P21 0x00200000 // Input Change Interrupt Enable
#define PIOA_IER_P22 0x00400000 // Input Change Interrupt Enable
#define PIOA_IER_P23 0x00800000 // Input Change Interrupt Enable
#define PIOA_IER_P24 0x01000000 // Input Change Interrupt Enable
#define PIOA_IER_P25 0x02000000 // Input Change Interrupt Enable
#define PIOA_IER_P26 0x04000000 // Input Change Interrupt Enable
#define PIOA_IER_P27 0x08000000 // Input Change Interrupt Enable
#define PIOA_IER_P28 0x10000000 // Input Change Interrupt Enable
#define PIOA_IER_P29 0x20000000 // Input Change Interrupt Enable
#define PIOA_IER_P30 0x40000000 // Input Change Interrupt Enable
#define PIOA_IER_P31 0x80000000 // Input Change Interrupt Enable

#define PIOA_IDR_P0  0x00000001 // Input Change Interrupt Disable
#define PIOA_IDR_P1  0x00000002 // Input Change Interrupt Disable
#define PIOA_IDR_P2  0x00000004 // Input Change Interrupt Disable
#define PIOA_IDR_P3  0x00000008 // Input Change Interrupt Disable
#define PIOA_IDR_P4  0x00000010 // Input Change Interrupt Disable
#define PIOA_IDR_P5  0x00000020 // Input Change Interrupt Disable
#define PIOA_IDR_P6  0x00000040 // Input Change Interrupt Disable
#define PIOA_IDR_P7  0x00000080 // Input Change Interrupt Disable
#define PIOA_IDR_P8  0x00000100 // Input Change Interrupt Disable
#define PIOA_IDR_P9  0x00000200 // Input Change Interrupt Disable
#define PIOA_IDR_P10 0x00000400 // Input Change Interrupt Disable
#define PIOA_IDR_P11 0x00000800 // Input Change Interrupt Disable
#define PIOA_IDR_P12 0x00001000 // Input Change Interrupt Disable
#define PIOA_IDR_P13 0x00002000 // Input Change Interrupt Disable
#define PIOA_IDR_P14 0x00004000 // Input Change Interrupt Disable
#define PIOA_IDR_P15 0x00008000 // Input Change Interrupt Disable
#define PIOA_IDR_P16 0x00010000 // Input Change Interrupt Disable
#define PIOA_IDR_P17 0x00020000 // Input Change Interrupt Disable
#define PIOA_IDR_P18 0x00040000 // Input Change Interrupt Disable
#define PIOA_IDR_P19 0x00080000 // Input Change Interrupt Disable
#define PIOA_IDR_P20 0x00100000 // Input Change Interrupt Disable
#define PIOA_IDR_P21 0x00200000 // Input Change Interrupt Disable
#define PIOA_IDR_P22 0x00400000 // Input Change Interrupt Disable
#define PIOA_IDR_P23 0x00800000 // Input Change Interrupt Disable
#define PIOA_IDR_P24 0x01000000 // Input Change Interrupt Disable
#define PIOA_IDR_P25 0x02000000 // Input Change Interrupt Disable
#define PIOA_IDR_P26 0x04000000 // Input Change Interrupt Disable
#define PIOA_IDR_P27 0x08000000 // Input Change Interrupt Disable
#define PIOA_IDR_P28 0x10000000 // Input Change Interrupt Disable
#define PIOA_IDR_P29 0x20000000 // Input Change Interrupt Disable
#define PIOA_IDR_P30 0x40000000 // Input Change Interrupt Disable
#define PIOA_IDR_P31 0x80000000 // Input Change Interrupt Disable

#define PIOA_IMR_P0  0x00000001 // Input Change Interrupt Mask
#define PIOA_IMR_P1  0x00000002 // Input Change Interrupt Mask
#define PIOA_IMR_P2  0x00000004 // Input Change Interrupt Mask
#define PIOA_IMR_P3  0x00000008 // Input Change Interrupt Mask
#define PIOA_IMR_P4  0x00000010 // Input Change Interrupt Mask
#define PIOA_IMR_P5  0x00000020 // Input Change Interrupt Mask
#define PIOA_IMR_P6  0x00000040 // Input Change Interrupt Mask
#define PIOA_IMR_P7  0x00000080 // Input Change Interrupt Mask
#define PIOA_IMR_P8  0x00000100 // Input Change Interrupt Mask
#define PIOA_IMR_P9  0x00000200 // Input Change Interrupt Mask
#define PIOA_IMR_P10 0x00000400 // Input Change Interrupt Mask
#define PIOA_IMR_P11 0x00000800 // Input Change Interrupt Mask
#define PIOA_IMR_P12 0x00001000 // Input Change Interrupt Mask
#define PIOA_IMR_P13 0x00002000 // Input Change Interrupt Mask
#define PIOA_IMR_P14 0x00004000 // Input Change Interrupt Mask
#define PIOA_IMR_P15 0x00008000 // Input Change Interrupt Mask
#define PIOA_IMR_P16 0x00010000 // Input Change Interrupt Mask
#define PIOA_IMR_P17 0x00020000 // Input Change Interrupt Mask
#define PIOA_IMR_P18 0x00040000 // Input Change Interrupt Mask
#define PIOA_IMR_P19 0x00080000 // Input Change Interrupt Mask
#define PIOA_IMR_P20 0x00100000 // Input Change Interrupt Mask
#define PIOA_IMR_P21 0x00200000 // Input Change Interrupt Mask
#define PIOA_IMR_P22 0x00400000 // Input Change Interrupt Mask
#define PIOA_IMR_P23 0x00800000 // Input Change Interrupt Mask
#define PIOA_IMR_P24 0x01000000 // Input Change Interrupt Mask
#define PIOA_IMR_P25 0x02000000 // Input Change Interrupt Mask
#define PIOA_IMR_P26 0x04000000 // Input Change Interrupt Mask
#define PIOA_IMR_P27 0x08000000 // Input Change Interrupt Mask
#define PIOA_IMR_P28 0x10000000 // Input Change Interrupt Mask
#define PIOA_IMR_P29 0x20000000 // Input Change Interrupt Mask
#define PIOA_IMR_P30 0x40000000 // Input Change Interrupt Mask
#define PIOA_IMR_P31 0x80000000 // Input Change Interrupt Mask

#define PIOA_ISR_P0  0x00000001 // Input Change Interrupt Status
#define PIOA_ISR_P1  0x00000002 // Input Change Interrupt Status
#define PIOA_ISR_P2  0x00000004 // Input Change Interrupt Status
#define PIOA_ISR_P3  0x00000008 // Input Change Interrupt Status
#define PIOA_ISR_P4  0x00000010 // Input Change Interrupt Status
#define PIOA_ISR_P5  0x00000020 // Input Change Interrupt Status
#define PIOA_ISR_P6  0x00000040 // Input Change Interrupt Status
#define PIOA_ISR_P7  0x00000080 // Input Change Interrupt Status
#define PIOA_ISR_P8  0x00000100 // Input Change Interrupt Status
#define PIOA_ISR_P9  0x00000200 // Input Change Interrupt Status
#define PIOA_ISR_P10 0x00000400 // Input Change Interrupt Status
#define PIOA_ISR_P11 0x00000800 // Input Change Interrupt Status
#define PIOA_ISR_P12 0x00001000 // Input Change Interrupt Status
#define PIOA_ISR_P13 0x00002000 // Input Change Interrupt Status
#define PIOA_ISR_P14 0x00004000 // Input Change Interrupt Status
#define PIOA_ISR_P15 0x00008000 // Input Change Interrupt Status
#define PIOA_ISR_P16 0x00010000 // Input Change Interrupt Status
#define PIOA_ISR_P17 0x00020000 // Input Change Interrupt Status
#define PIOA_ISR_P18 0x00040000 // Input Change Interrupt Status
#define PIOA_ISR_P19 0x00080000 // Input Change Interrupt Status
#define PIOA_ISR_P20 0x00100000 // Input Change Interrupt Status
#define PIOA_ISR_P21 0x00200000 // Input Change Interrupt Status
#define PIOA_ISR_P22 0x00400000 // Input Change Interrupt Status
#define PIOA_ISR_P23 0x00800000 // Input Change Interrupt Status
#define PIOA_ISR_P24 0x01000000 // Input Change Interrupt Status
#define PIOA_ISR_P25 0x02000000 // Input Change Interrupt Status
#define PIOA_ISR_P26 0x04000000 // Input Change Interrupt Status
#define PIOA_ISR_P27 0x08000000 // Input Change Interrupt Status
#define PIOA_ISR_P28 0x10000000 // Input Change Interrupt Status
#define PIOA_ISR_P29 0x20000000 // Input Change Interrupt Status
#define PIOA_ISR_P30 0x40000000 // Input Change Interrupt Status
#define PIOA_ISR_P31 0x80000000 // Input Change Interrupt Status

#define PIOA_MDER_P0  0x00000001 // Multi Drive Enable
#define PIOA_MDER_P1  0x00000002 // Multi Drive Enable
#define PIOA_MDER_P2  0x00000004 // Multi Drive Enable
#define PIOA_MDER_P3  0x00000008 // Multi Drive Enable
#define PIOA_MDER_P4  0x00000010 // Multi Drive Enable
#define PIOA_MDER_P5  0x00000020 // Multi Drive Enable
#define PIOA_MDER_P6  0x00000040 // Multi Drive Enable
#define PIOA_MDER_P7  0x00000080 // Multi Drive Enable
#define PIOA_MDER_P8  0x00000100 // Multi Drive Enable
#define PIOA_MDER_P9  0x00000200 // Multi Drive Enable
#define PIOA_MDER_P10 0x00000400 // Multi Drive Enable
#define PIOA_MDER_P11 0x00000800 // Multi Drive Enable
#define PIOA_MDER_P12 0x00001000 // Multi Drive Enable
#define PIOA_MDER_P13 0x00002000 // Multi Drive Enable
#define PIOA_MDER_P14 0x00004000 // Multi Drive Enable
#define PIOA_MDER_P15 0x00008000 // Multi Drive Enable
#define PIOA_MDER_P16 0x00010000 // Multi Drive Enable
#define PIOA_MDER_P17 0x00020000 // Multi Drive Enable
#define PIOA_MDER_P18 0x00040000 // Multi Drive Enable
#define PIOA_MDER_P19 0x00080000 // Multi Drive Enable
#define PIOA_MDER_P20 0x00100000 // Multi Drive Enable
#define PIOA_MDER_P21 0x00200000 // Multi Drive Enable
#define PIOA_MDER_P22 0x00400000 // Multi Drive Enable
#define PIOA_MDER_P23 0x00800000 // Multi Drive Enable
#define PIOA_MDER_P24 0x01000000 // Multi Drive Enable
#define PIOA_MDER_P25 0x02000000 // Multi Drive Enable
#define PIOA_MDER_P26 0x04000000 // Multi Drive Enable
#define PIOA_MDER_P27 0x08000000 // Multi Drive Enable
#define PIOA_MDER_P28 0x10000000 // Multi Drive Enable
#define PIOA_MDER_P29 0x20000000 // Multi Drive Enable
#define PIOA_MDER_P30 0x40000000 // Multi Drive Enable
#define PIOA_MDER_P31 0x80000000 // Multi Drive Enable

#define PIOA_MDDR_P0  0x00000001 // Multi Drive Disable
#define PIOA_MDDR_P1  0x00000002 // Multi Drive Disable
#define PIOA_MDDR_P2  0x00000004 // Multi Drive Disable
#define PIOA_MDDR_P3  0x00000008 // Multi Drive Disable
#define PIOA_MDDR_P4  0x00000010 // Multi Drive Disable
#define PIOA_MDDR_P5  0x00000020 // Multi Drive Disable
#define PIOA_MDDR_P6  0x00000040 // Multi Drive Disable
#define PIOA_MDDR_P7  0x00000080 // Multi Drive Disable
#define PIOA_MDDR_P8  0x00000100 // Multi Drive Disable
#define PIOA_MDDR_P9  0x00000200 // Multi Drive Disable
#define PIOA_MDDR_P10 0x00000400 // Multi Drive Disable
#define PIOA_MDDR_P11 0x00000800 // Multi Drive Disable
#define PIOA_MDDR_P12 0x00001000 // Multi Drive Disable
#define PIOA_MDDR_P13 0x00002000 // Multi Drive Disable
#define PIOA_MDDR_P14 0x00004000 // Multi Drive Disable
#define PIOA_MDDR_P15 0x00008000 // Multi Drive Disable
#define PIOA_MDDR_P16 0x00010000 // Multi Drive Disable
#define PIOA_MDDR_P17 0x00020000 // Multi Drive Disable
#define PIOA_MDDR_P18 0x00040000 // Multi Drive Disable
#define PIOA_MDDR_P19 0x00080000 // Multi Drive Disable
#define PIOA_MDDR_P20 0x00100000 // Multi Drive Disable
#define PIOA_MDDR_P21 0x00200000 // Multi Drive Disable
#define PIOA_MDDR_P22 0x00400000 // Multi Drive Disable
#define PIOA_MDDR_P23 0x00800000 // Multi Drive Disable
#define PIOA_MDDR_P24 0x01000000 // Multi Drive Disable
#define PIOA_MDDR_P25 0x02000000 // Multi Drive Disable
#define PIOA_MDDR_P26 0x04000000 // Multi Drive Disable
#define PIOA_MDDR_P27 0x08000000 // Multi Drive Disable
#define PIOA_MDDR_P28 0x10000000 // Multi Drive Disable
#define PIOA_MDDR_P29 0x20000000 // Multi Drive Disable
#define PIOA_MDDR_P30 0x40000000 // Multi Drive Disable
#define PIOA_MDDR_P31 0x80000000 // Multi Drive Disable

#define PIOA_MDSR_P0  0x00000001 // Multi Drive Status
#define PIOA_MDSR_P1  0x00000002 // Multi Drive Status
#define PIOA_MDSR_P2  0x00000004 // Multi Drive Status
#define PIOA_MDSR_P3  0x00000008 // Multi Drive Status
#define PIOA_MDSR_P4  0x00000010 // Multi Drive Status
#define PIOA_MDSR_P5  0x00000020 // Multi Drive Status
#define PIOA_MDSR_P6  0x00000040 // Multi Drive Status
#define PIOA_MDSR_P7  0x00000080 // Multi Drive Status
#define PIOA_MDSR_P8  0x00000100 // Multi Drive Status
#define PIOA_MDSR_P9  0x00000200 // Multi Drive Status
#define PIOA_MDSR_P10 0x00000400 // Multi Drive Status
#define PIOA_MDSR_P11 0x00000800 // Multi Drive Status
#define PIOA_MDSR_P12 0x00001000 // Multi Drive Status
#define PIOA_MDSR_P13 0x00002000 // Multi Drive Status
#define PIOA_MDSR_P14 0x00004000 // Multi Drive Status
#define PIOA_MDSR_P15 0x00008000 // Multi Drive Status
#define PIOA_MDSR_P16 0x00010000 // Multi Drive Status
#define PIOA_MDSR_P17 0x00020000 // Multi Drive Status
#define PIOA_MDSR_P18 0x00040000 // Multi Drive Status
#define PIOA_MDSR_P19 0x00080000 // Multi Drive Status
#define PIOA_MDSR_P20 0x00100000 // Multi Drive Status
#define PIOA_MDSR_P21 0x00200000 // Multi Drive Status
#define PIOA_MDSR_P22 0x00400000 // Multi Drive Status
#define PIOA_MDSR_P23 0x00800000 // Multi Drive Status
#define PIOA_MDSR_P24 0x01000000 // Multi Drive Status
#define PIOA_MDSR_P25 0x02000000 // Multi Drive Status
#define PIOA_MDSR_P26 0x04000000 // Multi Drive Status
#define PIOA_MDSR_P27 0x08000000 // Multi Drive Status
#define PIOA_MDSR_P28 0x10000000 // Multi Drive Status
#define PIOA_MDSR_P29 0x20000000 // Multi Drive Status
#define PIOA_MDSR_P30 0x40000000 // Multi Drive Status
#define PIOA_MDSR_P31 0x80000000 // Multi Drive Status

#define PIOA_PUDR_P0  0x00000001 // Pull Up Disable
#define PIOA_PUDR_P1  0x00000002 // Pull Up Disable
#define PIOA_PUDR_P2  0x00000004 // Pull Up Disable
#define PIOA_PUDR_P3  0x00000008 // Pull Up Disable
#define PIOA_PUDR_P4  0x00000010 // Pull Up Disable
#define PIOA_PUDR_P5  0x00000020 // Pull Up Disable
#define PIOA_PUDR_P6  0x00000040 // Pull Up Disable
#define PIOA_PUDR_P7  0x00000080 // Pull Up Disable
#define PIOA_PUDR_P8  0x00000100 // Pull Up Disable
#define PIOA_PUDR_P9  0x00000200 // Pull Up Disable
#define PIOA_PUDR_P10 0x00000400 // Pull Up Disable
#define PIOA_PUDR_P11 0x00000800 // Pull Up Disable
#define PIOA_PUDR_P12 0x00001000 // Pull Up Disable
#define PIOA_PUDR_P13 0x00002000 // Pull Up Disable
#define PIOA_PUDR_P14 0x00004000 // Pull Up Disable
#define PIOA_PUDR_P15 0x00008000 // Pull Up Disable
#define PIOA_PUDR_P16 0x00010000 // Pull Up Disable
#define PIOA_PUDR_P17 0x00020000 // Pull Up Disable
#define PIOA_PUDR_P18 0x00040000 // Pull Up Disable
#define PIOA_PUDR_P19 0x00080000 // Pull Up Disable
#define PIOA_PUDR_P20 0x00100000 // Pull Up Disable
#define PIOA_PUDR_P21 0x00200000 // Pull Up Disable
#define PIOA_PUDR_P22 0x00400000 // Pull Up Disable
#define PIOA_PUDR_P23 0x00800000 // Pull Up Disable
#define PIOA_PUDR_P24 0x01000000 // Pull Up Disable
#define PIOA_PUDR_P25 0x02000000 // Pull Up Disable
#define PIOA_PUDR_P26 0x04000000 // Pull Up Disable
#define PIOA_PUDR_P27 0x08000000 // Pull Up Disable
#define PIOA_PUDR_P28 0x10000000 // Pull Up Disable
#define PIOA_PUDR_P29 0x20000000 // Pull Up Disable
#define PIOA_PUDR_P30 0x40000000 // Pull Up Disable
#define PIOA_PUDR_P31 0x80000000 // Pull Up Disable

#define PIOA_PUER_P0  0x00000001 // Pull Up Enable
#define PIOA_PUER_P1  0x00000002 // Pull Up Enable
#define PIOA_PUER_P2  0x00000004 // Pull Up Enable
#define PIOA_PUER_P3  0x00000008 // Pull Up Enable
#define PIOA_PUER_P4  0x00000010 // Pull Up Enable
#define PIOA_PUER_P5  0x00000020 // Pull Up Enable
#define PIOA_PUER_P6  0x00000040 // Pull Up Enable
#define PIOA_PUER_P7  0x00000080 // Pull Up Enable
#define PIOA_PUER_P8  0x00000100 // Pull Up Enable
#define PIOA_PUER_P9  0x00000200 // Pull Up Enable
#define PIOA_PUER_P10 0x00000400 // Pull Up Enable
#define PIOA_PUER_P11 0x00000800 // Pull Up Enable
#define PIOA_PUER_P12 0x00001000 // Pull Up Enable
#define PIOA_PUER_P13 0x00002000 // Pull Up Enable
#define PIOA_PUER_P14 0x00004000 // Pull Up Enable
#define PIOA_PUER_P15 0x00008000 // Pull Up Enable
#define PIOA_PUER_P16 0x00010000 // Pull Up Enable
#define PIOA_PUER_P17 0x00020000 // Pull Up Enable
#define PIOA_PUER_P18 0x00040000 // Pull Up Enable
#define PIOA_PUER_P19 0x00080000 // Pull Up Enable
#define PIOA_PUER_P20 0x00100000 // Pull Up Enable
#define PIOA_PUER_P21 0x00200000 // Pull Up Enable
#define PIOA_PUER_P22 0x00400000 // Pull Up Enable
#define PIOA_PUER_P23 0x00800000 // Pull Up Enable
#define PIOA_PUER_P24 0x01000000 // Pull Up Enable
#define PIOA_PUER_P25 0x02000000 // Pull Up Enable
#define PIOA_PUER_P26 0x04000000 // Pull Up Enable
#define PIOA_PUER_P27 0x08000000 // Pull Up Enable
#define PIOA_PUER_P28 0x10000000 // Pull Up Enable
#define PIOA_PUER_P29 0x20000000 // Pull Up Enable
#define PIOA_PUER_P30 0x40000000 // Pull Up Enable
#define PIOA_PUER_P31 0x80000000 // Pull Up Enable

#define PIOA_PUSR_P0  0x00000001 // Pull Up Status
#define PIOA_PUSR_P1  0x00000002 // Pull Up Status
#define PIOA_PUSR_P2  0x00000004 // Pull Up Status
#define PIOA_PUSR_P3  0x00000008 // Pull Up Status
#define PIOA_PUSR_P4  0x00000010 // Pull Up Status
#define PIOA_PUSR_P5  0x00000020 // Pull Up Status
#define PIOA_PUSR_P6  0x00000040 // Pull Up Status
#define PIOA_PUSR_P7  0x00000080 // Pull Up Status
#define PIOA_PUSR_P8  0x00000100 // Pull Up Status
#define PIOA_PUSR_P9  0x00000200 // Pull Up Status
#define PIOA_PUSR_P10 0x00000400 // Pull Up Status
#define PIOA_PUSR_P11 0x00000800 // Pull Up Status
#define PIOA_PUSR_P12 0x00001000 // Pull Up Status
#define PIOA_PUSR_P13 0x00002000 // Pull Up Status
#define PIOA_PUSR_P14 0x00004000 // Pull Up Status
#define PIOA_PUSR_P15 0x00008000 // Pull Up Status
#define PIOA_PUSR_P16 0x00010000 // Pull Up Status
#define PIOA_PUSR_P17 0x00020000 // Pull Up Status
#define PIOA_PUSR_P18 0x00040000 // Pull Up Status
#define PIOA_PUSR_P19 0x00080000 // Pull Up Status
#define PIOA_PUSR_P20 0x00100000 // Pull Up Status
#define PIOA_PUSR_P21 0x00200000 // Pull Up Status
#define PIOA_PUSR_P22 0x00400000 // Pull Up Status
#define PIOA_PUSR_P23 0x00800000 // Pull Up Status
#define PIOA_PUSR_P24 0x01000000 // Pull Up Status
#define PIOA_PUSR_P25 0x02000000 // Pull Up Status
#define PIOA_PUSR_P26 0x04000000 // Pull Up Status
#define PIOA_PUSR_P27 0x08000000 // Pull Up Status
#define PIOA_PUSR_P28 0x10000000 // Pull Up Status
#define PIOA_PUSR_P29 0x20000000 // Pull Up Status
#define PIOA_PUSR_P30 0x40000000 // Pull Up Status
#define PIOA_PUSR_P31 0x80000000 // Pull Up Status

#define PIOA_ABSR_P0  0x00000001 // Peripheral A Select
#define PIOA_ABSR_P1  0x00000002 // Peripheral A Select
#define PIOA_ABSR_P2  0x00000004 // Peripheral A Select
#define PIOA_ABSR_P3  0x00000008 // Peripheral A Select
#define PIOA_ABSR_P4  0x00000010 // Peripheral A Select
#define PIOA_ABSR_P5  0x00000020 // Peripheral A Select
#define PIOA_ABSR_P6  0x00000040 // Peripheral A Select
#define PIOA_ABSR_P7  0x00000080 // Peripheral A Select
#define PIOA_ABSR_P8  0x00000100 // Peripheral A Select
#define PIOA_ABSR_P9  0x00000200 // Peripheral A Select
#define PIOA_ABSR_P10 0x00000400 // Peripheral A Select
#define PIOA_ABSR_P11 0x00000800 // Peripheral A Select
#define PIOA_ABSR_P12 0x00001000 // Peripheral A Select
#define PIOA_ABSR_P13 0x00002000 // Peripheral A Select
#define PIOA_ABSR_P14 0x00004000 // Peripheral A Select
#define PIOA_ABSR_P15 0x00008000 // Peripheral A Select
#define PIOA_ABSR_P16 0x00010000 // Peripheral A Select
#define PIOA_ABSR_P17 0x00020000 // Peripheral A Select
#define PIOA_ABSR_P18 0x00040000 // Peripheral A Select
#define PIOA_ABSR_P19 0x00080000 // Peripheral A Select
#define PIOA_ABSR_P20 0x00100000 // Peripheral A Select
#define PIOA_ABSR_P21 0x00200000 // Peripheral A Select
#define PIOA_ABSR_P22 0x00400000 // Peripheral A Select
#define PIOA_ABSR_P23 0x00800000 // Peripheral A Select
#define PIOA_ABSR_P24 0x01000000 // Peripheral A Select
#define PIOA_ABSR_P25 0x02000000 // Peripheral A Select
#define PIOA_ABSR_P26 0x04000000 // Peripheral A Select
#define PIOA_ABSR_P27 0x08000000 // Peripheral A Select
#define PIOA_ABSR_P28 0x10000000 // Peripheral A Select
#define PIOA_ABSR_P29 0x20000000 // Peripheral A Select
#define PIOA_ABSR_P30 0x40000000 // Peripheral A Select
#define PIOA_ABSR_P31 0x80000000 // Peripheral A Select

#define PIOA_SCIFSR_P0  0x00000001 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P1  0x00000002 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P2  0x00000004 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P3  0x00000008 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P4  0x00000010 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P5  0x00000020 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P6  0x00000040 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P7  0x00000080 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P8  0x00000100 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P9  0x00000200 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P10 0x00000400 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P11 0x00000800 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P12 0x00001000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P13 0x00002000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P14 0x00004000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P15 0x00008000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P16 0x00010000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P17 0x00020000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P18 0x00040000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P19 0x00080000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P20 0x00100000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P21 0x00200000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P22 0x00400000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P23 0x00800000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P24 0x01000000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P25 0x02000000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P26 0x04000000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P27 0x08000000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P28 0x10000000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P29 0x20000000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P30 0x40000000 // System Clock Glitch Filtering Select
#define PIOA_SCIFSR_P31 0x80000000 // System Clock Glitch Filtering Select

#define PIOA_DIFSR_P0  0x00000001 // Debouncing Filtering Select
#define PIOA_DIFSR_P1  0x00000002 // Debouncing Filtering Select
#define PIOA_DIFSR_P2  0x00000004 // Debouncing Filtering Select
#define PIOA_DIFSR_P3  0x00000008 // Debouncing Filtering Select
#define PIOA_DIFSR_P4  0x00000010 // Debouncing Filtering Select
#define PIOA_DIFSR_P5  0x00000020 // Debouncing Filtering Select
#define PIOA_DIFSR_P6  0x00000040 // Debouncing Filtering Select
#define PIOA_DIFSR_P7  0x00000080 // Debouncing Filtering Select
#define PIOA_DIFSR_P8  0x00000100 // Debouncing Filtering Select
#define PIOA_DIFSR_P9  0x00000200 // Debouncing Filtering Select
#define PIOA_DIFSR_P10 0x00000400 // Debouncing Filtering Select
#define PIOA_DIFSR_P11 0x00000800 // Debouncing Filtering Select
#define PIOA_DIFSR_P12 0x00001000 // Debouncing Filtering Select
#define PIOA_DIFSR_P13 0x00002000 // Debouncing Filtering Select
#define PIOA_DIFSR_P14 0x00004000 // Debouncing Filtering Select
#define PIOA_DIFSR_P15 0x00008000 // Debouncing Filtering Select
#define PIOA_DIFSR_P16 0x00010000 // Debouncing Filtering Select
#define PIOA_DIFSR_P17 0x00020000 // Debouncing Filtering Select
#define PIOA_DIFSR_P18 0x00040000 // Debouncing Filtering Select
#define PIOA_DIFSR_P19 0x00080000 // Debouncing Filtering Select
#define PIOA_DIFSR_P20 0x00100000 // Debouncing Filtering Select
#define PIOA_DIFSR_P21 0x00200000 // Debouncing Filtering Select
#define PIOA_DIFSR_P22 0x00400000 // Debouncing Filtering Select
#define PIOA_DIFSR_P23 0x00800000 // Debouncing Filtering Select
#define PIOA_DIFSR_P24 0x01000000 // Debouncing Filtering Select
#define PIOA_DIFSR_P25 0x02000000 // Debouncing Filtering Select
#define PIOA_DIFSR_P26 0x04000000 // Debouncing Filtering Select
#define PIOA_DIFSR_P27 0x08000000 // Debouncing Filtering Select
#define PIOA_DIFSR_P28 0x10000000 // Debouncing Filtering Select
#define PIOA_DIFSR_P29 0x20000000 // Debouncing Filtering Select
#define PIOA_DIFSR_P30 0x40000000 // Debouncing Filtering Select
#define PIOA_DIFSR_P31 0x80000000 // Debouncing Filtering Select

#define PIOA_IFDGSR_P0  0x00000001 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P1  0x00000002 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P2  0x00000004 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P3  0x00000008 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P4  0x00000010 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P5  0x00000020 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P6  0x00000040 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P7  0x00000080 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P8  0x00000100 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P9  0x00000200 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P10 0x00000400 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P11 0x00000800 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P12 0x00001000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P13 0x00002000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P14 0x00004000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P15 0x00008000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P16 0x00010000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P17 0x00020000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P18 0x00040000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P19 0x00080000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P20 0x00100000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P21 0x00200000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P22 0x00400000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P23 0x00800000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P24 0x01000000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P25 0x02000000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P26 0x04000000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P27 0x08000000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P28 0x10000000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P29 0x20000000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P30 0x40000000 // Glitch or Debouncing Filter Selection Status
#define PIOA_IFDGSR_P31 0x80000000 // Glitch or Debouncing Filter Selection Status

#define PIOA_SCDR_DIV(value) (((value) & 0x3FFF) << 0) // Slow Clock Divider Selection for Debouncing

#define PIOA_OWER_P0  0x00000001 // Output Write Enable
#define PIOA_OWER_P1  0x00000002 // Output Write Enable
#define PIOA_OWER_P2  0x00000004 // Output Write Enable
#define PIOA_OWER_P3  0x00000008 // Output Write Enable
#define PIOA_OWER_P4  0x00000010 // Output Write Enable
#define PIOA_OWER_P5  0x00000020 // Output Write Enable
#define PIOA_OWER_P6  0x00000040 // Output Write Enable
#define PIOA_OWER_P7  0x00000080 // Output Write Enable
#define PIOA_OWER_P8  0x00000100 // Output Write Enable
#define PIOA_OWER_P9  0x00000200 // Output Write Enable
#define PIOA_OWER_P10 0x00000400 // Output Write Enable
#define PIOA_OWER_P11 0x00000800 // Output Write Enable
#define PIOA_OWER_P12 0x00001000 // Output Write Enable
#define PIOA_OWER_P13 0x00002000 // Output Write Enable
#define PIOA_OWER_P14 0x00004000 // Output Write Enable
#define PIOA_OWER_P15 0x00008000 // Output Write Enable
#define PIOA_OWER_P16 0x00010000 // Output Write Enable
#define PIOA_OWER_P17 0x00020000 // Output Write Enable
#define PIOA_OWER_P18 0x00040000 // Output Write Enable
#define PIOA_OWER_P19 0x00080000 // Output Write Enable
#define PIOA_OWER_P20 0x00100000 // Output Write Enable
#define PIOA_OWER_P21 0x00200000 // Output Write Enable
#define PIOA_OWER_P22 0x00400000 // Output Write Enable
#define PIOA_OWER_P23 0x00800000 // Output Write Enable
#define PIOA_OWER_P24 0x01000000 // Output Write Enable
#define PIOA_OWER_P25 0x02000000 // Output Write Enable
#define PIOA_OWER_P26 0x04000000 // Output Write Enable
#define PIOA_OWER_P27 0x08000000 // Output Write Enable
#define PIOA_OWER_P28 0x10000000 // Output Write Enable
#define PIOA_OWER_P29 0x20000000 // Output Write Enable
#define PIOA_OWER_P30 0x40000000 // Output Write Enable
#define PIOA_OWER_P31 0x80000000 // Output Write Enable

#define PIOA_OWDR_P0  0x00000001 // Output Write Disable
#define PIOA_OWDR_P1  0x00000002 // Output Write Disable
#define PIOA_OWDR_P2  0x00000004 // Output Write Disable
#define PIOA_OWDR_P3  0x00000008 // Output Write Disable
#define PIOA_OWDR_P4  0x00000010 // Output Write Disable
#define PIOA_OWDR_P5  0x00000020 // Output Write Disable
#define PIOA_OWDR_P6  0x00000040 // Output Write Disable
#define PIOA_OWDR_P7  0x00000080 // Output Write Disable
#define PIOA_OWDR_P8  0x00000100 // Output Write Disable
#define PIOA_OWDR_P9  0x00000200 // Output Write Disable
#define PIOA_OWDR_P10 0x00000400 // Output Write Disable
#define PIOA_OWDR_P11 0x00000800 // Output Write Disable
#define PIOA_OWDR_P12 0x00001000 // Output Write Disable
#define PIOA_OWDR_P13 0x00002000 // Output Write Disable
#define PIOA_OWDR_P14 0x00004000 // Output Write Disable
#define PIOA_OWDR_P15 0x00008000 // Output Write Disable
#define PIOA_OWDR_P16 0x00010000 // Output Write Disable
#define PIOA_OWDR_P17 0x00020000 // Output Write Disable
#define PIOA_OWDR_P18 0x00040000 // Output Write Disable
#define PIOA_OWDR_P19 0x00080000 // Output Write Disable
#define PIOA_OWDR_P20 0x00100000 // Output Write Disable
#define PIOA_OWDR_P21 0x00200000 // Output Write Disable
#define PIOA_OWDR_P22 0x00400000 // Output Write Disable
#define PIOA_OWDR_P23 0x00800000 // Output Write Disable
#define PIOA_OWDR_P24 0x01000000 // Output Write Disable
#define PIOA_OWDR_P25 0x02000000 // Output Write Disable
#define PIOA_OWDR_P26 0x04000000 // Output Write Disable
#define PIOA_OWDR_P27 0x08000000 // Output Write Disable
#define PIOA_OWDR_P28 0x10000000 // Output Write Disable
#define PIOA_OWDR_P29 0x20000000 // Output Write Disable
#define PIOA_OWDR_P30 0x40000000 // Output Write Disable
#define PIOA_OWDR_P31 0x80000000 // Output Write Disable

#define PIOA_OWSR_P0  0x00000001 // Output Write Status
#define PIOA_OWSR_P1  0x00000002 // Output Write Status
#define PIOA_OWSR_P2  0x00000004 // Output Write Status
#define PIOA_OWSR_P3  0x00000008 // Output Write Status
#define PIOA_OWSR_P4  0x00000010 // Output Write Status
#define PIOA_OWSR_P5  0x00000020 // Output Write Status
#define PIOA_OWSR_P6  0x00000040 // Output Write Status
#define PIOA_OWSR_P7  0x00000080 // Output Write Status
#define PIOA_OWSR_P8  0x00000100 // Output Write Status
#define PIOA_OWSR_P9  0x00000200 // Output Write Status
#define PIOA_OWSR_P10 0x00000400 // Output Write Status
#define PIOA_OWSR_P11 0x00000800 // Output Write Status
#define PIOA_OWSR_P12 0x00001000 // Output Write Status
#define PIOA_OWSR_P13 0x00002000 // Output Write Status
#define PIOA_OWSR_P14 0x00004000 // Output Write Status
#define PIOA_OWSR_P15 0x00008000 // Output Write Status
#define PIOA_OWSR_P16 0x00010000 // Output Write Status
#define PIOA_OWSR_P17 0x00020000 // Output Write Status
#define PIOA_OWSR_P18 0x00040000 // Output Write Status
#define PIOA_OWSR_P19 0x00080000 // Output Write Status
#define PIOA_OWSR_P20 0x00100000 // Output Write Status
#define PIOA_OWSR_P21 0x00200000 // Output Write Status
#define PIOA_OWSR_P22 0x00400000 // Output Write Status
#define PIOA_OWSR_P23 0x00800000 // Output Write Status
#define PIOA_OWSR_P24 0x01000000 // Output Write Status
#define PIOA_OWSR_P25 0x02000000 // Output Write Status
#define PIOA_OWSR_P26 0x04000000 // Output Write Status
#define PIOA_OWSR_P27 0x08000000 // Output Write Status
#define PIOA_OWSR_P28 0x10000000 // Output Write Status
#define PIOA_OWSR_P29 0x20000000 // Output Write Status
#define PIOA_OWSR_P30 0x40000000 // Output Write Status
#define PIOA_OWSR_P31 0x80000000 // Output Write Status

#define PIOA_AIMER_P0  0x00000001 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P1  0x00000002 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P2  0x00000004 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P3  0x00000008 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P4  0x00000010 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P5  0x00000020 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P6  0x00000040 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P7  0x00000080 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P8  0x00000100 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P9  0x00000200 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P10 0x00000400 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P11 0x00000800 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P12 0x00001000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P13 0x00002000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P14 0x00004000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P15 0x00008000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P16 0x00010000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P17 0x00020000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P18 0x00040000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P19 0x00080000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P20 0x00100000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P21 0x00200000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P22 0x00400000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P23 0x00800000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P24 0x01000000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P25 0x02000000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P26 0x04000000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P27 0x08000000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P28 0x10000000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P29 0x20000000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P30 0x40000000 // Additional Interrupt Modes Enable
#define PIOA_AIMER_P31 0x80000000 // Additional Interrupt Modes Enable

#define PIOA_AIMDR_P0  0x00000001 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P1  0x00000002 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P2  0x00000004 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P3  0x00000008 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P4  0x00000010 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P5  0x00000020 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P6  0x00000040 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P7  0x00000080 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P8  0x00000100 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P9  0x00000200 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P10 0x00000400 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P11 0x00000800 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P12 0x00001000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P13 0x00002000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P14 0x00004000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P15 0x00008000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P16 0x00010000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P17 0x00020000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P18 0x00040000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P19 0x00080000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P20 0x00100000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P21 0x00200000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P22 0x00400000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P23 0x00800000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P24 0x01000000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P25 0x02000000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P26 0x04000000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P27 0x08000000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P28 0x10000000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P29 0x20000000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P30 0x40000000 // Additional Interrupt Modes Disable
#define PIOA_AIMDR_P31 0x80000000 // Additional Interrupt Modes Disable

#define PIOA_AIMMR_P0  0x00000001 // Peripheral CD Status
#define PIOA_AIMMR_P1  0x00000002 // Peripheral CD Status
#define PIOA_AIMMR_P2  0x00000004 // Peripheral CD Status
#define PIOA_AIMMR_P3  0x00000008 // Peripheral CD Status
#define PIOA_AIMMR_P4  0x00000010 // Peripheral CD Status
#define PIOA_AIMMR_P5  0x00000020 // Peripheral CD Status
#define PIOA_AIMMR_P6  0x00000040 // Peripheral CD Status
#define PIOA_AIMMR_P7  0x00000080 // Peripheral CD Status
#define PIOA_AIMMR_P8  0x00000100 // Peripheral CD Status
#define PIOA_AIMMR_P9  0x00000200 // Peripheral CD Status
#define PIOA_AIMMR_P10 0x00000400 // Peripheral CD Status
#define PIOA_AIMMR_P11 0x00000800 // Peripheral CD Status
#define PIOA_AIMMR_P12 0x00001000 // Peripheral CD Status
#define PIOA_AIMMR_P13 0x00002000 // Peripheral CD Status
#define PIOA_AIMMR_P14 0x00004000 // Peripheral CD Status
#define PIOA_AIMMR_P15 0x00008000 // Peripheral CD Status
#define PIOA_AIMMR_P16 0x00010000 // Peripheral CD Status
#define PIOA_AIMMR_P17 0x00020000 // Peripheral CD Status
#define PIOA_AIMMR_P18 0x00040000 // Peripheral CD Status
#define PIOA_AIMMR_P19 0x00080000 // Peripheral CD Status
#define PIOA_AIMMR_P20 0x00100000 // Peripheral CD Status
#define PIOA_AIMMR_P21 0x00200000 // Peripheral CD Status
#define PIOA_AIMMR_P22 0x00400000 // Peripheral CD Status
#define PIOA_AIMMR_P23 0x00800000 // Peripheral CD Status
#define PIOA_AIMMR_P24 0x01000000 // Peripheral CD Status
#define PIOA_AIMMR_P25 0x02000000 // Peripheral CD Status
#define PIOA_AIMMR_P26 0x04000000 // Peripheral CD Status
#define PIOA_AIMMR_P27 0x08000000 // Peripheral CD Status
#define PIOA_AIMMR_P28 0x10000000 // Peripheral CD Status
#define PIOA_AIMMR_P29 0x20000000 // Peripheral CD Status
#define PIOA_AIMMR_P30 0x40000000 // Peripheral CD Status
#define PIOA_AIMMR_P31 0x80000000 // Peripheral CD Status

#define PIOA_ESR_P0  0x00000001 // Edge Interrupt Selection
#define PIOA_ESR_P1  0x00000002 // Edge Interrupt Selection
#define PIOA_ESR_P2  0x00000004 // Edge Interrupt Selection
#define PIOA_ESR_P3  0x00000008 // Edge Interrupt Selection
#define PIOA_ESR_P4  0x00000010 // Edge Interrupt Selection
#define PIOA_ESR_P5  0x00000020 // Edge Interrupt Selection
#define PIOA_ESR_P6  0x00000040 // Edge Interrupt Selection
#define PIOA_ESR_P7  0x00000080 // Edge Interrupt Selection
#define PIOA_ESR_P8  0x00000100 // Edge Interrupt Selection
#define PIOA_ESR_P9  0x00000200 // Edge Interrupt Selection
#define PIOA_ESR_P10 0x00000400 // Edge Interrupt Selection
#define PIOA_ESR_P11 0x00000800 // Edge Interrupt Selection
#define PIOA_ESR_P12 0x00001000 // Edge Interrupt Selection
#define PIOA_ESR_P13 0x00002000 // Edge Interrupt Selection
#define PIOA_ESR_P14 0x00004000 // Edge Interrupt Selection
#define PIOA_ESR_P15 0x00008000 // Edge Interrupt Selection
#define PIOA_ESR_P16 0x00010000 // Edge Interrupt Selection
#define PIOA_ESR_P17 0x00020000 // Edge Interrupt Selection
#define PIOA_ESR_P18 0x00040000 // Edge Interrupt Selection
#define PIOA_ESR_P19 0x00080000 // Edge Interrupt Selection
#define PIOA_ESR_P20 0x00100000 // Edge Interrupt Selection
#define PIOA_ESR_P21 0x00200000 // Edge Interrupt Selection
#define PIOA_ESR_P22 0x00400000 // Edge Interrupt Selection
#define PIOA_ESR_P23 0x00800000 // Edge Interrupt Selection
#define PIOA_ESR_P24 0x01000000 // Edge Interrupt Selection
#define PIOA_ESR_P25 0x02000000 // Edge Interrupt Selection
#define PIOA_ESR_P26 0x04000000 // Edge Interrupt Selection
#define PIOA_ESR_P27 0x08000000 // Edge Interrupt Selection
#define PIOA_ESR_P28 0x10000000 // Edge Interrupt Selection
#define PIOA_ESR_P29 0x20000000 // Edge Interrupt Selection
#define PIOA_ESR_P30 0x40000000 // Edge Interrupt Selection
#define PIOA_ESR_P31 0x80000000 // Edge Interrupt Selection

#define PIOA_LSR_P0  0x00000001 // Level Interrupt Selection
#define PIOA_LSR_P1  0x00000002 // Level Interrupt Selection
#define PIOA_LSR_P2  0x00000004 // Level Interrupt Selection
#define PIOA_LSR_P3  0x00000008 // Level Interrupt Selection
#define PIOA_LSR_P4  0x00000010 // Level Interrupt Selection
#define PIOA_LSR_P5  0x00000020 // Level Interrupt Selection
#define PIOA_LSR_P6  0x00000040 // Level Interrupt Selection
#define PIOA_LSR_P7  0x00000080 // Level Interrupt Selection
#define PIOA_LSR_P8  0x00000100 // Level Interrupt Selection
#define PIOA_LSR_P9  0x00000200 // Level Interrupt Selection
#define PIOA_LSR_P10 0x00000400 // Level Interrupt Selection
#define PIOA_LSR_P11 0x00000800 // Level Interrupt Selection
#define PIOA_LSR_P12 0x00001000 // Level Interrupt Selection
#define PIOA_LSR_P13 0x00002000 // Level Interrupt Selection
#define PIOA_LSR_P14 0x00004000 // Level Interrupt Selection
#define PIOA_LSR_P15 0x00008000 // Level Interrupt Selection
#define PIOA_LSR_P16 0x00010000 // Level Interrupt Selection
#define PIOA_LSR_P17 0x00020000 // Level Interrupt Selection
#define PIOA_LSR_P18 0x00040000 // Level Interrupt Selection
#define PIOA_LSR_P19 0x00080000 // Level Interrupt Selection
#define PIOA_LSR_P20 0x00100000 // Level Interrupt Selection
#define PIOA_LSR_P21 0x00200000 // Level Interrupt Selection
#define PIOA_LSR_P22 0x00400000 // Level Interrupt Selection
#define PIOA_LSR_P23 0x00800000 // Level Interrupt Selection
#define PIOA_LSR_P24 0x01000000 // Level Interrupt Selection
#define PIOA_LSR_P25 0x02000000 // Level Interrupt Selection
#define PIOA_LSR_P26 0x04000000 // Level Interrupt Selection
#define PIOA_LSR_P27 0x08000000 // Level Interrupt Selection
#define PIOA_LSR_P28 0x10000000 // Level Interrupt Selection
#define PIOA_LSR_P29 0x20000000 // Level Interrupt Selection
#define PIOA_LSR_P30 0x40000000 // Level Interrupt Selection
#define PIOA_LSR_P31 0x80000000 // Level Interrupt Selection

#define PIOA_ELSR_P0  0x00000001 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P1  0x00000002 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P2  0x00000004 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P3  0x00000008 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P4  0x00000010 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P5  0x00000020 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P6  0x00000040 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P7  0x00000080 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P8  0x00000100 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P9  0x00000200 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P10 0x00000400 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P11 0x00000800 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P12 0x00001000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P13 0x00002000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P14 0x00004000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P15 0x00008000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P16 0x00010000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P17 0x00020000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P18 0x00040000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P19 0x00080000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P20 0x00100000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P21 0x00200000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P22 0x00400000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P23 0x00800000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P24 0x01000000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P25 0x02000000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P26 0x04000000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P27 0x08000000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P28 0x10000000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P29 0x20000000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P30 0x40000000 // Edge/Level Interrupt source selection
#define PIOA_ELSR_P31 0x80000000 // Edge/Level Interrupt source selection

#define PIOA_FELLSR_P0  0x00000001 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P1  0x00000002 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P2  0x00000004 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P3  0x00000008 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P4  0x00000010 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P5  0x00000020 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P6  0x00000040 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P7  0x00000080 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P8  0x00000100 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P9  0x00000200 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P10 0x00000400 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P11 0x00000800 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P12 0x00001000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P13 0x00002000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P14 0x00004000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P15 0x00008000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P16 0x00010000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P17 0x00020000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P18 0x00040000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P19 0x00080000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P20 0x00100000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P21 0x00200000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P22 0x00400000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P23 0x00800000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P24 0x01000000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P25 0x02000000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P26 0x04000000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P27 0x08000000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P28 0x10000000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P29 0x20000000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P30 0x40000000 // Falling Edge/Low Level Interrupt Selection
#define PIOA_FELLSR_P31 0x80000000 // Falling Edge/Low Level Interrupt Selection

#define PIOA_REHLSR_P0  0x00000001 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P1  0x00000002 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P2  0x00000004 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P3  0x00000008 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P4  0x00000010 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P5  0x00000020 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P6  0x00000040 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P7  0x00000080 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P8  0x00000100 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P9  0x00000200 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P10 0x00000400 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P11 0x00000800 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P12 0x00001000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P13 0x00002000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P14 0x00004000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P15 0x00008000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P16 0x00010000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P17 0x00020000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P18 0x00040000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P19 0x00080000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P20 0x00100000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P21 0x00200000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P22 0x00400000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P23 0x00800000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P24 0x01000000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P25 0x02000000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P26 0x04000000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P27 0x08000000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P28 0x10000000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P29 0x20000000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P30 0x40000000 // Rising Edge /High Level Interrupt Selection
#define PIOA_REHLSR_P31 0x80000000 // Rising Edge /High Level Interrupt Selection

#define PIOA_FRLHSR_P0  0x00000001 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P1  0x00000002 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P2  0x00000004 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P3  0x00000008 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P4  0x00000010 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P5  0x00000020 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P6  0x00000040 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P7  0x00000080 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P8  0x00000100 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P9  0x00000200 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P10 0x00000400 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P11 0x00000800 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P12 0x00001000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P13 0x00002000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P14 0x00004000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P15 0x00008000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P16 0x00010000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P17 0x00020000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P18 0x00040000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P19 0x00080000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P20 0x00100000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P21 0x00200000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P22 0x00400000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P23 0x00800000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P24 0x01000000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P25 0x02000000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P26 0x04000000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P27 0x08000000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P28 0x10000000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P29 0x20000000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P30 0x40000000 // Edge /Level Interrupt Source Selection
#define PIOA_FRLHSR_P31 0x80000000 // Edge /Level Interrupt Source Selection

#define PIOA_LOCKSR_P0  0x00000001 // Lock Status
#define PIOA_LOCKSR_P1  0x00000002 // Lock Status
#define PIOA_LOCKSR_P2  0x00000004 // Lock Status
#define PIOA_LOCKSR_P3  0x00000008 // Lock Status
#define PIOA_LOCKSR_P4  0x00000010 // Lock Status
#define PIOA_LOCKSR_P5  0x00000020 // Lock Status
#define PIOA_LOCKSR_P6  0x00000040 // Lock Status
#define PIOA_LOCKSR_P7  0x00000080 // Lock Status
#define PIOA_LOCKSR_P8  0x00000100 // Lock Status
#define PIOA_LOCKSR_P9  0x00000200 // Lock Status
#define PIOA_LOCKSR_P10 0x00000400 // Lock Status
#define PIOA_LOCKSR_P11 0x00000800 // Lock Status
#define PIOA_LOCKSR_P12 0x00001000 // Lock Status
#define PIOA_LOCKSR_P13 0x00002000 // Lock Status
#define PIOA_LOCKSR_P14 0x00004000 // Lock Status
#define PIOA_LOCKSR_P15 0x00008000 // Lock Status
#define PIOA_LOCKSR_P16 0x00010000 // Lock Status
#define PIOA_LOCKSR_P17 0x00020000 // Lock Status
#define PIOA_LOCKSR_P18 0x00040000 // Lock Status
#define PIOA_LOCKSR_P19 0x00080000 // Lock Status
#define PIOA_LOCKSR_P20 0x00100000 // Lock Status
#define PIOA_LOCKSR_P21 0x00200000 // Lock Status
#define PIOA_LOCKSR_P22 0x00400000 // Lock Status
#define PIOA_LOCKSR_P23 0x00800000 // Lock Status
#define PIOA_LOCKSR_P24 0x01000000 // Lock Status
#define PIOA_LOCKSR_P25 0x02000000 // Lock Status
#define PIOA_LOCKSR_P26 0x04000000 // Lock Status
#define PIOA_LOCKSR_P27 0x08000000 // Lock Status
#define PIOA_LOCKSR_P28 0x10000000 // Lock Status
#define PIOA_LOCKSR_P29 0x20000000 // Lock Status
#define PIOA_LOCKSR_P30 0x40000000 // Lock Status
#define PIOA_LOCKSR_P31 0x80000000 // Lock Status

#define PIOA_WPMR_WPEN         0x00000001                  // Write Protect Enable
#define PIOA_WPMR_WPKEY(value) (((value) & 0xFFFFFF) << 8) // Write Protect KEY

#define PIOA_WPSR_WPVS          0x00000001                // Write Protect Violation Status
#define PIOA_WPSR_WPVSRC(value) (((value) & 0xFFFF) << 8) // Write Protect Violation Source

#define PIOB_PER    (*(volatile unsigned int *)0x400E1000)       // [PIO Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1076654)
#define PIOB_PDR    (*(volatile unsigned int *)0x400E1004)       // [PIO Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1076837)
#define PIOB_PSR    (*(const volatile unsigned int *)0x400E1008) // [PIO Status Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077021)
#define PIOB_OER    (*(volatile unsigned int *)0x400E1010)       // [Output Enable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077204)
#define PIOB_ODR    (*(volatile unsigned int *)0x400E1014)       // [Output Disable Register](https://code.fbi.h-da.de/eingebettete-systeme/arduino-due/cmsis/-/raw/main/docs/datasheet.pdf#nameddest=G22.1077388)
#define PIOB_OSR    (*(const volatile unsigned int *)0x400E1018) // [Output Status Register](https://code.fbi.h-da.de/eingebettete-systeme/ar