/*
 * Copyright (c) 2025 Hochschule Darmstadt
 *
 * This software is provided exclusively for the practical part of the
 * course 'Embedded Systems' at 'Darmstadt University of Applied Sciences
 * (Hochschule Darmstadt, h_da)'.
 *
 * Any use, distribution, or modification outside this context is prohibited
 * without explicit permission.
 *
 * AUTHORS: David Heiß, Manfred Pester, Jens-Peter Akelbein
 * FILE: led.c
 * CONTENTS: Source for Due Onboard LED control
 */

#include <led.h>

#include <stdbool.h>
#include <state.h>
#include <sam.h>

// BUILTIN-LED on Arduino Due Board on PIO Port B Bit 27
#define DUE_LED_BUILTIN 0x08000000

// return state of LED
static bool led_get(void)
{
    // TODO
    return false;
}

// turn on/off LED
static void led_set(bool led_on)
{
    // TODO
}

// toogle LED
static void led_toggle(void)
{
    led_set(!led_get());
}

// LED is toggling after a number of calls
static void led_blinking(void)
{
    static unsigned int last_update = 0;
    if (value.clock.time - last_update >= 500)
    {
        led_toggle();
        last_update = value.clock.time;
    }
}

// initial config for using LED
void led_init(void)
{
    // TODO
}

// loop for LED control - blinking when EDA code is running
void led_loop(void)
{
    switch (state.led)
    {
    case LED_STATE_OFF:
        led_set(false);
        break;
    case LED_STATE_ON:
        led_set(true);
        break;
    case LED_STATE_BLINKING:
        led_blinking();
        break;
    case LED_STATE_INVALID:
        __builtin_unreachable();
    }
    value.led = led_get();
}