# Embedded Tools

The Embedded Tools extension provides a register viewer for [CMSIS-SVD](https://www.keil.com/pack/doc/CMSIS/SVD/html/index.html) files, and an RTOS data viewer with support for [Azure RTOS](https://azure.microsoft.com/en-us/services/rtos/), [FreeRTOS](https://www.freertos.org/), and [Zephyr](https://zephyrproject.org/).

## Get Started

To get started with this extension, you should configure a `cppdbg` debug session. To enable the `Peripheral View` you should provide a value for the `svdPath` field.

Once you have started a debug session, you should see the `Peripheral View` and `RTOS View` populated in the Side Bar of the debug view and in the Panel, respectively.
![Embedded Tools](https://github.com/microsoft/vscode-embedded-tools/raw/HEAD/assets/EmbeddedTools.gif)

## Feedback

We appreciate any feedback you have to help improve this extension. To submit feedback, please [create an issue](https://github.com/microsoft/vscode-embedded-tools/issues/new) on our GitHub page.

## Documentation

The tool windows and the general embedded support for Visual Studio Code are documented [here](https://docs.microsoft.com/en-us/cpp/embedded/?view=msvc-170).

### Data/Telemetry

This extension collects usage data and sends it to Microsoft to help improve our products and services. Collection of telemetry is controlled via the same setting provided by Visual Studio Code: `"telemetry.enableTelemetry"`. Read our [privacy statement](https://privacy.microsoft.com/en-us/privacystatement) to learn more.

