"use strict";var __importDefault=this&&this.__importDefault||function(t){return t&&t.__esModule?t:{default:t}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.DarwinPortBinding=exports.DarwinBinding=void 0;const debug_1=__importDefault(require("debug")),load_bindings_1=require("./load-bindings"),poller_1=require("./poller"),unix_read_1=require("./unix-read"),unix_write_1=require("./unix-write"),debug=(0,debug_1.default)("serialport/bindings-cpp");exports.DarwinBinding={list:()=>(debug("list"),(0,load_bindings_1.asyncList)()),async open(t){if(!t||"object"!=typeof t||Array.isArray(t))throw new TypeError('"options" is not an object');if(!t.path)throw new TypeError('"path" is not a valid port');if(!t.baudRate)throw new TypeError('"baudRate" is not a valid baudRate');debug("open");const r=Object.assign({vmin:1,vtime:0,dataBits:8,lock:!0,stopBits:1,parity:"none",rtscts:!1,xon:!1,xoff:!1,xany:!1,hupcl:!0},t),e=await(0,load_bindings_1.asyncOpen)(r.path,r);return new DarwinPortBinding(e,r)}};class DarwinPortBinding{constructor(t,r){this.fd=t,this.openOptions=r,this.poller=new poller_1.Poller(t),this.writeOperation=null}get isOpen(){return null!==this.fd}async close(){if(debug("close"),!this.isOpen)throw new Error("Port is not open");const t=this.fd;this.poller.stop(),this.poller.destroy(),this.fd=null,await(0,load_bindings_1.asyncClose)(t)}async read(t,r,e){if(!Buffer.isBuffer(t))throw new TypeError('"buffer" is not a Buffer');if("number"!=typeof r||isNaN(r))throw new TypeError(`"offset" is not an integer got "${isNaN(r)?"NaN":typeof r}"`);if("number"!=typeof e||isNaN(e))throw new TypeError(`"length" is not an integer got "${isNaN(e)?"NaN":typeof e}"`);if(debug("read"),t.length<r+e)throw new Error("buffer is too small");if(!this.isOpen)throw new Error("Port is not open");return(0,unix_read_1.unixRead)({binding:this,buffer:t,offset:r,length:e})}async write(t){if(!Buffer.isBuffer(t))throw new TypeError('"buffer" is not a Buffer');if(debug("write",t.length,"bytes"),!this.isOpen)throw debug("write","error port is not open"),new Error("Port is not open");return this.writeOperation=(async()=>{0!==t.length&&(await(0,unix_write_1.unixWrite)({binding:this,buffer:t}),this.writeOperation=null)})(),this.writeOperation}async update(t){if(!t||"object"!=typeof t||Array.isArray(t))throw TypeError('"options" is not an object');if("number"!=typeof t.baudRate)throw new TypeError('"options.baudRate" is not a number');if(debug("update"),!this.isOpen)throw new Error("Port is not open");await(0,load_bindings_1.asyncUpdate)(this.fd,t)}async set(t){if(!t||"object"!=typeof t||Array.isArray(t))throw new TypeError('"options" is not an object');if(debug("set",t),!this.isOpen)throw new Error("Port is not open");await(0,load_bindings_1.asyncSet)(this.fd,t)}async get(){if(debug("get"),!this.isOpen)throw new Error("Port is not open");return(0,load_bindings_1.asyncGet)(this.fd)}async getBaudRate(){if(debug("getBaudRate"),!this.isOpen)throw new Error("Port is not open");throw new Error("getBaudRate is not implemented on darwin")}async flush(){if(debug("flush"),!this.isOpen)throw new Error("Port is not open");await(0,load_bindings_1.asyncFlush)(this.fd)}async drain(){if(debug("drain"),!this.isOpen)throw new Error("Port is not open");await this.writeOperation,await(0,load_bindings_1.asyncDrain)(this.fd)}}exports.DarwinPortBinding=DarwinPortBinding;
// SIG // Begin signature block
// SIG // MIIoTwYJKoZIhvcNAQcCoIIoQDCCKDwCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // wm3u9R2z1vhK9KUVXq0xIC5aSlrvuv1+FBJ58Ihfa0yg
// SIG // gg2aMIIGGDCCBACgAwIBAgITMwAAA/O5amS77/ftYwAA
// SIG // AAAD8zANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTI0MDcxNzIxMDIzNFoX
// SIG // DTI1MDkxNTIxMDIzNFowgYgxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xMjAwBgNVBAMTKU1pY3Jvc29mdCAzcmQgUGFydHkg
// SIG // QXBwbGljYXRpb24gQ29tcG9uZW50MIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuJZyYTUkf/jOL2+w
// SIG // jAIr0zGEmBItBJx10kg2rf/QcDw9otBdYY+1vNFvHRLp
// SIG // b+dX89TQCCym3iKdiWku++5n32B38TFMPwXELMs1uidX
// SIG // ucVDzYLhlNhhV63ObPo8it/QCKROgE2XnIzA7gLuD9Z1
// SIG // RHGSg0dHwWz+0PAhXtdz4J2Yt5/+FF28GhJbxZK8ImuM
// SIG // IfPICfu5QxZGVDiNR9ccRDYD/cti5Qon6xzmoQF3GPk2
// SIG // ksnmar/hNI1eUpAavMzRQnlsjG6KCTz7Ehvi0BH0trDu
// SIG // MTazR2TJSYs4le/YddqsS4nD3rMLoDXQ/mgV6hdH8KKL
// SIG // z7r0sGik/8DPKJDTMQIDAQABo4IBgjCCAX4wHwYDVR0l
// SIG // BBgwFgYKKwYBBAGCN0wRAQYIKwYBBQUHAwMwHQYDVR0O
// SIG // BBYEFNUXbIMP3Uc+qArjvLCjbK6HZhMPMFQGA1UdEQRN
// SIG // MEukSTBHMS0wKwYDVQQLEyRNaWNyb3NvZnQgSXJlbGFu
// SIG // ZCBPcGVyYXRpb25zIExpbWl0ZWQxFjAUBgNVBAUTDTIz
// SIG // MTUyMis1MDI1MjEwHwYDVR0jBBgwFoAUSG5k5VAF04Kq
// SIG // Fzc3IrVtqMp1ApUwVAYDVR0fBE0wSzBJoEegRYZDaHR0
// SIG // cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9jcmwv
// SIG // TWljQ29kU2lnUENBMjAxMV8yMDExLTA3LTA4LmNybDBh
// SIG // BggrBgEFBQcBAQRVMFMwUQYIKwYBBQUHMAKGRWh0dHA6
// SIG // Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvY2VydHMv
// SIG // TWljQ29kU2lnUENBMjAxMV8yMDExLTA3LTA4LmNydDAM
// SIG // BgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4ICAQBj
// SIG // RShosExjVPOZfvN7SYQejdgT72k/UwJLhO7lJ4rtVVOm
// SIG // 9f3q3JJl4rlagS4NrBsxOztdtmyvO9XzVqYhK/f6TH5W
// SIG // odTy//tA+lwqHVkuNVJliC0VIUqilEWfonHquZ+BFIin
// SIG // GqQSoWergil0l+tglR5bzb+DeiQOzVM7RNId4wBEHi6B
// SIG // khZXzar5EzqGxOTcJTEUiVoUOkmJ7MIk2NUFNOqUk2j/
// SIG // 3lXnS0ZOqt7f1PYm71cB0/nk8NQEgW2aGTsVgNxY6yvV
// SIG // 4rDk/xqMldsPQ94MyhRjhJQhaUb3HhnkSstjd2EkY44F
// SIG // fVWJVDORv3M+GYoAArZ3eI3xO3m2ypog79lAdSFKcUs0
// SIG // uEwDtW5ADW8Cf3630opFDxn2Utn0UVzFmU3kC+W0wXJl
// SIG // uyDTUyMTNjMRekKpS7ZpCWd4r/XKHMENTM1q63dQVP4q
// SIG // S8IBrW8O5gnrLV2Yz9mphXkI7nALSrfT5BDZ1n1Hsa8E
// SIG // GZ2SVhd5glbyU4egAlNAicjtGtmvkYrsbL0fEKTMNYBN
// SIG // ++OEmzO+ZwAbvOP83ZMX0ZIl66OSLFCfnjVV1ShJbxZ4
// SIG // Ac6W2LU1X9T3XLPMtLBKOhcRkJM8CjSx3tvLRtR9zUx1
// SIG // DWtC0FCkYzKv+fCGr/aquK1tUCM31wBJwQ0gRb9ROLy5
// SIG // sdi4IajET8kwAWbq6wgp9TCCB3owggVioAMCAQICCmEO
// SIG // kNIAAAAAAAMwDQYJKoZIhvcNAQELBQAwgYgxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xMjAwBgNVBAMTKU1pY3Jvc29mdCBS
// SIG // b290IENlcnRpZmljYXRlIEF1dGhvcml0eSAyMDExMB4X
// SIG // DTExMDcwODIwNTkwOVoXDTI2MDcwODIxMDkwOVowfjEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEoMCYGA1UEAxMfTWljcm9z
// SIG // b2Z0IENvZGUgU2lnbmluZyBQQ0EgMjAxMTCCAiIwDQYJ
// SIG // KoZIhvcNAQEBBQADggIPADCCAgoCggIBAKvw+nIQHC6t
// SIG // 2G6qghBNNLrytlghn0IbKmvpWlCquAY4GgRJun/DDB7d
// SIG // N2vGEtgL8DjCmQawyDnVARQxQtOJDXlkh36UYCRsr55J
// SIG // nOloXtLfm1OyCizDr9mpK656Ca/XllnKYBoF6WZ26DJS
// SIG // JhIv56sIUM+zRLdd2MQuA3WraPPLbfM6XKEW9Ea64Dhk
// SIG // rG5kNXimoGMPLdNAk/jj3gcN1Vx5pUkp5w2+oBN3vpQ9
// SIG // 7/vjK1oQH01WKKJ6cuASOrdJXtjt7UORg9l7snuGG9k+
// SIG // sYxd6IlPhBryoS9Z5JA7La4zWMW3Pv4y07MDPbGyr5I4
// SIG // ftKdgCz1TlaRITUlwzluZH9TupwPrRkjhMv0ugOGjfdf
// SIG // 8NBSv4yUh7zAIXQlXxgotswnKDglmDlKNs98sZKuHCOn
// SIG // qWbsYR9q4ShJnV+I4iVd0yFLPlLEtVc/JAPw0XpbL9Uj
// SIG // 43BdD1FGd7P4AOG8rAKCX9vAFbO9G9RVS+c5oQ/pI0m8
// SIG // GLhEfEXkwcNyeuBy5yTfv0aZxe/CHFfbg43sTUkwp6uO
// SIG // 3+xbn6/83bBm4sGXgXvt1u1L50kppxMopqd9Z4DmimJ4
// SIG // X7IvhNdXnFy/dygo8e1twyiPLI9AN0/B4YVEicQJTMXU
// SIG // pUMvdJX3bvh4IFgsE11glZo+TzOE2rCIF96eTvSWsLxG
// SIG // oGyY0uDWiIwLAgMBAAGjggHtMIIB6TAQBgkrBgEEAYI3
// SIG // FQEEAwIBADAdBgNVHQ4EFgQUSG5k5VAF04KqFzc3IrVt
// SIG // qMp1ApUwGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // CwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHwYD
// SIG // VR0jBBgwFoAUci06AjGQQ7kUBU7h6qfHMdEjiTQwWgYD
// SIG // VR0fBFMwUTBPoE2gS4ZJaHR0cDovL2NybC5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljUm9vQ2Vy
// SIG // QXV0MjAxMV8yMDExXzAzXzIyLmNybDBeBggrBgEFBQcB
// SIG // AQRSMFAwTgYIKwYBBQUHMAKGQmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // MjAxMV8yMDExXzAzXzIyLmNydDCBnwYDVR0gBIGXMIGU
// SIG // MIGRBgkrBgEEAYI3LgMwgYMwPwYIKwYBBQUHAgEWM2h0
// SIG // dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvZG9j
// SIG // cy9wcmltYXJ5Y3BzLmh0bTBABggrBgEFBQcCAjA0HjIg
// SIG // HQBMAGUAZwBhAGwAXwBwAG8AbABpAGMAeQBfAHMAdABh
// SIG // AHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOC
// SIG // AgEAZ/KGpZjgVHkaLtPYdGcimwuWEeFjkplCln3SeQyQ
// SIG // wWVfLiw++MNy0W2D/r4/6ArKO79HqaPzadtjvyI1pZdd
// SIG // ZYSQfYtGUFXYDJJ80hpLHPM8QotS0LD9a+M+By4pm+Y9
// SIG // G6XUtR13lDni6WTJRD14eiPzE32mkHSDjfTLJgJGKsKK
// SIG // ELukqQUMm+1o+mgulaAqPyprWEljHwlpblqYluSD9MCP
// SIG // 80Yr3vw70L01724lruWvJ+3Q3fMOr5kol5hNDj0L8giJ
// SIG // 1h/DMhji8MUtzluetEk5CsYKwsatruWy2dsViFFFWDgy
// SIG // cScaf7H0J/jeLDogaZiyWYlobm+nt3TDQAUGpgEqKD6C
// SIG // PxNNZgvAs0314Y9/HG8VfUWnduVAKmWjw11SYobDHWM2
// SIG // l4bf2vP48hahmifhzaWX0O5dY0HjWwechz4GdwbRBrF1
// SIG // HxS+YWG18NzGGwS+30HHDiju3mUv7Jf2oVyW2ADWoUa9
// SIG // WfOXpQlLSBCZgB/QACnFsZulP0V3HjXG0qKin3p6IvpI
// SIG // lR+r+0cjgPWe+L9rt0uX4ut1eBrs6jeZeRhL/9azI2h1
// SIG // 5q/6/IvrC4DqaTuv/DDtBEyO3991bWORPdGdVk5Pv4BX
// SIG // IqF4ETIheu9BCrE/+6jMpF3BoYibV3FWTkhFwELJm3Zb
// SIG // CoBIa/15n8G9bW1qyVJzEw16UM0xghoNMIIaCQIBATCB
// SIG // lTB+MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9N
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQSAyMDExAhMz
// SIG // AAAD87lqZLvv9+1jAAAAAAPzMA0GCWCGSAFlAwQCAQUA
// SIG // oIGuMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
// SIG // CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqG
// SIG // SIb3DQEJBDEiBCCDbdorWiCeXTNjuixY8nbqzAyW9B7A
// SIG // r44l5JyLIT8akDBCBgorBgEEAYI3AgEMMTQwMqAUgBIA
// SIG // TQBpAGMAcgBvAHMAbwBmAHShGoAYaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBAFx1
// SIG // DAiGVgLW0Uqv9UNA6I1c0M3TEFeUUydGDxEob3186bu2
// SIG // iBt8ZNnrnIBwDkMq532uHCBffG3GTAjyZdS+WYuSdK3i
// SIG // xGWn5zjLR8CU9AzPkppHww7OxRikkRFKvBg9p8OWjv1d
// SIG // F8A6ELbD17JdXHSUKwQxmrrkyRsrlH24CZhvwNyvtDyT
// SIG // OFzz3KoBqhMj6wIyyhOL56YL0V0WEOUjNJ+e4bmnbwkZ
// SIG // 8yQmTOV1qnS0YrV9t/Um1d8edIHCFidmBchm7PVSEI+b
// SIG // 4Ttifk62loYwvauL/TNixCjBb6rcJMbrDKts8wowJMAf
// SIG // HCQjm5LgnTHqJ3Tf28o5LnbPvcj/woWhgheXMIIXkwYK
// SIG // KwYBBAGCNwMDATGCF4Mwghd/BgkqhkiG9w0BBwKgghdw
// SIG // MIIXbAIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBUgYLKoZI
// SIG // hvcNAQkQAQSgggFBBIIBPTCCATkCAQEGCisGAQQBhFkK
// SIG // AwEwMTANBglghkgBZQMEAgEFAAQglgKVBZNuRZ4IZYCm
// SIG // qUNPOCIPi+6rMT/hnqvP+h6JPYcCBmbjDw5FWxgTMjAy
// SIG // NDA5MTcxNTIzMTguODk0WjAEgAIB9KCB0aSBzjCByzEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjElMCMGA1UECxMcTWljcm9z
// SIG // b2Z0IEFtZXJpY2EgT3BlcmF0aW9uczEnMCUGA1UECxMe
// SIG // blNoaWVsZCBUU1MgRVNOOjM3MDMtMDVFMC1EOTQ3MSUw
// SIG // IwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBTZXJ2
// SIG // aWNloIIR7TCCByAwggUIoAMCAQICEzMAAAHqmiRy1Vk/
// SIG // YWMAAQAAAeowDQYJKoZIhvcNAQELBQAwfDELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBIDIwMTAwHhcNMjMxMjA2MTg0NTMw
// SIG // WhcNMjUwMzA1MTg0NTMwWjCByzELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjElMCMGA1UECxMcTWljcm9zb2Z0IEFtZXJpY2Eg
// SIG // T3BlcmF0aW9uczEnMCUGA1UECxMeblNoaWVsZCBUU1Mg
// SIG // RVNOOjM3MDMtMDVFMC1EOTQ3MSUwIwYDVQQDExxNaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNlMIICIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAtQtf8Ug/IAfV
// SIG // +y7naKNq1m9pLKmheuULSZG0KZrHOhuG4OTDr+lj/7ie
// SIG // Fzibyl/3NbdHo+KFganRg+lW411+E9Cn8pU7pa8yrYMZ
// SIG // 8WYe6tbg9A8v8ORtAyQz2+qMUK8+rzFdmd8vWcY32agZ
// SIG // w36hqJ/+FQx52YXWrNtrL0guRh8sLENifdDDOy+HnGPE
// SIG // 5yyPOZF101REm9PbcS9rRzGKwfihwstPHbN+mp+yHDhn
// SIG // 0ZoR2xaD2uaJvWBqVSkvMXk+xAMFu1m1y/5aOafSkUSI
// SIG // wJbAQRw9U3RgbnKxgt00F0k6fbOw45L7zRblGtASrM+l
// SIG // Igi8SRkEmYXdojiUxHydX8WJNp2OkgirFflZrVeWoj82
// SIG // P7FqBWOeNvs86wD6+Hpa76/bgenIvynIv/xDhEWRFEwT
// SIG // 1zBP4mvrfI609st7oNeTEglboTrDa5rmRcGkQq0RA9Ms
// SIG // +FfcJTExhyCVueYjTNxz1SSdfbzkr6wj/ZbBHBMFmSEN
// SIG // RQsjzp5DNX7O/PNHWoQGuVJj6jJOVhCscwz1adPNV+UU
// SIG // OhxlVM+mXYENI3E+fRBvgigz0Q+psfKL8yKUv6/8BBzy
// SIG // reZDoWK48kB13PShyk1n16QFY9UsqreV+J6/jKXrm7/j
// SIG // fz40BD69ImCQ40sya6iC4QbOacrW+r8kfB1FTKfpgAOK
// SIG // 14zsONr5B30CAwEAAaOCAUkwggFFMB0GA1UdDgQWBBQr
// SIG // gUUlolHm6RdAVNTEyHKLBW5ZXjAfBgNVHSMEGDAWgBSf
// SIG // pxVdAF5iXYP05dJlpxtTNRnpcjBfBgNVHR8EWDBWMFSg
// SIG // UqBQhk5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtp
// SIG // b3BzL2NybC9NaWNyb3NvZnQlMjBUaW1lLVN0YW1wJTIw
// SIG // UENBJTIwMjAxMCgxKS5jcmwwbAYIKwYBBQUHAQEEYDBe
// SIG // MFwGCCsGAQUFBzAChlBodHRwOi8vd3d3Lm1pY3Jvc29m
// SIG // dC5jb20vcGtpb3BzL2NlcnRzL01pY3Jvc29mdCUyMFRp
// SIG // bWUtU3RhbXAlMjBQQ0ElMjAyMDEwKDEpLmNydDAMBgNV
// SIG // HRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMI
// SIG // MA4GA1UdDwEB/wQEAwIHgDANBgkqhkiG9w0BAQsFAAOC
// SIG // AgEAKIOtVl4/fv58VW19xt+yoL8qDQJ7rtsNx6FmY9x9
// SIG // GAnkN2/SkmU4VU4VuIhXB6yp4RTAW1yV+LkCOd5Dlkml
// SIG // gmld8Qs56Ubd3OP4Ep93bzv9Rj9zCZKSX4KOegoEvcyz
// SIG // oj99ZH5qVHT6npGW+IrzEei6D2+RzZatFmwacxW7bE4z
// SIG // a08n6qnKgMHOq/fQ39lEE6g2tL88KQPAsYgINipWz8jM
// SIG // ATj3K/YSU/LBqV/2YSw4ddXWXG1AM1x6NUSaK0kn7VWv
// SIG // YS1p88RsxBmnz1MC5qBE4oThi6iEJQqb6/eB4mpNBqtM
// SIG // GOpXblEI5P5cWeBMwMP3BjHpPCd0HYjUvLvbo2IdQezS
// SIG // 6+rdyIJX0nA1d23VVnrdYrU1KClUSyIr0Q8AE+3UR9dw
// SIG // qt9o9iRuQWLv14rURPHHc2iZg1Qc2IZT5fUF7wvuqkfC
// SIG // OjSDf/fdeG06v0uIOhReH9XYsVMROKpX1DzIsRq9BbeP
// SIG // 0tD+H8JobPlh0Z+tjweI98wh4sSiQrEZ/SEdxMQUCkHT
// SIG // IuWroqgesUAQA1H/he4UimX2wPLBUha3i0qob4/qlEBf
// SIG // ODXMbmsaWyVlabDtfCC+EG7eOQs/0DGuxJjBjZ+2vDDN
// SIG // 7k0DpUMtLunP46tddYtSajI2sk3HkGTTATDORDHOQ6+Z
// SIG // t0+Gw4/VkzS4D/EhXtxKk2llTDkwggdxMIIFWaADAgEC
// SIG // AhMzAAAAFcXna54Cm0mZAAAAAAAVMA0GCSqGSIb3DQEB
// SIG // CwUAMIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQD
// SIG // EylNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRo
// SIG // b3JpdHkgMjAxMDAeFw0yMTA5MzAxODIyMjVaFw0zMDA5
// SIG // MzAxODMyMjVaMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQI
// SIG // EwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w
// SIG // HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAk
// SIG // BgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAy
// SIG // MDEwMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKC
// SIG // AgEA5OGmTOe0ciELeaLL1yR5vQ7VgtP97pwHB9KpbE51
// SIG // yMo1V/YBf2xK4OK9uT4XYDP/XE/HZveVU3Fa4n5KWv64
// SIG // NmeFRiMMtY0Tz3cywBAY6GB9alKDRLemjkZrBxTzxXb1
// SIG // hlDcwUTIcVxRMTegCjhuje3XD9gmU3w5YQJ6xKr9cmmv
// SIG // Haus9ja+NSZk2pg7uhp7M62AW36MEBydUv626GIl3GoP
// SIG // z130/o5Tz9bshVZN7928jaTjkY+yOSxRnOlwaQ3KNi1w
// SIG // jjHINSi947SHJMPgyY9+tVSP3PoFVZhtaDuaRr3tpK56
// SIG // KTesy+uDRedGbsoy1cCGMFxPLOJiss254o2I5JasAUq7
// SIG // vnGpF1tnYN74kpEeHT39IM9zfUGaRnXNxF803RKJ1v2l
// SIG // IH1+/NmeRd+2ci/bfV+AutuqfjbsNkz2K26oElHovwUD
// SIG // o9Fzpk03dJQcNIIP8BDyt0cY7afomXw/TNuvXsLz1dhz
// SIG // PUNOwTM5TI4CvEJoLhDqhFFG4tG9ahhaYQFzymeiXtco
// SIG // dgLiMxhy16cg8ML6EgrXY28MyTZki1ugpoMhXV8wdJGU
// SIG // lNi5UPkLiWHzNgY1GIRH29wb0f2y1BzFa/ZcUlFdEtsl
// SIG // uq9QBXpsxREdcu+N+VLEhReTwDwV2xo3xwgVGD94q0W2
// SIG // 9R6HXtqPnhZyacaue7e3PmriLq0CAwEAAaOCAd0wggHZ
// SIG // MBIGCSsGAQQBgjcVAQQFAgMBAAEwIwYJKwYBBAGCNxUC
// SIG // BBYEFCqnUv5kxJq+gpE8RjUpzxD/LwTuMB0GA1UdDgQW
// SIG // BBSfpxVdAF5iXYP05dJlpxtTNRnpcjBcBgNVHSAEVTBT
// SIG // MFEGDCsGAQQBgjdMg30BATBBMD8GCCsGAQUFBwIBFjNo
// SIG // dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL0Rv
// SIG // Y3MvUmVwb3NpdG9yeS5odG0wEwYDVR0lBAwwCgYIKwYB
// SIG // BQUHAwgwGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // CwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHwYD
// SIG // VR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb186aGMQwVgYD
// SIG // VR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljUm9vQ2Vy
// SIG // QXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsGAQUFBwEBBE4w
// SIG // TDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXRfMjAx
// SIG // MC0wNi0yMy5jcnQwDQYJKoZIhvcNAQELBQADggIBAJ1V
// SIG // ffwqreEsH2cBMSRb4Z5yS/ypb+pcFLY+TkdkeLEGk5c9
// SIG // MTO1OdfCcTY/2mRsfNB1OW27DzHkwo/7bNGhlBgi7ulm
// SIG // ZzpTTd2YurYeeNg2LpypglYAA7AFvonoaeC6Ce5732pv
// SIG // vinLbtg/SHUB2RjebYIM9W0jVOR4U3UkV7ndn/OOPcbz
// SIG // aN9l9qRWqveVtihVJ9AkvUCgvxm2EhIRXT0n4ECWOKz3
// SIG // +SmJw7wXsFSFQrP8DJ6LGYnn8AtqgcKBGUIZUnWKNsId
// SIG // w2FzLixre24/LAl4FOmRsqlb30mjdAy87JGA0j3mSj5m
// SIG // O0+7hvoyGtmW9I/2kQH2zsZ0/fZMcm8Qq3UwxTSwethQ
// SIG // /gpY3UA8x1RtnWN0SCyxTkctwRQEcb9k+SS+c23Kjgm9
// SIG // swFXSVRk2XPXfx5bRAGOWhmRaw2fpCjcZxkoJLo4S5pu
// SIG // +yFUa2pFEUep8beuyOiJXk+d0tBMdrVXVAmxaQFEfnyh
// SIG // YWxz/gq77EFmPWn9y8FBSX5+k77L+DvktxW/tM4+pTFR
// SIG // hLy/AsGConsXHRWJjXD+57XQKBqJC4822rpM+Zv/Cuk0
// SIG // +CQ1ZyvgDbjmjJnW4SLq8CdCPSWU5nR0W2rRnj7tfqAx
// SIG // M328y+l7vzhwRNGQ8cirOoo6CGJ/2XBjU02N7oJtpQUQ
// SIG // wXEGahC0HVUzWLOhcGbyoYIDUDCCAjgCAQEwgfmhgdGk
// SIG // gc4wgcsxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJTAjBgNVBAsT
// SIG // HE1pY3Jvc29mdCBBbWVyaWNhIE9wZXJhdGlvbnMxJzAl
// SIG // BgNVBAsTHm5TaGllbGQgVFNTIEVTTjozNzAzLTA1RTAt
// SIG // RDk0NzElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3Rh
// SIG // bXAgU2VydmljZaIjCgEBMAcGBSsOAwIaAxUAidse3EH4
// SIG // 6UbJCfFBiHLTgpJhJI+ggYMwgYCkfjB8MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0EgMjAxMDANBgkqhkiG9w0BAQsFAAIF
// SIG // AOqTe9UwIhgPMjAyNDA5MTcwMzUzNTdaGA8yMDI0MDkx
// SIG // ODAzNTM1N1owdzA9BgorBgEEAYRZCgQBMS8wLTAKAgUA
// SIG // 6pN71QIBADAKAgEAAgIOzgIB/zAHAgEAAgIU7TAKAgUA
// SIG // 6pTNVQIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgorBgEE
// SIG // AYRZCgMCoAowCAIBAAIDB6EgoQowCAIBAAIDAYagMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAi4jhkjWlXBj0I46EAAS70
// SIG // On3y9YZUjZ4tcd2ZhR/ZwPTfIBThXe5C85+RwJwHCOzh
// SIG // 0i2qRy18N6ribI+12zD/bwfmX+m2zQl3067+49ffrgpR
// SIG // bS688XVPQkS0d+HXbJhpqJoemoqLOfAdpIniW3mcdplu
// SIG // lVnClwSbk9nV48MVKGaJehhsPFkgo4n3B0TShmn27Q6P
// SIG // kDuqzMH/pfAQylc3vzJix5LAnkkfnAIfB4Po+0lbCJMx
// SIG // SSBaXiFl04Vx82kO2ha2Y/aDNndUP3jPnZccMqKR24hq
// SIG // mWIdBsJP6aOJqJh7oKPU6QQch0Dy79AyxQQwse5UPY8Y
// SIG // OA/nQQjC1rlyMYIEDTCCBAkCAQEwgZMwfDELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBIDIwMTACEzMAAAHqmiRy1Vk/YWMA
// SIG // AQAAAeowDQYJYIZIAWUDBAIBBQCgggFKMBoGCSqGSIb3
// SIG // DQEJAzENBgsqhkiG9w0BCRABBDAvBgkqhkiG9w0BCQQx
// SIG // IgQgPnUittDiu2r+sMRVa/3Mw4e1WIVf4AiN8W2ju7EY
// SIG // hXcwgfoGCyqGSIb3DQEJEAIvMYHqMIHnMIHkMIG9BCAp
// SIG // j6HV42Q0eIsINJbSwDVwYeRtbiqiiL6vLIynpLhmeDCB
// SIG // mDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNV
// SIG // BAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEw
// SIG // AhMzAAAB6pokctVZP2FjAAEAAAHqMCIEIOxfLAQu9j8p
// SIG // 5ZmJq/W4zhEUWemairwwYwLhiI1i894/MA0GCSqGSIb3
// SIG // DQEBCwUABIICAFi3L4/rd8osCNz5f+oAly53fOZRivbD
// SIG // z39fX+IGwKvHB/4befU8SRFlBlxn5VHyPIE7Z2zEoczs
// SIG // quiOK3kV8pb3qdjL8OPf4FJ21BZW3EKOnz5Y0obqw6wi
// SIG // kxJXyRIyDtoV4HzmfhJ1k43R+NOJOBKaq6rKeOMA3qPR
// SIG // xlotbwcBsmoxtsRkCZU9t5mo+Tjep1qngf7CBOSHVEBB
// SIG // zBDpuVQCPeu9F1wzYaD8w9s59sRTomeTAbvgwH3G0R3T
// SIG // 6N8vKI8Tnqqm2oHDc2sH9vSExadbhIf78gvQi9w7tsEP
// SIG // F5EAjm2O49912NmXjegb3oBSHhaWfsOwGlKeBuwHfpLh
// SIG // o+dInpJ4hOLAVBSZ8nOVj981vcNLq2jn6C++he7/HOrO
// SIG // Pn9afcGBJWrqMoEnf0LnScJP3TpbYmUqwX+Q2H3k9DPO
// SIG // idIUJ6qj6wjcofP9mKKMOfh9LLPBWkoXTtZ6mdzlP/8U
// SIG // uOAo8oIfQY5dvnuafSSYAgV739/17NYr0yzEWoclxLyy
// SIG // IF/QulNPNMVuSj03hvFrLUKDw/CQ5WQ3EC/XbxDG82SB
// SIG // SPRF9NbHbKKQTgibLWb0/SdlJhzDQrd1PglKDO9kB5Jv
// SIG // JuKqTrx4VWseknB6n3wCz1DVXsnUvjYYhwnt+VYkGEwn
// SIG // hZMhClPsaQspz+Faemysq6nv81l+tZbSK0+j
// SIG // End signature block
