# Change Log

## 0.8.0 - 2024-09-16

### Changed

- The bundled version of vcpkg is updated to [version 2024-09-18](https://github.com/microsoft/vcpkg-tool/releases/tag/2024-09-18).
- Remove the menu item that opens the .ioc file in CubeMX and the `vscode-embedded.openWithStm32CubeMx` command.

### Fixed

- Fixed localization issues.

## 0.7.0 - 2023-03-20

### Added

- A new `vcpkg.storageLocation` setting overrides the path to the directory where vcpkg installation files should be stored. The contents of this directory are fully managed by the extension, including potential deletion, so reusing an existing storage location is not recommended. Note that this is not the same as `VCPKG_ROOT`. A `root` directory will be created within this directory to act as the `VCPKG_ROOT`, but additional files will be stored in the directory itself. ([#36](https://github.com/microsoft/vscode-embedded-tools/issues/36), [#37](https://github.com/microsoft/vscode-embedded-tools/issues/37)).
- A new `vcpkg.diagnostics.additionalArguments` setting optionally provides additional arguments to be added to the end of every vcpkg invocation. This can be useful to add diagnostic flags like `--debug`.

### Changed

- The CMake build script for converted STM32CubeIDE projects issues a status message instead of a warning when multiple STM32CubeIDE installations are found.
- Debug configurations for converted STM32CubeIDE projects use more verbose logging by default. This makes ST-Link failures easier to diagnose.
- The bundled version of vcpkg is updated to [version 2023-03-14](https://github.com/microsoft/vcpkg-tool/releases/tag/2023-03-14).

### Fixed

- Converted STM32CubeIDE projects that use parts in the STM32C0 series are correctly detected as using an Arm Cortex-M0+ core instead of causing an error.
- Imported ST projects correctly detect STM32CubeCLT on Mac systems. [#38](https://github.com/microsoft/vscode-embedded-tools/issues/38)

## 0.6.0 - 2023-02-09

### Added

- Restoration of pinned and expanded peripheral view elements from last debug session.
- Imported STM32CubeIDE projects include a `.vs/launch.vs.json` file for use in Visual Studio.
- [vcpkg](https://vcpkg.io/en/index.html) version 2023-01-24 is bundled with the extension and vcpkg commands can be run with the new `vcpkg.run` command. Output is displayed in a new `vcpkg` output channel. vcpkg will be installed on demand the first time the command is run. If workspace folders are open, commands are run with a working directory of the first workspace folder. Note that this functionality is experimental and may be changed in a future version.
- Highlighting of peripheral view elements when values change.
- Projects that use [vcpkg artifacts](https://devblogs.microsoft.com/cppblog/vcpkg-artifacts/) can be activated directly in VS Code.
  - When a project with a `vcpkg-configuration.json` at the root is opened, a statusbar item with a loading icon will appear as vcpkg activation runs. This statusbar item can be clicked to view activation progress. Once activation is complete, the item will change to show a package icon and can be clicked to deactivate the environment, reactivate the environment, view the active configuration or view the vcpkg log.
  - A new `vcpkg.activateOnWorkspaceOpen` command can be used to disable auto-activation of vcpkg environments.
  - `vcpkg-configuration.json` files can be manually activated, deactivated, or reactivated by right clicking the file in the Explorer and selecting the new menu options.
  - New `vcpkg.activate`, `vcpkg.reactivate`, `vcpkg.deactivate` commands activate, reactivate, or deactivate vcpkg environments.

### Changed

- If different linker scripts are specified for C and C++ in an STM32CubeIDE project, the C++ script is now used during project conversion instead of causing an error.
- When both STM32CubeCLT and STM32CubeIDE are installed, STM32CubeCLT is used for converted STM32CubeIDE projects and a CMake warning is no longer issued.
- Whitespace is trimmed in peripheral view search queries.
- Added a category to the available commands. They will now appear as `Embedded Tools: <command>`
- Imported ST projects will use the bundled version of vcpkg by default.

### Fixed

- In converted STM32CubeIDE projects, `-Xlinker` option groups are preserved in the CMake build script.
- Handling of linked files in STM32CubeIDE projects is improved. The `location` attribute on `link` tags in the `.project` file is correctly handled.
- The path to secure gateway libraries manually specifed by linker flags in STM32CubeIDE projects is correctly represented in the CMake build script.
- All files in excluded directories in STM32CubeIDE projects are correctly excluded in the CMake build script ([#30](https://github.com/microsoft/vscode-embedded-tools/issues/30)).
- When pinning a large number of peripheral view elements, the elements now scroll instead of covering up the rest of the view.
- Unknown ThreadX thread states are displayed in hexadecimal instead of breaking the RTOS view ([#33](https://github.com/microsoft/vscode-embedded-tools/issues/33)).
- Unsupported Eclipse macros are removed in CMake build script for imported ST projects ([#34](https://github.com/microsoft/vscode-embedded-tools/issues/34)).

## 0.5.0 - 2022-11-30

### Added

- Message prompt when there are no search results.
- Peripheral view supports toggling between sorting by name or sorting by address.
- Peripheral view supports searching for registers by address.
- Simple project-to-project STM32CubeIDE project dependencies (tested with TrustZone samples) are represented in the CMake build script.
- Added support for STM32CubeCLT to automatic ST tool detection commands and features.

### Changed

- The peripheral view is only displayed when an SVD is available.

### Fixed

- Include and library paths of the form `${workspace_loc:/${ProjName}/<relative path>}` are correctly handled when importing STM32CubeIDE projects ([#27](https://github.com/microsoft/vscode-embedded-tools/issues/27)).
- Source files and directories that were excluded in STM32CubeIDE projects are also excluded from the CMake build script when importing a project ([#29](https://github.com/microsoft/vscode-embedded-tools/issues/29)).
- Pre-build commands from STM32CubeIDE projects are included in the CMake build script.
- Secure TrustZone STM32CubeIDE projects pass `-Wl,--cmse-implib -Wl,--out-implib=<path>` to the linker in the CMake build script.

## 0.4.0 - 2022-10-13

### Added

- Added support for copying and pasting to and from the search bar in the peripheral view.
- All Zephyr objects supported by Zephyr's object tracking system (timers, memory slabs, semaphores, mutexes, stacks, message queues, mailboxes, pipes, and queues) are now supported in the RTOS view. The `CONFIG_TRACING` and `CONFIG_TRACING_OBJECT_TRACKING` options must be enabled at build time for the Zephyr project, and the `CONFIG_MEM_SLAB_TRACE_MAX_UTILIZATION` option can optionally be enabled to provide additional information for memory slabs. Waiting threads are only displayed when `CONFIG_WAITQ_SCALABLE` is disabled.

### Fixed

- Fixed write-only fields to show correct access when inside of write-only registers.
- Converted ST projects respect any additional linker flags set in the ST project configuration.
- ST project conversion now works on MacOS. `code` must be on `PATH`.
- The link flags `-nostartfiles`, `-nodefaultlibs`, and `-nostdlib` are preserved during ST project conversion.
- ST project conversion correctly handles quoted absolute include paths.

## 0.3.0 - 2022-08-31

### Added

- Added support for ARM's `embedded-debug` debug type.

### Changed

- Edited the pinning experience such that on pinning an element, that element is selected.
- ST project conversion verifies that `com.st.stm32cube.ide.mcu.MCUProjectNature` exists as a nature in the `.project` file before starting conversion.

### Fixed

- The RTOS view now supports FreeRTOS versions that do not include `uxTopUsedPriority`.
- Peripheral view search results are now updated when the selected SVD changes.

## 0.2.0 - 2022-08-04

### Added

- The peripheral and RTOS views now work with [Cortex-Debug](https://github.com/Marus/cortex-debug) debug sessions. A recent build of Cortex-Debug that includes [this commit](https://github.com/Marus/cortex-debug/commit/ef59a834be96569859aca8273366296b430e77c0) is required.
- A warning appears when a workspace contains a `vcpkg-configuration.json` file but VS Code is not running in a vcpkg environment.
- Added the `vscode-embedded.convertStProject` command to open projects created in STM32CubeIDE.
- Added the `vscode-embedded.st.gdb`, `vscode-embedded.st.gdbserver`, `vscode-embedded.st.cubeprogrammer`, `vscode-embedded.st.svd`, and `vscode-embedded.st.cubemx` commands for use as [command variables](https://code.visualstudio.com/docs/editor/variables-reference#_command-variables). Each command will return the path to the respective tool from STM32CubeIDE or STM32CubeMX.
- Added an "Open With STM32CubeMX" entry on the Explorer context menu for *.ioc files.
- Support for filtering peripherals by name and description, and registers, clusters, and fields by name in the peripheral view.
- Added description to registers and fields in the peripheral view.

### Changed

- Removed dependency on the [VS Code Serial Monitor extension](https://marketplace.visualstudio.com/items?itemName=ms-vscode.vscode-serial-monitor).

### Fixed

- Accessibility fixes.
- Fixed an issue where the pin icon was overlapping with text.

## 0.1.1 - 2022-06-06

### Added

- Dependency on new [VS Code Serial Monitor extension](https://marketplace.visualstudio.com/items?itemName=ms-vscode.vscode-serial-monitor).
- Icon to pin elements to the top of the Peripheral View.
- Threads from the Zephyr RTOS are displayed in the the RTOS Viewer.
- Add telemetry.json so that when users run `code --telemetry` they can view what telemetry the extension emits.

### Changed

- The extension now supports [Remote Development](https://code.visualstudio.com/docs/remote/remote-overview).
- Pressing Esc or Ctrl now dismisses the error tooltip when editing a peripheral register value.

### Fixed

- Fixed a bug where attempting to edit a peripheral register while the debugger wasn't paused would cause displayed values to become blank.
- Fixed the error message that appears when attempting to write an invalid value to a peripheral register's field. The message now correctly specifies that the value must be binary.

## 0.1.0 - 2022-03-09

Initial Release.
