"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.linuxList=void 0;const child_process_1=require("child_process"),parser_readline_1=require("@serialport/parser-readline");function checkPathOfDevice(e){return/(tty(S|WCH|ACM|USB|AMA|MFD|O|XRUSB)|rfcomm)/.test(e)&&e}function propName(e){return{DEVNAME:"path",ID_VENDOR_ENC:"manufacturer",ID_SERIAL_SHORT:"serialNumber",ID_VENDOR_ID:"vendorId",ID_MODEL_ID:"productId",DEVLINKS:"pnpId"}[e.toUpperCase()]}function decodeHexEscape(e){return e.replace(/\\x([a-fA-F0-9]{2})/g,((e,r)=>String.fromCharCode(parseInt(r,16))))}function propVal(e,r){if("pnpId"===e){const e=r.match(/\/by-id\/([^\s]+)/);return(null==e?void 0:e[1])||void 0}return"manufacturer"===e?decodeHexEscape(r):/^0x/.test(r)?r.substr(2):r}function linuxList(e=child_process_1.spawn){const r=[],o=e("udevadm",["info","-e"]),i=o.stdout.pipe(new parser_readline_1.ReadlineParser);let t=!1,n={path:"",manufacturer:void 0,serialNumber:void 0,pnpId:void 0,locationId:void 0,vendorId:void 0,productId:void 0};return i.on("data",(e=>{const o=e.slice(0,1),i=e.slice(3);if("P"===o)return n={path:"",manufacturer:void 0,serialNumber:void 0,pnpId:void 0,locationId:void 0,vendorId:void 0,productId:void 0},void(t=!1);if(!t)if("N"!==o){if("E"===o){const e=i.match(/^(.+)=(.*)/);if(!e)return;const r=propName(e[1]);if(!r)return;n[r]=propVal(r,e[2])}}else checkPathOfDevice(i)?r.push(n):t=!0})),new Promise(((e,t)=>{o.on("close",(e=>{e&&t(new Error(`Error listing ports udevadm exited with error code: ${e}`))})),o.on("error",t),i.on("error",t),i.on("finish",(()=>e(r)))}))}exports.linuxList=linuxList;
// SIG // Begin signature block
// SIG // MIIoTAYJKoZIhvcNAQcCoIIoPTCCKDkCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // h/rJOhaZ5jmmPylzcBqA7+YdVDgfae/ssxeci59anbOg
// SIG // gg2aMIIGGDCCBACgAwIBAgITMwAAA/O5amS77/ftYwAA
// SIG // AAAD8zANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTI0MDcxNzIxMDIzNFoX
// SIG // DTI1MDkxNTIxMDIzNFowgYgxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xMjAwBgNVBAMTKU1pY3Jvc29mdCAzcmQgUGFydHkg
// SIG // QXBwbGljYXRpb24gQ29tcG9uZW50MIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuJZyYTUkf/jOL2+w
// SIG // jAIr0zGEmBItBJx10kg2rf/QcDw9otBdYY+1vNFvHRLp
// SIG // b+dX89TQCCym3iKdiWku++5n32B38TFMPwXELMs1uidX
// SIG // ucVDzYLhlNhhV63ObPo8it/QCKROgE2XnIzA7gLuD9Z1
// SIG // RHGSg0dHwWz+0PAhXtdz4J2Yt5/+FF28GhJbxZK8ImuM
// SIG // IfPICfu5QxZGVDiNR9ccRDYD/cti5Qon6xzmoQF3GPk2
// SIG // ksnmar/hNI1eUpAavMzRQnlsjG6KCTz7Ehvi0BH0trDu
// SIG // MTazR2TJSYs4le/YddqsS4nD3rMLoDXQ/mgV6hdH8KKL
// SIG // z7r0sGik/8DPKJDTMQIDAQABo4IBgjCCAX4wHwYDVR0l
// SIG // BBgwFgYKKwYBBAGCN0wRAQYIKwYBBQUHAwMwHQYDVR0O
// SIG // BBYEFNUXbIMP3Uc+qArjvLCjbK6HZhMPMFQGA1UdEQRN
// SIG // MEukSTBHMS0wKwYDVQQLEyRNaWNyb3NvZnQgSXJlbGFu
// SIG // ZCBPcGVyYXRpb25zIExpbWl0ZWQxFjAUBgNVBAUTDTIz
// SIG // MTUyMis1MDI1MjEwHwYDVR0jBBgwFoAUSG5k5VAF04Kq
// SIG // Fzc3IrVtqMp1ApUwVAYDVR0fBE0wSzBJoEegRYZDaHR0
// SIG // cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9jcmwv
// SIG // TWljQ29kU2lnUENBMjAxMV8yMDExLTA3LTA4LmNybDBh
// SIG // BggrBgEFBQcBAQRVMFMwUQYIKwYBBQUHMAKGRWh0dHA6
// SIG // Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvY2VydHMv
// SIG // TWljQ29kU2lnUENBMjAxMV8yMDExLTA3LTA4LmNydDAM
// SIG // BgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4ICAQBj
// SIG // RShosExjVPOZfvN7SYQejdgT72k/UwJLhO7lJ4rtVVOm
// SIG // 9f3q3JJl4rlagS4NrBsxOztdtmyvO9XzVqYhK/f6TH5W
// SIG // odTy//tA+lwqHVkuNVJliC0VIUqilEWfonHquZ+BFIin
// SIG // GqQSoWergil0l+tglR5bzb+DeiQOzVM7RNId4wBEHi6B
// SIG // khZXzar5EzqGxOTcJTEUiVoUOkmJ7MIk2NUFNOqUk2j/
// SIG // 3lXnS0ZOqt7f1PYm71cB0/nk8NQEgW2aGTsVgNxY6yvV
// SIG // 4rDk/xqMldsPQ94MyhRjhJQhaUb3HhnkSstjd2EkY44F
// SIG // fVWJVDORv3M+GYoAArZ3eI3xO3m2ypog79lAdSFKcUs0
// SIG // uEwDtW5ADW8Cf3630opFDxn2Utn0UVzFmU3kC+W0wXJl
// SIG // uyDTUyMTNjMRekKpS7ZpCWd4r/XKHMENTM1q63dQVP4q
// SIG // S8IBrW8O5gnrLV2Yz9mphXkI7nALSrfT5BDZ1n1Hsa8E
// SIG // GZ2SVhd5glbyU4egAlNAicjtGtmvkYrsbL0fEKTMNYBN
// SIG // ++OEmzO+ZwAbvOP83ZMX0ZIl66OSLFCfnjVV1ShJbxZ4
// SIG // Ac6W2LU1X9T3XLPMtLBKOhcRkJM8CjSx3tvLRtR9zUx1
// SIG // DWtC0FCkYzKv+fCGr/aquK1tUCM31wBJwQ0gRb9ROLy5
// SIG // sdi4IajET8kwAWbq6wgp9TCCB3owggVioAMCAQICCmEO
// SIG // kNIAAAAAAAMwDQYJKoZIhvcNAQELBQAwgYgxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xMjAwBgNVBAMTKU1pY3Jvc29mdCBS
// SIG // b290IENlcnRpZmljYXRlIEF1dGhvcml0eSAyMDExMB4X
// SIG // DTExMDcwODIwNTkwOVoXDTI2MDcwODIxMDkwOVowfjEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEoMCYGA1UEAxMfTWljcm9z
// SIG // b2Z0IENvZGUgU2lnbmluZyBQQ0EgMjAxMTCCAiIwDQYJ
// SIG // KoZIhvcNAQEBBQADggIPADCCAgoCggIBAKvw+nIQHC6t
// SIG // 2G6qghBNNLrytlghn0IbKmvpWlCquAY4GgRJun/DDB7d
// SIG // N2vGEtgL8DjCmQawyDnVARQxQtOJDXlkh36UYCRsr55J
// SIG // nOloXtLfm1OyCizDr9mpK656Ca/XllnKYBoF6WZ26DJS
// SIG // JhIv56sIUM+zRLdd2MQuA3WraPPLbfM6XKEW9Ea64Dhk
// SIG // rG5kNXimoGMPLdNAk/jj3gcN1Vx5pUkp5w2+oBN3vpQ9
// SIG // 7/vjK1oQH01WKKJ6cuASOrdJXtjt7UORg9l7snuGG9k+
// SIG // sYxd6IlPhBryoS9Z5JA7La4zWMW3Pv4y07MDPbGyr5I4
// SIG // ftKdgCz1TlaRITUlwzluZH9TupwPrRkjhMv0ugOGjfdf
// SIG // 8NBSv4yUh7zAIXQlXxgotswnKDglmDlKNs98sZKuHCOn
// SIG // qWbsYR9q4ShJnV+I4iVd0yFLPlLEtVc/JAPw0XpbL9Uj
// SIG // 43BdD1FGd7P4AOG8rAKCX9vAFbO9G9RVS+c5oQ/pI0m8
// SIG // GLhEfEXkwcNyeuBy5yTfv0aZxe/CHFfbg43sTUkwp6uO
// SIG // 3+xbn6/83bBm4sGXgXvt1u1L50kppxMopqd9Z4DmimJ4
// SIG // X7IvhNdXnFy/dygo8e1twyiPLI9AN0/B4YVEicQJTMXU
// SIG // pUMvdJX3bvh4IFgsE11glZo+TzOE2rCIF96eTvSWsLxG
// SIG // oGyY0uDWiIwLAgMBAAGjggHtMIIB6TAQBgkrBgEEAYI3
// SIG // FQEEAwIBADAdBgNVHQ4EFgQUSG5k5VAF04KqFzc3IrVt
// SIG // qMp1ApUwGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // CwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHwYD
// SIG // VR0jBBgwFoAUci06AjGQQ7kUBU7h6qfHMdEjiTQwWgYD
// SIG // VR0fBFMwUTBPoE2gS4ZJaHR0cDovL2NybC5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljUm9vQ2Vy
// SIG // QXV0MjAxMV8yMDExXzAzXzIyLmNybDBeBggrBgEFBQcB
// SIG // AQRSMFAwTgYIKwYBBQUHMAKGQmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // MjAxMV8yMDExXzAzXzIyLmNydDCBnwYDVR0gBIGXMIGU
// SIG // MIGRBgkrBgEEAYI3LgMwgYMwPwYIKwYBBQUHAgEWM2h0
// SIG // dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvZG9j
// SIG // cy9wcmltYXJ5Y3BzLmh0bTBABggrBgEFBQcCAjA0HjIg
// SIG // HQBMAGUAZwBhAGwAXwBwAG8AbABpAGMAeQBfAHMAdABh
// SIG // AHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOC
// SIG // AgEAZ/KGpZjgVHkaLtPYdGcimwuWEeFjkplCln3SeQyQ
// SIG // wWVfLiw++MNy0W2D/r4/6ArKO79HqaPzadtjvyI1pZdd
// SIG // ZYSQfYtGUFXYDJJ80hpLHPM8QotS0LD9a+M+By4pm+Y9
// SIG // G6XUtR13lDni6WTJRD14eiPzE32mkHSDjfTLJgJGKsKK
// SIG // ELukqQUMm+1o+mgulaAqPyprWEljHwlpblqYluSD9MCP
// SIG // 80Yr3vw70L01724lruWvJ+3Q3fMOr5kol5hNDj0L8giJ
// SIG // 1h/DMhji8MUtzluetEk5CsYKwsatruWy2dsViFFFWDgy
// SIG // cScaf7H0J/jeLDogaZiyWYlobm+nt3TDQAUGpgEqKD6C
// SIG // PxNNZgvAs0314Y9/HG8VfUWnduVAKmWjw11SYobDHWM2
// SIG // l4bf2vP48hahmifhzaWX0O5dY0HjWwechz4GdwbRBrF1
// SIG // HxS+YWG18NzGGwS+30HHDiju3mUv7Jf2oVyW2ADWoUa9
// SIG // WfOXpQlLSBCZgB/QACnFsZulP0V3HjXG0qKin3p6IvpI
// SIG // lR+r+0cjgPWe+L9rt0uX4ut1eBrs6jeZeRhL/9azI2h1
// SIG // 5q/6/IvrC4DqaTuv/DDtBEyO3991bWORPdGdVk5Pv4BX
// SIG // IqF4ETIheu9BCrE/+6jMpF3BoYibV3FWTkhFwELJm3Zb
// SIG // CoBIa/15n8G9bW1qyVJzEw16UM0xghoKMIIaBgIBATCB
// SIG // lTB+MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9N
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQSAyMDExAhMz
// SIG // AAAD87lqZLvv9+1jAAAAAAPzMA0GCWCGSAFlAwQCAQUA
// SIG // oIGuMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
// SIG // CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqG
// SIG // SIb3DQEJBDEiBCBRA5085QFx+R77j9mn5eiqqkJUO/gA
// SIG // I9ZBYTnM1BgssDBCBgorBgEEAYI3AgEMMTQwMqAUgBIA
// SIG // TQBpAGMAcgBvAHMAbwBmAHShGoAYaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBAFNe
// SIG // wyt/642C5a33kuUEBZq91K+/awERTcuiVS4fjL71gTHM
// SIG // XSJVJaT4mJyPiltjuDvM+WFT68iZTi+e+fUTsE+Gwp/Z
// SIG // 171TKA9kLW3hfAUsAe4+QSWN7gW14yZwGcJCCYnklA9m
// SIG // 2FliBP+UhRB+Nc6mGT12HluBDppwhWPE2GS8Ziay4Plj
// SIG // KRiAZSTZbyDCVQAOreGskgnE9slu1VLwAqaJghNPuPTd
// SIG // awiWCt9Qsjb6z3CZKMFcWDxcyiONwDWUy5HjHEDCno1U
// SIG // 0fZhNW19jiGcWunA495WeEEtqdknfq7nzFUS12GDFXRt
// SIG // fmQuOewriiRD95RcCUctKfOqNGm7vJWhgheUMIIXkAYK
// SIG // KwYBBAGCNwMDATGCF4Awghd8BgkqhkiG9w0BBwKgghdt
// SIG // MIIXaQIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBUgYLKoZI
// SIG // hvcNAQkQAQSgggFBBIIBPTCCATkCAQEGCisGAQQBhFkK
// SIG // AwEwMTANBglghkgBZQMEAgEFAAQgBVOZLT8cVXxF0Nit
// SIG // HTCq4eaLbORvyKLTgiGlUkgcxz4CBmbi2xklpRgTMjAy
// SIG // NDA5MTcxNTIzMTkuMzIyWjAEgAIB9KCB0aSBzjCByzEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjElMCMGA1UECxMcTWljcm9z
// SIG // b2Z0IEFtZXJpY2EgT3BlcmF0aW9uczEnMCUGA1UECxMe
// SIG // blNoaWVsZCBUU1MgRVNOOjkyMDAtMDVFMC1EOTQ3MSUw
// SIG // IwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBTZXJ2
// SIG // aWNloIIR6jCCByAwggUIoAMCAQICEzMAAAHnLo8vkwtP
// SIG // G+kAAQAAAecwDQYJKoZIhvcNAQELBQAwfDELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBIDIwMTAwHhcNMjMxMjA2MTg0NTE5
// SIG // WhcNMjUwMzA1MTg0NTE5WjCByzELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjElMCMGA1UECxMcTWljcm9zb2Z0IEFtZXJpY2Eg
// SIG // T3BlcmF0aW9uczEnMCUGA1UECxMeblNoaWVsZCBUU1Mg
// SIG // RVNOOjkyMDAtMDVFMC1EOTQ3MSUwIwYDVQQDExxNaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNlMIICIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAwlefL+CLkOuf
// SIG // VzzNQ7WljL/fx0VAuZHYhBfPWAT+v0Z+5I6jJGeREnpn
// SIG // +RJYuAi7UFUnn0aRdY+0uSyyorDFjhkWi3GlWxk33JiN
// SIG // bzESdbczMAjSKAqv78vFh/EHVdQfwG+bCvkPciL8xsOO
// SIG // 031zxPEZa2rsCv3vp1p8DLdOtGpBGYiSc9VYdS4UmCmo
// SIG // j/WdtxGZhhEwlooJCm3LgJ4b4d8qzGvPbgX2nh0GRBxk
// SIG // KnbJDOPBAXFklnaYkkgYgMcoR1JG5J5fTz87Qf0lMc0W
// SIG // Y1M1h4PW39ZqmdHCIgFgtBIyuzjYZUHykkR1SyizT6Zd
// SIG // //lC+F43NGL3anPPIDi1K//OE/f8Sua/Nrpb0adgPP2q
// SIG // /XBuFu+udLimgMUQJoC+ISoCF+f9GiALG8qiTmujiBkh
// SIG // fWvg315dS6UDzSke/drHBe7Yw+VqsCLon0vWFIhzL0S4
// SIG // 4ypNEkglf5qVwtAaD5JOWrH8a6yWwrCXjx0jhG5aSc0Z
// SIG // s2j+jjF8EXK2+01xUDrE5CrqpFr72CD71cwuvFDPjLJC
// SIG // z5XdXqnTjjCu0m239rRkmX9/ojsFkDHFlwfYMOYCtwCG
// SIG // CtPFpCSbssz6n4rYLm3UQpmK/QlbDTrlvsBw2BoXIiQx
// SIG // di5K45BVI1HF0iCXfX9rLGIrWfQrqxle+AUHH68Y75NS
// SIG // /I77Te5rpSMCAwEAAaOCAUkwggFFMB0GA1UdDgQWBBTP
// SIG // /uCYgJ82OHaRH/2Za4dSu96PWDAfBgNVHSMEGDAWgBSf
// SIG // pxVdAF5iXYP05dJlpxtTNRnpcjBfBgNVHR8EWDBWMFSg
// SIG // UqBQhk5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtp
// SIG // b3BzL2NybC9NaWNyb3NvZnQlMjBUaW1lLVN0YW1wJTIw
// SIG // UENBJTIwMjAxMCgxKS5jcmwwbAYIKwYBBQUHAQEEYDBe
// SIG // MFwGCCsGAQUFBzAChlBodHRwOi8vd3d3Lm1pY3Jvc29m
// SIG // dC5jb20vcGtpb3BzL2NlcnRzL01pY3Jvc29mdCUyMFRp
// SIG // bWUtU3RhbXAlMjBQQ0ElMjAyMDEwKDEpLmNydDAMBgNV
// SIG // HRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMI
// SIG // MA4GA1UdDwEB/wQEAwIHgDANBgkqhkiG9w0BAQsFAAOC
// SIG // AgEAdKHw25PpZVotXAup7H4nuSbadPaOm+gEQqb7Qz6t
// SIG // ihT/oYvlDTT+yxnIirnJKlwpgUxSIXwXhksb5OsnKJHU
// SIG // K9/NeaRDmmFk5x70NPvISsvOq9ReK3wbuKBweXE8tPE+
// SIG // KIaxvzmBvwf4DZ89Dper+7v6hI8+PM12emZcShsmcCpi
// SIG // mVmgXdg2BMMyqXS5AcbOgOnp1mUdI2PquRXW1eOYIRky
// SIG // oEq+RAgDpyw+J4ycH4yKtJkWVsA2UKF7SUmlR0rtpR0C
// SIG // 92BxBYpLp21EyXzXwQyy+xr/rE5kYg2ZMuTgMaCxtoGk
// SIG // 37ohW36Zknz3IJeQjlM3zEJ86Sn1+vhZCNEEDb7j6VrA
// SIG // 1PLEfrp4tlZg6O65qia6JuIoYFTXS2jHzVKrwS+WYkit
// SIG // c5mhCwSfWvmDoxOaZkmq1ubBm5+4lZBdlvSUCDh+rRli
// SIG // xSUuR7N+s2oZKB4fIg/ety3ho2apBbrCmlFu9sjI/8sU
// SIG // 3hhAzqCK9+ZMF8a9VLvs5Lq9svhbjWNKGY6ac6feQFtZ
// SIG // XoT9MWjvqAVdV372grq/weT1QKdsc66LDBFHAMKSaYqP
// SIG // lWHyLnxo+5nl3BkGFgPFJq/CugLqPiZY/CHhUupUryoa
// SIG // kKZnQcwDBqjzkCrdTsN2V8XoSu7wIopt2YgC5TNCueOp
// SIG // NLGa8XWT4KZs+zvMPYBy7smQEHswggdxMIIFWaADAgEC
// SIG // AhMzAAAAFcXna54Cm0mZAAAAAAAVMA0GCSqGSIb3DQEB
// SIG // CwUAMIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQD
// SIG // EylNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRo
// SIG // b3JpdHkgMjAxMDAeFw0yMTA5MzAxODIyMjVaFw0zMDA5
// SIG // MzAxODMyMjVaMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQI
// SIG // EwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w
// SIG // HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAk
// SIG // BgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAy
// SIG // MDEwMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKC
// SIG // AgEA5OGmTOe0ciELeaLL1yR5vQ7VgtP97pwHB9KpbE51
// SIG // yMo1V/YBf2xK4OK9uT4XYDP/XE/HZveVU3Fa4n5KWv64
// SIG // NmeFRiMMtY0Tz3cywBAY6GB9alKDRLemjkZrBxTzxXb1
// SIG // hlDcwUTIcVxRMTegCjhuje3XD9gmU3w5YQJ6xKr9cmmv
// SIG // Haus9ja+NSZk2pg7uhp7M62AW36MEBydUv626GIl3GoP
// SIG // z130/o5Tz9bshVZN7928jaTjkY+yOSxRnOlwaQ3KNi1w
// SIG // jjHINSi947SHJMPgyY9+tVSP3PoFVZhtaDuaRr3tpK56
// SIG // KTesy+uDRedGbsoy1cCGMFxPLOJiss254o2I5JasAUq7
// SIG // vnGpF1tnYN74kpEeHT39IM9zfUGaRnXNxF803RKJ1v2l
// SIG // IH1+/NmeRd+2ci/bfV+AutuqfjbsNkz2K26oElHovwUD
// SIG // o9Fzpk03dJQcNIIP8BDyt0cY7afomXw/TNuvXsLz1dhz
// SIG // PUNOwTM5TI4CvEJoLhDqhFFG4tG9ahhaYQFzymeiXtco
// SIG // dgLiMxhy16cg8ML6EgrXY28MyTZki1ugpoMhXV8wdJGU
// SIG // lNi5UPkLiWHzNgY1GIRH29wb0f2y1BzFa/ZcUlFdEtsl
// SIG // uq9QBXpsxREdcu+N+VLEhReTwDwV2xo3xwgVGD94q0W2
// SIG // 9R6HXtqPnhZyacaue7e3PmriLq0CAwEAAaOCAd0wggHZ
// SIG // MBIGCSsGAQQBgjcVAQQFAgMBAAEwIwYJKwYBBAGCNxUC
// SIG // BBYEFCqnUv5kxJq+gpE8RjUpzxD/LwTuMB0GA1UdDgQW
// SIG // BBSfpxVdAF5iXYP05dJlpxtTNRnpcjBcBgNVHSAEVTBT
// SIG // MFEGDCsGAQQBgjdMg30BATBBMD8GCCsGAQUFBwIBFjNo
// SIG // dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL0Rv
// SIG // Y3MvUmVwb3NpdG9yeS5odG0wEwYDVR0lBAwwCgYIKwYB
// SIG // BQUHAwgwGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // CwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHwYD
// SIG // VR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb186aGMQwVgYD
// SIG // VR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljUm9vQ2Vy
// SIG // QXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsGAQUFBwEBBE4w
// SIG // TDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXRfMjAx
// SIG // MC0wNi0yMy5jcnQwDQYJKoZIhvcNAQELBQADggIBAJ1V
// SIG // ffwqreEsH2cBMSRb4Z5yS/ypb+pcFLY+TkdkeLEGk5c9
// SIG // MTO1OdfCcTY/2mRsfNB1OW27DzHkwo/7bNGhlBgi7ulm
// SIG // ZzpTTd2YurYeeNg2LpypglYAA7AFvonoaeC6Ce5732pv
// SIG // vinLbtg/SHUB2RjebYIM9W0jVOR4U3UkV7ndn/OOPcbz
// SIG // aN9l9qRWqveVtihVJ9AkvUCgvxm2EhIRXT0n4ECWOKz3
// SIG // +SmJw7wXsFSFQrP8DJ6LGYnn8AtqgcKBGUIZUnWKNsId
// SIG // w2FzLixre24/LAl4FOmRsqlb30mjdAy87JGA0j3mSj5m
// SIG // O0+7hvoyGtmW9I/2kQH2zsZ0/fZMcm8Qq3UwxTSwethQ
// SIG // /gpY3UA8x1RtnWN0SCyxTkctwRQEcb9k+SS+c23Kjgm9
// SIG // swFXSVRk2XPXfx5bRAGOWhmRaw2fpCjcZxkoJLo4S5pu
// SIG // +yFUa2pFEUep8beuyOiJXk+d0tBMdrVXVAmxaQFEfnyh
// SIG // YWxz/gq77EFmPWn9y8FBSX5+k77L+DvktxW/tM4+pTFR
// SIG // hLy/AsGConsXHRWJjXD+57XQKBqJC4822rpM+Zv/Cuk0
// SIG // +CQ1ZyvgDbjmjJnW4SLq8CdCPSWU5nR0W2rRnj7tfqAx
// SIG // M328y+l7vzhwRNGQ8cirOoo6CGJ/2XBjU02N7oJtpQUQ
// SIG // wXEGahC0HVUzWLOhcGbyoYIDTTCCAjUCAQEwgfmhgdGk
// SIG // gc4wgcsxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJTAjBgNVBAsT
// SIG // HE1pY3Jvc29mdCBBbWVyaWNhIE9wZXJhdGlvbnMxJzAl
// SIG // BgNVBAsTHm5TaGllbGQgVFNTIEVTTjo5MjAwLTA1RTAt
// SIG // RDk0NzElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3Rh
// SIG // bXAgU2VydmljZaIjCgEBMAcGBSsOAwIaAxUAs3IE5xmr
// SIG // EsHv3a7vnD3tTRf78EOggYMwgYCkfjB8MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0EgMjAxMDANBgkqhkiG9w0BAQsFAAIF
// SIG // AOqT8JkwIhgPMjAyNDA5MTcxMjEyMDlaGA8yMDI0MDkx
// SIG // ODEyMTIwOVowdDA6BgorBgEEAYRZCgQBMSwwKjAKAgUA
// SIG // 6pPwmQIBADAHAgEAAgIHXTAHAgEAAgITNTAKAgUA6pVC
// SIG // GQIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZ
// SIG // CgMCoAowCAIBAAIDB6EgoQowCAIBAAIDAYagMA0GCSqG
// SIG // SIb3DQEBCwUAA4IBAQAeXSncG5qdWHZkKGg9PnK8/asZ
// SIG // cz0dsozR8FcF3xeup8pNsuVD1my8v2d9qAonAs0O+5uK
// SIG // SlLv0KNdIgJk1yrCTgG3NhS0mQcyGekRXx2Ok6dPQNHR
// SIG // +WvbNaDPM3ttjMdNR77YIaFnwC5Yh+YPWxrqz05lWpl2
// SIG // mEbFnZZJFSEi+ZQ937MzlCV10A7S89NSXH2KtMa8k1ih
// SIG // cignkFIRZtARchjLRZPvMTrvPiD6IEP3Z6mJ//IuELoP
// SIG // QuojTtAUzTTrsB3TZ40VjaFuX5i9GtzPKlVk1kWsq9nh
// SIG // GH96P/1sHKP0JSyKCfFvMvI8SMBMl4k7x/5derDGlaFr
// SIG // FfJCEd+yMYIEDTCCBAkCAQEwgZMwfDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUt
// SIG // U3RhbXAgUENBIDIwMTACEzMAAAHnLo8vkwtPG+kAAQAA
// SIG // AecwDQYJYIZIAWUDBAIBBQCgggFKMBoGCSqGSIb3DQEJ
// SIG // AzENBgsqhkiG9w0BCRABBDAvBgkqhkiG9w0BCQQxIgQg
// SIG // 40w6h73AJukSbgGZQJlvva6PFm/RLh3aFfs4gZc2lyAw
// SIG // gfoGCyqGSIb3DQEJEAIvMYHqMIHnMIHkMIG9BCDlNl0N
// SIG // dmqG/Q3gxVzPVBR3hF++Bb9AAb0DBu6gudZzrTCBmDCB
// SIG // gKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMT
// SIG // HU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMz
// SIG // AAAB5y6PL5MLTxvpAAEAAAHnMCIEIJm9J4hJWcPLi41r
// SIG // cDlbP3MdjdtUwrAv7nydwFFUPN6SMA0GCSqGSIb3DQEB
// SIG // CwUABIICAA90xFbbroHEypiKiAuJsruN3HifBWNOYM/1
// SIG // mbkwMJ8RTYJFAPcjsurXrqi+kGNgBNSzJqdblRci0WAg
// SIG // +HozouOaGfhYYm8EHG/Zab46POFoLH60XsEhv3AqqiKt
// SIG // MuwYysop4z1DdAySNvMLN34hGLP+WmqNfieSXHq4dpOc
// SIG // mOortOtV3unIxgeNnYsKJF73Uo/a98N813wyhJ/NsD4V
// SIG // 1NcLjYHjLJ+uIUHtAmgd2TOnqevVqRtSKJMQ+wVBNbqR
// SIG // YF0Hqnh0gyeB+TBJbNAd1zZWAi6YRYM1y5lFekdHHmYo
// SIG // fcSVflp6N/3UzSDAchJ+284T1mU2arRzzmsvgi/3P+5Y
// SIG // VWPeDFjOGAmxH6Q4jm9TO4wSBrOROjTJCORo5RZddtr/
// SIG // eAkmN+Ym7GjXV4UIlzWrJoG3UyfrLz8eFL+gUVW4Z+oR
// SIG // DcDNr+ukFAa0SLpyZseRVzKYeOQGPBw+/EFhptKZQmeu
// SIG // F9M5SQF54wPeCMCm9sLojm5DFJ8dQt92+SbcUZlbm9P8
// SIG // F4l4a20knPX9EqXfPbLQWDRMXl3HkwjXVna5LDQmEjqP
// SIG // z0pNzGKGsQ8krK4Ane7ljMU/z5dN/+IYRMTG2xiwJQBv
// SIG // vV5vyKm3pxtW+p9bHHiqJapFaHhleU3OJVsyeTolVTes
// SIG // JBJtUbzRI9qrBKN60jg7Q5WiMf6MKdHT
// SIG // End signature block
