#!/bin/sh
PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin
NEWUSER=${PAM_USER}

if grep -q "${NEWUSER}" /etc/subuid; then
    echo "User con0fig ${NEWUSER} already present"
    exit 0;
elif [ "${NEWUSER}" != "root" ]; then
    NEXTUID=$(awk -F ':'  'BEGIN {max = 100000} {if ($2>max) max=$2} END {print (max+$3)}' /etc/subuid)
    usermod -v ${NEXTUID}-$((NEXTUID+65536)) -w  ${NEXTUID}-$((NEXTUID+65536)) ${NEWUSER}
    echo "Set UID/GID (${NEXTUID}) for User ${NEWUSER}"
fi

podman system migrate

exit 0
